// ThreeWebGL.js r42 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(b){this.setHex(b)};
THREE.Color.prototype={copy:function(b){this.r=b.r;this.g=b.g;this.b=b.b;this.hex=b.hex},setHex:function(b){this.hex=~~b&16777215;this.updateRGB()},setRGB:function(b,d,e){this.r=b;this.g=d;this.b=e;this.updateHex()},setHSV:function(b,d,e){var f,g,i,h,j,k;if(e==0)f=g=i=0;else switch(h=Math.floor(b*6),j=b*6-h,b=e*(1-d),k=e*(1-d*j),d=e*(1-d*(1-j)),h){case 1:f=k;g=e;i=b;break;case 2:f=b;g=e;i=d;break;case 3:f=b;g=k;i=e;break;case 4:f=d;g=b;i=e;break;case 5:f=e;g=b;i=k;break;case 6:case 0:f=e,g=d,i=b}this.setRGB(f,
g,i)},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(b,d){this.set(b||0,d||0)};
THREE.Vector2.prototype={set:function(b,d){this.x=b;this.y=d;return this},copy:function(b){this.x=b.x;this.y=b.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(b,d){this.x=b.x+d.x;this.y=b.y+d.y;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;return this},sub:function(b,d){this.x=b.x-d.x;this.y=b.y-d.y;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;return this},divideScalar:function(b){b?
(this.x/=b,this.y/=b):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){var d=this.x-b.x,b=this.y-b.y;return d*d+b*b},setLength:function(b){return this.normalize().multiplyScalar(b)},
unit:function(){return this.normalize()},equals:function(b){return b.x==this.x&&b.y==this.y}};THREE.Vector3=function(b,d,e){this.set(b||0,d||0,e||0)};
THREE.Vector3.prototype={set:function(b,d,e){this.x=b;this.y=d;this.z=e;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(b,d){this.x=b.x+d.x;this.y=b.y+d.y;this.z=b.z+d.z;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;return this},addScalar:function(b){this.x+=b;this.y+=b;this.z+=b;return this},sub:function(b,d){this.x=b.x-d.x;this.y=b.y-d.y;this.z=b.z-d.z;return this},subSelf:function(b){this.x-=
b.x;this.y-=b.y;this.z-=b.z;return this},multiply:function(b,d){this.x=b.x*d.x;this.y=b.y*d.y;this.z=b.z*d.z;return this},multiplySelf:function(b){this.x*=b.x;this.y*=b.y;this.z*=b.y;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;return this},divideSelf:function(b){return this.divide(this,b)},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*
b.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},cross:function(b,d){this.x=b.y*d.z-b.z*d.y;this.y=b.z*d.x-b.x*d.z;this.z=b.x*d.y-b.y*d.x;return this},crossSelf:function(b){return this.set(this.y*b.z-this.z*b.y,this.z*b.x-this.x*b.z,this.x*
b.y-this.y*b.x)},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){return(new THREE.Vector3).sub(this,b).lengthSq()},setPositionFromMatrix:function(b){this.x=b.n14;this.y=b.n24;this.z=b.n34},setRotationFromMatrix:function(b){var d=Math.cos(this.y);this.y=Math.asin(b.n13);Math.abs(d)>1.0E-5?(this.x=Math.atan2(-b.n23/d,b.n33/d),this.z=Math.atan2(-b.n12/d,b.n11/d)):(this.x=0,this.z=Math.atan2(b.n21,b.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};
THREE.Vector4=function(b,d,e,f){this.set(b||0,d||0,e||0,f||1)};
THREE.Vector4.prototype={set:function(b,d,e,f){this.x=b;this.y=d;this.z=e;this.w=f;return this},copy:function(b){return this.set(b.x,b.y,b.z,b.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(b,d){this.x=b.x+d.x;this.y=b.y+d.y;this.z=b.z+d.z;this.w=b.w+d.w;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;this.w+=b.w;return this},sub:function(b,d){this.x=b.x-d.x;this.y=b.y-d.y;this.z=b.z-d.z;this.w=b.w-d.w;return this},subSelf:function(b){this.x-=
b.x;this.y-=b.y;this.z-=b.z;this.w-=b.w;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;this.w*=b;return this},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b,this.w/=b):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z+this.w*b.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(b){return this.normalize().multiplyScalar(b)},lerpSelf:function(b,d){this.x+=(b.x-this.x)*d;this.y+=(b.y-this.y)*d;this.z+=(b.z-this.z)*d;this.w+=(b.w-this.w)*d;return this}};THREE.Ray=function(b,d){this.origin=b||new THREE.Vector3;this.direction=d||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(b){return this.intersectObjects(b.objects)},intersectObjects:function(b){var d,e,f=[];d=0;for(e=b.length;d<e;d++)f=f.concat(this.intersectObject(b[d]));f.sort(function(b,d){return b.distance-d.distance});return f},intersectObject:function(b){function d(b,d,e){var f,e=e.matrixWorld.getPosition();f=e.clone().subSelf(b).dot(d);b=b.clone().addSelf(d.clone().multiplyScalar(f));return e.distanceTo(b)}function e(b,d,e,f){var f=f.clone().subSelf(d),e=e.clone().subSelf(d),
g=b.clone().subSelf(d),b=f.dot(f),d=f.dot(e),f=f.dot(g),h=e.dot(e),e=e.dot(g),g=1/(b*h-d*d),h=(h*f-d*e)*g,b=(b*e-d*f)*g;return h>0&&b>0&&h+b<1}if(b instanceof THREE.Particle){var f=d(this.origin,this.direction,b);if(!f||f>b.scale.x)return[];return[{distance:f,point:b.position,face:null,object:b}]}else if(b instanceof THREE.Mesh){f=d(this.origin,this.direction,b);if(!f||f>b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)))return[];var g,i,h,j,k,o,q,n,t,u,z=b.geometry,
D=z.vertices,E=[],f=0;for(g=z.faces.length;f<g;f++)if(i=z.faces[f],t=this.origin.clone(),u=this.direction.clone(),o=b.matrixWorld,h=o.multiplyVector3(D[i.a].position.clone()),j=o.multiplyVector3(D[i.b].position.clone()),k=o.multiplyVector3(D[i.c].position.clone()),o=i instanceof THREE.Face4?o.multiplyVector3(D[i.d].position.clone()):null,q=b.matrixRotationWorld.multiplyVector3(i.normal.clone()),n=u.dot(q),b.doubleSided||(b.flipSided?n>0:n<0))if(q=q.dot((new THREE.Vector3).sub(h,t))/n,t=t.addSelf(u.multiplyScalar(q)),
i instanceof THREE.Face3)e(t,h,j,k)&&(i={distance:this.origin.distanceTo(t),point:t,face:i,object:b},E.push(i));else if(i instanceof THREE.Face4&&(e(t,h,j,o)||e(t,j,k,o)))i={distance:this.origin.distanceTo(t),point:t,face:i,object:b},E.push(i);return E}else return[]}};
THREE.Rectangle=function(){function b(){i=f-d;h=g-e}var d,e,f,g,i,h,j=!0;this.getX=function(){return d};this.getY=function(){return e};this.getWidth=function(){return i};this.getHeight=function(){return h};this.getLeft=function(){return d};this.getTop=function(){return e};this.getRight=function(){return f};this.getBottom=function(){return g};this.set=function(h,i,q,n){j=!1;d=h;e=i;f=q;g=n;b()};this.addPoint=function(h,i){j?(j=!1,d=h,e=i,f=h,g=i):(d=d<h?d:h,e=e<i?e:i,f=f>h?f:h,g=g>i?g:i);b()};this.add3Points=
function(h,i,q,n,t,u){j?(j=!1,d=h<q?h<t?h:t:q<t?q:t,e=i<n?i<u?i:u:n<u?n:u,f=h>q?h>t?h:t:q>t?q:t,g=i>n?i>u?i:u:n>u?n:u):(d=h<q?h<t?h<d?h:d:t<d?t:d:q<t?q<d?q:d:t<d?t:d,e=i<n?i<u?i<e?i:e:u<e?u:e:n<u?n<e?n:e:u<e?u:e,f=h>q?h>t?h>f?h:f:t>f?t:f:q>t?q>f?q:f:t>f?t:f,g=i>n?i>u?i>g?i:g:u>g?u:g:n>u?n>g?n:g:u>g?u:g);b()};this.addRectangle=function(h){j?(j=!1,d=h.getLeft(),e=h.getTop(),f=h.getRight(),g=h.getBottom()):(d=d<h.getLeft()?d:h.getLeft(),e=e<h.getTop()?e:h.getTop(),f=f>h.getRight()?f:h.getRight(),g=g>
h.getBottom()?g:h.getBottom());b()};this.inflate=function(h){d-=h;e-=h;f+=h;g+=h;b()};this.minSelf=function(h){d=d>h.getLeft()?d:h.getLeft();e=e>h.getTop()?e:h.getTop();f=f<h.getRight()?f:h.getRight();g=g<h.getBottom()?g:h.getBottom();b()};this.instersects=function(b){return Math.min(f,b.getRight())-Math.max(d,b.getLeft())>=0&&Math.min(g,b.getBottom())-Math.max(e,b.getTop())>=0};this.empty=function(){j=!0;g=f=e=d=0;b()};this.isEmpty=function(){return j}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={transpose:function(){var b,d=this.m;b=d[1];d[1]=d[3];d[3]=b;b=d[2];d[2]=d[6];d[6]=b;b=d[5];d[5]=d[7];d[7]=b;return this},transposeIntoArray:function(b){var d=this.m;b[0]=d[0];b[1]=d[3];b[2]=d[6];b[3]=d[1];b[4]=d[4];b[5]=d[7];b[6]=d[2];b[7]=d[5];b[8]=d[8];return this}};THREE.Matrix4=function(b,d,e,f,g,i,h,j,k,o,q,n,t,u,z,D){this.set(b||1,d||0,e||0,f||0,g||0,i||1,h||0,j||0,k||0,o||0,q||1,n||0,t||0,u||0,z||0,D||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(b,d,e,f,g,i,h,j,k,o,q,n,t,u,z,D){this.n11=b;this.n12=d;this.n13=e;this.n14=f;this.n21=g;this.n22=i;this.n23=h;this.n24=j;this.n31=k;this.n32=o;this.n33=q;this.n34=n;this.n41=t;this.n42=u;this.n43=z;this.n44=D;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(b){this.set(b.n11,b.n12,b.n13,b.n14,b.n21,b.n22,b.n23,b.n24,b.n31,b.n32,b.n33,b.n34,b.n41,b.n42,b.n43,b.n44);return this},lookAt:function(b,d,e){var f=THREE.Matrix4.__v1,
g=THREE.Matrix4.__v2,i=THREE.Matrix4.__v3;i.sub(b,d).normalize();if(i.length()===0)i.z=1;f.cross(e,i).normalize();f.length()===0&&(i.x+=1.0E-4,f.cross(e,i).normalize());g.cross(i,f).normalize();this.n11=f.x;this.n12=g.x;this.n13=i.x;this.n21=f.y;this.n22=g.y;this.n23=i.y;this.n31=f.z;this.n32=g.z;this.n33=i.z;return this},multiplyVector3:function(b){var d=b.x,e=b.y,f=b.z,g=1/(this.n41*d+this.n42*e+this.n43*f+this.n44);b.x=(this.n11*d+this.n12*e+this.n13*f+this.n14)*g;b.y=(this.n21*d+this.n22*e+this.n23*
f+this.n24)*g;b.z=(this.n31*d+this.n32*e+this.n33*f+this.n34)*g;return b},multiplyVector4:function(b){var d=b.x,e=b.y,f=b.z,g=b.w;b.x=this.n11*d+this.n12*e+this.n13*f+this.n14*g;b.y=this.n21*d+this.n22*e+this.n23*f+this.n24*g;b.z=this.n31*d+this.n32*e+this.n33*f+this.n34*g;b.w=this.n41*d+this.n42*e+this.n43*f+this.n44*g;return b},rotateAxis:function(b){var d=b.x,e=b.y,f=b.z;b.x=d*this.n11+e*this.n12+f*this.n13;b.y=d*this.n21+e*this.n22+f*this.n23;b.z=d*this.n31+e*this.n32+f*this.n33;b.normalize();
return b},crossVector:function(b){var d=new THREE.Vector4;d.x=this.n11*b.x+this.n12*b.y+this.n13*b.z+this.n14*b.w;d.y=this.n21*b.x+this.n22*b.y+this.n23*b.z+this.n24*b.w;d.z=this.n31*b.x+this.n32*b.y+this.n33*b.z+this.n34*b.w;d.w=b.w?this.n41*b.x+this.n42*b.y+this.n43*b.z+this.n44*b.w:1;return d},multiply:function(b,d){var e=b.n11,f=b.n12,g=b.n13,i=b.n14,h=b.n21,j=b.n22,k=b.n23,o=b.n24,q=b.n31,n=b.n32,t=b.n33,u=b.n34,z=b.n41,D=b.n42,E=b.n43,C=b.n44,N=d.n11,ea=d.n12,S=d.n13,H=d.n14,y=d.n21,aa=d.n22,
P=d.n23,Q=d.n24,B=d.n31,ua=d.n32,K=d.n33,L=d.n34,c=d.n41,sa=d.n42,la=d.n43,ha=d.n44;this.n11=e*N+f*y+g*B+i*c;this.n12=e*ea+f*aa+g*ua+i*sa;this.n13=e*S+f*P+g*K+i*la;this.n14=e*H+f*Q+g*L+i*ha;this.n21=h*N+j*y+k*B+o*c;this.n22=h*ea+j*aa+k*ua+o*sa;this.n23=h*S+j*P+k*K+o*la;this.n24=h*H+j*Q+k*L+o*ha;this.n31=q*N+n*y+t*B+u*c;this.n32=q*ea+n*aa+t*ua+u*sa;this.n33=q*S+n*P+t*K+u*la;this.n34=q*H+n*Q+t*L+u*ha;this.n41=z*N+D*y+E*B+C*c;this.n42=z*ea+D*aa+E*ua+C*sa;this.n43=z*S+D*P+E*K+C*la;this.n44=z*H+D*Q+E*
L+C*ha;return this},multiplyToArray:function(b,d,e){this.multiply(b,d);e[0]=this.n11;e[1]=this.n21;e[2]=this.n31;e[3]=this.n41;e[4]=this.n12;e[5]=this.n22;e[6]=this.n32;e[7]=this.n42;e[8]=this.n13;e[9]=this.n23;e[10]=this.n33;e[11]=this.n43;e[12]=this.n14;e[13]=this.n24;e[14]=this.n34;e[15]=this.n44;return this},multiplySelf:function(b){this.multiply(this,b);return this},multiplyScalar:function(b){this.n11*=b;this.n12*=b;this.n13*=b;this.n14*=b;this.n21*=b;this.n22*=b;this.n23*=b;this.n24*=b;this.n31*=
b;this.n32*=b;this.n33*=b;this.n34*=b;this.n41*=b;this.n42*=b;this.n43*=b;this.n44*=b;return this},determinant:function(){var b=this.n11,d=this.n12,e=this.n13,f=this.n14,g=this.n21,i=this.n22,h=this.n23,j=this.n24,k=this.n31,o=this.n32,q=this.n33,n=this.n34,t=this.n41,u=this.n42,z=this.n43,D=this.n44;return f*h*o*t-e*j*o*t-f*i*q*t+d*j*q*t+e*i*n*t-d*h*n*t-f*h*k*u+e*j*k*u+f*g*q*u-b*j*q*u-e*g*n*u+b*h*n*u+f*i*k*z-d*j*k*z-f*g*o*z+b*j*o*z+d*g*n*z-b*i*n*z-e*i*k*D+d*h*k*D+e*g*o*D-b*h*o*D-d*g*q*D+b*i*q*D},
transpose:function(){var b;b=this.n21;this.n21=this.n12;this.n12=b;b=this.n31;this.n31=this.n13;this.n13=b;b=this.n32;this.n32=this.n23;this.n23=b;b=this.n41;this.n41=this.n14;this.n14=b;b=this.n42;this.n42=this.n24;this.n24=b;b=this.n43;this.n43=this.n34;this.n43=b;return this},clone:function(){var b=new THREE.Matrix4;b.n11=this.n11;b.n12=this.n12;b.n13=this.n13;b.n14=this.n14;b.n21=this.n21;b.n22=this.n22;b.n23=this.n23;b.n24=this.n24;b.n31=this.n31;b.n32=this.n32;b.n33=this.n33;b.n34=this.n34;
b.n41=this.n41;b.n42=this.n42;b.n43=this.n43;b.n44=this.n44;return b},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(b){b[0]=this.n11;
b[1]=this.n21;b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return b},flattenToArrayOffset:function(b,d){b[d]=this.n11;b[d+1]=this.n21;b[d+2]=this.n31;b[d+3]=this.n41;b[d+4]=this.n12;b[d+5]=this.n22;b[d+6]=this.n32;b[d+7]=this.n42;b[d+8]=this.n13;b[d+9]=this.n23;b[d+10]=this.n33;b[d+11]=this.n43;b[d+12]=this.n14;b[d+13]=this.n24;b[d+14]=this.n34;
b[d+15]=this.n44;return b},setTranslation:function(b,d,e){this.set(1,0,0,b,0,1,0,d,0,0,1,e,0,0,0,1);return this},setScale:function(b,d,e){this.set(b,0,0,0,0,d,0,0,0,0,e,0,0,0,0,1);return this},setRotationX:function(b){var d=Math.cos(b),b=Math.sin(b);this.set(1,0,0,0,0,d,-b,0,0,b,d,0,0,0,0,1);return this},setRotationY:function(b){var d=Math.cos(b),b=Math.sin(b);this.set(d,0,b,0,0,1,0,0,-b,0,d,0,0,0,0,1);return this},setRotationZ:function(b){var d=Math.cos(b),b=Math.sin(b);this.set(d,-b,0,0,b,d,0,0,
0,0,1,0,0,0,0,1);return this},setRotationAxis:function(b,d){var e=Math.cos(d),f=Math.sin(d),g=1-e,i=b.x,h=b.y,j=b.z,k=g*i,o=g*h;this.set(k*i+e,k*h-f*j,k*j+f*h,0,k*h+f*j,o*h+e,o*j-f*i,0,k*j-f*h,o*j+f*i,g*j*j+e,0,0,0,0,1);return this},setPosition:function(b){this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(b,d){var e=b.x,f=b.y,g=b.z,i=Math.cos(e),e=Math.sin(e),h=Math.cos(f),f=Math.sin(f),j=Math.cos(g),g=Math.sin(g);switch(d){case "YXZ":var k=
h*j,o=h*g,q=f*j,n=f*g;this.n11=k+n*e;this.n12=q*e-o;this.n13=i*f;this.n21=i*g;this.n22=i*j;this.n23=-e;this.n31=o*e-q;this.n32=n+k*e;this.n33=i*h;break;case "ZXY":k=h*j;o=h*g;q=f*j;n=f*g;this.n11=k-n*e;this.n12=-i*g;this.n13=q+o*e;this.n21=o+q*e;this.n22=i*j;this.n23=n-k*e;this.n31=-i*f;this.n32=e;this.n33=i*h;break;case "ZYX":k=i*j;o=i*g;q=e*j;n=e*g;this.n11=h*j;this.n12=q*f-o;this.n13=k*f+n;this.n21=h*g;this.n22=n*f+k;this.n23=o*f-q;this.n31=-f;this.n32=e*h;this.n33=i*h;break;case "YZX":k=i*h;o=
i*f;q=e*h;n=e*f;this.n11=h*j;this.n12=n-k*g;this.n13=q*g+o;this.n21=g;this.n22=i*j;this.n23=-e*j;this.n31=-f*j;this.n32=o*g+q;this.n33=k-n*g;break;case "XZY":k=i*h;o=i*f;q=e*h;n=e*f;this.n11=h*j;this.n12=-g;this.n13=f*j;this.n21=k*g+n;this.n22=i*j;this.n23=o*g-q;this.n31=q*g-o;this.n32=e*j;this.n33=n*g+k;break;default:k=i*j,o=i*g,q=e*j,n=e*g,this.n11=h*j,this.n12=-h*g,this.n13=f,this.n21=o+q*f,this.n22=k-n*f,this.n23=-e*h,this.n31=n-k*f,this.n32=q+o*f,this.n33=i*h}return this},setRotationFromQuaternion:function(b){var d=
b.x,e=b.y,f=b.z,g=b.w,i=d+d,h=e+e,j=f+f,b=d*i,k=d*h;d*=j;var o=e*h;e*=j;f*=j;i*=g;h*=g;g*=j;this.n11=1-(o+f);this.n12=k-g;this.n13=d+h;this.n21=k+g;this.n22=1-(b+f);this.n23=e-i;this.n31=d-h;this.n32=e+i;this.n33=1-(b+o);return this},scale:function(b){var d=b.x,e=b.y,b=b.z;this.n11*=d;this.n12*=e;this.n13*=b;this.n21*=d;this.n22*=e;this.n23*=b;this.n31*=d;this.n32*=e;this.n33*=b;this.n41*=d;this.n42*=e;this.n43*=b;return this},extractPosition:function(b){this.n14=b.n14;this.n24=b.n24;this.n34=b.n34},
extractRotation:function(b,d){var e=1/d.x,f=1/d.y,g=1/d.z;this.n11=b.n11*e;this.n21=b.n21*e;this.n31=b.n31*e;this.n12=b.n12*f;this.n22=b.n22*f;this.n32=b.n32*f;this.n13=b.n13*g;this.n23=b.n23*g;this.n33=b.n33*g}};
THREE.Matrix4.makeInvert=function(b,d){var e=b.n11,f=b.n12,g=b.n13,i=b.n14,h=b.n21,j=b.n22,k=b.n23,o=b.n24,q=b.n31,n=b.n32,t=b.n33,u=b.n34,z=b.n41,D=b.n42,E=b.n43,C=b.n44;d===void 0&&(d=new THREE.Matrix4);d.n11=k*u*D-o*t*D+o*n*E-j*u*E-k*n*C+j*t*C;d.n12=i*t*D-g*u*D-i*n*E+f*u*E+g*n*C-f*t*C;d.n13=g*o*D-i*k*D+i*j*E-f*o*E-g*j*C+f*k*C;d.n14=i*k*n-g*o*n-i*j*t+f*o*t+g*j*u-f*k*u;d.n21=o*t*z-k*u*z-o*q*E+h*u*E+k*q*C-h*t*C;d.n22=g*u*z-i*t*z+i*q*E-e*u*E-g*q*C+e*t*C;d.n23=i*k*z-g*o*z-i*h*E+e*o*E+g*h*C-e*k*C;d.n24=
g*o*q-i*k*q+i*h*t-e*o*t-g*h*u+e*k*u;d.n31=j*u*z-o*n*z+o*q*D-h*u*D-j*q*C+h*n*C;d.n32=i*n*z-f*u*z-i*q*D+e*u*D+f*q*C-e*n*C;d.n33=g*o*z-i*j*z+i*h*D-e*o*D-f*h*C+e*j*C;d.n34=i*j*q-f*o*q-i*h*n+e*o*n+f*h*u-e*j*u;d.n41=k*n*z-j*t*z-k*q*D+h*t*D+j*q*E-h*n*E;d.n42=f*t*z-g*n*z+g*q*D-e*t*D-f*q*E+e*n*E;d.n43=g*j*z-f*k*z-g*h*D+e*k*D+f*h*E-e*j*E;d.n44=f*k*q-g*j*q+g*h*n-e*k*n-f*h*t+e*j*t;d.multiplyScalar(1/b.determinant());return d};
THREE.Matrix4.makeInvert3x3=function(b){var d=b.m33,e=d.m,f=b.n33*b.n22-b.n32*b.n23,g=-b.n33*b.n21+b.n31*b.n23,i=b.n32*b.n21-b.n31*b.n22,h=-b.n33*b.n12+b.n32*b.n13,j=b.n33*b.n11-b.n31*b.n13,k=-b.n32*b.n11+b.n31*b.n12,o=b.n23*b.n12-b.n22*b.n13,q=-b.n23*b.n11+b.n21*b.n13,n=b.n22*b.n11-b.n21*b.n12,b=b.n11*f+b.n21*h+b.n31*o;b==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");b=1/b;e[0]=b*f;e[1]=b*g;e[2]=b*i;e[3]=b*h;e[4]=b*j;e[5]=b*k;e[6]=b*o;e[7]=b*q;e[8]=b*n;return d};
THREE.Matrix4.makeFrustum=function(b,d,e,f,g,i){var h;h=new THREE.Matrix4;h.n11=2*g/(d-b);h.n12=0;h.n13=(d+b)/(d-b);h.n14=0;h.n21=0;h.n22=2*g/(f-e);h.n23=(f+e)/(f-e);h.n24=0;h.n31=0;h.n32=0;h.n33=-(i+g)/(i-g);h.n34=-2*i*g/(i-g);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(b,d,e,f){var g,b=e*Math.tan(b*Math.PI/360);g=-b;return THREE.Matrix4.makeFrustum(g*d,b*d,g,b,e,f)};
THREE.Matrix4.makeOrtho=function(b,d,e,f,g,i){var h,j,k,o;h=new THREE.Matrix4;j=d-b;k=e-f;o=i-g;h.n11=2/j;h.n12=0;h.n13=0;h.n14=-((d+b)/j);h.n21=0;h.n22=2/k;h.n23=0;h.n24=-((e+f)/k);h.n31=0;h.n32=0;h.n33=-2/o;h.n34=-((i+g)/o);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;
this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={translate:function(b,d){this.matrix.rotateAxis(d);this.position.addSelf(d.multiplyScalar(b))},translateX:function(b){this.translate(b,this._vector.set(1,0,0))},translateY:function(b){this.translate(b,this._vector.set(0,1,0))},translateZ:function(b){this.translate(b,this._vector.set(0,0,1))},lookAt:function(b){this.matrix.lookAt(b,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(b){if(this.children.indexOf(b)===
-1){b.parent!==void 0&&b.parent.removeChild(b);b.parent=this;this.children.push(b);for(var d=this;d.parent!==void 0;)d=d.parent;d!==void 0&&d instanceof THREE.Scene&&d.addChildRecurse(b)}},removeChild:function(b){var d=this.children.indexOf(b);if(d!==-1)b.parent=void 0,this.children.splice(d,1)},getChildByName:function(b,d){var e,f,g;e=0;for(f=this.children.length;e<f;e++){g=this.children[e];if(g.name===b)return g;if(d&&(g=g.getChildByName(b,d),g!==void 0))return g}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(b,d,e){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||d)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,d=!0;for(var b=0,f=this.children.length;b<f;b++)this.children[b].update(this.matrixWorld,d,e)}};THREE.Quaternion=function(b,d,e,f){this.set(b||0,d||0,e||0,f!==void 0?f:1)};
THREE.Quaternion.prototype={set:function(b,d,e,f){this.x=b;this.y=d;this.z=e;this.w=f;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w;return this},setFromEuler:function(b){var d=0.5*Math.PI/360,e=b.x*d,f=b.y*d,g=b.z*d,b=Math.cos(f),f=Math.sin(f),d=Math.cos(-g),g=Math.sin(-g),i=Math.cos(e),e=Math.sin(e),h=b*d,j=f*g;this.w=h*i-j*e;this.x=h*e+j*i;this.y=f*d*i+b*g*e;this.z=b*g*i-f*d*e;return this},setFromAxisAngle:function(b,d){var e=d/2,f=Math.sin(e);this.x=b.x*f;this.y=b.y*
f;this.z=b.z*f;this.w=Math.cos(e);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var b=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);b==0?this.w=this.z=this.y=this.x=0:(b=1/b,this.x*=b,this.y*=b,this.z*=b,this.w*=b);return this},
multiplySelf:function(b){var d=this.x,e=this.y,f=this.z,g=this.w,i=b.x,h=b.y,j=b.z,b=b.w;this.x=d*b+g*i+e*j-f*h;this.y=e*b+g*h+f*i-d*j;this.z=f*b+g*j+d*h-e*i;this.w=g*b-d*i-e*h-f*j;return this},multiply:function(b,d){this.x=b.x*d.w+b.y*d.z-b.z*d.y+b.w*d.x;this.y=-b.x*d.z+b.y*d.w+b.z*d.x+b.w*d.y;this.z=b.x*d.y-b.y*d.x+b.z*d.w+b.w*d.z;this.w=-b.x*d.x-b.y*d.y-b.z*d.z+b.w*d.w;return this},multiplyVector3:function(b,d){d||(d=b);var e=b.x,f=b.y,g=b.z,i=this.x,h=this.y,j=this.z,k=this.w,o=k*e+h*g-j*f,q=
k*f+j*e-i*g,n=k*g+i*f-h*e,e=-i*e-h*f-j*g;d.x=o*k+e*-i+q*-j-n*-h;d.y=q*k+e*-h+n*-i-o*-j;d.z=n*k+e*-j+o*-h-q*-i;return d}};
THREE.Quaternion.slerp=function(b,d,e,f){var g=b.w*d.w+b.x*d.x+b.y*d.y+b.z*d.z;if(Math.abs(g)>=1)return e.w=b.w,e.x=b.x,e.y=b.y,e.z=b.z,e;var i=Math.acos(g),h=Math.sqrt(1-g*g);if(Math.abs(h)<0.001)return e.w=0.5*(b.w+d.w),e.x=0.5*(b.x+d.x),e.y=0.5*(b.y+d.y),e.z=0.5*(b.z+d.z),e;g=Math.sin((1-f)*i)/h;f=Math.sin(f*i)/h;e.w=b.w*g+d.w*f;e.x=b.x*g+d.x*f;e.y=b.y*g+d.y*f;e.z=b.z*g+d.z*f;return e};THREE.Vertex=function(b){this.position=b||new THREE.Vector3};
THREE.Face3=function(b,d,e,f,g,i){this.a=b;this.b=d;this.c=e;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=i instanceof Array?i:[i];this.centroid=new THREE.Vector3};
THREE.Face4=function(b,d,e,f,g,i,h){this.a=b;this.b=d;this.c=e;this.d=f;this.normal=g instanceof THREE.Vector3?g:new THREE.Vector3;this.vertexNormals=g instanceof Array?g:[];this.color=i instanceof THREE.Color?i:new THREE.Color;this.vertexColors=i instanceof Array?i:[];this.vertexTangents=[];this.materials=h instanceof Array?h:[h];this.centroid=new THREE.Vector3};THREE.UV=function(b,d){this.set(b||0,d||0)};
THREE.UV.prototype={set:function(b,d){this.u=b;this.v=d;return this},copy:function(b){this.set(b.u,b.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var b,d,e;b=0;for(d=this.faces.length;b<d;b++)e=this.faces[b],e.centroid.set(0,0,0),e instanceof THREE.Face3?(e.centroid.addSelf(this.vertices[e.a].position),e.centroid.addSelf(this.vertices[e.b].position),e.centroid.addSelf(this.vertices[e.c].position),e.centroid.divideScalar(3)):e instanceof THREE.Face4&&(e.centroid.addSelf(this.vertices[e.a].position),e.centroid.addSelf(this.vertices[e.b].position),e.centroid.addSelf(this.vertices[e.c].position),
e.centroid.addSelf(this.vertices[e.d].position),e.centroid.divideScalar(4))},computeFaceNormals:function(b){var d,e,f,g,i,h,j=new THREE.Vector3,k=new THREE.Vector3;f=0;for(g=this.faces.length;f<g;f++){i=this.faces[f];if(b&&i.vertexNormals.length){j.set(0,0,0);d=0;for(e=i.vertexNormals.length;d<e;d++)j.addSelf(i.vertexNormals[d]);j.divideScalar(3)}else d=this.vertices[i.a],e=this.vertices[i.b],h=this.vertices[i.c],j.sub(h.position,e.position),k.sub(d.position,e.position),j.crossSelf(k);j.isZero()||
j.normalize();i.normal.copy(j)}},computeVertexNormals:function(){var b,d,e,f;if(this.__tmpVertices==void 0){f=this.__tmpVertices=Array(this.vertices.length);b=0;for(d=this.vertices.length;b<d;b++)f[b]=new THREE.Vector3;b=0;for(d=this.faces.length;b<d;b++)if(e=this.faces[b],e instanceof THREE.Face3)e.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(e instanceof THREE.Face4)e.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{f=
this.__tmpVertices;b=0;for(d=this.vertices.length;b<d;b++)f[b].set(0,0,0)}b=0;for(d=this.faces.length;b<d;b++)e=this.faces[b],e instanceof THREE.Face3?(f[e.a].addSelf(e.normal),f[e.b].addSelf(e.normal),f[e.c].addSelf(e.normal)):e instanceof THREE.Face4&&(f[e.a].addSelf(e.normal),f[e.b].addSelf(e.normal),f[e.c].addSelf(e.normal),f[e.d].addSelf(e.normal));b=0;for(d=this.vertices.length;b<d;b++)f[b].normalize();b=0;for(d=this.faces.length;b<d;b++)e=this.faces[b],e instanceof THREE.Face3?(e.vertexNormals[0].copy(f[e.a]),
e.vertexNormals[1].copy(f[e.b]),e.vertexNormals[2].copy(f[e.c])):e instanceof THREE.Face4&&(e.vertexNormals[0].copy(f[e.a]),e.vertexNormals[1].copy(f[e.b]),e.vertexNormals[2].copy(f[e.c]),e.vertexNormals[3].copy(f[e.d]))},computeTangents:function(){function b(b,c,d,e,f,g,i){j=b.vertices[c].position;k=b.vertices[d].position;o=b.vertices[e].position;q=h[f];n=h[g];t=h[i];u=k.x-j.x;z=o.x-j.x;D=k.y-j.y;E=o.y-j.y;C=k.z-j.z;N=o.z-j.z;ea=n.u-q.u;S=t.u-q.u;H=n.v-q.v;y=t.v-q.v;aa=1/(ea*y-S*H);ua.set((y*u-H*
z)*aa,(y*D-H*E)*aa,(y*C-H*N)*aa);K.set((ea*z-S*u)*aa,(ea*E-S*D)*aa,(ea*N-S*C)*aa);Q[c].addSelf(ua);Q[d].addSelf(ua);Q[e].addSelf(ua);B[c].addSelf(K);B[d].addSelf(K);B[e].addSelf(K)}var d,e,f,g,i,h,j,k,o,q,n,t,u,z,D,E,C,N,ea,S,H,y,aa,P,Q=[],B=[],ua=new THREE.Vector3,K=new THREE.Vector3,L=new THREE.Vector3,c=new THREE.Vector3,sa=new THREE.Vector3;d=0;for(e=this.vertices.length;d<e;d++)Q[d]=new THREE.Vector3,B[d]=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++)i=this.faces[d],h=this.faceVertexUvs[0][d],
i instanceof THREE.Face3?b(this,i.a,i.b,i.c,0,1,2):i instanceof THREE.Face4&&(b(this,i.a,i.b,i.c,0,1,2),b(this,i.a,i.b,i.d,0,1,3));var la=["a","b","c","d"];d=0;for(e=this.faces.length;d<e;d++){i=this.faces[d];for(f=0;f<i.vertexNormals.length;f++)sa.copy(i.vertexNormals[f]),g=i[la[f]],P=Q[g],L.copy(P),L.subSelf(sa.multiplyScalar(sa.dot(P))).normalize(),c.cross(i.vertexNormals[f],P),g=c.dot(B[g]),g=g<0?-1:1,i.vertexTangents[f]=new THREE.Vector4(L.x,L.y,L.z,g)}this.hasTangents=!0},computeBoundingBox:function(){var b;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var d=1,e=this.vertices.length;d<e;d++){b=this.vertices[d];if(b.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=b.position.x;else if(b.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=b.position.x;if(b.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=b.position.y;
else if(b.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=b.position.y;if(b.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=b.position.z;else if(b.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=b.position.z}}},computeBoundingSphere:function(){for(var b=0,d=0,e=this.vertices.length;d<e;d++)b=Math.max(b,this.vertices[d].position.length());this.boundingSphere={radius:b}},computeEdgeFaces:function(){function b(b,d){return Math.min(b,d)+"_"+Math.max(b,d)}function d(b,d,e){b[d]===
void 0?(b[d]={set:{},array:[]},b[d].set[e]=1,b[d].array.push(e)):b[d].set[e]===void 0&&(b[d].set[e]=1,b[d].array.push(e))}var e,f,g,i,h,j={};e=0;for(f=this.faces.length;e<f;e++)h=this.faces[e],h instanceof THREE.Face3?(g=b(h.a,h.b),d(j,g,e),g=b(h.b,h.c),d(j,g,e),g=b(h.a,h.c),d(j,g,e)):h instanceof THREE.Face4&&(g=b(h.b,h.d),d(j,g,e),g=b(h.a,h.b),d(j,g,e),g=b(h.a,h.d),d(j,g,e),g=b(h.b,h.c),d(j,g,e),g=b(h.c,h.d),d(j,g,e));e=0;for(f=this.edges.length;e<f;e++){h=this.edges[e];g=h.vertexIndices[0];i=h.vertexIndices[1];
h.faceIndices=j[b(g,i)].array;for(g=0;g<h.faceIndices.length;g++)i=h.faceIndices[g],h.faces.push(this.faces[i])}}};THREE.GeometryIdCounter=0;
THREE.Spline=function(b){function d(b,d,e,f,g,h,i){b=(e-b)*0.5;f=(f-d)*0.5;return(2*(d-e)+b+f)*i+(-3*(d-e)-2*b-f)*h+b*g+d}this.points=b;var e=[],f={x:0,y:0,z:0},g,i,h,j,k,o,q,n,t;this.initFromArray=function(b){this.points=[];for(var d=0;d<b.length;d++)this.points[d]={x:b[d][0],y:b[d][1],z:b[d][2]}};this.getPoint=function(b){g=(this.points.length-1)*b;i=Math.floor(g);h=g-i;e[0]=i==0?i:i-1;e[1]=i;e[2]=i>this.points.length-2?i:i+1;e[3]=i>this.points.length-3?i:i+2;o=this.points[e[0]];q=this.points[e[1]];
n=this.points[e[2]];t=this.points[e[3]];j=h*h;k=h*j;f.x=d(o.x,q.x,n.x,t.x,h,j,k);f.y=d(o.y,q.y,n.y,t.y,h,j,k);f.z=d(o.z,q.z,n.z,t.z,h,j,k);return f};this.getControlPointsArray=function(){var b,d,e=this.points.length,f=[];for(b=0;b<e;b++)d=this.points[b],f[b]=[d.x,d.y,d.z];return f};this.getLength=function(b){var d,e,f=d=d=0,g=new THREE.Vector3,h=new THREE.Vector3,i=[],j=0;i[0]=0;b||(b=100);e=this.points.length*b;g.copy(this.points[0]);for(b=1;b<e;b++)d=b/e,position=this.getPoint(d),h.copy(position),
j+=h.distanceTo(g),g.copy(position),d*=this.points.length-1,d=Math.floor(d),d!=f&&(i[d]=j,f=d);i[i.length]=j;return{chunks:i,total:j}};this.reparametrizeByArcLength=function(b){var d,e,f,g,h,i,j=[],o=new THREE.Vector3,k=this.getLength();j.push(o.copy(this.points[0]).clone());for(d=1;d<this.points.length;d++){e=k.chunks[d]-k.chunks[d-1];i=Math.ceil(b*e/k.total);g=(d-1)/(this.points.length-1);h=d/(this.points.length-1);for(e=1;e<i-1;e++)f=g+e*(1/i)*(h-g),position=this.getPoint(f),j.push(o.copy(position).clone());
j.push(o.copy(this.points[d]).clone())}this.points=j}};THREE.Edge=function(b,d,e,f){this.vertices=[b,d];this.vertexIndices=[e,f];this.faces=[];this.faceIndices=[]};THREE.Camera=function(b,d,e,f,g){THREE.Object3D.call(this);this.fov=b||50;this.aspect=d||1;this.near=e||0.1;this.far=f||2E3;this.target=g||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;
THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(b,d){this.matrix.rotateAxis(d);d.multiplyScalar(b);this.position.addSelf(d);this.target.position.addSelf(d)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var b=this.fullWidth/this.fullHeight,d=Math.tan(this.fov*Math.PI/360)*this.near,e=-d,f=b*e,b=Math.abs(b*d-f),e=Math.abs(d-e);this.projectionMatrix=THREE.Matrix4.makeFrustum(f+this.x*b/this.fullWidth,f+(this.x+this.width)*b/this.fullWidth,d-(this.y+this.height)*e/this.fullHeight,d-this.y*e/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(b,d,e,f,g,i){this.fullWidth=b;this.fullHeight=d;this.x=e;this.y=f;this.width=g;this.height=i;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(b,d,e){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),d=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),d||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,d=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,d,e)};THREE.Light=function(b){THREE.Object3D.call(this);this.color=new THREE.Color(b)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(b){THREE.Light.call(this,b)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(b,d,e,f){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.intensity=d||1;this.distance=e||0;this.castShadow=f!==void 0?f:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(b,d,e){THREE.Light.call(this,b);this.position=new THREE.Vector3;this.intensity=d||1;this.distance=e||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.LensFlare=function(b,d,e,f){THREE.Object3D.call(this);this.positionScreen=new THREE.Vector3;this.lensFlares=[];this.customUpdateCallback=void 0;b!==void 0&&this.add(b,d,e,f)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;
THREE.LensFlare.prototype.add=function(b,d,e,f){d===void 0&&(d=-1);e===void 0&&(e=0);if(f===void 0)f=THREE.BillboardBlending;e=Math.min(e,Math.max(0,e));this.lensFlares.push({texture:b,size:d,distance:e,x:0,y:0,z:0,scale:1,rotation:1,opacity:1,blending:f})};
THREE.LensFlare.prototype.updateLensFlares=function(){var b,d=this.lensFlares.length,e,f=-this.positionScreen.x*2,g=-this.positionScreen.y*2;for(b=0;b<d;b++)e=this.lensFlares[b],e.x=this.positionScreen.x+f*e.distance,e.y=this.positionScreen.y+g*e.distance,e.wantedRotation=e.x*Math.PI*0.25,e.rotation+=(e.wantedRotation-e.rotation)*0.25};
THREE.Material=function(b){this.id=THREE.MaterialCounter.value++;b=b||{};this.opacity=b.opacity!==void 0?b.opacity:1;this.transparent=b.transparent!==void 0?b.transparent:!1;this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.depthTest=b.depthTest!==void 0?b.depthTest:!0;this.polygonOffset=b.polygonOffset!==void 0?b.polygonOffset:!1;this.polygonOffsetFactor=b.polygonOffsetFactor!==void 0?b.polygonOffsetFactor:0;this.polygonOffsetUnits=b.polygonOffsetUnits!==void 0?b.polygonOffsetUnits:
0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};
THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.LineBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.linewidth=b.linewidth!==void 0?b.linewidth:1;this.linecap=b.linecap!==void 0?b.linecap:"round";this.linejoin=b.linejoin!==void 0?b.linejoin:"round";this.vertexColors=b.vertexColors?b.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;
THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.ambient=b.ambient!==void 0?new THREE.Color(b.ambient):new THREE.Color(328965);this.specular=b.specular!==void 0?new THREE.Color(b.specular):new THREE.Color(1118481);this.shininess=b.shininess!==void 0?b.shininess:30;this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;
this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==
void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading?b.shading:THREE.FlatShading;this.wireframe=b.wireframe?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth?b.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.fragmentShader=b.fragmentShader!==void 0?b.fragmentShader:"void main() {}";this.vertexShader=b.vertexShader!==void 0?b.vertexShader:"void main() {}";this.uniforms=b.uniforms!==void 0?b.uniforms:{};this.attributes=b.attributes;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.fog=
b.fog!==void 0?b.fog:!1;this.lights=b.lights!==void 0?b.lights:!1;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshShaderMaterial.prototype=new THREE.Material;THREE.MeshShaderMaterial.prototype.constructor=THREE.MeshShaderMaterial;
THREE.ParticleBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.size=b.size!==void 0?b.size:1;this.sizeAttenuation=b.sizeAttenuation!==void 0?b.sizeAttenuation:!0;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ShadowVolumeDynamicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.ShadowVolumeDynamicMaterial.prototype=new THREE.Material;THREE.ShadowVolumeDynamicMaterial.prototype.constructor=THREE.ShadowVolumeDynamicMaterial;
THREE.Texture=function(b,d,e,f,g,i){this.image=b;this.mapping=d!==void 0?d:new THREE.UVMapping;this.wrapS=e!==void 0?e:THREE.ClampToEdgeWrapping;this.wrapT=f!==void 0?f:THREE.ClampToEdgeWrapping;this.magFilter=g!==void 0?g:THREE.LinearFilter;this.minFilter=i!==void 0?i:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;
THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.ParticleSystem=function(b,d){THREE.Object3D.call(this);this.geometry=b;this.materials=d instanceof Array?d:[d];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(b,d,e){THREE.Object3D.call(this);this.geometry=b;this.materials=d instanceof Array?d:[d];this.type=e!=void 0?e:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(b,d){THREE.Object3D.call(this);this.geometry=b;this.materials=d&&d.length?d:[d];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=b.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var e=0;e<this.geometry.morphTargets.length;e++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[e].name]=
e}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(b){if(this.morphTargetDictionary[b]!==void 0)return this.morphTargetDictionary[b];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+b+" does not exist. Returning 0.");return 0};
THREE.Bone=function(b){THREE.Object3D.call(this);this.skin=b;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(b,d,e){this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate)b?this.skinMatrix.multiply(b,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,d=!0;var f,g=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(f=0;f<g;f++)b=this.children[f],b instanceof THREE.Bone?b.update(this.skinMatrix,d,e):b.update(this.matrixWorld,!0,e)}else for(f=0;f<g;f++)this.children[f].update(this.skinMatrix,
d,e)};THREE.Bone.prototype.addChild=function(b){if(this.children.indexOf(b)===-1&&(b.parent!==void 0&&b.parent.removeChild(b),b.parent=this,this.children.push(b),!(b instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};
THREE.SkinnedMesh=function(b,d){THREE.Mesh.call(this,b,d);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var e,f,g,i,h,j;if(this.geometry.bones!==void 0){for(e=0;e<this.geometry.bones.length;e++)g=this.geometry.bones[e],i=g.pos,h=g.rotq,j=g.scl,f=this.addBone(),f.name=g.name,f.position.set(i[0],i[1],i[2]),f.quaternion.set(h[0],h[1],h[2],h[3]),f.useQuaternion=!0,j!==void 0?f.scale.set(j[0],j[1],j[2]):f.scale.set(1,1,1);for(e=0;e<this.bones.length;e++)g=this.geometry.bones[e],
f=this.bones[e],g.parent===-1?this.addChild(f):this.bones[g.parent].addChild(f);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(b,d,e){if(this.visible){this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,d=!0;var f,g=this.children.length;for(f=0;f<g;f++)b=this.children[f],b instanceof THREE.Bone?b.update(this.identityMatrix,!1,e):b.update(this.matrixWorld,d,e);e=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(d=0;d<e;d++)ba[d].skinMatrix.flattenToArrayOffset(bm,
d*16)}};THREE.SkinnedMesh.prototype.addBone=function(b){b===void 0&&(b=new THREE.Bone(this));this.bones.push(b);return b};
THREE.SkinnedMesh.prototype.pose=function(){this.update(void 0,!0);for(var b,d=[],e=0;e<this.bones.length;e++)b=this.bones[e],d.push(THREE.Matrix4.makeInvert(b.skinMatrix)),b.skinMatrix.flattenToArrayOffset(this.boneMatrices,e*16);if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var f;for(b=0;b<this.geometry.skinIndices.length;b++){var e=this.geometry.vertices[b].position,g=this.geometry.skinIndices[b].x,i=this.geometry.skinIndices[b].y;f=new THREE.Vector3(e.x,
e.y,e.z);this.geometry.skinVerticesA.push(d[g].multiplyVector3(f));f=new THREE.Vector3(e.x,e.y,e.z);this.geometry.skinVerticesB.push(d[i].multiplyVector3(f));this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y!==1&&(e=(1-(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y))*0.5,this.geometry.skinWeights[b].x+=e,this.geometry.skinWeights[b].y+=e)}}};THREE.Ribbon=function(b,d){THREE.Object3D.call(this);this.geometry=b;this.materials=d instanceof Array?d:[d]};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(b,d){d===void 0&&(d=0);for(var d=Math.abs(d),e=0;e<this.LODs.length;e++)if(d<this.LODs[e].visibleAtDistance)break;this.LODs.splice(e,0,{visibleAtDistance:d,object3D:b});this.addChild(b)};
THREE.LOD.prototype.update=function(b,d,e){this.matrixAutoUpdate&&(d|=this.updateMatrix());if(d||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,d=!0;if(this.LODs.length>1){b=e.matrixWorldInverse;b=-(b.n31*this.position.x+b.n32*this.position.y+b.n33*this.position.z+b.n34);this.LODs[0].object3D.visible=!0;for(var f=1;f<this.LODs.length;f++)if(b>=this.LODs[f].visibleAtDistance)this.LODs[f-1].object3D.visible=!1,
this.LODs[f].object3D.visible=!0;else break;for(;f<this.LODs.length;f++)this.LODs[f].object3D.visible=!1}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,d,e)};THREE.ShadowVolume=function(b,d){b instanceof THREE.Mesh?(THREE.Mesh.call(this,b.geometry,d?[new THREE.ShadowVolumeDynamicMaterial]:[new THREE.ShadowVolumeDynamicMaterial]),b.addChild(this)):THREE.Mesh.call(this,b,d?[new THREE.ShadowVolumeDynamicMaterial]:[new THREE.ShadowVolumeDynamicMaterial]);this.calculateShadowVolumeGeometry()};
THREE.ShadowVolume.prototype=new THREE.Mesh;THREE.ShadowVolume.prototype.constructor=THREE.ShadowVolume;THREE.ShadowVolume.prototype.supr=THREE.Mesh.prototype;
THREE.ShadowVolume.prototype.calculateShadowVolumeGeometry=function(){if(this.geometry.edges&&this.geometry.edges.length){var b,d,e,f,g,i,h,j,k,o,q,n,t,u,z=new THREE.Geometry;z.vertices=this.geometry.vertices;f=z.faces=this.geometry.faces;var D=z.egdes=this.geometry.edges,E=z.edgeFaces=[];g=0;var C=[];b=0;for(d=f.length;b<d;b++)if(e=f[b],C.push(g),g+=e instanceof THREE.Face3?3:4,e.vertexNormals[0]=e.normal,e.vertexNormals[1]=e.normal,e.vertexNormals[2]=e.normal,e instanceof THREE.Face4)e.vertexNormals[3]=
e.normal;b=0;for(d=D.length;b<d;b++)j=D[b],e=j.faces[0],f=j.faces[1],g=j.faceIndices[0],i=j.faceIndices[1],h=j.vertexIndices[0],j=j.vertexIndices[1],e.a===h?(k="a",q=C[g]+0):e.b===h?(k="b",q=C[g]+1):e.c===h?(k="c",q=C[g]+2):e.d===h&&(k="d",q=C[g]+3),e.a===j?(k+="a",n=C[g]+0):e.b===j?(k+="b",n=C[g]+1):e.c===j?(k+="c",n=C[g]+2):e.d===j&&(k+="d",n=C[g]+3),f.a===h?(o="a",t=C[i]+0):f.b===h?(o="b",t=C[i]+1):f.c===h?(o="c",t=C[i]+2):f.d===h&&(o="d",t=C[i]+3),f.a===j?(o+="a",u=C[i]+0):f.b===j?(o+="b",u=C[i]+
1):f.c===j?(o+="c",u=C[i]+2):f.d===j&&(o+="d",u=C[i]+3),k==="ac"||k==="ad"||k==="ca"||k==="da"?q>n&&(e=q,q=n,n=e):q<n&&(e=q,q=n,n=e),o==="ac"||o==="ad"||o==="ca"||o==="da"?t>u&&(e=t,t=u,u=e):t<u&&(e=t,t=u,u=e),e=new THREE.Face4(q,n,t,u),e.normal.set(1,0,0),E.push(e);this.geometry=z}else this.calculateShadowVolumeGeometryWithoutEdgeInfo(this.geometry)};
THREE.ShadowVolume.prototype.calculateShadowVolumeGeometryWithoutEdgeInfo=function(b){this.geometry=new THREE.Geometry;this.geometry.boundingSphere=b.boundingSphere;this.geometry.edgeFaces=[];var d=this.geometry.vertices,e=this.geometry.faces,f=this.geometry.edgeFaces,g=b.faces,b=b.vertices,i=g.length,h,j,k,o,q,n=["a","b","c","d"];for(k=0;k<i;k++){j=d.length;h=g[k];h instanceof THREE.Face4?(o=4,j=new THREE.Face4(j,j+1,j+2,j+3)):(o=3,j=new THREE.Face3(j,j+1,j+2));j.normal.copy(h.normal);e.push(j);
for(j=0;j<o;j++)q=b[h[n[j]]],d.push(new THREE.Vertex(q.position.clone()))}for(i=0;i<g.length-1;i++){b=e[i];for(h=i+1;h<g.length;h++)j=e[h],j=this.facesShareEdge(d,b,j),j!==void 0&&(j=new THREE.Face4(j.indices[0],j.indices[3],j.indices[2],j.indices[1]),j.normal.set(1,0,0),f.push(j))}};
THREE.ShadowVolume.prototype.facesShareEdge=function(b,d,e){var f,g,i,h,j,k,o,q,n,t,u,z,D,E=0,C=["a","b","c","d"];f=d instanceof THREE.Face4?4:3;g=e instanceof THREE.Face4?4:3;for(z=0;z<f;z++){i=d[C[z]];j=b[i];for(D=0;D<g;D++)if(h=e[C[D]],k=b[h],Math.abs(j.position.x-k.position.x)<1.0E-4&&Math.abs(j.position.y-k.position.y)<1.0E-4&&Math.abs(j.position.z-k.position.z)<1.0E-4&&(E++,E===1&&(o=j,q=k,n=i,t=h,u=C[z]),E===2))return u+=C[z],u==="ad"||u==="ac"?{faces:[d,e],vertices:[o,q,k,j],indices:[n,t,
h,i],vertexTypes:[1,2,2,1],extrudable:!0}:{faces:[d,e],vertices:[o,j,k,q],indices:[n,i,h,t],vertexTypes:[1,1,2,2],extrudable:!0}}};
THREE.Sprite=function(b){THREE.Object3D.call(this);if(b.material!==void 0)this.material=b.material,this.map=void 0,this.blending=material.blending;else if(b.map!==void 0)this.map=b.map instanceof THREE.Texture?b.map:THREE.ImageUtils.loadTexture(b.map),this.material=void 0,this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.useScreenCoordinates=b.useScreenCoordinates!==void 0?b.useScreenCoordinates:!0;this.mergeWith3D=b.mergeWith3D!==void 0?b.mergeWith3D:!this.useScreenCoordinates;
this.affectedByDistance=b.affectedByDistance!==void 0?b.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=b.scaleByViewport!==void 0?b.scaleByViewport:!this.affectedByDistance;this.alignment=b.alignment instanceof THREE.Vector2?b.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.supr=THREE.Object3D.prototype;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);
THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(b){this.supr.addChild.call(this,b);this.addChildRecurse(b)};
THREE.Scene.prototype.addChildRecurse=function(b){if(b instanceof THREE.Light)this.lights.indexOf(b)===-1&&this.lights.push(b);else if(!(b instanceof THREE.Camera||b instanceof THREE.Bone)&&this.objects.indexOf(b)===-1)this.objects.push(b),this.__objectsAdded.push(b);for(var d=0;d<b.children.length;d++)this.addChildRecurse(b.children[d])};THREE.Scene.prototype.removeChild=function(b){this.supr.removeChild.call(this,b);this.removeChildRecurse(b)};
THREE.Scene.prototype.removeChildRecurse=function(b){if(b instanceof THREE.Light){var d=this.lights.indexOf(b);d!==-1&&this.lights.splice(d,1)}else b instanceof THREE.Camera||(d=this.objects.indexOf(b),d!==-1&&(this.objects.splice(d,1),this.__objectsRemoved.push(b)));for(d=0;d<b.children.length;d++)this.removeChildRecurse(b.children[d])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;
THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(b,d,e){this.color=new THREE.Color(b);this.near=d||1;this.far=e||1E3};THREE.FogExp2=function(b,d){this.color=new THREE.Color(b);this.density=d!==void 0?d:2.5E-4};
THREE.Projector=function(){function b(){var b=k[j]=k[j]||new THREE.RenderableVertex;j++;return b}function d(b,d){return d.z-b.z}function e(b,d){var e=0,c=1,f=b.z+b.w,g=d.z+d.w,h=-b.z+b.w,i=-d.z+d.w;return f>=0&&g>=0&&h>=0&&i>=0?!0:f<0&&g<0||h<0&&i<0?!1:(f<0?e=Math.max(e,f/(f-g)):g<0&&(c=Math.min(c,f/(f-g))),h<0?e=Math.max(e,h/(h-i)):i<0&&(c=Math.min(c,h/(h-i))),c<e?!1:(b.lerpSelf(d,e),d.lerpSelf(b,1-c),!0))}var f,g,i=[],h,j,k=[],o,q,n=[],t,u=[],z,D,E=[],C,N,ea=[],S=new THREE.Vector4,H=new THREE.Vector4,
y=new THREE.Matrix4,aa=new THREE.Matrix4,P=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],Q=new THREE.Vector4,B=new THREE.Vector4;this.projectVector=function(b,d){y.multiply(d.projectionMatrix,d.matrixWorldInverse);y.multiplyVector3(b);return b};this.unprojectVector=function(b,d){y.multiply(d.matrixWorld,THREE.Matrix4.makeInvert(d.projectionMatrix));y.multiplyVector3(b);return b};this.projectObjects=function(b,e,h){var e=[],c,j,o;g=0;
j=b.objects;b=0;for(c=j.length;b<c;b++){o=j[b];var k;if(!(k=!o.visible))if(k=o instanceof THREE.Mesh){a:{k=void 0;for(var q=o.matrixWorld,n=-o.geometry.boundingSphere.radius*Math.max(o.scale.x,Math.max(o.scale.y,o.scale.z)),t=0;t<6;t++)if(k=P[t].x*q.n14+P[t].y*q.n24+P[t].z*q.n34+P[t].w,k<=n){k=!1;break a}k=!0}k=!k}if(!k)k=i[g]=i[g]||new THREE.RenderableObject,g++,f=k,S.copy(o.position),y.multiplyVector3(S),f.object=o,f.z=S.z,e.push(f)}h&&e.sort(d);return e};this.projectScene=function(f,g,i){var c=
[],S=g.near,la=g.far,ha,ma,M,na,F,$,T,R,pa,G,xa,va,qa,ra,ia,ta,ya;N=D=t=q=0;g.matrixAutoUpdate&&g.update(void 0,!0);f.update(void 0,!1,g);y.multiply(g.projectionMatrix,g.matrixWorldInverse);P[0].set(y.n41-y.n11,y.n42-y.n12,y.n43-y.n13,y.n44-y.n14);P[1].set(y.n41+y.n11,y.n42+y.n12,y.n43+y.n13,y.n44+y.n14);P[2].set(y.n41+y.n21,y.n42+y.n22,y.n43+y.n23,y.n44+y.n24);P[3].set(y.n41-y.n21,y.n42-y.n22,y.n43-y.n23,y.n44-y.n24);P[4].set(y.n41-y.n31,y.n42-y.n32,y.n43-y.n33,y.n44-y.n34);P[5].set(y.n41+y.n31,
y.n42+y.n32,y.n43+y.n33,y.n44+y.n34);for(ha=0;ha<6;ha++)pa=P[ha],pa.divideScalar(Math.sqrt(pa.x*pa.x+pa.y*pa.y+pa.z*pa.z));pa=this.projectObjects(f,g,!0);f=0;for(ha=pa.length;f<ha;f++)if(G=pa[f].object,G.visible)if(xa=G.matrixWorld,va=G.matrixRotationWorld,qa=G.materials,ra=G.overdraw,j=0,G instanceof THREE.Mesh){ia=G.geometry;na=ia.vertices;ta=ia.faces;ia=ia.faceVertexUvs;ma=0;for(M=na.length;ma<M;ma++)h=b(),h.positionWorld.copy(na[ma].position),xa.multiplyVector3(h.positionWorld),h.positionScreen.copy(h.positionWorld),
y.multiplyVector4(h.positionScreen),h.positionScreen.x/=h.positionScreen.w,h.positionScreen.y/=h.positionScreen.w,h.visible=h.positionScreen.z>S&&h.positionScreen.z<la;na=0;for(ma=ta.length;na<ma;na++){M=ta[na];if(M instanceof THREE.Face3)if(F=k[M.a],$=k[M.b],T=k[M.c],F.visible&&$.visible&&T.visible&&(G.doubleSided||G.flipSided!=(T.positionScreen.x-F.positionScreen.x)*($.positionScreen.y-F.positionScreen.y)-(T.positionScreen.y-F.positionScreen.y)*($.positionScreen.x-F.positionScreen.x)<0))R=n[q]=
n[q]||new THREE.RenderableFace3,q++,o=R,o.v1.copy(F),o.v2.copy($),o.v3.copy(T);else continue;else if(M instanceof THREE.Face4)if(F=k[M.a],$=k[M.b],T=k[M.c],R=k[M.d],F.visible&&$.visible&&T.visible&&R.visible&&(G.doubleSided||G.flipSided!=((R.positionScreen.x-F.positionScreen.x)*($.positionScreen.y-F.positionScreen.y)-(R.positionScreen.y-F.positionScreen.y)*($.positionScreen.x-F.positionScreen.x)<0||($.positionScreen.x-T.positionScreen.x)*(R.positionScreen.y-T.positionScreen.y)-($.positionScreen.y-
T.positionScreen.y)*(R.positionScreen.x-T.positionScreen.x)<0)))ya=u[t]=u[t]||new THREE.RenderableFace4,t++,o=ya,o.v1.copy(F),o.v2.copy($),o.v3.copy(T),o.v4.copy(R);else continue;o.normalWorld.copy(M.normal);va.multiplyVector3(o.normalWorld);o.centroidWorld.copy(M.centroid);xa.multiplyVector3(o.centroidWorld);o.centroidScreen.copy(o.centroidWorld);y.multiplyVector3(o.centroidScreen);T=M.vertexNormals;F=0;for($=T.length;F<$;F++)R=o.vertexNormalsWorld[F],R.copy(T[F]),va.multiplyVector3(R);F=0;for($=
ia.length;F<$;F++)if(ya=ia[F][na]){T=0;for(R=ya.length;T<R;T++)o.uvs[F][T]=ya[T]}o.meshMaterials=qa;o.faceMaterials=M.materials;o.overdraw=ra;o.z=o.centroidScreen.z;c.push(o)}}else if(G instanceof THREE.Line){aa.multiply(y,xa);na=G.geometry.vertices;F=b();F.positionScreen.copy(na[0].position);aa.multiplyVector4(F.positionScreen);ma=1;for(M=na.length;ma<M;ma++)if(F=b(),F.positionScreen.copy(na[ma].position),aa.multiplyVector4(F.positionScreen),$=k[j-2],Q.copy(F.positionScreen),B.copy($.positionScreen),
e(Q,B))Q.multiplyScalar(1/Q.w),B.multiplyScalar(1/B.w),xa=E[D]=E[D]||new THREE.RenderableLine,D++,z=xa,z.v1.positionScreen.copy(Q),z.v2.positionScreen.copy(B),z.z=Math.max(Q.z,B.z),z.materials=G.materials,c.push(z)}else if(G instanceof THREE.Particle&&(H.set(G.matrixWorld.n14,G.matrixWorld.n24,G.matrixWorld.n34,1),y.multiplyVector4(H),H.z/=H.w,H.z>0&&H.z<1))xa=ea[N]=ea[N]||new THREE.RenderableParticle,N++,C=xa,C.x=H.x/H.w,C.y=H.y/H.w,C.z=H.z,C.rotation=G.rotation.z,C.scale.x=G.scale.x*Math.abs(C.x-
(H.x+g.projectionMatrix.n11)/(H.w+g.projectionMatrix.n14)),C.scale.y=G.scale.y*Math.abs(C.y-(H.y+g.projectionMatrix.n22)/(H.w+g.projectionMatrix.n24)),C.materials=G.materials,c.push(C);i&&c.sort(d);return c}};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef PHONG\nvPointLight[ i ] = vec4( lVector, lDistance );\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + vViewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight * pointDistance;\npointSpecular += mSpecular * pointSpecularWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif"};THREE.UniformsUtils={merge:function(b){var d,e,f,g={};for(d=0;d<b.length;d++)for(e in f=this.clone(b[d]),f)g[e]=f[e];return g},clone:function(b){var d,e,f,g={};for(d in b)for(e in g[d]={},b[d])f=b[d][e],g[d][e]=f instanceof THREE.Color||f instanceof THREE.Vector3||f instanceof THREE.Texture?f.clone():f;return g}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",
value:new THREE.Color(16777215)},morphTargetInfluences:{type:"f",value:0}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",value:1},
map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}}};
THREE.ShaderLib={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * vVisibility;\ngl_FragColor = color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * visibility;\ngl_FragColor = color;\n}\n}"},
sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity;\ngl_FragColor = color;\n}"},shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main() {\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform \tfloat \tdarkness;\nvoid main() {\ngl_FragColor = vec4( 0, 0, 0, darkness );\n}"},
shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm ) ), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0 );\n}"},
depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{opacity:{type:"f",value:1}},
fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,
THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );\ngl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,
THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.map_fragment,
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,
"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsLib.particle,fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",
THREE.ShaderChunk.color_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;\n}"].join("\n")}};
THREE.WebGLRenderer=function(b){function d(b,d,e){var f,g,h,i=b.vertices,j=i.length,k=b.colors,o=k.length,p=b.__vertexArray,O=b.__colorArray,q=b.__sortArray,n=b.__dirtyVertices,t=b.__dirtyColors;if(e.sortParticles){ia.multiplySelf(e.matrixWorld);for(f=0;f<j;f++)g=i[f].position,Da.copy(g),ia.multiplyVector3(Da),q[f]=[Da.z,f];q.sort(function(b,c){return c[0]-b[0]});for(f=0;f<j;f++)g=i[q[f][1]].position,h=f*3,p[h]=g.x,p[h+1]=g.y,p[h+2]=g.z;for(f=0;f<o;f++)h=f*3,color=k[q[f][1]],O[h]=color.r,O[h+1]=color.g,
O[h+2]=color.b}else{if(n)for(f=0;f<j;f++)g=i[f].position,h=f*3,p[h]=g.x,p[h+1]=g.y,p[h+2]=g.z;if(t)for(f=0;f<o;f++)color=k[f],h=f*3,O[h]=color.r,O[h+1]=color.g,O[h+2]=color.b}if(n||e.sortParticles)c.bindBuffer(c.ARRAY_BUFFER,b.__webglVertexBuffer),c.bufferData(c.ARRAY_BUFFER,p,d);if(t||e.sortParticles)c.bindBuffer(c.ARRAY_BUFFER,b.__webglColorBuffer),c.bufferData(c.ARRAY_BUFFER,O,d)}function e(b,d,e,f,g){f.program||L.initMaterial(f,d,e,g);var h=f.program,i=h.uniforms,j=f.uniforms;h!=la&&(c.useProgram(h),
la=h);c.uniformMatrix4fv(i.projectionMatrix,!1,ta);if(e&&(f instanceof THREE.MeshBasicMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshPhongMaterial||f instanceof THREE.LineBasicMaterial||f instanceof THREE.ParticleBasicMaterial||f.fog))if(j.fogColor.value=e.color,e instanceof THREE.Fog)j.fogNear.value=e.near,j.fogFar.value=e.far;else if(e instanceof THREE.FogExp2)j.fogDensity.value=e.density;if(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||
f.lights){var k,o,p=0,O=0,q=0,n,t,u,y,v=Ga,r=v.directional.colors,C=v.directional.positions,z=v.point.colors,D=v.point.positions,I=v.point.distances,x=0,s=0,e=o=y=0;for(k=d.length;e<k;e++)if(o=d[e],n=o.color,t=o.position,u=o.intensity,y=o.distance,o instanceof THREE.AmbientLight)p+=n.r,O+=n.g,q+=n.b;else if(o instanceof THREE.DirectionalLight)y=x*3,r[y]=n.r*u,r[y+1]=n.g*u,r[y+2]=n.b*u,C[y]=t.x,C[y+1]=t.y,C[y+2]=t.z,x+=1;else if(o instanceof THREE.PointLight)o=s*3,z[o]=n.r*u,z[o+1]=n.g*u,z[o+2]=n.b*
u,D[o]=t.x,D[o+1]=t.y,D[o+2]=t.z,I[s]=y,s+=1;for(e=x*3;e<r.length;e++)r[e]=0;for(e=s*3;e<z.length;e++)z[e]=0;v.point.length=s;v.directional.length=x;v.ambient[0]=p;v.ambient[1]=O;v.ambient[2]=q;e=Ga;j.enableLighting.value=e.directional.length+e.point.length;j.ambientLightColor.value=e.ambient;j.directionalLightColor.value=e.directional.colors;j.directionalLightDirection.value=e.directional.positions;j.pointLightColor.value=e.point.colors;j.pointLightPosition.value=e.point.positions;j.pointLightDistance.value=
e.point.distances}if(f instanceof THREE.MeshBasicMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshPhongMaterial)j.diffuse.value=f.color,j.opacity.value=f.opacity,(j.map.texture=f.map)&&j.offsetRepeat.value.set(f.map.offset.x,f.map.offset.y,f.map.repeat.x,f.map.repeat.y),j.lightMap.texture=f.lightMap,j.envMap.texture=f.envMap,j.reflectivity.value=f.reflectivity,j.refractionRatio.value=f.refractionRatio,j.combine.value=f.combine,j.useRefract.value=f.envMap&&f.envMap.mapping instanceof
THREE.CubeRefractionMapping;if(f instanceof THREE.LineBasicMaterial)j.diffuse.value=f.color,j.opacity.value=f.opacity;else if(f instanceof THREE.ParticleBasicMaterial)j.psColor.value=f.color,j.opacity.value=f.opacity,j.size.value=f.size,j.scale.value=wa.height/2,j.map.texture=f.map;else if(f instanceof THREE.MeshPhongMaterial)j.ambient.value=f.ambient,j.specular.value=f.specular,j.shininess.value=f.shininess;else if(f instanceof THREE.MeshDepthMaterial)j.mNear.value=b.near,j.mFar.value=b.far,j.opacity.value=
f.opacity;else if(f instanceof THREE.MeshNormalMaterial)j.opacity.value=f.opacity;for(var A in j)if(O=h.uniforms[A])if(k=j[A],p=k.type,e=k.value,p=="i")c.uniform1i(O,e);else if(p=="f")c.uniform1f(O,e);else if(p=="fv1")c.uniform1fv(O,e);else if(p=="fv")c.uniform3fv(O,e);else if(p=="v2")c.uniform2f(O,e.x,e.y);else if(p=="v3")c.uniform3f(O,e.x,e.y,e.z);else if(p=="v4")c.uniform4f(O,e.x,e.y,e.z,e.w);else if(p=="c")c.uniform3f(O,e.r,e.g,e.b);else if(p=="t"&&(c.uniform1i(O,e),k=k.texture))if(k.image instanceof
Array&&k.image.length==6){if(k.image.length==6){if(k.needsUpdate){if(k.__webglInit){c.bindTexture(c.TEXTURE_CUBE_MAP,k.image.__webglTextureCube);for(p=0;p<6;++p)c.texSubImage2D(c.TEXTURE_CUBE_MAP_POSITIVE_X+p,0,0,0,c.RGBA,c.UNSIGNED_BYTE,k.image[p])}else{k.image.__webglTextureCube=c.createTexture();c.bindTexture(c.TEXTURE_CUBE_MAP,k.image.__webglTextureCube);for(p=0;p<6;++p)c.texImage2D(c.TEXTURE_CUBE_MAP_POSITIVE_X+p,0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,k.image[p]);k.__webglInit=!0}aa(c.TEXTURE_CUBE_MAP,
k,k.image[0]);c.bindTexture(c.TEXTURE_CUBE_MAP,null);k.needsUpdate=!1}c.activeTexture(c.TEXTURE0+e);c.bindTexture(c.TEXTURE_CUBE_MAP,k.image.__webglTextureCube)}}else P(k,e);c.uniformMatrix4fv(i.modelViewMatrix,!1,g._modelViewMatrixArray);c.uniformMatrix3fv(i.normalMatrix,!1,g._normalMatrixArray);(f instanceof THREE.MeshShaderMaterial||f instanceof THREE.MeshPhongMaterial||f.envMap)&&i.cameraPosition!==null&&c.uniform3f(i.cameraPosition,b.position.x,b.position.y,b.position.z);(f instanceof THREE.MeshShaderMaterial||
f.envMap||f.skinning)&&i.objectMatrix!==null&&c.uniformMatrix4fv(i.objectMatrix,!1,g._objectMatrixArray);(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshShaderMaterial||f.skinning)&&i.viewMatrix!==null&&c.uniformMatrix4fv(i.viewMatrix,!1,ya);if(f instanceof THREE.ShadowVolumeDynamicMaterial)b=j.directionalLightDirection.value,b[0]=-d[1].position.x,b[1]=-d[1].position.y,b[2]=-d[1].position.z,c.uniform3fv(i.directionalLightDirection,b),c.uniformMatrix4fv(i.objectMatrix,
!1,g._objectMatrixArray),c.uniformMatrix4fv(i.viewMatrix,!1,ya);f.skinning&&(c.uniformMatrix4fv(i.cameraInverseMatrix,!1,ya),c.uniformMatrix4fv(i.boneGlobalMatrices,!1,g.boneMatrices));return h}function f(b,d,f,g,h,i){if(g.opacity!=0){var j,b=e(b,d,f,g,i).attributes;if(!g.morphTargets&&b.position>=0)c.bindBuffer(c.ARRAY_BUFFER,h.__webglVertexBuffer),c.vertexAttribPointer(b.position,3,c.FLOAT,!1,0,0);else{d=g.program.attributes;i.morphTargetBase!==-1?(c.bindBuffer(c.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[i.morphTargetBase]),
c.vertexAttribPointer(d.position,3,c.FLOAT,!1,0,0)):d.position>=0&&(c.bindBuffer(c.ARRAY_BUFFER,h.__webglVertexBuffer),c.vertexAttribPointer(d.position,3,c.FLOAT,!1,0,0));if(i.morphTargetForcedOrder.length)for(var f=0,k=i.morphTargetForcedOrder,o=i.morphTargetInfluences;f<g.numSupportedMorphTargets&&f<k.length;)c.bindBuffer(c.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[k[f]]),c.vertexAttribPointer(d["morphTarget"+f],3,c.FLOAT,!1,0,0),i.__webglMorphTargetInfluences[f]=o[k[f]],f++;else{var k=[],q=-1,
p=0,o=i.morphTargetInfluences,O,n=o.length,f=0;for(i.morphTargetBase!==-1&&(k[i.morphTargetBase]=!0);f<g.numSupportedMorphTargets;){for(O=0;O<n;O++)!k[O]&&o[O]>q&&(p=O,q=o[p]);c.bindBuffer(c.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[p]);c.vertexAttribPointer(d["morphTarget"+f],3,c.FLOAT,!1,0,0);i.__webglMorphTargetInfluences[f]=q;k[p]=1;q=-1;f++}}g.program.uniforms.morphTargetInfluences!==null&&c.uniform1fv(g.program.uniforms.morphTargetInfluences,i.__webglMorphTargetInfluences)}if(h.__webglCustomAttributes)for(j in h.__webglCustomAttributes)b[j]>=
0&&(d=h.__webglCustomAttributes[j],c.bindBuffer(c.ARRAY_BUFFER,d.buffer),c.vertexAttribPointer(b[j],d.size,c.FLOAT,!1,0,0));b.color>=0&&(c.bindBuffer(c.ARRAY_BUFFER,h.__webglColorBuffer),c.vertexAttribPointer(b.color,3,c.FLOAT,!1,0,0));b.normal>=0&&(c.bindBuffer(c.ARRAY_BUFFER,h.__webglNormalBuffer),c.vertexAttribPointer(b.normal,3,c.FLOAT,!1,0,0));b.tangent>=0&&(c.bindBuffer(c.ARRAY_BUFFER,h.__webglTangentBuffer),c.vertexAttribPointer(b.tangent,4,c.FLOAT,!1,0,0));b.uv>=0&&(h.__webglUVBuffer?(c.bindBuffer(c.ARRAY_BUFFER,
h.__webglUVBuffer),c.vertexAttribPointer(b.uv,2,c.FLOAT,!1,0,0),c.enableVertexAttribArray(b.uv)):c.disableVertexAttribArray(b.uv));b.uv2>=0&&(h.__webglUV2Buffer?(c.bindBuffer(c.ARRAY_BUFFER,h.__webglUV2Buffer),c.vertexAttribPointer(b.uv2,2,c.FLOAT,!1,0,0),c.enableVertexAttribArray(b.uv2)):c.disableVertexAttribArray(b.uv2));g.skinning&&b.skinVertexA>=0&&b.skinVertexB>=0&&b.skinIndex>=0&&b.skinWeight>=0&&(c.bindBuffer(c.ARRAY_BUFFER,h.__webglSkinVertexABuffer),c.vertexAttribPointer(b.skinVertexA,4,
c.FLOAT,!1,0,0),c.bindBuffer(c.ARRAY_BUFFER,h.__webglSkinVertexBBuffer),c.vertexAttribPointer(b.skinVertexB,4,c.FLOAT,!1,0,0),c.bindBuffer(c.ARRAY_BUFFER,h.__webglSkinIndicesBuffer),c.vertexAttribPointer(b.skinIndex,4,c.FLOAT,!1,0,0),c.bindBuffer(c.ARRAY_BUFFER,h.__webglSkinWeightsBuffer),c.vertexAttribPointer(b.skinWeight,4,c.FLOAT,!1,0,0));i instanceof THREE.Mesh?(g.wireframe?(c.lineWidth(g.wireframeLinewidth),c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,h.__webglLineBuffer),c.drawElements(c.LINES,h.__webglLineCount,
c.UNSIGNED_SHORT,0)):(c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,h.__webglFaceBuffer),c.drawElements(c.TRIANGLES,h.__webglFaceCount,c.UNSIGNED_SHORT,0)),L.data.vertices+=h.__webglFaceCount,L.data.faces+=h.__webglFaceCount/3,L.data.drawCalls++):i instanceof THREE.Line?(i=i.type==THREE.LineStrip?c.LINE_STRIP:c.LINES,c.lineWidth(g.linewidth),c.drawArrays(i,0,h.__webglLineCount),L.data.drawCalls++):i instanceof THREE.ParticleSystem?(c.drawArrays(c.POINTS,0,h.__webglParticleCount),L.data.drawCalls++):i instanceof
THREE.Ribbon&&(c.drawArrays(c.TRIANGLE_STRIP,0,h.__webglVertexCount),L.data.drawCalls++)}}function g(b,d,e){if(!b.__webglVertexBuffer)b.__webglVertexBuffer=c.createBuffer();if(!b.__webglNormalBuffer)b.__webglNormalBuffer=c.createBuffer();b.hasPos&&(c.bindBuffer(c.ARRAY_BUFFER,b.__webglVertexBuffer),c.bufferData(c.ARRAY_BUFFER,b.positionArray,c.DYNAMIC_DRAW),c.enableVertexAttribArray(d.attributes.position),c.vertexAttribPointer(d.attributes.position,3,c.FLOAT,!1,0,0));if(b.hasNormal){c.bindBuffer(c.ARRAY_BUFFER,
b.__webglNormalBuffer);if(e==THREE.FlatShading){var f,h,g,i,j,k,o,p,q,n,t=b.count*3;for(n=0;n<t;n+=9)e=b.normalArray,f=e[n],h=e[n+1],g=e[n+2],i=e[n+3],k=e[n+4],p=e[n+5],j=e[n+6],o=e[n+7],q=e[n+8],f=(f+i+j)/3,h=(h+k+o)/3,g=(g+p+q)/3,e[n]=f,e[n+1]=h,e[n+2]=g,e[n+3]=f,e[n+4]=h,e[n+5]=g,e[n+6]=f,e[n+7]=h,e[n+8]=g}c.bufferData(c.ARRAY_BUFFER,b.normalArray,c.DYNAMIC_DRAW);c.enableVertexAttribArray(d.attributes.normal);c.vertexAttribPointer(d.attributes.normal,3,c.FLOAT,!1,0,0)}c.drawArrays(c.TRIANGLES,
0,b.count);b.count=0}function i(b){if(M!=b.doubleSided)b.doubleSided?c.disable(c.CULL_FACE):c.enable(c.CULL_FACE),M=b.doubleSided;if(na!=b.flipSided)b.flipSided?c.frontFace(c.CW):c.frontFace(c.CCW),na=b.flipSided}function h(b){$!=b&&(b?c.enable(c.DEPTH_TEST):c.disable(c.DEPTH_TEST),$=b)}function j(b,d,e){T!=b&&(b?c.enable(c.POLYGON_OFFSET_FILL):c.disable(c.POLYGON_OFFSET_FILL),T=b);if(b&&(R!=d||pa!=e))c.polygonOffset(d,e),R=d,pa=e}function k(b){ra[0].set(b.n41-b.n11,b.n42-b.n12,b.n43-b.n13,b.n44-
b.n14);ra[1].set(b.n41+b.n11,b.n42+b.n12,b.n43+b.n13,b.n44+b.n14);ra[2].set(b.n41+b.n21,b.n42+b.n22,b.n43+b.n23,b.n44+b.n24);ra[3].set(b.n41-b.n21,b.n42-b.n22,b.n43-b.n23,b.n44-b.n24);ra[4].set(b.n41-b.n31,b.n42-b.n32,b.n43-b.n33,b.n44-b.n34);ra[5].set(b.n41+b.n31,b.n42+b.n32,b.n43+b.n33,b.n44+b.n34);for(var c,b=0;b<6;b++)c=ra[b],c.divideScalar(Math.sqrt(c.x*c.x+c.y*c.y+c.z*c.z))}function o(b){for(var c=b.matrixWorld,d=-b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)),
e=0;e<6;e++)if(b=ra[e].x*c.n14+ra[e].y*c.n24+ra[e].z*c.n34+ra[e].w,b<=d)return!1;return!0}function q(b,c){b.list[b.count]=c;b.count+=1}function n(b){var c,d,e=b.object,f=b.opaque,h=b.transparent;h.count=0;b=f.count=0;for(c=e.materials.length;b<c;b++)d=e.materials[b],d.transparent?q(h,d):q(f,d)}function t(b){var c,d,e,f,h=b.object,g=b.buffer,i=b.opaque,j=b.transparent;j.count=0;b=i.count=0;for(e=h.materials.length;b<e;b++)if(c=h.materials[b],c instanceof THREE.MeshFaceMaterial){c=0;for(d=g.materials.length;c<
d;c++)(f=g.materials[c])&&(f.transparent?q(j,f):q(i,f))}else(f=c)&&(f.transparent?q(j,f):q(i,f))}function u(b,c){return c.z-b.z}function z(b){c.enable(c.POLYGON_OFFSET_FILL);c.polygonOffset(0.1,1);c.enable(c.STENCIL_TEST);c.enable(c.DEPTH_TEST);c.depthMask(!1);c.colorMask(!1,!1,!1,!1);c.stencilFunc(c.ALWAYS,1,255);c.stencilOpSeparate(c.BACK,c.KEEP,c.INCR,c.KEEP);c.stencilOpSeparate(c.FRONT,c.KEEP,c.DECR,c.KEEP);var d,e=b.lights.length,f,h=b.lights,g=[],i,j,k,o,p,n=b.__webglShadowVolumes.length;for(d=
0;d<e;d++)if(f=b.lights[d],f instanceof THREE.DirectionalLight&&f.castShadow){g[0]=-f.position.x;g[1]=-f.position.y;g[2]=-f.position.z;for(p=0;p<n;p++)f=b.__webglShadowVolumes[p].object,i=b.__webglShadowVolumes[p].buffer,j=f.materials[0],j.program||L.initMaterial(j,h,void 0,f),j=j.program,k=j.uniforms,o=j.attributes,la!==j&&(c.useProgram(j),la=j,c.uniformMatrix4fv(k.projectionMatrix,!1,ta),c.uniformMatrix4fv(k.viewMatrix,!1,ya),c.uniform3fv(k.directionalLightDirection,g)),f.matrixWorld.flattenToArray(f._objectMatrixArray),
c.uniformMatrix4fv(k.objectMatrix,!1,f._objectMatrixArray),c.bindBuffer(c.ARRAY_BUFFER,i.__webglVertexBuffer),c.vertexAttribPointer(o.position,3,c.FLOAT,!1,0,0),c.bindBuffer(c.ARRAY_BUFFER,i.__webglNormalBuffer),c.vertexAttribPointer(o.normal,3,c.FLOAT,!1,0,0),c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,i.__webglFaceBuffer),c.cullFace(c.FRONT),c.drawElements(c.TRIANGLES,i.__webglFaceCount,c.UNSIGNED_SHORT,0),c.cullFace(c.BACK),c.drawElements(c.TRIANGLES,i.__webglFaceCount,c.UNSIGNED_SHORT,0)}c.disable(c.POLYGON_OFFSET_FILL);
c.colorMask(!0,!0,!0,!0);c.stencilFunc(c.NOTEQUAL,0,255);c.stencilOp(c.KEEP,c.KEEP,c.KEEP);c.disable(c.DEPTH_TEST);F=-1;la=x.program;c.useProgram(x.program);c.uniformMatrix4fv(x.projectionLocation,!1,ta);c.uniform1f(x.darknessLocation,x.darkness);c.bindBuffer(c.ARRAY_BUFFER,x.vertexBuffer);c.vertexAttribPointer(x.vertexLocation,3,c.FLOAT,!1,0,0);c.enableVertexAttribArray(x.vertexLocation);c.blendFunc(c.ONE,c.ONE_MINUS_SRC_ALPHA);c.blendEquation(c.FUNC_ADD);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,x.elementBuffer);
c.drawElements(c.TRIANGLES,6,c.UNSIGNED_SHORT,0);c.disable(c.STENCIL_TEST);c.enable(c.DEPTH_TEST);c.depthMask(ma)}function D(b,d){var e,f,h;e=r.attributes;var g=r.uniforms,i=qa/va,j,k=[],o=va*0.5,p=qa*0.5,n=!0;c.useProgram(r.program);la=r.program;F=-1;Ha||(c.enableVertexAttribArray(r.attributes.position),c.enableVertexAttribArray(r.attributes.uv),Ha=!0);c.disable(c.CULL_FACE);c.enable(c.BLEND);c.depthMask(!0);c.bindBuffer(c.ARRAY_BUFFER,r.vertexBuffer);c.vertexAttribPointer(e.position,2,c.FLOAT,!1,
16,0);c.vertexAttribPointer(e.uv,2,c.FLOAT,!1,16,8);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,r.elementBuffer);c.uniformMatrix4fv(g.projectionMatrix,!1,ta);c.activeTexture(c.TEXTURE0);c.uniform1i(g.map,0);e=0;for(f=b.__webglSprites.length;e<f;e++)h=b.__webglSprites[e],h.useScreenCoordinates?h.z=-h.position.z:(h._modelViewMatrix.multiplyToArray(d.matrixWorldInverse,h.matrixWorld,h._modelViewMatrixArray),h.z=-h._modelViewMatrix.n34);b.__webglSprites.sort(u);e=0;for(f=b.__webglSprites.length;e<f;e++)h=b.__webglSprites[e],
h.material===void 0&&h.map&&h.map.image&&h.map.image.width&&(h.useScreenCoordinates?(c.uniform1i(g.useScreenCoordinates,1),c.uniform3f(g.screenPosition,(h.position.x-o)/o,(p-h.position.y)/p,Math.max(0,Math.min(1,h.position.z)))):(c.uniform1i(g.useScreenCoordinates,0),c.uniform1i(g.affectedByDistance,h.affectedByDistance?1:0),c.uniformMatrix4fv(g.modelViewMatrix,!1,h._modelViewMatrixArray)),j=h.map.image.width/(h.scaleByViewport?qa:1),k[0]=j*i*h.scale.x,k[1]=j*h.scale.y,c.uniform2f(g.uvScale,h.uvScale.x,
h.uvScale.y),c.uniform2f(g.uvOffset,h.uvOffset.x,h.uvOffset.y),c.uniform2f(g.alignment,h.alignment.x,h.alignment.y),c.uniform1f(g.opacity,h.opacity),c.uniform1f(g.rotation,h.rotation),c.uniform2fv(g.scale,k),h.mergeWith3D&&!n?(c.enable(c.DEPTH_TEST),n=!0):!h.mergeWith3D&&n&&(c.disable(c.DEPTH_TEST),n=!1),y(h.blending),P(h.map,0),c.drawElements(c.TRIANGLES,6,c.UNSIGNED_SHORT,0));c.enable(c.CULL_FACE);c.enable(c.DEPTH_TEST);c.depthMask(ma)}function E(b,e){var d,f,h=b.__webglLensFlares.length,g,i,j,
k=new THREE.Vector3,o=qa/va,p=va*0.5,n=qa*0.5,q=16/qa,t=[q*o,q],u=[1,1,0],r=[1,1],z=v.uniforms;d=v.attributes;c.useProgram(v.program);la=v.program;F=-1;Ia||(c.enableVertexAttribArray(v.attributes.vertex),c.enableVertexAttribArray(v.attributes.uv),Ia=!0);c.uniform1i(z.occlusionMap,0);c.uniform1i(z.map,1);c.bindBuffer(c.ARRAY_BUFFER,v.vertexBuffer);c.vertexAttribPointer(d.vertex,2,c.FLOAT,!1,16,0);c.vertexAttribPointer(d.uv,2,c.FLOAT,!1,16,8);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,v.elementBuffer);c.disable(c.CULL_FACE);
c.depthMask(!1);c.activeTexture(c.TEXTURE0);c.bindTexture(c.TEXTURE_2D,v.occlusionTexture);c.activeTexture(c.TEXTURE1);for(f=0;f<h;f++)if(d=b.__webglLensFlares[f].object,k.set(d.matrixWorld.n14,d.matrixWorld.n24,d.matrixWorld.n34),e.matrixWorldInverse.multiplyVector3(k),e.projectionMatrix.multiplyVector3(k),u[0]=k.x,u[1]=k.y,u[2]=k.z,r[0]=u[0]*p+p,r[1]=u[1]*n+n,v.hasVertexTexture||r[0]>0&&r[0]<va&&r[1]>0&&r[1]<qa){c.bindTexture(c.TEXTURE_2D,v.tempTexture);c.copyTexImage2D(c.TEXTURE_2D,0,c.RGB,r[0]-
8,r[1]-8,16,16,0);c.uniform1i(z.renderType,0);c.uniform2fv(z.scale,t);c.uniform3fv(z.screenPosition,u);c.disable(c.BLEND);c.enable(c.DEPTH_TEST);c.drawElements(c.TRIANGLES,6,c.UNSIGNED_SHORT,0);c.bindTexture(c.TEXTURE_2D,v.occlusionTexture);c.copyTexImage2D(c.TEXTURE_2D,0,c.RGBA,r[0]-8,r[1]-8,16,16,0);c.uniform1i(z.renderType,1);c.disable(c.DEPTH_TEST);c.bindTexture(c.TEXTURE_2D,v.tempTexture);c.drawElements(c.TRIANGLES,6,c.UNSIGNED_SHORT,0);d.positionScreen.x=u[0];d.positionScreen.y=u[1];d.positionScreen.z=
u[2];d.customUpdateCallback?d.customUpdateCallback(d):d.updateLensFlares();c.uniform1i(z.renderType,2);c.enable(c.BLEND);g=0;for(i=d.lensFlares.length;g<i;g++)if(j=d.lensFlares[g],j.opacity>0.001&&j.scale>0.001)u[0]=j.x,u[1]=j.y,u[2]=j.z,q=j.size*j.scale/qa,t[0]=q*o,t[1]=q,c.uniform3fv(z.screenPosition,u),c.uniform2fv(z.scale,t),c.uniform1f(z.rotation,j.rotation),c.uniform1f(z.opacity,j.opacity),y(j.blending),P(j.texture,1),c.drawElements(c.TRIANGLES,6,c.UNSIGNED_SHORT,0)}c.enable(c.CULL_FACE);c.enable(c.DEPTH_TEST);
c.depthMask(ma)}function C(b,c){b._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,b.matrixWorld,b._modelViewMatrixArray);THREE.Matrix4.makeInvert3x3(b._modelViewMatrix).transposeIntoArray(b._normalMatrixArray)}function N(b){var e,f,h,g;if(b instanceof THREE.Mesh){f=b.geometry;for(e in f.geometryGroups){h=f.geometryGroups[e];a:{for(var i=g=void 0,j=void 0,k=void 0,o=void 0,o=h.__materials,i=0,j=o.length;i<j;i++)if(k=o[i],k.attributes)for(g in k.attributes)if(k.attributes[g].needsUpdate){g=!0;
break a}g=!1}if(f.__dirtyVertices||f.__dirtyMorphTargets||f.__dirtyElements||f.__dirtyUvs||f.__dirtyNormals||f.__dirtyColors||f.__dirtyTangents||g)if(g=h,i=b,j=c.DYNAMIC_DRAW,g.__inittedArrays){var n=o=k=void 0,p=void 0,q=n=void 0,t=void 0,u=void 0,r=void 0,y=void 0,v=void 0,z=void 0,C=void 0,D=void 0,x=void 0,J=void 0,I=void 0,E=void 0,s=p=r=p=u=t=void 0,A=void 0,m=A=s=t=void 0,F=void 0,H=m=A=s=n=n=q=r=p=m=A=s=F=m=A=s=F=m=A=s=void 0,B=0,G=0,P=0,T=0,L=0,K=0,U=0,M=0,ca=0,w=0,da=0,A=s=0,fa=g.__vertexArray,
$=g.__uvArray,aa=g.__uv2Array,Q=g.__normalArray,V=g.__tangentArray,ga=g.__colorArray,W=g.__skinVertexAArray,X=g.__skinVertexBArray,Y=g.__skinIndexArray,Z=g.__skinWeightArray,ea=g.__morphTargetsArrays,S=g.__webglCustomAttributes,m=void 0,N=g.__faceArray,R=g.__lineArray,la=g.__needsSmoothNormals,v=g.__vertexColorType,y=g.__uvType,z=g.__normalType,ja=i.geometry,ma=ja.__dirtyVertices,na=ja.__dirtyElements,ha=ja.__dirtyUvs,pa=ja.__dirtyNormals,qa=ja.__dirtyTangents,ra=ja.__dirtyColors,sa=ja.__dirtyMorphTargets,
ia=ja.vertices,ua=g.faces,xa=ja.faces,va=ja.faceVertexUvs[0],ya=ja.faceVertexUvs[1],oa=ja.skinVerticesA,ta=ja.skinVerticesB,wa=ja.skinIndices,Ba=ja.skinWeights,Ca=i instanceof THREE.ShadowVolume?ja.edgeFaces:void 0,Aa=ja.morphTargets;if(S)for(H in S)S[H].offset=0,S[H].offsetSrc=0;k=0;for(o=ua.length;k<o;k++)if(n=ua[k],p=xa[n],va&&(C=va[n]),ya&&(D=ya[n]),n=p.vertexNormals,q=p.normal,t=p.vertexColors,u=p.color,r=p.vertexTangents,p instanceof THREE.Face3){if(ma)x=ia[p.a].position,J=ia[p.b].position,
I=ia[p.c].position,fa[G]=x.x,fa[G+1]=x.y,fa[G+2]=x.z,fa[G+3]=J.x,fa[G+4]=J.y,fa[G+5]=J.z,fa[G+6]=I.x,fa[G+7]=I.y,fa[G+8]=I.z,G+=9;if(S)for(H in S)if(m=S[H],m.__original.needsUpdate)s=m.offset,A=m.offsetSrc,m.size===1?(m.boundTo===void 0||m.boundTo==="vertices"?(m.array[s+0]=m.value[p.a],m.array[s+1]=m.value[p.b],m.array[s+2]=m.value[p.c]):m.boundTo==="faces"?(m.array[s+0]=m.value[A],m.array[s+1]=m.value[A],m.array[s+2]=m.value[A],m.offsetSrc++):m.boundTo==="faceVertices"&&(m.array[s+0]=m.value[A+
0],m.array[s+1]=m.value[A+1],m.array[s+2]=m.value[A+2],m.offsetSrc+=3),m.offset+=3):(m.boundTo===void 0||m.boundTo==="vertices"?(x=m.value[p.a],J=m.value[p.b],I=m.value[p.c]):m.boundTo==="faces"?(x=m.value[A],J=m.value[A],I=m.value[A],m.offsetSrc++):m.boundTo==="faceVertices"&&(x=m.value[A+0],J=m.value[A+1],I=m.value[A+2],m.offsetSrc+=3),m.size===2?(m.array[s+0]=x.x,m.array[s+1]=x.y,m.array[s+2]=J.x,m.array[s+3]=J.y,m.array[s+4]=I.x,m.array[s+5]=I.y,m.offset+=6):m.size===3?(m.type==="c"?(m.array[s+
0]=x.r,m.array[s+1]=x.g,m.array[s+2]=x.b,m.array[s+3]=J.r,m.array[s+4]=J.g,m.array[s+5]=J.b,m.array[s+6]=I.r,m.array[s+7]=I.g,m.array[s+8]=I.b):(m.array[s+0]=x.x,m.array[s+1]=x.y,m.array[s+2]=x.z,m.array[s+3]=J.x,m.array[s+4]=J.y,m.array[s+5]=J.z,m.array[s+6]=I.x,m.array[s+7]=I.y,m.array[s+8]=I.z),m.offset+=9):(m.array[s+0]=x.x,m.array[s+1]=x.y,m.array[s+2]=x.z,m.array[s+3]=x.w,m.array[s+4]=J.x,m.array[s+5]=J.y,m.array[s+6]=J.z,m.array[s+7]=J.w,m.array[s+8]=I.x,m.array[s+9]=I.y,m.array[s+10]=I.z,
m.array[s+11]=I.w,m.offset+=12));if(sa){s=0;for(A=Aa.length;s<A;s++)x=Aa[s].vertices[p.a].position,J=Aa[s].vertices[p.b].position,I=Aa[s].vertices[p.c].position,m=ea[s],m[da+0]=x.x,m[da+1]=x.y,m[da+2]=x.z,m[da+3]=J.x,m[da+4]=J.y,m[da+5]=J.z,m[da+6]=I.x,m[da+7]=I.y,m[da+8]=I.z;da+=9}if(Ba.length)s=Ba[p.a],A=Ba[p.b],m=Ba[p.c],Z[w]=s.x,Z[w+1]=s.y,Z[w+2]=s.z,Z[w+3]=s.w,Z[w+4]=A.x,Z[w+5]=A.y,Z[w+6]=A.z,Z[w+7]=A.w,Z[w+8]=m.x,Z[w+9]=m.y,Z[w+10]=m.z,Z[w+11]=m.w,s=wa[p.a],A=wa[p.b],m=wa[p.c],Y[w]=s.x,Y[w+
1]=s.y,Y[w+2]=s.z,Y[w+3]=s.w,Y[w+4]=A.x,Y[w+5]=A.y,Y[w+6]=A.z,Y[w+7]=A.w,Y[w+8]=m.x,Y[w+9]=m.y,Y[w+10]=m.z,Y[w+11]=m.w,s=oa[p.a],A=oa[p.b],m=oa[p.c],W[w]=s.x,W[w+1]=s.y,W[w+2]=s.z,W[w+3]=1,W[w+4]=A.x,W[w+5]=A.y,W[w+6]=A.z,W[w+7]=1,W[w+8]=m.x,W[w+9]=m.y,W[w+10]=m.z,W[w+11]=1,s=ta[p.a],A=ta[p.b],m=ta[p.c],X[w]=s.x,X[w+1]=s.y,X[w+2]=s.z,X[w+3]=1,X[w+4]=A.x,X[w+5]=A.y,X[w+6]=A.z,X[w+7]=1,X[w+8]=m.x,X[w+9]=m.y,X[w+10]=m.z,X[w+11]=1,w+=12;if(ra&&v)t.length==3&&v==THREE.VertexColors?(p=t[0],s=t[1],A=t[2]):
A=s=p=u,ga[ca]=p.r,ga[ca+1]=p.g,ga[ca+2]=p.b,ga[ca+3]=s.r,ga[ca+4]=s.g,ga[ca+5]=s.b,ga[ca+6]=A.r,ga[ca+7]=A.g,ga[ca+8]=A.b,ca+=9;if(qa&&ja.hasTangents)t=r[0],u=r[1],p=r[2],V[U]=t.x,V[U+1]=t.y,V[U+2]=t.z,V[U+3]=t.w,V[U+4]=u.x,V[U+5]=u.y,V[U+6]=u.z,V[U+7]=u.w,V[U+8]=p.x,V[U+9]=p.y,V[U+10]=p.z,V[U+11]=p.w,U+=12;if(pa&&z)if(n.length==3&&la)for(r=0;r<3;r++)q=n[r],Q[K]=q.x,Q[K+1]=q.y,Q[K+2]=q.z,K+=3;else for(r=0;r<3;r++)Q[K]=q.x,Q[K+1]=q.y,Q[K+2]=q.z,K+=3;if(ha&&C!==void 0&&y)for(r=0;r<3;r++)n=C[r],$[P]=
n.u,$[P+1]=n.v,P+=2;if(ha&&D!==void 0&&y)for(r=0;r<3;r++)n=D[r],aa[T]=n.u,aa[T+1]=n.v,T+=2;na&&(N[L]=B,N[L+1]=B+1,N[L+2]=B+2,L+=3,R[M]=B,R[M+1]=B+1,R[M+2]=B,R[M+3]=B+2,R[M+4]=B+1,R[M+5]=B+2,M+=6,B+=3)}else if(p instanceof THREE.Face4){if(ma)x=ia[p.a].position,J=ia[p.b].position,I=ia[p.c].position,E=ia[p.d].position,fa[G]=x.x,fa[G+1]=x.y,fa[G+2]=x.z,fa[G+3]=J.x,fa[G+4]=J.y,fa[G+5]=J.z,fa[G+6]=I.x,fa[G+7]=I.y,fa[G+8]=I.z,fa[G+9]=E.x,fa[G+10]=E.y,fa[G+11]=E.z,G+=12;if(S)for(H in S)if(m=S[H],m.__original.needsUpdate)s=
m.offset,A=m.offsetSrc,m.size===1?(m.boundTo===void 0||m.boundTo==="vertices"?(m.array[s+0]=m.value[p.a],m.array[s+1]=m.value[p.b],m.array[s+2]=m.value[p.c],m.array[s+3]=m.value[p.d]):m.boundTo==="faces"?(m.array[s+0]=m.value[A],m.array[s+1]=m.value[A],m.array[s+2]=m.value[A],m.array[s+3]=m.value[A],m.offsetSrc++):m.boundTo==="faceVertices"&&(m.array[s+0]=m.value[A+0],m.array[s+1]=m.value[A+1],m.array[s+2]=m.value[A+2],m.array[s+3]=m.value[A+3],m.offsetSrc+=4),m.offset+=4):(m.boundTo===void 0||m.boundTo===
"vertices"?(x=m.value[p.a],J=m.value[p.b],I=m.value[p.c],E=m.value[p.d]):m.boundTo==="faces"?(x=m.value[A],J=m.value[A],I=m.value[A],E=m.value[A],m.offsetSrc++):m.boundTo==="faceVertices"&&(x=m.value[A+0],J=m.value[A+1],I=m.value[A+2],E=m.value[A+3],m.offsetSrc+=4),m.size===2?(m.array[s+0]=x.x,m.array[s+1]=x.y,m.array[s+2]=J.x,m.array[s+3]=J.y,m.array[s+4]=I.x,m.array[s+5]=I.y,m.array[s+6]=E.x,m.array[s+7]=E.y,m.offset+=8):m.size===3?(m.type==="c"?(m.array[s+0]=x.r,m.array[s+1]=x.g,m.array[s+2]=x.b,
m.array[s+3]=J.r,m.array[s+4]=J.g,m.array[s+5]=J.b,m.array[s+6]=I.r,m.array[s+7]=I.g,m.array[s+8]=I.b,m.array[s+9]=E.r,m.array[s+10]=E.g,m.array[s+11]=E.b):(m.array[s+0]=x.x,m.array[s+1]=x.y,m.array[s+2]=x.z,m.array[s+3]=J.x,m.array[s+4]=J.y,m.array[s+5]=J.z,m.array[s+6]=I.x,m.array[s+7]=I.y,m.array[s+8]=I.z,m.array[s+9]=E.x,m.array[s+10]=E.y,m.array[s+11]=E.z),m.offset+=12):(m.array[s+0]=x.x,m.array[s+1]=x.y,m.array[s+2]=x.z,m.array[s+3]=x.w,m.array[s+4]=J.x,m.array[s+5]=J.y,m.array[s+6]=J.z,m.array[s+
7]=J.w,m.array[s+8]=I.x,m.array[s+9]=I.y,m.array[s+10]=I.z,m.array[s+11]=I.w,m.array[s+12]=E.x,m.array[s+13]=E.y,m.array[s+14]=E.z,m.array[s+15]=E.w,m.offset+=16));if(sa){s=0;for(A=Aa.length;s<A;s++)x=Aa[s].vertices[p.a].position,J=Aa[s].vertices[p.b].position,I=Aa[s].vertices[p.c].position,E=Aa[s].vertices[p.d].position,m=ea[s],m[da+0]=x.x,m[da+1]=x.y,m[da+2]=x.z,m[da+3]=J.x,m[da+4]=J.y,m[da+5]=J.z,m[da+6]=I.x,m[da+7]=I.y,m[da+8]=I.z,m[da+9]=E.x,m[da+10]=E.y,m[da+11]=E.z;da+=12}if(Ba.length)s=Ba[p.a],
A=Ba[p.b],m=Ba[p.c],F=Ba[p.d],Z[w]=s.x,Z[w+1]=s.y,Z[w+2]=s.z,Z[w+3]=s.w,Z[w+4]=A.x,Z[w+5]=A.y,Z[w+6]=A.z,Z[w+7]=A.w,Z[w+8]=m.x,Z[w+9]=m.y,Z[w+10]=m.z,Z[w+11]=m.w,Z[w+12]=F.x,Z[w+13]=F.y,Z[w+14]=F.z,Z[w+15]=F.w,s=wa[p.a],A=wa[p.b],m=wa[p.c],F=wa[p.d],Y[w]=s.x,Y[w+1]=s.y,Y[w+2]=s.z,Y[w+3]=s.w,Y[w+4]=A.x,Y[w+5]=A.y,Y[w+6]=A.z,Y[w+7]=A.w,Y[w+8]=m.x,Y[w+9]=m.y,Y[w+10]=m.z,Y[w+11]=m.w,Y[w+12]=F.x,Y[w+13]=F.y,Y[w+14]=F.z,Y[w+15]=F.w,s=oa[p.a],A=oa[p.b],m=oa[p.c],F=oa[p.d],W[w]=s.x,W[w+1]=s.y,W[w+2]=s.z,
W[w+3]=1,W[w+4]=A.x,W[w+5]=A.y,W[w+6]=A.z,W[w+7]=1,W[w+8]=m.x,W[w+9]=m.y,W[w+10]=m.z,W[w+11]=1,W[w+12]=F.x,W[w+13]=F.y,W[w+14]=F.z,W[w+15]=1,s=ta[p.a],A=ta[p.b],m=ta[p.c],p=ta[p.d],X[w]=s.x,X[w+1]=s.y,X[w+2]=s.z,X[w+3]=1,X[w+4]=A.x,X[w+5]=A.y,X[w+6]=A.z,X[w+7]=1,X[w+8]=m.x,X[w+9]=m.y,X[w+10]=m.z,X[w+11]=1,X[w+12]=p.x,X[w+13]=p.y,X[w+14]=p.z,X[w+15]=1,w+=16;if(ra&&v)t.length==4&&v==THREE.VertexColors?(p=t[0],s=t[1],A=t[2],t=t[3]):t=A=s=p=u,ga[ca]=p.r,ga[ca+1]=p.g,ga[ca+2]=p.b,ga[ca+3]=s.r,ga[ca+4]=
s.g,ga[ca+5]=s.b,ga[ca+6]=A.r,ga[ca+7]=A.g,ga[ca+8]=A.b,ga[ca+9]=t.r,ga[ca+10]=t.g,ga[ca+11]=t.b,ca+=12;if(qa&&ja.hasTangents)t=r[0],u=r[1],p=r[2],r=r[3],V[U]=t.x,V[U+1]=t.y,V[U+2]=t.z,V[U+3]=t.w,V[U+4]=u.x,V[U+5]=u.y,V[U+6]=u.z,V[U+7]=u.w,V[U+8]=p.x,V[U+9]=p.y,V[U+10]=p.z,V[U+11]=p.w,V[U+12]=r.x,V[U+13]=r.y,V[U+14]=r.z,V[U+15]=r.w,U+=16;if(pa&&z)if(n.length==4&&la)for(r=0;r<4;r++)q=n[r],Q[K]=q.x,Q[K+1]=q.y,Q[K+2]=q.z,K+=3;else for(r=0;r<4;r++)Q[K]=q.x,Q[K+1]=q.y,Q[K+2]=q.z,K+=3;if(ha&&C!==void 0&&
y)for(r=0;r<4;r++)n=C[r],$[P]=n.u,$[P+1]=n.v,P+=2;if(ha&&D!==void 0&&y)for(r=0;r<4;r++)n=D[r],aa[T]=n.u,aa[T+1]=n.v,T+=2;na&&(N[L]=B,N[L+1]=B+1,N[L+2]=B+3,N[L+3]=B+1,N[L+4]=B+2,N[L+5]=B+3,L+=6,R[M]=B,R[M+1]=B+1,R[M+2]=B,R[M+3]=B+3,R[M+4]=B+1,R[M+5]=B+2,R[M+6]=B+2,R[M+7]=B+3,M+=8,B+=4)}if(Ca){k=0;for(o=Ca.length;k<o;k++)N[L]=Ca[k].a,N[L+1]=Ca[k].b,N[L+2]=Ca[k].c,N[L+3]=Ca[k].a,N[L+4]=Ca[k].c,N[L+5]=Ca[k].d,L+=6}ma&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglVertexBuffer),c.bufferData(c.ARRAY_BUFFER,fa,
j));if(S)for(H in S)m=S[H],m.__original.needsUpdate&&(c.bindBuffer(c.ARRAY_BUFFER,m.buffer),c.bufferData(c.ARRAY_BUFFER,m.array,j));if(sa){s=0;for(A=Aa.length;s<A;s++)c.bindBuffer(c.ARRAY_BUFFER,g.__webglMorphTargetsBuffers[s]),c.bufferData(c.ARRAY_BUFFER,ea[s],j)}ra&&ca>0&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglColorBuffer),c.bufferData(c.ARRAY_BUFFER,ga,j));pa&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglNormalBuffer),c.bufferData(c.ARRAY_BUFFER,Q,j));qa&&ja.hasTangents&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglTangentBuffer),
c.bufferData(c.ARRAY_BUFFER,V,j));ha&&P>0&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglUVBuffer),c.bufferData(c.ARRAY_BUFFER,$,j));ha&&T>0&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglUV2Buffer),c.bufferData(c.ARRAY_BUFFER,aa,j));na&&(c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,g.__webglFaceBuffer),c.bufferData(c.ELEMENT_ARRAY_BUFFER,N,j),c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,g.__webglLineBuffer),c.bufferData(c.ELEMENT_ARRAY_BUFFER,R,j));w>0&&(c.bindBuffer(c.ARRAY_BUFFER,g.__webglSkinVertexABuffer),c.bufferData(c.ARRAY_BUFFER,
W,j),c.bindBuffer(c.ARRAY_BUFFER,g.__webglSkinVertexBBuffer),c.bufferData(c.ARRAY_BUFFER,X,j),c.bindBuffer(c.ARRAY_BUFFER,g.__webglSkinIndicesBuffer),c.bufferData(c.ARRAY_BUFFER,Y,j),c.bindBuffer(c.ARRAY_BUFFER,g.__webglSkinWeightsBuffer),c.bufferData(c.ARRAY_BUFFER,Z,j));i.dynamic||(delete g.__inittedArrays,delete g.__colorArray,delete g.__normalArray,delete g.__tangentArray,delete g.__uvArray,delete g.__uv2Array,delete g.__faceArray,delete g.__vertexArray,delete g.__lineArray,delete g.__skinVertexAArray,
delete g.__skinVertexBArray,delete g.__skinIndexArray,delete g.__skinWeightArray)}}f.__dirtyVertices=!1;f.__dirtyMorphTargets=!1;f.__dirtyElements=!1;f.__dirtyUvs=!1;f.__dirtyNormals=!1;f.__dirtyTangents=!1;f.__dirtyColors=!1;var ka;h=h.__materials;f=0;for(b=h.length;f<b;f++)if(e=h[f],e.attributes)for(ka in e.attributes)e.attributes[ka].needsUpdate=!1}else if(b instanceof THREE.Ribbon){f=b.geometry;if(f.__dirtyVertices||f.__dirtyColors){ka=f;b=c.DYNAMIC_DRAW;o=ka.vertices;h=ka.colors;y=o.length;g=
h.length;v=ka.__vertexArray;i=ka.__colorArray;z=ka.__dirtyColors;if(ka.__dirtyVertices){for(j=0;j<y;j++)k=o[j].position,e=j*3,v[e]=k.x,v[e+1]=k.y,v[e+2]=k.z;c.bindBuffer(c.ARRAY_BUFFER,ka.__webglVertexBuffer);c.bufferData(c.ARRAY_BUFFER,v,b)}if(z){for(j=0;j<g;j++)color=h[j],e=j*3,i[e]=color.r,i[e+1]=color.g,i[e+2]=color.b;c.bindBuffer(c.ARRAY_BUFFER,ka.__webglColorBuffer);c.bufferData(c.ARRAY_BUFFER,i,b)}}f.__dirtyVertices=!1;f.__dirtyColors=!1}else if(b instanceof THREE.Line){f=b.geometry;if(f.__dirtyVertices||
f.__dirtyColors){ka=f;b=c.DYNAMIC_DRAW;o=ka.vertices;h=ka.colors;y=o.length;g=h.length;v=ka.__vertexArray;i=ka.__colorArray;z=ka.__dirtyColors;if(ka.__dirtyVertices){for(j=0;j<y;j++)k=o[j].position,e=j*3,v[e]=k.x,v[e+1]=k.y,v[e+2]=k.z;c.bindBuffer(c.ARRAY_BUFFER,ka.__webglVertexBuffer);c.bufferData(c.ARRAY_BUFFER,v,b)}if(z){for(j=0;j<g;j++)color=h[j],e=j*3,i[e]=color.r,i[e+1]=color.g,i[e+2]=color.b;c.bindBuffer(c.ARRAY_BUFFER,ka.__webglColorBuffer);c.bufferData(c.ARRAY_BUFFER,i,b)}}f.__dirtyVertices=
!1;f.__dirtyColors=!1}else if(b instanceof THREE.ParticleSystem)f=b.geometry,(f.__dirtyVertices||f.__dirtyColors||b.sortParticles)&&d(f,c.DYNAMIC_DRAW,b),f.__dirtyVertices=!1,f.__dirtyColors=!1}function ea(b,c){var e;for(e=b.length-1;e>=0;e--)b[e].object==c&&b.splice(e,1)}function S(b){function c(b){var f=[];e=0;for(d=b.length;e<d;e++)b[e]==void 0?f.push("undefined"):f.push(b[e].id);return f.join("_")}var e,d,f,g,h,i,j,k,p={},o=b.morphTargets!==void 0?b.morphTargets.length:0;b.geometryGroups={};f=
0;for(g=b.faces.length;f<g;f++)h=b.faces[f],i=h.materials,j=c(i),p[j]==void 0&&(p[j]={hash:j,counter:0}),k=p[j].hash+"_"+p[j].counter,b.geometryGroups[k]==void 0&&(b.geometryGroups[k]={faces:[],materials:i,vertices:0,numMorphTargets:o}),h=h instanceof THREE.Face3?3:4,b.geometryGroups[k].vertices+h>65535&&(p[j].counter+=1,k=p[j].hash+"_"+p[j].counter,b.geometryGroups[k]==void 0&&(b.geometryGroups[k]={faces:[],materials:i,vertices:0,numMorphTargets:o})),b.geometryGroups[k].faces.push(f),b.geometryGroups[k].vertices+=
h}function H(b,c,e){b.push({buffer:c,object:e,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function y(b){if(b!=F){switch(b){case THREE.AdditiveBlending:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.SRC_ALPHA,c.ONE);break;case THREE.SubtractiveBlending:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.ZERO,c.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:c.blendEquation(c.FUNC_ADD);c.blendFunc(c.ZERO,c.SRC_COLOR);break;default:c.blendEquationSeparate(c.FUNC_ADD,c.FUNC_ADD),c.blendFuncSeparate(c.SRC_ALPHA,
c.ONE_MINUS_SRC_ALPHA,c.ONE,c.ONE_MINUS_SRC_ALPHA)}F=b}}function aa(b,e,d){(d.width&d.width-1)==0&&(d.height&d.height-1)==0?(c.texParameteri(b,c.TEXTURE_WRAP_S,K(e.wrapS)),c.texParameteri(b,c.TEXTURE_WRAP_T,K(e.wrapT)),c.texParameteri(b,c.TEXTURE_MAG_FILTER,K(e.magFilter)),c.texParameteri(b,c.TEXTURE_MIN_FILTER,K(e.minFilter)),c.generateMipmap(b)):(c.texParameteri(b,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(b,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE),c.texParameteri(b,c.TEXTURE_MAG_FILTER,ua(e.magFilter)),
c.texParameteri(b,c.TEXTURE_MIN_FILTER,ua(e.minFilter)))}function P(b,e){if(b.needsUpdate)b.__webglInit?(c.bindTexture(c.TEXTURE_2D,b.__webglTexture),c.texImage2D(c.TEXTURE_2D,0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,b.image)):(b.__webglTexture=c.createTexture(),c.bindTexture(c.TEXTURE_2D,b.__webglTexture),c.texImage2D(c.TEXTURE_2D,0,c.RGBA,c.RGBA,c.UNSIGNED_BYTE,b.image),b.__webglInit=!0),aa(c.TEXTURE_2D,b,b.image),c.bindTexture(c.TEXTURE_2D,null),b.needsUpdate=!1;c.activeTexture(c.TEXTURE0+e);c.bindTexture(c.TEXTURE_2D,
b.__webglTexture)}function Q(b){if(b&&!b.__webglFramebuffer){if(b.depthBuffer===void 0)b.depthBuffer=!0;if(b.stencilBuffer===void 0)b.stencilBuffer=!0;b.__webglFramebuffer=c.createFramebuffer();b.__webglRenderbuffer=c.createRenderbuffer();b.__webglTexture=c.createTexture();c.bindTexture(c.TEXTURE_2D,b.__webglTexture);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,K(b.wrapS));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,K(b.wrapT));c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,K(b.magFilter));
c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,K(b.minFilter));c.texImage2D(c.TEXTURE_2D,0,K(b.format),b.width,b.height,0,K(b.format),K(b.type),null);c.bindRenderbuffer(c.RENDERBUFFER,b.__webglRenderbuffer);c.bindFramebuffer(c.FRAMEBUFFER,b.__webglFramebuffer);c.framebufferTexture2D(c.FRAMEBUFFER,c.COLOR_ATTACHMENT0,c.TEXTURE_2D,b.__webglTexture,0);b.depthBuffer&&!b.stencilBuffer?(c.renderbufferStorage(c.RENDERBUFFER,c.DEPTH_COMPONENT16,b.width,b.height),c.framebufferRenderbuffer(c.FRAMEBUFFER,
c.DEPTH_ATTACHMENT,c.RENDERBUFFER,b.__webglRenderbuffer)):b.depthBuffer&&b.stencilBuffer?(c.renderbufferStorage(c.RENDERBUFFER,c.DEPTH_STENCIL,b.width,b.height),c.framebufferRenderbuffer(c.FRAMEBUFFER,c.DEPTH_STENCIL_ATTACHMENT,c.RENDERBUFFER,b.__webglRenderbuffer)):c.renderbufferStorage(c.RENDERBUFFER,c.RGBA4,b.width,b.height);c.bindTexture(c.TEXTURE_2D,null);c.bindRenderbuffer(c.RENDERBUFFER,null);c.bindFramebuffer(c.FRAMEBUFFER,null)}var e,d;b?(e=b.__webglFramebuffer,d=b.width,b=b.height):(e=null,
d=va,b=qa);e!=ha&&(c.bindFramebuffer(c.FRAMEBUFFER,e),c.viewport(G,xa,d,b),ha=e)}function B(b,e){var d;b=="fragment"?d=c.createShader(c.FRAGMENT_SHADER):b=="vertex"&&(d=c.createShader(c.VERTEX_SHADER));c.shaderSource(d,e);c.compileShader(d);if(!c.getShaderParameter(d,c.COMPILE_STATUS))return console.error(c.getShaderInfoLog(d)),console.error(e),null;return d}function ua(b){switch(b){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return c.NEAREST;
default:return c.LINEAR}}function K(b){switch(b){case THREE.RepeatWrapping:return c.REPEAT;case THREE.ClampToEdgeWrapping:return c.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return c.MIRRORED_REPEAT;case THREE.NearestFilter:return c.NEAREST;case THREE.NearestMipMapNearestFilter:return c.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return c.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return c.LINEAR;case THREE.LinearMipMapNearestFilter:return c.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return c.LINEAR_MIPMAP_LINEAR;
case THREE.ByteType:return c.BYTE;case THREE.UnsignedByteType:return c.UNSIGNED_BYTE;case THREE.ShortType:return c.SHORT;case THREE.UnsignedShortType:return c.UNSIGNED_SHORT;case THREE.IntType:return c.INT;case THREE.UnsignedShortType:return c.UNSIGNED_INT;case THREE.FloatType:return c.FLOAT;case THREE.AlphaFormat:return c.ALPHA;case THREE.RGBFormat:return c.RGB;case THREE.RGBAFormat:return c.RGBA;case THREE.LuminanceFormat:return c.LUMINANCE;case THREE.LuminanceAlphaFormat:return c.LUMINANCE_ALPHA}return 0}
var L=this,c,sa=[],la=null,ha=null,ma=!0,M=null,na=null,F=null,$=null,T=null,R=null,pa=null,G=0,xa=0,va=0,qa=0,ra=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],ia=new THREE.Matrix4,ta=new Float32Array(16),ya=new Float32Array(16),Da=new THREE.Vector4,Ga={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}},b=b||{},wa=b.canvas!==void 0?b.canvas:document.createElement("canvas"),
Fa=b.stencil!==void 0?b.stencil:!0,Ka=b.antialias!==void 0?b.antialias:!1,oa=b.clearColor!==void 0?new THREE.Color(b.clearColor):new THREE.Color(0),Ea=b.clearAlpha!==void 0?b.clearAlpha:0;this.data={vertices:0,faces:0,drawCalls:0};this.maxMorphTargets=8;this.domElement=wa;this.sortObjects=this.autoClear=!0;try{if(!(c=wa.getContext("experimental-webgl",{antialias:Ka,stencil:Fa})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+c.getParameter(c.VERSION)+" | "+c.getParameter(c.VENDOR)+
" | "+c.getParameter(c.RENDERER)+" | "+c.getParameter(c.SHADING_LANGUAGE_VERSION))}catch(La){console.error(La)}c.clearColor(0,0,0,1);c.clearDepth(1);c.enable(c.DEPTH_TEST);c.depthFunc(c.LEQUAL);c.frontFace(c.CCW);c.cullFace(c.BACK);c.enable(c.CULL_FACE);c.enable(c.BLEND);c.blendEquation(c.FUNC_ADD);c.blendFunc(c.SRC_ALPHA,c.ONE_MINUS_SRC_ALPHA);c.clearColor(oa.r,oa.g,oa.b,Ea);this.context=c;var Ja=c.getParameter(c.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0;if(Fa){var x={};x.vertices=new Float32Array(12);x.faces=
new Uint16Array(6);x.darkness=0.5;x.vertices[0]=-20;x.vertices[1]=-20;x.vertices[2]=-1;x.vertices[3]=20;x.vertices[4]=-20;x.vertices[5]=-1;x.vertices[6]=20;x.vertices[7]=20;x.vertices[8]=-1;x.vertices[9]=-20;x.vertices[10]=20;x.vertices[11]=-1;x.faces[0]=0;x.faces[1]=1;x.faces[2]=2;x.faces[3]=0;x.faces[4]=2;x.faces[5]=3;x.vertexBuffer=c.createBuffer();x.elementBuffer=c.createBuffer();c.bindBuffer(c.ARRAY_BUFFER,x.vertexBuffer);c.bufferData(c.ARRAY_BUFFER,x.vertices,c.STATIC_DRAW);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,
x.elementBuffer);c.bufferData(c.ELEMENT_ARRAY_BUFFER,x.faces,c.STATIC_DRAW);x.program=c.createProgram();c.attachShader(x.program,B("fragment",THREE.ShaderLib.shadowPost.fragmentShader));c.attachShader(x.program,B("vertex",THREE.ShaderLib.shadowPost.vertexShader));c.linkProgram(x.program);x.vertexLocation=c.getAttribLocation(x.program,"position");x.projectionLocation=c.getUniformLocation(x.program,"projectionMatrix");x.darknessLocation=c.getUniformLocation(x.program,"darkness")}var v={};v.vertices=
new Float32Array(16);v.faces=new Uint16Array(6);b=0;v.vertices[b++]=-1;v.vertices[b++]=-1;v.vertices[b++]=0;v.vertices[b++]=0;v.vertices[b++]=1;v.vertices[b++]=-1;v.vertices[b++]=1;v.vertices[b++]=0;v.vertices[b++]=1;v.vertices[b++]=1;v.vertices[b++]=1;v.vertices[b++]=1;v.vertices[b++]=-1;v.vertices[b++]=1;v.vertices[b++]=0;v.vertices[b++]=1;b=0;v.faces[b++]=0;v.faces[b++]=1;v.faces[b++]=2;v.faces[b++]=0;v.faces[b++]=2;v.faces[b++]=3;v.vertexBuffer=c.createBuffer();v.elementBuffer=c.createBuffer();
v.tempTexture=c.createTexture();v.occlusionTexture=c.createTexture();c.bindBuffer(c.ARRAY_BUFFER,v.vertexBuffer);c.bufferData(c.ARRAY_BUFFER,v.vertices,c.STATIC_DRAW);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,v.elementBuffer);c.bufferData(c.ELEMENT_ARRAY_BUFFER,v.faces,c.STATIC_DRAW);c.bindTexture(c.TEXTURE_2D,v.tempTexture);c.texImage2D(c.TEXTURE_2D,0,c.RGB,16,16,0,c.RGB,c.UNSIGNED_BYTE,null);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE);
c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.NEAREST);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.NEAREST);c.bindTexture(c.TEXTURE_2D,v.occlusionTexture);c.texImage2D(c.TEXTURE_2D,0,c.RGBA,16,16,0,c.RGBA,c.UNSIGNED_BYTE,null);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.NEAREST);c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.NEAREST);c.getParameter(c.MAX_VERTEX_TEXTURE_IMAGE_UNITS)<=
0?(v.hasVertexTexture=!1,v.program=c.createProgram(),c.attachShader(v.program,B("fragment",THREE.ShaderLib.lensFlare.fragmentShader)),c.attachShader(v.program,B("vertex",THREE.ShaderLib.lensFlare.vertexShader))):(v.hasVertexTexture=!0,v.program=c.createProgram(),c.attachShader(v.program,B("fragment",THREE.ShaderLib.lensFlareVertexTexture.fragmentShader)),c.attachShader(v.program,B("vertex",THREE.ShaderLib.lensFlareVertexTexture.vertexShader)));c.linkProgram(v.program);v.attributes={};v.uniforms={};
v.attributes.vertex=c.getAttribLocation(v.program,"position");v.attributes.uv=c.getAttribLocation(v.program,"UV");v.uniforms.renderType=c.getUniformLocation(v.program,"renderType");v.uniforms.map=c.getUniformLocation(v.program,"map");v.uniforms.occlusionMap=c.getUniformLocation(v.program,"occlusionMap");v.uniforms.opacity=c.getUniformLocation(v.program,"opacity");v.uniforms.scale=c.getUniformLocation(v.program,"scale");v.uniforms.rotation=c.getUniformLocation(v.program,"rotation");v.uniforms.screenPosition=
c.getUniformLocation(v.program,"screenPosition");var Ia=!1,r={};r.vertices=new Float32Array(16);r.faces=new Uint16Array(6);b=0;r.vertices[b++]=-1;r.vertices[b++]=-1;r.vertices[b++]=0;r.vertices[b++]=1;r.vertices[b++]=1;r.vertices[b++]=-1;r.vertices[b++]=1;r.vertices[b++]=1;r.vertices[b++]=1;r.vertices[b++]=1;r.vertices[b++]=1;r.vertices[b++]=0;r.vertices[b++]=-1;r.vertices[b++]=1;r.vertices[b++]=0;b=r.vertices[b++]=0;r.faces[b++]=0;r.faces[b++]=1;r.faces[b++]=2;r.faces[b++]=0;r.faces[b++]=2;r.faces[b++]=
3;r.vertexBuffer=c.createBuffer();r.elementBuffer=c.createBuffer();c.bindBuffer(c.ARRAY_BUFFER,r.vertexBuffer);c.bufferData(c.ARRAY_BUFFER,r.vertices,c.STATIC_DRAW);c.bindBuffer(c.ELEMENT_ARRAY_BUFFER,r.elementBuffer);c.bufferData(c.ELEMENT_ARRAY_BUFFER,r.faces,c.STATIC_DRAW);r.program=c.createProgram();c.attachShader(r.program,B("fragment",THREE.ShaderLib.sprite.fragmentShader));c.attachShader(r.program,B("vertex",THREE.ShaderLib.sprite.vertexShader));c.linkProgram(r.program);r.attributes={};r.uniforms=
{};r.attributes.position=c.getAttribLocation(r.program,"position");r.attributes.uv=c.getAttribLocation(r.program,"uv");r.uniforms.uvOffset=c.getUniformLocation(r.program,"uvOffset");r.uniforms.uvScale=c.getUniformLocation(r.program,"uvScale");r.uniforms.rotation=c.getUniformLocation(r.program,"rotation");r.uniforms.scale=c.getUniformLocation(r.program,"scale");r.uniforms.alignment=c.getUniformLocation(r.program,"alignment");r.uniforms.map=c.getUniformLocation(r.program,"map");r.uniforms.opacity=c.getUniformLocation(r.program,
"opacity");r.uniforms.useScreenCoordinates=c.getUniformLocation(r.program,"useScreenCoordinates");r.uniforms.affectedByDistance=c.getUniformLocation(r.program,"affectedByDistance");r.uniforms.screenPosition=c.getUniformLocation(r.program,"screenPosition");r.uniforms.modelViewMatrix=c.getUniformLocation(r.program,"modelViewMatrix");r.uniforms.projectionMatrix=c.getUniformLocation(r.program,"projectionMatrix");var Ha=!1;this.setSize=function(b,c){wa.width=b;wa.height=c;this.setViewport(0,0,wa.width,
wa.height)};this.setViewport=function(b,e,d,f){G=b;xa=e;va=d;qa=f;c.viewport(G,xa,va,qa)};this.setScissor=function(b,e,d,f){c.scissor(b,e,d,f)};this.enableScissorTest=function(b){b?c.enable(c.SCISSOR_TEST):c.disable(c.SCISSOR_TEST)};this.enableDepthBufferWrite=function(b){ma=b;c.depthMask(b)};this.setClearColorHex=function(b,e){oa.setHex(b);Ea=e;c.clearColor(oa.r,oa.g,oa.b,Ea)};this.setClearColor=function(b,e){oa.copy(b);Ea=e;c.clearColor(oa.r,oa.g,oa.b,Ea)};this.clear=function(){c.clear(c.COLOR_BUFFER_BIT|
c.DEPTH_BUFFER_BIT|c.STENCIL_BUFFER_BIT)};this.setStencilShadowDarkness=function(b){x.darkness=b};this.getContext=function(){return c};this.initMaterial=function(b,e,d,f){var g,h,i;b instanceof THREE.MeshDepthMaterial?i="depth":b instanceof THREE.ShadowVolumeDynamicMaterial?i="shadowVolumeDynamic":b instanceof THREE.MeshNormalMaterial?i="normal":b instanceof THREE.MeshBasicMaterial?i="basic":b instanceof THREE.MeshLambertMaterial?i="lambert":b instanceof THREE.MeshPhongMaterial?i="phong":b instanceof
THREE.LineBasicMaterial?i="basic":b instanceof THREE.ParticleBasicMaterial&&(i="particle_basic");if(i){var j=THREE.ShaderLib[i];b.uniforms=THREE.UniformsUtils.clone(j.uniforms);b.vertexShader=j.vertexShader;b.fragmentShader=j.fragmentShader}var k,o,p;k=p=j=0;for(o=e.length;k<o;k++)h=e[k],h instanceof THREE.DirectionalLight&&p++,h instanceof THREE.PointLight&&j++;j+p<=4?e=p:(e=Math.ceil(4*p/(j+p)),j=4-e);h={directional:e,point:j};p=50;if(f!==void 0&&f instanceof THREE.SkinnedMesh)p=f.bones.length;
var n;a:{k=b.fragmentShader;o=b.vertexShader;var j=b.uniforms,e=b.attributes,d={map:!!b.map,envMap:!!b.envMap,lightMap:!!b.lightMap,vertexColors:b.vertexColors,fog:d,sizeAttenuation:b.sizeAttenuation,skinning:b.skinning,morphTargets:b.morphTargets,maxMorphTargets:this.maxMorphTargets,maxDirLights:h.directional,maxPointLights:h.point,maxBones:p},q;h=[];i?h.push(i):(h.push(k),h.push(o));for(q in d)h.push(q),h.push(d[q]);i=h.join();q=0;for(h=sa.length;q<h;q++)if(sa[q].code==i){n=sa[q].program;break a}q=
c.createProgram();h=[Ja?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_BONES "+d.maxBones,d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.skinning?"#define USE_SKINNING":"",d.morphTargets?"#define USE_MORPHTARGETS":"",d.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
p=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,d.fog?"#define USE_FOG":"",d.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");c.attachShader(q,B("fragment",p+k));c.attachShader(q,B("vertex",h+o));c.linkProgram(q);
c.getProgramParameter(q,c.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+c.getProgramParameter(q,c.VALIDATE_STATUS)+", gl error ["+c.getError()+"]");q.uniforms={};q.attributes={};var t;k=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(t in j)k.push(t);t=k;j=0;for(k=t.length;j<k;j++)o=t[j],q.uniforms[o]=c.getUniformLocation(q,o);k=["position","normal",
"uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(t=0;t<d.maxMorphTargets;t++)k.push("morphTarget"+t);for(n in e)k.push(n);n=k;t=0;for(e=n.length;t<e;t++)d=n[t],q.attributes[d]=c.getAttribLocation(q,d);sa.push({program:q,code:i});n=q}b.program=n;n=b.program.attributes;n.position>=0&&c.enableVertexAttribArray(n.position);n.color>=0&&c.enableVertexAttribArray(n.color);n.normal>=0&&c.enableVertexAttribArray(n.normal);n.tangent>=0&&c.enableVertexAttribArray(n.tangent);
b.skinning&&n.skinVertexA>=0&&n.skinVertexB>=0&&n.skinIndex>=0&&n.skinWeight>=0&&(c.enableVertexAttribArray(n.skinVertexA),c.enableVertexAttribArray(n.skinVertexB),c.enableVertexAttribArray(n.skinIndex),c.enableVertexAttribArray(n.skinWeight));if(b.attributes)for(g in b.attributes)n[g]!==void 0&&n[g]>=0&&c.enableVertexAttribArray(n[g]);if(b.morphTargets){b.numSupportedMorphTargets=0;n.morphTarget0>=0&&(c.enableVertexAttribArray(n.morphTarget0),b.numSupportedMorphTargets++);n.morphTarget1>=0&&(c.enableVertexAttribArray(n.morphTarget1),
b.numSupportedMorphTargets++);n.morphTarget2>=0&&(c.enableVertexAttribArray(n.morphTarget2),b.numSupportedMorphTargets++);n.morphTarget3>=0&&(c.enableVertexAttribArray(n.morphTarget3),b.numSupportedMorphTargets++);n.morphTarget4>=0&&(c.enableVertexAttribArray(n.morphTarget4),b.numSupportedMorphTargets++);n.morphTarget5>=0&&(c.enableVertexAttribArray(n.morphTarget5),b.numSupportedMorphTargets++);n.morphTarget6>=0&&(c.enableVertexAttribArray(n.morphTarget6),b.numSupportedMorphTargets++);n.morphTarget7>=
0&&(c.enableVertexAttribArray(n.morphTarget7),b.numSupportedMorphTargets++);f.__webglMorphTargetInfluences=new Float32Array(this.maxMorphTargets);b=0;for(g=this.maxMorphTargets;b<g;b++)f.__webglMorphTargetInfluences[b]=0}};this.render=function(b,d,q,r){var v,x,za,B,F,G,p,O,H=b.lights,K=b.fog;L.data.vertices=0;L.data.faces=0;L.data.drawCalls=0;d.matrixAutoUpdate&&d.update(void 0,!0);b.update(void 0,!1,d);d.matrixWorldInverse.flattenToArray(ya);d.projectionMatrix.flattenToArray(ta);ia.multiply(d.projectionMatrix,
d.matrixWorldInverse);k(ia);this.initWebGLObjects(b);Q(q);(this.autoClear||r)&&this.clear();F=b.__webglObjects.length;for(r=0;r<F;r++)if(v=b.__webglObjects[r],p=v.object,p.visible)if(!(p instanceof THREE.Mesh)||o(p)){if(p.matrixWorld.flattenToArray(p._objectMatrixArray),C(p,d),t(v),v.render=!0,this.sortObjects)v.object.renderDepth?v.z=v.object.renderDepth:(Da.copy(p.position),ia.multiplyVector3(Da),v.z=Da.z)}else v.render=!1;else v.render=!1;this.sortObjects&&b.__webglObjects.sort(u);G=b.__webglObjectsImmediate.length;
for(r=0;r<G;r++)v=b.__webglObjectsImmediate[r],p=v.object,p.visible&&(p.matrixAutoUpdate&&p.matrixWorld.flattenToArray(p._objectMatrixArray),C(p,d),n(v));if(b.overrideMaterial){h(b.overrideMaterial.depthTest);y(b.overrideMaterial.blending);for(r=0;r<F;r++)if(v=b.__webglObjects[r],v.render)p=v.object,O=v.buffer,i(p),f(d,H,K,b.overrideMaterial,O,p);for(r=0;r<G;r++)v=b.__webglObjectsImmediate[r],p=v.object,p.visible&&(i(p),x=e(d,H,K,b.overrideMaterial,p),p.render(function(c){g(c,x,b.overrideMaterial.shading)}))}else{y(THREE.NormalBlending);
for(r=0;r<F;r++)if(v=b.__webglObjects[r],v.render){p=v.object;O=v.buffer;za=v.opaque;i(p);for(v=0;v<za.count;v++)B=za.list[v],h(B.depthTest),j(B.polygonOffset,B.polygonOffsetFactor,B.polygonOffsetUnits),f(d,H,K,B,O,p)}for(r=0;r<G;r++)if(v=b.__webglObjectsImmediate[r],p=v.object,p.visible){za=v.opaque;i(p);for(v=0;v<za.count;v++)B=za.list[v],h(B.depthTest),j(B.polygonOffset,B.polygonOffsetFactor,B.polygonOffsetUnits),x=e(d,H,K,B,p),p.render(function(b){g(b,x,B.shading)})}for(r=0;r<F;r++)if(v=b.__webglObjects[r],
v.render){p=v.object;O=v.buffer;za=v.transparent;i(p);for(v=0;v<za.count;v++)B=za.list[v],y(B.blending),h(B.depthTest),j(B.polygonOffset,B.polygonOffsetFactor,B.polygonOffsetUnits),f(d,H,K,B,O,p)}for(r=0;r<G;r++)if(v=b.__webglObjectsImmediate[r],p=v.object,p.visible){za=v.transparent;i(p);for(v=0;v<za.count;v++)B=za.list[v],y(B.blending),h(B.depthTest),j(B.polygonOffset,B.polygonOffsetFactor,B.polygonOffsetUnits),x=e(d,H,K,B,p),p.render(function(b){g(b,x,B.shading)})}}b.__webglSprites.length&&D(b,
d);Fa&&b.__webglShadowVolumes.length&&b.lights.length&&z(b);b.__webglLensFlares.length&&E(b,d);q&&q.minFilter!==THREE.NearestFilter&&q.minFilter!==THREE.LinearFilter&&(c.bindTexture(c.TEXTURE_2D,q.__webglTexture),c.generateMipmap(c.TEXTURE_2D),c.bindTexture(c.TEXTURE_2D,null))};this.initWebGLObjects=function(b){if(!b.__webglObjects)b.__webglObjects=[],b.__webglObjectsImmediate=[],b.__webglShadowVolumes=[],b.__webglLensFlares=[],b.__webglSprites=[];for(;b.__objectsAdded.length;){var d=b.__objectsAdded[0],
e=b,f=void 0,g=void 0,h=void 0;if(d._modelViewMatrix==void 0)d._modelViewMatrix=new THREE.Matrix4,d._normalMatrixArray=new Float32Array(9),d._modelViewMatrixArray=new Float32Array(16),d._objectMatrixArray=new Float32Array(16),d.matrixWorld.flattenToArray(d._objectMatrixArray);if(d instanceof THREE.Mesh)for(f in g=d.geometry,g.geometryGroups==void 0&&S(g),g.geometryGroups){h=g.geometryGroups[f];if(!h.__webglVertexBuffer){var i=h;i.__webglVertexBuffer=c.createBuffer();i.__webglNormalBuffer=c.createBuffer();
i.__webglTangentBuffer=c.createBuffer();i.__webglColorBuffer=c.createBuffer();i.__webglUVBuffer=c.createBuffer();i.__webglUV2Buffer=c.createBuffer();i.__webglSkinVertexABuffer=c.createBuffer();i.__webglSkinVertexBBuffer=c.createBuffer();i.__webglSkinIndicesBuffer=c.createBuffer();i.__webglSkinWeightsBuffer=c.createBuffer();i.__webglFaceBuffer=c.createBuffer();i.__webglLineBuffer=c.createBuffer();if(i.numMorphTargets){var j=void 0,k=void 0;i.__webglMorphTargetsBuffers=[];j=0;for(k=i.numMorphTargets;j<
k;j++)i.__webglMorphTargetsBuffers.push(c.createBuffer())}for(var i=h,j=d,n=void 0,p=void 0,o=void 0,q=o=void 0,r=void 0,t=void 0,v=t=k=0,u=o=p=void 0,x=u=p=n=void 0,o=void 0,q=j.geometry,r=q.faces,u=i.faces,n=0,p=u.length;n<p;n++)o=u[n],o=r[o],o instanceof THREE.Face3?(k+=3,t+=1,v+=3):o instanceof THREE.Face4&&(k+=4,t+=2,v+=4);for(var n=i,p=j,y=u=r=void 0,z=void 0,y=void 0,o=[],r=0,u=p.materials.length;r<u;r++)if(y=p.materials[r],y instanceof THREE.MeshFaceMaterial){y=0;for(l=n.materials.length;y<
l;y++)(z=n.materials[y])&&o.push(z)}else(z=y)&&o.push(z);n=o;i.__materials=n;a:{r=p=void 0;u=n.length;for(p=0;p<u;p++)if(r=n[p],r.map||r.lightMap||r instanceof THREE.MeshShaderMaterial){p=!0;break a}p=!1}a:{u=r=void 0;o=n.length;for(r=0;r<o;r++)if(u=n[r],!(u instanceof THREE.MeshBasicMaterial&&!u.envMap||u instanceof THREE.MeshDepthMaterial)){u=u&&u.shading!=void 0&&u.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;break a}u=!1}a:{o=r=void 0;y=n.length;for(r=0;r<y;r++)if(o=n[r],
o.vertexColors){o=o.vertexColors;break a}o=!1}i.__vertexArray=new Float32Array(k*3);if(u)i.__normalArray=new Float32Array(k*3);if(q.hasTangents)i.__tangentArray=new Float32Array(k*4);if(o)i.__colorArray=new Float32Array(k*3);if(p){if(q.faceUvs.length>0||q.faceVertexUvs.length>0)i.__uvArray=new Float32Array(k*2);if(q.faceUvs.length>1||q.faceVertexUvs.length>1)i.__uv2Array=new Float32Array(k*2)}if(j.geometry.skinWeights.length&&j.geometry.skinIndices.length)i.__skinVertexAArray=new Float32Array(k*4),
i.__skinVertexBArray=new Float32Array(k*4),i.__skinIndexArray=new Float32Array(k*4),i.__skinWeightArray=new Float32Array(k*4);i.__faceArray=new Uint16Array(t*3+(j.geometry.edgeFaces?j.geometry.edgeFaces.length*6:0));i.__lineArray=new Uint16Array(v*2);if(i.numMorphTargets){i.__morphTargetsArrays=[];q=0;for(r=i.numMorphTargets;q<r;q++)i.__morphTargetsArrays.push(new Float32Array(k*3))}i.__needsSmoothNormals=u==THREE.SmoothShading;i.__uvType=p;i.__vertexColorType=o;i.__normalType=u;i.__webglFaceCount=
t*3+(j.geometry.edgeFaces?j.geometry.edgeFaces.length*6:0);i.__webglLineCount=v*2;q=0;for(r=n.length;q<r;q++)if(p=n[q],p.attributes)for(a in i.__webglCustomAttributes={},p.attributes){o=p.attributes[a];u={};for(x in o)u[x]=o[x];if(!u.__webglInitialized||u.createUniqueBuffers)u.__webglInitialized=!0,t=1,u.type==="v2"?t=2:u.type==="v3"?t=3:u.type==="v4"?t=4:u.type==="c"&&(t=3),u.size=t,u.array=new Float32Array(k*t),u.buffer=c.createBuffer(),u.buffer.belongsToAttribute=a,o.needsUpdate=!0,u.__original=
o;i.__webglCustomAttributes[a]=u}i.__inittedArrays=!0;g.__dirtyVertices=!0;g.__dirtyMorphTargets=!0;g.__dirtyElements=!0;g.__dirtyUvs=!0;g.__dirtyNormals=!0;g.__dirtyTangents=!0;g.__dirtyColors=!0}d instanceof THREE.ShadowVolume?H(e.__webglShadowVolumes,h,d):H(e.__webglObjects,h,d)}else if(d instanceof THREE.LensFlare)H(e.__webglLensFlares,void 0,d);else if(d instanceof THREE.Ribbon){g=d.geometry;if(!g.__webglVertexBuffer)f=g,f.__webglVertexBuffer=c.createBuffer(),f.__webglColorBuffer=c.createBuffer(),
f=g,h=f.vertices.length,f.__vertexArray=new Float32Array(h*3),f.__colorArray=new Float32Array(h*3),f.__webglVertexCount=h,g.__dirtyVertices=!0,g.__dirtyColors=!0;H(e.__webglObjects,g,d)}else if(d instanceof THREE.Line){g=d.geometry;if(!g.__webglVertexBuffer)f=g,f.__webglVertexBuffer=c.createBuffer(),f.__webglColorBuffer=c.createBuffer(),f=g,h=f.vertices.length,f.__vertexArray=new Float32Array(h*3),f.__colorArray=new Float32Array(h*3),f.__webglLineCount=h,g.__dirtyVertices=!0,g.__dirtyColors=!0;H(e.__webglObjects,
g,d)}else if(d instanceof THREE.ParticleSystem){g=d.geometry;if(!g.__webglVertexBuffer)f=g,f.__webglVertexBuffer=c.createBuffer(),f.__webglColorBuffer=c.createBuffer(),f=g,h=f.vertices.length,f.__vertexArray=new Float32Array(h*3),f.__colorArray=new Float32Array(h*3),f.__sortArray=[],f.__webglParticleCount=h,g.__dirtyVertices=!0,g.__dirtyColors=!0;H(e.__webglObjects,g,d)}else THREE.MarchingCubes!==void 0&&d instanceof THREE.MarchingCubes?e.__webglObjectsImmediate.push({object:d,opaque:{list:[],count:0},
transparent:{list:[],count:0}}):d instanceof THREE.Sprite&&e.__webglSprites.push(d);b.__objectsAdded.splice(0,1)}for(;b.__objectsRemoved.length;){e=b.__objectsRemoved[0];d=b;if(e instanceof THREE.ShadowVolume)ea(d.__webglShadowVolumes,e);else if(e instanceof THREE.Mesh||e instanceof THREE.ParticleSystem||e instanceof THREE.Ribbon||e instanceof THREE.Line)ea(d.__webglObjects,e);else if(e instanceof THREE.Sprite){d=d.__webglSprites;g=void 0;for(g=d.length-1;g>=0;g--)d[g]==e&&d.splice(g,1)}else e instanceof
THREE.LensFlare?ea(d.__webglLensFlares,e):e instanceof THREE.MarchingCubes&&ea(d.__webglObjectsImmediate,e);b.__objectsRemoved.splice(0,1)}d=0;for(e=b.__webglObjects.length;d<e;d++)N(b.__webglObjects[d].object,b);d=0;for(e=b.__webglShadowVolumes.length;d<e;d++)N(b.__webglShadowVolumes[d].object,b);d=0;for(e=b.__webglLensFlares.length;d<e;d++)N(b.__webglLensFlares[d].object,b)};this.setFaceCulling=function(b,d){b?(!d||d=="ccw"?c.frontFace(c.CCW):c.frontFace(c.CW),b=="back"?c.cullFace(c.BACK):b=="front"?
c.cullFace(c.FRONT):c.cullFace(c.FRONT_AND_BACK),c.enable(c.CULL_FACE)):c.disable(c.CULL_FACE)};this.supportsVertexTextures=function(){return Ja}};
THREE.WebGLRenderTarget=function(b,d,e){this.width=b;this.height=d;e=e||{};this.wrapS=e.wrapS!==void 0?e.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=e.wrapT!==void 0?e.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=e.magFilter!==void 0?e.magFilter:THREE.LinearFilter;this.minFilter=e.minFilter!==void 0?e.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=e.format!==void 0?e.format:THREE.RGBAFormat;this.type=e.type!==void 0?e.type:
THREE.UnsignedByteType;this.depthBuffer=e.depthBuffer!==void 0?e.depthBuffer:!0;this.stencilBuffer=e.stencilBuffer!==void 0?e.stencilBuffer:!0};
