// ThreeSVG.js r40 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;this.hex=a.hex;this.__styleString=a.__styleString},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,b,c){this.h=a;this.s=b;this.v=c;var d,e,h,f,i,g;if(c==0)d=e=h=0;else{f=Math.floor(a*6);i=a*6-f;a=c*(1-b);g=c*(1-b*i);b=c*(1-b*(1-i));switch(f){case 1:d=g;e=c;h=a;break;case 2:d=a;e=c;h=b;break;case 3:d=a;e=g;h=c;break;case 4:d=b;e=
a;h=c;break;case 5:d=c;e=a;h=g;break;case 6:case 0:d=c;e=b;h=a}}this.r=d;this.g=e;this.b=h;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},updateHSV:function(){this.v=this.s=this.h=0;var a=Math.max(Math.max(this.r,this.g),this.b),b=Math.min(Math.min(this.r,this.g),this.b),c;if(b==a)b=c=0;else{c=a-b;b=c/a;c=this.r==a?(this.g-this.b)/c:this.g==a?2+(this.b-this.r)/c:4+(this.r-this.g)/c;c/=6;c<0&&(c+=1);c>1&&(c-=1)}this.h=c;this.s=b;this.v=a},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();
this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
b){this.set(a.y*b.z-a.z*b.y,a.z*b.x-a.x*b.z,a.x*b.y-a.y*b.x);return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.set(c*a.z-d*a.y,d*a.x-b*a.z,b*a.y-c*a.x);return this},multiply:function(a,b){this.set(a.x*b.x,a.y*b.y,a.z*b.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,c=this.y-a.y;a=this.z-a.z;return b*b+c*c+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);if(Math.abs(b)>1.0E-5){this.x=Math.atan2(-a.n23/b,a.n33/b);this.z=Math.atan2(-a.n12/b,a.n11/b)}else{this.x=0;this.z=Math.atan2(a.n21,a.n22)}},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<
1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,b){this.set(a.x+b.x,a.y+b.y,a.z+b.z,a.w+b.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,b){this.set(a.x-b.x,a.y-b.y,a.z-b.z,a.w-b.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,b){this.set(this.x+(a.x-this.x)*b,this.y+(a.y-this.y)*b,this.z+(a.z-this.z)*b,this.w+(a.w-this.w)*b)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var b,c,d=a.objects,e=[];a=0;for(b=d.length;a<b;a++){c=d[a];c instanceof THREE.Mesh&&(e=e.concat(this.intersectObject(c)))}e.sort(function(h,f){return h.distance-f.distance});return e},intersectObject:function(a){function b(y,u,H,I){I=I.clone().subSelf(u);H=H.clone().subSelf(u);var D=y.clone().subSelf(u);y=I.dot(I);u=I.dot(H);I=I.dot(D);var w=H.dot(H);H=H.dot(D);D=1/(y*w-u*u);w=(w*I-u*H)*D;y=(y*H-u*I)*D;return w>0&&y>0&&w+y<1}var c,d,e,h,f,i,g,j,m,k,
n,l=a.geometry,r=l.vertices,s=[];c=0;for(d=l.faces.length;c<d;c++){e=l.faces[c];k=this.origin.clone();n=this.direction.clone();g=a.matrixWorld;h=g.multiplyVector3(r[e.a].position.clone());f=g.multiplyVector3(r[e.b].position.clone());i=g.multiplyVector3(r[e.c].position.clone());g=e instanceof THREE.Face4?g.multiplyVector3(r[e.d].position.clone()):null;j=a.matrixRotationWorld.multiplyVector3(e.normal.clone());m=n.dot(j);if(a.doubleSided||(a.flipSided?m>0:m<0)){j=j.dot((new THREE.Vector3).sub(h,k))/
m;k=k.addSelf(n.multiplyScalar(j));if(e instanceof THREE.Face3){if(b(k,h,f,i)){e={distance:this.origin.distanceTo(k),point:k,face:e,object:a};s.push(e)}}else if(e instanceof THREE.Face4&&(b(k,h,f,g)||b(k,f,i,g))){e={distance:this.origin.distanceTo(k),point:k,face:e,object:a};s.push(e)}}}return s}};
THREE.Rectangle=function(){function a(){h=d-b;f=e-c}var b,c,d,e,h,f,i=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return h};this.getHeight=function(){return f};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(g,j,m,k){i=!1;b=g;c=j;d=m;e=k;a()};this.addPoint=function(g,j){if(i){i=!1;b=g;c=j;d=g;e=j}else{b=b<g?b:g;c=c<j?c:j;d=d>g?d:g;e=e>j?e:j}a()};
this.add3Points=function(g,j,m,k,n,l){if(i){i=!1;b=g<m?g<n?g:n:m<n?m:n;c=j<k?j<l?j:l:k<l?k:l;d=g>m?g>n?g:n:m>n?m:n;e=j>k?j>l?j:l:k>l?k:l}else{b=g<m?g<n?g<b?g:b:n<b?n:b:m<n?m<b?m:b:n<b?n:b;c=j<k?j<l?j<c?j:c:l<c?l:c:k<l?k<c?k:c:l<c?l:c;d=g>m?g>n?g>d?g:d:n>d?n:d:m>n?m>d?m:d:n>d?n:d;e=j>k?j>l?j>e?j:e:l>e?l:e:k>l?k>e?k:e:l>e?l:e}a()};this.addRectangle=function(g){if(i){i=!1;b=g.getLeft();c=g.getTop();d=g.getRight();e=g.getBottom()}else{b=b<g.getLeft()?b:g.getLeft();c=c<g.getTop()?c:g.getTop();d=d>g.getRight()?
d:g.getRight();e=e>g.getBottom()?e:g.getBottom()}a()};this.inflate=function(g){b-=g;c-=g;d+=g;e+=g;a()};this.minSelf=function(g){b=b>g.getLeft()?b:g.getLeft();c=c>g.getTop()?c:g.getTop();d=d<g.getRight()?d:g.getRight();e=e<g.getBottom()?e:g.getBottom();a()};this.instersects=function(g){return Math.min(d,g.getRight())-Math.max(b,g.getLeft())>=0&&Math.min(e,g.getBottom())-Math.max(c,g.getTop())>=0};this.empty=function(){i=!0;e=d=c=b=0;a()};this.isEmpty=function(){return i}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,h,f,i,g,j,m,k,n,l,r,s){this.set(a||1,b||0,c||0,d||0,e||0,h||1,f||0,i||0,g||0,j||0,m||1,k||0,n||0,l||0,r||0,s||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,e,h,f,i,g,j,m,k,n,l,r,s){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=h;this.n23=f;this.n24=i;this.n31=g;this.n32=j;this.n33=m;this.n34=k;this.n41=n;this.n42=l;this.n43=r;this.n44=s;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__v1,
e=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;h.sub(a,b).normalize();if(h.length()===0)h.z=1;d.cross(c,h).normalize();if(d.length()===0){h.x+=1.0E-4;d.cross(c,h).normalize()}e.cross(h,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=h.x;this.n21=d.y;this.n22=e.y;this.n23=h.y;this.n31=d.z;this.n32=e.z;this.n33=h.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*
d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();
return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,h=a.n14,f=a.n21,i=a.n22,g=a.n23,j=a.n24,m=a.n31,k=a.n32,n=a.n33,l=a.n34,r=a.n41,s=a.n42,y=a.n43,u=a.n44,H=b.n11,I=b.n12,D=b.n13,w=b.n14,o=b.n21,O=b.n22,
J=b.n23,K=b.n24,P=b.n31,C=b.n32,x=b.n33,F=b.n34;this.n11=c*H+d*o+e*P;this.n12=c*I+d*O+e*C;this.n13=c*D+d*J+e*x;this.n14=c*w+d*K+e*F+h;this.n21=f*H+i*o+g*P;this.n22=f*I+i*O+g*C;this.n23=f*D+i*J+g*x;this.n24=f*w+i*K+g*F+j;this.n31=m*H+k*o+n*P;this.n32=m*I+k*O+n*C;this.n33=m*D+k*J+n*x;this.n34=m*w+k*K+n*F+l;this.n41=r*H+s*o+y*P;this.n42=r*I+s*O+y*C;this.n43=r*D+s*J+y*x;this.n44=r*w+s*K+y*F+u;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=
this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=
this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,h=this.n22,f=this.n23,i=this.n24,g=this.n31,j=this.n32,m=this.n33,k=this.n34,n=this.n41,l=this.n42,r=this.n43,s=this.n44;return d*f*j*n-c*i*j*n-d*h*m*n+b*i*m*n+c*h*k*n-b*f*k*n-d*f*g*l+c*i*g*l+d*e*m*l-a*i*m*l-c*e*k*l+a*f*k*l+d*h*g*r-b*i*g*r-d*e*j*r+a*i*j*r+b*e*k*r-a*h*k*r-c*h*g*s+b*f*g*s+c*e*j*s-a*f*j*s-b*e*m*s+a*h*m*s},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=
this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;
this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=
this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,
b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,h=a.x,f=a.y,i=a.z,g=e*h,j=e*f;this.set(g*
h+c,g*f-d*i,g*i+d*f,0,g*f+d*i,j*f+c,j*i-d*h,0,g*i-d*f,j*i+d*h,e*i*i+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;
this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a){var b=a.x,c=a.y,d=a.z;a=Math.cos(b);b=Math.sin(b);var e=Math.cos(c);c=Math.sin(c);var h=Math.cos(d);d=Math.sin(d);var f=a*c,i=b*c;this.n11=e*h;this.n12=-e*d;this.n13=c;this.n21=i*h+a*d;this.n22=-i*d+a*h;this.n23=-b*e;this.n31=-f*h+b*d;this.n32=f*d+b*h;this.n33=a*e;return this},
setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,h=b+b,f=c+c,i=d+d;a=b*h;var g=b*f;b*=i;var j=c*f;c*=i;d*=i;h*=e;f*=e;e*=i;this.n11=1-(j+d);this.n12=g-e;this.n13=b+f;this.n21=g+e;this.n22=1-(a+d);this.n23=c-h;this.n31=b-f;this.n32=c+h;this.n33=1-(a+j);return this},scale:function(a){var b=a.x,c=a.y;a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=
a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,b){var c=1/b.x,d=1/b.y,e=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,h=a.n14,f=a.n21,i=a.n22,g=a.n23,j=a.n24,m=a.n31,k=a.n32,n=a.n33,l=a.n34,r=a.n41,s=a.n42,y=a.n43,u=a.n44;b===undefined&&(b=new THREE.Matrix4);b.n11=g*l*s-j*n*s+j*k*y-i*l*y-g*k*u+i*n*u;b.n12=h*n*s-e*l*s-h*k*y+d*l*y+e*k*u-d*n*u;b.n13=e*j*s-h*g*s+h*i*y-d*j*y-e*i*u+d*g*u;b.n14=h*g*k-e*j*k-h*i*n+d*j*n+e*i*l-d*g*l;b.n21=j*n*r-g*l*r-j*m*y+f*l*y+g*m*u-f*n*u;b.n22=e*l*r-h*n*r+h*m*y-c*l*y-e*m*u+c*n*u;b.n23=h*g*r-e*j*r-h*f*y+c*j*y+e*f*u-c*g*u;
b.n24=e*j*m-h*g*m+h*f*n-c*j*n-e*f*l+c*g*l;b.n31=i*l*r-j*k*r+j*m*s-f*l*s-i*m*u+f*k*u;b.n32=h*k*r-d*l*r-h*m*s+c*l*s+d*m*u-c*k*u;b.n33=e*j*r-h*i*r+h*f*s-c*j*s-d*f*u+c*i*u;b.n34=h*i*m-d*j*m-h*f*k+c*j*k+d*f*l-c*i*l;b.n41=g*k*r-i*n*r-g*m*s+f*n*s+i*m*y-f*k*y;b.n42=d*n*r-e*k*r+e*m*s-c*n*s-d*m*y+c*k*y;b.n43=e*i*r-d*g*r-e*f*s+c*g*s+d*f*y-c*i*y;b.n44=d*g*m-e*i*m+e*f*k-c*g*k-d*f*n+c*i*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,h=a.n32*a.n21-a.n31*a.n22,f=-a.n33*a.n12+a.n32*a.n13,i=a.n33*a.n11-a.n31*a.n13,g=-a.n32*a.n11+a.n31*a.n12,j=a.n23*a.n12-a.n22*a.n13,m=-a.n23*a.n11+a.n21*a.n13,k=a.n22*a.n11-a.n21*a.n12;a=a.n11*d+a.n21*f+a.n31*j;if(a==0)throw"matrix not invertible";a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*h;c[3]=a*f;c[4]=a*i;c[5]=a*g;c[6]=a*j;c[7]=a*m;c[8]=a*k;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,h){var f;f=new THREE.Matrix4;f.n11=2*e/(b-a);f.n12=0;f.n13=(b+a)/(b-a);f.n14=0;f.n21=0;f.n22=2*e/(d-c);f.n23=(d+c)/(d-c);f.n24=0;f.n31=0;f.n32=0;f.n33=-(h+e)/(h-e);f.n34=-2*h*e/(h-e);f.n41=0;f.n42=0;f.n43=-1;f.n44=0;return f};THREE.Matrix4.makePerspective=function(a,b,c,d){var e;a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,h){var f,i,g,j;f=new THREE.Matrix4;i=b-a;g=c-d;j=h-e;f.n11=2/i;f.n12=0;f.n13=0;f.n14=-((b+a)/i);f.n21=0;f.n22=2/g;f.n23=0;f.n24=-((c+d)/g);f.n31=0;f.n32=0;f.n33=-2/j;f.n34=-((h+e)/j);f.n41=0;f.n42=0;f.n43=0;f.n44=1;return f};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=undefined;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixAutoUpdate=!0;this.matrixWorldNeedsUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=
!0;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==undefined;)b=b.parent;b!==undefined&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1){a.parent=undefined;this.children.splice(b,1)}},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a)return e;if(b){e=e.getChildByName(a,b);if(e!==undefined)return e}}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale);this.matrixWorldNeedsUpdate=!1;b=!0}a=0;for(var d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==undefined?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b;a=Math.cos(d);d=Math.sin(d);b=Math.cos(-e);e=Math.sin(-e);var h=Math.cos(c);c=Math.sin(c);var f=a*b,i=d*e;this.w=f*h-i*c;this.x=f*c+i*h;this.y=d*b*h+a*e*c;this.z=a*e*h-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=
a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},
multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,h=a.x,f=a.y,i=a.z;a=a.w;this.x=b*a+e*h+c*i-d*f;this.y=c*a+e*f+d*h-b*i;this.z=d*a+e*i+b*f-c*h;this.w=e*a-b*h-c*f-d*i;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,h=this.x,f=this.y,i=this.z,g=this.w,j=g*c+f*e-i*d,m=
g*d+i*c-h*e,k=g*e+h*d-f*c;c=-h*c-f*d-i*e;b.x=j*g+c*-h+m*-i-k*-f;b.y=m*g+c*-f+k*-h-j*-i;b.z=k*g+c*-i+j*-f-m*-h;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var h=Math.acos(e),f=Math.sqrt(1-e*e);if(Math.abs(f)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}e=Math.sin((1-d)*h)/f;d=Math.sin(d*h)/f;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,e,h){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=h instanceof Array?h:[h];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,h,f){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=f instanceof Array?f:[f];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a].position);c.centroid.addSelf(this.vertices[c.b].position);c.centroid.addSelf(this.vertices[c.c].position);
c.centroid.addSelf(this.vertices[c.d].position);c.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var b,c,d,e,h,f,i=new THREE.Vector3,g=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++){h=this.faces[d];if(a&&h.vertexNormals.length){i.set(0,0,0);b=0;for(c=h.vertexNormals.length;b<c;b++)i.addSelf(h.vertexNormals[b]);i.divideScalar(3)}else{b=this.vertices[h.a];c=this.vertices[h.b];f=this.vertices[h.c];i.sub(f.position,c.position);g.sub(b.position,c.position);i.crossSelf(g)}i.isZero()||
i.normalize();h.normal.copy(i)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==undefined){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);
c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeTangents:function(){function a(t,G,z,E,p,q,A){i=t.vertices[G].position;g=t.vertices[z].position;j=t.vertices[E].position;m=f[p];k=f[q];n=f[A];l=g.x-i.x;r=j.x-i.x;s=g.y-i.y;y=j.y-i.y;u=g.z-i.z;H=j.z-i.z;I=k.u-m.u;D=n.u-m.u;w=k.v-m.v;o=n.v-m.v;O=1/(I*o-D*w);C.set((o*
l-w*r)*O,(o*s-w*y)*O,(o*u-w*H)*O);x.set((I*r-D*l)*O,(I*y-D*s)*O,(I*H-D*u)*O);K[G].addSelf(C);K[z].addSelf(C);K[E].addSelf(C);P[G].addSelf(x);P[z].addSelf(x);P[E].addSelf(x)}var b,c,d,e,h,f,i,g,j,m,k,n,l,r,s,y,u,H,I,D,w,o,O,J,K=[],P=[],C=new THREE.Vector3,x=new THREE.Vector3,F=new THREE.Vector3,M=new THREE.Vector3,Q=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++){K[b]=new THREE.Vector3;P[b]=new THREE.Vector3}b=0;for(c=this.faces.length;b<c;b++){h=this.faces[b];f=this.faceVertexUvs[0][b];
if(h instanceof THREE.Face3)a(this,h.a,h.b,h.c,0,1,2);else if(h instanceof THREE.Face4){a(this,h.a,h.b,h.c,0,1,2);a(this,h.a,h.b,h.d,0,1,3)}}var L=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){h=this.faces[b];for(d=0;d<h.vertexNormals.length;d++){Q.copy(h.vertexNormals[d]);e=h[L[d]];J=K[e];F.copy(J);F.subSelf(Q.multiplyScalar(Q.dot(J))).normalize();M.cross(h.vertexNormals[d],J);e=M.dot(P[e]);e=e<0?-1:1;h.vertexTangents[d]=new THREE.Vector4(F.x,F.y,F.z,e)}}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(g,j){return Math.min(g,
j)+"_"+Math.max(g,j)}function b(g,j,m){if(g[j]===undefined){g[j]={set:{},array:[]};g[j].set[m]=1;g[j].array.push(m)}else if(g[j].set[m]===undefined){g[j].set[m]=1;g[j].array.push(m)}}var c,d,e,h,f,i={};c=0;for(d=this.faces.length;c<d;c++){f=this.faces[c];if(f instanceof THREE.Face3){e=a(f.a,f.b);b(i,e,c);e=a(f.b,f.c);b(i,e,c);e=a(f.a,f.c);b(i,e,c)}else if(f instanceof THREE.Face4){e=a(f.b,f.d);b(i,e,c);e=a(f.a,f.b);b(i,e,c);e=a(f.a,f.d);b(i,e,c);e=a(f.b,f.c);b(i,e,c);e=a(f.c,f.d);b(i,e,c)}}c=0;for(d=
this.edges.length;c<d;c++){f=this.edges[c];e=f.vertexIndices[0];h=f.vertexIndices[1];f.faceIndices=i[a(e,h)].array;for(e=0;e<f.faceIndices.length;e++){h=f.faceIndices[e];f.faces.push(this.faces[h])}}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};
THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a));this.target.position.addSelf(b.multiplyScalar(a))};THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);this.matrix.setPosition(this.position);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);b=!0}else{this.matrixAutoUpdate&&this.updateMatrix();if(b||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=
!1;b=!0;THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==undefined?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.Material=function(a){this.id=THREE.MaterialCounter.value++;a=a||{};this.opacity=a.opacity!==undefined?a.opacity:1;this.transparent=a.transparent!==undefined?a.transparent:!1;this.blending=a.blending!==undefined?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==undefined?a.depthTest:!0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;
THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==undefined?a.linewidth:1;this.linecap=a.linecap!==undefined?a.linecap:"round";this.linejoin=a.linejoin!==undefined?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==undefined?a.map:null;this.lightMap=a.lightMap!==undefined?a.lightMap:null;this.envMap=a.envMap!==undefined?a.envMap:null;this.combine=a.combine!==undefined?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==undefined?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==undefined?a.refractionRatio:0.98;this.shading=
a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==undefined?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==undefined?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1;this.skinning=a.skinning!==undefined?a.skinning:!1;this.morphTargets=a.morphTargets!==undefined?
a.morphTargets:!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==undefined?a.map:null;this.lightMap=a.lightMap!==undefined?a.lightMap:null;this.envMap=a.envMap!==undefined?a.envMap:null;this.combine=a.combine!==undefined?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==undefined?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==undefined?a.refractionRatio:0.98;this.shading=
a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==undefined?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==undefined?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1;this.skinning=a.skinning!==undefined?a.skinning:!1;this.morphTargets=a.morphTargets!==undefined?
a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==undefined?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==undefined?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==undefined?a.shininess:30;this.map=a.map!==undefined?a.map:null;this.lightMap=a.lightMap!==undefined?a.lightMap:null;this.envMap=a.envMap!==undefined?
a.envMap:null;this.combine=a.combine!==undefined?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==undefined?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==undefined?a.refractionRatio:0.98;this.shading=a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==undefined?a.wireframeLinecap:"round";this.wireframeLinejoin=
a.wireframeLinejoin!==undefined?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1;this.skinning=a.skinning!==undefined?a.skinning:!1;this.morphTargets=a.morphTargets!==undefined?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==undefined?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==undefined?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==undefined?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==undefined?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==undefined?a.map:null;this.size=a.size!==undefined?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==undefined?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==undefined?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=undefined?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius;if(this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++){this.morphTargetInfluences.push(0);
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}}}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==undefined)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;b=!0}var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};
THREE.Sound=function(a,b,c,d){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=b!==undefined?Math.abs(b):100;this.volume=Math.min(1,Math.max(0,c!==undefined?c:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==undefined?d:!0;this.sources=a instanceof Array?a:[a];var e;c=this.sources.length;for(a=0;a<c;a++){b=this.sources[a];b.toLowerCase();if(b.indexOf(".mp3")!==-1)e=
"audio/mpeg";else if(b.indexOf(".ogg")!==-1)e="audio/ogg";else b.indexOf(".wav")!==-1&&(e="audio/wav");if(this.domElement.canPlayType(e)){e=document.createElement("source");e.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(e);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,b,c){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);b=!0}if(b||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;b=!0}var d=this.children.length;for(a=0;a<d;a++)this.children[a].update(this.matrixWorld,b,c)};
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.fog=null;this.objects=[];this.lights=[];this.sounds=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};
THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1){this.objects.push(a);this.__objectsAdded.push(a)}for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else if(a instanceof THREE.Sound){b=this.sounds.indexOf(a);b!==-1&&this.sounds.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.objects.indexOf(a);if(b!==-1){this.objects.splice(b,1);this.__objectsRemoved.push(a)}}for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var C=g[i]=g[i]||new THREE.RenderableVertex;i++;return C}function b(C,x){return x.z-C.z}function c(C,x){var F=0,M=1,Q=C.z+C.w,L=x.z+x.w,t=-C.z+C.w,G=-x.z+x.w;if(Q>=0&&L>=0&&t>=0&&G>=0)return!0;else if(Q<0&&L<0||t<0&&G<0)return!1;else{if(Q<0)F=Math.max(F,Q/(Q-L));else L<0&&(M=Math.min(M,Q/(Q-L)));if(t<0)F=Math.max(F,t/(t-G));else G<0&&(M=Math.min(M,t/(t-G)));if(M<F)return!1;else{C.lerpSelf(x,F);x.lerpSelf(C,1-M);return!0}}}var d,e,h=[],f,i,g=[],j,m,k=[],n,l=
[],r,s,y=[],u,H,I=[],D=new THREE.Vector4,w=new THREE.Vector4,o=new THREE.Matrix4,O=new THREE.Matrix4,J=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],K=new THREE.Vector4,P=new THREE.Vector4;this.projectVector=function(C,x){o.multiply(x.projectionMatrix,x.matrixWorldInverse);o.multiplyVector3(C);return C};this.unprojectVector=function(C,x){o.multiply(x.matrixWorld,THREE.Matrix4.makeInvert(x.projectionMatrix));o.multiplyVector3(C);return C};
this.projectObjects=function(C,x,F){x=[];var M,Q,L;e=0;Q=C.objects;C=0;for(M=Q.length;C<M;C++){L=Q[C];var t;if(!(t=!L.visible))if(t=L instanceof THREE.Mesh){a:{t=void 0;for(var G=L.matrixWorld,z=-L.geometry.boundingSphere.radius*Math.max(L.scale.x,Math.max(L.scale.y,L.scale.z)),E=0;E<6;E++){t=J[E].x*G.n14+J[E].y*G.n24+J[E].z*G.n34+J[E].w;if(t<=z){t=!1;break a}}t=!0}t=!t}if(!t){t=h[e]=h[e]||new THREE.RenderableObject;e++;d=t;D.copy(L.position);o.multiplyVector3(D);d.object=L;d.z=D.z;x.push(d)}}F&&
x.sort(b);return x};this.projectScene=function(C,x,F){var M=[],Q=x.near,L=x.far,t,G,z,E,p,q,A,N,B,v,R,U,W,X,S,V,T;H=s=n=m=0;x.matrixAutoUpdate&&x.update(undefined,!0);C.update(undefined,!1,x);o.multiply(x.projectionMatrix,x.matrixWorldInverse);J[0].set(o.n41-o.n11,o.n42-o.n12,o.n43-o.n13,o.n44-o.n14);J[1].set(o.n41+o.n11,o.n42+o.n12,o.n43+o.n13,o.n44+o.n14);J[2].set(o.n41+o.n21,o.n42+o.n22,o.n43+o.n23,o.n44+o.n24);J[3].set(o.n41-o.n21,o.n42-o.n22,o.n43-o.n23,o.n44-o.n24);J[4].set(o.n41-o.n31,o.n42-
o.n32,o.n43-o.n33,o.n44-o.n34);J[5].set(o.n41+o.n31,o.n42+o.n32,o.n43+o.n33,o.n44+o.n34);for(t=0;t<6;t++){B=J[t];B.divideScalar(Math.sqrt(B.x*B.x+B.y*B.y+B.z*B.z))}B=this.projectObjects(C,x,!0);C=0;for(t=B.length;C<t;C++){v=B[C].object;if(v.visible){R=v.matrixWorld;U=v.matrixRotationWorld;W=v.materials;X=v.overdraw;i=0;if(v instanceof THREE.Mesh){S=v.geometry;E=S.vertices;V=S.faces;S=S.faceVertexUvs;G=0;for(z=E.length;G<z;G++){f=a();f.positionWorld.copy(E[G].position);R.multiplyVector3(f.positionWorld);
f.positionScreen.copy(f.positionWorld);o.multiplyVector4(f.positionScreen);f.positionScreen.x/=f.positionScreen.w;f.positionScreen.y/=f.positionScreen.w;f.visible=f.positionScreen.z>Q&&f.positionScreen.z<L}E=0;for(G=V.length;E<G;E++){z=V[E];if(z instanceof THREE.Face3){p=g[z.a];q=g[z.b];A=g[z.c];if(p.visible&&q.visible&&A.visible&&(v.doubleSided||v.flipSided!=(A.positionScreen.x-p.positionScreen.x)*(q.positionScreen.y-p.positionScreen.y)-(A.positionScreen.y-p.positionScreen.y)*(q.positionScreen.x-
p.positionScreen.x)<0)){N=k[m]=k[m]||new THREE.RenderableFace3;m++;j=N;j.v1.copy(p);j.v2.copy(q);j.v3.copy(A)}else continue}else if(z instanceof THREE.Face4){p=g[z.a];q=g[z.b];A=g[z.c];N=g[z.d];if(p.visible&&q.visible&&A.visible&&N.visible&&(v.doubleSided||v.flipSided!=((N.positionScreen.x-p.positionScreen.x)*(q.positionScreen.y-p.positionScreen.y)-(N.positionScreen.y-p.positionScreen.y)*(q.positionScreen.x-p.positionScreen.x)<0||(q.positionScreen.x-A.positionScreen.x)*(N.positionScreen.y-A.positionScreen.y)-
(q.positionScreen.y-A.positionScreen.y)*(N.positionScreen.x-A.positionScreen.x)<0))){T=l[n]=l[n]||new THREE.RenderableFace4;n++;j=T;j.v1.copy(p);j.v2.copy(q);j.v3.copy(A);j.v4.copy(N)}else continue}j.normalWorld.copy(z.normal);U.multiplyVector3(j.normalWorld);j.centroidWorld.copy(z.centroid);R.multiplyVector3(j.centroidWorld);j.centroidScreen.copy(j.centroidWorld);o.multiplyVector3(j.centroidScreen);A=z.vertexNormals;p=0;for(q=A.length;p<q;p++){N=j.vertexNormalsWorld[p];N.copy(A[p]);U.multiplyVector3(N)}p=
0;for(q=S.length;p<q;p++)if(T=S[p][E]){A=0;for(N=T.length;A<N;A++)j.uvs[p][A]=T[A]}j.meshMaterials=W;j.faceMaterials=z.materials;j.overdraw=X;j.z=j.centroidScreen.z;M.push(j)}}else if(v instanceof THREE.Line){O.multiply(o,R);E=v.geometry.vertices;p=a();p.positionScreen.copy(E[0].position);O.multiplyVector4(p.positionScreen);G=1;for(z=E.length;G<z;G++){p=a();p.positionScreen.copy(E[G].position);O.multiplyVector4(p.positionScreen);q=g[i-2];K.copy(p.positionScreen);P.copy(q.positionScreen);if(c(K,P)){K.multiplyScalar(1/
K.w);P.multiplyScalar(1/P.w);R=y[s]=y[s]||new THREE.RenderableLine;s++;r=R;r.v1.positionScreen.copy(K);r.v2.positionScreen.copy(P);r.z=Math.max(K.z,P.z);r.materials=v.materials;M.push(r)}}}else if(v instanceof THREE.Particle){w.set(v.matrixWorld.n14,v.matrixWorld.n24,v.matrixWorld.n34,1);o.multiplyVector4(w);w.z/=w.w;if(w.z>0&&w.z<1){R=I[H]=I[H]||new THREE.RenderableParticle;H++;u=R;u.x=w.x/w.w;u.y=w.y/w.w;u.z=w.z;u.rotation=v.rotation.z;u.scale.x=v.scale.x*Math.abs(u.x-(w.x+x.projectionMatrix.n11)/
(w.w+x.projectionMatrix.n14));u.scale.y=v.scale.y*Math.abs(u.y-(w.y+x.projectionMatrix.n22)/(w.w+x.projectionMatrix.n24));u.materials=v.materials;M.push(u)}}}}F&&M.sort(b);return M}};
THREE.SVGRenderer=function(){function a(t,G,z){var E,p,q,A;E=0;for(p=t.lights.length;E<p;E++){q=t.lights[E];if(q instanceof THREE.DirectionalLight){A=G.normalWorld.dot(q.position)*q.intensity;if(A>0){z.r+=q.color.r*A;z.g+=q.color.g*A;z.b+=q.color.b*A}}else if(q instanceof THREE.PointLight){P.sub(q.position,G.centroidWorld);P.normalize();A=G.normalWorld.dot(P)*q.intensity;if(A>0){z.r+=q.color.r*A;z.g+=q.color.g*A;z.b+=q.color.b*A}}}}function b(t,G,z,E,p,q){h.data.vertices+=3;h.data.faces++;F=d(M++);
F.setAttribute("d","M "+t.positionScreen.x+" "+t.positionScreen.y+" L "+G.positionScreen.x+" "+G.positionScreen.y+" L "+z.positionScreen.x+","+z.positionScreen.y+"z");if(p instanceof THREE.MeshBasicMaterial)D.__styleString=p.color.__styleString;else if(p instanceof THREE.MeshLambertMaterial)if(I){w.r=o.r;w.g=o.g;w.b=o.b;a(q,E,w);D.r=p.color.r*w.r;D.g=p.color.g*w.g;D.b=p.color.b*w.b;D.updateStyleString()}else D.__styleString=p.color.__styleString;else if(p instanceof THREE.MeshDepthMaterial){K=1-p.__2near/
(p.__farPlusNear-E.z*p.__farMinusNear);D.setRGB(K,K,K)}else p instanceof THREE.MeshNormalMaterial&&D.setRGB(e(E.normalWorld.x),e(E.normalWorld.y),e(E.normalWorld.z));p.wireframe?F.setAttribute("style","fill: none; stroke: "+D.__styleString+"; stroke-width: "+p.wireframeLinewidth+"; stroke-opacity: "+p.opacity+"; stroke-linecap: "+p.wireframeLinecap+"; stroke-linejoin: "+p.wireframeLinejoin):F.setAttribute("style","fill: "+D.__styleString+"; fill-opacity: "+p.opacity);g.appendChild(F)}function c(t,
G,z,E,p,q,A){h.data.vertices+=4;h.data.faces++;F=d(M++);F.setAttribute("d","M "+t.positionScreen.x+" "+t.positionScreen.y+" L "+G.positionScreen.x+" "+G.positionScreen.y+" L "+z.positionScreen.x+","+z.positionScreen.y+" L "+E.positionScreen.x+","+E.positionScreen.y+"z");if(q instanceof THREE.MeshBasicMaterial)D.__styleString=q.color.__styleString;else if(q instanceof THREE.MeshLambertMaterial)if(I){w.r=o.r;w.g=o.g;w.b=o.b;a(A,p,w);D.r=q.color.r*w.r;D.g=q.color.g*w.g;D.b=q.color.b*w.b;D.updateStyleString()}else D.__styleString=
q.color.__styleString;else if(q instanceof THREE.MeshDepthMaterial){K=1-q.__2near/(q.__farPlusNear-p.z*q.__farMinusNear);D.setRGB(K,K,K)}else q instanceof THREE.MeshNormalMaterial&&D.setRGB(e(p.normalWorld.x),e(p.normalWorld.y),e(p.normalWorld.z));q.wireframe?F.setAttribute("style","fill: none; stroke: "+D.__styleString+"; stroke-width: "+q.wireframeLinewidth+"; stroke-opacity: "+q.opacity+"; stroke-linecap: "+q.wireframeLinecap+"; stroke-linejoin: "+q.wireframeLinejoin):F.setAttribute("style","fill: "+
D.__styleString+"; fill-opacity: "+q.opacity);g.appendChild(F)}function d(t){if(C[t]==null){C[t]=document.createElementNS("http://www.w3.org/2000/svg","path");L==0&&C[t].setAttribute("shape-rendering","crispEdges")}return C[t]}function e(t){return t<0?Math.min((1+t)*0.5,0.5):0.5+Math.min(t*0.5,0.5)}var h=this,f=null,i=new THREE.Projector,g=document.createElementNS("http://www.w3.org/2000/svg","svg"),j,m,k,n,l,r,s,y,u=new THREE.Rectangle,H=new THREE.Rectangle,I=!1,D=new THREE.Color(16777215),w=new THREE.Color(16777215),
o=new THREE.Color(0),O=new THREE.Color(0),J=new THREE.Color(0),K,P=new THREE.Vector3,C=[],x=[],F,M,Q,L=1;this.domElement=g;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.data={vertices:0,faces:0};this.setQuality=function(t){switch(t){case "high":L=1;break;case "low":L=0}};this.setSize=function(t,G){j=t;m=G;k=j/2;n=m/2;g.setAttribute("viewBox",-k+" "+-n+" "+j+" "+m);g.setAttribute("width",j);g.setAttribute("height",m);u.set(-k,-n,k,n)};this.clear=function(){for(;g.childNodes.length>
0;)g.removeChild(g.childNodes[0])};this.render=function(t,G){var z,E,p,q,A,N,B,v;this.autoClear&&this.clear();h.data.vertices=0;h.data.faces=0;f=i.projectScene(t,G,this.sortElements);Q=M=0;if(I=t.lights.length>0){B=t.lights;o.setRGB(0,0,0);O.setRGB(0,0,0);J.setRGB(0,0,0);z=0;for(E=B.length;z<E;z++){p=B[z];q=p.color;if(p instanceof THREE.AmbientLight){o.r+=q.r;o.g+=q.g;o.b+=q.b}else if(p instanceof THREE.DirectionalLight){O.r+=q.r;O.g+=q.g;O.b+=q.b}else if(p instanceof THREE.PointLight){J.r+=q.r;J.g+=
q.g;J.b+=q.b}}}z=0;for(E=f.length;z<E;z++){B=f[z];H.empty();if(B instanceof THREE.RenderableParticle){l=B;l.x*=k;l.y*=-n;p=0;for(q=B.materials.length;p<q;)p++}else if(B instanceof THREE.RenderableLine){l=B.v1;r=B.v2;l.positionScreen.x*=k;l.positionScreen.y*=-n;r.positionScreen.x*=k;r.positionScreen.y*=-n;H.addPoint(l.positionScreen.x,l.positionScreen.y);H.addPoint(r.positionScreen.x,r.positionScreen.y);if(u.instersects(H)){p=0;for(q=B.materials.length;p<q;)if((v=B.materials[p++])&&v.opacity!=0){A=
l;N=r;var R=Q++;if(x[R]==null){x[R]=document.createElementNS("http://www.w3.org/2000/svg","line");L==0&&x[R].setAttribute("shape-rendering","crispEdges")}F=x[R];F.setAttribute("x1",A.positionScreen.x);F.setAttribute("y1",A.positionScreen.y);F.setAttribute("x2",N.positionScreen.x);F.setAttribute("y2",N.positionScreen.y);if(v instanceof THREE.LineBasicMaterial){D.__styleString=v.color.__styleString;F.setAttribute("style","fill: none; stroke: "+D.__styleString+"; stroke-width: "+v.linewidth+"; stroke-opacity: "+
v.opacity+"; stroke-linecap: "+v.linecap+"; stroke-linejoin: "+v.linejoin);g.appendChild(F)}}}}else if(B instanceof THREE.RenderableFace3){l=B.v1;r=B.v2;s=B.v3;l.positionScreen.x*=k;l.positionScreen.y*=-n;r.positionScreen.x*=k;r.positionScreen.y*=-n;s.positionScreen.x*=k;s.positionScreen.y*=-n;H.addPoint(l.positionScreen.x,l.positionScreen.y);H.addPoint(r.positionScreen.x,r.positionScreen.y);H.addPoint(s.positionScreen.x,s.positionScreen.y);if(u.instersects(H)){p=0;for(q=B.meshMaterials.length;p<
q;){v=B.meshMaterials[p++];if(v instanceof THREE.MeshFaceMaterial){A=0;for(N=B.faceMaterials.length;A<N;)(v=B.faceMaterials[A++])&&v.opacity!=0&&b(l,r,s,B,v,t)}else v&&v.opacity!=0&&b(l,r,s,B,v,t)}}}else if(B instanceof THREE.RenderableFace4){l=B.v1;r=B.v2;s=B.v3;y=B.v4;l.positionScreen.x*=k;l.positionScreen.y*=-n;r.positionScreen.x*=k;r.positionScreen.y*=-n;s.positionScreen.x*=k;s.positionScreen.y*=-n;y.positionScreen.x*=k;y.positionScreen.y*=-n;H.addPoint(l.positionScreen.x,l.positionScreen.y);
H.addPoint(r.positionScreen.x,r.positionScreen.y);H.addPoint(s.positionScreen.x,s.positionScreen.y);H.addPoint(y.positionScreen.x,y.positionScreen.y);if(u.instersects(H)){p=0;for(q=B.meshMaterials.length;p<q;){v=B.meshMaterials[p++];if(v instanceof THREE.MeshFaceMaterial){A=0;for(N=B.faceMaterials.length;A<N;)(v=B.faceMaterials[A++])&&v.opacity!=0&&c(l,r,s,y,B,v,t)}else v&&v.opacity!=0&&c(l,r,s,y,B,v,t)}}}}}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,b,c){c&&a.update(undefined,!1,b);c=a.sounds;var d,e=c.length;for(d=0;d<e;d++){a=c[d];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(b.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
