# Advanced Tabular DL models in AutoMM

### 1. Run Example

[`example_tabular.py`](./example_tabular.py) : This example provides a use case for the pure _tabular_ data, including pure numerical features and numerical + categorical features, with FT_Transformer [1].

To run the example:

`python example_tabular.py --dataset_name ad --dataset_dir ./dataset --exp_dir ./result`

- `dataset_name` determines which dataset to run the experiments, refers to [Dataset Section](###2.-Datasets).
- `dataset_dir` is the path to the dataset(s). If the datasets do not present in this path, it will be automatically downloaded.
- `exp_dir` is the output path to store the weights and loggings.
- `gpu_id` specifies the GPU to use (optional).
- `seed` determines the random seed (optional). Default is 0.
- `lr` specifies the initial learning rate (optional). Default is `1e-04`.
- `end_lr` specifies the end learning rate (optional). Default is `1e-04`.

### 2. Datasets

We borrowed 11 tabular datasets provided by [1], and use identically the same abbreviation as Table 1 in the original paper [1] to name each datasets.
The datasets provided by https://github.com/Yura52/tabular-dl-revisiting-models are all in `Numpy.darray` format (can be downloaded from https://www.dropbox.com/s/o53umyg6mn3zhxy/data.tar.gz?dl=1).
These Data in `Numpy.ndarray` was first pre-processing into `.csv` format, which can be loaded by `pandas.Dataframe` as the input to `MultiModalPredictor`.
All Data can be automatically downloaded from s3 (online connection is necessary) if it does not exist with the given dataset path `dataset_dir`.

### 3. FT-Transformer

FT-Transformer consists of a numerical tokenizer, a categorical tokenizer and the transformer backbone. Some commonly used features are explained below:

- `num_blocks` is the number of transformer blocks in the transformer backbone.
- `token_dim` is the dimension of the input tokens after categorical/numerical tokenizers.
- `hidden_size` is the embedding dimension of the ft_transformer backbone.
- `ffn_hidden_size` is the hidden layer dimension of the FFN (Feed-Forward) layer in ft-transformer blocks.
- `ffn_dropout` is the dropout rate in feadforward layer.
- `ffn_activation` determines the activation function in feadforward layer. We support `relu`, `gelu`, `reglu` and `leaky_relu`.
- `attention_dropout` is the dropout rate in attention layer.
- `embedding_arch` is a list containing the names of embedding layers as described in [2].

These features can be tuned using `hyperparameters` in `MultiModalPredictor. For example:

```python
hyperparameters = {
   "model.names": ["ft_transformer"],
   "model.ft_transformer.num_blocks": 5,
   "model.ft_transformer.ffn_dropout": 0.0,
}
```

### 4. Results

| Datasets              | ca         | ad     | he         | ja         | hi     | al         | ep           | ye         | co         | ya         | mi         |
| --------------------- | ---------- | ------ | ---------- | ---------- | ------ | ---------- | ------------ | ---------- | ---------- | ---------- | ---------- |
| metrics               | rmse       | acc    | acc        | acc        | acc    | acc        | acc          | rmse       | acc        | rmse       | rmse       |
| problem_type          | regression | binary | multiclass | multiclass | binary | multiclass | binary       | regression | multiclass | regression | regression |
| #objects              | 20640      | 48842  | 65196      | 83733      | 98050  | 108000     | 500000       | 515345     | 581012     | 709877     | 1200192    |
| #num.                 | 8          | 6      | 27         | 54         | 28     | 128        | 2000         | 90         | 54         | 699        | 136        |
| #cat.                 | 0          | 8      | 0          | 0          | 0      | 0          | 0            | 0          | 0          | 0          | 0          |
| #classes              | -          | 2      | 100        | 4          | 2      | 1000       | 2            | -          | 7          | -          | -          |
| Best in [1]           | 0.459      | 0.859  | 0.396      | 0.732      | 0.729  | 0.963      | 0.8982       | 8.794      | 0.970      | 0.753      | 0.745      |
| FT-Transformer in [1] | 0.459      | 0.859  | 0.391      | 0.732      | 0.729  | 0.960      | 0.8982       | 8.855      | 0.970      | 0.756      | 0.746      |
| AutoMM FT-Transformer | 0.465      | 0.859  | 0.383      | 0.729      | 0.734  | 0.952      | RuntimeError | 8.873      | 0.963      | 0.759      | 0.761      |

`FT-Transformer in [1]` row leverages parameters searching, and `AutoMM FT-Transformer` row use a fixed training configurations.

You can reproduce the `AutoMM FT-Transformer` row by running:

```bash
bash run_all.sh
```

with overriding the following hyperparameters:

```python
automm_hyperparameters = {
    "data.categorical.convert_to_text": False,
    "model.names": ["ft_transformer"],
    "model.ft_transformer.embedding_arch": ["linear"],
    "env.batch_size": 128,
    "env.per_gpu_batch_size": 128,
    "env.inference_batch_size_ratio": 1,
    "env.num_workers": 12,
    "env.num_workers_inference": 12,
    "env.num_gpus": 1,
    "optim.max_epochs": 2000,
    "optim.weight_decay": 1.0e-5,
    "optim.lr_choice": None,
    "optim.lr_schedule": "polynomial_decay",
    "optim.warmup_steps": 0.0,
    "optim.patience": 20,
    "optim.top_k": 3,
}
```

We run the experiments on one NVIDIA Tesla T4 GPU with 15360MiB memory.

### Reference

[1] Revisiting Deep Learning Models for Tabular Data, 2021, <https://arxiv.org/pdf/2106.11959.pdf>

[2] On Embeddings for Numerical Features in Tabular Deep Learning, 2022, <https://arxiv.org/abs/2203.05556>
