# Version 1.3.0

We are happy to announce the AutoGluon 1.3.0 release!

AutoGluon 1.3 focuses on stability & usability improvements, bug fixes, and dependency upgrades.

This release contains [142 commits from 20 contributors](https://github.com/autogluon/autogluon/graphs/contributors?from=11%2F29%2F2024&to=4%2F30%2F2025&type=c)! See the full commit change-log here: https://github.com/autogluon/autogluon/compare/v1.2.0...v1.3.0

Join the community: [![](https://img.shields.io/discord/1043248669505368144?logo=discord&style=flat)](https://discord.gg/wjUmjqAc2N)
Get the latest updates: [![Twitter](https://img.shields.io/twitter/follow/autogluon?style=social)](https://twitter.com/autogluon)

Loading models trained on older versions of AutoGluon is not supported. Please re-train models using AutoGluon 1.3.

--------

## Highlights

### AutoGluon-Tabular is the state of the art in the AutoML Benchmark 2025!

The [AutoML Benchmark 2025](https://arxiv.org/pdf/2504.01222), an independent large-scale evaluation of tabular AutoML frameworks, showcases AutoGluon 1.2 as the state of the art AutoML framework! Highlights include:
- AutoGluon's rank statistically significantly outperforms all AutoML systems via the Nemenyi post-hoc test across all time constraints.
- AutoGluon with a 5 minute training budget outperforms all other AutoML systems with a 1 hour training budget.
- AutoGluon is pareto efficient in quality and speed across all evaluated presets and time constraints.
- AutoGluon with `presets="high", infer_limit=0.0001` (HQIL in the figures) achieves >10,000 samples/second inference throughput while outperforming all methods.
- AutoGluon is the most stable AutoML system. For "best" and "high" presets, AutoGluon has 0 failures on all time budgets >5 minutes.

<p float="left">
  <img src="https://raw.githubusercontent.com/Innixma/autogluon-doc-utils/refs/heads/main/docs/whats_new/v1.3.0/amlb2025_fig3a.png" width="40%"/>
  <img src="https://raw.githubusercontent.com/Innixma/autogluon-doc-utils/refs/heads/main/docs/whats_new/v1.3.0/amlb2025_fig10d.png" width="35%"/>
</p>

<img src="https://raw.githubusercontent.com/Innixma/autogluon-doc-utils/refs/heads/main/docs/whats_new/v1.3.0/amlb2025_fig1.png" width="100%"/>

### AutoGluon Multimodal's "Bag of Tricks" Update

We are pleased to announce the integration of a comprehensive "Bag of Tricks" update for AutoGluon's MultiModal (AutoMM). This significant enhancement substantially improves multimodal AutoML performance when working with combinations of image, text, and tabular data. The update implements various strategies including multimodal model fusion techniques, multimodal data augmentation, cross-modal alignment, tabular data serialization, better handling of missing modalities, and an ensemble learner that integrates these techniques for optimal performance.

Users can now access these capabilities through a simple parameter when initializing the MultiModalPredictor after following the instruction [here](https://github.com/autogluon/autogluon/blob/2b90eb0f4a848941d70cd387c2fdec67bc67706d/multimodal/src/autogluon/multimodal/learners/ensemble.py#L306-L322) to download the checkpoints:
```python
from autogluon.multimodal import MultiModalPredictor
predictor = MultiModalPredictor(label="label", use_ensemble=True)
predictor.fit(train_data=train_data)
```

We express our gratitude to [@zhiqiangdon](https://github.com/zhiqiangdon), for this substantial contribution that enhances AutoGluon's capabilities for handling complex multimodal datasets. Here is the corresponding research paper describing the technical details: [Bag of Tricks for Multimodal AutoML with Image, Text, and Tabular Data](https://arxiv.org/html/2412.16243v1).


## Deprecations and Breaking Changes

The following deprecated TabularPredictor methods have been removed in the 1.3.0 release (deprecated in 1.0.0, raise in 1.2.0, removed in 1.3.0). Please use the new names:
- `persist_models` -> `persist`, `unpersist_models` -> `unpersist`, `get_model_names` -> `model_names`, `get_model_best` -> `model_best`, `get_pred_from_proba` -> `predict_from_proba`, `get_model_full_dict` -> `model_refit_map`, `get_oof_pred_proba` -> `predict_proba_oof`, `get_oof_pred` -> `predict_oof`, `get_size_disk_per_file` -> `disk_usage_per_file`, `get_size_disk` -> `disk_usage`, `get_model_names_persisted` -> `model_names(persisted=True)`

The following logic has been deprecated starting in 1.3.0 and will log a `FutureWarning`. Functionality will be changed in a future release:

- (**FutureWarning**) `TabularPredictor.delete_models()` will default to `dry_run=False` in a future release (currently `dry_run=True`). Please ensure you explicitly specify `dry_run=True` for the existing logic to remain in future releases. [@Innixma](https://github.com/Innixma) ([#4905](https://github.com/autogluon/autogluon/pull/4905))


## General


### Improvements
- (**Major**) Internal refactor of `AbstractTrainer` class to improve extensibility and reduce code duplication. [@canerturkmen](https://github.com/canerturkmen) ([#4804](https://github.com/autogluon/autogluon/pull/4804), [#4820](https://github.com/autogluon/autogluon/pull/4820), [#4851](https://github.com/autogluon/autogluon/pull/4851))

### Dependencies

- Update numpy to `>=1.25.0,<2.3.0`. [@tonyhoo](https://github.com/tonyhoo), [@Innixma](https://github.com/Innixma), [@suzhoum](https://github.com/suzhoum) ([#5020](https://github.com/autogluon/autogluon/pull/5020), [#5056](https://github.com/autogluon/autogluon/pull/5056), [#5072](https://github.com/autogluon/autogluon/pull/5072))
- Update spacy to `<3.9`. [@tonyhoo](https://github.com/tonyhoo) ([#5072](https://github.com/autogluon/autogluon/pull/5072))
- Update scikit-learn to `>=1.4.0,<1.7.0`. [@tonyhoo](https://github.com/tonyhoo), [@Innixma](https://github.com/Innixma) ([#5029](https://github.com/autogluon/autogluon/pull/5029), [#5045](https://github.com/autogluon/autogluon/pull/5045))
- Update psutil to `>=5.7.3,<7.1.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update s3fs to `>=2024.2,<2026`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update ray to `>=2.10.0,<2.45`. [@suzhoum](https://github.com/suzhoum), [@celestinoxp](https://github.com/celestinoxp), [@tonyhoo](https://github.com/tonyhoo) ([#4714](https://github.com/autogluon/autogluon/pull/4714), [#4887](https://github.com/autogluon/autogluon/pull/4887), [#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update tabpfn to `>=0.1.11,<0.2`. [@Innixma](https://github.com/Innixma) ([#4787](https://github.com/autogluon/autogluon/pull/4787))
- Update torch to `>=2.2,<2.7`. [@FireballDWF](https://github.com/FireballDWF) ([#5000](https://github.com/autogluon/autogluon/pull/5000))
- Update lightning to `>=2.2,<2.7`. [@FireballDWF](https://github.com/FireballDWF) ([#5000](https://github.com/autogluon/autogluon/pull/5000))
- Update torchmetrics to `>=1.2.0,<1.8`. [@zkalson](https://github.com/zkalson), [@tonyhoo](https://github.com/tonyhoo) ([#4720](https://github.com/autogluon/autogluon/pull/4720), [#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update torchvision to `>=0.16.0,<0.22.0`. [@FireballDWF](https://github.com/FireballDWF) ([#5000](https://github.com/autogluon/autogluon/pull/5000))
- Update accelerate to `>=0.34.0,<2.0`. [@FireballDWF](https://github.com/FireballDWF) ([#5000](https://github.com/autogluon/autogluon/pull/5000))
- Update lightgbm to `>=4.0,<4.7`. [@tonyhoo](https://github.com/tonyhoo) ([#4960](https://github.com/autogluon/autogluon/pull/4960))
- Update fastai to `>=2.3.1,<2.9`. [@Innixma](https://github.com/Innixma) ([#4988](https://github.com/autogluon/autogluon/pull/4988))
- Update jsonschema to `>=4.18,<4.24`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update scikit-image to `>=0.19.1,<0.26.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update omegaconf to `>=2.1.1,<2.4.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update pytorch-metric-learning to `>=1.3.0,<2.9`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update nltk to `>=3.4.5,<4.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update pytesseract to `>=0.3.9,<0.4`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update nvidia-ml-py3 to `>=7.352.0,<8.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update datasets to `>=2.16.0,<3.6.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update onnxruntime to `>=1.17.0,<1.22.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update tensorrt to `>=8.6.0,<10.9.1`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update xgboost to `>=2.0,<3.1`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update imodels to `>=1.3.10,<2.1.0`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))
- Update statsforecast to `>=1.7.0,<2.0.2`. [@tonyhoo](https://github.com/tonyhoo) ([#5020](https://github.com/autogluon/autogluon/pull/5020))


### Documentation
- Updating documented python version's in CONTRIBUTING.md. [@celestinoxp](https://github.com/celestinoxp) ([#4796](https://github.com/autogluon/autogluon/pull/4796))
- Refactored CONTRIBUTING.md to have up-to-date information. [@Innixma](https://github.com/Innixma) ([#4798](https://github.com/autogluon/autogluon/pull/4798))
- Fix various typos. [@celestinoxp](https://github.com/celestinoxp) ([#4819](https://github.com/autogluon/autogluon/pull/4819))
- Minor doc improvements. [@tonyhoo](https://github.com/tonyhoo) ([#4894](https://github.com/autogluon/autogluon/pull/4894), [#4929](https://github.com/autogluon/autogluon/pull/4929))

### Fixes and Improvements
- Fix colab AutoGluon source install with `uv`. [@tonyhoo](https://github.com/tonyhoo) ([#4943](https://github.com/autogluon/autogluon/pull/4943), [#4964](https://github.com/autogluon/autogluon/pull/4964))
- Make `full_install.sh` use the script directory instead of the working directory. [@Innixma](https://github.com/Innixma) ([#4933](https://github.com/autogluon/autogluon/pull/4933))
- Add `test_version.py` to ensure proper version format for releases. [@Innixma](https://github.com/Innixma) ([#4799](https://github.com/autogluon/autogluon/pull/4799))
- Fix `setup_outputdir` to work with s3 paths. [@suzhoum](https://github.com/suzhoum) ([#4734](https://github.com/autogluon/autogluon/pull/4734))
- Ensure `setup_outputdir` always makes a new directory if `path_suffix != None` and `path=None`. [@Innixma](https://github.com/Innixma) ([#4903](https://github.com/autogluon/autogluon/pull/4903))
- Check `cuda.is_available()` before calling `cuda.device_count()` to avoid warnings. [@Innixma](https://github.com/Innixma) ([#4902](https://github.com/autogluon/autogluon/pull/4902))
- Log a warning if mlflow autologging is enabled. [@shchur](https://github.com/shchur) ([#4925](https://github.com/autogluon/autogluon/pull/4925))
- Fix rare ZeroDivisionError edge-case in `get_approximate_df_mem_usage`. [@shchur](https://github.com/shchur) ([#5083](https://github.com/autogluon/autogluon/pull/5083))
- Minor fixes & improvements. [@suzhoum](https://github.com/suzhoum) [@Innixma](https://github.com/Innixma) [@canerturkmen](https://github.com/canerturkmen) [@PGijsbers](https://github.com/PGijsbers) [@tonyhoo](https://github.com/tonyhoo) ([#4744](https://github.com/autogluon/autogluon/pull/4744), [#4785](https://github.com/autogluon/autogluon/pull/4785), [#4822](https://github.com/autogluon/autogluon/pull/4822), [#4860](https://github.com/autogluon/autogluon/pull/4860), [#4891](https://github.com/autogluon/autogluon/pull/4891), [#5012](https://github.com/autogluon/autogluon/pull/5012), [#5047](https://github.com/autogluon/autogluon/pull/5047))

--------

## Tabular

### Removed Models
- Removed vowpalwabbit model (key: `VW`) and optional dependency (`autogluon.tabular[vowpalwabbit]`), as the model implemented in AutoGluon was not widely used and was largely unmaintained. [@Innixma](https://github.com/Innixma) ([#4975](https://github.com/autogluon/autogluon/pull/4975))
- Removed TabTransformer model (key: `TRANSF`), as the model implemented in AutoGluon was heavily outdated, unmaintained since 2020, and generally outperformed by FT-Transformer (key: `FT_TRANSFORMER`). [@Innixma](https://github.com/Innixma) ([#4976](https://github.com/autogluon/autogluon/pull/4976))
- Removed tabpfn from `autogluon.tabular[tests]` install in preparation for future `tabpfn>=2.x` support. [@Innixma](https://github.com/Innixma) ([#4974](https://github.com/autogluon/autogluon/pull/4974))

### New Features
- Add support for regression stratified splits via binning. [@Innixma](https://github.com/Innixma) ([#4586](https://github.com/autogluon/autogluon/pull/4586))
- Add `TabularPredictor.model_hyperparameters(model)` that returns the hyperparameters of a model. [@Innixma](https://github.com/Innixma) ([#4901](https://github.com/autogluon/autogluon/pull/4901))
- Add `TabularPredictor.model_info(model)` that returns the metadata of a model. [@Innixma](https://github.com/Innixma) ([#4901](https://github.com/autogluon/autogluon/pull/4901))
- (Experimental) Add `plot_leaderboard.py` to visualize performance over training time of the predictor. [@Innixma](https://github.com/Innixma) ([#4907](https://github.com/autogluon/autogluon/pull/4907))
- (**Major**) Add internal `ag_model_registry` to improve the tracking of supported model families and their capabilities. [@Innixma](https://github.com/Innixma) ([#4913](https://github.com/autogluon/autogluon/pull/4913), [#5057](https://github.com/autogluon/autogluon/pull/5057), [#5107](https://github.com/autogluon/autogluon/pull/5107))
- Add `raise_on_model_failure` `TabularPredictor.fit` argument, default to False. If True, will immediately raise the original exception if a model raises an exception during fit instead of continuing to the next model. Setting to True is very helpful when using a debugger to try to figure out why a model is failing, as otherwise exceptions are handled by AutoGluon which isn't desired while debugging. [@Innixma](https://github.com/Innixma) ([#4937](https://github.com/autogluon/autogluon/pull/4937), [#5055](https://github.com/autogluon/autogluon/pull/5055))

### Documentation
- Minor tutorial doc improvements/fixes. [@kbulygin](https://github.com/kbulygin) [@Innixma](https://github.com/Innixma) ([#4779](https://github.com/autogluon/autogluon/pull/4779), [#4777](https://github.com/autogluon/autogluon/pull/4777))
- Add Kaggle competition results. [@Innixma](https://github.com/Innixma) ([#4717](https://github.com/autogluon/autogluon/pull/4717), [#4770](https://github.com/autogluon/autogluon/pull/4770))

### Fixes and Improvements
- (**Major**) Ensure bagged refits in refit_full works properly (crashed in v1.2.0 due to a bug). [@Innixma](https://github.com/Innixma) ([#4870](https://github.com/autogluon/autogluon/pull/4870))
- Improve XGBoost and CatBoost memory estimates. [@Innixma](https://github.com/Innixma) ([#5090](https://github.com/autogluon/autogluon/pull/5090))
- Improve LightGBM memory estimates. [@Innixma](https://github.com/Innixma) ([#5101](https://github.com/autogluon/autogluon/pull/5101))
- Fixed plot_tabular_models save path. [@everdark](https://github.com/everdark) ([#4711](https://github.com/autogluon/autogluon/pull/4711))
- Fixed balanced_accuracy metric edge-case exception + added unit tests to ensure future bugs don't occur. [@Innixma](https://github.com/Innixma) ([#4775](https://github.com/autogluon/autogluon/pull/4775))
- Fix HPO logging verbosity. [@Innixma](https://github.com/Innixma) ([#4781](https://github.com/autogluon/autogluon/pull/4781))
- Improve logging for use_child_oof=True. [@Innixma](https://github.com/Innixma) ([#4780](https://github.com/autogluon/autogluon/pull/4780))
- Fix crash when NN_TORCH trains with fewer than 8 samples. [@Innixma](https://github.com/Innixma) ([#4790](https://github.com/autogluon/autogluon/pull/4790))
- Improve logging and documentation in CatBoost memory_check callback. [@celestinoxp](https://github.com/celestinoxp) ([#4802](https://github.com/autogluon/autogluon/pull/4802))
- Improve code formatting to satisfy PEP585. [@celestinoxp](https://github.com/celestinoxp) ([#4823](https://github.com/autogluon/autogluon/pull/4823))
- Remove deprecated TabularPredictor methods: [@Innixma](https://github.com/Innixma) ([#4906](https://github.com/autogluon/autogluon/pull/4906))
- (**FutureWarning**) `TabularPredictor.delete_models()` will default to `dry_run=False` in a future release (currently `dry_run=True`). Please ensure you explicitly specify `dry_run=True` for the existing logic to remain in future releases. [@Innixma](https://github.com/Innixma) ([#4905](https://github.com/autogluon/autogluon/pull/4905))
- Sped up tabular unit tests by 4x through various optimizations (3060s -> 743s). [@Innixma](https://github.com/Innixma) ([#4944](https://github.com/autogluon/autogluon/pull/4944))
- Major tabular unit test refactor to avoid using fixtures. [@Innixma](https://github.com/Innixma) ([#4949](https://github.com/autogluon/autogluon/pull/4949))
- Fix XGBoost GPU warnings. [@Innixma](https://github.com/Innixma) ([#4866](https://github.com/autogluon/autogluon/pull/4866))
- Fix `TabularPredictor.refit_full(train_data_extra)` failing when categorical features exist. [@Innixma](https://github.com/Innixma) ([#4948](https://github.com/autogluon/autogluon/pull/4948))
- Reduced memory usage of artifact created by `convert_simulation_artifacts_to_tabular_predictions_dict` by 4x. [@Innixma](https://github.com/Innixma) ([#5024](https://github.com/autogluon/autogluon/pull/5024))
- Minor fixes. [@shchur](https://github.com/shchur) ([#5030](https://github.com/autogluon/autogluon/pull/5030))
- Ensure that max model resources is respected during holdout model fit. [@Innixma](https://github.com/Innixma) ([#5067](https://github.com/autogluon/autogluon/pull/5067))
- Remove unintended setting of global random seed during LightGBM model fit. [@Innixma](https://github.com/Innixma) ([#5095](https://github.com/autogluon/autogluon/pull/5095))


------

## TimeSeries

The new v1.3 release brings numerous usability improvements and bug fixes to the TimeSeries module.
Internally, we completed a major refactor of the core classes and introduced static type checking to simplify future contributions, accelerate development, and catch potential bugs earlier.


### API Changes and Deprecations
* As part of the refactor, we made several changes to the internal `AbstractTimeSeriesModel` class. If you maintain a **custom model** implementation, you will likely need to update it. Please refer to the [custom forecasting model tutorial](https://auto.gluon.ai/stable/tutorials/timeseries/advanced/forecasting-custom-model.html) for details.

    No action is needed from the users that rely solely on the public API of the `timeseries` module (`TimeSeriesPredictor` and `TimeSeriesDataFrame`).


### New Features
* New tutorial on adding custom forecasting models by [@shchur](https://github.com/shchur) in [#4749](https://github.com/autogluon/autogluon/pull/4749)
* Add `cutoff` support in `evaluate` and `leaderboard` by [@abdulfatir](https://github.com/abdulfatir) in [#5078](https://github.com/autogluon/autogluon/pull/5078)
* Add `horizon_weight` support for `TimeSeriesPredictor` by [@shchur](https://github.com/shchur) in [#5084](https://github.com/autogluon/autogluon/pull/5084)
* Add `make_future_data_frame` method to TimeSeriesPredictor by [@shchur](https://github.com/shchur) in [#5051](https://github.com/autogluon/autogluon/pull/5051)
* Refactor ensemble base class and add new ensembles by [@canerturkmen](https://github.com/canerturkmen) in [#5062](https://github.com/autogluon/autogluon/pull/5062)

### Code Quality
* Add static type checking for the `timeseries` module by [@canerturkmen](https://github.com/canerturkmen) in [#4712](https://github.com/autogluon/autogluon/pull/4712) [#4788](https://github.com/autogluon/autogluon/pull/4788) [#4801](https://github.com/autogluon/autogluon/pull/4801) [#4821](https://github.com/autogluon/autogluon/pull/4821) [#4969](https://github.com/autogluon/autogluon/pull/4969) [#5086](https://github.com/autogluon/autogluon/pull/5086) [#5085](https://github.com/autogluon/autogluon/pull/5085)
* Refactor the `AbstractTimeSeriesModel` class by [@canerturkmen](https://github.com/canerturkmen) in [#4868](https://github.com/autogluon/autogluon/pull/4868) [#4909](https://github.com/autogluon/autogluon/pull/4909) [#4946](https://github.com/autogluon/autogluon/pull/4946) [#4958](https://github.com/autogluon/autogluon/pull/4958) [#5008](https://github.com/autogluon/autogluon/pull/5008) [#5038](https://github.com/autogluon/autogluon/pull/5038)
* Improvements to the unit tests by [@canerturkmen](https://github.com/canerturkmen) in [#4773](https://github.com/autogluon/autogluon/pull/4773) [#4828](https://github.com/autogluon/autogluon/pull/4828) [#4877](https://github.com/autogluon/autogluon/pull/4877) [#4872](https://github.com/autogluon/autogluon/pull/4872) [#4884](https://github.com/autogluon/autogluon/pull/4884) [#4888](https://github.com/autogluon/autogluon/pull/4888)

### Fixes and Improvements
* Allow using custom `distr_output` with the TFT model by [@shchur](https://github.com/shchur) in [#4899](https://github.com/autogluon/autogluon/pull/4899)
* Update version ranges for `statsforecast` & `coreforecast` by [@shchur](https://github.com/shchur) in [#4745](https://github.com/autogluon/autogluon/pull/4745)
* Fix feature importance calculation for models that use a `covariate_regressor` by [@canerturkmen](https://github.com/canerturkmen) in [#4845](https://github.com/autogluon/autogluon/pull/4845)
* Fix hyperparameter tuning for Chronos and other models by [@abdulfatir](https://github.com/abdulfatir) [@shchur](https://github.com/shchur) in [#4838](https://github.com/autogluon/autogluon/pull/4838) [#5075](https://github.com/autogluon/autogluon/pull/5075) [#5079](https://github.com/autogluon/autogluon/pull/5079)
* Fix frequency inference for `TimeSeriesDataFrame` by [@abdulfatir](https://github.com/abdulfatir) [@shchur](https://github.com/shchur) in [#4834](https://github.com/autogluon/autogluon/pull/4834) [#5066](https://github.com/autogluon/autogluon/pull/5066)
* Fix minor CovariateRegressor bugs by [@shchur](https://github.com/shchur) in [#4849](https://github.com/autogluon/autogluon/pull/4849)
* Update docs for custom `distr_output` by [@Killer3048](https://github.com/Killer3048) in [#5068](https://github.com/autogluon/autogluon/pull/5068)
* Minor documentation updates by [@shchur](https://github.com/shchur) in [#4928](https://github.com/autogluon/autogluon/pull/4928) [#5092](https://github.com/autogluon/autogluon/pull/5092)
* Raise informative error message if invalid model name is provided by [@shchur](https://github.com/shchur) in [#5004](https://github.com/autogluon/autogluon/pull/5004)
* Gracefully handle corrupted cached predictions by [@shchur](https://github.com/shchur) in [#5005](https://github.com/autogluon/autogluon/pull/5005)
* Chronos-Bolt: Fix scaling that affects constant series by [@abdulfatir](https://github.com/abdulfatir) in [#5013](https://github.com/autogluon/autogluon/pull/5013)
* Fix deprecated `evaluation_strategy` kwarg in `transformers` by [@abdulfatir](https://github.com/abdulfatir) in [#5019](https://github.com/autogluon/autogluon/pull/5019)
* Fix time_limit when val_data is provided [#5046](https://github.com/autogluon/autogluon/pull/5046) by [@shchur](https://github.com/shchur) in [#5059](https://github.com/autogluon/autogluon/pull/5059)
* Rename covariate metadata by [@canerturkmen](https://github.com/canerturkmen) in [#5064](https://github.com/autogluon/autogluon/pull/5064)
* Fix NaT timestamp values during resampling by [@shchur](https://github.com/shchur) in [#5080](https://github.com/autogluon/autogluon/pull/5080)
* Fix typing compatibility for py39 by [@suzhoum](https://github.com/suzhoum) [@shchur](https://github.com/shchur) in [#5094](https://github.com/autogluon/autogluon/pull/5094) [#5097](https://github.com/autogluon/autogluon/pull/5097)
* Warn if an S3 path is provided to the `TimeSeriesPredictor` by [@shchur](https://github.com/shchur) in [#5091](https://github.com/autogluon/autogluon/pull/5091)



------

## Multimodal

### New Features
AutoGluon's MultiModal module has been enhanced with a comprehensive "Bag of Tricks" update that significantly improves performance when working with combined image, text, and tabular data through advanced fusion techniques, data augmentation, and an integrated ensemble learner now accessible via a simple `use_ensemble=True` parameter after following the instruction [here](https://github.com/autogluon/autogluon/blob/2b90eb0f4a848941d70cd387c2fdec67bc67706d/multimodal/src/autogluon/multimodal/learners/ensemble.py#L306-L322) to download the checkpoints.

* [AutoMM] Bag of Tricks by [@zhiqiangdon](https://github.com/zhiqiangdon) in [#4737](https://github.com/autogluon/autogluon/pull/4737)

### Documentation
* [Tutorial] categorical convert_to_text default value by [@cheungdaven](https://github.com/cheungdaven) in [#4699](https://github.com/autogluon/autogluon/pull/4699)
* [AutoMM] Fix and Update Object Detection Tutorials by [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) in [#4889](https://github.com/autogluon/autogluon/pull/4889)

### Fixes and Improvements
* Update s3 path to public URL for AutoMM unit tests by [@suzhoum](https://github.com/suzhoum) in [#4809](https://github.com/autogluon/autogluon/pull/4809)
* Fix object detection tutorial and default behavior of predict by [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) in [#4865](https://github.com/autogluon/autogluon/pull/4865)
* Fix NLTK tagger path in download function by [@k-ken-t4g](https://github.com/k-ken-t4g) in [#4982](https://github.com/autogluon/autogluon/pull/4982)
* Fix AutoMM model saving logic by capping transformer range by [@tonyhoo](https://github.com/tonyhoo) in [#5007](https://github.com/autogluon/autogluon/pull/5007)
* fix: account for distributed training in learning rate schedule by [@tonyhoo](https://github.com/tonyhoo) in [#5003](https://github.com/autogluon/autogluon/pull/5003)

--------

## Special Thanks
* [Zhiqiang Tang](https://github.com/zhiqiangdon) for implementing "Bag of Tricks" for AutoGluon's MultiModal, which significantly enhances the multimodal performance.
* [Caner Turkmen](https://github.com/canerturkmen) for leading the efforts on refactoring and improving the internal logic in the `timeseries` module.
* [Celestino](https://github.com/celestinoxp) for providing numerous bug reports, suggestions, and code cleanup as a new contributor.

## Contributors

Full Contributor List (ordered by # of commits):

[@Innixma](https://github.com/Innixma) [@shchur](https://github.com/shchur) [@canerturkmen](https://github.com/canerturkmen) [@tonyhoo](https://github.com/tonyhoo) [@abdulfatir](https://github.com/abdulfatir) [@celestinoxp](https://github.com/celestinoxp) [@suzhoum](https://github.com/suzhoum) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@prateekdesai04](https://github.com/prateekdesai04) [@zhiqiangdon](https://github.com/zhiqiangdon)
[@cheungdaven](https://github.com/cheungdaven) [@LennartPurucker](https://github.com/LennartPurucker) [@abhishek-iitmadras](https://github.com/abhishek-iitmadras) [@zkalson](https://github.com/zkalson) [@nathanaelbosch](https://github.com/nathanaelbosch) [@Killer3048](https://github.com/Killer3048) [@FireballDWF](https://github.com/FireballDWF) [@timostrunk](https://github.com/timostrunk) [@everdark](https://github.com/everdark) [@kbulygin](https://github.com/kbulygin) [@PGijsbers](https://github.com/PGijsbers) [@k-ken-t4g](https://github.com/k-ken-t4g)


### New Contributors
* [@everdark](https://github.com/everdark) made their first contribution in [#4711](https://github.com/autogluon/autogluon/pull/4711)
* [@kbulygin](https://github.com/kbulygin) made their first contribution in [#4777](https://github.com/autogluon/autogluon/pull/4777)
* [@celestinoxp](https://github.com/celestinoxp) made their first contribution in [#4796](https://github.com/autogluon/autogluon/pull/4796)
* [@PGijsbers](https://github.com/PGijsbers) made their first contribution in [#4891](https://github.com/autogluon/autogluon/pull/4891)
* [@k-ken-t4g](https://github.com/k-ken-t4g) made their first contribution in [#4982](https://github.com/autogluon/autogluon/pull/4982)
* [@FireballDWF](https://github.com/FireballDWF) made their first contribution in [#5000](https://github.com/autogluon/autogluon/pull/5000)
* [@Killer3048](https://github.com/Killer3048) made their first contribution in [#5068](https://github.com/autogluon/autogluon/pull/5068)
