# Version 1.1.1

We're happy to announce the AutoGluon 1.1.1 release.

AutoGluon 1.1.1 contains bug fixes and logging improvements for Tabular, TimeSeries, and Multimodal modules, as well as support for PyTorch 2.2 and 2.3.

Join the community: [![](https://img.shields.io/discord/1043248669505368144?logo=discord&style=flat)](https://discord.gg/wjUmjqAc2N)  
Get the latest updates: [![Twitter](https://img.shields.io/twitter/follow/autogluon?style=social)](https://twitter.com/autogluon)

This release supports Python versions 3.8, 3.9, 3.10, and 3.11. Loading models trained on older versions of AutoGluon is not supported. Please re-train models using AutoGluon 1.1.1.

This release contains **[52 commits from 10 contributors](https://github.com/autogluon/autogluon/compare/v1.1.0...v1.1.1)**!

## General
- Add support for PyTorch 2.2. [@prateekdesai04](https://github.com/prateekdesai04) ([#4123](https://github.com/autogluon/autogluon/pull/4123))
- Add support for PyTorch 2.3. [@suzhoum](https://github.com/suzhoum) ([#4239](https://github.com/autogluon/autogluon/pull/4239), [#4256](https://github.com/autogluon/autogluon/pull/4256))
- Upgrade GluonTS to 0.15.1. [@shchur](https://github.com/shchur) ([#4231](https://github.com/autogluon/autogluon/pull/4231))

## Tabular
Note: Trying to load a TabularPredictor with a FastAI model trained on a previous AutoGluon release will raise an exception when calling `predict` due to a fix in the `model-interals.pkl` path. Please ensure matching versions.

- Fix deadlock when `num_gpus>0` and dynamic_stacking is enabled. [@Innixma](https://github.com/Innixma) ([#4208](https://github.com/autogluon/autogluon/pull/4208))
- Improve decision threshold calibration. [@Innixma](https://github.com/Innixma) ([#4136](https://github.com/autogluon/autogluon/pull/4136), [#4137](https://github.com/autogluon/autogluon/pull/4137))
- Improve dynamic stacking logging. [@Innixma](https://github.com/Innixma) ([#4208](https://github.com/autogluon/autogluon/pull/4208), [#4262](https://github.com/autogluon/autogluon/pull/4262))
- Fix regression metrics (other than RMSE and MSE) being calculated incorrectly for LightGBM early stopping. [@Innixma](https://github.com/Innixma) ([#4174](https://github.com/autogluon/autogluon/pull/4174))
- Fix custom multiclass metrics being calculated incorrectly for LightGBM early stopping. [@Innixma](https://github.com/Innixma) ([#4250](https://github.com/autogluon/autogluon/pull/4250))
- Fix HPO crashing with NN_TORCH and FASTAI models. [@Innixma](https://github.com/Innixma) ([#4232](https://github.com/autogluon/autogluon/pull/4232))
- Improve NN_TORCH runtime estimate. [@Innixma](https://github.com/Innixma) ([#4247](https://github.com/autogluon/autogluon/pull/4247))
- Add infer throughput logging. [@Innixma](https://github.com/Innixma) ([#4200](https://github.com/autogluon/autogluon/pull/4200))
- Disable sklearnex for linear models due to observed performance degradation. [@Innixma](https://github.com/Innixma) ([#4223](https://github.com/autogluon/autogluon/pull/4223))
- Improve sklearnex logging verbosity in Kaggle. [@Innixma](https://github.com/Innixma) ([#4216](https://github.com/autogluon/autogluon/pull/4216))
- Rename cached version file to version.txt. [@Innixma](https://github.com/Innixma) ([#4203](https://github.com/autogluon/autogluon/pull/4203))
- Add refit_full support for Linear models. [@Innixma](https://github.com/Innixma) ([#4222](https://github.com/autogluon/autogluon/pull/4222))
- Add AsTypeFeatureGenerator detailed exception logging. [@Innixma](https://github.com/Innixma) ([#4251](https://github.com/autogluon/autogluon/pull/4251), [#4252](https://github.com/autogluon/autogluon/pull/4252))

## TimeSeries
- Ensure prediction_length is stored as an integer. [@shchur](https://github.com/shchur) ([#4160](https://github.com/autogluon/autogluon/pull/4160))
- Fix tabular model preprocessing failure edge-case. [@shchur](https://github.com/shchur) ([#4175](https://github.com/autogluon/autogluon/pull/4175))
- Fix loading of Tabular models failure if predictor moved to a different directory. [@shchur](https://github.com/shchur) ([#4171](https://github.com/autogluon/autogluon/pull/4171))
- Fix cached predictions error when predictor saved on-top of an existing predictor. [@shchur](https://github.com/shchur) ([#4202](https://github.com/autogluon/autogluon/pull/4202))
- Use AutoGluon forks of Chronos models. [@shchur](https://github.com/shchur) ([#4198](https://github.com/autogluon/autogluon/pull/4198))
- Fix off-by-one bug in Chronos inference. [@canerturkmen](https://github.com/canerturkmen) ([#4205](https://github.com/autogluon/autogluon/pull/4205))
- Rename cached version file to version.txt. [@Innixma](https://github.com/Innixma) ([#4203](https://github.com/autogluon/autogluon/pull/4203))
- Use correct target and quantile_levels in fallback model for MLForecast. [@shchur](https://github.com/shchur) ([#4230](https://github.com/autogluon/autogluon/pull/4230))

## Multimodal
- Fix bug in CLIP's image feature normalization. [@Harry-zzh](https://github.com/Harry-zzh) ([#4114](https://github.com/autogluon/autogluon/pull/4114))
- Fix bug in text augmentation. [@Harry-zzh](https://github.com/Harry-zzh) ([#4115](https://github.com/autogluon/autogluon/pull/4115))
- Modify default fine-tuning tricks. [@Harry-zzh](https://github.com/Harry-zzh) ([#4166](https://github.com/autogluon/autogluon/pull/4166))
- Add PyTorch version warning for object detection. [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#4217](https://github.com/autogluon/autogluon/pull/4217))

## Docs and CI
- Add competition solutions to `AWESOME.md`. [@Innixma](https://github.com/Innixma) [@shchur](https://github.com/shchur) ([#4122](https://github.com/autogluon/autogluon/pull/4122), [#4163](https://github.com/autogluon/autogluon/pull/4163), [#4245](https://github.com/autogluon/autogluon/pull/4245))
- Fix PDF classification tutorial. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#4127](https://github.com/autogluon/autogluon/pull/4127))
- Add AutoMM paper citation. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#4154](https://github.com/autogluon/autogluon/pull/4154))
- Add pickle load warning in all modules and tutorials. [@shchur](https://github.com/shchur) ([#4243](https://github.com/autogluon/autogluon/pull/4243))
- Various minor doc and test fixes and improvements. [@tonyhoo](https://github.com/tonyhoo) [@shchur](https://github.com/shchur) [@lovvge](https://github.com/lovvge) [@Innixma](https://github.com/Innixma) [@suzhoum](https://github.com/suzhoum) ([#4113](https://github.com/autogluon/autogluon/pull/4113), [#4176](https://github.com/autogluon/autogluon/pull/4176), [#4225](https://github.com/autogluon/autogluon/pull/4225), [#4233](https://github.com/autogluon/autogluon/pull/4233), [#4235](https://github.com/autogluon/autogluon/pull/4235), [#4249](https://github.com/autogluon/autogluon/pull/4249), [#4266](https://github.com/autogluon/autogluon/pull/4266))

## Contributors

Full Contributor List (ordered by # of commits):

[@Innixma](https://github.com/Innixma) [@shchur](https://github.com/shchur) [@Harry-zzh](https://github.com/Harry-zzh) [@suzhoum](https://github.com/suzhoum) [@zhiqiangdon](https://github.com/zhiqiangdon) [@lovvge](https://github.com/lovvge) [@rey-allan](https://github.com/rey-allan) [@prateekdesai04](https://github.com/prateekdesai04) [@canerturkmen](https://github.com/canerturkmen) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) 

### New Contributors
* [@lovvge](https://github.com/lovvge) made their first contribution in https://github.com/autogluon/autogluon/commit/57a15fcfbbbc94514ff20ed2774cd447d9f4115f
* [@rey-allan](https://github.com/rey-allan) made their first contribution in [#4145](https://github.com/autogluon/autogluon/pull/4145)