# Version 1.1.0

We're happy to announce the AutoGluon 1.1 release.

AutoGluon 1.1 contains major improvements to the TimeSeries module, achieving a 60% win-rate vs AutoGluon 1.0 through the addition of Chronos, a pretrained model for time series forecasting, along with numerous other enhancements.
The other modules have also been enhanced through new features such as Conv-LORA support and improved performance for large tabular datasets between 5 - 30 GB in size. 
For a full breakdown of AutoGluon 1.1 features, please refer to the feature spotlights and the itemized enhancements below.

Join the community: [![](https://img.shields.io/discord/1043248669505368144?logo=discord&style=flat)](https://discord.gg/wjUmjqAc2N)  
Get the latest updates: [![Twitter](https://img.shields.io/twitter/follow/autogluon?style=social)](https://twitter.com/autogluon)

This release supports Python versions 3.8, 3.9, 3.10, and 3.11. Loading models trained on older versions of AutoGluon is not supported. Please re-train models using AutoGluon 1.1.

This release contains [121 commits from 20 contributors](https://github.com/autogluon/autogluon/compare/v1.0.0...v1.1.0)!

Full Contributor List (ordered by # of commits):

[@shchur](https://github.com/shchur) [@prateekdesai04](https://github.com/prateekdesai04) [@Innixma](https://github.com/Innixma) [@canerturkmen](https://github.com/canerturkmen) [@zhiqiangdon](https://github.com/zhiqiangdon) [@tonyhoo](https://github.com/tonyhoo) [@AnirudhDagar](https://github.com/AnirudhDagar) [@Harry-zzh](https://github.com/Harry-zzh) [@suzhoum](https://github.com/suzhoum) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@nimasteryang](https://github.com/nimasteryang) [@lostella](https://github.com/lostella) [@dassaswat](https://github.com/dassaswat) [@afmkt](https://github.com/afmkt) [@npepin-hub](https://github.com/npepin-hub) [@mglowacki100](https://github.com/mglowacki100) [@ddelange](https://github.com/ddelange) [@LennartPurucker](https://github.com/LennartPurucker) [@taoyang1122](https://github.com/taoyang1122) [@gradientsky](https://github.com/gradientsky)

Special thanks to [@ddelange](https://github.com/ddelange) for their continued assistance with Python 3.11 support and Ray version upgrades!

## Spotlight

### AutoGluon Achieves Top Placements in ML Competitions!

AutoGluon has experienced [wide-spread adoption on Kaggle](https://www.kaggle.com/search?q=autogluon+sortBy%3Adate) since the AutoGluon 1.0 release. 
AutoGluon has been used in over 130 Kaggle notebooks and mentioned in over 100 discussion threads in the past 90 days!
Most excitingly, AutoGluon has already been used to achieve top ranking placements in multiple competitions with thousands of competitors since the start of 2024:

| Placement                                | Competition                                                                                                                                       | Author                                             | Date       | AutoGluon Details | Notes                          |
|:-----------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------|:---------------------------------------------------|:-----------|:------------------|:-------------------------------|
| :3rd_place_medal: Rank 3/2303 (Top 0.1%) | [Steel Plate Defect Prediction](https://www.kaggle.com/competitions/playground-series-s4e3/discussion/488127)                                     | [Samvel Kocharyan](https://github.com/samvelkoch)  | 2024/03/31 | v1.0, Tabular     | Kaggle Playground Series S4E3  |
| :2nd_place_medal: Rank 2/93 (Top 2%)     | [Prediction Interval Competition I: Birth Weight](https://www.kaggle.com/competitions/prediction-interval-competition-i-birth-weight/leaderboard) | [Oleksandr Shchur](https://shchur.github.io/)      | 2024/03/21 | v1.0, Tabular     |                                |
| :2nd_place_medal: Rank 2/1542 (Top 0.1%) | [WiDS Datathon 2024 Challenge #1](https://www.kaggle.com/competitions/widsdatathon2024-challenge1/discussion/482285)                              | [lazy_panda](https://www.kaggle.com/byteliberator) | 2024/03/01 | v1.0, Tabular     |                                |
| :2nd_place_medal: Rank 2/3746 (Top 0.1%) | [Multi-Class Prediction of Obesity Risk](https://www.kaggle.com/competitions/playground-series-s4e2/discussion/480939)                            | [Kirderf](https://twitter.com/kirderf9)            | 2024/02/29 | v1.0, Tabular     | Kaggle Playground Series S4E2  |
| :2nd_place_medal: Rank 2/3777 (Top 0.1%) | [Binary Classification with a Bank Churn Dataset](https://www.kaggle.com/competitions/playground-series-s4e1/discussion/472496)                   | [lukaszl](https://www.kaggle.com/lukaszl)          | 2024/01/31 | v1.0, Tabular     | Kaggle Playground Series S4E1  |
| Rank 4/1718 (Top 0.2%)                   | [Multi-Class Prediction of Cirrhosis Outcomes](https://www.kaggle.com/competitions/playground-series-s3e26/discussion/464863)                     | [Kirderf](https://twitter.com/kirderf9)            | 2024/01/01 | v1.0, Tabular     | Kaggle Playground Series S3E26 |

We are thrilled that the data science community is leveraging AutoGluon as their go-to method to quickly and effectively achieve top-ranking ML solutions! 
For an up-to-date list of competition solutions using AutoGluon refer to our [AWESOME.md](https://github.com/autogluon/autogluon/blob/master/AWESOME.md#competition-solutions-using-autogluon), 
and don't hesitate to let us know if you used AutoGluon in a competition!

### Chronos, a pretrained model for time series forecasting

AutoGluon-TimeSeries now features [Chronos](https://arxiv.org/abs/2403.07815), a family of forecasting models pretrained on large collections of open-source time series datasets that can generate accurate zero-shot predictions for new unseen data. Check out the [new tutorial](https://auto.gluon.ai/stable/tutorials/timeseries/forecasting-chronos.html) to learn how to use Chronos through the familiar `TimeSeriesPredictor` API.


## General

- Refactor project README & project Tagline [@Innixma](https://github.com/Innixma) ([#3861](https://github.com/autogluon/autogluon/pull/3861), [#4066](https://github.com/autogluon/autogluon/pull/4066))
- Add AWESOME.md competition results and other doc improvements. [@Innixma](https://github.com/Innixma) ([#4023](https://github.com/autogluon/autogluon/pull/4023))
- Pandas version upgrade. [@shchur](https://github.com/shchur) [@Innixma](https://github.com/Innixma) ([#4079](https://github.com/autogluon/autogluon/pull/4079), [#4089](https://github.com/autogluon/autogluon/pull/4089))
- PyTorch, CUDA, Lightning version upgrades. [@prateekdesai04](https://github.com/prateekdesai04) [@canerturkmen](https://github.com/canerturkmen) [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3982](https://github.com/autogluon/autogluon/pull/3982), [#3984](https://github.com/autogluon/autogluon/pull/3984), [#3991](https://github.com/autogluon/autogluon/pull/3991), [#4006](https://github.com/autogluon/autogluon/pull/4006))
- Ray version upgrade. [@ddelange](https://github.com/ddelange) [@tonyhoo](https://github.com/tonyhoo) ([#3774](https://github.com/autogluon/autogluon/pull/3774), [#3956](https://github.com/autogluon/autogluon/pull/3956))
- Scikit-learn version upgrade. [@prateekdesai04](https://github.com/prateekdesai04) ([#3872](https://github.com/autogluon/autogluon/pull/3872), [#3881](https://github.com/autogluon/autogluon/pull/3881), [#3947](https://github.com/autogluon/autogluon/pull/3947))
- Various dependency upgrades. [@Innixma](https://github.com/Innixma) [@tonyhoo](https://github.com/tonyhoo) ([#4024](https://github.com/autogluon/autogluon/pull/4024), [#4083](https://github.com/autogluon/autogluon/pull/4083))

## TimeSeries

### Highlights
AutoGluon 1.1 comes with numerous new features and improvements to the time series module. These include highly requested functionality such as feature importance,
support for categorical covariates, ability to visualize forecasts, and enhancements to logging.
The new release also comes with considerable improvements to forecast accuracy, achieving 60% win rate and 3% average error reduction compared to the previous AutoGluon version. These improvements are mostly attributed to the addition of Chronos, improved preprocessing logic, and native handling of missing values.


### New Features
- Add Chronos pretrained forecasting model ([tutorial](https://auto.gluon.ai/stable/tutorials/timeseries/forecasting-chronos.html)). [@canerturkmen](https://github.com/canerturkmen) [@shchur](https://github.com/shchur) [@lostella](https://github.com/lostella) ([#3978](https://github.com/autogluon/autogluon/pull/3978), [#4013](https://github.com/autogluon/autogluon/pull/4013), [#4052](https://github.com/autogluon/autogluon/pull/4052), [#4055](https://github.com/autogluon/autogluon/pull/4055), [#4056](https://github.com/autogluon/autogluon/pull/4056), [#4061](https://github.com/autogluon/autogluon/pull/4061), [#4092](https://github.com/autogluon/autogluon/pull/4092), [#4098](https://github.com/autogluon/autogluon/pull/4098))
- Measure the importance of features & covariates on the forecast accuracy with `TimeSeriesPredictor.feature_importance()`. [@canerturkmen](https://github.com/canerturkmen) ([#4033](https://github.com/autogluon/autogluon/pull/4033), [#4087](https://github.com/autogluon/autogluon/pull/4087))
- Native missing values support (no imputation required). [@shchur](https://github.com/shchur) ([#3995](https://github.com/autogluon/autogluon/pull/3995), [#4068](https://github.com/autogluon/autogluon/pull/4068), [#4091](https://github.com/autogluon/autogluon/pull/4091))
- Add support for categorical covariates. [@shchur](https://github.com/shchur) ([#3874](https://github.com/autogluon/autogluon/pull/3874), [#4037](https://github.com/autogluon/autogluon/pull/4037))
- Improve inference speed by persisting models in memory with `TimeSeriesPredictor.persist()`. [@canerturkmen](https://github.com/canerturkmen) ([#4005](https://github.com/autogluon/autogluon/pull/4005))
- Visualize forecasts with `TimeSeriesPredictor.plot()`. [@shchur](https://github.com/shchur) ([#3889](https://github.com/autogluon/autogluon/pull/3889))
- Add `RMSLE` evaluation metric. [@canerturkmen](https://github.com/canerturkmen) ([#3938](https://github.com/autogluon/autogluon/pull/3938))
- Enable logging to file. [@canerturkmen](https://github.com/canerturkmen) ([#3877](https://github.com/autogluon/autogluon/pull/3877))
- Add option to keep lightning logs after training with `keep_lightning_logs` hyperparameter. [@shchur](https://github.com/shchur) ([#3937](https://github.com/autogluon/autogluon/pull/3937))

### Fixes and Improvements
- Automatically preprocess real-valued covariates [@shchur](https://github.com/shchur) ([#4042](https://github.com/autogluon/autogluon/pull/4042), [#4069](https://github.com/autogluon/autogluon/pull/4069))
- Add option to skip model selection when only one model is trained. [@shchur](https://github.com/shchur) ([#4002](https://github.com/autogluon/autogluon/pull/4002))
- Ensure all metrics handle missing values in target [@shchur](https://github.com/shchur) ([#3966](https://github.com/autogluon/autogluon/pull/3966))
- Fix bug when loading a GPU trained model on a CPU machine [@shchur](https://github.com/shchur) ([#3979](https://github.com/autogluon/autogluon/pull/3979))
- Fix inconsistent random seed. [@canerturkmen](https://github.com/canerturkmen) [@shchur](https://github.com/shchur) ([#3934](https://github.com/autogluon/autogluon/pull/3934), [#4099](https://github.com/autogluon/autogluon/pull/4099))
- Fix crash when calling .info after load. [@afmkt](https://github.com/afmkt) ([#3900](https://github.com/autogluon/autogluon/pull/3900))
- Fix leaderboard crash when no models trained. [@shchur](https://github.com/shchur) ([#3849](https://github.com/autogluon/autogluon/pull/3849))
- Add prototype TabRepo simulation artifact generation. [@shchur](https://github.com/shchur) ([#3829](https://github.com/autogluon/autogluon/pull/3829))
- Fix refit_full bug. [@shchur](https://github.com/shchur) ([#3820](https://github.com/autogluon/autogluon/pull/3820))
- Documentation improvements, hide deprecated methods. [@shchur](https://github.com/shchur) ([#3764](https://github.com/autogluon/autogluon/pull/3764), [#4054](https://github.com/autogluon/autogluon/pull/4054), [#4098](https://github.com/autogluon/autogluon/pull/4098)) 
- Minor fixes. [@canerturkmen](https://github.com/canerturkmen), [@shchur](https://github.com/shchur), [@AnirudhDagar](https://github.com/AnirudhDagar) ([#4009](https://github.com/autogluon/autogluon/pull/4009), [#4040](https://github.com/autogluon/autogluon/pull/4040), [#4041](https://github.com/autogluon/autogluon/pull/4041), [#4051](https://github.com/autogluon/autogluon/pull/4051), [#4070](https://github.com/autogluon/autogluon/pull/4070), [#4094](https://github.com/autogluon/autogluon/pull/4094))

## AutoMM

### Highlights

AutoMM 1.1 introduces the innovative Conv-LoRA, 
a parameter-efficient fine-tuning (PEFT) method stemming from our latest paper presented at ICLR 2024, 
titled "[Convolution Meets LoRA: Parameter Efficient Finetuning for Segment Anything Model](https://arxiv.org/abs/2401.17868)". 
Conv-LoRA is designed for fine-tuning the Segment Anything Model, 
exhibiting superior performance compared to previous PEFT approaches, 
such as LoRA and visual prompt tuning, 
across various semantic segmentation tasks in diverse domains 
including natural images, agriculture, remote sensing, and healthcare. Check out [our Conv-LoRA example](https://github.com/autogluon/autogluon/tree/master/examples/automm/Conv-LoRA).

### New Features

- Added Conv-LoRA, a new parameter efficient fine-tuning method. [@Harry-zzh](https://github.com/Harry-zzh) [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3933](https://github.com/autogluon/autogluon/pull/3933), [#3999](https://github.com/autogluon/autogluon/pull/3999), [#4007](https://github.com/autogluon/autogluon/pull/4007), [#4022](https://github.com/autogluon/autogluon/pull/4022), [#4025](https://github.com/autogluon/autogluon/pull/4025))
- Added support for new column type: 'image_base64_str'. [@Harry-zzh](https://github.com/Harry-zzh) [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3867](https://github.com/autogluon/autogluon/pull/3867))
- Added support for loading pre-trained weights in FT-Transformer. [@taoyang1122](https://github.com/taoyang1122) [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3859](https://github.com/autogluon/autogluon/pull/3859))

### Fixes and Improvements

- Fixed bugs in semantic segmentation. [@Harry-zzh](https://github.com/Harry-zzh) ([#3801](https://github.com/autogluon/autogluon/pull/3801), [#3812](https://github.com/autogluon/autogluon/pull/3812))
- Fixed crashes when using F1 metric. [@suzhoum](https://github.com/suzhoum) ([#3822](https://github.com/autogluon/autogluon/pull/3822))
- Fixed bugs in PEFT methods. [@Harry-zzh](https://github.com/Harry-zzh) ([#3840](https://github.com/autogluon/autogluon/pull/3840))
- Accelerated object detection training by ~30\% for the high_quality and best_quality presets. [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#3970](https://github.com/autogluon/autogluon/pull/3970))
- Depreciated Grounding-DINO [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#3974](https://github.com/autogluon/autogluon/pull/3974))
- Fixed lightning upgrade issues [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3991](https://github.com/autogluon/autogluon/pull/3991))
- Fixed using f1, f1_macro, f1_micro for binary classification in knowledge distillation. [@nimasteryang](https://github.com/nimasteryang) ([#3837](https://github.com/autogluon/autogluon/pull/3837))
- Removed MyMuPDF from installation due to the license issue. Users need to install it by themselves to do document classification. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#4093](https://github.com/autogluon/autogluon/pull/4093))


## Tabular

### Highlights
AutoGluon-Tabular 1.1 primarily focuses on bug fixes and stability improvements. In particular, we have greatly improved the runtime performance for large datasets between 5 - 30 GB in size through the usage of subsampling for decision threshold calibration and the weighted ensemble fitting to 1 million rows, maintaining the same quality while being far faster to execute. We also adjusted the default weighted ensemble iterations from 100 to 25, which will speedup all weighted ensemble fit times by 4x. We heavily refactored the `fit_pseudolabel` logic, and it should now achieve noticeably stronger results.

### Fixes and Improvements
- Fix return value in `predictor.fit_weighted_ensemble(refit_full=True)`. [@Innixma](https://github.com/Innixma) ([#1956](https://github.com/autogluon/autogluon/pull/1956))
- Enhance performance on large datasets through subsampling. [@Innixma](https://github.com/Innixma) ([#3977](https://github.com/autogluon/autogluon/pull/3977))
- Fix refit_full crash when out of memory. [@Innixma](https://github.com/Innixma) ([#3977](https://github.com/autogluon/autogluon/pull/3977))
- Refactor and enhance `.fit_pseudolabel` logic. [@Innixma](https://github.com/Innixma) ([#3930](https://github.com/autogluon/autogluon/pull/3930))
- Fix crash in memory check during HPO for LightGBM, CatBoost, and XGBoost. [@Innixma](https://github.com/Innixma) ([#3931](https://github.com/autogluon/autogluon/pull/3931))
- Fix dynamic stacking on windows. [@Innixma](https://github.com/Innixma) ([#3893](https://github.com/autogluon/autogluon/pull/3893))
- LightGBM version upgrade. [@mglowacki100](https://github.com/mglowacki100), [@Innixma](https://github.com/Innixma) ([#3427](https://github.com/autogluon/autogluon/pull/3427))
- Fix memory-safe sub-fits being skipped if Ray is not initialized. [@LennartPurucker](https://github.com/LennartPurucker) ([#3868](https://github.com/autogluon/autogluon/pull/3868))
- Logging improvements. [@AnirudhDagar](https://github.com/AnirudhDagar) ([#3873](https://github.com/autogluon/autogluon/pull/3873))
- Hide deprecated methods. [@Innixma](https://github.com/Innixma) ([#3795](https://github.com/autogluon/autogluon/pull/3795))
- Documentation improvements. [@Innixma](https://github.com/Innixma) [@AnirudhDagar](https://github.com/AnirudhDagar) ([#2024](https://github.com/autogluon/autogluon/pull/2024), [#3975](https://github.com/autogluon/autogluon/pull/3975), [#3976](https://github.com/autogluon/autogluon/pull/3976), [#3996](https://github.com/autogluon/autogluon/pull/3996))

## Docs and CI
- Add auto benchmarking report generation. [@prateekdesai04](https://github.com/prateekdesai04) ([#4038](https://github.com/autogluon/autogluon/pull/4038), [#4039](https://github.com/autogluon/autogluon/pull/4039))
- Fix tabular tests for Windows. [@tonyhoo](https://github.com/tonyhoo) ([#4036](https://github.com/autogluon/autogluon/pull/4036))
- Fix hanging tabular unit tests. [@prateekdesai04](https://github.com/prateekdesai04) ([#4031](https://github.com/autogluon/autogluon/pull/4031))
- Fix CI evaluation. [@suzhoum](https://github.com/suzhoum) ([#4019](https://github.com/autogluon/autogluon/pull/4019))
- Add package version comparison between CI runs [@prateekdesai04](https://github.com/prateekdesai04) ([#3962](https://github.com/autogluon/autogluon/pull/3962), [#3968](https://github.com/autogluon/autogluon/pull/3968), [#3972](https://github.com/autogluon/autogluon/pull/3972))
- Update conf.py to reflect current year. [@dassaswat](https://github.com/dassaswat) ([#3932](https://github.com/autogluon/autogluon/pull/3932))
- Avoid redundant unit test runs. [@prateekdesai04](https://github.com/prateekdesai04) ([#3942](https://github.com/autogluon/autogluon/pull/3942))
- Fix colab notebook links [@prateekdesai04](https://github.com/prateekdesai04) ([#3926](https://github.com/autogluon/autogluon/pull/3926))
