# Version 0.8.0
We're happy to announce the AutoGluon 0.8 release.

Note: Loading models trained in different versions of AutoGluon is not supported.

This release contains 196 commits from 20 contributors!

See the full commit change-log here: https://github.com/autogluon/autogluon/compare/0.7.0...0.8.0

Special thanks to [@geoalgo](https://github.com/geoalgo) for the joint work in generating the experimental tabular Zeroshot-HPO portfolio this release!

Full Contributor List (ordered by # of commits):

[@shchur](https://github.com/shchur), [@Innixma](https://github.com/Innixma), [@yinweisu](https://github.com/yinweisu), [@gradientsky](https://github.com/gradientsky), [@FANGAreNotGnu](https://github.com/FANGAreNotGnu), [@zhiqiangdon](https://github.com/zhiqiangdon), [@gidler](https://github.com/gidler), [@liangfu](https://github.com/liangfu), [@tonyhoo](https://github.com/tonyhoo), [@cheungdaven](https://github.com/cheungdaven), [@cnpgs](https://github.com/cnpgs), [@giswqs](https://github.com/giswqs), [@suzhoum](https://github.com/suzhoum), [@yongxinw](https://github.com/yongxinw), [@isunli](https://github.com/isunli), [@jjaeyeon](https://github.com/jjaeyeon), [@xiaochenbin9527](https://github.com/xiaochenbin9527), [@yzhliu](https://github.com/yzhliu), [@jsharpna](https://github.com/jsharpna), [@sxjscience](https://github.com/sxjscience)

AutoGluon 0.8 supports Python versions 3.8, 3.9, and 3.10.

## Changes

### Highlights
* AutoGluon TimeSeries introduced several major improvements, including new models, upgraded presets that lead to better forecast accuracy, and optimizations that speed up training & inference.
* AutoGluon Tabular now supports **[calibrating the decision threshold in binary classification](https://auto.gluon.ai/stable/tutorials/tabular/tabular-indepth.html#decision-threshold-calibration)** ([API](https://auto.gluon.ai/stable/api/autogluon.tabular.TabularPredictor.calibrate_decision_threshold.html)), leading to massive improvements in metrics such as `f1` and `balanced_accuracy`. It is not uncommon to see `f1` scores improve from `0.70` to `0.73` as an example. We **strongly** encourage all users who are using these metrics to try out the new decision threshold calibration logic.
* AutoGluon MultiModal introduces two new features: 1) **PDF document classification**, and 2) **Open Vocabulary Object Detection**.
* AutoGluon MultiModal upgraded the presets for object detection, now offering `medium_quality`, `high_quality`, and `best_quality` options. The empirical results demonstrate significant ~20% relative improvements in the mAP (mean Average Precision) metric, using the same preset.
* AutoGluon Tabular has added an experimental **Zeroshot HPO config** which performs well on small datasets <10000 rows when at least an hour of training time is provided (~60% win-rate vs `best_quality`). To try it out, specify `presets="experimental_zeroshot_hpo_hybrid"` when calling `fit()`.
* AutoGluon EDA added support for **Anomaly Detection** and **Partial Dependence Plots**.
* AutoGluon Tabular has added experimental support for **[TabPFN](https://github.com/automl/TabPFN)**, a pre-trained tabular transformer model. Try it out via `pip install autogluon.tabular[all,tabpfn]` (hyperparameter key is "TABPFN")!

### General
* General doc improvements [@tonyhoo](https://github.com/tonyhoo) [@Innixma](https://github.com/Innixma) [@yinweisu](https://github.com/yinweisu) [@gidler](https://github.com/gidler) [@cnpgs](https://github.com/cnpgs) [@isunli](https://github.com/isunli) [@giswqs](https://github.com/giswqs) ([#2940](https://github.com/autogluon/autogluon/pull/2940), [#2953](https://github.com/autogluon/autogluon/pull/2953), [#2963](https://github.com/autogluon/autogluon/pull/2963), [#3007](https://github.com/autogluon/autogluon/pull/3007), [#3027](https://github.com/autogluon/autogluon/pull/3027), [#3059](https://github.com/autogluon/autogluon/pull/3059), [#3068](https://github.com/autogluon/autogluon/pull/3068), [#3083](https://github.com/autogluon/autogluon/pull/3083), [#3128](https://github.com/autogluon/autogluon/pull/3128), [#3129](https://github.com/autogluon/autogluon/pull/3129), [#3130](https://github.com/autogluon/autogluon/pull/3130), [#3147](https://github.com/autogluon/autogluon/pull/3147), [#3174](https://github.com/autogluon/autogluon/pull/3174), [#3187](https://github.com/autogluon/autogluon/pull/3187), [#3256](https://github.com/autogluon/autogluon/pull/3256), [#3258](https://github.com/autogluon/autogluon/pull/3258), [#3280](https://github.com/autogluon/autogluon/pull/3280), [#3306](https://github.com/autogluon/autogluon/pull/3306), [#3307](https://github.com/autogluon/autogluon/pull/3307), [#3311](https://github.com/autogluon/autogluon/pull/3311), [#3313](https://github.com/autogluon/autogluon/pull/3313))
* General code fixes and improvements [@yinweisu](https://github.com/yinweisu) [@Innixma](https://github.com/Innixma) ([#2921](https://github.com/autogluon/autogluon/pull/2921), [#3078](https://github.com/autogluon/autogluon/pull/3078), [#3113](https://github.com/autogluon/autogluon/pull/3113), [#3140](https://github.com/autogluon/autogluon/pull/3140), [#3206](https://github.com/autogluon/autogluon/pull/3206))
* CI improvements [@yinweisu](https://github.com/yinweisu) [@gidler](https://github.com/gidler) [@yzhliu](https://github.com/yzhliu) [@liangfu](https://github.com/liangfu) [@gradientsky](https://github.com/gradientsky) ([#2965](https://github.com/autogluon/autogluon/pull/2965), [#3008](https://github.com/autogluon/autogluon/pull/3008), [#3013](https://github.com/autogluon/autogluon/pull/3013), [#3020](https://github.com/autogluon/autogluon/pull/3020), [#3046](https://github.com/autogluon/autogluon/pull/3046), [#3053](https://github.com/autogluon/autogluon/pull/3053), [#3108](https://github.com/autogluon/autogluon/pull/3108), [#3135](https://github.com/autogluon/autogluon/pull/3135), [#3159](https://github.com/autogluon/autogluon/pull/3159), [#3283](https://github.com/autogluon/autogluon/pull/3283), [#3185](https://github.com/autogluon/autogluon/pull/3185))
* New AutoGluon Webpage [@gidler](https://github.com/gidler) [@shchur](https://github.com/shchur) ([#2924](https://github.com/autogluon/autogluon/pull/2924))
* Support sample_weight in RMSE [@jjaeyeon](https://github.com/jjaeyeon) ([#3052](https://github.com/autogluon/autogluon/pull/3052))
* Move AG search space to common [@yinweisu](https://github.com/yinweisu) ([#3192](https://github.com/autogluon/autogluon/pull/3192))
* Deprecation utils [@yinweisu](https://github.com/yinweisu) ([#3206](https://github.com/autogluon/autogluon/pull/3206), [#3209](https://github.com/autogluon/autogluon/pull/3209))
* Update namespace packages for PEP420 compatibility [@gradientsky](https://github.com/gradientsky) ([#3228](https://github.com/autogluon/autogluon/pull/3228))

### Multimodal

AutoGluon MultiModal (also known as AutoMM) introduces two new features: 1) PDF document classification, and 2) Open Vocabulary Object Detection. Additionally, we have upgraded the presets for object detection, now offering `medium_quality`, `high_quality`, and `best_quality` options. The empirical results demonstrate significant ~20% relative improvements in the mAP (mean Average Precision) metric, using the same preset.

#### New Features
* PDF Document Classification. See [tutorial](https://auto.gluon.ai/0.8.0/tutorials/multimodal/document/pdf_classification.html) [@cheungdaven](https://github.com/cheungdaven) ([#2864](https://github.com/autogluon/autogluon/pull/2864), [#3043](https://github.com/autogluon/autogluon/pull/3043))
* Open Vocabulary Object Detection. See [tutorial](https://auto.gluon.ai/0.8.0/tutorials/multimodal/object_detection/quick_start/quick_start_ovd.html) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#3164](https://github.com/autogluon/autogluon/pull/3164))

#### Performance Improvements
* Upgrade the detection engine from mmdet 2.x to mmdet 3.x, and upgrade our presets [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#3262](https://github.com/autogluon/autogluon/pull/3262))
    * `medium_quality`: yolo-s -> yolox-l 
    * `high_quality`: yolox-l -> DINO-Res50
    * `best_quality`: yolox-x -> DINO-Swin_l  
* Speedup fusion model training with deepspeed strategy. [@liangfu](https://github.com/liangfu) ([#2932](https://github.com/autogluon/autogluon/pull/2932))
* Enable detection backbone freezing to boost finetuning speed and save GPU usage [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#3220](https://github.com/autogluon/autogluon/pull/3220))

#### Other Enhancements
* Support passing data path to the fit() API [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3006](https://github.com/autogluon/autogluon/pull/3006))
* Upgrade TIMM to the latest v0.9.* [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3282](https://github.com/autogluon/autogluon/pull/3282))
* Support xywh output for object detection [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#2948](https://github.com/autogluon/autogluon/pull/2948))
* Fusion model inference acceleration with TensorRT [@liangfu](https://github.com/liangfu) ([#2836](https://github.com/autogluon/autogluon/pull/2836), [#2987](https://github.com/autogluon/autogluon/pull/2987))
* Support customizing advanced image data augmentation. Users can pass a list of [torchvision transform](https://pytorch.org/vision/stable/transforms.html#geometry) objects as image augmentation. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3022](https://github.com/autogluon/autogluon/pull/3022))
* Add yoloxm and yoloxtiny [@FangAreNotGnu](https://github.com/FangAreNotGnu) ([#3038](https://github.com/autogluon/autogluon/pull/3038))
* Add MultiImageMix Dataset for Object Detection [@FangAreNotGnu](https://github.com/FangAreNotGnu) ([#3094](https://github.com/autogluon/autogluon/pull/3094))
* Support loading specific checkpoints. Users can load the intermediate checkpoints other than model.ckpt and last.ckpt. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3244](https://github.com/autogluon/autogluon/pull/3244))
* Add some predictor properties for model statistics [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3289](https://github.com/autogluon/autogluon/pull/3289))
    * `trainable_parameters` returns the number of trainable parameters.
    * `total_parameters` returns the number of total parameters.
    * `model_size` returns the model size measured by megabytes.

#### Bug Fixes / Code and Doc Improvements
* General bug fixes and improvements [@zhiqiangdon](https://github.com/zhiqiangdon) [@liangfu](https://github.com/liangfu) [@cheungdaven](https://github.com/cheungdaven) [@xiaochenbin9527](https://github.com/xiaochenbin9527) [@Innixma](https://github.com/Innixma) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@gradientsky](https://github.com/gradientsky) [@yinweisu](https://github.com/yinweisu) [@yongxinw](https://github.com/yongxinw) ([#2939](https://github.com/autogluon/autogluon/pull/2939), [#2989](https://github.com/autogluon/autogluon/pull/2989),  [#2983](https://github.com/autogluon/autogluon/pull/2983), [#2998](https://github.com/autogluon/autogluon/pull/2998), [#3001](https://github.com/autogluon/autogluon/pull/3001), [#3004](https://github.com/autogluon/autogluon/pull/3004), [#3006](https://github.com/autogluon/autogluon/pull/3006), [#3025](https://github.com/autogluon/autogluon/pull/3025), [#3026](https://github.com/autogluon/autogluon/pull/3026), [#3048](https://github.com/autogluon/autogluon/pull/3048), [#3055](https://github.com/autogluon/autogluon/pull/3055), [#3064](https://github.com/autogluon/autogluon/pull/3064), [#3070](https://github.com/autogluon/autogluon/pull/3070), [#3081](https://github.com/autogluon/autogluon/pull/3081), [#3090](https://github.com/autogluon/autogluon/pull/3090), [#3103](https://github.com/autogluon/autogluon/pull/3103), [#3106](https://github.com/autogluon/autogluon/pull/3106), [#3119](https://github.com/autogluon/autogluon/pull/3119), [#3155](https://github.com/autogluon/autogluon/pull/3155), [#3158](https://github.com/autogluon/autogluon/pull/3158), [#3167](https://github.com/autogluon/autogluon/pull/3167), [#3180](https://github.com/autogluon/autogluon/pull/3180), [#3188](https://github.com/autogluon/autogluon/pull/3188), [#3222](https://github.com/autogluon/autogluon/pull/3222), [#3261](https://github.com/autogluon/autogluon/pull/3261), [#3266](https://github.com/autogluon/autogluon/pull/3266), [#3277](https://github.com/autogluon/autogluon/pull/3277), [#3279](https://github.com/autogluon/autogluon/pull/3279), [#3261](https://github.com/autogluon/autogluon/pull/3261), [#3267](https://github.com/autogluon/autogluon/pull/3267))
* General doc improvements [@suzhoum](https://github.com/suzhoum) ([#3295](https://github.com/autogluon/autogluon/pull/3295), [#3300](https://github.com/autogluon/autogluon/pull/3300))
* Remove clip from fusion models [@liangfu](https://github.com/liangfu) ([#2946](https://github.com/autogluon/autogluon/pull/2946))
* Refactor inferring problem type and output shape [@zhiqiangdon](https://github.com/zhiqiangdon) ([#3227](https://github.com/autogluon/autogluon/pull/3227))
* Log GPU info including GPU total memory, free memory, GPU card name, and CUDA version during training [@zhiqaingdon](https://github.com/zhiqaingdon) ([#3291](https://github.com/autogluon/autogluon/pull/3291))


### Tabular

#### New Features
* Added `calibrate_decision_threshold` ([tutorial](https://auto.gluon.ai/stable/tutorials/tabular/tabular-indepth.html#decision-threshold-calibration)), which allows to optimize a given metric's decision threshold for predictions to strongly enhance the metric score. [@Innixma](https://github.com/Innixma) ([#3298](https://github.com/autogluon/autogluon/pull/3298))
* We've added an experimental Zeroshot HPO config, which performs well on small datasets <10000 rows when at least an hour of training time is provided. To try it out, specify `presets="experimental_zeroshot_hpo_hybrid"` when calling `fit()` [@Innixma](https://github.com/Innixma) [@geoalgo](https://github.com/geoalgo) ([#3312](https://github.com/autogluon/autogluon/pull/3312))
* The [TabPFN model](https://auto.gluon.ai/stable/api/autogluon.tabular.models.html#tabpfnmodel) is now supported as an experimental model. TabPFN is a viable model option when inference speed is not a concern, and the number of rows of training data is less than 10,000. Try it out via `pip install autogluon.tabular[all,tabpfn]`! [@Innixma](https://github.com/Innixma) ([#3270](https://github.com/autogluon/autogluon/pull/3270))
* Backend support for distributed training, which will be available with the next Cloud module release. [@yinweisu](https://github.com/yinweisu) ([#3054](https://github.com/autogluon/autogluon/pull/3054), [#3110](https://github.com/autogluon/autogluon/pull/3110), [#3115](https://github.com/autogluon/autogluon/pull/3115), [#3131](https://github.com/autogluon/autogluon/pull/3131), [#3142](https://github.com/autogluon/autogluon/pull/3142), [#3179](https://github.com/autogluon/autogluon/pull/3179), [#3216](https://github.com/autogluon/autogluon/pull/3216))
#### Performance Improvements
* Accelerate boolean preprocessing [@Innixma](https://github.com/Innixma) ([#2944](https://github.com/autogluon/autogluon/pull/2944))
#### Other Enhancements
* Add quantile regression support for CatBoost [@shchur](https://github.com/shchur) ([#3165](https://github.com/autogluon/autogluon/pull/3165))
* Implement quantile regression for LGBModel [@shchur](https://github.com/shchur) ([#3168](https://github.com/autogluon/autogluon/pull/3168))
* Log to file support [@yinweisu](https://github.com/yinweisu) ([#3232](https://github.com/autogluon/autogluon/pull/3232))
* Add support for `included_model_types` [@yinweisu](https://github.com/yinweisu) ([#3239](https://github.com/autogluon/autogluon/pull/3239))
* Add enable_categorical=True support to XGBoost [@Innixma](https://github.com/Innixma) ([#3286](https://github.com/autogluon/autogluon/pull/3286))
#### Bug Fixes / Code and Doc Improvements
* Cross-OS loading of a fit TabularPredictor should now work properly [@yinweisu](https://github.com/yinweisu) [@Innixma](https://github.com/Innixma)
* General bug fixes and improvements [@Innixma](https://github.com/Innixma) [@cnpgs](https://github.com/cnpgs) [@shchur](https://github.com/shchur) [@yinweisu](https://github.com/yinweisu) [@gradientsky](https://github.com/gradientsky) ([#2865](https://github.com/autogluon/autogluon/pull/2865), [#2936](https://github.com/autogluon/autogluon/pull/2936), [#2990](https://github.com/autogluon/autogluon/pull/2990), [#3045](https://github.com/autogluon/autogluon/pull/3045), [#3060](https://github.com/autogluon/autogluon/pull/3060), [#3069](https://github.com/autogluon/autogluon/pull/3069), [#3148](https://github.com/autogluon/autogluon/pull/3148), [#3182](https://github.com/autogluon/autogluon/pull/3182), [#3199](https://github.com/autogluon/autogluon/pull/3199), [#3226](https://github.com/autogluon/autogluon/pull/3226), [#3257](https://github.com/autogluon/autogluon/pull/3257), [#3259](https://github.com/autogluon/autogluon/pull/3259), [#3268](https://github.com/autogluon/autogluon/pull/3268), [#3269](https://github.com/autogluon/autogluon/pull/3269), [#3287](https://github.com/autogluon/autogluon/pull/3287), [#3288](https://github.com/autogluon/autogluon/pull/3288), [#3285](https://github.com/autogluon/autogluon/pull/3285), [#3293](https://github.com/autogluon/autogluon/pull/3293), [#3294](https://github.com/autogluon/autogluon/pull/3294), [#3302](https://github.com/autogluon/autogluon/pull/3302))
* Move interpretable logic to InterpretableTabularPredictor [@Innixma](https://github.com/Innixma) ([#2981](https://github.com/autogluon/autogluon/pull/2981))
* Enhance drop_duplicates, enable by default [@Innixma](https://github.com/Innixma) ([#3010](https://github.com/autogluon/autogluon/pull/3010))
* Refactor params_aux & memory checks [@Innixma](https://github.com/Innixma) ([#3033](https://github.com/autogluon/autogluon/pull/3033))
* Raise regression `pred_proba` [@Innixma](https://github.com/Innixma) ([#3240](https://github.com/autogluon/autogluon/pull/3240))


### TimeSeries
In v0.8 we introduce several major improvements to the Time Series module, including new models, upgraded presets that lead to better forecast accuracy, and optimizations that speed up training & inference.

#### Highlights
- New models: `PatchTST` and `DLinear` from GluonTS, and `RecursiveTabular` based on integration with the [`mlforecast`](https://github.com/Nixtla/mlforecast) library [@shchur](https://github.com/shchur) ([#3177](https://github.com/autogluon/autogluon/pull/3177), [#3184](https://github.com/autogluon/autogluon/pull/3184), [#3230](https://github.com/autogluon/autogluon/pull/3230))
- Improved accuracy and reduced overall training time thanks to updated presets [@shchur](https://github.com/shchur) ([#3281](https://github.com/autogluon/autogluon/pull/3281), [#3120](https://github.com/autogluon/autogluon/pull/3120))
- 3-6x faster training and inference for `AutoARIMA`, `AutoETS`, `Theta`, `DirectTabular`, `WeightedEnsemble` models [@shchur](https://github.com/shchur) ([#3062](https://github.com/autogluon/autogluon/pull/3062), [#3214](https://github.com/autogluon/autogluon/pull/3214), [#3252](https://github.com/autogluon/autogluon/pull/3252))

#### New Features
- Dramatically faster repeated calls to `predict()`, `leaderboard()` and `evaluate()` thanks to prediction caching [@shchur](https://github.com/shchur) ([#3237](https://github.com/autogluon/autogluon/pull/3237))
- Reduce overfitting by using multiple validation windows with the `num_val_windows` argument to `fit()` [@shchur](https://github.com/shchur) ([#3080](https://github.com/autogluon/autogluon/pull/3080))
- Exclude certain models from presets with the `excluded_model_types` argument to `fit()` [@shchur](https://github.com/shchur) ([#3231](https://github.com/autogluon/autogluon/pull/3231))
- New method `refit_full()` that refits models on combined train and validation data [@shchur](https://github.com/shchur) ([#3157](https://github.com/autogluon/autogluon/pull/3157))
- Train multiple configurations of the same model by providing lists in the `hyperparameters` argument [@shchur](https://github.com/shchur) ([#3183](https://github.com/autogluon/autogluon/pull/3183))
- Time limit set by `time_limit` is now respected by all models [@shchur](https://github.com/shchur) ([#3214](https://github.com/autogluon/autogluon/pull/3214))

#### Enhancements
- Improvements to the `DirectTabular` model (previously called `AutoGluonTabular`): faster featurization, trained as a quantile regression model if `eval_metric` is set to `"mean_wQuantileLoss"` [@shchur](https://github.com/shchur) ([#2973](https://github.com/autogluon/autogluon/pull/2973), [#3211](https://github.com/autogluon/autogluon/pull/3211))
- Use correct seasonal period when computing the MASE metric [@shchur](https://github.com/shchur) ([#2970](https://github.com/autogluon/autogluon/pull/2970))
- Check the AutoGluon version when loading `TimeSeriesPredictor` from disk [@shchur](https://github.com/shchur) ([#3233](https://github.com/autogluon/autogluon/pull/3233))

#### Minor Improvements / Documentation / Bug Fixes
* Update documentation and tutorials [@shchur](https://github.com/shchur) ([#2960](https://github.com/autogluon/autogluon/pull/2960), [#2964](https://github.com/autogluon/autogluon/pull/2964), [#3296](https://github.com/autogluon/autogluon/pull/3296), [#3297](https://github.com/autogluon/autogluon/pull/3297))
* General bug fixes and improvements [@shchur](https://github.com/shchur) ([#2977](https://github.com/autogluon/autogluon/pull/2977), [#3058](https://github.com/autogluon/autogluon/pull/3058), [#3066](https://github.com/autogluon/autogluon/pull/3066), [#3160](https://github.com/autogluon/autogluon/pull/3160), [#3193](https://github.com/autogluon/autogluon/pull/3193), [#3202](https://github.com/autogluon/autogluon/pull/3202), [#3236](https://github.com/autogluon/autogluon/pull/3236), [#3255](https://github.com/autogluon/autogluon/pull/3255), [#3275](https://github.com/autogluon/autogluon/pull/3275), [#3290](https://github.com/autogluon/autogluon/pull/3290))

### Exploratory Data Analysis (EDA) tools
In 0.8 we introduce a few new tools to help with data exploration and feature engineering:
* **Anomaly Detection** [@gradientsky](https://github.com/gradientsky) ([#3124](https://github.com/autogluon/autogluon/pull/3124), [#3137](https://github.com/autogluon/autogluon/pull/3137)) - helps to identify unusual patterns or behaviors in data that deviate significantly from the norm.  It's best used when finding outliers, rare events, or suspicious activities that could indicate fraud, defects, or system failures. Check the [Anomaly Detection Tutorial](https://auto.gluon.ai/0.8.0/tutorials/eda/eda-auto-anomaly-detection.html) to explore the functionality.
* **Partial Dependence Plots** [@gradientsky](https://github.com/gradientsky) ([#3071](https://github.com/autogluon/autogluon/pull/3071), [#3079](https://github.com/autogluon/autogluon/pull/3079)) -  visualize the relationship between a feature and the model's output for each individual instance in the dataset. Two-way variant can visualize potential interactions between any two features. Please see this tutorial for more detail: [Using Interaction Charts To Learn Information About the Data](https://auto.gluon.ai/0.8.0/tutorials/eda/eda-auto-analyze-interaction.html#using-interaction-charts-to-learn-information-about-the-data)
#### Bug Fixes / Code and Doc Improvements
* Switch regression analysis in `quick_fit` to use residuals plot [@gradientsky](https://github.com/gradientsky) ([#3039](https://github.com/autogluon/autogluon/pull/3039))
* Added `explain_rows` method to `autogluon.eda.auto` - Kernel SHAP visualization [@gradientsky](https://github.com/gradientsky) ([#3014](https://github.com/autogluon/autogluon/pull/3014))
* General improvements and fixes [@gradientsky](https://github.com/gradientsky) ([#2991](https://github.com/autogluon/autogluon/pull/2991), [#3056](https://github.com/autogluon/autogluon/pull/3056), [#3102](https://github.com/autogluon/autogluon/pull/3102), [#3107](https://github.com/autogluon/autogluon/pull/3107), [#3138](https://github.com/autogluon/autogluon/pull/3138))
