# Version 0.7.0

We're happy to announce the AutoGluon 0.7 release. This release contains a new experimental module `autogluon.eda` for exploratory
data analysis. AutoGluon 0.7 offers **conda-forge support**, enhancements to Tabular, MultiModal, and Time Series
modules, and many quality of life improvements and fixes.

As always, only load previously trained models using the same version of AutoGluon that they were originally trained on.
Loading models trained in different versions of AutoGluon is not supported.

This release contains [**170** commits from **19** contributors](https://github.com/autogluon/autogluon/graphs/contributors?from=2023-01-10&to=2023-02-16&type=c)!

See the full commit change-log here: https://github.com/autogluon/autogluon/compare/v0.6.2...v0.7.0

Special thanks to [@MountPOTATO](https://github.com/MountPOTATO) who is a first time contributor to AutoGluon this release!

Full Contributor List (ordered by # of commits):

[@Innixma](https://github.com/Innixma), [@zhiqiangdon](https://github.com/zhiqiangdon), [@yinweisu](https://github.com/yinweisu), [@gradientsky](https://github.com/gradientsky), [@shchur](https://github.com/shchur), [@sxjscience](https://github.com/sxjscience), [@FANGAreNotGnu](https://github.com/FANGAreNotGnu), [@yongxinw](https://github.com/yongxinw), [@cheungdaven](https://github.com/cheungdaven),
[@liangfu](https://github.com/liangfu), [@tonyhoo](https://github.com/tonyhoo), [@bryanyzhu](https://github.com/bryanyzhu), [@suzhoum](https://github.com/suzhoum), [@canerturkmen](https://github.com/canerturkmen), [@giswqs](https://github.com/giswqs), [@gidler](https://github.com/gidler), [@yzhliu](https://github.com/yzhliu), [@Linuxdex](https://github.com/Linuxdex) and [@MountPOTATO](https://github.com/MountPOTATO)

AutoGluon 0.7 supports Python versions 3.8, 3.9, and **3.10**. Python 3.7 is no longer supported as of this release. 

## Changes

### NEW: AutoGluon available on conda-forge

As of AutoGluon 0.7 release, AutoGluon is now available on [conda-forge](https://anaconda.org/conda-forge/autogluon) ([#612](https://github.com/autogluon/autogluon/pull/612))!

Kudos to the following individuals for making this happen:
  * [@giswqs](https://github.com/giswqs) for leading the entire effort and being a 1-man army driving this forward.
  * [@h-vetinari](https://github.com/h-vetinari) for providing excellent advice for working with conda-forge and some truly exceptional feedback.
  * [@arturdaraujo](https://github.com/arturdaraujo), [@PertuyF](https://github.com/PertuyF), [@ngam](https://github.com/ngam) and [@priyanga24](https://github.com/priyanga24) for their encouragement, suggestions, and feedback.
  * The conda-forge team for their prompt and effective reviews of our (many) PRs.
  * [@gradientsky](https://github.com/gradientsky) for testing M1 support during the early stages.
  * [@sxjscience](https://github.com/sxjscience), [@zhiqiangdon](https://github.com/zhiqiangdon), [@canerturkmen](https://github.com/canerturkmen), [@shchur](https://github.com/shchur), and [@Innixma](https://github.com/Innixma) for helping upgrade our downstream dependency versions to be compatible with conda.
  * Everyone else who has supported this process either directly or indirectly.

### NEW: `autogluon.eda` (Exploratory Data Analysis)

We are happy to announce AutoGluon Exploratory Data Analysis (EDA) toolkit. Starting with v0.7, AutoGluon now can analyze and visualize different aspects of data and models. We invite you to explore the following tutorials: [Quick Fit](https://auto.gluon.ai/0.7.0/tutorials/eda/eda-auto-quick-fit.html), [Dataset Overview](https://auto.gluon.ai/0.7.0/tutorials/eda/eda-auto-dataset-overview.html), [Target Variable Analysis](https://auto.gluon.ai/0.7.0/tutorials/eda/eda-auto-target-analysis.html), [Covariate Shift Analysis](https://auto.gluon.ai/0.7.0/tutorials/eda/eda-auto-covariate-shift.html). Other materials can be found in [EDA Section](https://auto.gluon.ai/0.7.0/tutorials/eda/index.html) of the website.

### General

- Added Python 3.10 support. [@Innixma](https://github.com/Innixma) ([#2721](https://github.com/autogluon/autogluon/pull/2721))
- Dropped Python 3.7 support. [@Innixma](https://github.com/Innixma) ([#2722](https://github.com/autogluon/autogluon/pull/2722))
- Removed `dask` and `distributed` dependencies. [@Innixma](https://github.com/Innixma) ([#2691](https://github.com/autogluon/autogluon/pull/2691))
- Removed `autogluon.text` and `autogluon.vision` modules. We recommend using `autogluon.multimodal` for text and vision tasks going forward.

### AutoMM

AutoGluon MultiModal (a.k.a AutoMM) supports three new features: 1) document classification; 2) named entity recognition
for Chinese language; 3) few shot learning with SVM  

Meanwhile, we removed `autogluon.text` and `autogluon.vision` as these features are supported in `autogluon.multimodal`

#### New features

- Document Classification
  - Add scanned document classification (experimental).
  - Customers can train models for scanned document classification in a few lines of codes
  - See [tutorials](https://auto.gluon.ai/0.7.0/tutorials/multimodal/document/document_classification.html)
  - Contributors and commits: [@cheungdaven](https://github.com/cheungdaven) ([#2765](https://github.com/autogluon/autogluon/pull/2765), [#2826](https://github.com/autogluon/autogluon/pull/2826), [#2833](https://github.com/autogluon/autogluon/pull/2833), [#2928](https://github.com/autogluon/autogluon/pull/2928))
- NER for Chinese Language
  - Support Chinese named entity recognition
  - See [tutorials](https://auto.gluon.ai/0.7.0/tutorials/multimodal/document/document_classification.html)
  - Contributors and commits:  [@cheungdaven](https://github.com/cheungdaven) ([#2676](https://github.com/autogluon/autogluon/pull/2676), [#2709](https://github.com/autogluon/autogluon/pull/2709))
- Few Shot Learning with SVM
  - Improved few shot learning by adding SVM support
  - See [tutorials](https://auto.gluon.ai/stable/tutorials/multimodal/advanced_topics/few_shot_learning.html)
  - Contributors and commits: [@yongxinw](https://github.com/yongxinw) ([#2850](https://github.com/autogluon/autogluon/pull/2850))

#### Other Enhancements

- Add new loss function `FocalLoss`. [@yongxinw](https://github.com/yongxinw) ([#2860](https://github.com/autogluon/autogluon/pull/2860))
- Add matcher realtime inference support. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#2613](https://github.com/autogluon/autogluon/pull/2613))
- Add matcher HPO. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#2619](https://github.com/autogluon/autogluon/pull/2619))
- Add YOLOX models (small, large, and x-large) and update presets for object detection. [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#2644](https://github.com/autogluon/autogluon/pull/2644), [#2867](https://github.com/autogluon/autogluon/pull/2867), [#2927](https://github.com/autogluon/autogluon/pull/2927), [#2933](https://github.com/autogluon/autogluon/pull/2933))
- Add AutoMM presets [@zhiqiangdon](https://github.com/zhiqiangdon). ([#2620](https://github.com/autogluon/autogluon/pull/2620), [#2749](https://github.com/autogluon/autogluon/pull/2749), [#2839](https://github.com/autogluon/autogluon/pull/2839))
- Add model dump for models from HuggingFace, timm and mmdet. [@suzhoum](https://github.com/suzhoum) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@liangfu](https://github.com/liangfu) ([#2682](https://github.com/autogluon/autogluon/pull/2682), [#2700](https://github.com/autogluon/autogluon/pull/2700), [#2737](https://github.com/autogluon/autogluon/pull/2737), [#2840](https://github.com/autogluon/autogluon/pull/2840))
- Bug fix / refactor for NER. [@cheungdaven](https://github.com/cheungdaven) ([#2659](https://github.com/autogluon/autogluon/pull/2659), [#2696](https://github.com/autogluon/autogluon/pull/2696), [#2759](https://github.com/autogluon/autogluon/pull/2759), [#2773](https://github.com/autogluon/autogluon/pull/2773))
- MultiModalPredictor import time reduction. [@sxjscience](https://github.com/sxjscience) ([#2718](https://github.com/autogluon/autogluon/pull/2718))

#### Bug Fixes / Code and Doc Improvements

- NER example with visualization. [@sxjscience](https://github.com/sxjscience) ([#2698](https://github.com/autogluon/autogluon/pull/2698))
- Bug fixes / Code and Doc Improvements. [@sxjscience](https://github.com/sxjscience) [@tonyhoo](https://github.com/tonyhoo) [@giswqs](https://github.com/giswqs) ([#2708](https://github.com/autogluon/autogluon/pull/2708), [#2714](https://github.com/autogluon/autogluon/pull/2714), [#2739](https://github.com/autogluon/autogluon/pull/2739), [#2782](https://github.com/autogluon/autogluon/pull/2782), [#2787](https://github.com/autogluon/autogluon/pull/2787), [#2857](https://github.com/autogluon/autogluon/pull/2857), [#2818](https://github.com/autogluon/autogluon/pull/2818), [#2858](https://github.com/autogluon/autogluon/pull/2858), [#2859](https://github.com/autogluon/autogluon/pull/2859), [#2891](https://github.com/autogluon/autogluon/pull/2891), [#2918](https://github.com/autogluon/autogluon/pull/2918), [#2940](https://github.com/autogluon/autogluon/pull/2940), [#2906](https://github.com/autogluon/autogluon/pull/2906), [#2907](https://github.com/autogluon/autogluon/pull/2907))
- Support of [Label-Studio](https://labelstud.io/) file export in AutoMM and added [examples](https://github.com/autogluon/autogluon/tree/master/examples/automm/label_studio_export_reader). [@MountPOTATO](https://github.com/MountPOTATO) ([#2615](https://github.com/autogluon/autogluon/pull/2615))
- Added example of few-shot memory bank model with feature extraction based on [Tip-adapter](https://arxiv.org/abs/2111.03930). [@Linuxdex](https://github.com/Linuxdex) ([#2822](https://github.com/autogluon/autogluon/pull/2822))

#### Deprecations

* `autogluon.vision` namespace is deprecated. [@bryanyzhu](https://github.com/bryanyzhu) ([#2790](https://github.com/autogluon/autogluon/pull/2790), [#2819](https://github.com/autogluon/autogluon/pull/2819), [#2832](https://github.com/autogluon/autogluon/pull/2832))
* `autogluon.text` namespace is deprecated. [@sxjscience](https://github.com/sxjscience) [@Innixma](https://github.com/Innixma) ([#2695](https://github.com/autogluon/autogluon/pull/2695), [#2847](https://github.com/autogluon/autogluon/pull/2847))

### Tabular

1) TabularPredictor’s inference speed has been heavily optimized, with an average **250% speedup** for real-time inference. This means that TabularPredictor can satisfy <10 ms end-to-end latency on many datasets when using `infer_limit`, and the `high_quality` preset can satisfy <100 ms end-to-end latency on many datasets by default.
2) TabularPredictor’s `"multimodal"` hyperparameter preset now leverages the full capabilities of MultiModalPredictor, resulting in stronger performance on datasets containing a mix of tabular, image, and text features.

#### Performance Improvements

- Upgraded versions of all dependency packages to use the latest releases. [@Innixma](https://github.com/Innixma) ([#2823](https://github.com/autogluon/autogluon/pull/2823), [#2829](https://github.com/autogluon/autogluon/pull/2829), [#2834](https://github.com/autogluon/autogluon/pull/2834), [#2887](https://github.com/autogluon/autogluon/pull/2887), [#2915](https://github.com/autogluon/autogluon/pull/2915))
- Accelerated ensemble inference speed by 150% by removing TorchThreadManager context switching. [@liangfu](https://github.com/liangfu) ([#2472](https://github.com/autogluon/autogluon/pull/2472))
- Accelerated FastAI neural network inference speed by 100x+ and training speed by 10x on datasets with many features. [@Innixma](https://github.com/Innixma) ([#2909](https://github.com/autogluon/autogluon/pull/2909))
- (From 0.6.1) Avoid unnecessary DataFrame copies to accelerate feature preprocessing by 25%. [@liangfu](https://github.com/liangfu) ([#2532](https://github.com/autogluon/autogluon/pull/2532))
- (From 0.6.1) Refactor `NN_TORCH` model to be dataset iterable, leading to a 100% inference speedup. [@liangfu](https://github.com/liangfu) ([#2395](https://github.com/autogluon/autogluon/pull/2395))
- MultiModalPredictor is now used as a member of the ensemble when `TabularPredictor.fit` is passed `hyperparameters="multimodal"`. [@Innixma](https://github.com/Innixma) ([#2890](https://github.com/autogluon/autogluon/pull/2890))

#### API Enhancements

- Added `predict_multi` and `predict_proba_multi` methods to `TabularPredictor` to efficiently get predictions from multiple models. [@Innixma](https://github.com/Innixma) ([#2727](https://github.com/autogluon/autogluon/pull/2727))
- Allow label column to not be present in `leaderboard` calls when scoring is disabled. [@Innixma](https://github.com/Innixma) ([#2912](https://github.com/autogluon/autogluon/pull/2912))

#### Deprecations

- Added a deprecation warning when calling `predict_proba` with `problem_type="regression"`. This will raise an exception in a future release. [@Innixma](https://github.com/Innixma) ([#2684](https://github.com/autogluon/autogluon/pull/2684))

#### Bug Fixes / Doc Improvements

- Fixed incorrect time_limit estimation in `NN_TORCH` model. [@Innixma](https://github.com/Innixma) ([#2909](https://github.com/autogluon/autogluon/pull/2909))
- Fixed error when fitting with only text features. [@Innixma](https://github.com/Innixma) ([#2705](https://github.com/autogluon/autogluon/pull/2705))
- Fixed error when `calibrate=True, use_bag_holdout=True` in `TabularPredictor.fit`. [@Innixma](https://github.com/Innixma) ([#2715](https://github.com/autogluon/autogluon/pull/2715))
- Fixed error when tuning `n_estimators` with RandomForest / ExtraTrees models. [@Innixma](https://github.com/Innixma) ([#2735](https://github.com/autogluon/autogluon/pull/2735))
- Fixed missing onnxruntime dependency on Linux/MacOS when installing optional dependency `skl2onnx`. [@liangfu](https://github.com/liangfu) ([#2923](https://github.com/autogluon/autogluon/pull/2923))
- Fixed edge-case RandomForest error on Windows. [@yinweisu](https://github.com/yinweisu) ([#2851](https://github.com/autogluon/autogluon/pull/2851))
- Added improved logging for `refit_full`. [@Innixma](https://github.com/Innixma) ([#2913](https://github.com/autogluon/autogluon/pull/2913))
- Added `compile_models` to the deployment tutorial. [@liangfu](https://github.com/liangfu) ([#2717](https://github.com/autogluon/autogluon/pull/2717))
- Various internal code refactoring. [@Innixma](https://github.com/Innixma) ([#2744](https://github.com/autogluon/autogluon/pull/2744), [#2887](https://github.com/autogluon/autogluon/pull/2887))
- Various doc and logging improvements. [@Innixma](https://github.com/Innixma) ([#2668](https://github.com/autogluon/autogluon/pull/2668))

## autogluon.timeseries

### New features

- `TimeSeriesPredictor` now supports **past covariates** (a.k.a.dynamic features or related time series which is not known for time steps to be predicted). [@shchur](https://github.com/shchur) ([#2665](https://github.com/autogluon/autogluon/pull/2665), [#2680](https://github.com/autogluon/autogluon/pull/2680))
- New models from [StatsForecast](https://github.com/Nixtla/statsforecast) got introduced in `TimeSeriesPredictor` for various presets (`medium_quality`, `high_quality` and `best_quality`). [@shchur](https://github.com/shchur) ([#2758](https://github.com/autogluon/autogluon/pull/2758))
- Support missing value imputation for TimeSeriesDataFrame which allows users to customize filling logics for missing values and fill gaps in an irregular sampled times series. [@shchur](https://github.com/shchur) ([#2781](https://github.com/autogluon/autogluon/pull/2781))
- Improve quantile forecasting performance of the AutoGluon-Tabular forecaster using the empirical noise distribution. [@shchur](https://github.com/shchur) ([#2740](https://github.com/autogluon/autogluon/pull/2740))

### Bug Fixes / Doc Improvements

- Bug fixes and code improvements. [@shchur](https://github.com/shchur) [@canerturkmen](https://github.com/canerturkmen) ([#2703](https://github.com/autogluon/autogluon/pull/2703), [#2712](https://github.com/autogluon/autogluon/pull/2712), [#2713](https://github.com/autogluon/autogluon/pull/2713), [#2769](https://github.com/autogluon/autogluon/pull/2769), [#2771](https://github.com/autogluon/autogluon/pull/2771), [#2816](https://github.com/autogluon/autogluon/pull/2816), [#2817](https://github.com/autogluon/autogluon/pull/2817), [#2875](https://github.com/autogluon/autogluon/pull/2875), [#2877](https://github.com/autogluon/autogluon/pull/2877), [#2919](https://github.com/autogluon/autogluon/pull/2919))
- Doc improvements. [@shchur](https://github.com/shchur) [@gidler](https://github.com/gidler) ([#2772](https://github.com/autogluon/autogluon/pull/2772), [#2783](https://github.com/autogluon/autogluon/pull/2783), [#2800](https://github.com/autogluon/autogluon/pull/2800))
