# Version 0.6.1

v0.6.1 is a security fix / bug fix release.

As always, only load previously trained models using the same version of AutoGluon that they were originally trained on. 
Loading models trained in different versions of AutoGluon is not supported.

See the full commit change-log here: https://github.com/autogluon/autogluon/compare/v0.6.0...v0.6.1

Special thanks to [@lvwerra](https://github.com/lvwerra) who is first time contributors to AutoGluon this release!

This version supports Python versions 3.7 to 3.9. 0.6.x are the last releases that will support Python 3.7.

## Changes

### Documentation improvements

- Fix object detection tutorial layout ([#2450](https://github.com/autogluon/autogluon/pull/2450)) - [@bryanyzhu](https://github.com/bryanyzhu)
- Add multimodal cheatsheet ([#2467](https://github.com/autogluon/autogluon/pull/2467)) - [@sxjscience](https://github.com/sxjscience)
- Refactoring detection inference quickstart and bug fix on fit->predict - [@yongxinw](https://github.com/yongxinw), [@zhiqiangdon](https://github.com/zhiqiangdon), [@Innixma](https://github.com/Innixma), [@BingzhaoZhu](https://github.com/BingzhaoZhu), [@tonyhoo](https://github.com/tonyhoo)
- Use Pothole Dataset in Tutorial for AutoMM Detection ([#2468](https://github.com/autogluon/autogluon/pull/2468)) - [@FANGAreNotGnu](https://github.com/FANGAreNotGnu)
- add time series cheat sheet, add time series to doc titles ([#2478](https://github.com/autogluon/autogluon/pull/2478)) - [@canerturkmen](https://github.com/canerturkmen)
- Update all repo references to autogluon/autogluon ([#2463](https://github.com/autogluon/autogluon/pull/2463)) - [@gidler](https://github.com/gidler)
- fix typo in object detection tutorial CI ([#2516](https://github.com/autogluon/autogluon/pull/2516)) - [@tonyhoo](https://github.com/tonyhoo)

### Bug Fixes / Security

- bump evaluate to 0.3.0 ([#2433](https://github.com/autogluon/autogluon/pull/2433)) - [@lvwerra](https://github.com/lvwerra)
- Add finetune/eval tests for AutoMM detection ([#2441](https://github.com/autogluon/autogluon/pull/2441)) - [@FANGAreNotGnu](https://github.com/FANGAreNotGnu)
- Adding Joint IA3_LoRA as efficient finetuning strategy ([#2451](https://github.com/autogluon/autogluon/pull/2451)) - [@Raldir](https://github.com/Raldir)
- Fix AutoMM warnings about object detection ([#2458](https://github.com/autogluon/autogluon/pull/2458)) - [@zhiqiangdon](https://github.com/zhiqiangdon)
- [Tabular] Speed up feature transform in tabular NN model ([#2442](https://github.com/autogluon/autogluon/pull/2442)) - [@liangfu](https://github.com/liangfu)
- fix matcher cpu inference bug ([#2461](https://github.com/autogluon/autogluon/pull/2461)) - [@sxjscience](https://github.com/sxjscience)
- [timeseries] Silence GluonTS JSON warning ([#2454](https://github.com/autogluon/autogluon/pull/2454)) - [@shchur](https://github.com/shchur)
- [timeseries] Fix pandas groupby bug + GluonTS index bug ([#2420](https://github.com/autogluon/autogluon/pull/2420)) - [@shchur](https://github.com/shchur)
- Simplified infer speed throughput calculation ([#2465](https://github.com/autogluon/autogluon/pull/2465)) - [@Innixma](https://github.com/Innixma)
- [Tabular] make tabular nn dataset iterable ([#2395](https://github.com/autogluon/autogluon/pull/2395)) - [@liangfu](https://github.com/liangfu)
- Remove old images and dataset download scripts ([#2471](https://github.com/autogluon/autogluon/pull/2471)) - [@Innixma](https://github.com/Innixma)
- Support image bytearray in AutoMM ([#2490](https://github.com/autogluon/autogluon/pull/2490)) - [@suzhoum](https://github.com/suzhoum)
- [NER] add an NER visualizer ([#2500](https://github.com/autogluon/autogluon/pull/2500)) - [@cheungdaven](https://github.com/cheungdaven)
- [Cloud] Lazy load TextPredcitor and ImagePredictor which will be deprecated ([#2517](https://github.com/autogluon/autogluon/pull/2517)) - [@tonyhoo](https://github.com/tonyhoo)
- Use detectron2 visualizer and update quickstart ([#2502](https://github.com/autogluon/autogluon/pull/2502)) - [@yongxinw](https://github.com/yongxinw), [@zhiqiangdon](https://github.com/zhiqiangdon), [@Innixma](https://github.com/Innixma), [@BingzhaoZhu](https://github.com/BingzhaoZhu), [@tonyhoo](https://github.com/tonyhoo)
- fix df preprocessor properties ([#2512](https://github.com/autogluon/autogluon/pull/2512)) - [@zhiqiangdon](https://github.com/zhiqiangdon)
- [timeseries] Fix info and fit_summary for TimeSeriesPredictor ([#2510](https://github.com/autogluon/autogluon/pull/2510)) - [@shchur](https://github.com/shchur)
- [timeseries] Pass known_covariates to component models of the WeightedEnsemble - [@shchur](https://github.com/shchur)
- [timeseries] Gracefully handle inconsistencies in static_features provided by user - [@shchur](https://github.com/shchur)
- [security] update Pillow to >=9.3.0 ([#2519](https://github.com/autogluon/autogluon/pull/2519)) - [@gradientsky](https://github.com/gradientsky)
- [CI] upgrade codeql v1 to v2 as v1 will be deprecated ([#2528](https://github.com/autogluon/autogluon/pull/2528)) - [@tonyhoo](https://github.com/tonyhoo)
- Upgrade scikit-learn-intelex version ([#2466](https://github.com/autogluon/autogluon/pull/2466)) - [@Innixma](https://github.com/Innixma)
- Save AutoGluonTabular model to the correct folder ([#2530](https://github.com/autogluon/autogluon/pull/2530)) - [@shchur](https://github.com/shchur)
- support predicting with model fitted on v0.5.1 ([#2531](https://github.com/autogluon/autogluon/pull/2531)) - [@liangfu](https://github.com/liangfu)
- [timeseries] Implement input validation for TimeSeriesPredictor and improve debug messages - [@shchur](https://github.com/shchur)
- [timeseries] Ensure that timestamps are sorted when creating a TimeSeriesDataFrame - [@shchur](https://github.com/shchur)
- Add tests for preprocessing mutation ([#2540](https://github.com/autogluon/autogluon/pull/2540)) - [@Innixma](https://github.com/Innixma)
- Fix timezone datetime edgecase ([#2538](https://github.com/autogluon/autogluon/pull/2538)) - [@Innixma](https://github.com/Innixma), [@gradientsky](https://github.com/gradientsky)
- Mmdet Fix Image Identifier ([#2492](https://github.com/autogluon/autogluon/pull/2492)) - [@FANGAreNotGnu](https://github.com/FANGAreNotGnu)
- [timeseries] Warn if provided data has a frequency that is not supported - [@shchur](https://github.com/shchur)
- Train and inference with different image data types ([#2535](https://github.com/autogluon/autogluon/pull/2535)) - [@suzhoum](https://github.com/suzhoum)
- Remove pycocotools ([#2548](https://github.com/autogluon/autogluon/pull/2548)) - [@bryanyzhu](https://github.com/bryanyzhu)
- avoid copying identical dataframes ([#2532](https://github.com/autogluon/autogluon/pull/2532)) - [@liangfu](https://github.com/liangfu)
- Fix AutoMM Tokenizer ([#2550](https://github.com/autogluon/autogluon/pull/2550)) - [@FANGAreNotGnu](https://github.com/FANGAreNotGnu)
- [Tabular] Resource Allocation Fix ([#2536](https://github.com/autogluon/autogluon/pull/2536)) - [@yinweisu](https://github.com/yinweisu)
- imodels version cap ([#2557](https://github.com/autogluon/autogluon/pull/2557)) - [@yinweisu](https://github.com/yinweisu)
- Fix int32/int64 difference between windows and other platforms; fix mutation issue - [@gradientsky](https://github.com/gradientsky)
