# Version 0.6.0

We're happy to announce the AutoGluon 0.6 release. 0.6 contains major enhancements to Tabular, Multimodal, and Time Series
modules, along with many quality of life improvements and fixes.

As always, only load previously trained models using the same version of AutoGluon that they were originally trained on.
Loading models trained in different versions of AutoGluon is not supported.

This release contains [**263** commits from **25** contributors](https://github.com/autogluon/autogluon/graphs/contributors?from=2022-07-18&to=2022-11-15&type=c)!

See the full commit change-log here: https://github.com/autogluon/autogluon/compare/v0.5.2...v0.6.0

Special thanks to [@cheungdaven](https://github.com/cheungdaven), [@suzhoum](https://github.com/suzhoum), [@BingzhaoZhu](https://github.com/BingzhaoZhu), [@liangfu](https://github.com/liangfu), [@Harry-zzh](https://github.com/Harry-zzh), [@gidler](https://github.com/gidler), [@yongxinw](https://github.com/yongxinw), [@martinschaef](https://github.com/martinschaef),
[@giswqs](https://github.com/giswqs), [@Jalagarto](https://github.com/Jalagarto), [@geoalgo](https://github.com/geoalgo), [@lujiaying](https://github.com/lujiaying) and [@leloykun](https://github.com/leloykun) who were first time contributors to AutoGluon this release!

Full Contributor List (ordered by # of commits):

[@shchur](https://github.com/shchur), [@yinweisu](https://github.com/yinweisu), [@zhiqiangdon](https://github.com/zhiqiangdon), [@Innixma](https://github.com/Innixma), [@FANGAreNotGnu](https://github.com/FANGAreNotGnu), [@canerturkmen](https://github.com/canerturkmen), [@sxjscience](https://github.com/sxjscience), [@gradientsky](https://github.com/gradientsky), [@cheungdaven](https://github.com/cheungdaven),
[@bryanyzhu](https://github.com/bryanyzhu), [@suzhoum](https://github.com/suzhoum), [@BingzhaoZhu](https://github.com/BingzhaoZhu), [@yongxinw](https://github.com/yongxinw), [@tonyhoo](https://github.com/tonyhoo), [@liangfu](https://github.com/liangfu), [@Harry-zzh](https://github.com/Harry-zzh), [@Raldir](https://github.com/Raldir), [@gidler](https://github.com/gidler), [@martinschaef](https://github.com/martinschaef), 
[@giswqs](https://github.com/giswqs), [@Jalagarto](https://github.com/Jalagarto), [@geoalgo](https://github.com/geoalgo), [@lujiaying](https://github.com/lujiaying), [@leloykun](https://github.com/leloykun), [@yiqings](https://github.com/yiqings)

This version supports Python versions 3.7 to 3.9. This is the last release that will support Python 3.7.

## Changes

### AutoMM

AutoGluon Multimodal (a.k.a AutoMM) supports three new features: 1) object detection, 2) named entity recognition, and 3) multimodal matching. In addition, the HPO backend of AutoGluon Multimodal has been upgraded to ray 2.0. It also supports fine-tuning billion-scale FLAN-T5-XL model on a single AWS g4.2x-large instance with improved parameter-efficient finetuning. Starting from 0.6, we recommend using autogluon.multimodal rather than autogluon.text or autogluon.vision and added deprecation warnings.

#### New features

- Object Detection
  - Add new problem_type `"object_detection"`.
  - Customers can run inference with pretrained object detection models and train their own model with three lines of code.
  - Integrate with [open-mmlab/mmdetection](https://github.com/open-mmlab/mmdetection), which supports classic detection architectures like Faster RCNN, and more efficient and performant architectures like YOLOV3 and VFNet.
  - See [tutorials](https://auto.gluon.ai/stable/tutorials/multimodal/object_detection/index.html) and [examples](https://github.com/autogluon/autogluon/tree/master/examples/automm/object_detection) for more detail.
  - Contributors and commits: [@FANGAreNotGnu](https://github.com/FANGAreNotGnu), [@bryanyzhu](https://github.com/bryanyzhu), [@zhiqiangdon](https://github.com/zhiqiangdon), [@yongxinw](https://github.com/yongxinw), [@sxjscience](https://github.com/sxjscience), [@Harry-zzh](https://github.com/Harry-zzh) ([#2025](https://github.com/autogluon/autogluon/pull/2025), [#2061](https://github.com/autogluon/autogluon/pull/2061), [#2131](https://github.com/autogluon/autogluon/pull/2131), [#2181](https://github.com/autogluon/autogluon/pull/2181), [#2196](https://github.com/autogluon/autogluon/pull/2196), [#2215](https://github.com/autogluon/autogluon/pull/2215), [#2244](https://github.com/autogluon/autogluon/pull/2244), [#2265](https://github.com/autogluon/autogluon/pull/2265), [#2290](https://github.com/autogluon/autogluon/pull/2290), [#2311](https://github.com/autogluon/autogluon/pull/2311), [#2312](https://github.com/autogluon/autogluon/pull/2312), [#2337](https://github.com/autogluon/autogluon/pull/2337), [#2349](https://github.com/autogluon/autogluon/pull/2349), [#2353](https://github.com/autogluon/autogluon/pull/2353), [#2360](https://github.com/autogluon/autogluon/pull/2360), [#2362](https://github.com/autogluon/autogluon/pull/2362), [#2365](https://github.com/autogluon/autogluon/pull/2365), [#2380](https://github.com/autogluon/autogluon/pull/2380), [#2381](https://github.com/autogluon/autogluon/pull/2381), [#2391](https://github.com/autogluon/autogluon/pull/2391), [#2393](https://github.com/autogluon/autogluon/pull/2393), [#2400](https://github.com/autogluon/autogluon/pull/2400), [#2419](https://github.com/autogluon/autogluon/pull/2419), [#2421](https://github.com/autogluon/autogluon/pull/2421), [#2063](https://github.com/autogluon/autogluon/pull/2063), [#2104](https://github.com/autogluon/autogluon/pull/2104), [#2411](https://github.com/autogluon/autogluon/pull/2411))

- Named Entity Recognition
  - Add new problem_type `"ner"`.
  - Customers can train models to extract named entities with three lines of code.
  - The implementation supports any backbones in huggingface/transformer, including the recently [FLAN-T5 series](https://arxiv.org/abs/2210.11416) released by Google.
  - See [tutorials](https://auto.gluon.ai/stable/tutorials/multimodal/text_prediction/ner.html) for more detail.
  - Contributors and commits: [@cheungdaven](https://github.com/cheungdaven) ([#2183](https://github.com/autogluon/autogluon/pull/2183), [#2232](https://github.com/autogluon/autogluon/pull/2232), [#2220](https://github.com/autogluon/autogluon/pull/2220), [#2282](https://github.com/autogluon/autogluon/pull/2282), [#2295](https://github.com/autogluon/autogluon/pull/2295), [#2301](https://github.com/autogluon/autogluon/pull/2301), [#2337](https://github.com/autogluon/autogluon/pull/2337), [#2346](https://github.com/autogluon/autogluon/pull/2346), [#2361](https://github.com/autogluon/autogluon/pull/2361), [#2372](https://github.com/autogluon/autogluon/pull/2372), [#2394](https://github.com/autogluon/autogluon/pull/2394), [#2412](https://github.com/autogluon/autogluon/pull/2412))

- Multimodal Matching
  - Add new problem_type `"text_similarity"`, `"image_similarity"`, `"image_text_similarity"`.
  - Users can now extract semantic embeddings with pretrained models for text-text, image-image, and text-image matching problems.
  - Moreover, users can further finetune these models with relevance data.
  - The semantic text embedding model can also be combined with BM25 to form a hybrid indexing solution.
  - Internally, AutoGluon Multimodal implements a twin-tower architecture that is flexible in the choice of backbones for each tower. It supports image backbones in TIMM, text backbones in huggingface/transformers, and also the CLIP backbone.
  - See [tutorials](https://auto.gluon.ai/0.6.0/tutorials/multimodal/matching/index.html) for more detail.
  - Contributors and commits: [@zhiqiangdon](https://github.com/zhiqiangdon) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@cheungdaven](https://github.com/cheungdaven) [@suzhoum](https://github.com/suzhoum) [@sxjscience](https://github.com/sxjscience) [@bryanyzhu](https://github.com/bryanyzhu) ([#1975](https://github.com/autogluon/autogluon/pull/1975), [#1994](https://github.com/autogluon/autogluon/pull/1994), [#2142](https://github.com/autogluon/autogluon/pull/2142), [#2179](https://github.com/autogluon/autogluon/pull/2179), [#2186](https://github.com/autogluon/autogluon/pull/2186), [#2217](https://github.com/autogluon/autogluon/pull/2217), [#2235](https://github.com/autogluon/autogluon/pull/2235), [#2284](https://github.com/autogluon/autogluon/pull/2284), [#2297](https://github.com/autogluon/autogluon/pull/2297), [#2313](https://github.com/autogluon/autogluon/pull/2313), [#2326](https://github.com/autogluon/autogluon/pull/2326), [#2337](https://github.com/autogluon/autogluon/pull/2337), [#2347](https://github.com/autogluon/autogluon/pull/2347), [#2357](https://github.com/autogluon/autogluon/pull/2357), [#2358](https://github.com/autogluon/autogluon/pull/2358), [#2362](https://github.com/autogluon/autogluon/pull/2362), [#2363](https://github.com/autogluon/autogluon/pull/2363), [#2375](https://github.com/autogluon/autogluon/pull/2375), [#2378](https://github.com/autogluon/autogluon/pull/2378), [#2404](https://github.com/autogluon/autogluon/pull/2404), [#2416](https://github.com/autogluon/autogluon/pull/2416), [#2407](https://github.com/autogluon/autogluon/pull/2407), [#2417](https://github.com/autogluon/autogluon/pull/2417))

- Miscellaneous minor fixes. [@cheungdaven](https://github.com/cheungdaven) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@geoalgo](https://github.com/geoalgo) [@zhiqiangdon](https://github.com/zhiqiangdon) ([#2402](https://github.com/autogluon/autogluon/pull/2402), [#2409](https://github.com/autogluon/autogluon/pull/2409), [#2026](https://github.com/autogluon/autogluon/pull/2026), [#2401](https://github.com/autogluon/autogluon/pull/2401), [#2418](https://github.com/autogluon/autogluon/pull/2418))

#### Other Enhancements

- Fix the FT-Transformer implementation and support Fastformer. [@BingzhaoZhu](https://github.com/BingzhaoZhu) [@yiqings](https://github.com/yiqings) ([#1958](https://github.com/autogluon/autogluon/pull/1958), [#2194](https://github.com/autogluon/autogluon/pull/2194), [#2251](https://github.com/autogluon/autogluon/pull/2251), [#2344](https://github.com/autogluon/autogluon/pull/2344), [#2379](https://github.com/autogluon/autogluon/pull/2379), [#2386](https://github.com/autogluon/autogluon/pull/2386))
- Support finetuning billion-scale FLAN-T5-XL in a single AWS g4.2x-large instance via improved parameter-efficient finetuning. See [tutorial](https://auto.gluon.ai/stable/tutorials/multimodal/advanced_topics/efficient_finetuning_basic.html). [@Raldir](https://github.com/Raldir) [@sxjscience](https://github.com/sxjscience) ([#2032](https://github.com/autogluon/autogluon/pull/2032), [#2108](https://github.com/autogluon/autogluon/pull/2108), [#2285](https://github.com/autogluon/autogluon/pull/2285), [#2336](https://github.com/autogluon/autogluon/pull/2336), [#2352](https://github.com/autogluon/autogluon/pull/2352))
- Upgrade multimodal HPO to use ray 2.0 and also add [new tutorial](https://auto.gluon.ai/stable/tutorials/multimodal/advanced_topics/hyperparameter_optimization.html). [@yinweisu](https://github.com/yinweisu) [@suzhoum](https://github.com/suzhoum) [@bryanyzhu](https://github.com/bryanyzhu) ([#2206](https://github.com/autogluon/autogluon/pull/2206), [#2341](https://github.com/autogluon/autogluon/pull/2341))
- Further improvement on model distillation. Add [example](https://github.com/autogluon/autogluon/tree/master/examples/automm/distillation) and [tutorial](https://auto.gluon.ai/stable/tutorials/multimodal/advanced_topics/model_distillation.html). [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) [@sxjscience](https://github.com/sxjscience) ([#1983](https://github.com/autogluon/autogluon/pull/1983), [#2064](https://github.com/autogluon/autogluon/pull/2064), [#2397](https://github.com/autogluon/autogluon/pull/2397))
- Revise the default presets of AutoMM for image classification problems.  [@bryanyzhu](https://github.com/bryanyzhu) ([#2351](https://github.com/autogluon/autogluon/pull/2351))
- Support backend=“automm” in autogluon.vision. [@bryanyzhu](https://github.com/bryanyzhu) ([#2316](https://github.com/autogluon/autogluon/pull/2316))
- Add deprecated warning to autogluon.vision and autogluon.text and point the usage to autogluon.multimodal. [@bryanyzhu](https://github.com/bryanyzhu) [@sxjscience](https://github.com/sxjscience) ([#2268](https://github.com/autogluon/autogluon/pull/2268), [#2315](https://github.com/autogluon/autogluon/pull/2315))
- Examples about [Kaggle: Feedback Prize prediction competition](https://www.kaggle.com/competitions/feedback-prize-effectiveness). We created [a solution](https://www.kaggle.com/code/mountpotatoq/autogluon-finetune-solutions) with AutoGluon Multimodal that obtained 152/1557 in the public leaderboard and 170/1557 in the private leaderboard, which is among the top 12% participants. The solution is public days before the DDL of the competition and obtained more than 3000 views. [@suzhoum](https://github.com/suzhoum) [@MountPOTATO](https://github.com/MountPOTATO) ([#2129](https://github.com/autogluon/autogluon/pull/2129), [#2168](https://github.com/autogluon/autogluon/pull/2168), [#2333](https://github.com/autogluon/autogluon/pull/2333))
* Improve native inference speed. [@zhiqiangdon](https://github.com/zhiqiangdon) ([#2051](https://github.com/autogluon/autogluon/pull/2051), [#2157](https://github.com/autogluon/autogluon/pull/2157), [#2161](https://github.com/autogluon/autogluon/pull/2161), [#2171](https://github.com/autogluon/autogluon/pull/2171))
* Other improvements, security/bug fixes. [@zhiqiangdon](https://github.com/zhiqiangdon) [@sxjscience](https://github.com/sxjscience) [@FANGAreNotGnu](https://github.com/FANGAreNotGnu), [@yinweisu](https://github.com/yinweisu) [@Innixma](https://github.com/Innixma) [@tonyhoo](https://github.com/tonyhoo) [@martinschaef](https://github.com/martinschaef) [@giswqs](https://github.com/giswqs) [@tonyhoo](https://github.com/tonyhoo) ([#1980](https://github.com/autogluon/autogluon/pull/1980), [#1987](https://github.com/autogluon/autogluon/pull/1987), [#1989](https://github.com/autogluon/autogluon/pull/1989), [#2003](https://github.com/autogluon/autogluon/pull/2003), [#2080](https://github.com/autogluon/autogluon/pull/2080), [#2018](https://github.com/autogluon/autogluon/pull/2018), [#2039](https://github.com/autogluon/autogluon/pull/2039), [#2058](https://github.com/autogluon/autogluon/pull/2058), [#2101](https://github.com/autogluon/autogluon/pull/2101), [#2102](https://github.com/autogluon/autogluon/pull/2102), [#2125](https://github.com/autogluon/autogluon/pull/2125), [#2135](https://github.com/autogluon/autogluon/pull/2135), [#2136](https://github.com/autogluon/autogluon/pull/2136), [#2140](https://github.com/autogluon/autogluon/pull/2140), [#2141](https://github.com/autogluon/autogluon/pull/2141), [#2152](https://github.com/autogluon/autogluon/pull/2152), [#2164](https://github.com/autogluon/autogluon/pull/2164), [#2166](https://github.com/autogluon/autogluon/pull/2166), [#2192](https://github.com/autogluon/autogluon/pull/2192), [#2219](https://github.com/autogluon/autogluon/pull/2219), [#2250](https://github.com/autogluon/autogluon/pull/2250), [#2257](https://github.com/autogluon/autogluon/pull/2257), [#2280](https://github.com/autogluon/autogluon/pull/2280), [#2308](https://github.com/autogluon/autogluon/pull/2308), [#2315](https://github.com/autogluon/autogluon/pull/2315), [#2317](https://github.com/autogluon/autogluon/pull/2317), [#2321](https://github.com/autogluon/autogluon/pull/2321), [#2356](https://github.com/autogluon/autogluon/pull/2356), [#2388](https://github.com/autogluon/autogluon/pull/2388), [#2392](https://github.com/autogluon/autogluon/pull/2392), [#2413](https://github.com/autogluon/autogluon/pull/2413), [#2414](https://github.com/autogluon/autogluon/pull/2414), [#2417](https://github.com/autogluon/autogluon/pull/2417), [#2426](https://github.com/autogluon/autogluon/pull/2426), [#2028](https://github.com/autogluon/autogluon/pull/2028), [#2382](https://github.com/autogluon/autogluon/pull/2382), [#2415](https://github.com/autogluon/autogluon/pull/2415), [#2193](https://github.com/autogluon/autogluon/pull/2193), [#2213](https://github.com/autogluon/autogluon/pull/2213), [#2230](https://github.com/autogluon/autogluon/pull/2230))
* CI improvements. [@yinweisu](https://github.com/yinweisu) ([#1965](https://github.com/autogluon/autogluon/pull/1965), [#1966](https://github.com/autogluon/autogluon/pull/1966), [#1972](https://github.com/autogluon/autogluon/pull/1972), [#1991](https://github.com/autogluon/autogluon/pull/1991), [#2002](https://github.com/autogluon/autogluon/pull/2002), [#2029](https://github.com/autogluon/autogluon/pull/2029), [#2137](https://github.com/autogluon/autogluon/pull/2137), [#2151](https://github.com/autogluon/autogluon/pull/2151), [#2156](https://github.com/autogluon/autogluon/pull/2156), [#2163](https://github.com/autogluon/autogluon/pull/2163), [#2191](https://github.com/autogluon/autogluon/pull/2191), [#2214](https://github.com/autogluon/autogluon/pull/2214), [#2369](https://github.com/autogluon/autogluon/pull/2369), [#2113](https://github.com/autogluon/autogluon/pull/2113), [#2118](https://github.com/autogluon/autogluon/pull/2118))


#### Experimental Features

- Support 11B-scale model finetuning with DeepSpeed. [@Raldir](https://github.com/Raldir) ([#2032](https://github.com/autogluon/autogluon/pull/2032))
- Enable few-shot learning with 11B-scale model. [@Raldir](https://github.com/Raldir) ([#2197](https://github.com/autogluon/autogluon/pull/2197))
- ONNX export example of hf_text model. [@FANGAreNotGnu](https://github.com/FANGAreNotGnu) ([#2149](https://github.com/autogluon/autogluon/pull/2149))

### Tabular

#### New features

- New experimental model `FT_TRANSFORMER`. [@bingzhaozhu](https://github.com/bingzhaozhu), [@innixma](https://github.com/innixma) ([#2085](https://github.com/autogluon/autogluon/pull/2085), [#2379](https://github.com/autogluon/autogluon/pull/2379), [#2389](https://github.com/autogluon/autogluon/pull/2389), [#2410](https://github.com/autogluon/autogluon/pull/2410)) 
  - You can access it via specifying the `FT_TRANSFORMER` key
in the `hyperparameters` dictionary or via `presets="experimental_best_quality"`. 
  - It is recommended to use GPU to train this model, but CPU training is also supported.
  - If given enough training time, this model generally improves the ensemble quality.

- New experimental model compilation support via `predictor.compile_models()`. [@liangfu](https://github.com/liangfu), [@innixma](https://github.com/innixma) ([#2225](https://github.com/autogluon/autogluon/pull/2225), [#2260](https://github.com/autogluon/autogluon/pull/2260), [#2300](https://github.com/autogluon/autogluon/pull/2300)) 
  - Currently only Random Forest and Extra Trees have compilation support.
  - You will need to install extra dependencies for this to work: `pip install autogluon.tabular[all,skl2onnx]`.
  - Compiling models dramatically speeds up inference time (~10x) when processing small batches of samples (<10000).
  - Note that a known bug exists in the current implementation: Refitting models after compilation will fail
and cause a crash. To avoid this, ensure that `.compile_models` is called only at the very end.
- Added `predictor.clone(...)` method to allow perfectly cloning a predictor object to a new directory. 
This is useful to preserve the state of a predictor prior to altering it
(such as prior to calling `.save_space`, `.distill`, `.compile_models`, or `.refit_full`. [@innixma](https://github.com/innixma) ([#2071](https://github.com/autogluon/autogluon/pull/2071))
- Added simplified `num_gpus` and `num_cpus` arguments to `predictor.fit` to control total resources.
[@yinweisu](https://github.com/yinweisu), [@innixma](https://github.com/innixma) ([#2263](https://github.com/autogluon/autogluon/pull/2263))
- Improved stability and effectiveness of HPO functionality via various refactors regarding our usage of ray.
[@yinweisu](https://github.com/yinweisu), [@innixma](https://github.com/innixma) ([#1974](https://github.com/autogluon/autogluon/pull/1974), [#1990](https://github.com/autogluon/autogluon/pull/1990), [#2094](https://github.com/autogluon/autogluon/pull/2094), [#2121](https://github.com/autogluon/autogluon/pull/2121), [#2133](https://github.com/autogluon/autogluon/pull/2133), [#2195](https://github.com/autogluon/autogluon/pull/2195), [#2253](https://github.com/autogluon/autogluon/pull/2253), [#2263](https://github.com/autogluon/autogluon/pull/2263), [#2330](https://github.com/autogluon/autogluon/pull/2330))
- Upgraded dependency versions: XGBoost 1.7, CatBoost 1.1, Scikit-learn 1.1, Pandas 1.5, Scipy 1.9, Numpy 1.23.
[@innixma](https://github.com/innixma) ([#2373](https://github.com/autogluon/autogluon/pull/2373))
- Added python version compatibility check when loading a fitted TabularPredictor.
Will now error if python versions are incompatible. [@innixma](https://github.com/innixma) ([#2054](https://github.com/autogluon/autogluon/pull/2054))
- Added `fit_weighted_ensemble` argument to `predictor.fit`. This allows the user to disable the weighted ensemble.
[@innixma](https://github.com/innixma) ([#2145](https://github.com/autogluon/autogluon/pull/2145))
- Added cascade ensemble foundation logic. [@innixma](https://github.com/innixma) ([#1929](https://github.com/autogluon/autogluon/pull/1929)) 

#### Other Enhancements
- Improved logging clarity when using `infer_limit`. [@innixma](https://github.com/innixma) ([#2014](https://github.com/autogluon/autogluon/pull/2014))
- Significantly improved HPO search space of XGBoost. [@innixma](https://github.com/innixma) ([#2123](https://github.com/autogluon/autogluon/pull/2123))
- Fixed HPO crashing when tuning Random Forest, Extra Trees, or KNN. [@innixma](https://github.com/innixma) ([#2070](https://github.com/autogluon/autogluon/pull/2070))
- Optimized roc_auc metric scoring speed by 7x. [@innixma](https://github.com/innixma) ([#2318](https://github.com/autogluon/autogluon/pull/2318), [#2331](https://github.com/autogluon/autogluon/pull/2331))
- Fixed bug with AutoMM Tabular model crashing if not trained last. [@innixma](https://github.com/innixma) ([#2309](https://github.com/autogluon/autogluon/pull/2309))
- Refactored `Scorer` classes to be easier to use, plus added comprehensive unit tests for all metrics. [@innixma](https://github.com/innixma) ([#2242](https://github.com/autogluon/autogluon/pull/2242))
- Sped up TextSpecial feature generation during preprocessing by 20% [@gidler](https://github.com/gidler) ([#2095](https://github.com/autogluon/autogluon/pull/2095))
- imodels integration improvements [@Jalagarto](https://github.com/Jalagarto) ([#2062](https://github.com/autogluon/autogluon/pull/2062))
- Fix crash when calling feature importance in quantile_regression. [@leloykun](https://github.com/leloykun) ([#1977](https://github.com/autogluon/autogluon/pull/1977))
- Add FAQ section for missing value imputation. [@innixma](https://github.com/innixma) ([#2076](https://github.com/autogluon/autogluon/pull/2076))
- Various minor fixes and cleanup [@innixma](https://github.com/innixma), [@yinweisu](https://github.com/yinweisu), [@gradientsky](https://github.com/gradientsky), [@gidler](https://github.com/gidler) ([#1997](https://github.com/autogluon/autogluon/pull/1997), [#2031](https://github.com/autogluon/autogluon/pull/2031), [#2124](https://github.com/autogluon/autogluon/pull/2124), [#2144](https://github.com/autogluon/autogluon/pull/2144), [#2178](https://github.com/autogluon/autogluon/pull/2178), [#2340](https://github.com/autogluon/autogluon/pull/2340), [#2342](https://github.com/autogluon/autogluon/pull/2342), [#2345](https://github.com/autogluon/autogluon/pull/2345), [#2374](https://github.com/autogluon/autogluon/pull/2374), [#2339](https://github.com/autogluon/autogluon/pull/2339), 
[#2348](https://github.com/autogluon/autogluon/pull/2348), [#2403](https://github.com/autogluon/autogluon/pull/2403), [#1981](https://github.com/autogluon/autogluon/pull/1981), [#1982](https://github.com/autogluon/autogluon/pull/1982), [#2234](https://github.com/autogluon/autogluon/pull/2234), [#2233](https://github.com/autogluon/autogluon/pull/2233), [#2243](https://github.com/autogluon/autogluon/pull/2243), [#2269](https://github.com/autogluon/autogluon/pull/2269), [#2288](https://github.com/autogluon/autogluon/pull/2288), [#2307](https://github.com/autogluon/autogluon/pull/2307), [#2367](https://github.com/autogluon/autogluon/pull/2367), [#2019](https://github.com/autogluon/autogluon/pull/2019))

### Time Series

#### New features

- `TimeSeriesPredictor` now supports **static features** (a.k.a. time series metadata, static covariates) and **
  time-varying covariates** (a.k.a. dynamic features or related time series). [@shchur](https://github.com/shchur) [@canerturkmen](https://github.com/canerturkmen) ([#1986](https://github.com/autogluon/autogluon/pull/1986), [#2238](https://github.com/autogluon/autogluon/pull/2238),
  [#2276](https://github.com/autogluon/autogluon/pull/2276), [#2287](https://github.com/autogluon/autogluon/pull/2287))
- AutoGluon-TimeSeries now uses **PyTorch** by default (for `DeepAR` and `SimpleFeedForward`), removing the dependency
  on MXNet. [@canerturkmen](https://github.com/canerturkmen) ([#2074](https://github.com/autogluon/autogluon/pull/2074), [#2205](https://github.com/autogluon/autogluon/pull/2205), [#2279](https://github.com/autogluon/autogluon/pull/2279))
- New models! `AutoGluonTabular` relies on XGBoost, LightGBM and CatBoost under the hood via the `autogluon.tabular`
  module. `Naive` and `SeasonalNaive` forecasters are simple methods that provide strong baselines with no increase in
  training time. `TemporalFusionTransformerMXNet` brings the TFT transformer architecture to AutoGluon. [@shchur](https://github.com/shchur) ([#2106](https://github.com/autogluon/autogluon/pull/2106),
  [#2188](https://github.com/autogluon/autogluon/pull/2188), [#2258](https://github.com/autogluon/autogluon/pull/2258), [#2266](https://github.com/autogluon/autogluon/pull/2266))
- Up to 20x faster parallel and memory-efficient training for statistical (local) forecasting models like `ETS`, `ARIMA`
  and `Theta`, as well as `WeightedEnsemble`. [@shchur](https://github.com/shchur) [@canerturkmen](https://github.com/canerturkmen) ([#2001](https://github.com/autogluon/autogluon/pull/2001), [#2033](https://github.com/autogluon/autogluon/pull/2033), [#2040](https://github.com/autogluon/autogluon/pull/2040), [#2067](https://github.com/autogluon/autogluon/pull/2067), [#2072](https://github.com/autogluon/autogluon/pull/2072), [#2073](https://github.com/autogluon/autogluon/pull/2073), [#2180](https://github.com/autogluon/autogluon/pull/2180),
  [#2293](https://github.com/autogluon/autogluon/pull/2293), [#2305](https://github.com/autogluon/autogluon/pull/2305))
- Up to 3x faster training for GluonTS models with data caching. GPU training enabled by default on PyTorch models.
  [@shchur](https://github.com/shchur) ([#2323](https://github.com/autogluon/autogluon/pull/2323))
- More accurate validation for time series models with multi-window backtesting. [@shchur](https://github.com/shchur) ([#2013](https://github.com/autogluon/autogluon/pull/2013), [#2038](https://github.com/autogluon/autogluon/pull/2038))
- `TimeSeriesPredictor` now handles irregularly sampled time series with `ignore_index`. [@canerturkmen](https://github.com/canerturkmen), [@shchur](https://github.com/shchur) ([#1993](https://github.com/autogluon/autogluon/pull/1993),
  [#2322](https://github.com/autogluon/autogluon/pull/2322))
- Improved and extended presets for more accurate forecasting. [@shchur](https://github.com/shchur) ([#2304](https://github.com/autogluon/autogluon/pull/2304))
- 15x faster and more robust forecast evaluation with updates to `TimeSeriesEvaluator` [@shchur](https://github.com/shchur) ([#2147](https://github.com/autogluon/autogluon/pull/2147), [#2150](https://github.com/autogluon/autogluon/pull/2150))
- Enabled Ray Tune backend for hyperparameter optimization of time series models. [@shchur](https://github.com/shchur) ([#2167](https://github.com/autogluon/autogluon/pull/2167), [#2203](https://github.com/autogluon/autogluon/pull/2203))

#### More tutorials and examples

Improved documentation and new tutorials:

- Updated [Quickstart tutorial](https://auto.gluon.ai/0.6.0/tutorials/timeseries/forecasting-quickstart.html)
- New! [In-depth tutorial](https://auto.gluon.ai/stable/tutorials/timeseries/forecasting-indepth.html)
- New! [Overview of available models and hyperparameters](https://auto.gluon.ai/stable/tutorials/timeseries/forecasting-model-zoo.html)
- Updated [API documentation](https://auto.gluon.ai/0.6.0/api/autogluon.predictor.html#module-5)

[@shchur](https://github.com/shchur) ([#2120](https://github.com/autogluon/autogluon/pull/2120), [#2127](https://github.com/autogluon/autogluon/pull/2127), [#2146](https://github.com/autogluon/autogluon/pull/2146), [#2174](https://github.com/autogluon/autogluon/pull/2174), [#2187](https://github.com/autogluon/autogluon/pull/2187), [#2354](https://github.com/autogluon/autogluon/pull/2354))

#### Miscellaneous

[@shchur](https://github.com/shchur)
- Deprecate passing quantile_levels to TimeSeriesPredictor.predict ([#2277](https://github.com/autogluon/autogluon/pull/2277))
- Use static features in GluonTS forecasting models ([#2238](https://github.com/autogluon/autogluon/pull/2238))
- Make sure that time series splitter doesn't trim training series shorter than prediction_length + 1 ([#2099](https://github.com/autogluon/autogluon/pull/2099))
- Fix hyperparameter overloading in HPO for time series models ([#2189](https://github.com/autogluon/autogluon/pull/2189))
- Clean up the TimeSeriesDataFrame public API ([#2105](https://github.com/autogluon/autogluon/pull/2105))
- Fix item order in GluonTS models predictions ([#2092](https://github.com/autogluon/autogluon/pull/2092))
- Implement hash_ts_dataframe_items ([#2060](https://github.com/autogluon/autogluon/pull/2060))
- Speed up TimeSeriesDataFrame.slice_by_timestep ([#2020](https://github.com/autogluon/autogluon/pull/2020))
- Speed up RandomForestQuantileRegressor and ExtraTreesQuantileRegressor ([#2204](https://github.com/autogluon/autogluon/pull/2204))
- Various backend enhancements / refactoring / cleanup ([#2314](https://github.com/autogluon/autogluon/pull/2314), [#2294](https://github.com/autogluon/autogluon/pull/2294), [#2292](https://github.com/autogluon/autogluon/pull/2292), [#2278](https://github.com/autogluon/autogluon/pull/2278), [#1985](https://github.com/autogluon/autogluon/pull/1985), [#2398](https://github.com/autogluon/autogluon/pull/2398))

[@canerturkmen](https://github.com/canerturkmen)
- Increase the number of samples used by DeepAR at prediction time ([#2291](https://github.com/autogluon/autogluon/pull/2291)) 
- revise timeseries presets to minimum context length of 10 ([#2065](https://github.com/autogluon/autogluon/pull/2065)) 
- Fix timeseries daily frequency inferred period ([#2100](https://github.com/autogluon/autogluon/pull/2100)) 
- Various backend enhancements / refactoring / cleanup ([#2286](https://github.com/autogluon/autogluon/pull/2286), [#2302](https://github.com/autogluon/autogluon/pull/2302), [#2240](https://github.com/autogluon/autogluon/pull/2240), [#2093](https://github.com/autogluon/autogluon/pull/2093), [#2098](https://github.com/autogluon/autogluon/pull/2098), [#2044](https://github.com/autogluon/autogluon/pull/2044), [#2385](https://github.com/autogluon/autogluon/pull/2385), [#2355](https://github.com/autogluon/autogluon/pull/2355), [#2405](https://github.com/autogluon/autogluon/pull/2405))
