# Object Detection

## Quick Start

::::{grid} 2
  :gutter: 3

:::{grid-item-card} Quick Start on a Tiny COCO Format Dataset
  :link: quick_start/quick_start_coco.html

  How to train high quality object detection model with AutoMM in under 5 minutes on COCO format dataset.
:::

::::

## Data Preparation

::::{grid} 2
  :gutter: 3

:::{grid-item-card} Prepare COCO2017 Dataset
  :link: data_preparation/prepare_coco17.html

  How to prepare COCO2017 dataset for object detection.
:::

:::{grid-item-card} Prepare Pascal VOC Dataset
  :link: data_preparation/prepare_voc.html

  How to prepare Pascal VOC dataset for object detection.
:::

:::{grid-item-card} Prepare Watercolor Dataset
  :link: data_preparation/prepare_watercolor.html

  How to prepare Watercolor dataset for object detection.
:::

:::{grid-item-card} Convert VOC Format Dataset to COCO Format
  :link: data_preparation/voc_to_coco.html

  How to convert a dataset from VOC format to COCO format for object detection.
:::

:::{grid-item-card} Object Detection with DataFrame
  :link: data_preparation/object_detection_with_dataframe.html

  How to use pd.DataFrame format for object detection
:::
::::

## Advanced

::::{grid} 2
  :gutter: 3

:::{grid-item-card} Finetune on COCO Format Dataset with Customized Settings
  :link: advanced/finetune_coco.html

  How to customize high quality object detection model with AutoMM on COCO format dataset in under 5 minutes.
:::

::::

```{toctree}
---
maxdepth: 1
hidden: true
---

quick_start/index
advanced/index
data_preparation/index
```
