Awesome AutoGluon
-----------------

This page contains a moderated list of examples, tutorials, articles, and research papers about AutoGluon use cases.
It is inspired by [awesome-machine-learning](https://github.com/josephmisiti/awesome-machine-learning).

We will be happy to add your success story using AutoGluon to this list.
Send us a pull request if you want to include your case here.

## Videos & Tutorials

To get started, we recommend watching [AutoGluon 1.0: Shattering the AutoML Ceiling with Zero Lines of Code](https://www.youtube.com/watch?v=5tvp_Ihgnuk), our talk at AutoML Conf 2023.

### Full Talk List

| Title                                                                                                                                                              | Format    | Location                                                                                                                           | Date       |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------|------------------------------------------------------------------------------------------------------------------------------------|------------|
| :tv: [AutoGluon: Towards No-Code Automated Machine Learning](https://www.youtube.com/watch?v=SwPq9qjaN2Q)                                                          | Tutorial  | [AutoML 2024](https://2024.automl.cc/)                                                                                             | 2024/09/09 |
| [AutoGluon: AutoML at Your Fingertips](https://suzhoum.github.io/icml-24-autogluon-talk/)                                                                          | Expo Talk | [ICML 2024](https://icml.cc/Expo/Conferences/2024/talk%20panel/36234)                                                              | 2024/07/21 |
| [AutoGluon 1.0: AutoML at Your Fingertips](https://autogluon.github.io/neurips-autogluon-workshop/)                                                                | Tutorial  | [NeurIPS 2023](https://neurips.cc/Expo/Conferences/2023/workshop/78401)                                                            | 2023/12/10 |
| :tv: [Leveraging Text, Images, and the Kitchen Sink to solve complex ML problems in 1 line of code](https://www.youtube.com/watch?v=fdfGb2jq-_c)                   | Tutorial  | [Fall AutoML School 2023](https://sites.google.com/view/automl-fall-school-2023/schedule/hands-on-autogluon?authuser=0)            | 2023/11/29 |
| :tv: [AutoGluon 1.0: Shattering the AutoML Ceiling with Zero Lines of Code](https://www.youtube.com/watch?v=5tvp_Ihgnuk)                                           | Tutorial  | [AutoML 2023](https://2023.automl.cc/)                                                                                             | 2023/09/12 |
| :sound: [AutoGluon: The Story](https://automlpodcast.com/episode/autogluon-the-story)                                                                              | Podcast   | [The AutoML Podcast](https://automlpodcast.com/)                                                                                   | 2023/09/05 |
| :tv: [AutoGluon: AutoML for Tabular, Multimodal, and Time Series Data](https://youtu.be/Lwu15m5mmbs?si=jSaFJDqkTU27C0fa)                                           | Tutorial  | PyData Berlin                                                                                                                      | 2023/06/20 | 
| :tv: [Solving Complex ML Problems in a few Lines of Code with AutoGluon](https://www.youtube.com/watch?v=J1UQUCPB88I)                                              | Tutorial  | PyData Seattle                                                                                                                     | 2023/06/20 | 
| [AutoGluon: Empowering (Multimodal) AutoML for the Next 10 Million Users](https://autogluon.github.io/neurips2022-autogluon-workshop/)                             | Tutorial  | [NeurIPS 2022](https://nips.cc/Expo/Conferences/2022/workshop/63089)                                                               | 2022/11/28 |
| :tv: [The AutoML Revolution](https://www.youtube.com/watch?v=VAAITEds-28)                                                                                          | Tutorial  | [Fall AutoML School 2022](https://sites.google.com/view/automl-fall-school-2022)                                                   | 2022/10/18 |
| [Multimodal AutoML for Image, Text and Tabular Data](https://github.com/Innixma/kdd-2022-multimodal-automl-tutorial)                                               | Tutorial  | [KDD 2022](https://kdd.org/kdd2022/lectureTutorial.html)                                                                           | 2022/08/14 |
| :tv: [Automating Machine Learning for the Rest of Us](https://www.youtube.com/watch?v=x-EEDBSl3OM)                                                                 | Keynote   | [AutoML 2022](https://2022.automl.cc/index.html)                                                                                   | 2022/07/25 |
| :tv: [AutoGluon: re:MARS 2022 Keynote](https://www.youtube.com/watch?v=_wd0IJBTwbY&t=1277s)                                                                        | Keynote   | [Amazon re:MARS 2022](https://icml.cc/virtual/2020/workshop/5725)                                                                  | 2022/06/24 |
| [Advancing the State of the Art in AutoML](https://developer.nvidia.com/blog/advancing-the-state-of-the-art-in-automl-now-10x-faster-with-nvidia-gpus-and-rapids/) | Talk      | [GTC 2021](https://developer.nvidia.com/blog/advancing-the-state-of-the-art-in-automl-now-10x-faster-with-nvidia-gpus-and-rapids/) | 2021/06/09 |
| :tv: [AutoGluon and Distillation](https://icml.cc/virtual/2020/7045)                                                                                               | Keynote   | [ICML 2020, AutoML Workshop](https://icml.cc/virtual/2020/workshop/5725)                                                           | 2020/07/18 |

### Articles
- [AutoGluon-TimeSeries: Every Time Series Forecasting Model In One Library](https://towardsdatascience.com/autogluon-timeseries-every-time-series-forecasting-model-in-one-library-29a3bf6879db) (*Towards Data Science*, Jan 2024)
- [AutoGluon-TimeSeries: Creating Powerful Ensemble Forecasts - Complete Tutorial](https://aihorizonforecast.substack.com/p/autogluon-timeseries-creating-powerful) (*AI Horizon Forecast*, Dec 2023)
- [AutoGluon for tabular data: 3 lines of code to achieve top 1% in Kaggle competitions](https://aws.amazon.com/blogs/opensource/machine-learning-with-autogluon-an-open-source-automl-library/) (*AWS Open Source Blog*, Mar 2020)
- [AutoGluon overview & example applications](https://towardsdatascience.com/autogluon-deep-learning-automl-5cdb4e2388ec?source=friends_link&sk=e3d17d06880ac714e47f07f39178fdf2) (*Towards Data Science*, Dec 2019)

## Competition Solutions using AutoGluon

AutoGluon is [widely adopted](https://www.kaggle.com/search?q=autogluon) on ML competition sites such as Kaggle. 
Below is a sampling of competition solutions that use AutoGluon to achieve strong results.

### Kaggle

#### 2024

| Placement                                | Competition Solution                                                                                                                                    | Author                                                                                                                                     | Date       | AutoGluon Details | Notes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
|:-----------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------|:-----------|:------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| :2nd_place_medal: Rank 2/2392 (Top 0.1%) | [Regression with an Insurance Dataset](https://www.kaggle.com/competitions/playground-series-s4e12/discussion/554505)                                   | [SCRIPTCHEF](https://www.kaggle.com/noodl35)                                                                                               | 2024/12/31 | v1.2, Tabular     | Kaggle Playground Series S4E12. Also used in [9th](https://www.kaggle.com/competitions/playground-series-s4e12/discussion/554377) and [10th](https://www.kaggle.com/competitions/playground-series-s4e12/discussion/554332) place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| :1st_place_medal: Rank 1/2687            | [Exploring Mental Health Data](https://www.kaggle.com/competitions/playground-series-s4e11/discussion/549160)                                           | [Mahdi Ravaghi](https://www.kaggle.com/ravaghi)                                                                                            | 2024/11/30 | v1.1, Tabular     | Kaggle Playground Series S4E11. Also used in [4th](https://www.kaggle.com/competitions/playground-series-s4e11/discussion/549197) and [13th](https://www.kaggle.com/competitions/playground-series-s4e11/discussion/549155) place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| Rank 8/3859 (Top 0.3%)                   | [Loan Approval Prediction](https://www.kaggle.com/competitions/playground-series-s4e10/discussion/543772)                                               | [Mahdi Ravaghi](https://www.kaggle.com/ravaghi)                                                                                            | 2024/10/31 | v1.1, Tabular     | Kaggle Playground Series S4E10                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| :1st_place_medal: Rank 1/3066            | [Regression of Used Car Prices](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/537052)                                           | [Mart Preusse](https://www.kaggle.com/martinapreusse)                                                                                      | 2024/09/30 | v1.1, Tabular     | Kaggle Playground Series S4E9. Also used in :2nd_place_medal: [2nd](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/537349), :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/537029), [4th](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/536973), and [5th](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/537173) place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| :1st_place_medal: Rank 1/1116            | [Kaggle AutoML Grand Prix (Overall)](https://www.kaggle.com/automl-grand-prix)                                                                          | [Alexander R.](https://www.kaggle.com/alexryzhkov), [Dmitry S.](https://www.kaggle.com/simakov), [Rinchin](https://www.kaggle.com/rinchin) | 2024/09/01 | v1.1, Tabular     | Teams using AutoGluon in the Grand Prix: :1st_place_medal: [1st](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/523732), :2nd_place_medal: [2nd](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/523656), :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/532028), [4th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524709), [6th](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/532758), [7th](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/532419), [8th](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/532668), [9th](https://www.kaggle.com/competitions/playground-series-s4e6/discussion/509937), and [10th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524752) place teams! |
| :2nd_place_medal: Rank 2/247 (Top 1%)    | [Kaggle AutoML Grand Prix Episode 5](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/532028)                                      | [Robert Hatch](https://www.kaggle.com/roberthatch)                                                                                         | 2024/09/01 | v1.1, Tabular     | Also used in :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/531971), [4th](https://www.kaggle.com/competitions/playground-series-s4e9/discussion/532419), 6th, 7th, 9th, and 10th place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| :1st_place_medal: Rank 1/2424            | [Binary Prediction of Poisonous Mushrooms](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531823)                                | [Optimistix](https://www.kaggle.com/optimistix)                                                                                            | 2024/08/31 | v1.1, Tabular     | Kaggle Playground Series S4E8. Also used in :2nd_place_medal: [2nd](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531368), :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531956), [4th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531343), [6th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531330), [8th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531374), and [10th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/531424) place solutions!                                                                                                                                                                                                                                                                           |
| :1st_place_medal: Rank 1/218             | [Kaggle AutoML Grand Prix Episode 4](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/523656)                                      | [Lennart P.](https://twitter.com/lennartpurucker), [Nick E.](https://twitter.com/innixma) & [Arjun K.](https://github.com/Neonkraft)       | 2024/08/01 | v1.1, Tabular     | Also used in :2nd_place_medal: [2nd](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524752), :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524709), [4th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/523837), [5th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/523660), [6th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524720), [7th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/523732), [8th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524544), [9th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524675), and [10th](https://www.kaggle.com/competitions/playground-series-s4e8/discussion/524430) place solutions!                                           |
| :3rd_place_medal: Rank 3/2236 (Top 0.2%) | [Binary Classification of Insurance Cross Selling](https://www.kaggle.com/competitions/playground-series-s4e7/discussion/523661)                        | [Tilii](https://www.kaggle.com/tilii7)                                                                                                     | 2024/07/31 | v1.1, Tabular     | Kaggle Playground Series S4E7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| Rank 4/207 (Top 2%)                      | [Kaggle AutoML Grand Prix Episode 3](https://www.kaggle.com/competitions/playground-series-s4e7/discussion/516265)                                      | [Lennart Purucker](https://twitter.com/lennartpurucker) & [Nick Erickson](https://twitter.com/innixma)                                     | 2024/07/01 | v1.1, Tabular     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Rank 17/2684 (Top 1%)                    | [Classification with an Academic Success Dataset](https://www.kaggle.com/competitions/playground-series-s4e6/discussion/516047)                         | [Mart Preusse](https://www.kaggle.com/martinapreusse)                                                                                      | 2024/06/30 | v1.1, Tabular     | Kaggle Playground Series S4E6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| :3rd_place_medal: Rank 3/542 (Top 0.6%)  | [WiDS Datathon 2024 Challenge #2](https://www.kaggle.com/competitions/widsdatathon2024-challenge2/discussion/511732)                                    | [olgaskv](https://www.kaggle.com/olgaskv)                                                                                                  | 2024/06/11 | v1.1, Tabular     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| :1st_place_medal: Rank 1/230             | [Kaggle AutoML Grand Prix Episode 2](https://www.kaggle.com/competitions/playground-series-s4e6/discussion/509631)                                      | [Lennart Purucker](https://twitter.com/lennartpurucker) & [Nick Erickson](https://twitter.com/innixma)                                     | 2024/06/01 | v1.1, Tabular     | Also used in [5th](https://www.kaggle.com/competitions/playground-series-s4e6/discussion/509937) place solution!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| :1st_place_medal: Rank 1/2788            | [Regression with a Flood Prediction Dataset](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/509043)                              | [Alexandre Daubas](https://www.kaggle.com/adaubas)                                                                                         | 2024/05/31 | v1.1, Tabular     | Kaggle Playground Series S4E5. Also used in :2nd_place_medal: [2nd](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/509410), :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/509042), and [4th](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/509044) place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Rank 5/214 (Top 3%)                      | [Kaggle AutoML Grand Prix Episode 1](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/500453)                                      | [James King](https://www.kaggle.com/jamesking76)                                                                                           | 2024/05/01 | v1.1, Tabular     | Also used in [8th](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/509410) and [9th](https://www.kaggle.com/competitions/playground-series-s4e5/discussion/509042) place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| :1st_place_medal: Rank 1/2606            | [Regression with an Abalone Dataset](https://www.kaggle.com/competitions/playground-series-s4e4/discussion/499174)                                      | [Johannes Heller](https://www.kaggle.com/stopwhispering)                                                                                   | 2024/04/30 | v1.0, Tabular     | Kaggle Playground Series S4E4. Also used in :2nd_place_medal: [2nd](https://www.kaggle.com/competitions/playground-series-s4e4/discussion/499698), :3rd_place_medal: [3rd](https://www.kaggle.com/competitions/playground-series-s4e4/discussion/499747), [4th](https://www.kaggle.com/competitions/playground-series-s4e4/discussion/499341), and [8th](https://www.kaggle.com/competitions/playground-series-s4e4/discussion/499258) place solutions!                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| :3rd_place_medal: Rank 3/2303 (Top 0.2%) | [Steel Plate Defect Prediction](https://www.kaggle.com/competitions/playground-series-s4e3/discussion/488127)                                           | [Samvel Kocharyan](https://github.com/samvelkoch)                                                                                          | 2024/03/31 | v1.0, Tabular     | Kaggle Playground Series S4E3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| :2nd_place_medal: Rank 2/93 (Top 2%)     | [Prediction Interval Competition I: Birth Weight](https://www.kaggle.com/competitions/prediction-interval-competition-i-birth-weight/discussion/496813) | [Oleksandr Shchur](https://shchur.github.io/)                                                                                              | 2024/03/21 | v1.0, Tabular     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| :2nd_place_medal: Rank 2/1542 (Top 0.2%) | [WiDS Datathon 2024 Challenge #1](https://www.kaggle.com/competitions/widsdatathon2024-challenge1/discussion/482285)                                    | [lazy_panda](https://www.kaggle.com/byteliberator)                                                                                         | 2024/03/01 | v1.0, Tabular     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| :2nd_place_medal: Rank 2/3746 (Top 0.1%) | [Multi-Class Prediction of Obesity Risk](https://www.kaggle.com/competitions/playground-series-s4e2/discussion/480939)                                  | [Kirderf](https://twitter.com/kirderf9)                                                                                                    | 2024/02/29 | v1.0, Tabular     | Kaggle Playground Series S4E2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| :2nd_place_medal: Rank 2/3777 (Top 0.1%) | [Binary Classification with a Bank Churn Dataset](https://www.kaggle.com/competitions/playground-series-s4e1/discussion/472496)                         | [lukaszl](https://www.kaggle.com/lukaszl)                                                                                                  | 2024/01/31 | v1.0, Tabular     | Kaggle Playground Series S4E1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |

#### Older Results

| Placement                               | Competition Solution                                                                                                                                   | Author                                                                | Date       | AutoGluon Details | Notes                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|:----------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------|:-----------|:------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Rank 4/1718 (Top 0.2%)                  | [Multi-Class Prediction of Cirrhosis Outcomes](https://www.kaggle.com/competitions/playground-series-s3e26/discussion/464863)                          | [Kirderf](https://twitter.com/kirderf9)                               | 2023/12/31 | v1.0, Tabular     | Kaggle Playground Series S3E26                                                                                                                                                                                                                                                                                                                                                                                                                        |
| :2nd_place_medal: Rank 2/58 (Top 4%)    | [ML Olympiad - Water Quality Prediction](https://www.kaggle.com/competitions/ml-olympiad-waterqualityprediction/discussion/393393)                     | [Chris X](https://www.kaggle.com/docxian)                             | 2023/03/11 | v0.6.2, Tabular   |                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| Rank 6/734 (Top 1%)                     | [Tabular Regression with a Gemstone Price Dataset](https://www.kaggle.com/competitions/playground-series-s3e8/discussion/392820)                       | [Kirderf](https://twitter.com/kirderf9)                               | 2023/03/06 | v0.6.2, Tabular   | Kaggle Playground Series S3E8                                                                                                                                                                                                                                                                                                                                                                                                                         |
| Rank 9/703 (Top 1.3%)                   | [Tabular Regression with a Paris Housing Price Dataset](https://www.kaggle.com/competitions/playground-series-s3e6/discussion/389151)                  | [Brendan Moore](https://www.kaggle.com/brendanmoore14)                | 2023/02/20 | v0.6.2, Tabular   | Kaggle Playground Series S3E6                                                                                                                                                                                                                                                                                                                                                                                                                         |
| :1st_place_medal: Rank 1/689            | [Tabular Regression with the California Housing Dataset](https://www.kaggle.com/competitions/playground-series-s3e1/discussion/377137)                 | [Kirderf](https://twitter.com/kirderf9)                               | 2023/01/09 | v0.6.1, Tabular   | Kaggle Playground Series S3E1                                                                                                                                                                                                                                                                                                                                                                                                                         |

## Research Papers

To view a list of all AutoGluon research papers, please refer to our [citation guide](CITING.md).

## AutoML Benchmarks using AutoGluon

### [AMLB: An AutoML Benchmark](https://openml.github.io/automlbenchmark/) (JMLR 2024)
* For a thorough comparison of AutoGluon and other modern AutoML systems, please refer to the 2024 JMLR paper ["AMLB: An AutoML Benchmark"](https://www.jmlr.org/papers/volume25/22-0493/22-0493.pdf) and the [2022 edition](https://arxiv.org/abs/2207.12560) where AutoGluon is shown to be the state-of-the-art among AutoML systems on tabular data.
* We encourage all users to benchmark AutoGluon & other AutoML frameworks on AMLB.
* This is our preferred benchmark as it is widely accepted and trusted within the AutoML community.

### [AutoML Benchmark with Shorter Time Constraints and Early Stopping](https://arxiv.org/pdf/2504.01222) (ICLR 2025)

The [AutoML Benchmark 2025](https://arxiv.org/pdf/2504.01222), an independent large-scale evaluation of tabular AutoML frameworks, showcases AutoGluon 1.2 as the state of the art AutoML framework. Highlights include:
- AutoGluon's rank statistically significantly outperforms all AutoML systems via the Nemenyi post-hoc test across all time constraints.
- AutoGluon with a 5 minute training budget outperforms all other AutoML systems with a 1 hour training budget.
- AutoGluon is pareto efficient in quality and speed across all evaluated presets and time constraints.
- AutoGluon with `presets="high", infer_limit=0.0001` (HQIL in the figures) achieves >10,000 samples/second inference throughput while outperforming all methods.
- AutoGluon is the most stable AutoML system. For "best" and "high" presets, AutoGluon has 0 failures on all time budgets >5 minutes.

<p float="left">
  <img src="https://raw.githubusercontent.com/Innixma/autogluon-doc-utils/refs/heads/main/docs/whats_new/v1.3.0/amlb2025_fig3a.png" width="40%"/>
  <img src="https://raw.githubusercontent.com/Innixma/autogluon-doc-utils/refs/heads/main/docs/whats_new/v1.3.0/amlb2025_fig10d.png" width="35%"/>
</p>

<img src="https://raw.githubusercontent.com/Innixma/autogluon-doc-utils/refs/heads/main/docs/whats_new/v1.3.0/amlb2025_fig1.png" width="100%"/>

## Papers using AutoGluon

Below is a sampling of some interesting papers that have cited AutoGluon.

* (2023/04/28) [Benchmarking Automated Machine Learning Methods for Price Forecasting Applications](https://arxiv.org/abs/2304.14735)
  * This paper compares various traditional and AutoML methods for price forecasting problems, with AutoGluon achieving the strongest results.
