# Contributing

Want to help contribute something to the project? Awesome! :smile:

Please take a moment to review this doc to make contributions easy and effective for everyone.

If there’s anything you’d like to discuss before diving in, you can find us on Gitter.

[![Gitter](https://badges.gitter.im/Join Chat.svg)](https://gitter.im/amsul/pickadate.js)


<a name="bugs"></a>

## Bug reports

If you believe you’ve found a bug within the repository code:

- Search the existing issues to avoid duplicates and to check if it has already been solved.
- Make sure you’re using the latest build.
- Isolate the problem and create a [reduced test case](http://css-tricks.com/6263-reduced-test-cases/) - preferably supported with a live example.
- Try to be as detailed as possible in the report (OS, browser, expected outcome vs actual outcome, etc).
- Please **do not** use the issue tracker for personal support requests. Instead try [Stack Overflow](http://stackoverflow.com/questions/tagged/pickadate) or the likes with a `pickadate` tag.




<a name="pull-requests"></a>

## Pull requests

If you’re submitting a pull request, please respect the coding standards used (indentations, comments, semi-colons, etc) as per the **Golden Rule**:

> All code in any code base should look like a single person typed it, no matter how many people contributed.

A few other things to keep in mind:

- Make sure the changes are suitable within the scope of this project.
- Discuss any significant features before endeavoring into developing them. I’d hate to have anyone spend effort on something only for me to not merge it into the main project.
- Include the relevant test coverage if any JavaScript files are involved.
- Compile the project using `grunt build --verbose` to make sure everything passes with a green flag.
- Use the Semantic Versioning guide, as mentioned in the [readme file](https://github.com/amsul/pickadate.js/#readme), in the case that a version bump is due.


#### All pull requests should be submitted to the `master` branch.




<a name="features"></a>

## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea fits within the scope and aims of this project. It’s up to *you* to make a strong case to the merits of this feature. Please provide as much detail and context as possible.



