/*
 * Copyright 2017-2019 Allegro.pl
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const {config: commonConfig} = require("./webpack.common");
const merge = require("webpack-merge");
const webpack = require('webpack');
const hotMiddlewareScript = 'webpack-hot-middleware/client';

module.exports = merge.smart(commonConfig, {
  mode: 'development',
  entry: {
    main: [hotMiddlewareScript, "./src/client/main.tsx"]
  },
  output: {
    publicPath: '/',
    pathinfo: false
  },
  plugins: [
    new webpack.DefinePlugin({
      'process.env.NODE_ENV': JSON.stringify('dev-hmr')
    }),
    new webpack.HotModuleReplacementPlugin(),
  ]
});
