# Get Started

If you are new to machine learning, we recommend taking the following online
course prior to diving into TensorFlow documentation:

  * [Machine Learning Crash Course](https://developers.google.com/machine-learning/crash-course/),
    which introduces machine learning concepts and encourages experimentation
    with existing TensorFlow code.

TensorFlow is a tool for machine learning. While it contains a wide range of
functionality, TensorFlow is mainly designed for deep neural network models.

The easiest way to get started with TensorFlow is by using Eager Execution.

  * @{$get_started/eager}, is for anyone new to machine learning or TensorFlow.

TensorFlow provides many APIs. The remainder of this section focuses on the
Estimator API which provide scalable, high-performance models. See the
@{$estimators} guide.

For more advanced users:

  * The @{$low_level_intro$Low Level Introduction} demonstrates how to use
    TensorFlow outside of the Estimator framework, for debugging and
    experimentation.
  * The @{$programmers_guide$Programmer's Guide} details major
    TensorFlow components.
  * The @{$tutorials$Tutorials} provide walkthroughs of a variety of
    TensorFlow models.
