# Swift Community

Welcome to the Swift for TensorFlow development community!

Swift for TensorFlow is a result of first-principles thinking applied to machine
learning frameworks, and works quite differently than existing TensorFlow
language bindings.  Whereas prior solutions are designed within the constraints
of what can be achieved by a (typically Python or Lua) library, Swift for
TensorFlow is based on the belief that machine learning is important enough to
deserve first-class language and compiler support.

First-class language and compiler support allows us to innovate in areas that
have traditionally been out of bounds for machine learning libraries.  Our
results provide the performance of TensorFlow graphs with the ease of use of
define-by-run models, and provides a great user experience - for example, by
catching more mistakes before you run your code.

## Open Source

As announced at the TensorFlow Developer Summit, we are planning to launch our
open source project on GitHub in April.  In addition to releasing the code, we
will be using an open design model, where design discussions happen in public.

Between now and then, we are writing some technical white papers that explain in
detail the design approach (e.g., the core compiler partitioning technique that
underlies the whole thing, our approach to automatic differentiation, etc.),
implementation tradeoffs, and the status of this work.  We can’t wait to engage
with the broader community, but prefer to start the conversation when these
white papers are ready.

[Sign up here to join the community Google
group](https://groups.google.com/a/tensorflow.org/d/forum/swift). We will
initially use it for announcements, and then open it for general discussion when
we are ready in April.

