# Community

Welcome to the TensorFlow community! This page explains where to get help, and
different ways to be part of the community. We are committed to fostering an
open and welcoming environment, and request that you review our [code of
conduct](https://github.com/tensorflow/tensorflow/blob/master/CODE_OF_CONDUCT.md).

## Get Help

### Technical Questions

To ask or answer technical questions about TensorFlow, use [Stack
Overflow](https://stackoverflow.com/questions/tagged/tensorflow). For example,
ask or search about a particular error message you encountered during
installation.

### Bugs and Feature Requests

To report bugs or make feature requests, file an issue on GitHub. Please choose
the appropriate repository for the project. Major repositories include:

  * [TensorFlow](https://github.com/tensorflow/tensorflow/issues)
  * [TensorBoard](https://github.com/tensorflow/tensorboard/issues)
  * [TensorFlow models](https://github.com/tensorflow/models/issues)
  
### Security

Before using TensorFlow, please take a look at our security model, list of
recent security announcements, and ways you can report security issues to the
TensorFlow team at the
[Using TensorFlow Securely](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) page on GitHub.

## Stay Informed

### Announcements Mailing List

All major releases and important announcements are sent to
[announce@tensorflow.org](https://groups.google.com/a/tensorflow.org/forum/#!forum/announce).
We recommend that you join this list if you depend on TensorFlow in any way.

### Development Roadmap

The @{$roadmap$Roadmap} summarizes plans for upcoming additions to TensorFlow.

### Social Media

For news and updates from around the universe of TensorFlow projects, follow
[@tensorflow](https://twitter.com/tensorflow) on Twitter.

### Blog

We post regularly to the [TensorFlow Blog](http://blog.tensorflow.org/),
with content from the TensorFlow team and the best articles from the community.

### YouTube

Our [YouTube Channel](http://youtube.com/tensorflow/) focuses on machine learing
and AI with TensorFlow. On it we have a number of new shows, including:

- TensorFlow Meets: meet with community contributors to learn and share what they're doing
- Ask TensorFlow: the team answers the best questions tagged #AskTensorFlow from social media 
- Coding TensorFlow: short bites with tips for success with TensorFlow

## Community Support

### Mailing Lists

For general discussion about TensorFlow development and direction, please join
the [TensorFlow discuss mailing
list](https://groups.google.com/a/tensorflow.org/d/forum/discuss).

A number of other mailing lists exist, focused on different project areas, which
can be found at @{$lists$TensorFlow Mailing Lists}.

### User Groups

To meet with like-minded people local to you, check out the many
@{$groups$TensorFlow user groups} around the world.


## Contributing To TensorFlow

We welcome contributions and collaboration on TensorFlow. For more information,
please read [Contributing to TensorFlow](contributing.md).

