# Building Graphs
[TOC]

Classes and functions for building TensorFlow graphs.

## Core graph data structures

*   @{tf.Graph}
*   @{tf.Operation}
*   @{tf.Tensor}

## Tensor types

*   @{tf.DType}
*   @{tf.as_dtype}

## Utility functions

*   @{tf.device}
*   @{tf.container}
*   @{tf.name_scope}
*   @{tf.control_dependencies}
*   @{tf.convert_to_tensor}
*   @{tf.convert_to_tensor_or_indexed_slices}
*   @{tf.convert_to_tensor_or_sparse_tensor}
*   @{tf.get_default_graph}
*   @{tf.reset_default_graph}
*   @{tf.import_graph_def}
*   @{tf.load_file_system_library}
*   @{tf.load_op_library}

## Graph collections

*   @{tf.add_to_collection}
*   @{tf.get_collection}
*   @{tf.get_collection_ref}
*   @{tf.GraphKeys}

## Defining new operations

*   @{tf.RegisterGradient}
*   @{tf.NotDifferentiable}
*   @{tf.NoGradient}
*   @{tf.TensorShape}
*   @{tf.Dimension}
*   @{tf.op_scope}
*   @{tf.get_seed}

## For libraries building on TensorFlow

*   @{tf.register_tensor_conversion_function}
