---
title: Huma Introduction
description: A modern, simple, fast & flexible micro framework for building HTTP APIs in Golang backed by OpenAPI 3 and JSON Schema.
hide:
    - navigation
sponsors:
    - bclements
    - bekabaz
    - victoraugustolls
---

# Huma {.hidden}

## Introduction {.hidden}

![Huma Logo](./huma.png#only-light)
![Huma Logo](./huma-dark.png#only-dark)

<div style="display: flex; justify-content: center;" markdown>
[![Huma Powered](https://img.shields.io/badge/Powered%20By-Huma-f40273)](https://huma.rocks/) [![CI](https://github.com/danielgtaylor/huma/workflows/CI/badge.svg?branch=main)](https://github.com/danielgtaylor/huma/actions?query=workflow%3ACI+branch%3Amain++) [![codecov](https://codecov.io/gh/danielgtaylor/huma/branch/main/graph/badge.svg)](https://codecov.io/gh/danielgtaylor/huma) [![Docs](https://godoc.org/github.com/danielgtaylor/huma/v2?status.svg)](https://pkg.go.dev/github.com/danielgtaylor/huma/v2?tab=doc) [![Go Report Card](https://goreportcard.com/badge/github.com/danielgtaylor/huma/v2)](https://goreportcard.com/report/github.com/danielgtaylor/huma/v2)
</div>

A modern, simple, fast & flexible micro framework for building HTTP REST/RPC APIs in Golang backed by OpenAPI 3 and JSON Schema. Pronounced IPA: [/'hjuːmɑ/](https://en.wiktionary.org/wiki/Wiktionary:International_Phonetic_Alphabet).

## Goals

The goals of this project are to provide:

-   A modern REST or HTTP RPC API backend framework for Go developers
    -   Described by [OpenAPI 3.1](https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.1.0.md) & [JSON Schema](https://json-schema.org/)
-   Incremental adoption for teams with existing services
    -   Bring your own router, middleware, and logging/metrics
    -   Extensible OpenAPI & JSON Schema layer to document existing routes
-   Guard rails to prevent common mistakes
-   Documentation that can't get out of date
-   High-quality generated developer tooling

## Starting Points

<div class="grid cards" markdown>
<ul markdown>
  <li markdown>
      <h3>Why Huma</h3>
      <hr/>
      What makes Huma different and why should you use it for your next project?<br/>
      <br/>
      <a href="./why/">:material-arrow-right: Learn more</a>
  </li>
</ul>
<ul markdown>
  <li markdown>
    <h3>Tutorial in 5 Minutes</h3>
    <hr/>
    Install <code>huma</code> and have a working API in about five minutes.<br/>
    <br/>
    <a href="./tutorial/installation/">:material-arrow-right: Get started</a>
  </li>
</ul>
<ul markdown>
  <li markdown>
    <h3>How To Guides</h3>
    <hr/>
    Learn how to solve specific real-world problems with Huma.<br/>
    <br/>
    <a href="./how-to/custom-validation/">:material-arrow-right: Solve problems</a>
  </li>
</ul>
<ul markdown>
  <li markdown>
    <h3>Features & Reference</h3>
    <hr/>
    Learn about all of Huma's features & how to use them.<br/>
    <br/>
    <a href="./features/">:material-arrow-right: Feature docs</a><br/>
    <a href="https://pkg.go.dev/github.com/danielgtaylor/huma/v2?tab=doc">:material-arrow-right: Go reference</a>
  </li>
</ul>
</div>
