### `tf.case(pred_fn_pairs, default, exclusive=False, name='case')` {#case}

Create a case operation.

The `pred_fn_pairs` parameter is a dict or list of pairs of size N.
Each pair contains a boolean scalar tensor and a python callable that
creates the tensors to be returned if the boolean evaluates to True.
`default` is a callable generating a list of tensors. All the callables
in `pred_fn_pairs` as well as `default` should return the same number
and types of tensors.

If `exclusive==True`, all predicates are evaluated, and a logging operation
with an error is returned if more than one of the predicates evaluates to
True. If `exclusive==False`, execution stops are the first predicate which
evaluates to True, and the tensors generated by the corresponding function
are returned immediately. If none of the predicates evaluate to True, this
operation returns the tensors generated by `default`.

Example 1:
  Pseudocode:
  ```
    if (x < y) return 17;
    else return 23;
  ```

  Expressions:
  ```
    f1 = lambda: tf.constant(17)
    f2 = lambda: tf.constant(23)
    r = case([(tf.less(x, y), f1)], default=f2)
  ```

Example 2:
  Pseudocode:
  ```
    if (x < y && x > z) raise OpError("Only one predicate may evaluate true");
    if (x < y) return 17;
    else if (x > z) return 23;
    else return -1;
  ```

  Expressions:
  ```
    x = tf.constant(0)
    y = tf.constant(1)
    z = tf.constant(2)
    def f1(): return tf.constant(17)
    def f2(): return tf.constant(23)
    def f3(): return tf.constant(-1)
    r = case({tf.less(x, y): f1, tf.greater(x, z): f2},
             default=f3, exclusive=True)
  ```

##### Args:


*  <b>`pred_fn_pairs`</b>: Dict or list of pairs of a boolean scalar tensor and a
                 callable which returns a list of tensors.
*  <b>`default`</b>: A callable that returns a list of tensors.
*  <b>`exclusive`</b>: True iff more than one predicate is allowed to evaluate to True.
*  <b>`name`</b>: A name for this operation (optional).

##### Returns:

  The tensors returned by the first pair whose predicate evaluated to True, or
  those returned by `default` if none does.

##### Raises:


*  <b>`TypeError`</b>: If `pred_fn_pairs` is not a list/dictionary.
*  <b>`TypeError`</b>: If `pred_fn_pairs` is a list but does not contain 2-tuples.
*  <b>`TypeError`</b>: If `fns[i]` is not callable for any i, or `default` is not
             callable.

