# Getting Started

For a brief overview of TensorFlow programming fundamentals, see the following
guide:

  * @{$get_started/get_started$Getting Started with TensorFlow}

MNIST has become the canonical dataset for trying out a new machine learning
toolkit.  We offer three guides that each demonstrate a different approach
to training an MNIST model on TensorFlow:

  * @{$mnist/beginners$MNIST for ML Beginners}, which introduces MNIST through
    the high-level API.
  * @{$mnist/pros$Deep MNIST for Experts}, which is more-in depth than
    "MNIST for ML Beginners," and assumes some familiarity with machine
    learning concepts.
  * @{$mnist/mechanics$TensorFlow Mechanics 101}, which introduces MNIST through
    the low-level API.

For developers new to TensorFlow, the high-level API is a good place to start.
To learn about the high-level API, read the following guides:

  * @{$get_started/estimator$tf.estimator Quickstart}, which introduces this
    API.
  * @{$get_started/input_fn$Building Input Functions with tf.contrib.learn},
    which takes you into a somewhat more sophisticated use of this API.
  * @{$get_started/monitors$Logging and Monitoring Basics with tf.contrib.learn},
    which explains how to audit the progress of model training.
  * @{$get_started/export$Exporting a Trained Model for Serving}, which shows
    how to save a trained model in a form that is ready to deploy.

TensorBoard is a utility to visualize different aspects of machine learning.
The following guides explain how to use TensorBoard:

  * @{$get_started/summaries_and_tensorboard$TensorBoard: Visualizing Learning},
    which gets you started.
  * @{$get_started/embedding_viz$TensorBoard: Embedding Visualization}, which
    demonstrates how to view and interact with high-dimensional data, such as
    embeddings.
  * @{$get_started/graph_viz$TensorBoard: Graph Visualization}, which explains
    how to visualize the computational graph.  Graph visualization is typically
    more useful for programmers using the low-level API.

