# Roadmap
**Last updated: January 23, 2017**

TensorFlow is a fast moving project. In order for the community to better
understand what the near future will bring, this document shares what we are
working on internally. Many of these features were requested by the community,
and we welcome
[contributions](https://github.com/tensorflow/tensorflow/labels/stat%3Acontributions%20welcome).

The features on this list are targeted for the next few months. At this point,
we do not have timelines for these features.

### Improve non-Python language support

* Support for adding gradient computation for graphs constructed in other
  languages (C++, Java, Go etc.)

### Making TensorFlow easier to use
* High-level APIs
* Well-maintained models showing best practices

### Performance
* Speed and memory benchmarks
* Distributed full model benchmarks
* Performance and memory usage improvements

### Core Features
* Automatic op placement ([#2126](https://github.com/tensorflow/tensorflow/issues/2126))
* Support for graph-level functions

### Platforms
* OpenCL support ([#22](https://github.com/tensorflow/tensorflow/issues/22))

### Community
* More educational resources
* Better integration of TensorFlow into the opensource big data ecosystem (e.g.
[#2655](https://github.com/tensorflow/tensorflow/issues/2655))
