/* Copyright 2015 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

// automatically generated by the FlatBuffers compiler, do not modify

#ifndef FLATBUFFERS_GENERATED_SCHEMA_TFLITE_H_
#define FLATBUFFERS_GENERATED_SCHEMA_TFLITE_H_

#include "flatbuffers/flatbuffers.h"

namespace tflite {

struct QuantizationParameters;
struct QuantizationParametersT;

struct Tensor;
struct TensorT;

struct Conv2DOptions;
struct Conv2DOptionsT;

struct Pool2DOptions;
struct Pool2DOptionsT;

struct DepthwiseConv2DOptions;
struct DepthwiseConv2DOptionsT;

struct ConcatEmbeddingsOptions;
struct ConcatEmbeddingsOptionsT;

struct LSHProjectionOptions;
struct LSHProjectionOptionsT;

struct SVDFOptions;
struct SVDFOptionsT;

struct RNNOptions;
struct RNNOptionsT;

struct FullyConnectedOptions;
struct FullyConnectedOptionsT;

struct SoftmaxOptions;
struct SoftmaxOptionsT;

struct ConcatenationOptions;
struct ConcatenationOptionsT;

struct AddOptions;
struct AddOptionsT;

struct MulOptions;
struct MulOptionsT;

struct L2NormOptions;
struct L2NormOptionsT;

struct LocalResponseNormalizationOptions;
struct LocalResponseNormalizationOptionsT;

struct LSTMOptions;
struct LSTMOptionsT;

struct ResizeBilinearOptions;
struct ResizeBilinearOptionsT;

struct CallOptions;
struct CallOptionsT;

struct PadOptions;
struct PadOptionsT;

struct ReshapeOptions;
struct ReshapeOptionsT;

struct SkipGramOptions;
struct SkipGramOptionsT;

struct SpaceToDepthOptions;
struct SpaceToDepthOptionsT;

struct EmbeddingLookupSparseOptions;
struct EmbeddingLookupSparseOptionsT;

struct OperatorCode;
struct OperatorCodeT;

struct Operator;
struct OperatorT;

struct SubGraph;
struct SubGraphT;

struct Buffer;
struct BufferT;

struct Model;
struct ModelT;

enum TensorType {
  TensorType_FLOAT32 = 0,
  TensorType_FLOAT16 = 1,
  TensorType_INT32 = 2,
  TensorType_UINT8 = 3,
  TensorType_INT64 = 4,
  TensorType_STRING = 5,
  TensorType_MIN = TensorType_FLOAT32,
  TensorType_MAX = TensorType_STRING
};

inline TensorType (&EnumValuesTensorType())[6] {
  static TensorType values[] = {TensorType_FLOAT32, TensorType_FLOAT16,
                                TensorType_INT32,   TensorType_UINT8,
                                TensorType_INT64,   TensorType_STRING};
  return values;
}

inline const char **EnumNamesTensorType() {
  static const char *names[] = {"FLOAT32", "FLOAT16", "INT32", "UINT8",
                                "INT64",   "STRING",  nullptr};
  return names;
}

inline const char *EnumNameTensorType(TensorType e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesTensorType()[index];
}

enum BuiltinOperator {
  BuiltinOperator_ADD = 0,
  BuiltinOperator_AVERAGE_POOL_2D = 1,
  BuiltinOperator_CONCATENATION = 2,
  BuiltinOperator_CONV_2D = 3,
  BuiltinOperator_DEPTHWISE_CONV_2D = 4,
  BuiltinOperator_EMBEDDING_LOOKUP = 7,
  BuiltinOperator_FULLY_CONNECTED = 9,
  BuiltinOperator_HASHTABLE_LOOKUP = 10,
  BuiltinOperator_L2_NORMALIZATION = 11,
  BuiltinOperator_L2_POOL_2D = 12,
  BuiltinOperator_LOCAL_RESPONSE_NORMALIZATION = 13,
  BuiltinOperator_LOGISTIC = 14,
  BuiltinOperator_LSH_PROJECTION = 15,
  BuiltinOperator_LSTM = 16,
  BuiltinOperator_MAX_POOL_2D = 17,
  BuiltinOperator_MUL = 18,
  BuiltinOperator_RELU = 19,
  BuiltinOperator_RELU1 = 20,
  BuiltinOperator_RELU6 = 21,
  BuiltinOperator_RESHAPE = 22,
  BuiltinOperator_RESIZE_BILINEAR = 23,
  BuiltinOperator_RNN = 24,
  BuiltinOperator_SOFTMAX = 25,
  BuiltinOperator_SPACE_TO_DEPTH = 26,
  BuiltinOperator_SVDF = 27,
  BuiltinOperator_TANH = 28,
  BuiltinOperator_CONCAT_EMBEDDINGS = 29,
  BuiltinOperator_SKIP_GRAM = 30,
  BuiltinOperator_CALL = 31,
  BuiltinOperator_CUSTOM = 32,
  BuiltinOperator_EMBEDDING_LOOKUP_SPARSE = 33,
  BuiltinOperator_PAD = 34,
  BuiltinOperator_MIN = BuiltinOperator_ADD,
  BuiltinOperator_MAX = BuiltinOperator_PAD
};

inline BuiltinOperator (&EnumValuesBuiltinOperator())[32] {
  static BuiltinOperator values[] = {
      BuiltinOperator_ADD,
      BuiltinOperator_AVERAGE_POOL_2D,
      BuiltinOperator_CONCATENATION,
      BuiltinOperator_CONV_2D,
      BuiltinOperator_DEPTHWISE_CONV_2D,
      BuiltinOperator_EMBEDDING_LOOKUP,
      BuiltinOperator_FULLY_CONNECTED,
      BuiltinOperator_HASHTABLE_LOOKUP,
      BuiltinOperator_L2_NORMALIZATION,
      BuiltinOperator_L2_POOL_2D,
      BuiltinOperator_LOCAL_RESPONSE_NORMALIZATION,
      BuiltinOperator_LOGISTIC,
      BuiltinOperator_LSH_PROJECTION,
      BuiltinOperator_LSTM,
      BuiltinOperator_MAX_POOL_2D,
      BuiltinOperator_MUL,
      BuiltinOperator_RELU,
      BuiltinOperator_RELU1,
      BuiltinOperator_RELU6,
      BuiltinOperator_RESHAPE,
      BuiltinOperator_RESIZE_BILINEAR,
      BuiltinOperator_RNN,
      BuiltinOperator_SOFTMAX,
      BuiltinOperator_SPACE_TO_DEPTH,
      BuiltinOperator_SVDF,
      BuiltinOperator_TANH,
      BuiltinOperator_CONCAT_EMBEDDINGS,
      BuiltinOperator_SKIP_GRAM,
      BuiltinOperator_CALL,
      BuiltinOperator_CUSTOM,
      BuiltinOperator_EMBEDDING_LOOKUP_SPARSE,
      BuiltinOperator_PAD};
  return values;
}

inline const char **EnumNamesBuiltinOperator() {
  static const char *names[] = {"ADD",
                                "AVERAGE_POOL_2D",
                                "CONCATENATION",
                                "CONV_2D",
                                "DEPTHWISE_CONV_2D",
                                "",
                                "",
                                "EMBEDDING_LOOKUP",
                                "",
                                "FULLY_CONNECTED",
                                "HASHTABLE_LOOKUP",
                                "L2_NORMALIZATION",
                                "L2_POOL_2D",
                                "LOCAL_RESPONSE_NORMALIZATION",
                                "LOGISTIC",
                                "LSH_PROJECTION",
                                "LSTM",
                                "MAX_POOL_2D",
                                "MUL",
                                "RELU",
                                "RELU1",
                                "RELU6",
                                "RESHAPE",
                                "RESIZE_BILINEAR",
                                "RNN",
                                "SOFTMAX",
                                "SPACE_TO_DEPTH",
                                "SVDF",
                                "TANH",
                                "CONCAT_EMBEDDINGS",
                                "SKIP_GRAM",
                                "CALL",
                                "CUSTOM",
                                "EMBEDDING_LOOKUP_SPARSE",
                                "PAD",
                                nullptr};
  return names;
}

inline const char *EnumNameBuiltinOperator(BuiltinOperator e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesBuiltinOperator()[index];
}

enum BuiltinOptions {
  BuiltinOptions_NONE = 0,
  BuiltinOptions_Conv2DOptions = 1,
  BuiltinOptions_DepthwiseConv2DOptions = 2,
  BuiltinOptions_ConcatEmbeddingsOptions = 3,
  BuiltinOptions_LSHProjectionOptions = 4,
  BuiltinOptions_Pool2DOptions = 5,
  BuiltinOptions_SVDFOptions = 6,
  BuiltinOptions_RNNOptions = 7,
  BuiltinOptions_FullyConnectedOptions = 8,
  BuiltinOptions_SoftmaxOptions = 9,
  BuiltinOptions_ConcatenationOptions = 10,
  BuiltinOptions_AddOptions = 11,
  BuiltinOptions_L2NormOptions = 12,
  BuiltinOptions_LocalResponseNormalizationOptions = 13,
  BuiltinOptions_LSTMOptions = 14,
  BuiltinOptions_ResizeBilinearOptions = 15,
  BuiltinOptions_CallOptions = 16,
  BuiltinOptions_ReshapeOptions = 17,
  BuiltinOptions_SkipGramOptions = 18,
  BuiltinOptions_SpaceToDepthOptions = 19,
  BuiltinOptions_EmbeddingLookupSparseOptions = 20,
  BuiltinOptions_MulOptions = 21,
  BuiltinOptions_PadOptions = 22,
  BuiltinOptions_MIN = BuiltinOptions_NONE,
  BuiltinOptions_MAX = BuiltinOptions_PadOptions
};

inline BuiltinOptions (&EnumValuesBuiltinOptions())[23] {
  static BuiltinOptions values[] = {
      BuiltinOptions_NONE,
      BuiltinOptions_Conv2DOptions,
      BuiltinOptions_DepthwiseConv2DOptions,
      BuiltinOptions_ConcatEmbeddingsOptions,
      BuiltinOptions_LSHProjectionOptions,
      BuiltinOptions_Pool2DOptions,
      BuiltinOptions_SVDFOptions,
      BuiltinOptions_RNNOptions,
      BuiltinOptions_FullyConnectedOptions,
      BuiltinOptions_SoftmaxOptions,
      BuiltinOptions_ConcatenationOptions,
      BuiltinOptions_AddOptions,
      BuiltinOptions_L2NormOptions,
      BuiltinOptions_LocalResponseNormalizationOptions,
      BuiltinOptions_LSTMOptions,
      BuiltinOptions_ResizeBilinearOptions,
      BuiltinOptions_CallOptions,
      BuiltinOptions_ReshapeOptions,
      BuiltinOptions_SkipGramOptions,
      BuiltinOptions_SpaceToDepthOptions,
      BuiltinOptions_EmbeddingLookupSparseOptions,
      BuiltinOptions_MulOptions,
      BuiltinOptions_PadOptions};
  return values;
}

inline const char **EnumNamesBuiltinOptions() {
  static const char *names[] = {"NONE",
                                "Conv2DOptions",
                                "DepthwiseConv2DOptions",
                                "ConcatEmbeddingsOptions",
                                "LSHProjectionOptions",
                                "Pool2DOptions",
                                "SVDFOptions",
                                "RNNOptions",
                                "FullyConnectedOptions",
                                "SoftmaxOptions",
                                "ConcatenationOptions",
                                "AddOptions",
                                "L2NormOptions",
                                "LocalResponseNormalizationOptions",
                                "LSTMOptions",
                                "ResizeBilinearOptions",
                                "CallOptions",
                                "ReshapeOptions",
                                "SkipGramOptions",
                                "SpaceToDepthOptions",
                                "EmbeddingLookupSparseOptions",
                                "MulOptions",
                                "PadOptions",
                                nullptr};
  return names;
}

inline const char *EnumNameBuiltinOptions(BuiltinOptions e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesBuiltinOptions()[index];
}

template <typename T>
struct BuiltinOptionsTraits {
  static const BuiltinOptions enum_value = BuiltinOptions_NONE;
};

template <>
struct BuiltinOptionsTraits<Conv2DOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_Conv2DOptions;
};

template <>
struct BuiltinOptionsTraits<DepthwiseConv2DOptions> {
  static const BuiltinOptions enum_value =
      BuiltinOptions_DepthwiseConv2DOptions;
};

template <>
struct BuiltinOptionsTraits<ConcatEmbeddingsOptions> {
  static const BuiltinOptions enum_value =
      BuiltinOptions_ConcatEmbeddingsOptions;
};

template <>
struct BuiltinOptionsTraits<LSHProjectionOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_LSHProjectionOptions;
};

template <>
struct BuiltinOptionsTraits<Pool2DOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_Pool2DOptions;
};

template <>
struct BuiltinOptionsTraits<SVDFOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_SVDFOptions;
};

template <>
struct BuiltinOptionsTraits<RNNOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_RNNOptions;
};

template <>
struct BuiltinOptionsTraits<FullyConnectedOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_FullyConnectedOptions;
};

template <>
struct BuiltinOptionsTraits<SoftmaxOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_SoftmaxOptions;
};

template <>
struct BuiltinOptionsTraits<ConcatenationOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_ConcatenationOptions;
};

template <>
struct BuiltinOptionsTraits<AddOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_AddOptions;
};

template <>
struct BuiltinOptionsTraits<L2NormOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_L2NormOptions;
};

template <>
struct BuiltinOptionsTraits<LocalResponseNormalizationOptions> {
  static const BuiltinOptions enum_value =
      BuiltinOptions_LocalResponseNormalizationOptions;
};

template <>
struct BuiltinOptionsTraits<LSTMOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_LSTMOptions;
};

template <>
struct BuiltinOptionsTraits<ResizeBilinearOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_ResizeBilinearOptions;
};

template <>
struct BuiltinOptionsTraits<CallOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_CallOptions;
};

template <>
struct BuiltinOptionsTraits<ReshapeOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_ReshapeOptions;
};

template <>
struct BuiltinOptionsTraits<SkipGramOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_SkipGramOptions;
};

template <>
struct BuiltinOptionsTraits<SpaceToDepthOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_SpaceToDepthOptions;
};

template <>
struct BuiltinOptionsTraits<EmbeddingLookupSparseOptions> {
  static const BuiltinOptions enum_value =
      BuiltinOptions_EmbeddingLookupSparseOptions;
};

template <>
struct BuiltinOptionsTraits<MulOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_MulOptions;
};

template <>
struct BuiltinOptionsTraits<PadOptions> {
  static const BuiltinOptions enum_value = BuiltinOptions_PadOptions;
};

struct BuiltinOptionsUnion {
  BuiltinOptions type;
  void *value;

  BuiltinOptionsUnion() : type(BuiltinOptions_NONE), value(nullptr) {}
  BuiltinOptionsUnion(BuiltinOptionsUnion &&u) FLATBUFFERS_NOEXCEPT
      : type(BuiltinOptions_NONE),
        value(nullptr) {
    std::swap(type, u.type);
    std::swap(value, u.value);
  }
  BuiltinOptionsUnion(const BuiltinOptionsUnion &) FLATBUFFERS_NOEXCEPT;
  BuiltinOptionsUnion &operator=(const BuiltinOptionsUnion &u)
      FLATBUFFERS_NOEXCEPT {
    BuiltinOptionsUnion t(u);
    std::swap(type, t.type);
    std::swap(value, t.value);
    return *this;
  }
  BuiltinOptionsUnion &operator=(BuiltinOptionsUnion &&u) FLATBUFFERS_NOEXCEPT {
    std::swap(type, u.type);
    std::swap(value, u.value);
    return *this;
  }
  ~BuiltinOptionsUnion() { Reset(); }

  void Reset();

#ifndef FLATBUFFERS_CPP98_STL
  template <typename T>
  void Set(T &&val) {
    Reset();
    type = BuiltinOptionsTraits<typename T::TableType>::enum_value;
    if (type != BuiltinOptions_NONE) {
      value = new T(std::forward<T>(val));
    }
  }
#endif  // FLATBUFFERS_CPP98_STL

  static void *UnPack(const void *obj, BuiltinOptions type,
                      const flatbuffers::resolver_function_t *resolver);
  flatbuffers::Offset<void> Pack(
      flatbuffers::FlatBufferBuilder &_fbb,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr) const;

  Conv2DOptionsT *AsConv2DOptions() {
    return type == BuiltinOptions_Conv2DOptions
               ? reinterpret_cast<Conv2DOptionsT *>(value)
               : nullptr;
  }
  const Conv2DOptionsT *AsConv2DOptions() const {
    return type == BuiltinOptions_Conv2DOptions
               ? reinterpret_cast<const Conv2DOptionsT *>(value)
               : nullptr;
  }
  DepthwiseConv2DOptionsT *AsDepthwiseConv2DOptions() {
    return type == BuiltinOptions_DepthwiseConv2DOptions
               ? reinterpret_cast<DepthwiseConv2DOptionsT *>(value)
               : nullptr;
  }
  const DepthwiseConv2DOptionsT *AsDepthwiseConv2DOptions() const {
    return type == BuiltinOptions_DepthwiseConv2DOptions
               ? reinterpret_cast<const DepthwiseConv2DOptionsT *>(value)
               : nullptr;
  }
  ConcatEmbeddingsOptionsT *AsConcatEmbeddingsOptions() {
    return type == BuiltinOptions_ConcatEmbeddingsOptions
               ? reinterpret_cast<ConcatEmbeddingsOptionsT *>(value)
               : nullptr;
  }
  const ConcatEmbeddingsOptionsT *AsConcatEmbeddingsOptions() const {
    return type == BuiltinOptions_ConcatEmbeddingsOptions
               ? reinterpret_cast<const ConcatEmbeddingsOptionsT *>(value)
               : nullptr;
  }
  LSHProjectionOptionsT *AsLSHProjectionOptions() {
    return type == BuiltinOptions_LSHProjectionOptions
               ? reinterpret_cast<LSHProjectionOptionsT *>(value)
               : nullptr;
  }
  const LSHProjectionOptionsT *AsLSHProjectionOptions() const {
    return type == BuiltinOptions_LSHProjectionOptions
               ? reinterpret_cast<const LSHProjectionOptionsT *>(value)
               : nullptr;
  }
  Pool2DOptionsT *AsPool2DOptions() {
    return type == BuiltinOptions_Pool2DOptions
               ? reinterpret_cast<Pool2DOptionsT *>(value)
               : nullptr;
  }
  const Pool2DOptionsT *AsPool2DOptions() const {
    return type == BuiltinOptions_Pool2DOptions
               ? reinterpret_cast<const Pool2DOptionsT *>(value)
               : nullptr;
  }
  SVDFOptionsT *AsSVDFOptions() {
    return type == BuiltinOptions_SVDFOptions
               ? reinterpret_cast<SVDFOptionsT *>(value)
               : nullptr;
  }
  const SVDFOptionsT *AsSVDFOptions() const {
    return type == BuiltinOptions_SVDFOptions
               ? reinterpret_cast<const SVDFOptionsT *>(value)
               : nullptr;
  }
  RNNOptionsT *AsRNNOptions() {
    return type == BuiltinOptions_RNNOptions
               ? reinterpret_cast<RNNOptionsT *>(value)
               : nullptr;
  }
  const RNNOptionsT *AsRNNOptions() const {
    return type == BuiltinOptions_RNNOptions
               ? reinterpret_cast<const RNNOptionsT *>(value)
               : nullptr;
  }
  FullyConnectedOptionsT *AsFullyConnectedOptions() {
    return type == BuiltinOptions_FullyConnectedOptions
               ? reinterpret_cast<FullyConnectedOptionsT *>(value)
               : nullptr;
  }
  const FullyConnectedOptionsT *AsFullyConnectedOptions() const {
    return type == BuiltinOptions_FullyConnectedOptions
               ? reinterpret_cast<const FullyConnectedOptionsT *>(value)
               : nullptr;
  }
  SoftmaxOptionsT *AsSoftmaxOptions() {
    return type == BuiltinOptions_SoftmaxOptions
               ? reinterpret_cast<SoftmaxOptionsT *>(value)
               : nullptr;
  }
  const SoftmaxOptionsT *AsSoftmaxOptions() const {
    return type == BuiltinOptions_SoftmaxOptions
               ? reinterpret_cast<const SoftmaxOptionsT *>(value)
               : nullptr;
  }
  ConcatenationOptionsT *AsConcatenationOptions() {
    return type == BuiltinOptions_ConcatenationOptions
               ? reinterpret_cast<ConcatenationOptionsT *>(value)
               : nullptr;
  }
  const ConcatenationOptionsT *AsConcatenationOptions() const {
    return type == BuiltinOptions_ConcatenationOptions
               ? reinterpret_cast<const ConcatenationOptionsT *>(value)
               : nullptr;
  }
  AddOptionsT *AsAddOptions() {
    return type == BuiltinOptions_AddOptions
               ? reinterpret_cast<AddOptionsT *>(value)
               : nullptr;
  }
  const AddOptionsT *AsAddOptions() const {
    return type == BuiltinOptions_AddOptions
               ? reinterpret_cast<const AddOptionsT *>(value)
               : nullptr;
  }
  L2NormOptionsT *AsL2NormOptions() {
    return type == BuiltinOptions_L2NormOptions
               ? reinterpret_cast<L2NormOptionsT *>(value)
               : nullptr;
  }
  const L2NormOptionsT *AsL2NormOptions() const {
    return type == BuiltinOptions_L2NormOptions
               ? reinterpret_cast<const L2NormOptionsT *>(value)
               : nullptr;
  }
  LocalResponseNormalizationOptionsT *AsLocalResponseNormalizationOptions() {
    return type == BuiltinOptions_LocalResponseNormalizationOptions
               ? reinterpret_cast<LocalResponseNormalizationOptionsT *>(value)
               : nullptr;
  }
  const LocalResponseNormalizationOptionsT *
  AsLocalResponseNormalizationOptions() const {
    return type == BuiltinOptions_LocalResponseNormalizationOptions
               ? reinterpret_cast<const LocalResponseNormalizationOptionsT *>(
                     value)
               : nullptr;
  }
  LSTMOptionsT *AsLSTMOptions() {
    return type == BuiltinOptions_LSTMOptions
               ? reinterpret_cast<LSTMOptionsT *>(value)
               : nullptr;
  }
  const LSTMOptionsT *AsLSTMOptions() const {
    return type == BuiltinOptions_LSTMOptions
               ? reinterpret_cast<const LSTMOptionsT *>(value)
               : nullptr;
  }
  ResizeBilinearOptionsT *AsResizeBilinearOptions() {
    return type == BuiltinOptions_ResizeBilinearOptions
               ? reinterpret_cast<ResizeBilinearOptionsT *>(value)
               : nullptr;
  }
  const ResizeBilinearOptionsT *AsResizeBilinearOptions() const {
    return type == BuiltinOptions_ResizeBilinearOptions
               ? reinterpret_cast<const ResizeBilinearOptionsT *>(value)
               : nullptr;
  }
  CallOptionsT *AsCallOptions() {
    return type == BuiltinOptions_CallOptions
               ? reinterpret_cast<CallOptionsT *>(value)
               : nullptr;
  }
  const CallOptionsT *AsCallOptions() const {
    return type == BuiltinOptions_CallOptions
               ? reinterpret_cast<const CallOptionsT *>(value)
               : nullptr;
  }
  ReshapeOptionsT *AsReshapeOptions() {
    return type == BuiltinOptions_ReshapeOptions
               ? reinterpret_cast<ReshapeOptionsT *>(value)
               : nullptr;
  }
  const ReshapeOptionsT *AsReshapeOptions() const {
    return type == BuiltinOptions_ReshapeOptions
               ? reinterpret_cast<const ReshapeOptionsT *>(value)
               : nullptr;
  }
  SkipGramOptionsT *AsSkipGramOptions() {
    return type == BuiltinOptions_SkipGramOptions
               ? reinterpret_cast<SkipGramOptionsT *>(value)
               : nullptr;
  }
  const SkipGramOptionsT *AsSkipGramOptions() const {
    return type == BuiltinOptions_SkipGramOptions
               ? reinterpret_cast<const SkipGramOptionsT *>(value)
               : nullptr;
  }
  SpaceToDepthOptionsT *AsSpaceToDepthOptions() {
    return type == BuiltinOptions_SpaceToDepthOptions
               ? reinterpret_cast<SpaceToDepthOptionsT *>(value)
               : nullptr;
  }
  const SpaceToDepthOptionsT *AsSpaceToDepthOptions() const {
    return type == BuiltinOptions_SpaceToDepthOptions
               ? reinterpret_cast<const SpaceToDepthOptionsT *>(value)
               : nullptr;
  }
  EmbeddingLookupSparseOptionsT *AsEmbeddingLookupSparseOptions() {
    return type == BuiltinOptions_EmbeddingLookupSparseOptions
               ? reinterpret_cast<EmbeddingLookupSparseOptionsT *>(value)
               : nullptr;
  }
  const EmbeddingLookupSparseOptionsT *AsEmbeddingLookupSparseOptions() const {
    return type == BuiltinOptions_EmbeddingLookupSparseOptions
               ? reinterpret_cast<const EmbeddingLookupSparseOptionsT *>(value)
               : nullptr;
  }
  MulOptionsT *AsMulOptions() {
    return type == BuiltinOptions_MulOptions
               ? reinterpret_cast<MulOptionsT *>(value)
               : nullptr;
  }
  const MulOptionsT *AsMulOptions() const {
    return type == BuiltinOptions_MulOptions
               ? reinterpret_cast<const MulOptionsT *>(value)
               : nullptr;
  }
  PadOptionsT *AsPadOptions() {
    return type == BuiltinOptions_PadOptions
               ? reinterpret_cast<PadOptionsT *>(value)
               : nullptr;
  }
  const PadOptionsT *AsPadOptions() const {
    return type == BuiltinOptions_PadOptions
               ? reinterpret_cast<const PadOptionsT *>(value)
               : nullptr;
  }
};

bool VerifyBuiltinOptions(flatbuffers::Verifier &verifier, const void *obj,
                          BuiltinOptions type);
bool VerifyBuiltinOptionsVector(
    flatbuffers::Verifier &verifier,
    const flatbuffers::Vector<flatbuffers::Offset<void>> *values,
    const flatbuffers::Vector<uint8_t> *types);

enum Padding {
  Padding_SAME = 0,
  Padding_VALID = 1,
  Padding_MIN = Padding_SAME,
  Padding_MAX = Padding_VALID
};

inline Padding (&EnumValuesPadding())[2] {
  static Padding values[] = {Padding_SAME, Padding_VALID};
  return values;
}

inline const char **EnumNamesPadding() {
  static const char *names[] = {"SAME", "VALID", nullptr};
  return names;
}

inline const char *EnumNamePadding(Padding e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesPadding()[index];
}

enum ActivationFunctionType {
  ActivationFunctionType_NONE = 0,
  ActivationFunctionType_RELU = 1,
  ActivationFunctionType_RELU1 = 2,
  ActivationFunctionType_RELU6 = 3,
  ActivationFunctionType_TANH = 4,
  ActivationFunctionType_SIGN_BIT = 5,
  ActivationFunctionType_MIN = ActivationFunctionType_NONE,
  ActivationFunctionType_MAX = ActivationFunctionType_SIGN_BIT
};

inline ActivationFunctionType (&EnumValuesActivationFunctionType())[6] {
  static ActivationFunctionType values[] = {
      ActivationFunctionType_NONE,  ActivationFunctionType_RELU,
      ActivationFunctionType_RELU1, ActivationFunctionType_RELU6,
      ActivationFunctionType_TANH,  ActivationFunctionType_SIGN_BIT};
  return values;
}

inline const char **EnumNamesActivationFunctionType() {
  static const char *names[] = {"NONE", "RELU",     "RELU1", "RELU6",
                                "TANH", "SIGN_BIT", nullptr};
  return names;
}

inline const char *EnumNameActivationFunctionType(ActivationFunctionType e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesActivationFunctionType()[index];
}

enum LSHProjectionType {
  LSHProjectionType_UNKNOWN = 0,
  LSHProjectionType_SPARSE = 1,
  LSHProjectionType_DENSE = 2,
  LSHProjectionType_MIN = LSHProjectionType_UNKNOWN,
  LSHProjectionType_MAX = LSHProjectionType_DENSE
};

inline LSHProjectionType (&EnumValuesLSHProjectionType())[3] {
  static LSHProjectionType values[] = {LSHProjectionType_UNKNOWN,
                                       LSHProjectionType_SPARSE,
                                       LSHProjectionType_DENSE};
  return values;
}

inline const char **EnumNamesLSHProjectionType() {
  static const char *names[] = {"UNKNOWN", "SPARSE", "DENSE", nullptr};
  return names;
}

inline const char *EnumNameLSHProjectionType(LSHProjectionType e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesLSHProjectionType()[index];
}

enum CombinerType {
  CombinerType_SUM = 0,
  CombinerType_MEAN = 1,
  CombinerType_SQRTN = 2,
  CombinerType_MIN = CombinerType_SUM,
  CombinerType_MAX = CombinerType_SQRTN
};

inline CombinerType (&EnumValuesCombinerType())[3] {
  static CombinerType values[] = {CombinerType_SUM, CombinerType_MEAN,
                                  CombinerType_SQRTN};
  return values;
}

inline const char **EnumNamesCombinerType() {
  static const char *names[] = {"SUM", "MEAN", "SQRTN", nullptr};
  return names;
}

inline const char *EnumNameCombinerType(CombinerType e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesCombinerType()[index];
}

enum CustomOptionsFormat {
  CustomOptionsFormat_FLEXBUFFERS = 0,
  CustomOptionsFormat_MIN = CustomOptionsFormat_FLEXBUFFERS,
  CustomOptionsFormat_MAX = CustomOptionsFormat_FLEXBUFFERS
};

inline CustomOptionsFormat (&EnumValuesCustomOptionsFormat())[1] {
  static CustomOptionsFormat values[] = {CustomOptionsFormat_FLEXBUFFERS};
  return values;
}

inline const char **EnumNamesCustomOptionsFormat() {
  static const char *names[] = {"FLEXBUFFERS", nullptr};
  return names;
}

inline const char *EnumNameCustomOptionsFormat(CustomOptionsFormat e) {
  const size_t index = static_cast<int>(e);
  return EnumNamesCustomOptionsFormat()[index];
}

struct QuantizationParametersT : public flatbuffers::NativeTable {
  typedef QuantizationParameters TableType;
  std::vector<float> min;
  std::vector<float> max;
  std::vector<float> scale;
  std::vector<int64_t> zero_point;
  QuantizationParametersT() {}
};

struct QuantizationParameters FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef QuantizationParametersT NativeTableType;
  enum { VT_MIN = 4, VT_MAX = 6, VT_SCALE = 8, VT_ZERO_POINT = 10 };
  const flatbuffers::Vector<float> *min() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_MIN);
  }
  const flatbuffers::Vector<float> *max() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_MAX);
  }
  const flatbuffers::Vector<float> *scale() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_SCALE);
  }
  const flatbuffers::Vector<int64_t> *zero_point() const {
    return GetPointer<const flatbuffers::Vector<int64_t> *>(VT_ZERO_POINT);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_MIN) &&
           verifier.Verify(min()) && VerifyOffset(verifier, VT_MAX) &&
           verifier.Verify(max()) && VerifyOffset(verifier, VT_SCALE) &&
           verifier.Verify(scale()) && VerifyOffset(verifier, VT_ZERO_POINT) &&
           verifier.Verify(zero_point()) && verifier.EndTable();
  }
  QuantizationParametersT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      QuantizationParametersT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<QuantizationParameters> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const QuantizationParametersT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct QuantizationParametersBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_min(flatbuffers::Offset<flatbuffers::Vector<float>> min) {
    fbb_.AddOffset(QuantizationParameters::VT_MIN, min);
  }
  void add_max(flatbuffers::Offset<flatbuffers::Vector<float>> max) {
    fbb_.AddOffset(QuantizationParameters::VT_MAX, max);
  }
  void add_scale(flatbuffers::Offset<flatbuffers::Vector<float>> scale) {
    fbb_.AddOffset(QuantizationParameters::VT_SCALE, scale);
  }
  void add_zero_point(
      flatbuffers::Offset<flatbuffers::Vector<int64_t>> zero_point) {
    fbb_.AddOffset(QuantizationParameters::VT_ZERO_POINT, zero_point);
  }
  explicit QuantizationParametersBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  QuantizationParametersBuilder &operator=(
      const QuantizationParametersBuilder &);
  flatbuffers::Offset<QuantizationParameters> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<QuantizationParameters>(end);
    return o;
  }
};

inline flatbuffers::Offset<QuantizationParameters> CreateQuantizationParameters(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<float>> min = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> max = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> scale = 0,
    flatbuffers::Offset<flatbuffers::Vector<int64_t>> zero_point = 0) {
  QuantizationParametersBuilder builder_(_fbb);
  builder_.add_zero_point(zero_point);
  builder_.add_scale(scale);
  builder_.add_max(max);
  builder_.add_min(min);
  return builder_.Finish();
}

inline flatbuffers::Offset<QuantizationParameters>
CreateQuantizationParametersDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<float> *min = nullptr,
    const std::vector<float> *max = nullptr,
    const std::vector<float> *scale = nullptr,
    const std::vector<int64_t> *zero_point = nullptr) {
  return tflite::CreateQuantizationParameters(
      _fbb, min ? _fbb.CreateVector<float>(*min) : 0,
      max ? _fbb.CreateVector<float>(*max) : 0,
      scale ? _fbb.CreateVector<float>(*scale) : 0,
      zero_point ? _fbb.CreateVector<int64_t>(*zero_point) : 0);
}

flatbuffers::Offset<QuantizationParameters> CreateQuantizationParameters(
    flatbuffers::FlatBufferBuilder &_fbb, const QuantizationParametersT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct TensorT : public flatbuffers::NativeTable {
  typedef Tensor TableType;
  std::vector<int32_t> shape;
  TensorType type;
  uint32_t buffer;
  std::string name;
  std::unique_ptr<QuantizationParametersT> quantization;
  TensorT() : type(TensorType_FLOAT32), buffer(0) {}
};

struct Tensor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorT NativeTableType;
  enum {
    VT_SHAPE = 4,
    VT_TYPE = 6,
    VT_BUFFER = 8,
    VT_NAME = 10,
    VT_QUANTIZATION = 12
  };
  const flatbuffers::Vector<int32_t> *shape() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_SHAPE);
  }
  TensorType type() const {
    return static_cast<TensorType>(GetField<int8_t>(VT_TYPE, 0));
  }
  uint32_t buffer() const { return GetField<uint32_t>(VT_BUFFER, 0); }
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const QuantizationParameters *quantization() const {
    return GetPointer<const QuantizationParameters *>(VT_QUANTIZATION);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_SHAPE) &&
           verifier.Verify(shape()) && VerifyField<int8_t>(verifier, VT_TYPE) &&
           VerifyField<uint32_t>(verifier, VT_BUFFER) &&
           VerifyOffset(verifier, VT_NAME) && verifier.Verify(name()) &&
           VerifyOffset(verifier, VT_QUANTIZATION) &&
           verifier.VerifyTable(quantization()) && verifier.EndTable();
  }
  TensorT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(TensorT *_o, const flatbuffers::resolver_function_t *_resolver =
                                 nullptr) const;
  static flatbuffers::Offset<Tensor> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const TensorT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct TensorBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_shape(flatbuffers::Offset<flatbuffers::Vector<int32_t>> shape) {
    fbb_.AddOffset(Tensor::VT_SHAPE, shape);
  }
  void add_type(TensorType type) {
    fbb_.AddElement<int8_t>(Tensor::VT_TYPE, static_cast<int8_t>(type), 0);
  }
  void add_buffer(uint32_t buffer) {
    fbb_.AddElement<uint32_t>(Tensor::VT_BUFFER, buffer, 0);
  }
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(Tensor::VT_NAME, name);
  }
  void add_quantization(
      flatbuffers::Offset<QuantizationParameters> quantization) {
    fbb_.AddOffset(Tensor::VT_QUANTIZATION, quantization);
  }
  explicit TensorBuilder(flatbuffers::FlatBufferBuilder &_fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  TensorBuilder &operator=(const TensorBuilder &);
  flatbuffers::Offset<Tensor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Tensor>(end);
    return o;
  }
};

inline flatbuffers::Offset<Tensor> CreateTensor(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> shape = 0,
    TensorType type = TensorType_FLOAT32, uint32_t buffer = 0,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<QuantizationParameters> quantization = 0) {
  TensorBuilder builder_(_fbb);
  builder_.add_quantization(quantization);
  builder_.add_name(name);
  builder_.add_buffer(buffer);
  builder_.add_shape(shape);
  builder_.add_type(type);
  return builder_.Finish();
}

inline flatbuffers::Offset<Tensor> CreateTensorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<int32_t> *shape = nullptr,
    TensorType type = TensorType_FLOAT32, uint32_t buffer = 0,
    const char *name = nullptr,
    flatbuffers::Offset<QuantizationParameters> quantization = 0) {
  return tflite::CreateTensor(
      _fbb, shape ? _fbb.CreateVector<int32_t>(*shape) : 0, type, buffer,
      name ? _fbb.CreateString(name) : 0, quantization);
}

flatbuffers::Offset<Tensor> CreateTensor(
    flatbuffers::FlatBufferBuilder &_fbb, const TensorT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct Conv2DOptionsT : public flatbuffers::NativeTable {
  typedef Conv2DOptions TableType;
  Padding padding;
  int32_t stride_w;
  int32_t stride_h;
  ActivationFunctionType fused_activation_function;
  Conv2DOptionsT()
      : padding(Padding_SAME),
        stride_w(0),
        stride_h(0),
        fused_activation_function(ActivationFunctionType_NONE) {}
};

struct Conv2DOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Conv2DOptionsT NativeTableType;
  enum {
    VT_PADDING = 4,
    VT_STRIDE_W = 6,
    VT_STRIDE_H = 8,
    VT_FUSED_ACTIVATION_FUNCTION = 10
  };
  Padding padding() const {
    return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
  }
  int32_t stride_w() const { return GetField<int32_t>(VT_STRIDE_W, 0); }
  int32_t stride_h() const { return GetField<int32_t>(VT_STRIDE_H, 0); }
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_PADDING) &&
           VerifyField<int32_t>(verifier, VT_STRIDE_W) &&
           VerifyField<int32_t>(verifier, VT_STRIDE_H) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  Conv2DOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      Conv2DOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Conv2DOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const Conv2DOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct Conv2DOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_padding(Padding padding) {
    fbb_.AddElement<int8_t>(Conv2DOptions::VT_PADDING,
                            static_cast<int8_t>(padding), 0);
  }
  void add_stride_w(int32_t stride_w) {
    fbb_.AddElement<int32_t>(Conv2DOptions::VT_STRIDE_W, stride_w, 0);
  }
  void add_stride_h(int32_t stride_h) {
    fbb_.AddElement<int32_t>(Conv2DOptions::VT_STRIDE_H, stride_h, 0);
  }
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(Conv2DOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit Conv2DOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Conv2DOptionsBuilder &operator=(const Conv2DOptionsBuilder &);
  flatbuffers::Offset<Conv2DOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Conv2DOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<Conv2DOptions> CreateConv2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, Padding padding = Padding_SAME,
    int32_t stride_w = 0, int32_t stride_h = 0,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  Conv2DOptionsBuilder builder_(_fbb);
  builder_.add_stride_h(stride_h);
  builder_.add_stride_w(stride_w);
  builder_.add_fused_activation_function(fused_activation_function);
  builder_.add_padding(padding);
  return builder_.Finish();
}

flatbuffers::Offset<Conv2DOptions> CreateConv2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const Conv2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct Pool2DOptionsT : public flatbuffers::NativeTable {
  typedef Pool2DOptions TableType;
  Padding padding;
  int32_t stride_w;
  int32_t stride_h;
  int32_t filter_width;
  int32_t filter_height;
  ActivationFunctionType fused_activation_function;
  Pool2DOptionsT()
      : padding(Padding_SAME),
        stride_w(0),
        stride_h(0),
        filter_width(0),
        filter_height(0),
        fused_activation_function(ActivationFunctionType_NONE) {}
};

struct Pool2DOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Pool2DOptionsT NativeTableType;
  enum {
    VT_PADDING = 4,
    VT_STRIDE_W = 6,
    VT_STRIDE_H = 8,
    VT_FILTER_WIDTH = 10,
    VT_FILTER_HEIGHT = 12,
    VT_FUSED_ACTIVATION_FUNCTION = 14
  };
  Padding padding() const {
    return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
  }
  int32_t stride_w() const { return GetField<int32_t>(VT_STRIDE_W, 0); }
  int32_t stride_h() const { return GetField<int32_t>(VT_STRIDE_H, 0); }
  int32_t filter_width() const { return GetField<int32_t>(VT_FILTER_WIDTH, 0); }
  int32_t filter_height() const {
    return GetField<int32_t>(VT_FILTER_HEIGHT, 0);
  }
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_PADDING) &&
           VerifyField<int32_t>(verifier, VT_STRIDE_W) &&
           VerifyField<int32_t>(verifier, VT_STRIDE_H) &&
           VerifyField<int32_t>(verifier, VT_FILTER_WIDTH) &&
           VerifyField<int32_t>(verifier, VT_FILTER_HEIGHT) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  Pool2DOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      Pool2DOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Pool2DOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const Pool2DOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct Pool2DOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_padding(Padding padding) {
    fbb_.AddElement<int8_t>(Pool2DOptions::VT_PADDING,
                            static_cast<int8_t>(padding), 0);
  }
  void add_stride_w(int32_t stride_w) {
    fbb_.AddElement<int32_t>(Pool2DOptions::VT_STRIDE_W, stride_w, 0);
  }
  void add_stride_h(int32_t stride_h) {
    fbb_.AddElement<int32_t>(Pool2DOptions::VT_STRIDE_H, stride_h, 0);
  }
  void add_filter_width(int32_t filter_width) {
    fbb_.AddElement<int32_t>(Pool2DOptions::VT_FILTER_WIDTH, filter_width, 0);
  }
  void add_filter_height(int32_t filter_height) {
    fbb_.AddElement<int32_t>(Pool2DOptions::VT_FILTER_HEIGHT, filter_height, 0);
  }
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(Pool2DOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit Pool2DOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Pool2DOptionsBuilder &operator=(const Pool2DOptionsBuilder &);
  flatbuffers::Offset<Pool2DOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Pool2DOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<Pool2DOptions> CreatePool2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, Padding padding = Padding_SAME,
    int32_t stride_w = 0, int32_t stride_h = 0, int32_t filter_width = 0,
    int32_t filter_height = 0,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  Pool2DOptionsBuilder builder_(_fbb);
  builder_.add_filter_height(filter_height);
  builder_.add_filter_width(filter_width);
  builder_.add_stride_h(stride_h);
  builder_.add_stride_w(stride_w);
  builder_.add_fused_activation_function(fused_activation_function);
  builder_.add_padding(padding);
  return builder_.Finish();
}

flatbuffers::Offset<Pool2DOptions> CreatePool2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const Pool2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct DepthwiseConv2DOptionsT : public flatbuffers::NativeTable {
  typedef DepthwiseConv2DOptions TableType;
  Padding padding;
  int32_t stride_w;
  int32_t stride_h;
  int32_t depth_multiplier;
  ActivationFunctionType fused_activation_function;
  DepthwiseConv2DOptionsT()
      : padding(Padding_SAME),
        stride_w(0),
        stride_h(0),
        depth_multiplier(0),
        fused_activation_function(ActivationFunctionType_NONE) {}
};

struct DepthwiseConv2DOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef DepthwiseConv2DOptionsT NativeTableType;
  enum {
    VT_PADDING = 4,
    VT_STRIDE_W = 6,
    VT_STRIDE_H = 8,
    VT_DEPTH_MULTIPLIER = 10,
    VT_FUSED_ACTIVATION_FUNCTION = 12
  };
  Padding padding() const {
    return static_cast<Padding>(GetField<int8_t>(VT_PADDING, 0));
  }
  int32_t stride_w() const { return GetField<int32_t>(VT_STRIDE_W, 0); }
  int32_t stride_h() const { return GetField<int32_t>(VT_STRIDE_H, 0); }
  int32_t depth_multiplier() const {
    return GetField<int32_t>(VT_DEPTH_MULTIPLIER, 0);
  }
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_PADDING) &&
           VerifyField<int32_t>(verifier, VT_STRIDE_W) &&
           VerifyField<int32_t>(verifier, VT_STRIDE_H) &&
           VerifyField<int32_t>(verifier, VT_DEPTH_MULTIPLIER) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  DepthwiseConv2DOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      DepthwiseConv2DOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<DepthwiseConv2DOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const DepthwiseConv2DOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct DepthwiseConv2DOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_padding(Padding padding) {
    fbb_.AddElement<int8_t>(DepthwiseConv2DOptions::VT_PADDING,
                            static_cast<int8_t>(padding), 0);
  }
  void add_stride_w(int32_t stride_w) {
    fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_STRIDE_W, stride_w, 0);
  }
  void add_stride_h(int32_t stride_h) {
    fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_STRIDE_H, stride_h, 0);
  }
  void add_depth_multiplier(int32_t depth_multiplier) {
    fbb_.AddElement<int32_t>(DepthwiseConv2DOptions::VT_DEPTH_MULTIPLIER,
                             depth_multiplier, 0);
  }
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(
        DepthwiseConv2DOptions::VT_FUSED_ACTIVATION_FUNCTION,
        static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit DepthwiseConv2DOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  DepthwiseConv2DOptionsBuilder &operator=(
      const DepthwiseConv2DOptionsBuilder &);
  flatbuffers::Offset<DepthwiseConv2DOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<DepthwiseConv2DOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<DepthwiseConv2DOptions> CreateDepthwiseConv2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, Padding padding = Padding_SAME,
    int32_t stride_w = 0, int32_t stride_h = 0, int32_t depth_multiplier = 0,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  DepthwiseConv2DOptionsBuilder builder_(_fbb);
  builder_.add_depth_multiplier(depth_multiplier);
  builder_.add_stride_h(stride_h);
  builder_.add_stride_w(stride_w);
  builder_.add_fused_activation_function(fused_activation_function);
  builder_.add_padding(padding);
  return builder_.Finish();
}

flatbuffers::Offset<DepthwiseConv2DOptions> CreateDepthwiseConv2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const DepthwiseConv2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ConcatEmbeddingsOptionsT : public flatbuffers::NativeTable {
  typedef ConcatEmbeddingsOptions TableType;
  int32_t num_channels;
  std::vector<int32_t> num_columns_per_channel;
  std::vector<int32_t> embedding_dim_per_channel;
  ConcatEmbeddingsOptionsT() : num_channels(0) {}
};

struct ConcatEmbeddingsOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef ConcatEmbeddingsOptionsT NativeTableType;
  enum {
    VT_NUM_CHANNELS = 4,
    VT_NUM_COLUMNS_PER_CHANNEL = 6,
    VT_EMBEDDING_DIM_PER_CHANNEL = 8
  };
  int32_t num_channels() const { return GetField<int32_t>(VT_NUM_CHANNELS, 0); }
  const flatbuffers::Vector<int32_t> *num_columns_per_channel() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(
        VT_NUM_COLUMNS_PER_CHANNEL);
  }
  const flatbuffers::Vector<int32_t> *embedding_dim_per_channel() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(
        VT_EMBEDDING_DIM_PER_CHANNEL);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_NUM_CHANNELS) &&
           VerifyOffset(verifier, VT_NUM_COLUMNS_PER_CHANNEL) &&
           verifier.Verify(num_columns_per_channel()) &&
           VerifyOffset(verifier, VT_EMBEDDING_DIM_PER_CHANNEL) &&
           verifier.Verify(embedding_dim_per_channel()) && verifier.EndTable();
  }
  ConcatEmbeddingsOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      ConcatEmbeddingsOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ConcatEmbeddingsOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const ConcatEmbeddingsOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ConcatEmbeddingsOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_num_channels(int32_t num_channels) {
    fbb_.AddElement<int32_t>(ConcatEmbeddingsOptions::VT_NUM_CHANNELS,
                             num_channels, 0);
  }
  void add_num_columns_per_channel(
      flatbuffers::Offset<flatbuffers::Vector<int32_t>>
          num_columns_per_channel) {
    fbb_.AddOffset(ConcatEmbeddingsOptions::VT_NUM_COLUMNS_PER_CHANNEL,
                   num_columns_per_channel);
  }
  void add_embedding_dim_per_channel(
      flatbuffers::Offset<flatbuffers::Vector<int32_t>>
          embedding_dim_per_channel) {
    fbb_.AddOffset(ConcatEmbeddingsOptions::VT_EMBEDDING_DIM_PER_CHANNEL,
                   embedding_dim_per_channel);
  }
  explicit ConcatEmbeddingsOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ConcatEmbeddingsOptionsBuilder &operator=(
      const ConcatEmbeddingsOptionsBuilder &);
  flatbuffers::Offset<ConcatEmbeddingsOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ConcatEmbeddingsOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<ConcatEmbeddingsOptions>
CreateConcatEmbeddingsOptions(flatbuffers::FlatBufferBuilder &_fbb,
                              int32_t num_channels = 0,
                              flatbuffers::Offset<flatbuffers::Vector<int32_t>>
                                  num_columns_per_channel = 0,
                              flatbuffers::Offset<flatbuffers::Vector<int32_t>>
                                  embedding_dim_per_channel = 0) {
  ConcatEmbeddingsOptionsBuilder builder_(_fbb);
  builder_.add_embedding_dim_per_channel(embedding_dim_per_channel);
  builder_.add_num_columns_per_channel(num_columns_per_channel);
  builder_.add_num_channels(num_channels);
  return builder_.Finish();
}

inline flatbuffers::Offset<ConcatEmbeddingsOptions>
CreateConcatEmbeddingsOptionsDirect(
    flatbuffers::FlatBufferBuilder &_fbb, int32_t num_channels = 0,
    const std::vector<int32_t> *num_columns_per_channel = nullptr,
    const std::vector<int32_t> *embedding_dim_per_channel = nullptr) {
  return tflite::CreateConcatEmbeddingsOptions(
      _fbb, num_channels,
      num_columns_per_channel
          ? _fbb.CreateVector<int32_t>(*num_columns_per_channel)
          : 0,
      embedding_dim_per_channel
          ? _fbb.CreateVector<int32_t>(*embedding_dim_per_channel)
          : 0);
}

flatbuffers::Offset<ConcatEmbeddingsOptions> CreateConcatEmbeddingsOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ConcatEmbeddingsOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct LSHProjectionOptionsT : public flatbuffers::NativeTable {
  typedef LSHProjectionOptions TableType;
  LSHProjectionType type;
  LSHProjectionOptionsT() : type(LSHProjectionType_UNKNOWN) {}
};

struct LSHProjectionOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef LSHProjectionOptionsT NativeTableType;
  enum { VT_TYPE = 4 };
  LSHProjectionType type() const {
    return static_cast<LSHProjectionType>(GetField<int8_t>(VT_TYPE, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_TYPE) && verifier.EndTable();
  }
  LSHProjectionOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      LSHProjectionOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<LSHProjectionOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const LSHProjectionOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct LSHProjectionOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_type(LSHProjectionType type) {
    fbb_.AddElement<int8_t>(LSHProjectionOptions::VT_TYPE,
                            static_cast<int8_t>(type), 0);
  }
  explicit LSHProjectionOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  LSHProjectionOptionsBuilder &operator=(const LSHProjectionOptionsBuilder &);
  flatbuffers::Offset<LSHProjectionOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<LSHProjectionOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<LSHProjectionOptions> CreateLSHProjectionOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    LSHProjectionType type = LSHProjectionType_UNKNOWN) {
  LSHProjectionOptionsBuilder builder_(_fbb);
  builder_.add_type(type);
  return builder_.Finish();
}

flatbuffers::Offset<LSHProjectionOptions> CreateLSHProjectionOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const LSHProjectionOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct SVDFOptionsT : public flatbuffers::NativeTable {
  typedef SVDFOptions TableType;
  int32_t rank;
  ActivationFunctionType fused_activation_function;
  SVDFOptionsT()
      : rank(0), fused_activation_function(ActivationFunctionType_NONE) {}
};

struct SVDFOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef SVDFOptionsT NativeTableType;
  enum { VT_RANK = 4, VT_FUSED_ACTIVATION_FUNCTION = 6 };
  int32_t rank() const { return GetField<int32_t>(VT_RANK, 0); }
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_RANK) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  SVDFOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      SVDFOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<SVDFOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const SVDFOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct SVDFOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_rank(int32_t rank) {
    fbb_.AddElement<int32_t>(SVDFOptions::VT_RANK, rank, 0);
  }
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(SVDFOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit SVDFOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  SVDFOptionsBuilder &operator=(const SVDFOptionsBuilder &);
  flatbuffers::Offset<SVDFOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SVDFOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<SVDFOptions> CreateSVDFOptions(
    flatbuffers::FlatBufferBuilder &_fbb, int32_t rank = 0,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  SVDFOptionsBuilder builder_(_fbb);
  builder_.add_rank(rank);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<SVDFOptions> CreateSVDFOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SVDFOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct RNNOptionsT : public flatbuffers::NativeTable {
  typedef RNNOptions TableType;
  ActivationFunctionType fused_activation_function;
  RNNOptionsT() : fused_activation_function(ActivationFunctionType_NONE) {}
};

struct RNNOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef RNNOptionsT NativeTableType;
  enum { VT_FUSED_ACTIVATION_FUNCTION = 4 };
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  RNNOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      RNNOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<RNNOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const RNNOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct RNNOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(RNNOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit RNNOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  RNNOptionsBuilder &operator=(const RNNOptionsBuilder &);
  flatbuffers::Offset<RNNOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<RNNOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<RNNOptions> CreateRNNOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  RNNOptionsBuilder builder_(_fbb);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<RNNOptions> CreateRNNOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const RNNOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct FullyConnectedOptionsT : public flatbuffers::NativeTable {
  typedef FullyConnectedOptions TableType;
  ActivationFunctionType fused_activation_function;
  FullyConnectedOptionsT()
      : fused_activation_function(ActivationFunctionType_NONE) {}
};

struct FullyConnectedOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef FullyConnectedOptionsT NativeTableType;
  enum { VT_FUSED_ACTIVATION_FUNCTION = 4 };
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  FullyConnectedOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      FullyConnectedOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<FullyConnectedOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const FullyConnectedOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct FullyConnectedOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(FullyConnectedOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit FullyConnectedOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  FullyConnectedOptionsBuilder &operator=(const FullyConnectedOptionsBuilder &);
  flatbuffers::Offset<FullyConnectedOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<FullyConnectedOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<FullyConnectedOptions> CreateFullyConnectedOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  FullyConnectedOptionsBuilder builder_(_fbb);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<FullyConnectedOptions> CreateFullyConnectedOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const FullyConnectedOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct SoftmaxOptionsT : public flatbuffers::NativeTable {
  typedef SoftmaxOptions TableType;
  float beta;
  SoftmaxOptionsT() : beta(0.0f) {}
};

struct SoftmaxOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef SoftmaxOptionsT NativeTableType;
  enum { VT_BETA = 4 };
  float beta() const { return GetField<float>(VT_BETA, 0.0f); }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<float>(verifier, VT_BETA) && verifier.EndTable();
  }
  SoftmaxOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      SoftmaxOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<SoftmaxOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const SoftmaxOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct SoftmaxOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_beta(float beta) {
    fbb_.AddElement<float>(SoftmaxOptions::VT_BETA, beta, 0.0f);
  }
  explicit SoftmaxOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  SoftmaxOptionsBuilder &operator=(const SoftmaxOptionsBuilder &);
  flatbuffers::Offset<SoftmaxOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SoftmaxOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<SoftmaxOptions> CreateSoftmaxOptions(
    flatbuffers::FlatBufferBuilder &_fbb, float beta = 0.0f) {
  SoftmaxOptionsBuilder builder_(_fbb);
  builder_.add_beta(beta);
  return builder_.Finish();
}

flatbuffers::Offset<SoftmaxOptions> CreateSoftmaxOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SoftmaxOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ConcatenationOptionsT : public flatbuffers::NativeTable {
  typedef ConcatenationOptions TableType;
  int32_t axis;
  ActivationFunctionType fused_activation_function;
  ConcatenationOptionsT()
      : axis(0), fused_activation_function(ActivationFunctionType_NONE) {}
};

struct ConcatenationOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef ConcatenationOptionsT NativeTableType;
  enum { VT_AXIS = 4, VT_FUSED_ACTIVATION_FUNCTION = 6 };
  int32_t axis() const { return GetField<int32_t>(VT_AXIS, 0); }
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_AXIS) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  ConcatenationOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      ConcatenationOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ConcatenationOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const ConcatenationOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ConcatenationOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_axis(int32_t axis) {
    fbb_.AddElement<int32_t>(ConcatenationOptions::VT_AXIS, axis, 0);
  }
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(ConcatenationOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit ConcatenationOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ConcatenationOptionsBuilder &operator=(const ConcatenationOptionsBuilder &);
  flatbuffers::Offset<ConcatenationOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ConcatenationOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<ConcatenationOptions> CreateConcatenationOptions(
    flatbuffers::FlatBufferBuilder &_fbb, int32_t axis = 0,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  ConcatenationOptionsBuilder builder_(_fbb);
  builder_.add_axis(axis);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<ConcatenationOptions> CreateConcatenationOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ConcatenationOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct AddOptionsT : public flatbuffers::NativeTable {
  typedef AddOptions TableType;
  ActivationFunctionType fused_activation_function;
  AddOptionsT() : fused_activation_function(ActivationFunctionType_NONE) {}
};

struct AddOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef AddOptionsT NativeTableType;
  enum { VT_FUSED_ACTIVATION_FUNCTION = 4 };
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  AddOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      AddOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<AddOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const AddOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct AddOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(AddOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit AddOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  AddOptionsBuilder &operator=(const AddOptionsBuilder &);
  flatbuffers::Offset<AddOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<AddOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<AddOptions> CreateAddOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  AddOptionsBuilder builder_(_fbb);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<AddOptions> CreateAddOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const AddOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct MulOptionsT : public flatbuffers::NativeTable {
  typedef MulOptions TableType;
  ActivationFunctionType fused_activation_function;
  MulOptionsT() : fused_activation_function(ActivationFunctionType_NONE) {}
};

struct MulOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef MulOptionsT NativeTableType;
  enum { VT_FUSED_ACTIVATION_FUNCTION = 4 };
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  MulOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      MulOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<MulOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const MulOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct MulOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(MulOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit MulOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  MulOptionsBuilder &operator=(const MulOptionsBuilder &);
  flatbuffers::Offset<MulOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<MulOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<MulOptions> CreateMulOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  MulOptionsBuilder builder_(_fbb);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<MulOptions> CreateMulOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const MulOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct L2NormOptionsT : public flatbuffers::NativeTable {
  typedef L2NormOptions TableType;
  ActivationFunctionType fused_activation_function;
  L2NormOptionsT() : fused_activation_function(ActivationFunctionType_NONE) {}
};

struct L2NormOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef L2NormOptionsT NativeTableType;
  enum { VT_FUSED_ACTIVATION_FUNCTION = 4 };
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           verifier.EndTable();
  }
  L2NormOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      L2NormOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<L2NormOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const L2NormOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct L2NormOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(L2NormOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  explicit L2NormOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  L2NormOptionsBuilder &operator=(const L2NormOptionsBuilder &);
  flatbuffers::Offset<L2NormOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<L2NormOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<L2NormOptions> CreateL2NormOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE) {
  L2NormOptionsBuilder builder_(_fbb);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<L2NormOptions> CreateL2NormOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const L2NormOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct LocalResponseNormalizationOptionsT : public flatbuffers::NativeTable {
  typedef LocalResponseNormalizationOptions TableType;
  int32_t radius;
  float bias;
  float alpha;
  float beta;
  LocalResponseNormalizationOptionsT()
      : radius(0), bias(0.0f), alpha(0.0f), beta(0.0f) {}
};

struct LocalResponseNormalizationOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef LocalResponseNormalizationOptionsT NativeTableType;
  enum { VT_RADIUS = 4, VT_BIAS = 6, VT_ALPHA = 8, VT_BETA = 10 };
  int32_t radius() const { return GetField<int32_t>(VT_RADIUS, 0); }
  float bias() const { return GetField<float>(VT_BIAS, 0.0f); }
  float alpha() const { return GetField<float>(VT_ALPHA, 0.0f); }
  float beta() const { return GetField<float>(VT_BETA, 0.0f); }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_RADIUS) &&
           VerifyField<float>(verifier, VT_BIAS) &&
           VerifyField<float>(verifier, VT_ALPHA) &&
           VerifyField<float>(verifier, VT_BETA) && verifier.EndTable();
  }
  LocalResponseNormalizationOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      LocalResponseNormalizationOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<LocalResponseNormalizationOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb,
      const LocalResponseNormalizationOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct LocalResponseNormalizationOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_radius(int32_t radius) {
    fbb_.AddElement<int32_t>(LocalResponseNormalizationOptions::VT_RADIUS,
                             radius, 0);
  }
  void add_bias(float bias) {
    fbb_.AddElement<float>(LocalResponseNormalizationOptions::VT_BIAS, bias,
                           0.0f);
  }
  void add_alpha(float alpha) {
    fbb_.AddElement<float>(LocalResponseNormalizationOptions::VT_ALPHA, alpha,
                           0.0f);
  }
  void add_beta(float beta) {
    fbb_.AddElement<float>(LocalResponseNormalizationOptions::VT_BETA, beta,
                           0.0f);
  }
  explicit LocalResponseNormalizationOptionsBuilder(
      flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  LocalResponseNormalizationOptionsBuilder &operator=(
      const LocalResponseNormalizationOptionsBuilder &);
  flatbuffers::Offset<LocalResponseNormalizationOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<LocalResponseNormalizationOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<LocalResponseNormalizationOptions>
CreateLocalResponseNormalizationOptions(flatbuffers::FlatBufferBuilder &_fbb,
                                        int32_t radius = 0, float bias = 0.0f,
                                        float alpha = 0.0f, float beta = 0.0f) {
  LocalResponseNormalizationOptionsBuilder builder_(_fbb);
  builder_.add_beta(beta);
  builder_.add_alpha(alpha);
  builder_.add_bias(bias);
  builder_.add_radius(radius);
  return builder_.Finish();
}

flatbuffers::Offset<LocalResponseNormalizationOptions>
CreateLocalResponseNormalizationOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    const LocalResponseNormalizationOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct LSTMOptionsT : public flatbuffers::NativeTable {
  typedef LSTMOptions TableType;
  ActivationFunctionType fused_activation_function;
  float cell_clip;
  float proj_clip;
  LSTMOptionsT()
      : fused_activation_function(ActivationFunctionType_NONE),
        cell_clip(0.0f),
        proj_clip(0.0f) {}
};

struct LSTMOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef LSTMOptionsT NativeTableType;
  enum { VT_FUSED_ACTIVATION_FUNCTION = 4, VT_CELL_CLIP = 6, VT_PROJ_CLIP = 8 };
  ActivationFunctionType fused_activation_function() const {
    return static_cast<ActivationFunctionType>(
        GetField<int8_t>(VT_FUSED_ACTIVATION_FUNCTION, 0));
  }
  float cell_clip() const { return GetField<float>(VT_CELL_CLIP, 0.0f); }
  float proj_clip() const { return GetField<float>(VT_PROJ_CLIP, 0.0f); }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_FUSED_ACTIVATION_FUNCTION) &&
           VerifyField<float>(verifier, VT_CELL_CLIP) &&
           VerifyField<float>(verifier, VT_PROJ_CLIP) && verifier.EndTable();
  }
  LSTMOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      LSTMOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<LSTMOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const LSTMOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct LSTMOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_fused_activation_function(
      ActivationFunctionType fused_activation_function) {
    fbb_.AddElement<int8_t>(LSTMOptions::VT_FUSED_ACTIVATION_FUNCTION,
                            static_cast<int8_t>(fused_activation_function), 0);
  }
  void add_cell_clip(float cell_clip) {
    fbb_.AddElement<float>(LSTMOptions::VT_CELL_CLIP, cell_clip, 0.0f);
  }
  void add_proj_clip(float proj_clip) {
    fbb_.AddElement<float>(LSTMOptions::VT_PROJ_CLIP, proj_clip, 0.0f);
  }
  explicit LSTMOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  LSTMOptionsBuilder &operator=(const LSTMOptionsBuilder &);
  flatbuffers::Offset<LSTMOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<LSTMOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<LSTMOptions> CreateLSTMOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    ActivationFunctionType fused_activation_function =
        ActivationFunctionType_NONE,
    float cell_clip = 0.0f, float proj_clip = 0.0f) {
  LSTMOptionsBuilder builder_(_fbb);
  builder_.add_proj_clip(proj_clip);
  builder_.add_cell_clip(cell_clip);
  builder_.add_fused_activation_function(fused_activation_function);
  return builder_.Finish();
}

flatbuffers::Offset<LSTMOptions> CreateLSTMOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const LSTMOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ResizeBilinearOptionsT : public flatbuffers::NativeTable {
  typedef ResizeBilinearOptions TableType;
  int32_t new_height;
  int32_t new_width;
  ResizeBilinearOptionsT() : new_height(0), new_width(0) {}
};

struct ResizeBilinearOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef ResizeBilinearOptionsT NativeTableType;
  enum { VT_NEW_HEIGHT = 4, VT_NEW_WIDTH = 6 };
  int32_t new_height() const { return GetField<int32_t>(VT_NEW_HEIGHT, 0); }
  int32_t new_width() const { return GetField<int32_t>(VT_NEW_WIDTH, 0); }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_NEW_HEIGHT) &&
           VerifyField<int32_t>(verifier, VT_NEW_WIDTH) && verifier.EndTable();
  }
  ResizeBilinearOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      ResizeBilinearOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ResizeBilinearOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const ResizeBilinearOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ResizeBilinearOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_new_height(int32_t new_height) {
    fbb_.AddElement<int32_t>(ResizeBilinearOptions::VT_NEW_HEIGHT, new_height,
                             0);
  }
  void add_new_width(int32_t new_width) {
    fbb_.AddElement<int32_t>(ResizeBilinearOptions::VT_NEW_WIDTH, new_width, 0);
  }
  explicit ResizeBilinearOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ResizeBilinearOptionsBuilder &operator=(const ResizeBilinearOptionsBuilder &);
  flatbuffers::Offset<ResizeBilinearOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ResizeBilinearOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<ResizeBilinearOptions> CreateResizeBilinearOptions(
    flatbuffers::FlatBufferBuilder &_fbb, int32_t new_height = 0,
    int32_t new_width = 0) {
  ResizeBilinearOptionsBuilder builder_(_fbb);
  builder_.add_new_width(new_width);
  builder_.add_new_height(new_height);
  return builder_.Finish();
}

flatbuffers::Offset<ResizeBilinearOptions> CreateResizeBilinearOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ResizeBilinearOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct CallOptionsT : public flatbuffers::NativeTable {
  typedef CallOptions TableType;
  uint32_t subgraph;
  CallOptionsT() : subgraph(0) {}
};

struct CallOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef CallOptionsT NativeTableType;
  enum { VT_SUBGRAPH = 4 };
  uint32_t subgraph() const { return GetField<uint32_t>(VT_SUBGRAPH, 0); }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint32_t>(verifier, VT_SUBGRAPH) && verifier.EndTable();
  }
  CallOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      CallOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<CallOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const CallOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct CallOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_subgraph(uint32_t subgraph) {
    fbb_.AddElement<uint32_t>(CallOptions::VT_SUBGRAPH, subgraph, 0);
  }
  explicit CallOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  CallOptionsBuilder &operator=(const CallOptionsBuilder &);
  flatbuffers::Offset<CallOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<CallOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<CallOptions> CreateCallOptions(
    flatbuffers::FlatBufferBuilder &_fbb, uint32_t subgraph = 0) {
  CallOptionsBuilder builder_(_fbb);
  builder_.add_subgraph(subgraph);
  return builder_.Finish();
}

flatbuffers::Offset<CallOptions> CreateCallOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const CallOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct PadOptionsT : public flatbuffers::NativeTable {
  typedef PadOptions TableType;
  std::vector<int32_t> before_padding;
  std::vector<int32_t> after_padding;
  PadOptionsT() {}
};

struct PadOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef PadOptionsT NativeTableType;
  enum { VT_BEFORE_PADDING = 4, VT_AFTER_PADDING = 6 };
  const flatbuffers::Vector<int32_t> *before_padding() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_BEFORE_PADDING);
  }
  const flatbuffers::Vector<int32_t> *after_padding() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_AFTER_PADDING);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BEFORE_PADDING) &&
           verifier.Verify(before_padding()) &&
           VerifyOffset(verifier, VT_AFTER_PADDING) &&
           verifier.Verify(after_padding()) && verifier.EndTable();
  }
  PadOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      PadOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<PadOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const PadOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct PadOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_before_padding(
      flatbuffers::Offset<flatbuffers::Vector<int32_t>> before_padding) {
    fbb_.AddOffset(PadOptions::VT_BEFORE_PADDING, before_padding);
  }
  void add_after_padding(
      flatbuffers::Offset<flatbuffers::Vector<int32_t>> after_padding) {
    fbb_.AddOffset(PadOptions::VT_AFTER_PADDING, after_padding);
  }
  explicit PadOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  PadOptionsBuilder &operator=(const PadOptionsBuilder &);
  flatbuffers::Offset<PadOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<PadOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<PadOptions> CreatePadOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> before_padding = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> after_padding = 0) {
  PadOptionsBuilder builder_(_fbb);
  builder_.add_after_padding(after_padding);
  builder_.add_before_padding(before_padding);
  return builder_.Finish();
}

inline flatbuffers::Offset<PadOptions> CreatePadOptionsDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<int32_t> *before_padding = nullptr,
    const std::vector<int32_t> *after_padding = nullptr) {
  return tflite::CreatePadOptions(
      _fbb, before_padding ? _fbb.CreateVector<int32_t>(*before_padding) : 0,
      after_padding ? _fbb.CreateVector<int32_t>(*after_padding) : 0);
}

flatbuffers::Offset<PadOptions> CreatePadOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const PadOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ReshapeOptionsT : public flatbuffers::NativeTable {
  typedef ReshapeOptions TableType;
  std::vector<int32_t> new_shape;
  ReshapeOptionsT() {}
};

struct ReshapeOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ReshapeOptionsT NativeTableType;
  enum { VT_NEW_SHAPE = 4 };
  const flatbuffers::Vector<int32_t> *new_shape() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_NEW_SHAPE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_NEW_SHAPE) &&
           verifier.Verify(new_shape()) && verifier.EndTable();
  }
  ReshapeOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      ReshapeOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<ReshapeOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const ReshapeOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ReshapeOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_new_shape(
      flatbuffers::Offset<flatbuffers::Vector<int32_t>> new_shape) {
    fbb_.AddOffset(ReshapeOptions::VT_NEW_SHAPE, new_shape);
  }
  explicit ReshapeOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ReshapeOptionsBuilder &operator=(const ReshapeOptionsBuilder &);
  flatbuffers::Offset<ReshapeOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ReshapeOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<ReshapeOptions> CreateReshapeOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> new_shape = 0) {
  ReshapeOptionsBuilder builder_(_fbb);
  builder_.add_new_shape(new_shape);
  return builder_.Finish();
}

inline flatbuffers::Offset<ReshapeOptions> CreateReshapeOptionsDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<int32_t> *new_shape = nullptr) {
  return tflite::CreateReshapeOptions(
      _fbb, new_shape ? _fbb.CreateVector<int32_t>(*new_shape) : 0);
}

flatbuffers::Offset<ReshapeOptions> CreateReshapeOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ReshapeOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct SkipGramOptionsT : public flatbuffers::NativeTable {
  typedef SkipGramOptions TableType;
  int32_t ngram_size;
  int32_t max_skip_size;
  bool include_all_ngrams;
  SkipGramOptionsT()
      : ngram_size(0), max_skip_size(0), include_all_ngrams(false) {}
};

struct SkipGramOptions FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef SkipGramOptionsT NativeTableType;
  enum { VT_NGRAM_SIZE = 4, VT_MAX_SKIP_SIZE = 6, VT_INCLUDE_ALL_NGRAMS = 8 };
  int32_t ngram_size() const { return GetField<int32_t>(VT_NGRAM_SIZE, 0); }
  int32_t max_skip_size() const {
    return GetField<int32_t>(VT_MAX_SKIP_SIZE, 0);
  }
  bool include_all_ngrams() const {
    return GetField<uint8_t>(VT_INCLUDE_ALL_NGRAMS, 0) != 0;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_NGRAM_SIZE) &&
           VerifyField<int32_t>(verifier, VT_MAX_SKIP_SIZE) &&
           VerifyField<uint8_t>(verifier, VT_INCLUDE_ALL_NGRAMS) &&
           verifier.EndTable();
  }
  SkipGramOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      SkipGramOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<SkipGramOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const SkipGramOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct SkipGramOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_ngram_size(int32_t ngram_size) {
    fbb_.AddElement<int32_t>(SkipGramOptions::VT_NGRAM_SIZE, ngram_size, 0);
  }
  void add_max_skip_size(int32_t max_skip_size) {
    fbb_.AddElement<int32_t>(SkipGramOptions::VT_MAX_SKIP_SIZE, max_skip_size,
                             0);
  }
  void add_include_all_ngrams(bool include_all_ngrams) {
    fbb_.AddElement<uint8_t>(SkipGramOptions::VT_INCLUDE_ALL_NGRAMS,
                             static_cast<uint8_t>(include_all_ngrams), 0);
  }
  explicit SkipGramOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  SkipGramOptionsBuilder &operator=(const SkipGramOptionsBuilder &);
  flatbuffers::Offset<SkipGramOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SkipGramOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<SkipGramOptions> CreateSkipGramOptions(
    flatbuffers::FlatBufferBuilder &_fbb, int32_t ngram_size = 0,
    int32_t max_skip_size = 0, bool include_all_ngrams = false) {
  SkipGramOptionsBuilder builder_(_fbb);
  builder_.add_max_skip_size(max_skip_size);
  builder_.add_ngram_size(ngram_size);
  builder_.add_include_all_ngrams(include_all_ngrams);
  return builder_.Finish();
}

flatbuffers::Offset<SkipGramOptions> CreateSkipGramOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SkipGramOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct SpaceToDepthOptionsT : public flatbuffers::NativeTable {
  typedef SpaceToDepthOptions TableType;
  int32_t block_size;
  SpaceToDepthOptionsT() : block_size(0) {}
};

struct SpaceToDepthOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef SpaceToDepthOptionsT NativeTableType;
  enum { VT_BLOCK_SIZE = 4 };
  int32_t block_size() const { return GetField<int32_t>(VT_BLOCK_SIZE, 0); }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_BLOCK_SIZE) && verifier.EndTable();
  }
  SpaceToDepthOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      SpaceToDepthOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<SpaceToDepthOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const SpaceToDepthOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct SpaceToDepthOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_block_size(int32_t block_size) {
    fbb_.AddElement<int32_t>(SpaceToDepthOptions::VT_BLOCK_SIZE, block_size, 0);
  }
  explicit SpaceToDepthOptionsBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  SpaceToDepthOptionsBuilder &operator=(const SpaceToDepthOptionsBuilder &);
  flatbuffers::Offset<SpaceToDepthOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SpaceToDepthOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<SpaceToDepthOptions> CreateSpaceToDepthOptions(
    flatbuffers::FlatBufferBuilder &_fbb, int32_t block_size = 0) {
  SpaceToDepthOptionsBuilder builder_(_fbb);
  builder_.add_block_size(block_size);
  return builder_.Finish();
}

flatbuffers::Offset<SpaceToDepthOptions> CreateSpaceToDepthOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SpaceToDepthOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct EmbeddingLookupSparseOptionsT : public flatbuffers::NativeTable {
  typedef EmbeddingLookupSparseOptions TableType;
  CombinerType combiner;
  EmbeddingLookupSparseOptionsT() : combiner(CombinerType_SUM) {}
};

struct EmbeddingLookupSparseOptions FLATBUFFERS_FINAL_CLASS
    : private flatbuffers::Table {
  typedef EmbeddingLookupSparseOptionsT NativeTableType;
  enum { VT_COMBINER = 4 };
  CombinerType combiner() const {
    return static_cast<CombinerType>(GetField<int8_t>(VT_COMBINER, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_COMBINER) && verifier.EndTable();
  }
  EmbeddingLookupSparseOptionsT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      EmbeddingLookupSparseOptionsT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<EmbeddingLookupSparseOptions> Pack(
      flatbuffers::FlatBufferBuilder &_fbb,
      const EmbeddingLookupSparseOptionsT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct EmbeddingLookupSparseOptionsBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_combiner(CombinerType combiner) {
    fbb_.AddElement<int8_t>(EmbeddingLookupSparseOptions::VT_COMBINER,
                            static_cast<int8_t>(combiner), 0);
  }
  explicit EmbeddingLookupSparseOptionsBuilder(
      flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  EmbeddingLookupSparseOptionsBuilder &operator=(
      const EmbeddingLookupSparseOptionsBuilder &);
  flatbuffers::Offset<EmbeddingLookupSparseOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<EmbeddingLookupSparseOptions>(end);
    return o;
  }
};

inline flatbuffers::Offset<EmbeddingLookupSparseOptions>
CreateEmbeddingLookupSparseOptions(flatbuffers::FlatBufferBuilder &_fbb,
                                   CombinerType combiner = CombinerType_SUM) {
  EmbeddingLookupSparseOptionsBuilder builder_(_fbb);
  builder_.add_combiner(combiner);
  return builder_.Finish();
}

flatbuffers::Offset<EmbeddingLookupSparseOptions>
CreateEmbeddingLookupSparseOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    const EmbeddingLookupSparseOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct OperatorCodeT : public flatbuffers::NativeTable {
  typedef OperatorCode TableType;
  BuiltinOperator builtin_code;
  std::string custom_code;
  OperatorCodeT() : builtin_code(BuiltinOperator_ADD) {}
};

struct OperatorCode FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef OperatorCodeT NativeTableType;
  enum { VT_BUILTIN_CODE = 4, VT_CUSTOM_CODE = 6 };
  BuiltinOperator builtin_code() const {
    return static_cast<BuiltinOperator>(GetField<int8_t>(VT_BUILTIN_CODE, 0));
  }
  const flatbuffers::String *custom_code() const {
    return GetPointer<const flatbuffers::String *>(VT_CUSTOM_CODE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_BUILTIN_CODE) &&
           VerifyOffset(verifier, VT_CUSTOM_CODE) &&
           verifier.Verify(custom_code()) && verifier.EndTable();
  }
  OperatorCodeT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      OperatorCodeT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<OperatorCode> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const OperatorCodeT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct OperatorCodeBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_builtin_code(BuiltinOperator builtin_code) {
    fbb_.AddElement<int8_t>(OperatorCode::VT_BUILTIN_CODE,
                            static_cast<int8_t>(builtin_code), 0);
  }
  void add_custom_code(flatbuffers::Offset<flatbuffers::String> custom_code) {
    fbb_.AddOffset(OperatorCode::VT_CUSTOM_CODE, custom_code);
  }
  explicit OperatorCodeBuilder(flatbuffers::FlatBufferBuilder &_fbb)
      : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  OperatorCodeBuilder &operator=(const OperatorCodeBuilder &);
  flatbuffers::Offset<OperatorCode> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<OperatorCode>(end);
    return o;
  }
};

inline flatbuffers::Offset<OperatorCode> CreateOperatorCode(
    flatbuffers::FlatBufferBuilder &_fbb,
    BuiltinOperator builtin_code = BuiltinOperator_ADD,
    flatbuffers::Offset<flatbuffers::String> custom_code = 0) {
  OperatorCodeBuilder builder_(_fbb);
  builder_.add_custom_code(custom_code);
  builder_.add_builtin_code(builtin_code);
  return builder_.Finish();
}

inline flatbuffers::Offset<OperatorCode> CreateOperatorCodeDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    BuiltinOperator builtin_code = BuiltinOperator_ADD,
    const char *custom_code = nullptr) {
  return tflite::CreateOperatorCode(
      _fbb, builtin_code, custom_code ? _fbb.CreateString(custom_code) : 0);
}

flatbuffers::Offset<OperatorCode> CreateOperatorCode(
    flatbuffers::FlatBufferBuilder &_fbb, const OperatorCodeT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct OperatorT : public flatbuffers::NativeTable {
  typedef Operator TableType;
  uint32_t opcode_index;
  std::vector<int32_t> inputs;
  std::vector<int32_t> outputs;
  BuiltinOptionsUnion builtin_options;
  std::vector<uint8_t> custom_options;
  CustomOptionsFormat custom_options_format;
  OperatorT()
      : opcode_index(0),
        custom_options_format(CustomOptionsFormat_FLEXBUFFERS) {}
};

struct Operator FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef OperatorT NativeTableType;
  enum {
    VT_OPCODE_INDEX = 4,
    VT_INPUTS = 6,
    VT_OUTPUTS = 8,
    VT_BUILTIN_OPTIONS_TYPE = 10,
    VT_BUILTIN_OPTIONS = 12,
    VT_CUSTOM_OPTIONS = 14,
    VT_CUSTOM_OPTIONS_FORMAT = 16
  };
  uint32_t opcode_index() const {
    return GetField<uint32_t>(VT_OPCODE_INDEX, 0);
  }
  const flatbuffers::Vector<int32_t> *inputs() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_INPUTS);
  }
  const flatbuffers::Vector<int32_t> *outputs() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_OUTPUTS);
  }
  BuiltinOptions builtin_options_type() const {
    return static_cast<BuiltinOptions>(
        GetField<uint8_t>(VT_BUILTIN_OPTIONS_TYPE, 0));
  }
  const void *builtin_options() const {
    return GetPointer<const void *>(VT_BUILTIN_OPTIONS);
  }
  template <typename T>
  const T *builtin_options_as() const;
  const Conv2DOptions *builtin_options_as_Conv2DOptions() const {
    return builtin_options_type() == BuiltinOptions_Conv2DOptions
               ? static_cast<const Conv2DOptions *>(builtin_options())
               : nullptr;
  }
  const DepthwiseConv2DOptions *builtin_options_as_DepthwiseConv2DOptions()
      const {
    return builtin_options_type() == BuiltinOptions_DepthwiseConv2DOptions
               ? static_cast<const DepthwiseConv2DOptions *>(builtin_options())
               : nullptr;
  }
  const ConcatEmbeddingsOptions *builtin_options_as_ConcatEmbeddingsOptions()
      const {
    return builtin_options_type() == BuiltinOptions_ConcatEmbeddingsOptions
               ? static_cast<const ConcatEmbeddingsOptions *>(builtin_options())
               : nullptr;
  }
  const LSHProjectionOptions *builtin_options_as_LSHProjectionOptions() const {
    return builtin_options_type() == BuiltinOptions_LSHProjectionOptions
               ? static_cast<const LSHProjectionOptions *>(builtin_options())
               : nullptr;
  }
  const Pool2DOptions *builtin_options_as_Pool2DOptions() const {
    return builtin_options_type() == BuiltinOptions_Pool2DOptions
               ? static_cast<const Pool2DOptions *>(builtin_options())
               : nullptr;
  }
  const SVDFOptions *builtin_options_as_SVDFOptions() const {
    return builtin_options_type() == BuiltinOptions_SVDFOptions
               ? static_cast<const SVDFOptions *>(builtin_options())
               : nullptr;
  }
  const RNNOptions *builtin_options_as_RNNOptions() const {
    return builtin_options_type() == BuiltinOptions_RNNOptions
               ? static_cast<const RNNOptions *>(builtin_options())
               : nullptr;
  }
  const FullyConnectedOptions *builtin_options_as_FullyConnectedOptions()
      const {
    return builtin_options_type() == BuiltinOptions_FullyConnectedOptions
               ? static_cast<const FullyConnectedOptions *>(builtin_options())
               : nullptr;
  }
  const SoftmaxOptions *builtin_options_as_SoftmaxOptions() const {
    return builtin_options_type() == BuiltinOptions_SoftmaxOptions
               ? static_cast<const SoftmaxOptions *>(builtin_options())
               : nullptr;
  }
  const ConcatenationOptions *builtin_options_as_ConcatenationOptions() const {
    return builtin_options_type() == BuiltinOptions_ConcatenationOptions
               ? static_cast<const ConcatenationOptions *>(builtin_options())
               : nullptr;
  }
  const AddOptions *builtin_options_as_AddOptions() const {
    return builtin_options_type() == BuiltinOptions_AddOptions
               ? static_cast<const AddOptions *>(builtin_options())
               : nullptr;
  }
  const L2NormOptions *builtin_options_as_L2NormOptions() const {
    return builtin_options_type() == BuiltinOptions_L2NormOptions
               ? static_cast<const L2NormOptions *>(builtin_options())
               : nullptr;
  }
  const LocalResponseNormalizationOptions *
  builtin_options_as_LocalResponseNormalizationOptions() const {
    return builtin_options_type() ==
                   BuiltinOptions_LocalResponseNormalizationOptions
               ? static_cast<const LocalResponseNormalizationOptions *>(
                     builtin_options())
               : nullptr;
  }
  const LSTMOptions *builtin_options_as_LSTMOptions() const {
    return builtin_options_type() == BuiltinOptions_LSTMOptions
               ? static_cast<const LSTMOptions *>(builtin_options())
               : nullptr;
  }
  const ResizeBilinearOptions *builtin_options_as_ResizeBilinearOptions()
      const {
    return builtin_options_type() == BuiltinOptions_ResizeBilinearOptions
               ? static_cast<const ResizeBilinearOptions *>(builtin_options())
               : nullptr;
  }
  const CallOptions *builtin_options_as_CallOptions() const {
    return builtin_options_type() == BuiltinOptions_CallOptions
               ? static_cast<const CallOptions *>(builtin_options())
               : nullptr;
  }
  const ReshapeOptions *builtin_options_as_ReshapeOptions() const {
    return builtin_options_type() == BuiltinOptions_ReshapeOptions
               ? static_cast<const ReshapeOptions *>(builtin_options())
               : nullptr;
  }
  const SkipGramOptions *builtin_options_as_SkipGramOptions() const {
    return builtin_options_type() == BuiltinOptions_SkipGramOptions
               ? static_cast<const SkipGramOptions *>(builtin_options())
               : nullptr;
  }
  const SpaceToDepthOptions *builtin_options_as_SpaceToDepthOptions() const {
    return builtin_options_type() == BuiltinOptions_SpaceToDepthOptions
               ? static_cast<const SpaceToDepthOptions *>(builtin_options())
               : nullptr;
  }
  const EmbeddingLookupSparseOptions *
  builtin_options_as_EmbeddingLookupSparseOptions() const {
    return builtin_options_type() == BuiltinOptions_EmbeddingLookupSparseOptions
               ? static_cast<const EmbeddingLookupSparseOptions *>(
                     builtin_options())
               : nullptr;
  }
  const MulOptions *builtin_options_as_MulOptions() const {
    return builtin_options_type() == BuiltinOptions_MulOptions
               ? static_cast<const MulOptions *>(builtin_options())
               : nullptr;
  }
  const PadOptions *builtin_options_as_PadOptions() const {
    return builtin_options_type() == BuiltinOptions_PadOptions
               ? static_cast<const PadOptions *>(builtin_options())
               : nullptr;
  }
  const flatbuffers::Vector<uint8_t> *custom_options() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_CUSTOM_OPTIONS);
  }
  CustomOptionsFormat custom_options_format() const {
    return static_cast<CustomOptionsFormat>(
        GetField<int8_t>(VT_CUSTOM_OPTIONS_FORMAT, 0));
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint32_t>(verifier, VT_OPCODE_INDEX) &&
           VerifyOffset(verifier, VT_INPUTS) && verifier.Verify(inputs()) &&
           VerifyOffset(verifier, VT_OUTPUTS) && verifier.Verify(outputs()) &&
           VerifyField<uint8_t>(verifier, VT_BUILTIN_OPTIONS_TYPE) &&
           VerifyOffset(verifier, VT_BUILTIN_OPTIONS) &&
           VerifyBuiltinOptions(verifier, builtin_options(),
                                builtin_options_type()) &&
           VerifyOffset(verifier, VT_CUSTOM_OPTIONS) &&
           verifier.Verify(custom_options()) &&
           VerifyField<int8_t>(verifier, VT_CUSTOM_OPTIONS_FORMAT) &&
           verifier.EndTable();
  }
  OperatorT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      OperatorT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<Operator> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const OperatorT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

template <>
inline const Conv2DOptions *Operator::builtin_options_as<Conv2DOptions>()
    const {
  return builtin_options_as_Conv2DOptions();
}

template <>
inline const DepthwiseConv2DOptions *
Operator::builtin_options_as<DepthwiseConv2DOptions>() const {
  return builtin_options_as_DepthwiseConv2DOptions();
}

template <>
inline const ConcatEmbeddingsOptions *
Operator::builtin_options_as<ConcatEmbeddingsOptions>() const {
  return builtin_options_as_ConcatEmbeddingsOptions();
}

template <>
inline const LSHProjectionOptions *
Operator::builtin_options_as<LSHProjectionOptions>() const {
  return builtin_options_as_LSHProjectionOptions();
}

template <>
inline const Pool2DOptions *Operator::builtin_options_as<Pool2DOptions>()
    const {
  return builtin_options_as_Pool2DOptions();
}

template <>
inline const SVDFOptions *Operator::builtin_options_as<SVDFOptions>() const {
  return builtin_options_as_SVDFOptions();
}

template <>
inline const RNNOptions *Operator::builtin_options_as<RNNOptions>() const {
  return builtin_options_as_RNNOptions();
}

template <>
inline const FullyConnectedOptions *
Operator::builtin_options_as<FullyConnectedOptions>() const {
  return builtin_options_as_FullyConnectedOptions();
}

template <>
inline const SoftmaxOptions *Operator::builtin_options_as<SoftmaxOptions>()
    const {
  return builtin_options_as_SoftmaxOptions();
}

template <>
inline const ConcatenationOptions *
Operator::builtin_options_as<ConcatenationOptions>() const {
  return builtin_options_as_ConcatenationOptions();
}

template <>
inline const AddOptions *Operator::builtin_options_as<AddOptions>() const {
  return builtin_options_as_AddOptions();
}

template <>
inline const L2NormOptions *Operator::builtin_options_as<L2NormOptions>()
    const {
  return builtin_options_as_L2NormOptions();
}

template <>
inline const LocalResponseNormalizationOptions *
Operator::builtin_options_as<LocalResponseNormalizationOptions>() const {
  return builtin_options_as_LocalResponseNormalizationOptions();
}

template <>
inline const LSTMOptions *Operator::builtin_options_as<LSTMOptions>() const {
  return builtin_options_as_LSTMOptions();
}

template <>
inline const ResizeBilinearOptions *
Operator::builtin_options_as<ResizeBilinearOptions>() const {
  return builtin_options_as_ResizeBilinearOptions();
}

template <>
inline const CallOptions *Operator::builtin_options_as<CallOptions>() const {
  return builtin_options_as_CallOptions();
}

template <>
inline const ReshapeOptions *Operator::builtin_options_as<ReshapeOptions>()
    const {
  return builtin_options_as_ReshapeOptions();
}

template <>
inline const SkipGramOptions *Operator::builtin_options_as<SkipGramOptions>()
    const {
  return builtin_options_as_SkipGramOptions();
}

template <>
inline const SpaceToDepthOptions *
Operator::builtin_options_as<SpaceToDepthOptions>() const {
  return builtin_options_as_SpaceToDepthOptions();
}

template <>
inline const EmbeddingLookupSparseOptions *
Operator::builtin_options_as<EmbeddingLookupSparseOptions>() const {
  return builtin_options_as_EmbeddingLookupSparseOptions();
}

template <>
inline const MulOptions *Operator::builtin_options_as<MulOptions>() const {
  return builtin_options_as_MulOptions();
}

template <>
inline const PadOptions *Operator::builtin_options_as<PadOptions>() const {
  return builtin_options_as_PadOptions();
}

struct OperatorBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_opcode_index(uint32_t opcode_index) {
    fbb_.AddElement<uint32_t>(Operator::VT_OPCODE_INDEX, opcode_index, 0);
  }
  void add_inputs(flatbuffers::Offset<flatbuffers::Vector<int32_t>> inputs) {
    fbb_.AddOffset(Operator::VT_INPUTS, inputs);
  }
  void add_outputs(flatbuffers::Offset<flatbuffers::Vector<int32_t>> outputs) {
    fbb_.AddOffset(Operator::VT_OUTPUTS, outputs);
  }
  void add_builtin_options_type(BuiltinOptions builtin_options_type) {
    fbb_.AddElement<uint8_t>(Operator::VT_BUILTIN_OPTIONS_TYPE,
                             static_cast<uint8_t>(builtin_options_type), 0);
  }
  void add_builtin_options(flatbuffers::Offset<void> builtin_options) {
    fbb_.AddOffset(Operator::VT_BUILTIN_OPTIONS, builtin_options);
  }
  void add_custom_options(
      flatbuffers::Offset<flatbuffers::Vector<uint8_t>> custom_options) {
    fbb_.AddOffset(Operator::VT_CUSTOM_OPTIONS, custom_options);
  }
  void add_custom_options_format(CustomOptionsFormat custom_options_format) {
    fbb_.AddElement<int8_t>(Operator::VT_CUSTOM_OPTIONS_FORMAT,
                            static_cast<int8_t>(custom_options_format), 0);
  }
  explicit OperatorBuilder(flatbuffers::FlatBufferBuilder &_fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  OperatorBuilder &operator=(const OperatorBuilder &);
  flatbuffers::Offset<Operator> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Operator>(end);
    return o;
  }
};

inline flatbuffers::Offset<Operator> CreateOperator(
    flatbuffers::FlatBufferBuilder &_fbb, uint32_t opcode_index = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> inputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> outputs = 0,
    BuiltinOptions builtin_options_type = BuiltinOptions_NONE,
    flatbuffers::Offset<void> builtin_options = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> custom_options = 0,
    CustomOptionsFormat custom_options_format =
        CustomOptionsFormat_FLEXBUFFERS) {
  OperatorBuilder builder_(_fbb);
  builder_.add_custom_options(custom_options);
  builder_.add_builtin_options(builtin_options);
  builder_.add_outputs(outputs);
  builder_.add_inputs(inputs);
  builder_.add_opcode_index(opcode_index);
  builder_.add_custom_options_format(custom_options_format);
  builder_.add_builtin_options_type(builtin_options_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<Operator> CreateOperatorDirect(
    flatbuffers::FlatBufferBuilder &_fbb, uint32_t opcode_index = 0,
    const std::vector<int32_t> *inputs = nullptr,
    const std::vector<int32_t> *outputs = nullptr,
    BuiltinOptions builtin_options_type = BuiltinOptions_NONE,
    flatbuffers::Offset<void> builtin_options = 0,
    const std::vector<uint8_t> *custom_options = nullptr,
    CustomOptionsFormat custom_options_format =
        CustomOptionsFormat_FLEXBUFFERS) {
  return tflite::CreateOperator(
      _fbb, opcode_index, inputs ? _fbb.CreateVector<int32_t>(*inputs) : 0,
      outputs ? _fbb.CreateVector<int32_t>(*outputs) : 0, builtin_options_type,
      builtin_options,
      custom_options ? _fbb.CreateVector<uint8_t>(*custom_options) : 0,
      custom_options_format);
}

flatbuffers::Offset<Operator> CreateOperator(
    flatbuffers::FlatBufferBuilder &_fbb, const OperatorT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct SubGraphT : public flatbuffers::NativeTable {
  typedef SubGraph TableType;
  std::vector<std::unique_ptr<TensorT>> tensors;
  std::vector<int32_t> inputs;
  std::vector<int32_t> outputs;
  std::vector<std::unique_ptr<OperatorT>> operators;
  std::string name;
  SubGraphT() {}
};

struct SubGraph FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef SubGraphT NativeTableType;
  enum {
    VT_TENSORS = 4,
    VT_INPUTS = 6,
    VT_OUTPUTS = 8,
    VT_OPERATORS = 10,
    VT_NAME = 12
  };
  const flatbuffers::Vector<flatbuffers::Offset<Tensor>> *tensors() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<Tensor>> *>(
        VT_TENSORS);
  }
  const flatbuffers::Vector<int32_t> *inputs() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_INPUTS);
  }
  const flatbuffers::Vector<int32_t> *outputs() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_OUTPUTS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<Operator>> *operators() const {
    return GetPointer<
        const flatbuffers::Vector<flatbuffers::Offset<Operator>> *>(
        VT_OPERATORS);
  }
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_TENSORS) &&
           verifier.Verify(tensors()) &&
           verifier.VerifyVectorOfTables(tensors()) &&
           VerifyOffset(verifier, VT_INPUTS) && verifier.Verify(inputs()) &&
           VerifyOffset(verifier, VT_OUTPUTS) && verifier.Verify(outputs()) &&
           VerifyOffset(verifier, VT_OPERATORS) &&
           verifier.Verify(operators()) &&
           verifier.VerifyVectorOfTables(operators()) &&
           VerifyOffset(verifier, VT_NAME) && verifier.Verify(name()) &&
           verifier.EndTable();
  }
  SubGraphT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(
      SubGraphT *_o,
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static flatbuffers::Offset<SubGraph> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const SubGraphT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct SubGraphBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_tensors(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Tensor>>>
          tensors) {
    fbb_.AddOffset(SubGraph::VT_TENSORS, tensors);
  }
  void add_inputs(flatbuffers::Offset<flatbuffers::Vector<int32_t>> inputs) {
    fbb_.AddOffset(SubGraph::VT_INPUTS, inputs);
  }
  void add_outputs(flatbuffers::Offset<flatbuffers::Vector<int32_t>> outputs) {
    fbb_.AddOffset(SubGraph::VT_OUTPUTS, outputs);
  }
  void add_operators(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Operator>>>
          operators) {
    fbb_.AddOffset(SubGraph::VT_OPERATORS, operators);
  }
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(SubGraph::VT_NAME, name);
  }
  explicit SubGraphBuilder(flatbuffers::FlatBufferBuilder &_fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  SubGraphBuilder &operator=(const SubGraphBuilder &);
  flatbuffers::Offset<SubGraph> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SubGraph>(end);
    return o;
  }
};

inline flatbuffers::Offset<SubGraph> CreateSubGraph(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Tensor>>>
        tensors = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> inputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> outputs = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Operator>>>
        operators = 0,
    flatbuffers::Offset<flatbuffers::String> name = 0) {
  SubGraphBuilder builder_(_fbb);
  builder_.add_name(name);
  builder_.add_operators(operators);
  builder_.add_outputs(outputs);
  builder_.add_inputs(inputs);
  builder_.add_tensors(tensors);
  return builder_.Finish();
}

inline flatbuffers::Offset<SubGraph> CreateSubGraphDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<flatbuffers::Offset<Tensor>> *tensors = nullptr,
    const std::vector<int32_t> *inputs = nullptr,
    const std::vector<int32_t> *outputs = nullptr,
    const std::vector<flatbuffers::Offset<Operator>> *operators = nullptr,
    const char *name = nullptr) {
  return tflite::CreateSubGraph(
      _fbb,
      tensors ? _fbb.CreateVector<flatbuffers::Offset<Tensor>>(*tensors) : 0,
      inputs ? _fbb.CreateVector<int32_t>(*inputs) : 0,
      outputs ? _fbb.CreateVector<int32_t>(*outputs) : 0,
      operators ? _fbb.CreateVector<flatbuffers::Offset<Operator>>(*operators)
                : 0,
      name ? _fbb.CreateString(name) : 0);
}

flatbuffers::Offset<SubGraph> CreateSubGraph(
    flatbuffers::FlatBufferBuilder &_fbb, const SubGraphT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct BufferT : public flatbuffers::NativeTable {
  typedef Buffer TableType;
  std::vector<uint8_t> data;
  BufferT() {}
};

struct Buffer FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BufferT NativeTableType;
  enum { VT_DATA = 4 };
  const flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_DATA) &&
           verifier.Verify(data()) && verifier.EndTable();
  }
  BufferT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(BufferT *_o, const flatbuffers::resolver_function_t *_resolver =
                                 nullptr) const;
  static flatbuffers::Offset<Buffer> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const BufferT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct BufferBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(Buffer::VT_DATA, data);
  }
  explicit BufferBuilder(flatbuffers::FlatBufferBuilder &_fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  BufferBuilder &operator=(const BufferBuilder &);
  flatbuffers::Offset<Buffer> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Buffer>(end);
    return o;
  }
};

inline flatbuffers::Offset<Buffer> CreateBuffer(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data = 0) {
  BufferBuilder builder_(_fbb);
  builder_.add_data(data);
  return builder_.Finish();
}

inline flatbuffers::Offset<Buffer> CreateBufferDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<uint8_t> *data = nullptr) {
  return tflite::CreateBuffer(_fbb,
                              data ? _fbb.CreateVector<uint8_t>(*data) : 0);
}

flatbuffers::Offset<Buffer> CreateBuffer(
    flatbuffers::FlatBufferBuilder &_fbb, const BufferT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ModelT : public flatbuffers::NativeTable {
  typedef Model TableType;
  uint32_t version;
  std::vector<std::unique_ptr<OperatorCodeT>> operator_codes;
  std::vector<std::unique_ptr<SubGraphT>> subgraphs;
  std::string description;
  std::vector<std::unique_ptr<BufferT>> buffers;
  ModelT() : version(0) {}
};

struct Model FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ModelT NativeTableType;
  enum {
    VT_VERSION = 4,
    VT_OPERATOR_CODES = 6,
    VT_SUBGRAPHS = 8,
    VT_DESCRIPTION = 10,
    VT_BUFFERS = 12
  };
  uint32_t version() const { return GetField<uint32_t>(VT_VERSION, 0); }
  const flatbuffers::Vector<flatbuffers::Offset<OperatorCode>> *operator_codes()
      const {
    return GetPointer<
        const flatbuffers::Vector<flatbuffers::Offset<OperatorCode>> *>(
        VT_OPERATOR_CODES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<SubGraph>> *subgraphs() const {
    return GetPointer<
        const flatbuffers::Vector<flatbuffers::Offset<SubGraph>> *>(
        VT_SUBGRAPHS);
  }
  const flatbuffers::String *description() const {
    return GetPointer<const flatbuffers::String *>(VT_DESCRIPTION);
  }
  const flatbuffers::Vector<flatbuffers::Offset<Buffer>> *buffers() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<Buffer>> *>(
        VT_BUFFERS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint32_t>(verifier, VT_VERSION) &&
           VerifyOffset(verifier, VT_OPERATOR_CODES) &&
           verifier.Verify(operator_codes()) &&
           verifier.VerifyVectorOfTables(operator_codes()) &&
           VerifyOffset(verifier, VT_SUBGRAPHS) &&
           verifier.Verify(subgraphs()) &&
           verifier.VerifyVectorOfTables(subgraphs()) &&
           VerifyOffset(verifier, VT_DESCRIPTION) &&
           verifier.Verify(description()) &&
           VerifyOffset(verifier, VT_BUFFERS) && verifier.Verify(buffers()) &&
           verifier.VerifyVectorOfTables(buffers()) && verifier.EndTable();
  }
  ModelT *UnPack(
      const flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ModelT *_o, const flatbuffers::resolver_function_t *_resolver =
                                nullptr) const;
  static flatbuffers::Offset<Model> Pack(
      flatbuffers::FlatBufferBuilder &_fbb, const ModelT *_o,
      const flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ModelBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_version(uint32_t version) {
    fbb_.AddElement<uint32_t>(Model::VT_VERSION, version, 0);
  }
  void add_operator_codes(
      flatbuffers::Offset<
          flatbuffers::Vector<flatbuffers::Offset<OperatorCode>>>
          operator_codes) {
    fbb_.AddOffset(Model::VT_OPERATOR_CODES, operator_codes);
  }
  void add_subgraphs(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<SubGraph>>>
          subgraphs) {
    fbb_.AddOffset(Model::VT_SUBGRAPHS, subgraphs);
  }
  void add_description(flatbuffers::Offset<flatbuffers::String> description) {
    fbb_.AddOffset(Model::VT_DESCRIPTION, description);
  }
  void add_buffers(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Buffer>>>
          buffers) {
    fbb_.AddOffset(Model::VT_BUFFERS, buffers);
  }
  explicit ModelBuilder(flatbuffers::FlatBufferBuilder &_fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ModelBuilder &operator=(const ModelBuilder &);
  flatbuffers::Offset<Model> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Model>(end);
    return o;
  }
};

inline flatbuffers::Offset<Model> CreateModel(
    flatbuffers::FlatBufferBuilder &_fbb, uint32_t version = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<OperatorCode>>>
        operator_codes = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<SubGraph>>>
        subgraphs = 0,
    flatbuffers::Offset<flatbuffers::String> description = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<Buffer>>>
        buffers = 0) {
  ModelBuilder builder_(_fbb);
  builder_.add_buffers(buffers);
  builder_.add_description(description);
  builder_.add_subgraphs(subgraphs);
  builder_.add_operator_codes(operator_codes);
  builder_.add_version(version);
  return builder_.Finish();
}

inline flatbuffers::Offset<Model> CreateModelDirect(
    flatbuffers::FlatBufferBuilder &_fbb, uint32_t version = 0,
    const std::vector<flatbuffers::Offset<OperatorCode>> *operator_codes =
        nullptr,
    const std::vector<flatbuffers::Offset<SubGraph>> *subgraphs = nullptr,
    const char *description = nullptr,
    const std::vector<flatbuffers::Offset<Buffer>> *buffers = nullptr) {
  return tflite::CreateModel(
      _fbb, version,
      operator_codes ? _fbb.CreateVector<flatbuffers::Offset<OperatorCode>>(
                           *operator_codes)
                     : 0,
      subgraphs ? _fbb.CreateVector<flatbuffers::Offset<SubGraph>>(*subgraphs)
                : 0,
      description ? _fbb.CreateString(description) : 0,
      buffers ? _fbb.CreateVector<flatbuffers::Offset<Buffer>>(*buffers) : 0);
}

flatbuffers::Offset<Model> CreateModel(
    flatbuffers::FlatBufferBuilder &_fbb, const ModelT *_o,
    const flatbuffers::rehasher_function_t *_rehasher = nullptr);

inline QuantizationParametersT *QuantizationParameters::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new QuantizationParametersT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void QuantizationParameters::UnPackTo(
    QuantizationParametersT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = min();
    if (_e) {
      _o->min.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->min[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = max();
    if (_e) {
      _o->max.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->max[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = scale();
    if (_e) {
      _o->scale.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->scale[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = zero_point();
    if (_e) {
      _o->zero_point.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->zero_point[_i] = _e->Get(_i);
      }
    }
  };
}

inline flatbuffers::Offset<QuantizationParameters> QuantizationParameters::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const QuantizationParametersT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateQuantizationParameters(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<QuantizationParameters> CreateQuantizationParameters(
    flatbuffers::FlatBufferBuilder &_fbb, const QuantizationParametersT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const QuantizationParametersT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _min = _o->min.size() ? _fbb.CreateVector(_o->min) : 0;
  auto _max = _o->max.size() ? _fbb.CreateVector(_o->max) : 0;
  auto _scale = _o->scale.size() ? _fbb.CreateVector(_o->scale) : 0;
  auto _zero_point =
      _o->zero_point.size() ? _fbb.CreateVector(_o->zero_point) : 0;
  return tflite::CreateQuantizationParameters(_fbb, _min, _max, _scale,
                                              _zero_point);
}

inline TensorT *Tensor::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new TensorT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Tensor::UnPackTo(
    TensorT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = shape();
    if (_e) {
      _o->shape.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->shape[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = type();
    _o->type = _e;
  };
  {
    auto _e = buffer();
    _o->buffer = _e;
  };
  {
    auto _e = name();
    if (_e) _o->name = _e->str();
  };
  {
    auto _e = quantization();
    if (_e)
      _o->quantization =
          std::unique_ptr<QuantizationParametersT>(_e->UnPack(_resolver));
  };
}

inline flatbuffers::Offset<Tensor> Tensor::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const TensorT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateTensor(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Tensor> CreateTensor(
    flatbuffers::FlatBufferBuilder &_fbb, const TensorT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const TensorT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _shape = _o->shape.size() ? _fbb.CreateVector(_o->shape) : 0;
  auto _type = _o->type;
  auto _buffer = _o->buffer;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _quantization = _o->quantization
                           ? CreateQuantizationParameters(
                                 _fbb, _o->quantization.get(), _rehasher)
                           : 0;
  return tflite::CreateTensor(_fbb, _shape, _type, _buffer, _name,
                              _quantization);
}

inline Conv2DOptionsT *Conv2DOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new Conv2DOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Conv2DOptions::UnPackTo(
    Conv2DOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = padding();
    _o->padding = _e;
  };
  {
    auto _e = stride_w();
    _o->stride_w = _e;
  };
  {
    auto _e = stride_h();
    _o->stride_h = _e;
  };
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<Conv2DOptions> Conv2DOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const Conv2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateConv2DOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Conv2DOptions> CreateConv2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const Conv2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const Conv2DOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _padding = _o->padding;
  auto _stride_w = _o->stride_w;
  auto _stride_h = _o->stride_h;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateConv2DOptions(_fbb, _padding, _stride_w, _stride_h,
                                     _fused_activation_function);
}

inline Pool2DOptionsT *Pool2DOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new Pool2DOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Pool2DOptions::UnPackTo(
    Pool2DOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = padding();
    _o->padding = _e;
  };
  {
    auto _e = stride_w();
    _o->stride_w = _e;
  };
  {
    auto _e = stride_h();
    _o->stride_h = _e;
  };
  {
    auto _e = filter_width();
    _o->filter_width = _e;
  };
  {
    auto _e = filter_height();
    _o->filter_height = _e;
  };
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<Pool2DOptions> Pool2DOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const Pool2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreatePool2DOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Pool2DOptions> CreatePool2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const Pool2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const Pool2DOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _padding = _o->padding;
  auto _stride_w = _o->stride_w;
  auto _stride_h = _o->stride_h;
  auto _filter_width = _o->filter_width;
  auto _filter_height = _o->filter_height;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreatePool2DOptions(_fbb, _padding, _stride_w, _stride_h,
                                     _filter_width, _filter_height,
                                     _fused_activation_function);
}

inline DepthwiseConv2DOptionsT *DepthwiseConv2DOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new DepthwiseConv2DOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void DepthwiseConv2DOptions::UnPackTo(
    DepthwiseConv2DOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = padding();
    _o->padding = _e;
  };
  {
    auto _e = stride_w();
    _o->stride_w = _e;
  };
  {
    auto _e = stride_h();
    _o->stride_h = _e;
  };
  {
    auto _e = depth_multiplier();
    _o->depth_multiplier = _e;
  };
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<DepthwiseConv2DOptions> DepthwiseConv2DOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const DepthwiseConv2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateDepthwiseConv2DOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<DepthwiseConv2DOptions> CreateDepthwiseConv2DOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const DepthwiseConv2DOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const DepthwiseConv2DOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _padding = _o->padding;
  auto _stride_w = _o->stride_w;
  auto _stride_h = _o->stride_h;
  auto _depth_multiplier = _o->depth_multiplier;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateDepthwiseConv2DOptions(_fbb, _padding, _stride_w,
                                              _stride_h, _depth_multiplier,
                                              _fused_activation_function);
}

inline ConcatEmbeddingsOptionsT *ConcatEmbeddingsOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ConcatEmbeddingsOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ConcatEmbeddingsOptions::UnPackTo(
    ConcatEmbeddingsOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = num_channels();
    _o->num_channels = _e;
  };
  {
    auto _e = num_columns_per_channel();
    if (_e) {
      _o->num_columns_per_channel.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->num_columns_per_channel[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = embedding_dim_per_channel();
    if (_e) {
      _o->embedding_dim_per_channel.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->embedding_dim_per_channel[_i] = _e->Get(_i);
      }
    }
  };
}

inline flatbuffers::Offset<ConcatEmbeddingsOptions>
ConcatEmbeddingsOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const ConcatEmbeddingsOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateConcatEmbeddingsOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ConcatEmbeddingsOptions>
CreateConcatEmbeddingsOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ConcatEmbeddingsOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const ConcatEmbeddingsOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _num_channels = _o->num_channels;
  auto _num_columns_per_channel =
      _o->num_columns_per_channel.size()
          ? _fbb.CreateVector(_o->num_columns_per_channel)
          : 0;
  auto _embedding_dim_per_channel =
      _o->embedding_dim_per_channel.size()
          ? _fbb.CreateVector(_o->embedding_dim_per_channel)
          : 0;
  return tflite::CreateConcatEmbeddingsOptions(_fbb, _num_channels,
                                               _num_columns_per_channel,
                                               _embedding_dim_per_channel);
}

inline LSHProjectionOptionsT *LSHProjectionOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new LSHProjectionOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void LSHProjectionOptions::UnPackTo(
    LSHProjectionOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = type();
    _o->type = _e;
  };
}

inline flatbuffers::Offset<LSHProjectionOptions> LSHProjectionOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const LSHProjectionOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateLSHProjectionOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LSHProjectionOptions> CreateLSHProjectionOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const LSHProjectionOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const LSHProjectionOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _type = _o->type;
  return tflite::CreateLSHProjectionOptions(_fbb, _type);
}

inline SVDFOptionsT *SVDFOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new SVDFOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void SVDFOptions::UnPackTo(
    SVDFOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = rank();
    _o->rank = _e;
  };
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<SVDFOptions> SVDFOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const SVDFOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateSVDFOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SVDFOptions> CreateSVDFOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SVDFOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const SVDFOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _rank = _o->rank;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateSVDFOptions(_fbb, _rank, _fused_activation_function);
}

inline RNNOptionsT *RNNOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new RNNOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void RNNOptions::UnPackTo(
    RNNOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<RNNOptions> RNNOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const RNNOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateRNNOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<RNNOptions> CreateRNNOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const RNNOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const RNNOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateRNNOptions(_fbb, _fused_activation_function);
}

inline FullyConnectedOptionsT *FullyConnectedOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new FullyConnectedOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void FullyConnectedOptions::UnPackTo(
    FullyConnectedOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<FullyConnectedOptions> FullyConnectedOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const FullyConnectedOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateFullyConnectedOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<FullyConnectedOptions> CreateFullyConnectedOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const FullyConnectedOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const FullyConnectedOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateFullyConnectedOptions(_fbb, _fused_activation_function);
}

inline SoftmaxOptionsT *SoftmaxOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new SoftmaxOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void SoftmaxOptions::UnPackTo(
    SoftmaxOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = beta();
    _o->beta = _e;
  };
}

inline flatbuffers::Offset<SoftmaxOptions> SoftmaxOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const SoftmaxOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateSoftmaxOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SoftmaxOptions> CreateSoftmaxOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SoftmaxOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const SoftmaxOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _beta = _o->beta;
  return tflite::CreateSoftmaxOptions(_fbb, _beta);
}

inline ConcatenationOptionsT *ConcatenationOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ConcatenationOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ConcatenationOptions::UnPackTo(
    ConcatenationOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = axis();
    _o->axis = _e;
  };
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<ConcatenationOptions> ConcatenationOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const ConcatenationOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateConcatenationOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ConcatenationOptions> CreateConcatenationOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ConcatenationOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const ConcatenationOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _axis = _o->axis;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateConcatenationOptions(_fbb, _axis,
                                            _fused_activation_function);
}

inline AddOptionsT *AddOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new AddOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void AddOptions::UnPackTo(
    AddOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<AddOptions> AddOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const AddOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateAddOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<AddOptions> CreateAddOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const AddOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const AddOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateAddOptions(_fbb, _fused_activation_function);
}

inline MulOptionsT *MulOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new MulOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void MulOptions::UnPackTo(
    MulOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<MulOptions> MulOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const MulOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateMulOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<MulOptions> CreateMulOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const MulOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const MulOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateMulOptions(_fbb, _fused_activation_function);
}

inline L2NormOptionsT *L2NormOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new L2NormOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void L2NormOptions::UnPackTo(
    L2NormOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
}

inline flatbuffers::Offset<L2NormOptions> L2NormOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const L2NormOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateL2NormOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<L2NormOptions> CreateL2NormOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const L2NormOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const L2NormOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _fused_activation_function = _o->fused_activation_function;
  return tflite::CreateL2NormOptions(_fbb, _fused_activation_function);
}

inline LocalResponseNormalizationOptionsT *
LocalResponseNormalizationOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new LocalResponseNormalizationOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void LocalResponseNormalizationOptions::UnPackTo(
    LocalResponseNormalizationOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = radius();
    _o->radius = _e;
  };
  {
    auto _e = bias();
    _o->bias = _e;
  };
  {
    auto _e = alpha();
    _o->alpha = _e;
  };
  {
    auto _e = beta();
    _o->beta = _e;
  };
}

inline flatbuffers::Offset<LocalResponseNormalizationOptions>
LocalResponseNormalizationOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb,
    const LocalResponseNormalizationOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateLocalResponseNormalizationOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LocalResponseNormalizationOptions>
CreateLocalResponseNormalizationOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    const LocalResponseNormalizationOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const LocalResponseNormalizationOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _radius = _o->radius;
  auto _bias = _o->bias;
  auto _alpha = _o->alpha;
  auto _beta = _o->beta;
  return tflite::CreateLocalResponseNormalizationOptions(_fbb, _radius, _bias,
                                                         _alpha, _beta);
}

inline LSTMOptionsT *LSTMOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new LSTMOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void LSTMOptions::UnPackTo(
    LSTMOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = fused_activation_function();
    _o->fused_activation_function = _e;
  };
  {
    auto _e = cell_clip();
    _o->cell_clip = _e;
  };
  {
    auto _e = proj_clip();
    _o->proj_clip = _e;
  };
}

inline flatbuffers::Offset<LSTMOptions> LSTMOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const LSTMOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateLSTMOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<LSTMOptions> CreateLSTMOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const LSTMOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const LSTMOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _fused_activation_function = _o->fused_activation_function;
  auto _cell_clip = _o->cell_clip;
  auto _proj_clip = _o->proj_clip;
  return tflite::CreateLSTMOptions(_fbb, _fused_activation_function, _cell_clip,
                                   _proj_clip);
}

inline ResizeBilinearOptionsT *ResizeBilinearOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ResizeBilinearOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ResizeBilinearOptions::UnPackTo(
    ResizeBilinearOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = new_height();
    _o->new_height = _e;
  };
  {
    auto _e = new_width();
    _o->new_width = _e;
  };
}

inline flatbuffers::Offset<ResizeBilinearOptions> ResizeBilinearOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const ResizeBilinearOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateResizeBilinearOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ResizeBilinearOptions> CreateResizeBilinearOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ResizeBilinearOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const ResizeBilinearOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _new_height = _o->new_height;
  auto _new_width = _o->new_width;
  return tflite::CreateResizeBilinearOptions(_fbb, _new_height, _new_width);
}

inline CallOptionsT *CallOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new CallOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void CallOptions::UnPackTo(
    CallOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = subgraph();
    _o->subgraph = _e;
  };
}

inline flatbuffers::Offset<CallOptions> CallOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const CallOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateCallOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<CallOptions> CreateCallOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const CallOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const CallOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _subgraph = _o->subgraph;
  return tflite::CreateCallOptions(_fbb, _subgraph);
}

inline PadOptionsT *PadOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new PadOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void PadOptions::UnPackTo(
    PadOptionsT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = before_padding();
    if (_e) {
      _o->before_padding.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->before_padding[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = after_padding();
    if (_e) {
      _o->after_padding.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->after_padding[_i] = _e->Get(_i);
      }
    }
  };
}

inline flatbuffers::Offset<PadOptions> PadOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const PadOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreatePadOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<PadOptions> CreatePadOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const PadOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const PadOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _before_padding =
      _o->before_padding.size() ? _fbb.CreateVector(_o->before_padding) : 0;
  auto _after_padding =
      _o->after_padding.size() ? _fbb.CreateVector(_o->after_padding) : 0;
  return tflite::CreatePadOptions(_fbb, _before_padding, _after_padding);
}

inline ReshapeOptionsT *ReshapeOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ReshapeOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void ReshapeOptions::UnPackTo(
    ReshapeOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = new_shape();
    if (_e) {
      _o->new_shape.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->new_shape[_i] = _e->Get(_i);
      }
    }
  };
}

inline flatbuffers::Offset<ReshapeOptions> ReshapeOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const ReshapeOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateReshapeOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<ReshapeOptions> CreateReshapeOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const ReshapeOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const ReshapeOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _new_shape = _o->new_shape.size() ? _fbb.CreateVector(_o->new_shape) : 0;
  return tflite::CreateReshapeOptions(_fbb, _new_shape);
}

inline SkipGramOptionsT *SkipGramOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new SkipGramOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void SkipGramOptions::UnPackTo(
    SkipGramOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = ngram_size();
    _o->ngram_size = _e;
  };
  {
    auto _e = max_skip_size();
    _o->max_skip_size = _e;
  };
  {
    auto _e = include_all_ngrams();
    _o->include_all_ngrams = _e;
  };
}

inline flatbuffers::Offset<SkipGramOptions> SkipGramOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const SkipGramOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateSkipGramOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SkipGramOptions> CreateSkipGramOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SkipGramOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const SkipGramOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _ngram_size = _o->ngram_size;
  auto _max_skip_size = _o->max_skip_size;
  auto _include_all_ngrams = _o->include_all_ngrams;
  return tflite::CreateSkipGramOptions(_fbb, _ngram_size, _max_skip_size,
                                       _include_all_ngrams);
}

inline SpaceToDepthOptionsT *SpaceToDepthOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new SpaceToDepthOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void SpaceToDepthOptions::UnPackTo(
    SpaceToDepthOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = block_size();
    _o->block_size = _e;
  };
}

inline flatbuffers::Offset<SpaceToDepthOptions> SpaceToDepthOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const SpaceToDepthOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateSpaceToDepthOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SpaceToDepthOptions> CreateSpaceToDepthOptions(
    flatbuffers::FlatBufferBuilder &_fbb, const SpaceToDepthOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const SpaceToDepthOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _block_size = _o->block_size;
  return tflite::CreateSpaceToDepthOptions(_fbb, _block_size);
}

inline EmbeddingLookupSparseOptionsT *EmbeddingLookupSparseOptions::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new EmbeddingLookupSparseOptionsT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void EmbeddingLookupSparseOptions::UnPackTo(
    EmbeddingLookupSparseOptionsT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = combiner();
    _o->combiner = _e;
  };
}

inline flatbuffers::Offset<EmbeddingLookupSparseOptions>
EmbeddingLookupSparseOptions::Pack(
    flatbuffers::FlatBufferBuilder &_fbb,
    const EmbeddingLookupSparseOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateEmbeddingLookupSparseOptions(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<EmbeddingLookupSparseOptions>
CreateEmbeddingLookupSparseOptions(
    flatbuffers::FlatBufferBuilder &_fbb,
    const EmbeddingLookupSparseOptionsT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const EmbeddingLookupSparseOptionsT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _combiner = _o->combiner;
  return tflite::CreateEmbeddingLookupSparseOptions(_fbb, _combiner);
}

inline OperatorCodeT *OperatorCode::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new OperatorCodeT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void OperatorCode::UnPackTo(
    OperatorCodeT *_o,
    const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = builtin_code();
    _o->builtin_code = _e;
  };
  {
    auto _e = custom_code();
    if (_e) _o->custom_code = _e->str();
  };
}

inline flatbuffers::Offset<OperatorCode> OperatorCode::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const OperatorCodeT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateOperatorCode(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<OperatorCode> CreateOperatorCode(
    flatbuffers::FlatBufferBuilder &_fbb, const OperatorCodeT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const OperatorCodeT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _builtin_code = _o->builtin_code;
  auto _custom_code =
      _o->custom_code.empty() ? 0 : _fbb.CreateString(_o->custom_code);
  return tflite::CreateOperatorCode(_fbb, _builtin_code, _custom_code);
}

inline OperatorT *Operator::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new OperatorT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Operator::UnPackTo(
    OperatorT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = opcode_index();
    _o->opcode_index = _e;
  };
  {
    auto _e = inputs();
    if (_e) {
      _o->inputs.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->inputs[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = outputs();
    if (_e) {
      _o->outputs.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->outputs[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = builtin_options_type();
    _o->builtin_options.type = _e;
  };
  {
    auto _e = builtin_options();
    if (_e)
      _o->builtin_options.value =
          BuiltinOptionsUnion::UnPack(_e, builtin_options_type(), _resolver);
  };
  {
    auto _e = custom_options();
    if (_e) {
      _o->custom_options.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->custom_options[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = custom_options_format();
    _o->custom_options_format = _e;
  };
}

inline flatbuffers::Offset<Operator> Operator::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const OperatorT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateOperator(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Operator> CreateOperator(
    flatbuffers::FlatBufferBuilder &_fbb, const OperatorT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const OperatorT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _opcode_index = _o->opcode_index;
  auto _inputs = _o->inputs.size() ? _fbb.CreateVector(_o->inputs) : 0;
  auto _outputs = _o->outputs.size() ? _fbb.CreateVector(_o->outputs) : 0;
  auto _builtin_options_type = _o->builtin_options.type;
  auto _builtin_options = _o->builtin_options.Pack(_fbb);
  auto _custom_options =
      _o->custom_options.size() ? _fbb.CreateVector(_o->custom_options) : 0;
  auto _custom_options_format = _o->custom_options_format;
  return tflite::CreateOperator(_fbb, _opcode_index, _inputs, _outputs,
                                _builtin_options_type, _builtin_options,
                                _custom_options, _custom_options_format);
}

inline SubGraphT *SubGraph::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new SubGraphT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void SubGraph::UnPackTo(
    SubGraphT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = tensors();
    if (_e) {
      _o->tensors.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->tensors[_i] =
            std::unique_ptr<TensorT>(_e->Get(_i)->UnPack(_resolver));
      }
    }
  };
  {
    auto _e = inputs();
    if (_e) {
      _o->inputs.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->inputs[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = outputs();
    if (_e) {
      _o->outputs.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->outputs[_i] = _e->Get(_i);
      }
    }
  };
  {
    auto _e = operators();
    if (_e) {
      _o->operators.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->operators[_i] =
            std::unique_ptr<OperatorT>(_e->Get(_i)->UnPack(_resolver));
      }
    }
  };
  {
    auto _e = name();
    if (_e) _o->name = _e->str();
  };
}

inline flatbuffers::Offset<SubGraph> SubGraph::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const SubGraphT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateSubGraph(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<SubGraph> CreateSubGraph(
    flatbuffers::FlatBufferBuilder &_fbb, const SubGraphT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const SubGraphT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _tensors =
      _o->tensors.size()
          ? _fbb.CreateVector<flatbuffers::Offset<Tensor>>(
                _o->tensors.size(),
                [](size_t i, _VectorArgs *__va) {
                  return CreateTensor(*__va->__fbb, __va->__o->tensors[i].get(),
                                      __va->__rehasher);
                },
                &_va)
          : 0;
  auto _inputs = _o->inputs.size() ? _fbb.CreateVector(_o->inputs) : 0;
  auto _outputs = _o->outputs.size() ? _fbb.CreateVector(_o->outputs) : 0;
  auto _operators = _o->operators.size()
                        ? _fbb.CreateVector<flatbuffers::Offset<Operator>>(
                              _o->operators.size(),
                              [](size_t i, _VectorArgs *__va) {
                                return CreateOperator(
                                    *__va->__fbb, __va->__o->operators[i].get(),
                                    __va->__rehasher);
                              },
                              &_va)
                        : 0;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  return tflite::CreateSubGraph(_fbb, _tensors, _inputs, _outputs, _operators,
                                _name);
}

inline BufferT *Buffer::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new BufferT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Buffer::UnPackTo(
    BufferT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = data();
    if (_e) {
      _o->data.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->data[_i] = _e->Get(_i);
      }
    }
  };
}

inline flatbuffers::Offset<Buffer> Buffer::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const BufferT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateBuffer(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Buffer> CreateBuffer(
    flatbuffers::FlatBufferBuilder &_fbb, const BufferT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const BufferT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _data = _o->data.size() ? _fbb.CreateVector(_o->data) : 0;
  return tflite::CreateBuffer(_fbb, _data);
}

inline ModelT *Model::UnPack(
    const flatbuffers::resolver_function_t *_resolver) const {
  auto _o = new ModelT();
  UnPackTo(_o, _resolver);
  return _o;
}

inline void Model::UnPackTo(
    ModelT *_o, const flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  {
    auto _e = version();
    _o->version = _e;
  };
  {
    auto _e = operator_codes();
    if (_e) {
      _o->operator_codes.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->operator_codes[_i] =
            std::unique_ptr<OperatorCodeT>(_e->Get(_i)->UnPack(_resolver));
      }
    }
  };
  {
    auto _e = subgraphs();
    if (_e) {
      _o->subgraphs.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->subgraphs[_i] =
            std::unique_ptr<SubGraphT>(_e->Get(_i)->UnPack(_resolver));
      }
    }
  };
  {
    auto _e = description();
    if (_e) _o->description = _e->str();
  };
  {
    auto _e = buffers();
    if (_e) {
      _o->buffers.resize(_e->size());
      for (flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) {
        _o->buffers[_i] =
            std::unique_ptr<BufferT>(_e->Get(_i)->UnPack(_resolver));
      }
    }
  };
}

inline flatbuffers::Offset<Model> Model::Pack(
    flatbuffers::FlatBufferBuilder &_fbb, const ModelT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  return CreateModel(_fbb, _o, _rehasher);
}

inline flatbuffers::Offset<Model> CreateModel(
    flatbuffers::FlatBufferBuilder &_fbb, const ModelT *_o,
    const flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs {
    flatbuffers::FlatBufferBuilder *__fbb;
    const ModelT *__o;
    const flatbuffers::rehasher_function_t *__rehasher;
  } _va = {&_fbb, _o, _rehasher};
  (void)_va;
  auto _version = _o->version;
  auto _operator_codes =
      _o->operator_codes.size()
          ? _fbb.CreateVector<flatbuffers::Offset<OperatorCode>>(
                _o->operator_codes.size(),
                [](size_t i, _VectorArgs *__va) {
                  return CreateOperatorCode(*__va->__fbb,
                                            __va->__o->operator_codes[i].get(),
                                            __va->__rehasher);
                },
                &_va)
          : 0;
  auto _subgraphs = _o->subgraphs.size()
                        ? _fbb.CreateVector<flatbuffers::Offset<SubGraph>>(
                              _o->subgraphs.size(),
                              [](size_t i, _VectorArgs *__va) {
                                return CreateSubGraph(
                                    *__va->__fbb, __va->__o->subgraphs[i].get(),
                                    __va->__rehasher);
                              },
                              &_va)
                        : 0;
  auto _description =
      _o->description.empty() ? 0 : _fbb.CreateString(_o->description);
  auto _buffers =
      _o->buffers.size()
          ? _fbb.CreateVector<flatbuffers::Offset<Buffer>>(
                _o->buffers.size(),
                [](size_t i, _VectorArgs *__va) {
                  return CreateBuffer(*__va->__fbb, __va->__o->buffers[i].get(),
                                      __va->__rehasher);
                },
                &_va)
          : 0;
  return tflite::CreateModel(_fbb, _version, _operator_codes, _subgraphs,
                             _description, _buffers);
}

inline bool VerifyBuiltinOptions(flatbuffers::Verifier &verifier,
                                 const void *obj, BuiltinOptions type) {
  switch (type) {
    case BuiltinOptions_NONE: {
      return true;
    }
    case BuiltinOptions_Conv2DOptions: {
      auto ptr = reinterpret_cast<const Conv2DOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_DepthwiseConv2DOptions: {
      auto ptr = reinterpret_cast<const DepthwiseConv2DOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ConcatEmbeddingsOptions: {
      auto ptr = reinterpret_cast<const ConcatEmbeddingsOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LSHProjectionOptions: {
      auto ptr = reinterpret_cast<const LSHProjectionOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_Pool2DOptions: {
      auto ptr = reinterpret_cast<const Pool2DOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SVDFOptions: {
      auto ptr = reinterpret_cast<const SVDFOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_RNNOptions: {
      auto ptr = reinterpret_cast<const RNNOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_FullyConnectedOptions: {
      auto ptr = reinterpret_cast<const FullyConnectedOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SoftmaxOptions: {
      auto ptr = reinterpret_cast<const SoftmaxOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ConcatenationOptions: {
      auto ptr = reinterpret_cast<const ConcatenationOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_AddOptions: {
      auto ptr = reinterpret_cast<const AddOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_L2NormOptions: {
      auto ptr = reinterpret_cast<const L2NormOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LocalResponseNormalizationOptions: {
      auto ptr =
          reinterpret_cast<const LocalResponseNormalizationOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_LSTMOptions: {
      auto ptr = reinterpret_cast<const LSTMOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ResizeBilinearOptions: {
      auto ptr = reinterpret_cast<const ResizeBilinearOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_CallOptions: {
      auto ptr = reinterpret_cast<const CallOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_ReshapeOptions: {
      auto ptr = reinterpret_cast<const ReshapeOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SkipGramOptions: {
      auto ptr = reinterpret_cast<const SkipGramOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_SpaceToDepthOptions: {
      auto ptr = reinterpret_cast<const SpaceToDepthOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions: {
      auto ptr = reinterpret_cast<const EmbeddingLookupSparseOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_MulOptions: {
      auto ptr = reinterpret_cast<const MulOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case BuiltinOptions_PadOptions: {
      auto ptr = reinterpret_cast<const PadOptions *>(obj);
      return verifier.VerifyTable(ptr);
    }
    default:
      return false;
  }
}

inline bool VerifyBuiltinOptionsVector(
    flatbuffers::Verifier &verifier,
    const flatbuffers::Vector<flatbuffers::Offset<void>> *values,
    const flatbuffers::Vector<uint8_t> *types) {
  if (values->size() != types->size()) return false;
  for (flatbuffers::uoffset_t i = 0; i < values->size(); ++i) {
    if (!VerifyBuiltinOptions(verifier, values->Get(i),
                              types->GetEnum<BuiltinOptions>(i))) {
      return false;
    }
  }
  return true;
}

inline void *BuiltinOptionsUnion::UnPack(
    const void *obj, BuiltinOptions type,
    const flatbuffers::resolver_function_t *resolver) {
  switch (type) {
    case BuiltinOptions_Conv2DOptions: {
      auto ptr = reinterpret_cast<const Conv2DOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_DepthwiseConv2DOptions: {
      auto ptr = reinterpret_cast<const DepthwiseConv2DOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ConcatEmbeddingsOptions: {
      auto ptr = reinterpret_cast<const ConcatEmbeddingsOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LSHProjectionOptions: {
      auto ptr = reinterpret_cast<const LSHProjectionOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_Pool2DOptions: {
      auto ptr = reinterpret_cast<const Pool2DOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SVDFOptions: {
      auto ptr = reinterpret_cast<const SVDFOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_RNNOptions: {
      auto ptr = reinterpret_cast<const RNNOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_FullyConnectedOptions: {
      auto ptr = reinterpret_cast<const FullyConnectedOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SoftmaxOptions: {
      auto ptr = reinterpret_cast<const SoftmaxOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ConcatenationOptions: {
      auto ptr = reinterpret_cast<const ConcatenationOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_AddOptions: {
      auto ptr = reinterpret_cast<const AddOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_L2NormOptions: {
      auto ptr = reinterpret_cast<const L2NormOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LocalResponseNormalizationOptions: {
      auto ptr =
          reinterpret_cast<const LocalResponseNormalizationOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_LSTMOptions: {
      auto ptr = reinterpret_cast<const LSTMOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ResizeBilinearOptions: {
      auto ptr = reinterpret_cast<const ResizeBilinearOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_CallOptions: {
      auto ptr = reinterpret_cast<const CallOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_ReshapeOptions: {
      auto ptr = reinterpret_cast<const ReshapeOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SkipGramOptions: {
      auto ptr = reinterpret_cast<const SkipGramOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_SpaceToDepthOptions: {
      auto ptr = reinterpret_cast<const SpaceToDepthOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions: {
      auto ptr = reinterpret_cast<const EmbeddingLookupSparseOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_MulOptions: {
      auto ptr = reinterpret_cast<const MulOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    case BuiltinOptions_PadOptions: {
      auto ptr = reinterpret_cast<const PadOptions *>(obj);
      return ptr->UnPack(resolver);
    }
    default:
      return nullptr;
  }
}

inline flatbuffers::Offset<void> BuiltinOptionsUnion::Pack(
    flatbuffers::FlatBufferBuilder &_fbb,
    const flatbuffers::rehasher_function_t *_rehasher) const {
  switch (type) {
    case BuiltinOptions_Conv2DOptions: {
      auto ptr = reinterpret_cast<const Conv2DOptionsT *>(value);
      return CreateConv2DOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_DepthwiseConv2DOptions: {
      auto ptr = reinterpret_cast<const DepthwiseConv2DOptionsT *>(value);
      return CreateDepthwiseConv2DOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ConcatEmbeddingsOptions: {
      auto ptr = reinterpret_cast<const ConcatEmbeddingsOptionsT *>(value);
      return CreateConcatEmbeddingsOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LSHProjectionOptions: {
      auto ptr = reinterpret_cast<const LSHProjectionOptionsT *>(value);
      return CreateLSHProjectionOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_Pool2DOptions: {
      auto ptr = reinterpret_cast<const Pool2DOptionsT *>(value);
      return CreatePool2DOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SVDFOptions: {
      auto ptr = reinterpret_cast<const SVDFOptionsT *>(value);
      return CreateSVDFOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_RNNOptions: {
      auto ptr = reinterpret_cast<const RNNOptionsT *>(value);
      return CreateRNNOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_FullyConnectedOptions: {
      auto ptr = reinterpret_cast<const FullyConnectedOptionsT *>(value);
      return CreateFullyConnectedOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SoftmaxOptions: {
      auto ptr = reinterpret_cast<const SoftmaxOptionsT *>(value);
      return CreateSoftmaxOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ConcatenationOptions: {
      auto ptr = reinterpret_cast<const ConcatenationOptionsT *>(value);
      return CreateConcatenationOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_AddOptions: {
      auto ptr = reinterpret_cast<const AddOptionsT *>(value);
      return CreateAddOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_L2NormOptions: {
      auto ptr = reinterpret_cast<const L2NormOptionsT *>(value);
      return CreateL2NormOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_LocalResponseNormalizationOptions: {
      auto ptr =
          reinterpret_cast<const LocalResponseNormalizationOptionsT *>(value);
      return CreateLocalResponseNormalizationOptions(_fbb, ptr, _rehasher)
          .Union();
    }
    case BuiltinOptions_LSTMOptions: {
      auto ptr = reinterpret_cast<const LSTMOptionsT *>(value);
      return CreateLSTMOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ResizeBilinearOptions: {
      auto ptr = reinterpret_cast<const ResizeBilinearOptionsT *>(value);
      return CreateResizeBilinearOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_CallOptions: {
      auto ptr = reinterpret_cast<const CallOptionsT *>(value);
      return CreateCallOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_ReshapeOptions: {
      auto ptr = reinterpret_cast<const ReshapeOptionsT *>(value);
      return CreateReshapeOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SkipGramOptions: {
      auto ptr = reinterpret_cast<const SkipGramOptionsT *>(value);
      return CreateSkipGramOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_SpaceToDepthOptions: {
      auto ptr = reinterpret_cast<const SpaceToDepthOptionsT *>(value);
      return CreateSpaceToDepthOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions: {
      auto ptr = reinterpret_cast<const EmbeddingLookupSparseOptionsT *>(value);
      return CreateEmbeddingLookupSparseOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_MulOptions: {
      auto ptr = reinterpret_cast<const MulOptionsT *>(value);
      return CreateMulOptions(_fbb, ptr, _rehasher).Union();
    }
    case BuiltinOptions_PadOptions: {
      auto ptr = reinterpret_cast<const PadOptionsT *>(value);
      return CreatePadOptions(_fbb, ptr, _rehasher).Union();
    }
    default:
      return 0;
  }
}

inline BuiltinOptionsUnion::BuiltinOptionsUnion(const BuiltinOptionsUnion &u)
    FLATBUFFERS_NOEXCEPT : type(u.type),
                           value(nullptr) {
  switch (type) {
    case BuiltinOptions_Conv2DOptions: {
      value = new Conv2DOptionsT(*reinterpret_cast<Conv2DOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_DepthwiseConv2DOptions: {
      value = new DepthwiseConv2DOptionsT(
          *reinterpret_cast<DepthwiseConv2DOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_ConcatEmbeddingsOptions: {
      value = new ConcatEmbeddingsOptionsT(
          *reinterpret_cast<ConcatEmbeddingsOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_LSHProjectionOptions: {
      value = new LSHProjectionOptionsT(
          *reinterpret_cast<LSHProjectionOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_Pool2DOptions: {
      value = new Pool2DOptionsT(*reinterpret_cast<Pool2DOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_SVDFOptions: {
      value = new SVDFOptionsT(*reinterpret_cast<SVDFOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_RNNOptions: {
      value = new RNNOptionsT(*reinterpret_cast<RNNOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_FullyConnectedOptions: {
      value = new FullyConnectedOptionsT(
          *reinterpret_cast<FullyConnectedOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_SoftmaxOptions: {
      value =
          new SoftmaxOptionsT(*reinterpret_cast<SoftmaxOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_ConcatenationOptions: {
      value = new ConcatenationOptionsT(
          *reinterpret_cast<ConcatenationOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_AddOptions: {
      value = new AddOptionsT(*reinterpret_cast<AddOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_L2NormOptions: {
      value = new L2NormOptionsT(*reinterpret_cast<L2NormOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_LocalResponseNormalizationOptions: {
      value = new LocalResponseNormalizationOptionsT(
          *reinterpret_cast<LocalResponseNormalizationOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_LSTMOptions: {
      value = new LSTMOptionsT(*reinterpret_cast<LSTMOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_ResizeBilinearOptions: {
      value = new ResizeBilinearOptionsT(
          *reinterpret_cast<ResizeBilinearOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_CallOptions: {
      value = new CallOptionsT(*reinterpret_cast<CallOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_ReshapeOptions: {
      value =
          new ReshapeOptionsT(*reinterpret_cast<ReshapeOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_SkipGramOptions: {
      value =
          new SkipGramOptionsT(*reinterpret_cast<SkipGramOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_SpaceToDepthOptions: {
      value = new SpaceToDepthOptionsT(
          *reinterpret_cast<SpaceToDepthOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions: {
      value = new EmbeddingLookupSparseOptionsT(
          *reinterpret_cast<EmbeddingLookupSparseOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_MulOptions: {
      value = new MulOptionsT(*reinterpret_cast<MulOptionsT *>(u.value));
      break;
    }
    case BuiltinOptions_PadOptions: {
      value = new PadOptionsT(*reinterpret_cast<PadOptionsT *>(u.value));
      break;
    }
    default:
      break;
  }
}

inline void BuiltinOptionsUnion::Reset() {
  switch (type) {
    case BuiltinOptions_Conv2DOptions: {
      auto ptr = reinterpret_cast<Conv2DOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_DepthwiseConv2DOptions: {
      auto ptr = reinterpret_cast<DepthwiseConv2DOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_ConcatEmbeddingsOptions: {
      auto ptr = reinterpret_cast<ConcatEmbeddingsOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_LSHProjectionOptions: {
      auto ptr = reinterpret_cast<LSHProjectionOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_Pool2DOptions: {
      auto ptr = reinterpret_cast<Pool2DOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_SVDFOptions: {
      auto ptr = reinterpret_cast<SVDFOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_RNNOptions: {
      auto ptr = reinterpret_cast<RNNOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_FullyConnectedOptions: {
      auto ptr = reinterpret_cast<FullyConnectedOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_SoftmaxOptions: {
      auto ptr = reinterpret_cast<SoftmaxOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_ConcatenationOptions: {
      auto ptr = reinterpret_cast<ConcatenationOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_AddOptions: {
      auto ptr = reinterpret_cast<AddOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_L2NormOptions: {
      auto ptr = reinterpret_cast<L2NormOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_LocalResponseNormalizationOptions: {
      auto ptr = reinterpret_cast<LocalResponseNormalizationOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_LSTMOptions: {
      auto ptr = reinterpret_cast<LSTMOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_ResizeBilinearOptions: {
      auto ptr = reinterpret_cast<ResizeBilinearOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_CallOptions: {
      auto ptr = reinterpret_cast<CallOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_ReshapeOptions: {
      auto ptr = reinterpret_cast<ReshapeOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_SkipGramOptions: {
      auto ptr = reinterpret_cast<SkipGramOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_SpaceToDepthOptions: {
      auto ptr = reinterpret_cast<SpaceToDepthOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_EmbeddingLookupSparseOptions: {
      auto ptr = reinterpret_cast<EmbeddingLookupSparseOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_MulOptions: {
      auto ptr = reinterpret_cast<MulOptionsT *>(value);
      delete ptr;
      break;
    }
    case BuiltinOptions_PadOptions: {
      auto ptr = reinterpret_cast<PadOptionsT *>(value);
      delete ptr;
      break;
    }
    default:
      break;
  }
  value = nullptr;
  type = BuiltinOptions_NONE;
}

inline const tflite::Model *GetModel(const void *buf) {
  return flatbuffers::GetRoot<tflite::Model>(buf);
}

inline const char *ModelIdentifier() { return "TFL3"; }

inline bool ModelBufferHasIdentifier(const void *buf) {
  return flatbuffers::BufferHasIdentifier(buf, ModelIdentifier());
}

inline bool VerifyModelBuffer(flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<tflite::Model>(ModelIdentifier());
}

inline const char *ModelExtension() { return "tflite"; }

inline void FinishModelBuffer(flatbuffers::FlatBufferBuilder &fbb,
                              flatbuffers::Offset<tflite::Model> root) {
  fbb.Finish(root, ModelIdentifier());
}

inline std::unique_ptr<ModelT> UnPackModel(
    const void *buf, const flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<ModelT>(GetModel(buf)->UnPack(res));
}

}  // namespace tflite

#endif  // FLATBUFFERS_GENERATED_SCHEMA_TFLITE_H_
