(function (root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(factory);
	} else {
		root.sampleData = factory();
	}
}(this, function () {
	return {
		"geonames": [{
			"fcodeName": "capital of a political entity",
			"toponymName": "Mexico City",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Mexico City",
			"wikipedia": "",
			"lng": -99.12766456604,
			"fcode": "PPLC",
			"geonameId": 3530597,
			"lat": 19.428472427036,
			"population": 12294193
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Manila",
			"countrycode": "PH",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Manila",
			"wikipedia": "",
			"lng": 120.9822,
			"fcode": "PPLC",
			"geonameId": 1701668,
			"lat": 14.6042,
			"population": 10444527
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Dhaka",
			"countrycode": "BD",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Dhaka",
			"wikipedia": "",
			"lng": 90.40743827819824,
			"fcode": "PPLC",
			"geonameId": 1185241,
			"lat": 23.710395616597037,
			"population": 10356500
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Seoul",
			"countrycode": "KR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Seoul",
			"wikipedia": "",
			"lng": 126.977834701538,
			"fcode": "PPLC",
			"geonameId": 1835848,
			"lat": 37.5682561388953,
			"population": 10349312
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Jakarta",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Jakarta",
			"wikipedia": "",
			"lng": 106.84513092041016,
			"fcode": "PPLC",
			"geonameId": 1642911,
			"lat": -6.214623197035775,
			"population": 8540121
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Tokyo",
			"countrycode": "JP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Tokyo",
			"wikipedia": "",
			"lng": 139.69171,
			"fcode": "PPLC",
			"geonameId": 1850147,
			"lat": 35.6895,
			"population": 8336599
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Taipei",
			"countrycode": "TW",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Taipei",
			"wikipedia": "",
			"lng": 121.531846,
			"fcode": "PPLC",
			"geonameId": 1668341,
			"lat": 25.047763,
			"population": 7871900
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Beijing",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Beijing",
			"wikipedia": "",
			"lng": 116.397228240967,
			"fcode": "PPLC",
			"geonameId": 1816670,
			"lat": 39.9074977414405,
			"population": 7480601
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Bogotá",
			"countrycode": "CO",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Bogotá",
			"wikipedia": "",
			"lng": -74.08175468444824,
			"fcode": "PPLC",
			"geonameId": 3688689,
			"lat": 4.609705849789108,
			"population": 7102602
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Hong Kong",
			"countrycode": "HK",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hong Kong",
			"wikipedia": "",
			"lng": 114.157691001892,
			"fcode": "PPLC",
			"geonameId": 1819729,
			"lat": 22.2855225817732,
			"population": 7012738
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Bangkok",
			"countrycode": "TH",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "The City of Angels",
			"wikipedia": "",
			"lng": 100.501444,
			"fcode": "PPLC",
			"geonameId": 1609350,
			"lat": 13.753979,
			"population": 5104476
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Singapore",
			"countrycode": "SG",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Singapore",
			"wikipedia": "",
			"lng": 103.850069046021,
			"fcode": "PPLC",
			"geonameId": 1880252,
			"lat": 1.28966883937733,
			"population": 3547809
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Pyongyang",
			"countrycode": "KP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Pyongyang",
			"wikipedia": "",
			"lng": 125.75431823730469,
			"fcode": "PPLC",
			"geonameId": 1871859,
			"lat": 39.033852842708576,
			"population": 3222000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Kabul",
			"countrycode": "AF",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kabul",
			"wikipedia": "",
			"lng": 69.17232513427734,
			"fcode": "PPLC",
			"geonameId": 1138958,
			"lat": 34.52812640463504,
			"population": 3043532
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Caracas",
			"countrycode": "VE",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Caracas",
			"wikipedia": "",
			"lng": -66.879193,
			"fcode": "PPLC",
			"geonameId": 3646738,
			"lat": 10.488011,
			"population": 3000000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Santo Domingo",
			"countrycode": "DO",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Santo Domingo",
			"wikipedia": "",
			"lng": -69.98857498168945,
			"fcode": "PPLC",
			"geonameId": 3492908,
			"lat": 18.50012187792744,
			"population": 2201941
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Havana",
			"countrycode": "CU",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Havana",
			"wikipedia": "",
			"lng": -82.38304138183594,
			"fcode": "PPLC",
			"geonameId": 3553478,
			"lat": 23.133019745980196,
			"population": 2163824
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Tashkent",
			"countrycode": "UZ",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Tashkent",
			"wikipedia": "",
			"lng": 69.21627044677734,
			"fcode": "PPLC",
			"geonameId": 1512569,
			"lat": 41.26464643600054,
			"population": 1978028
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Phnom Penh",
			"countrycode": "KH",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Phnom Penh",
			"wikipedia": "",
			"lng": 104.916006,
			"fcode": "PPLC",
			"geonameId": 1821306,
			"lat": 11.56245,
			"population": 1573544
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Kuala Lumpur",
			"countrycode": "MY",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kuala Lumpur",
			"wikipedia": "",
			"lng": 101.686534881592,
			"fcode": "PPLC",
			"geonameId": 1735161,
			"lat": 3.14120171804761,
			"population": 1453975
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Kathmandu",
			"countrycode": "NP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kathmandu",
			"wikipedia": "",
			"lng": 85.32059669494629,
			"fcode": "PPLC",
			"geonameId": 1283240,
			"lat": 27.701691866145573,
			"population": 1442271
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Hà Nội",
			"countrycode": "VN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hanoi",
			"wikipedia": "",
			"lng": 105.8411693572998,
			"fcode": "PPLC",
			"geonameId": 1581130,
			"lat": 21.02450477127423,
			"population": 1431270
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Quito",
			"countrycode": "EC",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Quito",
			"wikipedia": "",
			"lng": -78.52495193481445,
			"fcode": "PPLC",
			"geonameId": 3652462,
			"lat": -0.2298539672002563,
			"population": 1399814
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Guatemala City",
			"countrycode": "GT",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Guatemala City",
			"wikipedia": "",
			"lng": -90.51326751708984,
			"fcode": "PPLC",
			"geonameId": 3598132,
			"lat": 14.640724984903278,
			"population": 994938
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Managua",
			"countrycode": "NI",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Managua",
			"wikipedia": "",
			"lng": -86.25040054321289,
			"fcode": "PPLC",
			"geonameId": 3617763,
			"lat": 12.13281653939173,
			"population": 973087
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Nay Pyi Taw",
			"countrycode": "MM",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Nay Pyi Taw",
			"wikipedia": "",
			"lng": 96.129722,
			"fcode": "PPLC",
			"geonameId": 6611854,
			"lat": 19.745,
			"population": 925000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Bishkek",
			"countrycode": "KG",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Bishkek",
			"wikipedia": "",
			"lng": 74.59,
			"fcode": "PPLC",
			"geonameId": 1528675,
			"lat": 42.87,
			"population": 900000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Muscat",
			"countrycode": "OM",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Muscat",
			"wikipedia": "",
			"lng": 58.5922,
			"fcode": "PPLC",
			"geonameId": 287286,
			"lat": 23.613874,
			"population": 797000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Ashgabat",
			"countrycode": "TM",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ashgabat",
			"wikipedia": "",
			"lng": 58.3833333,
			"fcode": "PPLC",
			"geonameId": 162183,
			"lat": 37.95,
			"population": 727700
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Colombo",
			"countrycode": "LK",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Colombo",
			"wikipedia": "",
			"lng": 79.8477778,
			"fcode": "PPLC",
			"geonameId": 1248991,
			"lat": 6.9319444,
			"population": 648034
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Washington, D. C.",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Washington",
			"wikipedia": "",
			"lng": -77.0363658,
			"fcode": "PPLC",
			"geonameId": 4140963,
			"lat": 38.8951118,
			"population": 601723
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Dushanbe",
			"countrycode": "TJ",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Dushanbe",
			"wikipedia": "",
			"lng": 68.77904891967773,
			"fcode": "PPLC",
			"geonameId": 1221874,
			"lat": 38.5357458822238,
			"population": 543107
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Panamá",
			"countrycode": "PA",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Panama City",
			"wikipedia": "",
			"lng": -79.51972961425781,
			"fcode": "PPLC",
			"geonameId": 3703443,
			"lat": 8.99360046428003,
			"population": 408168
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "New Delhi",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "New Delhi",
			"wikipedia": "",
			"lng": 77.22444534301758,
			"fcode": "PPLC",
			"geonameId": 1261481,
			"lat": 28.635760131498763,
			"population": 317797
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Georgetown",
			"countrycode": "GY",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Georgetown",
			"wikipedia": "",
			"lng": -58.155269622802734,
			"fcode": "PPLC",
			"geonameId": 3378644,
			"lat": 6.804483851419782,
			"population": 235017
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Nassau",
			"countrycode": "BS",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Nassau",
			"wikipedia": "",
			"lng": -77.34306335449219,
			"fcode": "PPLC",
			"geonameId": 3571824,
			"lat": 25.05823320992254,
			"population": 227940
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Vientiane",
			"countrycode": "LA",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Vientiane",
			"wikipedia": "",
			"lng": 102.6,
			"fcode": "PPLC",
			"geonameId": 1651944,
			"lat": 17.966667,
			"population": 196731
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Dili",
			"countrycode": "TL",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Dili",
			"wikipedia": "",
			"lng": 125.5736111,
			"fcode": "PPLC",
			"geonameId": 1645457,
			"lat": -8.5586111,
			"population": 150000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Willemstad",
			"countrycode": "CW",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Willemstad",
			"wikipedia": "",
			"lng": -68.9335441589355,
			"fcode": "PPLC",
			"geonameId": 3513090,
			"lat": 12.1083965959225,
			"population": 125000
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Praia",
			"countrycode": "CV",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Praia",
			"wikipedia": "",
			"lng": -23.512544631958008,
			"fcode": "PPLC",
			"geonameId": 3374333,
			"lat": 14.931516073431668,
			"population": 113364
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Male",
			"countrycode": "MV",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Malé",
			"wikipedia": "",
			"lng": 73.5088777542114,
			"fcode": "PPLC",
			"geonameId": 1282027,
			"lat": 4.17479639013428,
			"population": 103693
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Bridgetown",
			"countrycode": "BB",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Bridgetown",
			"wikipedia": "",
			"lng": -59.6166667,
			"fcode": "PPLC",
			"geonameId": 3374036,
			"lat": 13.1,
			"population": 98511
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Fort-de-France",
			"countrycode": "MQ",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Fort-de-France",
			"wikipedia": "",
			"lng": -61.073341369628906,
			"fcode": "PPLC",
			"geonameId": 3570675,
			"lat": 14.608916925759976,
			"population": 89995
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Bandar Seri Begawan",
			"countrycode": "BN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Bandar Seri Begawan",
			"wikipedia": "",
			"lng": 114.94806289672852,
			"fcode": "PPLC",
			"geonameId": 1820906,
			"lat": 4.94028963405338,
			"population": 64409
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Cayenne",
			"countrycode": "GF",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Cayenne",
			"wikipedia": "",
			"lng": -52.333333,
			"fcode": "PPLC",
			"geonameId": 3382160,
			"lat": 4.933333,
			"population": 61550
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Saipan",
			"countrycode": "MP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Saipan",
			"wikipedia": "",
			"lng": 145.7544994354248,
			"fcode": "PPLC",
			"geonameId": 7828758,
			"lat": 15.212327568734572,
			"population": 48220
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Tarawa",
			"countrycode": "KI",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Tarawa",
			"wikipedia": "",
			"lng": 172.97695755958557,
			"fcode": "PPLC",
			"geonameId": 2110257,
			"lat": 1.3277999013685535,
			"population": 40311
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "George Town",
			"countrycode": "KY",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "George Town",
			"wikipedia": "",
			"lng": -81.36706352233887,
			"fcode": "PPLC",
			"geonameId": 3580661,
			"lat": 19.28692209354407,
			"population": 29370
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Majuro",
			"countrycode": "MH",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Majuro",
			"wikipedia": "",
			"lng": 171.380270719528,
			"fcode": "PPLC",
			"geonameId": 2113779,
			"lat": 7.08971365952458,
			"population": 25400
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Saint John’s",
			"countrycode": "AG",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "St. John's",
			"wikipedia": "",
			"lng": -61.85,
			"fcode": "PPLC",
			"geonameId": 3576022,
			"lat": 17.116667,
			"population": 24226
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Victoria",
			"countrycode": "SC",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Victoria",
			"wikipedia": "",
			"lng": 55.45,
			"fcode": "PPLC",
			"geonameId": 241131,
			"lat": -4.6166667,
			"population": 22881
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Belmopan",
			"countrycode": "BZ",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Belmopan",
			"wikipedia": "",
			"lng": -88.7666667,
			"fcode": "PPLC",
			"geonameId": 3582672,
			"lat": 17.25,
			"population": 13381
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Funafuti",
			"countrycode": "TV",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Funafuti",
			"wikipedia": "",
			"lng": 179.19417321682,
			"fcode": "PPLC",
			"geonameId": 2110394,
			"lat": -8.52424963509738,
			"population": 4492
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Cockburn Town",
			"countrycode": "TC",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Cockburn Town",
			"wikipedia": "",
			"lng": -71.141881942749,
			"fcode": "PPLC",
			"geonameId": 3576994,
			"lat": 21.4612165856583,
			"population": 3720
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Hagåtña",
			"countrycode": "GU",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hagåtña",
			"wikipedia": "",
			"lng": 144.748858809471,
			"fcode": "PPLC",
			"geonameId": 4044012,
			"lat": 13.4756693518442,
			"population": 1051
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Hamilton",
			"countrycode": "BM",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hamilton",
			"wikipedia": "",
			"lng": -64.7779655456543,
			"fcode": "PPLC",
			"geonameId": 3573197,
			"lat": 32.2914861102988,
			"population": 902
		}, {
			"fcodeName": "capital of a political entity",
			"toponymName": "Melekeok",
			"countrycode": "PW",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Melekeok",
			"wikipedia": "",
			"lng": 134.623546600342,
			"fcode": "PPLC",
			"geonameId": 7303944,
			"lat": 7.50042971665144,
			"population": 0
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Shanghai",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Shanghai",
			"wikipedia": "",
			"lng": 121.4580556,
			"fcode": "PPLA",
			"geonameId": 1796236,
			"lat": 31.2222222,
			"population": 14608512
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Mumbai",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Mumbai",
			"wikipedia": "",
			"lng": 72.88261413574219,
			"fcode": "PPLA",
			"geonameId": 1275339,
			"lat": 19.07282592774,
			"population": 12691836
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Karachi",
			"countrycode": "PK",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Karanchi",
			"wikipedia": "",
			"lng": 67.0822,
			"fcode": "PPLA",
			"geonameId": 1174872,
			"lat": 24.9056,
			"population": 11624219
		}, {
			"fcodeName": "populated place",
			"toponymName": "Zhumadian",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Zhumadian",
			"wikipedia": "",
			"lng": 114.0294444,
			"fcode": "PPL",
			"geonameId": 1783873,
			"lat": 32.9794444,
			"population": 8263100
		}, {
			"fcodeName": "populated place",
			"toponymName": "New York City",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "New York",
			"wikipedia": "",
			"lng": -74.0059729,
			"fcode": "PPL",
			"geonameId": 5128581,
			"lat": 40.7142691,
			"population": 8175133
		}, {
			"fcodeName": "seat of a third-order administrative division",
			"toponymName": "Nanchong",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Nanchong",
			"wikipedia": "",
			"lng": 106.084735,
			"fcode": "PPLA3",
			"geonameId": 1800146,
			"lat": 30.795075,
			"population": 7150000
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Lahore",
			"countrycode": "PK",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Lahore",
			"wikipedia": "",
			"lng": 74.343611,
			"fcode": "PPLA",
			"geonameId": 1172451,
			"lat": 31.549722,
			"population": 6310888
		}, {
			"fcodeName": "populated place",
			"toponymName": "Tai’an",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Tai’an",
			"wikipedia": "",
			"lng": 117.12,
			"fcode": "PPL",
			"geonameId": 1793724,
			"lat": 36.185278,
			"population": 5499000
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Bangalore",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Bangalore",
			"wikipedia": "",
			"lng": 77.59368896484375,
			"fcode": "PPLA",
			"geonameId": 1277333,
			"lat": 12.97194016928975,
			"population": 5104047
		}, {
			"fcodeName": "populated place",
			"toponymName": "Yueyang",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Yueyang",
			"wikipedia": "",
			"lng": 113.0919444,
			"fcode": "PPL",
			"geonameId": 1927639,
			"lat": 29.3333333,
			"population": 5000000
		}, {
			"fcodeName": "populated place",
			"toponymName": "Kaifeng",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kaifeng",
			"wikipedia": "",
			"lng": 114.30742263793945,
			"fcode": "PPL",
			"geonameId": 1804879,
			"lat": 34.79860431685418,
			"population": 4800000
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Toronto",
			"countrycode": "CA",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Toronto",
			"wikipedia": "",
			"lng": -79.416304194,
			"fcode": "PPLA",
			"geonameId": 6167865,
			"lat": 43.700113788,
			"population": 4612191
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Rangoon",
			"countrycode": "MM",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Yangon",
			"wikipedia": "",
			"lng": 96.1561111,
			"fcode": "PPLA",
			"geonameId": 1298824,
			"lat": 16.8052778,
			"population": 4477638
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Chittagong",
			"countrycode": "BD",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Chittagong",
			"wikipedia": "",
			"lng": 91.831685,
			"fcode": "PPLA",
			"geonameId": 1205733,
			"lat": 22.338396,
			"population": 3920222
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Los Angeles",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Los Angeles",
			"wikipedia": "",
			"lng": -118.2436849,
			"fcode": "PPLA2",
			"geonameId": 5368361,
			"lat": 34.0522342,
			"population": 3792621
		}, {
			"fcodeName": "populated place",
			"toponymName": "Ahmadābād",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ahmedabad",
			"wikipedia": "",
			"lng": 72.6166667,
			"fcode": "PPL",
			"geonameId": 1279233,
			"lat": 23.0333333,
			"population": 3719710
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Busan",
			"countrycode": "KR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Busan",
			"wikipedia": "",
			"lng": 129.040278,
			"fcode": "PPLA",
			"geonameId": 1838524,
			"lat": 35.102778,
			"population": 3678555
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Hyderābād",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hyderabad",
			"wikipedia": "",
			"lng": 78.4744444,
			"fcode": "PPLA",
			"geonameId": 1269843,
			"lat": 17.3752778,
			"population": 3597816
		}, {
			"fcodeName": "populated place",
			"toponymName": "Puyang",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Puyang",
			"wikipedia": "",
			"lng": 119.8861111,
			"fcode": "PPL",
			"geonameId": 1798425,
			"lat": 29.4602778,
			"population": 3590000
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Shenyang",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Shenyang",
			"wikipedia": "",
			"lng": 123.4327778,
			"fcode": "PPLA",
			"geonameId": 2034937,
			"lat": 41.7922222,
			"population": 3512192
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Lanzhou",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Lanzhou",
			"wikipedia": "",
			"lng": 103.7922222,
			"fcode": "PPLA",
			"geonameId": 1804430,
			"lat": 36.0563889,
			"population": 3200000
		}, {
			"fcodeName": "populated place",
			"toponymName": "Sūrat",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Surat",
			"wikipedia": "",
			"lng": 72.8333333,
			"fcode": "PPL",
			"geonameId": 1255364,
			"lat": 21.1666667,
			"population": 2894504
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Taiyuan",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Taiyuan",
			"wikipedia": "",
			"lng": 112.5602778,
			"fcode": "PPLA",
			"geonameId": 1793511,
			"lat": 37.8694444,
			"population": 2722475
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Jaipur",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Jaipur",
			"wikipedia": "",
			"lng": 75.78781127929688,
			"fcode": "PPLA",
			"geonameId": 1269515,
			"lat": 26.9196209739275,
			"population": 2711758
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Chicago",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Chicago",
			"wikipedia": "",
			"lng": -87.6500523,
			"fcode": "PPLA2",
			"geonameId": 4887398,
			"lat": 41.850033,
			"population": 2695598
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Changchun",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Changchun",
			"wikipedia": "",
			"lng": 125.3227778,
			"fcode": "PPLA",
			"geonameId": 2038180,
			"lat": 43.88,
			"population": 2537421
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Fortaleza",
			"countrycode": "BR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Fortaleza",
			"wikipedia": "",
			"lng": -38.54305556,
			"fcode": "PPLA",
			"geonameId": 3399415,
			"lat": -3.717222222,
			"population": 2400000
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Surabaya",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Surabaya",
			"wikipedia": "",
			"lng": 112.7508333,
			"fcode": "PPLA",
			"geonameId": 1625822,
			"lat": -7.2491667,
			"population": 2374658
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Mashhad",
			"countrycode": "IR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Mashhad",
			"wikipedia": "",
			"lng": 59.6062,
			"fcode": "PPLA",
			"geonameId": 124665,
			"lat": 36.297,
			"population": 2307177
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Nāgpur",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Nagpur",
			"wikipedia": "",
			"lng": 79.1,
			"fcode": "PPLA2",
			"geonameId": 1262180,
			"lat": 21.15,
			"population": 2228018
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Houston",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Houston",
			"wikipedia": "",
			"lng": -95.3632715,
			"fcode": "PPLA2",
			"geonameId": 4699066,
			"lat": 29.7632836,
			"population": 2099451
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Medellín",
			"countrycode": "CO",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Medellín",
			"wikipedia": "",
			"lng": -75.563591,
			"fcode": "PPLA",
			"geonameId": 3674962,
			"lat": 6.25184,
			"population": 1999979
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Guayaquil",
			"countrycode": "EC",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Guayaquil",
			"wikipedia": "",
			"lng": -79.9,
			"fcode": "PPLA",
			"geonameId": 3657509,
			"lat": -2.1666667,
			"population": 1952029
		}, {
			"fcodeName": "populated place",
			"toponymName": "Ordos",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ordos",
			"wikipedia": "",
			"lng": 109.78157043457031,
			"fcode": "PPL",
			"geonameId": 8347664,
			"lat": 39.60859776020064,
			"population": 1940653
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Sapporo-shi",
			"countrycode": "JP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Sapporo",
			"wikipedia": "",
			"lng": 141.346945,
			"fcode": "PPLA",
			"geonameId": 2128295,
			"lat": 43.064167,
			"population": 1883027
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Patna",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Patna",
			"wikipedia": "",
			"lng": 85.1166667,
			"fcode": "PPLA",
			"geonameId": 1260086,
			"lat": 25.6,
			"population": 1599920
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Manaus",
			"countrycode": "BR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Manaus",
			"wikipedia": "",
			"lng": -60.025,
			"fcode": "PPLA",
			"geonameId": 3663517,
			"lat": -3.101944444,
			"population": 1598210
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Urunchi",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ürümqi",
			"wikipedia": "",
			"lng": 87.600459,
			"fcode": "PPLA",
			"geonameId": 1529102,
			"lat": 43.800965,
			"population": 1508225
		}, {
			"fcodeName": "populated place",
			"toponymName": "Ciudad Juárez",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ciudad Juárez",
			"wikipedia": "",
			"lng": -106.483333,
			"fcode": "PPL",
			"geonameId": 4013708,
			"lat": 31.733333,
			"population": 1512354
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Recife",
			"countrycode": "BR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Recife",
			"wikipedia": "",
			"lng": -34.88111111,
			"fcode": "PPLA",
			"geonameId": 3390760,
			"lat": -8.053888889,
			"population": 1478098
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Kyoto",
			"countrycode": "JP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kyoto",
			"wikipedia": "",
			"lng": 135.75385093689,
			"fcode": "PPLA",
			"geonameId": 1857910,
			"lat": 35.02106999142,
			"population": 1459640
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Palembang",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Palembang",
			"wikipedia": "",
			"lng": 104.745798110962,
			"fcode": "PPLA",
			"geonameId": 1633070,
			"lat": -2.91672533277337,
			"population": 1441500
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Multān",
			"countrycode": "PK",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Multan",
			"wikipedia": "",
			"lng": 71.475278,
			"fcode": "PPLA2",
			"geonameId": 1169825,
			"lat": 30.195556,
			"population": 1437230
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Belém",
			"countrycode": "BR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Belém",
			"wikipedia": "",
			"lng": -48.50444444,
			"fcode": "PPLA",
			"geonameId": 3405870,
			"lat": -1.455833333,
			"population": 1407737
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Fukuoka-shi",
			"countrycode": "JP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Fukuoka",
			"wikipedia": "",
			"lng": 130.418056,
			"fcode": "PPLA",
			"geonameId": 1863967,
			"lat": 33.606389,
			"population": 1392289
		}, {
			"fcodeName": "populated place",
			"toponymName": "Tijuana",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Tijuana",
			"wikipedia": "",
			"lng": -117.003714,
			"fcode": "PPL",
			"geonameId": 3981609,
			"lat": 32.502698,
			"population": 1376457
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Makassar",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Makassar",
			"wikipedia": "",
			"lng": 119.4221,
			"fcode": "PPLA",
			"geonameId": 1622786,
			"lat": -5.14,
			"population": 1321717
		}, {
			"fcodeName": "populated place",
			"toponymName": "Budta",
			"countrycode": "PH",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Budta",
			"wikipedia": "",
			"lng": 124.4397222,
			"fcode": "PPL",
			"geonameId": 1723510,
			"lat": 7.2041667,
			"population": 1273715
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Dallas",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Dallas",
			"wikipedia": "",
			"lng": -96.8066667,
			"fcode": "PPLA2",
			"geonameId": 4684888,
			"lat": 32.7830556,
			"population": 1197816
		}, {
			"fcodeName": "populated place",
			"toponymName": "Gustavo A. Madero",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Gustavo A. Madero",
			"wikipedia": "",
			"lng": -98.7666667,
			"fcode": "PPL",
			"geonameId": 3482969,
			"lat": 22.8333333,
			"population": 1185772
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Guiyang",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Guiyang",
			"wikipedia": "",
			"lng": 106.7166667,
			"fcode": "PPLA",
			"geonameId": 1809461,
			"lat": 26.5833333,
			"population": 1171633
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Dubai",
			"countrycode": "AE",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Dubai",
			"wikipedia": "",
			"lng": 55.304717,
			"fcode": "PPLA",
			"geonameId": 292223,
			"lat": 25.258172,
			"population": 1137347
		}, {
			"fcodeName": "populated place",
			"toponymName": "Dayan",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Lijiang City",
			"wikipedia": "",
			"lng": 100.220718383789,
			"fcode": "PPL",
			"geonameId": 1813253,
			"lat": 26.8687934220524,
			"population": 1137600
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Monterrey",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Monterrey",
			"wikipedia": "",
			"lng": -100.3166667,
			"fcode": "PPLA",
			"geonameId": 3995465,
			"lat": 25.6666667,
			"population": 1122874
		}, {
			"fcodeName": "populated place",
			"toponymName": "León",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "León",
			"wikipedia": "",
			"lng": -101.6666667,
			"fcode": "PPL",
			"geonameId": 3998655,
			"lat": 21.1166667,
			"population": 1114626
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Sendai-shi",
			"countrycode": "JP",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Sendai-shi",
			"wikipedia": "",
			"lng": 140.871945,
			"fcode": "PPLA",
			"geonameId": 2111149,
			"lat": 38.268889,
			"population": 1037562
		}, {
			"fcodeName": "populated place",
			"toponymName": "Teni",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Theni",
			"wikipedia": "",
			"lng": 77.4833333,
			"fcode": "PPL",
			"geonameId": 1254745,
			"lat": 10,
			"population": 1034724
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Kunming",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kunming",
			"wikipedia": "",
			"lng": 102.7183333,
			"fcode": "PPLA",
			"geonameId": 1804651,
			"lat": 25.0388889,
			"population": 1023674
		}, {
			"fcodeName": "populated place",
			"toponymName": "Jabalpur",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Jabalpur",
			"wikipedia": "",
			"lng": 79.9500632286072,
			"fcode": "PPL",
			"geonameId": 1269633,
			"lat": 23.1669748590236,
			"population": 1030168
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Srīnagar",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Srinagar",
			"wikipedia": "",
			"lng": 74.802222,
			"fcode": "PPLA",
			"geonameId": 1255634,
			"lat": 34.092222,
			"population": 975857
		}, {
			"fcodeName": "populated place",
			"toponymName": "Cartagena",
			"countrycode": "CO",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Cartagena",
			"wikipedia": "",
			"lng": -75.5144444,
			"fcode": "PPL",
			"geonameId": 3687238,
			"lat": 10.3997222,
			"population": 952024
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "San Jose",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "San Jose",
			"wikipedia": "",
			"lng": -121.8949555,
			"fcode": "PPLA2",
			"geonameId": 5392171,
			"lat": 37.3393857,
			"population": 945942
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Mamuju",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Mamuju",
			"wikipedia": "",
			"lng": 118.8885,
			"fcode": "PPLA",
			"geonameId": 1636556,
			"lat": -2.6748,
			"population": 938254
		}, {
			"fcodeName": "populated place",
			"toponymName": "Guwāhāti",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Guwahati",
			"wikipedia": "",
			"lng": 91.75094604492188,
			"fcode": "PPL",
			"geonameId": 1271476,
			"lat": 26.186173577496323,
			"population": 899094
		}, {
			"fcodeName": "populated place",
			"toponymName": "Wenzhou",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Wenzhou",
			"wikipedia": "",
			"lng": 120.66682,
			"fcode": "PPL",
			"geonameId": 1791388,
			"lat": 27.999416,
			"population": 865672
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Padang",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Padang",
			"wikipedia": "",
			"lng": 100.354270935059,
			"fcode": "PPLA",
			"geonameId": 1633419,
			"lat": -0.949243986848526,
			"population": 840352
		}, {
			"fcodeName": "populated place",
			"toponymName": "Hubli",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hubli",
			"wikipedia": "",
			"lng": 75.13378143310547,
			"fcode": "PPL",
			"geonameId": 1269920,
			"lat": 15.34776192434695,
			"population": 840214
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Jacksonville",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Jacksonville",
			"wikipedia": "",
			"lng": -81.655651,
			"fcode": "PPLA2",
			"geonameId": 4160021,
			"lat": 30.3321838,
			"population": 821784
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Cebu City",
			"countrycode": "PH",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Cebu City",
			"wikipedia": "",
			"lng": 123.890708684921,
			"fcode": "PPLA",
			"geonameId": 1717512,
			"lat": 10.3167216222722,
			"population": 798634
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Thiruvananthapuram",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Thiruvananthapuram",
			"wikipedia": "",
			"lng": 76.956944,
			"fcode": "PPLA",
			"geonameId": 1254163,
			"lat": 8.506944,
			"population": 784153
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Natal",
			"countrycode": "BR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Natal",
			"wikipedia": "",
			"lng": -35.20944444,
			"fcode": "PPLA",
			"geonameId": 3394023,
			"lat": -5.795,
			"population": 763043
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Tainan",
			"countrycode": "TW",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Tainan",
			"wikipedia": "",
			"lng": 120.213333,
			"fcode": "PPLA2",
			"geonameId": 1668355,
			"lat": 22.990833,
			"population": 771235
		}, {
			"fcodeName": "populated place",
			"toponymName": "Kota",
			"countrycode": "IN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Kota",
			"wikipedia": "",
			"lng": 75.8333333,
			"fcode": "PPL",
			"geonameId": 1266049,
			"lat": 25.1833333,
			"population": 763088
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Turan",
			"countrycode": "VN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Da Nang",
			"wikipedia": "",
			"lng": 108.220833,
			"fcode": "PPLA",
			"geonameId": 1583992,
			"lat": 16.067778,
			"population": 752493
		}, {
			"fcodeName": "populated place",
			"toponymName": "Hengyang",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Hengyang",
			"wikipedia": "",
			"lng": 112.615,
			"fcode": "PPL",
			"geonameId": 1808370,
			"lat": 26.8880556,
			"population": 759602
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Trujillo",
			"countrycode": "PE",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Trujillo",
			"wikipedia": "",
			"lng": -79.0299797058105,
			"fcode": "PPLA",
			"geonameId": 3691175,
			"lat": -8.1159942774572,
			"population": 747450
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Teresina",
			"countrycode": "BR",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Teresina",
			"wikipedia": "",
			"lng": -42.80194444,
			"fcode": "PPLA",
			"geonameId": 3386496,
			"lat": -5.089166667,
			"population": 744512
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Ciudad Guayana",
			"countrycode": "VE",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ciudad Guayana",
			"wikipedia": "",
			"lng": -62.641023,
			"fcode": "PPLA2",
			"geonameId": 3645528,
			"lat": 8.351225,
			"population": 746535
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Charlotte",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Charlotte",
			"wikipedia": "",
			"lng": -80.8431268,
			"fcode": "PPLA2",
			"geonameId": 4460243,
			"lat": 35.2270869,
			"population": 731424
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Cúcuta",
			"countrycode": "CO",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Cúcuta",
			"wikipedia": "",
			"lng": -72.507821,
			"fcode": "PPLA",
			"geonameId": 3685533,
			"lat": 7.893907,
			"population": 721398
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Mérida",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Mérida",
			"wikipedia": "",
			"lng": -89.6166667,
			"fcode": "PPLA",
			"geonameId": 3523349,
			"lat": 20.9666667,
			"population": 717175
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Chihuahua",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Chihuahua",
			"wikipedia": "",
			"lng": -106.0833333,
			"fcode": "PPLA",
			"geonameId": 4014338,
			"lat": 28.6333333,
			"population": 708267
		}, {
			"fcodeName": "populated place",
			"toponymName": "City of Balikpapan",
			"countrycode": "ID",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "City of Balikpapan",
			"wikipedia": "",
			"lng": 116.8941879272461,
			"fcode": "PPL",
			"geonameId": 8224624,
			"lat": -1.2420444341467216,
			"population": 700000
		}, {
			"fcodeName": "populated place",
			"toponymName": "Zigong",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Zigong",
			"wikipedia": "",
			"lng": 104.776887,
			"fcode": "PPL",
			"geonameId": 1783745,
			"lat": 29.341622,
			"population": 689961
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Ipoh",
			"countrycode": "MY",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Ipoh",
			"wikipedia": "",
			"lng": 101.0829,
			"fcode": "PPLA",
			"geonameId": 1734634,
			"lat": 4.5841,
			"population": 673318
		}, {
			"fcodeName": "populated place",
			"toponymName": "Acapulco de Juárez",
			"countrycode": "MX",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Acapulco",
			"wikipedia": "",
			"lng": -99.89009857177734,
			"fcode": "PPL",
			"geonameId": 3533462,
			"lat": 16.863362389912385,
			"population": 652136
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Memphis",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Memphis",
			"wikipedia": "",
			"lng": -90.0489801,
			"fcode": "PPLA2",
			"geonameId": 4641239,
			"lat": 35.1495343,
			"population": 646889
		}, {
			"fcodeName": "seat of a second-order administrative division",
			"toponymName": "Shaoguan",
			"countrycode": "CN",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Shaoguan",
			"wikipedia": "",
			"lng": 113.5833333,
			"fcode": "PPLA2",
			"geonameId": 1795874,
			"lat": 24.8,
			"population": 628749
		}, {
			"fcodeName": "seat of a first-order administrative division",
			"toponymName": "Boston",
			"countrycode": "US",
			"fcl": "P",
			"fclName": "city, village,...",
			"name": "Boston",
			"wikipedia": "",
			"lng": -71.0597732,
			"fcode": "PPLA",
			"geonameId": 4930956,
			"lat": 42.3584308,
			"population": 617594
		}]
	};
}));
