/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.producer;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.tap4j.model.TestSet;
import org.tap4j.producer.Producer;
import org.tap4j.producer.ProducerException;
import org.tap4j.representer.Representer;
import org.tap4j.representer.RepresenterException;
import org.tap4j.representer.Tap13Representer;

public class TapProducer
implements Producer {
    private Representer representer;

    public TapProducer() {
        this.representer = new Tap13Representer();
    }

    public TapProducer(Representer representer) {
        this.representer = representer;
    }

    public String dump(TestSet testSet) {
        String dumpData = null;
        try {
            dumpData = this.representer.representData(testSet);
        }
        catch (RepresenterException re) {
            throw new ProducerException("Failed to produce test set dump: " + re.getMessage(), re);
        }
        return dumpData;
    }

    public void dump(TestSet testSet, Writer writer) {
        String tapStream = null;
        try {
            tapStream = this.dump(testSet);
        }
        catch (RepresenterException re) {
            throw new ProducerException("Failed to dump Test Set to writer: " + re.getMessage(), re);
        }
        try {
            writer.append(tapStream);
        }
        catch (IOException e) {
            throw new ProducerException("Failed to dump TAP Stream: " + e.getMessage(), e);
        }
    }

    public void dump(TestSet testSet, File output) {
        String tapStream = null;
        try {
            tapStream = this.dump(testSet);
        }
        catch (RepresenterException re) {
            throw new ProducerException("Failed to dump Test Set to output file '" + output + "': " + re.getMessage(), re);
        }
        try {
            FileUtils.writeStringToFile((File)output, (String)tapStream);
        }
        catch (IOException e) {
            throw new ProducerException("Failed to dump TAP Stream: " + e.getMessage(), e);
        }
    }

    public Representer getRepresenter() {
        return this.representer;
    }
}

