/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.parser;

import java.io.File;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.tap4j.model.BailOut;
import org.tap4j.model.Comment;
import org.tap4j.model.Directive;
import org.tap4j.model.Footer;
import org.tap4j.model.Header;
import org.tap4j.model.Plan;
import org.tap4j.model.SkipPlan;
import org.tap4j.model.TapElement;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.model.Text;
import org.tap4j.parser.Memento;
import org.tap4j.parser.Parser;
import org.tap4j.parser.ParserException;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;
import org.yaml.snakeyaml.Yaml;

public class Tap13YamlParser
implements Parser {
    protected static final Pattern INDENTANTION_PATTERN = Pattern.compile("((\\s|\\t)*)?.*");
    private TestSet testSet;
    private Stack<Memento> mementos = new Stack();
    private boolean firstLine;
    private boolean planBeforeTestResult;
    private boolean currentlyInYAML;
    private String lastLine = null;
    private TapElement lastParsedElement;
    private int baseIndentationLevel;
    private int currentIndentationLevel;
    private Yaml yaml;
    private StringBuilder diagnosticBuffer;

    public Tap13YamlParser() {
        this.init();
    }

    public final void init() {
        this.baseIndentationLevel = -1;
        this.currentIndentationLevel = -1;
        this.currentlyInYAML = Boolean.FALSE;
        this.diagnosticBuffer = new StringBuilder();
        this.lastParsedElement = null;
        this.firstLine = Boolean.TRUE;
        this.planBeforeTestResult = Boolean.FALSE;
        this.testSet = new TestSet();
        this.yaml = new Yaml();
    }

    private void saveMemento() {
        Memento memento = new Memento();
        memento.setBaseIndentationLevel(this.baseIndentationLevel);
        memento.setCurrentIndentationLevel(this.currentIndentationLevel);
        memento.setCurrentlyInYaml(this.currentlyInYAML);
        memento.setDiagnosticBuffer(this.diagnosticBuffer);
        memento.setLastParsedElement(this.lastParsedElement);
        memento.setFirstLine(this.firstLine);
        memento.setPlanBeforeTestResult(this.planBeforeTestResult);
        memento.setTestSet(this.testSet);
        this.mementos.push(memento);
    }

    private void loadMemento() {
        Memento memento = this.mementos.pop();
        this.baseIndentationLevel = memento.getBaseIndentationLevel();
        this.currentIndentationLevel = memento.getCurrentIndentationLevel();
        this.currentlyInYAML = memento.isCurrentlyInYaml();
        this.diagnosticBuffer = memento.getDiagnosticBuffer();
        this.lastParsedElement = memento.getLastParsedElement();
        this.firstLine = memento.isFirstLine();
        this.planBeforeTestResult = memento.isPlanBeforeTestResult();
        this.testSet = memento.getTestSet();
    }

    public TestSet getTestSet() {
        return this.testSet;
    }

    public void parseLine(String tapLine) {
        Matcher matcher = null;
        matcher = COMMENT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractComment(matcher);
            return;
        }
        this.lastLine = tapLine;
        if (this.isBaseIndentationAlreadyDefined() && (matcher = INDENTANTION_PATTERN.matcher(tapLine)).matches()) {
            int indentation;
            String spaces = matcher.group(1);
            this.currentIndentationLevel = indentation = spaces.length();
            if (indentation > this.baseIndentationLevel) {
                if (tapLine.trim().equals("---")) {
                    this.currentlyInYAML = true;
                    return;
                }
                if (tapLine.trim().equals("...")) {
                    this.currentlyInYAML = false;
                    return;
                }
                if (this.currentlyInYAML) {
                    this.appendTapLineToDiagnosticBuffer(tapLine);
                    return;
                }
                if (this.lastParsedElement instanceof TestResult) {
                    indentation = this.baseIndentationLevel;
                    TestResult lastTestResult = (TestResult)this.lastParsedElement;
                    TestSet newTestSet = new TestSet();
                    lastTestResult.setSubtest(newTestSet);
                    this.saveMemento();
                    this.init();
                    this.testSet = newTestSet;
                }
            }
            this.checkIndentationLevel(indentation, tapLine);
        }
        this.checkAndParseTapDiagnostic();
        matcher = HEADER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.setIndentationLevelIfNotDefined(tapLine);
            this.currentIndentationLevel = this.baseIndentationLevel;
            this.checkTAPHeaderParsingLocationAndDuplicity();
            this.extractHeader(matcher);
            this.firstLine = false;
            this.lastParsedElement = this.testSet.getHeader();
            return;
        }
        matcher = PLAN_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPPlanDuplicity();
            this.checkIfTAPPlanIsSetBeforeTestResultsOrBailOut();
            this.setIndentationLevelIfNotDefined(tapLine);
            this.extractPlan(matcher);
            this.firstLine = false;
            this.lastParsedElement = this.testSet.getPlan();
            return;
        }
        matcher = TEST_RESULT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.setIndentationLevelIfNotDefined(tapLine);
            this.extractTestResult(matcher);
            this.lastParsedElement = this.testSet.getTapLines().get(this.testSet.getTapLines().size() - 1);
            return;
        }
        matcher = BAIL_OUT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.setIndentationLevelIfNotDefined(tapLine);
            this.extractBailOut(matcher);
            this.lastParsedElement = this.testSet.getTapLines().get(this.testSet.getTapLines().size() - 1);
            return;
        }
        matcher = FOOTER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractFooter(matcher);
            this.lastParsedElement = this.testSet.getFooter();
            return;
        }
        Text text = new Text(tapLine);
        this.lastParsedElement = text;
        this.testSet.addTapLine(text);
    }

    protected void checkIfTAPPlanIsSetBeforeTestResultsOrBailOut() {
        if (this.testSet.getTestResults().size() <= 0 && this.testSet.getBailOuts().size() <= 0) {
            this.planBeforeTestResult = true;
        }
    }

    protected void checkTAPHeaderParsingLocationAndDuplicity() {
        if (this.testSet.getHeader() != null) {
            throw new ParserException("Duplicated TAP Header found.");
        }
        if (!this.firstLine) {
            throw new ParserException("Invalid position of TAP Header. It must be the first element (apart of Comments) in the TAP Stream.");
        }
    }

    protected void checkTAPPlanDuplicity() {
        if (this.testSet.getPlan() != null) {
            throw new ParserException("Duplicated TAP Plan found.");
        }
    }

    protected void checkTAPPlanPosition() {
        if (!this.planBeforeTestResult) {
            Matcher matcher = PLAN_PATTERN.matcher(this.lastLine);
            if (matcher.matches()) {
                return;
            }
            throw new ParserException("Invalid position of TAP Plan.");
        }
    }

    protected void checkTAPPlanIsSet() {
        if (this.testSet.getPlan() == null) {
            throw new ParserException("Missing TAP Plan.");
        }
    }

    protected void extractHeader(Matcher matcher) {
        Integer version = Integer.parseInt(matcher.group(1));
        Header header = new Header(version);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            header.setComment(comment);
        }
        this.testSet.setHeader(header);
    }

    protected void extractPlan(Matcher matcher) {
        String commentToken;
        Integer initialTest = Integer.parseInt(matcher.group(1));
        Integer lastTest = Integer.parseInt(matcher.group(3));
        Plan plan = null;
        plan = new Plan(initialTest, lastTest);
        String skipToken = matcher.group(4);
        if (skipToken != null) {
            String reason = matcher.group(5);
            SkipPlan skip = new SkipPlan(reason);
            plan.setSkip(skip);
        }
        if ((commentToken = matcher.group(6)) != null) {
            String text = matcher.group(7);
            Comment comment = new Comment(text);
            plan.setComment(comment);
        }
        this.testSet.setPlan(plan);
    }

    protected void extractTestResult(Matcher matcher) {
        String commentToken;
        TestResult testResult = null;
        String okOrNotOk = matcher.group(1);
        StatusValues status = null;
        status = okOrNotOk.trim().equals("ok") ? StatusValues.OK : StatusValues.NOT_OK;
        Integer testNumber = this.getTestNumber(matcher.group(2));
        testResult = new TestResult(status, testNumber);
        testResult.setDescription(matcher.group(3));
        String directiveToken = matcher.group(4);
        if (directiveToken != null) {
            String directiveText = matcher.group(5);
            DirectiveValues directiveValue = null;
            directiveValue = directiveText.trim().equalsIgnoreCase("todo") ? DirectiveValues.TODO : DirectiveValues.SKIP;
            String reason = matcher.group(6);
            Directive directive = new Directive(directiveValue, reason);
            testResult.setDirective(directive);
        }
        if ((commentToken = matcher.group(7)) != null) {
            String text = matcher.group(8);
            Comment comment = new Comment(text);
            comment.setInline(Boolean.TRUE);
            testResult.addComment(comment);
        }
        this.testSet.addTestResult(testResult);
    }

    private Integer getTestNumber(String testNumber) {
        Integer integerTestNumber = null;
        integerTestNumber = StringUtils.isEmpty((String)testNumber) ? Integer.valueOf(this.testSet.getTestResults().size() + 1) : Integer.valueOf(Integer.parseInt(testNumber));
        return integerTestNumber;
    }

    protected void extractBailOut(Matcher matcher) {
        String reason = matcher.group(1);
        BailOut bailOut = new BailOut(reason);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            bailOut.setComment(comment);
        }
        this.testSet.addBailOut(bailOut);
    }

    protected void extractComment(Matcher matcher) {
        String text = matcher.group(1);
        Comment comment = new Comment(text);
        this.testSet.addComment(comment);
        if (this.lastParsedElement instanceof TestResult) {
            TestResult lastTestResult = (TestResult)this.lastParsedElement;
            lastTestResult.addComment(comment);
        }
    }

    protected void extractFooter(Matcher matcher) {
        String text = matcher.group(1);
        Footer footer = new Footer(text);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String commentText = matcher.group(3);
            Comment comment = new Comment(commentText);
            footer.setComment(comment);
        }
        this.testSet.setFooter(footer);
    }

    public TestSet parseTapStream(String tapStream) {
        this.init();
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapStream);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!StringUtils.isNotEmpty((String)line)) continue;
                this.parseLine(line);
            }
            this.postProcess();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.getTestSet();
    }

    public TestSet parseFile(File tapFile) {
        this.init();
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapFile);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!StringUtils.isNotBlank((String)line)) continue;
                this.parseLine(line);
            }
            this.postProcess();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.getTestSet();
    }

    private void setIndentationLevelIfNotDefined(String tapLine) {
        if (this.isBaseIndentationAlreadyDefined() == Boolean.FALSE.booleanValue()) {
            this.baseIndentationLevel = this.getIndentationLevel(tapLine);
        }
    }

    private void checkIndentationLevel(int indentation, String tapLine) {
        if (indentation < this.baseIndentationLevel) {
            if (!this.currentlyInYAML && this.mementos.isEmpty() == Boolean.FALSE.booleanValue()) {
                while (!this.mementos.isEmpty() && indentation < this.baseIndentationLevel) {
                    this.loadMemento();
                }
            } else {
                throw new ParserException("Invalid indentantion. Check your TAP Stream. Line: " + tapLine);
            }
        }
    }

    private int getIndentationLevel(String tapLine) {
        int indentationLevel = 0;
        Matcher indentMatcher = INDENTANTION_PATTERN.matcher(tapLine);
        if (indentMatcher.matches()) {
            String spaces = indentMatcher.group(1);
            indentationLevel = spaces.length();
        }
        return indentationLevel;
    }

    private void checkAndParseTapDiagnostic() {
        if (this.diagnosticBuffer.length() > 0) {
            if (this.lastParsedElement == null) {
                throw new ParserException("Found diagnostic information without a previous TAP element.");
            }
            try {
                Map metaIterable = (Map)this.yaml.load(this.diagnosticBuffer.toString());
                this.lastParsedElement.setDiagnostic(metaIterable);
            }
            catch (Exception ex) {
                throw new ParserException("Error parsing YAML [" + this.diagnosticBuffer.toString() + "]: " + ex.getMessage(), ex);
            }
            this.diagnosticBuffer = new StringBuilder();
        }
    }

    private void appendTapLineToDiagnosticBuffer(String diagnosticLine) {
        if (diagnosticLine.trim().equals("---") || diagnosticLine.trim().equals("...")) {
            return;
        }
        if (this.currentlyInYAML) {
            this.diagnosticBuffer.append(diagnosticLine);
            this.diagnosticBuffer.append('\n');
        }
    }

    protected boolean isBaseIndentationAlreadyDefined() {
        return this.baseIndentationLevel >= 0;
    }

    protected void postProcess() {
        this.checkTAPPlanIsSet();
        this.checkAndParseTapDiagnostic();
    }
}

