/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.parser;

import java.io.File;
import java.util.Scanner;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.tap4j.model.BailOut;
import org.tap4j.model.Comment;
import org.tap4j.model.Directive;
import org.tap4j.model.Footer;
import org.tap4j.model.Header;
import org.tap4j.model.Plan;
import org.tap4j.model.SkipPlan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.model.Text;
import org.tap4j.parser.Parser;
import org.tap4j.parser.ParserException;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public class Tap13Parser
implements Parser {
    private boolean isFirstLine = true;
    private boolean planBeforeTestResult = false;
    private String lastLine = null;
    private TestSet testSet;

    public Tap13Parser() {
        this.init();
    }

    public final void init() {
        this.isFirstLine = true;
        this.planBeforeTestResult = false;
        this.lastLine = null;
        this.testSet = new TestSet();
    }

    public TestSet getTestSet() {
        return this.testSet;
    }

    public void parseLine(String tapLine) {
        if (StringUtils.isEmpty((String)tapLine)) {
            return;
        }
        Matcher matcher = null;
        matcher = COMMENT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractComment(matcher);
            return;
        }
        this.lastLine = tapLine;
        matcher = HEADER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPHeaderParsingLocationAndDuplicity();
            this.extractHeader(matcher);
            this.isFirstLine = false;
            return;
        }
        matcher = PLAN_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPPlanDuplicity();
            this.checkIfTAPPlanIsSetBeforeTestResultsOrBailOut();
            this.extractPlan(matcher);
            this.isFirstLine = false;
            return;
        }
        matcher = TEST_RESULT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractTestResult(matcher);
            return;
        }
        matcher = BAIL_OUT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractBailOut(matcher);
            return;
        }
        matcher = FOOTER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractFooter(matcher);
            return;
        }
        Text text = new Text(tapLine);
        this.testSet.getTapLines().add(text);
    }

    protected void checkIfTAPPlanIsSetBeforeTestResultsOrBailOut() {
        if (this.testSet.getTestResults().size() <= 0 && this.testSet.getBailOuts().size() <= 0) {
            this.planBeforeTestResult = true;
        }
    }

    protected void checkTAPHeaderParsingLocationAndDuplicity() {
        if (this.testSet.getHeader() != null) {
            throw new ParserException("Duplicated TAP Header found.");
        }
        if (!this.isFirstLine) {
            throw new ParserException("Invalid position of TAP Header. It must be the first element (apart of Comments) in the TAP Stream.");
        }
    }

    protected void checkTAPPlanDuplicity() {
        if (this.testSet.getPlan() != null) {
            throw new ParserException("Duplicated TAP Plan found.");
        }
    }

    protected void checkTAPPlanPosition() {
        if (!this.planBeforeTestResult) {
            Matcher matcher = PLAN_PATTERN.matcher(this.lastLine);
            if (matcher.matches()) {
                return;
            }
            throw new ParserException("Invalid position of TAP Plan.");
        }
    }

    protected void checkTAPPlanIsSet() {
        if (this.testSet.getPlan() == null) {
            throw new ParserException("Missing TAP Plan.");
        }
    }

    protected void extractHeader(Matcher matcher) {
        Integer version = Integer.parseInt(matcher.group(1));
        Header header = new Header(version);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            header.setComment(comment);
        }
        this.testSet.setHeader(header);
    }

    protected void extractPlan(Matcher matcher) {
        String commentToken;
        Integer initialTest = Integer.parseInt(matcher.group(1));
        Integer lastTest = Integer.parseInt(matcher.group(3));
        Plan plan = null;
        plan = new Plan(initialTest, lastTest);
        String skipToken = matcher.group(4);
        if (skipToken != null) {
            String reason = matcher.group(5);
            SkipPlan skip = new SkipPlan(reason);
            plan.setSkip(skip);
        }
        if ((commentToken = matcher.group(6)) != null) {
            String text = matcher.group(7);
            Comment comment = new Comment(text);
            plan.setComment(comment);
        }
        this.testSet.setPlan(plan);
    }

    protected void extractTestResult(Matcher matcher) {
        String commentToken;
        TestResult testResult = null;
        String okOrNotOk = matcher.group(1);
        StatusValues status = null;
        status = okOrNotOk.trim().equals("ok") ? StatusValues.OK : StatusValues.NOT_OK;
        Integer testNumber = this.getTestNumber(matcher.group(2));
        testResult = new TestResult(status, testNumber);
        testResult.setDescription(matcher.group(3));
        String directiveToken = matcher.group(4);
        if (directiveToken != null) {
            String directiveText = matcher.group(5);
            DirectiveValues directiveValue = null;
            directiveValue = directiveText.trim().equalsIgnoreCase("todo") ? DirectiveValues.TODO : DirectiveValues.SKIP;
            String reason = matcher.group(6);
            Directive directive = new Directive(directiveValue, reason);
            testResult.setDirective(directive);
        }
        if ((commentToken = matcher.group(7)) != null) {
            String text = matcher.group(8);
            Comment comment = new Comment(text);
            comment.setInline(Boolean.TRUE);
            testResult.addComment(comment);
        }
        this.testSet.addTestResult(testResult);
        this.testSet.addTapLine(testResult);
    }

    private Integer getTestNumber(String testNumber) {
        Integer integerTestNumber = null;
        integerTestNumber = StringUtils.isEmpty((String)testNumber) ? Integer.valueOf(this.testSet.getTestResults().size() + 1) : Integer.valueOf(Integer.parseInt(testNumber));
        return integerTestNumber;
    }

    protected void extractBailOut(Matcher matcher) {
        String reason = matcher.group(1);
        BailOut bailOut = new BailOut(reason);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String text = matcher.group(3);
            Comment comment = new Comment(text);
            bailOut.setComment(comment);
        }
        this.testSet.addBailOut(bailOut);
        this.testSet.addTapLine(bailOut);
    }

    protected void extractComment(Matcher matcher) {
        String text = matcher.group(1);
        Comment comment = new Comment(text);
        this.testSet.addComment(comment);
        this.testSet.addTapLine(comment);
    }

    protected void extractFooter(Matcher matcher) {
        String text = matcher.group(1);
        Footer footer = new Footer(text);
        String commentToken = matcher.group(2);
        if (commentToken != null) {
            String commentText = matcher.group(3);
            Comment comment = new Comment(commentText);
            footer.setComment(comment);
        }
        this.testSet.setFooter(footer);
    }

    public TestSet parseTapStream(String tapStream) {
        this.init();
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapStream);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!StringUtils.isNotEmpty((String)line)) continue;
                this.parseLine(line);
            }
            this.postProcess();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.getTestSet();
    }

    public TestSet parseFile(File tapFile) {
        this.init();
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapFile);
            String line = null;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!StringUtils.isNotBlank((String)line)) continue;
                this.parseLine(line);
            }
            this.postProcess();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.getTestSet();
    }

    protected void postProcess() {
        this.checkTAPPlanIsSet();
    }
}

