/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.testng;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.tap4j.ext.testng.TestNGTAPUtils;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.producer.Producer;
import org.tap4j.producer.TapProducer;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteTAPReporter
implements IReporter {
    private final Map<Class<?>, List<ITestResult>> testResultsPerSuite = new LinkedHashMap();
    private final Map<String, List<ITestResult>> testResultsPerGroup = new LinkedHashMap<String, List<ITestResult>>();
    private Producer tapProducer = new TapProducer();
    private TestSet testSet;

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        this.generateTAPPerSuite(xmlSuites, suites, outputDirectory);
        this.generateTAPPerGroup(xmlSuites, suites, outputDirectory);
    }

    protected void generateTAPPerSuite(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        for (ISuite suite : suites) {
            this.testSet = new TestSet();
            Set<Class<?>> testResultsSet = this.getTestResultsSetPerSuite(suite);
            Integer totalTestResults = this.getTotalTestResultsByTestSuite(testResultsSet);
            this.testSet.setPlan(new Plan(totalTestResults));
            for (Class<?> testResultClass : testResultsSet) {
                List<ITestResult> testResults = this.testResultsPerSuite.get(testResultClass);
                for (ITestResult testResult : testResults) {
                    TestResult tapTestResult = TestNGTAPUtils.generateTAPTestResult(testResult, this.testSet.getNumberOfTestResults() + 1);
                    this.testSet.addTestResult(tapTestResult);
                }
            }
            File output = new File(outputDirectory, suite.getName() + ".tap");
            this.tapProducer.dump(this.testSet, output);
        }
    }

    protected void generateTAPPerGroup(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        for (ISuite suite : suites) {
            Map groups = suite.getMethodsByGroups();
            this.populateTestResultsPerGroupMap(suite, groups);
            if (groups.size() <= 0) continue;
            Object[] groupNames = groups.keySet().toArray(new String[groups.size()]);
            Arrays.sort(groupNames);
            for (Object group : groupNames) {
                List<ITestResult> groupTestResults;
                if (!StringUtils.isNotEmpty((String)group) || (groupTestResults = this.testResultsPerGroup.get(group)) == null) continue;
                Integer totalTestResultsByGroup = groupTestResults.size();
                this.testSet = new TestSet();
                this.testSet.setPlan(new Plan(totalTestResultsByGroup));
                for (ITestResult testResult : groupTestResults) {
                    TestResult tapTestResult = TestNGTAPUtils.generateTAPTestResult(testResult, this.testSet.getNumberOfTestResults() + 1);
                    this.testSet.addTestResult(tapTestResult);
                }
                File output = new File(outputDirectory, (String)group + ".tap");
                this.tapProducer.dump(this.testSet, output);
            }
        }
    }

    protected Set<Class<?>> getTestResultsSetPerSuite(ISuite suite) {
        XmlSuite xmlSuite = suite.getXmlSuite();
        this.generateClasses(xmlSuite, suite);
        return this.testResultsPerSuite.keySet();
    }

    protected void populateTestResultsPerGroupMap(ISuite suite, Map<String, Collection<ITestNGMethod>> groups) {
        XmlSuite xmlSuite = suite.getXmlSuite();
        this.generateResultsMapForGroups(xmlSuite, suite, groups);
    }

    public Integer getTotalTestResultsByTestSuite(Set<Class<?>> keySet) {
        Integer totalTestResults = 0;
        for (Class<?> clazz : keySet) {
            List<ITestResult> testResults = this.testResultsPerSuite.get(clazz);
            totalTestResults = totalTestResults + testResults.size();
        }
        return totalTestResults;
    }

    public void generateClasses(XmlSuite xmlSuite, ISuite suite) {
        if (suite.getResults().size() > 0) {
            for (ISuiteResult suiteResult : suite.getResults().values()) {
                List<ITestResult> testResults = TestNGTAPUtils.getTestNGResultsOrderedByExecutionDate(suiteResult.getTestContext());
                for (ITestResult testResult : testResults) {
                    Class clazz = testResult.getMethod().getRealClass();
                    List<ITestResult> testResultsForThisClass = this.testResultsPerSuite.get(clazz);
                    if (testResultsForThisClass == null) {
                        testResultsForThisClass = new LinkedList<ITestResult>();
                        this.testResultsPerSuite.put(clazz, testResultsForThisClass);
                    }
                    testResultsForThisClass.add(testResult);
                }
            }
        }
    }

    protected void generateResultsMapForGroups(XmlSuite xmlSuite, ISuite suite, Map<String, Collection<ITestNGMethod>> groups) {
        if (suite.getResults().size() > 0) {
            for (ISuiteResult suiteResult : suite.getResults().values()) {
                List<ITestResult> testResults = TestNGTAPUtils.getTestNGResultsOrderedByExecutionDate(suiteResult.getTestContext());
                for (ITestResult testResult : testResults) {
                    String[] groupsNm;
                    ITestNGMethod method = testResult.getMethod();
                    for (String gpNm : groupsNm = this.findInWhatGroupsMethodIs(method, groups)) {
                        if (!StringUtils.isNotEmpty((String)gpNm)) continue;
                        List<ITestResult> testResultsForThisGroup = this.testResultsPerGroup.get(gpNm);
                        if (testResultsForThisGroup == null) {
                            testResultsForThisGroup = new LinkedList<ITestResult>();
                            this.testResultsPerGroup.put(gpNm, testResultsForThisGroup);
                        }
                        testResultsForThisGroup.add(testResult);
                    }
                }
            }
        }
    }

    protected String[] findInWhatGroupsMethodIs(ITestNGMethod methodToFind, Map<String, Collection<ITestNGMethod>> groups) {
        String[] groupsFound = new String[groups.keySet().size()];
        int cont = 0;
        for (Map.Entry<String, Collection<ITestNGMethod>> grupo : groups.entrySet()) {
            for (ITestNGMethod method : grupo.getValue()) {
                if (!method.equals(methodToFind) || !method.getRealClass().equals(methodToFind.getRealClass())) continue;
                groupsFound[cont++] = grupo.getKey();
            }
        }
        return groupsFound;
    }
}

