/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.junit;

import java.util.Map;
import org.tap4j.ext.junit.JUnitTestData;
import org.tap4j.ext.junit.JUnitYAMLishUtils;
import org.tap4j.model.Directive;
import org.tap4j.model.TestResult;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;
import org.testng.IResultMap;
import org.testng.ITestResult;
import org.testng.internal.ResultMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JUnitTAPUtils {
    private JUnitTAPUtils() {
    }

    public static TestResult generateTAPTestResult(JUnitTestData testMethod, Integer number) {
        TestResult tapTestResult = new TestResult();
        String testResultDescription = JUnitTAPUtils.generateTAPTestResultDescription(testMethod);
        tapTestResult.setDescription(testResultDescription);
        JUnitTAPUtils.setTapTestStatus(tapTestResult, testMethod);
        JUnitTAPUtils.createTestNGYAMLishData(tapTestResult, testMethod);
        return tapTestResult;
    }

    public static String generateTAPTestResultDescription(JUnitTestData testMethod) {
        StringBuilder description = new StringBuilder();
        description.append("- ");
        description.append(JUnitYAMLishUtils.extractClassName(testMethod.getDescription()));
        description.append('#');
        description.append(JUnitYAMLishUtils.extractMethodName(testMethod.getDescription()));
        return description.toString();
    }

    public static void setTapTestStatus(TestResult tapTestResult, JUnitTestData testMethod) {
        if (testMethod.isIgnored().booleanValue()) {
            tapTestResult.setStatus(StatusValues.NOT_OK);
            Directive skip = new Directive(DirectiveValues.SKIP, "JUnit test was skipped");
            tapTestResult.setDirective(skip);
        } else if (testMethod.isFailed().booleanValue()) {
            tapTestResult.setStatus(StatusValues.NOT_OK);
        } else {
            tapTestResult.setStatus(StatusValues.OK);
        }
    }

    public static void createTestNGYAMLishData(TestResult testResult, JUnitTestData testMethod) {
        Map<String, Object> yamlish = testResult.getDiagnostic();
        JUnitTAPUtils.createYAMLishMessage(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishSeverity(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishSource(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishDatetime(yamlish);
        JUnitTAPUtils.createYAMLishFile(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishLine(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishName(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishError(yamlish, testMethod);
        JUnitTAPUtils.createYAMLishBacktrace(yamlish, testMethod);
    }

    public static void createYAMLishMessage(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String message = JUnitYAMLishUtils.getMessage(testMethod);
        yamlish.put("message", message);
    }

    public static void createYAMLishSeverity(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String severity = JUnitYAMLishUtils.getSeverity(testMethod);
        yamlish.put("severity", severity);
    }

    public static void createYAMLishSource(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String methodName = JUnitYAMLishUtils.extractMethodName(testMethod.getDescription());
        String className = JUnitYAMLishUtils.extractClassName(testMethod.getDescription());
        String source = JUnitYAMLishUtils.getSource(methodName, className);
        yamlish.put("source", source);
    }

    public static void createYAMLishDatetime(Map<String, Object> yamlish) {
        String datetime = JUnitYAMLishUtils.getDatetime();
        yamlish.put("datetime", datetime);
    }

    public static void createYAMLishFile(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String file = JUnitYAMLishUtils.getFile(testMethod);
        yamlish.put("file", file);
    }

    public static void createYAMLishLine(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String line = JUnitYAMLishUtils.getLine(testMethod);
        yamlish.put("line", line);
    }

    public static void createYAMLishName(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String name = JUnitYAMLishUtils.getName(testMethod);
        yamlish.put("name", name);
    }

    public static void createYAMLishError(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String error = JUnitYAMLishUtils.getError(testMethod);
        yamlish.put("error", error);
    }

    public static void createYAMLishBacktrace(Map<String, Object> yamlish, JUnitTestData testMethod) {
        String backtrace = JUnitYAMLishUtils.getBacktrace(testMethod);
        yamlish.put("backtrace", backtrace);
    }

    public static void addAll(ResultMap total, IResultMap map) {
        for (ITestResult testResult : map.getAllResults()) {
            total.addResult(testResult, testResult.getMethod());
        }
    }
}

