/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.representer;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.tap4j.model.TapResult;
import org.tap4j.model.TestSet;
import org.tap4j.representer.Representer;
import org.tap4j.representer.RepresenterException;
import org.tap4j.representer.RepresenterUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Tap13YamlRepresenter
implements Representer {
    protected Yaml yaml;

    public Tap13YamlRepresenter() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        options.setExplicitStart(true);
        options.setExplicitEnd(true);
        this.yaml = new Yaml(options);
    }

    public String representData(TestSet testSet) throws RepresenterException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (testSet.getHeader() != null) {
            pw.println(testSet.getHeader().toString());
            RepresenterUtil.printDiagnostic(this.yaml, testSet.getHeader(), pw);
        }
        if (testSet.getPlan() == null) {
            throw new RepresenterException("Missing required TAP Plan");
        }
        pw.println(testSet.getPlan().toString());
        RepresenterUtil.printDiagnostic(this.yaml, testSet.getPlan(), pw);
        for (TapResult tapLine : testSet.getTapLines()) {
            pw.println(tapLine.toString());
            RepresenterUtil.printDiagnostic(this.yaml, tapLine, pw);
        }
        if (testSet.getFooter() != null) {
            pw.println(testSet.getFooter().toString());
            RepresenterUtil.printDiagnostic(this.yaml, testSet.getFooter(), pw);
        }
        return sw.toString();
    }
}

