/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.parser;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tap4j.model.TapElement;
import org.tap4j.model.Text;
import org.tap4j.parser.ParserException;
import org.tap4j.parser.Tap13Parser;
import org.yaml.snakeyaml.Yaml;

public class Tap13YamlParser
extends Tap13Parser {
    protected TapElement lastParsedElement = null;
    protected int baseIndentationLevel = -1;
    protected int currentIndentationLevel = -1;
    protected boolean currentlyInYAML = false;
    protected Yaml yaml = new Yaml();
    protected StringBuilder diagnosticBuffer = new StringBuilder();
    public static final Pattern INDENTANTION_PATTERN = Pattern.compile("((\\s|\\t)*)?.*");

    public void parseLine(String tapLine) throws ParserException {
        Matcher matcher = null;
        matcher = COMMENT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractComment(matcher);
            return;
        }
        this.lastLine = tapLine;
        if (this.isBaseIndentationAlreadyDefined() && (matcher = INDENTANTION_PATTERN.matcher(tapLine)).matches()) {
            int indentation;
            String spaces = matcher.group(1);
            this.currentIndentationLevel = indentation = spaces.length();
            if (indentation > this.baseIndentationLevel) {
                if (tapLine.trim().equals("---")) {
                    this.currentlyInYAML = true;
                }
                if (tapLine.trim().equals("...")) {
                    this.currentlyInYAML = false;
                }
                this.appendTapLineToDiagnosticBuffer(tapLine);
                return;
            }
            this.checkIndentationLevel(indentation, tapLine);
        }
        this.checkAndParseTapDiagnostic();
        matcher = HEADER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.setIndentationLevelIfNotDefined(tapLine);
            this.currentIndentationLevel = this.baseIndentationLevel;
            this.checkTAPHeaderParsingLocationAndDuplicity();
            this.extractHeader(matcher);
            this.isFirstLine = false;
            this.lastParsedElement = this.header;
            return;
        }
        matcher = PLAN_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.checkTAPPlanDuplicity();
            this.checkIfTAPPlanIsSetBeforeTestResultsOrBailOut();
            this.setIndentationLevelIfNotDefined(tapLine);
            this.extractPlan(matcher);
            this.isFirstLine = false;
            this.lastParsedElement = this.plan;
            return;
        }
        matcher = TEST_RESULT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.setIndentationLevelIfNotDefined(tapLine);
            this.extractTestResult(matcher);
            this.lastParsedElement = (TapElement)this.tapLines.get(this.tapLines.size() - 1);
            return;
        }
        matcher = BAIL_OUT_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.setIndentationLevelIfNotDefined(tapLine);
            this.extractBailOut(matcher);
            this.lastParsedElement = (TapElement)this.tapLines.get(this.tapLines.size() - 1);
            return;
        }
        matcher = FOOTER_PATTERN.matcher(tapLine);
        if (matcher.matches()) {
            this.extractFooter(matcher);
            this.lastParsedElement = this.footer;
            return;
        }
        Text text = new Text(tapLine);
        this.lastParsedElement = text;
        this.tapLines.add(text);
    }

    private void setIndentationLevelIfNotDefined(String tapLine) {
        if (this.isBaseIndentationAlreadyDefined() == Boolean.FALSE.booleanValue()) {
            this.baseIndentationLevel = this.getIndentationLevel(tapLine);
        }
    }

    private void checkIndentationLevel(int indentation, String tapLine) throws ParserException {
        if (indentation < this.baseIndentationLevel) {
            throw new ParserException("Invalid indentantion. Check your TAP Stream. Line: " + tapLine);
        }
    }

    private int getIndentationLevel(String tapLine) {
        int indentationLevel = 0;
        Matcher indentMatcher = INDENTANTION_PATTERN.matcher(tapLine);
        if (indentMatcher.matches()) {
            String spaces = indentMatcher.group(1);
            indentationLevel = spaces.length();
        }
        return indentationLevel;
    }

    private void checkAndParseTapDiagnostic() throws ParserException {
        if (this.diagnosticBuffer.length() > 0) {
            if (this.lastParsedElement == null) {
                throw new ParserException("Found diagnostic information without a previous TAP element.");
            }
            try {
                Map metaIterable = (Map)this.yaml.load(this.diagnosticBuffer.toString());
                this.lastParsedElement.setDiagnostic(metaIterable);
            }
            catch (Exception ex) {
                throw new ParserException("Error parsing YAML [" + this.diagnosticBuffer.toString() + "]: " + ex.getMessage(), ex);
            }
            this.diagnosticBuffer = new StringBuilder();
        }
    }

    private void appendTapLineToDiagnosticBuffer(String diagnosticLine) {
        if (diagnosticLine.trim().equals("---") || diagnosticLine.trim().equals("...")) {
            return;
        }
        if (this.currentlyInYAML) {
            this.diagnosticBuffer.append(diagnosticLine);
            this.diagnosticBuffer.append('\n');
        }
    }

    protected boolean isBaseIndentationAlreadyDefined() {
        return this.baseIndentationLevel >= 0;
    }

    protected void postProcess() throws ParserException {
        super.postProcess();
        this.checkAndParseTapDiagnostic();
    }
}

