/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.model;

import org.tap4j.model.AbstractTapElementDiagnostic;
import org.tap4j.model.Comment;
import org.tap4j.model.SkipPlan;

public class Plan
extends AbstractTapElementDiagnostic {
    private static final long serialVersionUID = 1L;
    private static final Integer INITIAL_TEST_STEP = 1;
    private Integer initialTestNumber;
    private Integer lastTestNumber;
    private SkipPlan skip;
    private Comment comment;

    public Plan(Integer initialTestNumber, Integer lastTestNumber) {
        this.initialTestNumber = initialTestNumber;
        this.lastTestNumber = lastTestNumber;
    }

    public Plan(Integer amountOfTests) {
        this.initialTestNumber = INITIAL_TEST_STEP;
        this.lastTestNumber = amountOfTests;
    }

    public Plan(Integer amountOfTests, SkipPlan skip) {
        this.initialTestNumber = INITIAL_TEST_STEP;
        this.lastTestNumber = amountOfTests;
        this.skip = skip;
    }

    public Plan(Integer initialTestNumber, Integer lastTestNumber, SkipPlan skip) {
        this.initialTestNumber = initialTestNumber;
        this.lastTestNumber = lastTestNumber;
        this.skip = skip;
    }

    public Integer getInitialTestNumber() {
        return this.initialTestNumber;
    }

    public Integer getLastTestNumber() {
        return this.lastTestNumber;
    }

    public Boolean isSkip() {
        return this.skip != null;
    }

    public SkipPlan getSkip() {
        return this.skip;
    }

    public void setSkip(SkipPlan skip) {
        this.skip = skip;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.initialTestNumber);
        sb.append("..");
        sb.append(this.lastTestNumber);
        if (this.skip != null) {
            sb.append(" skip ");
            sb.append(this.skip.getReason());
        }
        if (this.comment != null) {
            sb.append(' ');
            sb.append(this.comment.toString());
        }
        return sb.toString();
    }
}

