/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.testng;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.testng.ITestResult;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.JavaBeanLoader;
import org.yaml.snakeyaml.reader.UnicodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestNGYAMLishUtils {
    public static final SimpleDateFormat ISO_8061_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String LINE_SEPARATOR = DumperOptions.LineBreak.UNIX.getString();

    private TestNGYAMLishUtils() {
    }

    public static String getMessage(ITestResult testNgTestResult) {
        return "TestNG Test " + testNgTestResult.getName();
    }

    public static String getSeverity(ITestResult testNgTestResult) {
        String severity = "~";
        if (testNgTestResult.getThrowable() != null) {
            severity = "High";
        }
        return severity;
    }

    public static String getSource(ITestResult testNgTestResult) {
        String source = testNgTestResult.getTestClass().getName() + "#" + testNgTestResult.getMethod().getMethodName();
        return source;
    }

    public static String getDatetime(ITestResult testNgTestResult) {
        long ms = testNgTestResult.getStartMillis();
        Date date = new Date(ms);
        String iso8061Datetime = ISO_8061_DATE_FORMAT.format(date);
        return iso8061Datetime;
    }

    public static String getFile(ITestResult testNgTestResult) {
        String file = testNgTestResult.getTestClass().getName();
        return file;
    }

    public static String getLine(ITestResult testNgTestResult) {
        String line = "~";
        Throwable testNGException = testNgTestResult.getThrowable();
        if (testNGException != null) {
            StackTraceElement el;
            StringBuilder lookFor = new StringBuilder();
            lookFor.append(testNgTestResult.getTestClass().getName());
            lookFor.append('.');
            lookFor.append(testNgTestResult.getMethod().getMethodName());
            lookFor.append('(');
            lookFor.append(testNgTestResult.getTestClass().getClass().getSimpleName());
            lookFor.append(".java:");
            StackTraceElement[] els = testNGException.getStackTrace();
            for (int i = 0; i < els.length && (line = TestNGYAMLishUtils.getLineNumberFromExceptionTraceLine((el = els[i]).toString(), lookFor.toString())) == ""; ++i) {
            }
        }
        return line;
    }

    public static String getLineNumberFromExceptionTraceLine(String exceptionTraceLine, String substrToSearch) {
        String lineNumber = "";
        int index = exceptionTraceLine.indexOf(substrToSearch);
        if (index >= 0) {
            int length = substrToSearch.length() + index;
            if (exceptionTraceLine.lastIndexOf(41) > length) {
                lineNumber = exceptionTraceLine.substring(length, exceptionTraceLine.lastIndexOf(41));
            }
        }
        return lineNumber;
    }

    public static String getName(ITestResult testNgTestResult) {
        String name = testNgTestResult.getName();
        return name;
    }

    public static Object getExtensions(ITestResult testNgTestResult) {
        Serializable extensions = null;
        Set attributeNames = testNgTestResult.getAttributeNames();
        Iterator iterator = attributeNames.iterator();
        if (iterator.hasNext()) {
            extensions = new LinkedHashMap();
            while (iterator.hasNext()) {
                String attributeName = (String)iterator.next();
                Object attributeValue = testNgTestResult.getAttribute(attributeName);
                ((Map)((Object)extensions)).put(attributeName, attributeValue);
            }
        } else {
            extensions = Character.valueOf('~');
        }
        return extensions;
    }

    public static String getExpected(ITestResult testNgTestResult) {
        Throwable throwable = testNgTestResult.getThrowable();
        String expected = null;
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stringException = sw.toString();
            String expectedToken = "expected:";
            String butWasToken = " but was:";
            int index = stringException.toString().indexOf(expectedToken.toString());
            if (index > 0) {
                expected = stringException.toString().substring(index + expectedToken.length(), stringException.toString().lastIndexOf(butWasToken));
                index = stringException.toString().indexOf(butWasToken);
            }
        }
        return expected;
    }

    public static String getActual(ITestResult testNgTestResult) {
        Throwable throwable = testNgTestResult.getThrowable();
        String actual = "~";
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stringException = sw.toString();
            String expectedToken = "expected:";
            String butWasToken = " but was:";
            int index = stringException.toString().indexOf(expectedToken.toString());
            if (index > 0) {
                index = stringException.toString().indexOf(butWasToken);
                int eolIndex = stringException.toString().indexOf(System.getProperty("line.separator"), index);
                actual = stringException.toString().substring(index + butWasToken.length(), eolIndex);
            }
        }
        return actual;
    }

    public static String getDisplay(ITestResult testNgTestResult) {
        StringBuilder displayBuffer = new StringBuilder();
        String expected = TestNGYAMLishUtils.getExpected(testNgTestResult);
        String actual = TestNGYAMLishUtils.getActual(testNgTestResult);
        if (StringUtils.isNotEmpty((String)expected) && StringUtils.isNotEmpty((String)actual)) {
            int expectedLength = expected.length();
            int actualLength = actual.length();
            int greater = expectedLength;
            if (actualLength > expectedLength) {
                greater = actualLength;
            } else if ("Expected".length() > greater) {
                greater = "Expected".length();
            }
            int greaterPlus3 = greater + 3;
            displayBuffer.append("+" + TestNGYAMLishUtils.fill(greaterPlus3, '-') + "+" + TestNGYAMLishUtils.fill(greaterPlus3, '-') + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TestNGYAMLishUtils.fill(greater, "Got") + "|" + TestNGYAMLishUtils.fill(greater, "Expected") + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TestNGYAMLishUtils.fill(greaterPlus3, '-') + "+" + TestNGYAMLishUtils.fill(greaterPlus3, '-') + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TestNGYAMLishUtils.fill(greater, actual) + "|" + TestNGYAMLishUtils.fill(greater, expected) + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TestNGYAMLishUtils.fill(greaterPlus3, '-') + "+" + TestNGYAMLishUtils.fill(greaterPlus3, '-') + "+");
        } else {
            displayBuffer.append('~');
        }
        return displayBuffer.toString();
    }

    private static String fill(int greater, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < greater; ++i) {
            sb.append(Character.toString(c));
        }
        return sb.toString();
    }

    private static String fill(int greater, String s) {
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        sb.append(s);
        int newgreater = greater - s.length();
        sb.append(TestNGYAMLishUtils.fill(newgreater + 1, ' '));
        sb.append(' ');
        return sb.toString();
    }

    public static Object getDump(ITestResult testNgTestResult) {
        Object returnObject = null;
        Object[] parameters = testNgTestResult.getParameters();
        if (parameters.length > 0) {
            returnObject = new LinkedHashMap();
            for (int i = 0; i < parameters.length; ++i) {
                Object parameter = parameters[i];
                ((Map)returnObject).put("param" + (i + 1), parameter);
            }
        } else {
            returnObject = "~";
        }
        return returnObject.toString();
    }

    public static String getError(ITestResult testNgTestResult) {
        String error = "~";
        Throwable t = testNgTestResult.getThrowable();
        if (t != null) {
            error = t.getMessage();
        }
        return error;
    }

    public static String getBacktrace(ITestResult testNgTestResult) {
        StringBuilder stackTrace = new StringBuilder();
        Throwable throwable = testNgTestResult.getThrowable();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stackTraceString = sw.toString();
            stackTraceString = stackTraceString.trim().replaceAll("\\r\\n", "\n");
            StringTokenizer st = new StringTokenizer(stackTraceString, LINE_SEPARATOR);
            while (st.hasMoreTokens()) {
                String stackTraceLine = st.nextToken();
                stackTrace.append(stackTraceLine);
                stackTrace.append(LINE_SEPARATOR);
            }
        } else {
            stackTrace.append('~');
        }
        return stackTrace.toString();
    }

    public static StringBuilder toYaml(XmlSuite suite) {
        StringBuilder result = new StringBuilder();
        TestNGYAMLishUtils.maybeAdd(result, "name", suite.getName(), null);
        TestNGYAMLishUtils.maybeAdd(result, "junit", suite.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        TestNGYAMLishUtils.maybeAdd(result, "verbose", suite.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        TestNGYAMLishUtils.maybeAdd(result, "threadCount", suite.getThreadCount(), XmlSuite.DEFAULT_THREAD_COUNT);
        TestNGYAMLishUtils.maybeAdd(result, "dataProviderThreadCount", suite.getDataProviderThreadCount(), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT);
        TestNGYAMLishUtils.maybeAdd(result, "timeOut", suite.getTimeOut(), null);
        TestNGYAMLishUtils.maybeAdd(result, "parallel", suite.getParallel(), XmlSuite.DEFAULT_PARALLEL);
        TestNGYAMLishUtils.maybeAdd(result, "skipFailedInvocationCounts", suite.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        TestNGYAMLishUtils.toYaml(result, "parameters", "", suite.getParameters());
        TestNGYAMLishUtils.toYaml(result, suite.getPackages());
        if (suite.getListeners().size() > 0) {
            result.append("listeners:\n");
            TestNGYAMLishUtils.toYaml(result, "  ", suite.getListeners());
        }
        if (suite.getPackages().size() > 0) {
            result.append("packages:\n");
            TestNGYAMLishUtils.toYaml(result, suite.getPackages());
        }
        TestNGYAMLishUtils.toYaml(result, "listeners", suite.getListeners());
        if (suite.getTests().size() > 0) {
            result.append("tests:\n");
            for (XmlTest t : suite.getTests()) {
                TestNGYAMLishUtils.toYaml(result, "  ", t);
            }
        }
        if (suite.getChildSuites().size() > 0) {
            result.append("suite-files:\n");
            TestNGYAMLishUtils.toYaml(result, "  ", suite.getSuiteFiles());
        }
        return result;
    }

    private static void maybeAdd(StringBuilder sb, String key, Object value, Object def) {
        TestNGYAMLishUtils.maybeAdd(sb, "", key, value, def);
    }

    private static void maybeAdd(StringBuilder sb, String sp, String key, Object value, Object def) {
        if (value != null && !value.equals(def)) {
            sb.append(sp).append(key).append(": ").append(value.toString()).append("\n");
        }
    }

    private static void toYaml(StringBuilder result, String sp, XmlTest t) {
        Map mg;
        String sp2 = sp + "  ";
        result.append(sp).append("- name: ").append(t.getName()).append("\n");
        TestNGYAMLishUtils.maybeAdd(result, sp2, "junit", t.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        TestNGYAMLishUtils.maybeAdd(result, sp2, "verbose", t.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        TestNGYAMLishUtils.maybeAdd(result, sp2, "timeOut", t.getTimeOut(), null);
        TestNGYAMLishUtils.maybeAdd(result, sp2, "parallel", t.getParallel(), XmlSuite.DEFAULT_PARALLEL);
        TestNGYAMLishUtils.maybeAdd(result, sp2, "skipFailedInvocationCounts", t.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        TestNGYAMLishUtils.maybeAdd(result, "preserveOrder", sp2, t.getPreserveOrder(), "false");
        TestNGYAMLishUtils.toYaml(result, "parameters", sp2, t.getParameters());
        if (t.getIncludedGroups().size() > 0) {
            result.append(sp2).append("includedGroups: [ ").append(StringUtils.join((Collection)t.getIncludedGroups(), (String)",")).append(" ]\n");
        }
        if (t.getExcludedGroups().size() > 0) {
            result.append(sp2).append("excludedGroups: [ ").append(StringUtils.join((Collection)t.getExcludedGroups(), (String)",")).append(" ]\n");
        }
        if ((mg = t.getMetaGroups()).size() > 0) {
            result.append(sp2).append("metaGroups: { ");
            boolean first = true;
            for (String group : mg.keySet()) {
                if (!first) {
                    result.append(", ");
                }
                result.append(group).append(": [ ").append(StringUtils.join((Collection)((Collection)mg.get(group)), (String)",")).append(" ] ");
                first = false;
            }
            result.append(" }\n");
        }
        if (t.getXmlPackages().size() > 0) {
            result.append(sp2).append("xmlPackages:\n");
            for (XmlPackage xp : t.getXmlPackages()) {
                TestNGYAMLishUtils.toYaml(result, sp2 + "  - ", xp);
            }
        }
        if (t.getXmlClasses().size() > 0) {
            result.append(sp2).append("classes:\n");
            for (XmlClass xc : t.getXmlClasses()) {
                TestNGYAMLishUtils.toYaml(result, sp2 + "  ", xc);
            }
        }
        result.append("\n");
    }

    private static void toYaml(StringBuilder result, String sp2, XmlClass xc) {
        List im = xc.getIncludedMethods();
        List em = xc.getExcludedMethods();
        String name = im.size() > 0 || em.size() > 0 ? "name: " : "";
        result.append(sp2).append("- " + name).append(xc.getName()).append("\n");
        if (im.size() > 0) {
            result.append(sp2 + "  includedMethods:\n");
            for (XmlInclude xi : im) {
                TestNGYAMLishUtils.toYaml(result, sp2 + "    ", xi);
            }
        }
        if (em.size() > 0) {
            result.append(sp2 + "  excludedMethods:\n");
            TestNGYAMLishUtils.toYaml(result, sp2 + "    ", em);
        }
    }

    private static void toYaml(StringBuilder result, String sp2, XmlInclude xi) {
        result.append(sp2 + "- " + xi.getName()).append("\n");
    }

    private static void toYaml(StringBuilder result, String sp, List<String> strings) {
        for (String l : strings) {
            result.append(sp).append("- ").append(l).append("\n");
        }
    }

    private static void toYaml(StringBuilder sb, List<XmlPackage> packages) {
        if (packages.size() > 0) {
            sb.append("packages:\n");
            for (XmlPackage p : packages) {
                TestNGYAMLishUtils.toYaml(sb, "  ", p);
            }
        }
        for (XmlPackage p : packages) {
            TestNGYAMLishUtils.toYaml(sb, "  ", p);
        }
    }

    private static void toYaml(StringBuilder sb, String sp, XmlPackage p) {
        sb.append(sp).append("name: ").append(p.getName()).append("\n");
        TestNGYAMLishUtils.generateIncludeExclude(sb, sp, "includes", p.getInclude());
        TestNGYAMLishUtils.generateIncludeExclude(sb, sp, "excludes", p.getExclude());
    }

    private static void generateIncludeExclude(StringBuilder sb, String sp, String key, List<String> includes) {
        if (includes.size() > 0) {
            sb.append(sp).append("  ").append(key).append("\n");
            for (String inc : includes) {
                sb.append(sp).append("    ").append(inc);
            }
        }
    }

    private static void mapToYaml(Map<String, String> map, StringBuilder out) {
        if (map.size() > 0) {
            out.append("{ ");
            boolean first = true;
            for (Map.Entry<String, String> e : map.entrySet()) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(e.getKey() + ": " + e.getValue());
            }
            out.append(" }\n");
        }
    }

    private static void toYaml(StringBuilder sb, String key, String sp, Map<String, String> parameters) {
        if (parameters.size() > 0) {
            sb.append(sp).append(key).append(": ");
            TestNGYAMLishUtils.mapToYaml(parameters, sb);
        }
    }

    private static void addToMap(Map suite, String name, Map target) {
        List parameters = (List)suite.get(name);
        if (parameters != null) {
            for (Map parameter : parameters) {
                for (Map.Entry p : parameter.entrySet()) {
                    target.put(p.getKey(), p.getValue().toString());
                }
            }
        }
    }

    private static void addToList(Map suite, String name, List target) {
        List parameters = (List)suite.get(name);
        if (parameters != null) {
            for (Map parameter : parameters) {
                for (Map.Entry p : parameter.entrySet()) {
                    target.add(p.getValue().toString());
                }
            }
        }
    }

    public static XmlSuite parse(String filePath, InputStream is) throws FileNotFoundException {
        JavaBeanLoader loader = new JavaBeanLoader(XmlSuite.class);
        if (is == null) {
            is = new FileInputStream(new File(filePath));
        }
        XmlSuite result = (XmlSuite)loader.load((Reader)new UnicodeReader(is));
        result.setFileName(filePath);
        for (XmlTest t : result.getTests()) {
            t.setSuite(result);
        }
        return result;
    }
}

