/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.junit;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.tap4j.ext.junit.JUnitTAPUtils;
import org.tap4j.ext.junit.JUnitTestData;
import org.tap4j.ext.junit.JUnitYAMLishUtils;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.producer.TapProducer;
import org.tap4j.producer.TapProducerFactory;

public class JUnitTestTapReporter
extends RunListener {
    protected List<JUnitTestData> testMethodsList = null;
    protected TapProducer tapProducer = null;
    protected boolean isSuite = false;

    public void testRunStarted(Description description) throws Exception {
        this.tapProducer = TapProducerFactory.makeTap13YamlProducer();
        this.testMethodsList = new LinkedList<JUnitTestData>();
        this.isSuite = description.isSuite();
    }

    public void testRunFinished(Result result) throws Exception {
        this.setFailedTestsStatus(result);
        this.generateTapPerMethod(result);
        this.generateTapPerClass(result);
        if (this.isSuite) {
            this.generateTapPerSuite(result);
        }
    }

    public void testIgnored(Description description) throws Exception {
        JUnitTestData testMethod = new JUnitTestData(false, false);
        testMethod.setDescription(description);
        testMethod.setIgnored(true);
        this.testMethodsList.add(testMethod);
    }

    public void testStarted(Description description) throws Exception {
        this.setTestInfo(description);
    }

    public void testFailure(Failure failure) throws Exception {
    }

    public void testFinished(Description description) throws Exception {
    }

    protected void generateTapPerMethod(Result result) {
        for (JUnitTestData testMethod : this.testMethodsList) {
            TestResult tapTestResult = JUnitTAPUtils.generateTAPTestResult(testMethod, 1);
            TestSet testSet = new TestSet();
            testSet.setPlan(new Plan(1));
            testSet.addTestResult(tapTestResult);
            String className = JUnitYAMLishUtils.extractClassName(testMethod.getDescription());
            String methodName = JUnitYAMLishUtils.extractMethodName(testMethod.getDescription());
            File output = new File("./", className + "#" + methodName + ".tap");
            this.tapProducer.dump(testSet, output);
        }
    }

    protected void generateTapPerClass(Result result) {
        File output;
        TestSet testSet = new TestSet();
        Integer methodsSizeList = 0;
        String className = "";
        String lastClassName = "";
        for (JUnitTestData testMethod : this.testMethodsList) {
            className = JUnitYAMLishUtils.extractClassName(testMethod.getDescription());
            if (StringUtils.isNotBlank((String)lastClassName) && !lastClassName.equals(className)) {
                testSet.setPlan(new Plan(methodsSizeList));
                output = new File("./", lastClassName + ".tap");
                this.tapProducer.dump(testSet, output);
                testSet = new TestSet();
                methodsSizeList = 0;
            }
            TestResult tapTestResult = JUnitTAPUtils.generateTAPTestResult(testMethod, 1);
            testSet.addTestResult(tapTestResult);
            Integer n = methodsSizeList;
            Integer n2 = methodsSizeList = Integer.valueOf(methodsSizeList + 1);
            lastClassName = className;
        }
        testSet.setPlan(new Plan(methodsSizeList));
        output = new File("./", className + ".tap");
        this.tapProducer.dump(testSet, output);
    }

    protected void generateTapPerSuite(Result result) {
        TestSet testSet = new TestSet();
        testSet.setPlan(new Plan(this.testMethodsList.size()));
        String className = "";
        for (JUnitTestData testMethod : this.testMethodsList) {
            className = JUnitYAMLishUtils.extractClassName(testMethod.getDescription());
            TestResult tapTestResult = JUnitTAPUtils.generateTAPTestResult(testMethod, 1);
            testSet.addTestResult(tapTestResult);
        }
        File output = new File("./", className + "-SUITE.tap");
        this.tapProducer.dump(testSet, output);
    }

    protected void setTestInfo(Description description) {
        JUnitTestData testMethod = new JUnitTestData(false, false);
        testMethod.setDescription(description);
        this.testMethodsList.add(testMethod);
    }

    protected void setFailedTestsStatus(Result result) {
        if (result.getFailureCount() > 0) {
            for (Failure f : result.getFailures()) {
                for (JUnitTestData testMethod : this.testMethodsList) {
                    if (!testMethod.getDescription().getDisplayName().equals(f.getTestHeader())) continue;
                    testMethod.setFailed(true);
                    testMethod.setFailMessage(f.getMessage());
                    testMethod.setFailException(f.getException());
                    testMethod.setFailTrace(f.getTrace());
                }
            }
        }
    }
}

