# Contributing

Thank you for considering contributing to Iced! Feel free to read [the ecosystem overview] and [the roadmap] to get an idea of the current state of the library.

The main advice for new contributors is to share your ideas with the community. Introduce yourself over our [Discord server] or [start a discussion in an issue](https://github.com/iced-rs/iced/issues) explaining what you have in mind (do not be afraid of duplicated issues!).

This is a very important step. It helps to coordinate work, get on the same page, and start building trust. Please, do not skip it! Remember that [Code is the Easy Part] and also [The Hard Parts of Open Source]!

Provided you get in touch first, all kinds of contributions are welcome! Here are a few interesting ideas:

- New widgets: toggle, table, grid, color picker, video...
- New renderers: `iced_piet` (already in the works!), `iced_skia`, `iced_raqote`, `iced_pathfinder`...
- New shells: `iced_sdl` could be useful for gamedev!
- Better style generation for `iced_web`
- Optimizations for `iced_wgpu`: tiling, incremental rendering...
- Alternative to [`wgpu_glyph`] for proper (shaped), efficient text rendering
- Time travelling debugger built on top of Iced itself
- Testing library
- Cool website to serve on https://iced.rs

Besides directly writing code, there are many other different ways you can contribute. To name a few:

- Writing tutorials or blog posts
- Improving the documentation
- Submitting bug reports and use cases
- Sharing, discussing, researching and exploring new ideas

[the ecosystem overview]: ECOSYSTEM.md
[the roadmap]: ROADMAP.md
[Discord server]: https://discord.gg/3xZJ65GAhd
[Code is the Easy Part]: https://youtu.be/DSjbTC-hvqQ?t=1138
[The Hard Parts of Open Source]: https://www.youtube.com/watch?v=o_4EX4dPppA
[`wgpu_glyph`]: https://github.com/hecrj/wgpu_glyph
