<?php

namespace ccxt;

// PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
// https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

use Exception; // a common import
use \ccxt\ExchangeError;
use \ccxt\ArgumentsRequired;

class ripio extends Exchange {

    public function describe() {
        return $this->deep_extend(parent::describe (), array(
            'id' => 'ripio',
            'name' => 'Ripio',
            'countries' => array( 'AR', 'BR' ), // Argentina
            'rateLimit' => 50,
            'version' => 'v1',
            'pro' => true,
            // new metainfo interface
            'has' => array(
                'CORS' => false,
                'cancelOrder' => true,
                'createOrder' => true,
                'fetchBalance' => true,
                'fetchClosedOrders' => true,
                'fetchCurrencies' => true,
                'fetchMyTrades' => true,
                'fetchOpenOrders' => true,
                'fetchOrder' => true,
                'fetchOrderBook' => true,
                'fetchOrders' => true,
                'fetchTicker' => true,
                'fetchTickers' => true,
                'fetchTrades' => true,
            ),
            'urls' => array(
                'logo' => 'https://user-images.githubusercontent.com/1294454/94507548-a83d6a80-0218-11eb-9998-28b9cec54165.jpg',
                'api' => array(
                    'public' => 'https://api.exchange.ripio.com/api',
                    'private' => 'https://api.exchange.ripio.com/api',
                ),
                'www' => 'https://exchange.ripio.com',
                'doc' => array(
                    'https://exchange.ripio.com/en/api/',
                ),
                'fees' => 'https://exchange.ripio.com/en/fee',
            ),
            'api' => array(
                'public' => array(
                    'get' => array(
                        'rate/all/',
                        'rate/{pair}/',
                        'orderbook/{pair}/',
                        'tradehistory/{pair}/',
                        'pair/',
                        'currency/',
                        'orderbook/{pair}/depth/',
                    ),
                ),
                'private' => array(
                    'get' => array(
                        'balances/exchange_balances/',
                        'order/{pair}/{order_id}/',
                        'order/{pair}/',
                        'trade/{pair}/',
                    ),
                    'post' => array(
                        'order/{pair}/',
                        'order/{pair}/{order_id}/cancel/',
                    ),
                ),
            ),
            'fees' => array(
                'trading' => array(
                    'tierBased' => true,
                    'percentage' => true,
                    'taker' => 0.0 / 100,
                    'maker' => 0.0 / 100,
                ),
            ),
            'precisionMode' => TICK_SIZE,
            'requiredCredentials' => array(
                'apiKey' => true,
                'secret' => false,
            ),
            'exceptions' => array(
                'exact' => array(
                ),
                'broad' => array(
                    'Authentication credentials were not provided' => '\\ccxt\\AuthenticationError', // array("detail":"Authentication credentials were not provided.")
                    'Disabled pair' => '\\ccxt\\BadSymbol', // array("status_code":400,"errors":array("pair":["Invalid/Disabled pair BTC_ARS"]),"message":"An error has occurred, please check the form.")
                    'Invalid order type' => '\\ccxt\\InvalidOrder', // array("status_code":400,"errors":array("order_type":["Invalid order type. Valid options => ['MARKET', 'LIMIT']"]),"message":"An error has occurred, please check the form.")
                    'Your balance is not enough' => '\\ccxt\\InsufficientFunds', // array("status_code":400,"errors":array("non_field_errors":["Your balance is not enough for this order => You have 0 BTC but you need 1 BTC"]),"message":"An error has occurred, please check the form.")
                    "Order couldn't be created" => '\\ccxt\\ExchangeError', // array('status_code' => 400,'errors' => array('non_field_errors' => _("Order couldn't be created")), 'message' => _('Seems like an unexpected error occurred. Please try again later or write us to support@ripio.com if the problem persists.') )
                    // array("status_code":404,"errors":array("order":["Order 286e560e-b8a2-464b-8b84-15a7e2a67eab not found."]),"message":"An error has occurred, please check the form.")
                    // array("status_code":404,"errors":array("trade":["Trade <trade_id> not found."]),"message":"An error has occurred, please check the form.")
                    'not found' => '\\ccxt\\OrderNotFound',
                    'Invalid pair' => '\\ccxt\\BadSymbol', // array("status_code":400,"errors":array("pair":["Invalid pair FOOBAR"]),"message":"An error has occurred, please check the form.")
                    'amount must be a number' => '\\ccxt\\BadRequest', // array("status_code":400,"errors":array("amount":["amount must be a number"]),"message":"An error has occurred, please check the form.")
                    'Total must be at least' => '\\ccxt\\InvalidOrder', // array("status_code":400,"errors":array("non_field_errors":["Total must be at least 10."]),"message":"An error has occurred, please check the form.")
                    'Account not found' => '\\ccxt\\BadRequest', // array("error_description" => "Account not found."), "status" => 404
                    'Wrong password provided' => '\\ccxt\\AuthenticationError', // array('error' => "Wrong password provided."), “status_code” => 400
                    'User tokens limit' => '\\ccxt\\DDoSProtection', // array('error' => "User tokens limit. Can't create more than 10 tokens."), “status_code” => 400
                    'Something unexpected ocurred' => '\\ccxt\\ExchangeError', // array('status_code' => 400, 'errors' => array('non_field_errors' => 'Something unexpected ocurred!'), 'message' => 'Seems like an unexpected error occurred. Please try again later or write us to support@ripio.com if the problem persists.')
                    // array('status_code' => 404, 'errors' => array('account_balance' => ['Exchange balance <currency>not found.']),'message' => 'An error has occurred, please check the form.')
                    // array('status_code' => 404, 'errors' => array('account_balance' => ['Account balance <id> not found.']),'message' => 'An error has occurred, please check the form.')
                    'account_balance' => '\\ccxt\\BadRequest',
                ),
            ),
        ));
    }

    public function fetch_markets($params = array ()) {
        $response = $this->publicGetPair ($params);
        //
        //     {
        //         "next":null,
        //         "previous":null,
        //         "$results":array(
        //             array(
        //                 "$base":"BTC",
        //                 "base_name":"Bitcoin",
        //                 "$quote":"USDC",
        //                 "quote_name":"USD Coin",
        //                 "$symbol":"BTC_USDC",
        //                 "$fees":array(
        //                     array("traded_volume":0.0,"maker_fee":0.0,"taker_fee":0.0,"cancellation_fee":0.0)
        //                 ),
        //                 "country":"ZZ",
        //                 "enabled":true,
        //                 "priority":10,
        //                 "min_amount":"0.00001",
        //                 "price_tick":"0.000001",
        //                 "min_value":"10",
        //                 "limit_price_threshold":"25.00"
        //             ),
        //         )
        //     }
        //
        $result = array();
        $results = $this->safe_value($response, 'results', array());
        for ($i = 0; $i < count($results); $i++) {
            $market = $results[$i];
            $baseId = $this->safe_string($market, 'base');
            $quoteId = $this->safe_string($market, 'quote');
            $id = $this->safe_string($market, 'symbol');
            $base = $this->safe_currency_code($baseId);
            $quote = $this->safe_currency_code($quoteId);
            $symbol = $base . '/' . $quote;
            $precision = array(
                'amount' => $this->safe_float($market, 'min_amount'),
                'price' => $this->safe_float($market, 'price_tick'),
            );
            $limits = array(
                'amount' => array(
                    'min' => $this->safe_float($market, 'min_amount'),
                    'max' => null,
                ),
                'price' => array(
                    'min' => null,
                    'max' => null,
                ),
                'cost' => array(
                    'min' => $this->safe_float($market, 'min_value'),
                    'max' => null,
                ),
            );
            $active = $this->safe_value($market, 'enabled', true);
            $fees = $this->safe_value($market, 'fees', array());
            $firstFee = $this->safe_value($fees, 0, array());
            $maker = $this->safe_float($firstFee, 'maker_fee', 0.0);
            $taker = $this->safe_float($firstFee, 'taker_fee', 0.0);
            $result[] = array(
                'id' => $id,
                'symbol' => $symbol,
                'base' => $base,
                'quote' => $quote,
                'baseId' => $baseId,
                'quoteId' => $quoteId,
                'precision' => $precision,
                'maker' => $maker,
                'taker' => $taker,
                'limits' => $limits,
                'info' => $market,
                'active' => $active,
            );
        }
        return $result;
    }

    public function fetch_currencies($params = array ()) {
        $response = $this->publicGetCurrency ($params);
        //
        //     {
        //         "next":null,
        //         "previous":null,
        //         "$results":array(
        //             array(
        //                 "$name":"Argentine Peso",
        //                 "symbol":"$",
        //                 "$currency":"ARS",
        //                 "country":"AR",
        //                 "decimal_places":"2",
        //                 "enabled":true
        //             ),
        //             array(
        //                 "$name":"Bitcoin Cash",
        //                 "symbol":"BCH",
        //                 "$currency":"BCH",
        //                 "country":"AR",
        //                 "decimal_places":"8",
        //                 "enabled":true
        //             ),
        //             {
        //                 "$name":"Bitcoin",
        //                 "symbol":"BTC",
        //                 "$currency":"BTC",
        //                 "country":"AR",
        //                 "decimal_places":"8",
        //                 "enabled":true
        //             }
        //         )
        //     }
        //
        $results = $this->safe_value($response, 'results', array());
        $result = array();
        for ($i = 0; $i < count($results); $i++) {
            $currency = $results[$i];
            $id = $this->safe_string($currency, 'currency');
            $code = $this->safe_currency_code($id);
            $name = $this->safe_string($currency, 'name');
            $active = $this->safe_value($currency, 'enabled', true);
            $precision = $this->safe_integer($currency, 'decimal_places');
            $result[$code] = array(
                'id' => $id,
                'code' => $code,
                'name' => $name,
                'info' => $currency, // the original payload
                'active' => $active,
                'fee' => null,
                'precision' => $precision,
                'limits' => array(
                    'amount' => array( 'min' => null, 'max' => null ),
                    'price' => array( 'min' => null, 'max' => null ),
                    'cost' => array( 'min' => null, 'max' => null ),
                    'withdraw' => array( 'min' => null, 'max' => null ),
                ),
            );
        }
        return $result;
    }

    public function parse_ticker($ticker, $market = null) {
        //
        // fetchTicker, fetchTickers
        //
        //     {
        //         "pair":"BTC_USDC",
        //         "last_price":"10850.02",
        //         "low":"10720.03",
        //         "high":"10909.99",
        //         "variation":"1.21",
        //         "volume":"0.83868",
        //         "base":"BTC",
        //         "base_name":"Bitcoin",
        //         "quote":"USDC",
        //         "quote_name":"USD Coin",
        //         "bid":"10811.00",
        //         "ask":"10720.03",
        //         "avg":"10851.47",
        //         "ask_volume":"0.00140",
        //         "bid_volume":"0.00185",
        //         "created_at":"2020-09-28 21:44:51.228920+00:00"
        //     }
        //
        $timestamp = $this->parse8601($this->safe_string($ticker, 'created_at'));
        $marketId = $this->safe_string($ticker, 'pair');
        $symbol = $this->safe_symbol($marketId, $market);
        $last = $this->safe_float($ticker, 'last_price');
        $average = $this->safe_float($ticker, 'avg');
        return array(
            'symbol' => $symbol,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'high' => $this->safe_float($ticker, 'high'),
            'low' => $this->safe_float($ticker, 'low'),
            'bid' => $this->safe_float($ticker, 'bid'),
            'bidVolume' => $this->safe_float($ticker, 'bid_volume'),
            'ask' => $this->safe_float($ticker, 'ask'),
            'askVolume' => $this->safe_float($ticker, 'ask_volume'),
            'vwap' => null,
            'open' => null,
            'close' => $last,
            'last' => $last,
            'previousClose' => null,
            'change' => null,
            'percentage' => null,
            'average' => $average,
            'baseVolume' => null,
            'quoteVolume' => null,
            'info' => $ticker,
        );
    }

    public function fetch_ticker($symbol, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'pair' => $market['id'],
        );
        $response = $this->publicGetRatePair (array_merge($request, $params));
        //
        //     {
        //         "pair":"BTC_USDC",
        //         "last_price":"10850.02",
        //         "low":"10720.03",
        //         "high":"10909.99",
        //         "variation":"1.21",
        //         "volume":"0.83868",
        //         "base":"BTC",
        //         "base_name":"Bitcoin",
        //         "quote":"USDC",
        //         "quote_name":"USD Coin",
        //         "bid":"10811.00",
        //         "ask":"10720.03",
        //         "avg":"10851.47",
        //         "ask_volume":"0.00140",
        //         "bid_volume":"0.00185",
        //         "created_at":"2020-09-28 21:44:51.228920+00:00"
        //     }
        //
        return $this->parse_ticker($response, $market);
    }

    public function fetch_tickers($symbols = null, $params = array ()) {
        $this->load_markets();
        $response = $this->publicGetRateAll ($params);
        //
        //     array(
        //         {
        //             "pair":"BTC_USDC",
        //             "last_price":"10850.02",
        //             "low":"10720.03",
        //             "high":"10909.99",
        //             "variation":"1.21",
        //             "volume":"0.83868",
        //             "base":"BTC",
        //             "base_name":"Bitcoin",
        //             "quote":"USDC",
        //             "quote_name":"USD Coin",
        //             "bid":"10811.00",
        //             "ask":"10720.03",
        //             "avg":"10851.47",
        //             "ask_volume":"0.00140",
        //             "bid_volume":"0.00185",
        //             "created_at":"2020-09-28 21:44:51.228920+00:00"
        //         }
        //     )
        //
        $result = array();
        for ($i = 0; $i < count($response); $i++) {
            $ticker = $this->parse_ticker($response[$i]);
            $symbol = $ticker['symbol'];
            $result[$symbol] = $ticker;
        }
        return $this->filter_by_array($result, 'symbol', $symbols);
    }

    public function fetch_order_book($symbol, $limit = null, $params = array ()) {
        $this->load_markets();
        $request = array(
            'pair' => $this->market_id($symbol),
        );
        $response = $this->publicGetOrderbookPair (array_merge($request, $params));
        //
        //     {
        //         "buy":array(
        //             array("amount":"0.00230","total":"24.95","price":"10850.02"),
        //             array("amount":"0.07920","total":"858.52","price":"10840.00"),
        //             array("amount":"0.00277","total":"30.00","price":"10833.03"),
        //         ),
        //         "sell":array(
        //             array("amount":"0.03193","total":"348.16","price":"10904.00"),
        //             array("amount":"0.00210","total":"22.90","price":"10905.70"),
        //             array("amount":"0.00300","total":"32.72","price":"10907.98"),
        //         ),
        //         "updated_id":47225
        //     }
        //
        $orderbook = $this->parse_order_book($response, null, 'buy', 'sell', 'price', 'amount');
        $orderbook['nonce'] = $this->safe_integer($response, 'updated_id');
        return $orderbook;
    }

    public function parse_trade($trade, $market = null) {
        //
        // public fetchTrades, private fetchMyTrades
        //
        //     {
        //         "created_at":1601322501,
        //         "$amount":"0.00276",
        //         "$price":"10850.020000",
        //         "$side":"SELL",
        //         "pair":"BTC_USDC",
        //         "taker_fee":"0",
        //         "taker_side":"SELL",
        //         "maker_fee":"0",
        //         "taker":2577953,
        //         "maker":2577937
        //     }
        //
        // createOrder fills
        //
        //     {
        //         "pair":"BTC_USDC",
        //         "exchanged":0.002,
        //         "match_price":10593.99,
        //         "maker_fee":0.0,
        //         "taker_fee":0.0,
        //         "$timestamp":1601730306942
        //     }
        //
        $id = $this->safe_string($trade, 'id');
        $timestamp = $this->safe_integer($trade, 'timestamp');
        $timestamp = $this->safe_timestamp($trade, 'created_at', $timestamp);
        $side = $this->safe_string($trade, 'side');
        $takerSide = $this->safe_string($trade, 'taker_side');
        $takerOrMaker = ($takerSide === $side) ? 'taker' : 'maker';
        if ($side !== null) {
            $side = strtolower($side);
        }
        $price = $this->safe_float_2($trade, 'price', 'match_price');
        $amount = $this->safe_float_2($trade, 'amount', 'exchanged');
        $cost = null;
        if (($amount !== null) && ($price !== null)) {
            $cost = $amount * $price;
        }
        $marketId = $this->safe_string($trade, 'pair');
        $market = $this->safe_market($marketId, $market);
        $feeCost = $this->safe_float($trade, $takerOrMaker . '_fee');
        $orderId = $this->safe_string($trade, $takerOrMaker);
        $fee = null;
        if ($feeCost !== null) {
            $fee = array(
                'cost' => $feeCost,
                'currency' => ($side === 'buy') ? $market['base'] : $market['quote'],
            );
        }
        return array(
            'id' => $id,
            'order' => $orderId,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'symbol' => $market['symbol'],
            'type' => null,
            'side' => $side,
            'price' => $price,
            'amount' => $amount,
            'cost' => $cost,
            'takerOrMaker' => $takerOrMaker,
            'fee' => $fee,
            'info' => $trade,
        );
    }

    public function fetch_trades($symbol, $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'pair' => $market['id'],
        );
        $response = $this->publicGetTradehistoryPair (array_merge($request, $params));
        //
        //     array(
        //         {
        //             "created_at":1601322501,
        //             "amount":"0.00276",
        //             "price":"10850.020000",
        //             "side":"SELL",
        //             "pair":"BTC_USDC",
        //             "taker_fee":"0",
        //             "taker_side":"SELL",
        //             "maker_fee":"0",
        //             "taker":2577953,
        //             "maker":2577937
        //         }
        //     )
        //
        return $this->parse_trades($response, $market, $since, $limit);
    }

    public function fetch_balance($params = array ()) {
        $this->load_markets();
        $response = $this->privateGetBalancesExchangeBalances ($params);
        //
        //     array(
        //         array(
        //             "id":603794,
        //             "currency":"USD Coin",
        //             "symbol":"USDC",
        //             "available":"0",
        //             "locked":"0",
        //             "$code":"exchange",
        //             "balance_type":"crypto"
        //         ),
        //     )
        //
        $result = array( 'info' => $response );
        for ($i = 0; $i < count($response); $i++) {
            $balance = $response[$i];
            $currencyId = $this->safe_string($balance, 'symbol');
            $code = $this->safe_currency_code($currencyId);
            $account = $this->account();
            $account['free'] = $this->safe_float($balance, 'available');
            $account['used'] = $this->safe_float($balance, 'locked');
            $result[$code] = $account;
        }
        return $this->parse_balance($result);
    }

    public function create_order($symbol, $type, $side, $amount, $price = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $uppercaseType = strtoupper($type);
        $uppercaseSide = strtoupper($side);
        $request = array(
            'pair' => $market['id'],
            'order_type' => $uppercaseType, // LIMIT, MARKET
            'side' => $uppercaseSide, // BUY or SELL
            'amount' => $this->amount_to_precision($symbol, $amount),
        );
        if ($uppercaseType === 'LIMIT') {
            $request['limit_price'] = $this->price_to_precision($symbol, $price);
        }
        $response = $this->privatePostOrderPair (array_merge($request, $params));
        //
        //     {
        //         "order_id" => "160f523c-f6ef-4cd1-a7c9-1a8ede1468d8",
        //         "pair" => "BTC_ARS",
        //         "$side" => "BUY",
        //         "$amount" => "0.00400",
        //         "notional" => null,
        //         "fill_or_kill" => false,
        //         "all_or_none" => false,
        //         "order_type" => "LIMIT",
        //         "status" => "OPEN",
        //         "created_at" => 1578413945,
        //         "filled" => "0.00000",
        //         "limit_price" => "10.00",
        //         "stop_price" => null,
        //         "distance" => null
        //     }
        //
        // createOrder $market $type
        //
        //     {
        //         "order_id":"d6b60c01-8624-44f2-9e6c-9e8cd677ea5c",
        //         "pair":"BTC_USDC",
        //         "$side":"BUY",
        //         "$amount":"0.00200",
        //         "notional":"50",
        //         "fill_or_kill":false,
        //         "all_or_none":false,
        //         "order_type":"MARKET",
        //         "status":"OPEN",
        //         "created_at":1601730306,
        //         "filled":"0.00000",
        //         "fill_price":10593.99,
        //         "fee":0.0,
        //         "fills":array(
        //             {
        //                 "pair":"BTC_USDC",
        //                 "exchanged":0.002,
        //                 "match_price":10593.99,
        //                 "maker_fee":0.0,
        //                 "taker_fee":0.0,
        //                 "timestamp":1601730306942
        //             }
        //         ),
        //         "filled_at":"2020-10-03T13:05:06.942186Z",
        //         "limit_price":"0.000000",
        //         "stop_price":null,
        //         "distance":null
        //     }
        //
        return $this->parse_order($response, $market);
    }

    public function cancel_order($id, $symbol = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' cancelOrder() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'pair' => $market['id'],
            'order_id' => $id,
        );
        $response = $this->privatePostOrderPairOrderIdCancel (array_merge($request, $params));
        //
        //     {
        //         "order_id" => "286e560e-b8a2-464b-8b84-15a7e2a67eab",
        //         "pair" => "BTC_ARS",
        //         "side" => "SELL",
        //         "amount" => "0.00100",
        //         "notional" => null,
        //         "fill_or_kill" => false,
        //         "all_or_none" => false,
        //         "order_type" => "LIMIT",
        //         "status" => "CANC",
        //         "created_at" => 1575472707,
        //         "filled" => "0.00000",
        //         "limit_price" => "681000.00",
        //         "stop_price" => null,
        //         "distance" => null
        //     }
        //
        return $this->parse_order($response, $market);
    }

    public function fetch_order($id, $symbol = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchOrder() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'pair' => $market['id'],
            'order_id' => $id,
        );
        $response = $this->privateGetOrderPairOrderId (array_merge($request, $params));
        //
        //     {
        //         "order_id" => "0b4ff48e-cfd6-42db-8d8c-3b536da447af",
        //         "pair" => "BTC_ARS",
        //         "side" => "BUY",
        //         "amount" => "0.00100",
        //         "notional" => null,
        //         "fill_or_kill" => false,
        //         "all_or_none" => false,
        //         "order_type" => "LIMIT",
        //         "status" => "OPEN",
        //         "created_at" => 1575472944,
        //         "filled" => "0.00000",
        //         "limit_price" => "661000.00",
        //         "stop_price" => null,
        //         "distance" => null
        //     }
        //
        return $this->parse_order($response, $market);
    }

    public function fetch_orders($symbol = null, $since = null, $limit = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchOrders() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'pair' => $market['id'],
            // 'status' => 'OPEN,PART,CLOS,CANC,COMP',
            // 'offset' => 0,
            // 'limit' => $limit,
        );
        if ($limit !== null) {
            $request['offset'] = $limit;
        }
        $response = $this->privateGetOrderPair (array_merge($request, $params));
        //
        //     {
        //         "next" => "https://api.exchange.ripio.com/api/v1/order/BTC_ARS/?$limit=20&offset=20&page=1&page_size=25&status=OPEN%2CPART",
        //         "previous" => null,
        //         "$results" => {
        //             "$data" => array(
        //                 array(
        //                     "order_id" => "ca74280b-6966-4b73-a720-68709078922b",
        //                     "pair" => "BTC_ARS",
        //                     "side" => "SELL",
        //                     "amount" => "0.00100",
        //                     "notional" => null,
        //                     "fill_or_kill" => false,
        //                     "all_or_none" => false,
        //                     "order_type" => "LIMIT",
        //                     "status" => "OPEN",
        //                     "created_at" => 1578340134,
        //                     "filled" => "0.00000",
        //                     "limit_price" => "665000.00",
        //                     "stop_price" => null,
        //                     "distance" => null
        //                 ),
        //             )
        //         }
        //     }
        //
        $results = $this->safe_value($response, 'results', array());
        $data = $this->safe_value($results, 'data', array());
        return $this->parse_orders($data, $market, $since, $limit);
    }

    public function fetch_open_orders($symbol = null, $since = null, $limit = null, $params = array ()) {
        $request = array(
            'status' => 'OPEN,PART',
        );
        return $this->fetch_orders($symbol, $since, $limit, array_merge($request, $params));
    }

    public function fetch_closed_orders($symbol = null, $since = null, $limit = null, $params = array ()) {
        $request = array(
            'status' => 'CLOS,CANC,COMP',
        );
        return $this->fetch_orders($symbol, $since, $limit, array_merge($request, $params));
    }

    public function parse_order_status($status) {
        $statuses = array(
            'OPEN' => 'open',
            'PART' => 'open',
            'CLOS' => 'canceled',
            'CANC' => 'canceled',
            'COMP' => 'closed',
        );
        return $this->safe_string($statuses, $status, $status);
    }

    public function parse_order($order, $market = null) {
        //
        // createOrder, cancelOrder, fetchOpenOrders, fetchClosedOrders, fetchOrders, fetchOrder
        //
        //     {
        //         "order_id" => "286e560e-b8a2-464b-8b84-15a7e2a67eab",
        //         "pair" => "BTC_ARS",
        //         "$side" => "SELL",
        //         "$amount" => "0.00100",
        //         "notional" => null,
        //         "fill_or_kill" => false,
        //         "all_or_none" => false,
        //         "order_type" => "LIMIT",
        //         "$status" => "CANC",
        //         "created_at" => 1575472707,
        //         "$filled" => "0.00000",
        //         "limit_price" => "681000.00",
        //         "stop_price" => null,
        //         "distance" => null
        //     }
        //
        //     {
        //         "order_id":"d6b60c01-8624-44f2-9e6c-9e8cd677ea5c",
        //         "pair":"BTC_USDC",
        //         "$side":"BUY",
        //         "$amount":"0.00200",
        //         "notional":"50",
        //         "fill_or_kill":false,
        //         "all_or_none":false,
        //         "order_type":"MARKET",
        //         "$status":"OPEN",
        //         "created_at":1601730306,
        //         "$filled":"0.00000",
        //         "fill_price":10593.99,
        //         "fee":0.0,
        //         "$fills":array(
        //             {
        //                 "pair":"BTC_USDC",
        //                 "exchanged":0.002,
        //                 "match_price":10593.99,
        //                 "maker_fee":0.0,
        //                 "taker_fee":0.0,
        //                 "$timestamp":1601730306942
        //             }
        //         ),
        //         "filled_at":"2020-10-03T13:05:06.942186Z",
        //         "limit_price":"0.000000",
        //         "stop_price":null,
        //         "distance":null
        //     }
        //
        $id = $this->safe_string($order, 'order_id');
        $amount = $this->safe_float($order, 'amount');
        $cost = $this->safe_float($order, 'notional');
        $type = $this->safe_string_lower($order, 'order_type');
        $priceField = ($type === 'market') ? 'fill_price' : 'limit_price';
        $price = $this->safe_float($order, $priceField);
        $side = $this->safe_string_lower($order, 'side');
        $status = $this->parse_order_status($this->safe_string($order, 'status'));
        $timestamp = $this->safe_timestamp($order, 'created_at');
        $average = $this->safe_value($order, 'fill_price');
        $filled = $this->safe_float($order, 'filled');
        $remaining = null;
        $fills = $this->safe_value($order, 'fills');
        $trades = null;
        $lastTradeTimestamp = null;
        if ($fills !== null) {
            $numFills = is_array($fills) ? count($fills) : 0;
            if ($numFills > 0) {
                $filled = 0;
                $cost = 0;
                $trades = $this->parse_trades($fills, $market, null, null, array(
                    'order' => $id,
                    'side' => $side,
                ));
                for ($i = 0; $i < count($trades); $i++) {
                    $trade = $trades[$i];
                    $filled = $this->sum($trade['amount'], $filled);
                    $cost = $this->sum($trade['cost'], $cost);
                    $lastTradeTimestamp = $trade['timestamp'];
                }
                if (($average === null) && ($filled > 0)) {
                    $average = $cost / $filled;
                }
            }
        }
        if ($filled !== null) {
            if (($cost === null) && ($price !== null)) {
                $cost = $price * $filled;
            }
            if ($amount !== null) {
                $remaining = max (0, $amount - $filled);
            }
        }
        $marketId = $this->safe_string($order, 'pair');
        $symbol = $this->safe_symbol($marketId, $market, '_');
        $stopPrice = $this->safe_float($order, 'stop_price');
        return array(
            'id' => $id,
            'clientOrderId' => null,
            'info' => $order,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'lastTradeTimestamp' => $lastTradeTimestamp,
            'symbol' => $symbol,
            'type' => $type,
            'timeInForce' => null,
            'postOnly' => null,
            'side' => $side,
            'price' => $price,
            'stopPrice' => $stopPrice,
            'amount' => $amount,
            'cost' => $cost,
            'average' => $average,
            'filled' => $filled,
            'remaining' => $remaining,
            'status' => $status,
            'fee' => null,
            'trades' => $trades,
        );
    }

    public function fetch_my_trades($symbol = null, $since = null, $limit = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchMyTrades() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'pair' => $market['id'],
            // 'offset' => 0,
            // 'limit' => $limit,
        );
        if ($limit !== null) {
            $request['limit'] = $limit;
        }
        $response = $this->privateGetTradePair (array_merge($request, $params));
        //
        //     {
        //         "next" => "https://api.exchange.ripio.com/api/v1/trade/<pair>/?$limit=20&offset=20",
        //         "previous" => null,
        //         "$results" => {
        //             "$data" => array(
        //                 array(
        //                     "created_at" => 1578414028,
        //                     "amount" => "0.00100",
        //                     "price" => "665000.00",
        //                     "side" => "BUY",
        //                     "taker_fee" => "0",
        //                     "taker_side" => "BUY",
        //                     "match_price" => "66500000",
        //                     "maker_fee" => "0",
        //                     "taker" => 4892,
        //                     "maker" => 4889
        //                 ),
        //             )
        //         }
        //     }
        //
        $results = $this->safe_value($response, 'results', array());
        $data = $this->safe_value($results, 'data', array());
        return $this->parse_trades($data, $market, $since, $limit);
    }

    public function sign($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $request = '/' . $this->version . '/' . $this->implode_params($path, $params);
        $url = $this->urls['api'][$api] . $request;
        $query = $this->omit($params, $this->extract_params($path));
        if ($api === 'public') {
            if ($query) {
                $url .= '?' . $this->urlencode($query);
            }
        } else if ($api === 'private') {
            $this->check_required_credentials();
            if ($method === 'POST') {
                $body = $this->json($query);
            } else {
                if ($query) {
                    $url .= '?' . $this->urlencode($query);
                }
            }
            $headers = array(
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $this->apiKey,
            );
        }
        return array( 'url' => $url, 'method' => $method, 'body' => $body, 'headers' => $headers );
    }

    public function handle_errors($code, $reason, $url, $method, $headers, $body, $response, $requestHeaders, $requestBody) {
        if ($response === null) {
            return;
        }
        //
        //      array("$detail":"Authentication credentials were not provided.")
        //      array("status_code":400,"$errors":array("pair":["Invalid pair FOOBAR"]),"$message":"An $error has occurred, please check the form.")
        //      array("status_code":400,"$errors":array("order_type":["Invalid order type. Valid options => ['MARKET', 'LIMIT']"]),"$message":"An $error has occurred, please check the form.")
        //      array("status_code":400,"$errors":array("non_field_errors":"Something unexpected ocurred!"),"$message":"Seems like an unexpected $error occurred. Please try again later or write us to support@ripio.com if the problem persists.")
        //      array("status_code":400,"$errors":array("pair":["Invalid/Disabled pair BTC_ARS"]),"$message":"An $error has occurred, please check the form.")
        //
        $detail = $this->safe_string($response, 'detail');
        if ($detail !== null) {
            $feedback = $this->id . ' ' . $body;
            // $this->throw_exactly_matched_exception($this->exceptions['exact'], $message, $feedback);
            $this->throw_broadly_matched_exception($this->exceptions['broad'], $detail, $feedback);
        }
        $errors = $this->safe_value($response, 'errors');
        if ($errors !== null) {
            $feedback = $this->id . ' ' . $body;
            $keys = is_array($errors) ? array_keys($errors) : array();
            for ($i = 0; $i < count($keys); $i++) {
                $key = $keys[$i];
                $error = $this->safe_value($errors, $key, array());
                $message = $this->safe_string($error, 0);
                // $this->throw_exactly_matched_exception($this->exceptions['exact'], $message, $feedback);
                $this->throw_broadly_matched_exception($this->exceptions['broad'], $message, $feedback);
            }
            throw new ExchangeError($feedback); // unknown $message
        }
    }
}
