<?php

namespace ccxt;

// PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
// https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

use Exception; // a common import
use \ccxt\ExchangeError;
use \ccxt\ArgumentsRequired;
use \ccxt\InvalidOrder;
use \ccxt\NotSupported;

class bitget extends Exchange {

    public function describe() {
        return $this->deep_extend(parent::describe (), array(
            'id' => 'bitget',
            'name' => 'Bitget',
            'countries' => array( 'SG' ),
            'version' => 'v3',
            'rateLimit' => 1000, // up to 3000 requests per 5 minutes ≈ 600 requests per minute ≈ 10 requests per second ≈ 100 ms
            'has' => array(
                'cancelOrder' => true,
                'cancelOrders' => true,
                'CORS' => false,
                'createOrder' => true,
                'fetchAccounts' => true,
                'fetchBalance' => true,
                'fetchCurrencies' => true,
                'fetchDeposits' => true,
                'fetchMarkets' => true,
                'fetchMyTrades' => true,
                'fetchOHLCV' => true,
                'fetchOrder' => true,
                'fetchOrderBook' => true,
                'fetchOpenOrders' => true,
                'fetchClosedOrders' => true,
                'fetchOrderTrades' => true,
                'fetchTicker' => true,
                'fetchTickers' => true,
                'fetchTime' => true,
                'fetchTrades' => true,
                'fetchWithdrawals' => true,
            ),
            'timeframes' => array(
                '1m' => '1m',
                '5m' => '5m',
                '15m' => '15m',
                '30m' => '30m',
                '1h' => '1h',
                '2h' => '2h',
                '4h' => '4h',
                '6h' => '6h',
                '12h' => '12h',
                '1d' => '1d',
                '1w' => '1w',
            ),
            'hostname' => 'bitget.com',
            'urls' => array(
                'logo' => 'https://user-images.githubusercontent.com/51840849/88317935-a8a21c80-cd22-11ea-8e2b-4b9fac5975eb.jpg',
                'api' => array(
                    'data' => 'https://api.{hostname}',
                    'api' => 'https://api.{hostname}',
                    'capi' => 'https://capi.{hostname}',
                    'swap' => 'https://capi.{hostname}',
                ),
                'www' => 'https://www.bitget.com',
                'doc' => array(
                    'https://bitgetlimited.github.io/apidoc/en/swap',
                    'https://bitgetlimited.github.io/apidoc/en/spot',
                ),
                'fees' => 'https://www.bitget.cc/zh-CN/rate?tab=1',
                'test' => array(
                    'rest' => 'https://testnet.bitget.com',
                ),
                'referral' => 'https://www.bitget.com/expressly?languageType=0&channelCode=ccxt&vipCode=tg9j',
            ),
            'api' => array(
                'data' => array(
                    'get' => array(
                        'market/history/kline', // Kline data
                        'market/detail/merged', // Get aggregated ticker
                        'market/tickers', // Get all trading tickers
                        'market/allticker', // Get all trading market method 2
                        'market/depth', // Get Market Depth Data
                        'market/trade', // Get Trade Detail Data
                        'market/history/trade', // Get record of trading
                        'market/detail', // Get Market Detail 24h Volume
                        'common/symbols', // Query all trading pairs and accuracy supported in the station
                        'common/currencys', // Query all currencies supported in the station
                        'common/timestamp', // Query system current time
                    ),
                ),
                'api' => array(
                    'get' => array(
                        'account/accounts', // Get all accounts of current user(即account_id)。
                        'accounts/{account_id}/balance', // Get the balance of the specified account
                        'order/orders', // Query order, deprecated
                        'order/orders/openOrders',
                        'order/orders/history',
                        'order/deposit_withdraw', // Query assets history
                    ),
                    'post' => array(
                        'order/orders/place', // Place order
                        'order/orders/{order_id}/submitcancel', // Request to cancel an order request
                        'order/orders/batchcancel', // Bulk order cancellation
                        'order/orders/{order_id}', // Query an order details
                        'order/orders/{order_id}/matchresults', // Query the transaction details of an order
                        'order/matchresults', // Query current order, order history
                    ),
                ),
                'capi' => array(
                    'get' => array(
                        'market/time',
                        'market/contracts',
                        'market/depth',
                        'market/tickers',
                        'market/ticker',
                        'market/trades',
                        'market/candles',
                        'market/index',
                        'market/open_count',
                        'market/open_interest',
                        'market/price_limit',
                        'market/funding_time',
                        'market/mark_price',
                        'market/open_count',
                        'market/historyFundRate',
                    ),
                ),
                'swap' => array(
                    'get' => array(
                        'account/accounts',
                        'account/account',
                        'account/settings',
                        'position/allPosition',
                        'position/singlePosition',
                        'position/holds',
                        'order/detail',
                        'order/orders',
                        'order/fills',
                        'order/current',
                        'order/currentPlan', // conditional
                        'order/history',
                        'order/historyPlan', // conditional
                        'trace/closeTrack',
                        'trace/currentTrack',
                        'trace/historyTrack',
                    ),
                    'post' => array(
                        'account/leverage',
                        'account/adjustMargin',
                        'account/modifyAutoAppendMargin',
                        'order/placeOrder',
                        'order/batchOrders',
                        'order/cancel_order',
                        'order/cancel_batch_orders',
                        'order/plan_order',
                        'order/cancel_plan',
                        'position/changeHoldModel',
                    ),
                ),
            ),
            'fees' => array(
                'spot' => array(
                    'taker' => 0.002,
                    'maker' => 0.002,
                ),
                'swap' => array(
                    'taker' => 0.0006,
                    'maker' => 0.0004,
                ),
            ),
            'requiredCredentials' => array(
                'apiKey' => true,
                'secret' => true,
                'password' => true,
            ),
            'exceptions' => array(
                // http error codes
                // 400 Bad Request — Invalid request format
                // 401 Unauthorized — Invalid API Key
                // 403 Forbidden — You do not have access to the requested resource
                // 404 Not Found
                // 500 Internal Server Error — We had a problem with our server
                'exact' => array(
                    '1' => '\\ccxt\\ExchangeError', // array( "code" => 1, "message" => "System error" )
                    // undocumented
                    'failure to get a peer from the ring-balancer' => '\\ccxt\\ExchangeNotAvailable', // array( "message" => "failure to get a peer from the ring-balancer" )
                    '4010' => '\\ccxt\\PermissionDenied', // array( "code" => 4010, "message" => "For the security of your funds, withdrawals are not permitted within 24 hours after changing fund password  / mobile number / Google Authenticator settings " )
                    // common
                    // '0' => '\\ccxt\\ExchangeError', // 200 successful,when the order placement / cancellation / operation is successful
                    '4001' => '\\ccxt\\ExchangeError', // no data received in 30s
                    '4002' => '\\ccxt\\ExchangeError', // Buffer full. cannot write data
                    // --------------------------------------------------------
                    '30001' => '\\ccxt\\AuthenticationError', // array( "code" => 30001, "message" => 'request header "OK_ACCESS_KEY" cannot be blank')
                    '30002' => '\\ccxt\\AuthenticationError', // array( "code" => 30002, "message" => 'request header "OK_ACCESS_SIGN" cannot be blank')
                    '30003' => '\\ccxt\\AuthenticationError', // array( "code" => 30003, "message" => 'request header "OK_ACCESS_TIMESTAMP" cannot be blank')
                    '30004' => '\\ccxt\\AuthenticationError', // array( "code" => 30004, "message" => 'request header "OK_ACCESS_PASSPHRASE" cannot be blank')
                    '30005' => '\\ccxt\\InvalidNonce', // array( "code" => 30005, "message" => "invalid OK_ACCESS_TIMESTAMP" )
                    '30006' => '\\ccxt\\AuthenticationError', // array( "code" => 30006, "message" => "invalid OK_ACCESS_KEY" )
                    '30007' => '\\ccxt\\BadRequest', // array( "code" => 30007, "message" => 'invalid Content_Type, please use "application/json" format')
                    '30008' => '\\ccxt\\RequestTimeout', // array( "code" => 30008, "message" => "timestamp request expired" )
                    '30009' => '\\ccxt\\ExchangeError', // array( "code" => 30009, "message" => "system error" )
                    '30010' => '\\ccxt\\AuthenticationError', // array( "code" => 30010, "message" => "API validation failed" )
                    '30011' => '\\ccxt\\PermissionDenied', // array( "code" => 30011, "message" => "invalid IP" )
                    '30012' => '\\ccxt\\AuthenticationError', // array( "code" => 30012, "message" => "invalid authorization" )
                    '30013' => '\\ccxt\\AuthenticationError', // array( "code" => 30013, "message" => "invalid sign" )
                    '30014' => '\\ccxt\\DDoSProtection', // array( "code" => 30014, "message" => "request too frequent" )
                    '30015' => '\\ccxt\\AuthenticationError', // array( "code" => 30015, "message" => 'request header "OK_ACCESS_PASSPHRASE" incorrect')
                    '30016' => '\\ccxt\\ExchangeError', // array( "code" => 30015, "message" => "you are using v1 apiKey, please use v1 endpoint. If you would like to use v3 endpoint, please subscribe to v3 apiKey" )
                    '30017' => '\\ccxt\\ExchangeError', // array( "code" => 30017, "message" => "apikey's broker id does not match" )
                    '30018' => '\\ccxt\\ExchangeError', // array( "code" => 30018, "message" => "apikey's domain does not match" )
                    '30019' => '\\ccxt\\ExchangeNotAvailable', // array( "code" => 30019, "message" => "Api is offline or unavailable" )
                    '30020' => '\\ccxt\\BadRequest', // array( "code" => 30020, "message" => "body cannot be blank" )
                    '30021' => '\\ccxt\\BadRequest', // array( "code" => 30021, "message" => "Json data format error" ), array( "code" => 30021, "message" => "json data format error" )
                    '30022' => '\\ccxt\\PermissionDenied', // array( "code" => 30022, "message" => "Api has been frozen" )
                    '30023' => '\\ccxt\\BadRequest', // array( "code" => 30023, "message" => "{0} parameter cannot be blank" )
                    '30024' => '\\ccxt\\BadSymbol', // array("code":30024,"message":"\"instrument_id\" is an invalid parameter")
                    '30025' => '\\ccxt\\BadRequest', // array( "code" => 30025, "message" => "{0} parameter category error" )
                    '30026' => '\\ccxt\\DDoSProtection', // array( "code" => 30026, "message" => "requested too frequent" )
                    '30027' => '\\ccxt\\AuthenticationError', // array( "code" => 30027, "message" => "login failure" )
                    '30028' => '\\ccxt\\PermissionDenied', // array( "code" => 30028, "message" => "unauthorized execution" )
                    '30029' => '\\ccxt\\AccountSuspended', // array( "code" => 30029, "message" => "account suspended" )
                    '30030' => '\\ccxt\\ExchangeError', // array( "code" => 30030, "message" => "endpoint request failed. Please try again" )
                    '30031' => '\\ccxt\\BadRequest', // array( "code" => 30031, "message" => "token does not exist" )
                    '30032' => '\\ccxt\\BadSymbol', // array( "code" => 30032, "message" => "pair does not exist" )
                    '30033' => '\\ccxt\\BadRequest', // array( "code" => 30033, "message" => "exchange domain does not exist" )
                    '30034' => '\\ccxt\\ExchangeError', // array( "code" => 30034, "message" => "exchange ID does not exist" )
                    '30035' => '\\ccxt\\ExchangeError', // array( "code" => 30035, "message" => "trading is not supported in this website" )
                    '30036' => '\\ccxt\\ExchangeError', // array( "code" => 30036, "message" => "no relevant data" )
                    '30037' => '\\ccxt\\ExchangeNotAvailable', // array( "code" => 30037, "message" => "endpoint is offline or unavailable" )
                    // '30038' => '\\ccxt\\AuthenticationError', // array( "code" => 30038, "message" => "user does not exist" )
                    '30038' => '\\ccxt\\OnMaintenance', // array("client_oid":"","code":"30038","error_code":"30038","error_message":"Matching engine is being upgraded. Please try in about 1 minute.","message":"Matching engine is being upgraded. Please try in about 1 minute.","order_id":"-1","result":false)
                    // futures
                    '32001' => '\\ccxt\\AccountSuspended', // array( "code" => 32001, "message" => "futures account suspended" )
                    '32002' => '\\ccxt\\PermissionDenied', // array( "code" => 32002, "message" => "futures account does not exist" )
                    '32003' => '\\ccxt\\CancelPending', // array( "code" => 32003, "message" => "canceling, please wait" )
                    '32004' => '\\ccxt\\ExchangeError', // array( "code" => 32004, "message" => "you have no unfilled orders" )
                    '32005' => '\\ccxt\\InvalidOrder', // array( "code" => 32005, "message" => "max order quantity" )
                    '32006' => '\\ccxt\\InvalidOrder', // array( "code" => 32006, "message" => "the order price or trigger price exceeds USD 1 million" )
                    '32007' => '\\ccxt\\InvalidOrder', // array( "code" => 32007, "message" => "leverage level must be the same for orders on the same side of the contract" )
                    '32008' => '\\ccxt\\InvalidOrder', // array( "code" => 32008, "message" => "Max. positions to open (cross margin)" )
                    '32009' => '\\ccxt\\InvalidOrder', // array( "code" => 32009, "message" => "Max. positions to open (fixed margin)" )
                    '32010' => '\\ccxt\\ExchangeError', // array( "code" => 32010, "message" => "leverage cannot be changed with open positions" )
                    '32011' => '\\ccxt\\ExchangeError', // array( "code" => 32011, "message" => "futures status error" )
                    '32012' => '\\ccxt\\ExchangeError', // array( "code" => 32012, "message" => "futures order update error" )
                    '32013' => '\\ccxt\\ExchangeError', // array( "code" => 32013, "message" => "token type is blank" )
                    '32014' => '\\ccxt\\ExchangeError', // array( "code" => 32014, "message" => "your number of contracts closing is larger than the number of contracts available" )
                    '32015' => '\\ccxt\\ExchangeError', // array( "code" => 32015, "message" => "margin ratio is lower than 100% before opening positions" )
                    '32016' => '\\ccxt\\ExchangeError', // array( "code" => 32016, "message" => "margin ratio is lower than 100% after opening position" )
                    '32017' => '\\ccxt\\ExchangeError', // array( "code" => 32017, "message" => "no BBO" )
                    '32018' => '\\ccxt\\ExchangeError', // array( "code" => 32018, "message" => "the order quantity is less than 1, please try again" )
                    '32019' => '\\ccxt\\ExchangeError', // array( "code" => 32019, "message" => "the order price deviates from the price of the previous minute by more than 3%" )
                    '32020' => '\\ccxt\\ExchangeError', // array( "code" => 32020, "message" => "the price is not in the range of the price limit" )
                    '32021' => '\\ccxt\\ExchangeError', // array( "code" => 32021, "message" => "leverage error" )
                    '32022' => '\\ccxt\\ExchangeError', // array( "code" => 32022, "message" => "this function is not supported in your country or region according to the regulations" )
                    '32023' => '\\ccxt\\ExchangeError', // array( "code" => 32023, "message" => "this account has outstanding loan" )
                    '32024' => '\\ccxt\\ExchangeError', // array( "code" => 32024, "message" => "order cannot be placed during delivery" )
                    '32025' => '\\ccxt\\ExchangeError', // array( "code" => 32025, "message" => "order cannot be placed during settlement" )
                    '32026' => '\\ccxt\\ExchangeError', // array( "code" => 32026, "message" => "your account is restricted from opening positions" )
                    '32027' => '\\ccxt\\ExchangeError', // array( "code" => 32027, "message" => "cancelled over 20 orders" )
                    '32028' => '\\ccxt\\AccountSuspended', // array( "code" => 32028, "message" => "account is suspended and liquidated" )
                    '32029' => '\\ccxt\\ExchangeError', // array( "code" => 32029, "message" => "order info does not exist" )
                    '32030' => '\\ccxt\\InvalidOrder', // The order cannot be cancelled
                    '32031' => '\\ccxt\\ArgumentsRequired', // client_oid or order_id is required.
                    '32038' => '\\ccxt\\AuthenticationError', // User does not exist
                    '32040' => '\\ccxt\\ExchangeError', // User have open contract orders or position
                    '32044' => '\\ccxt\\ExchangeError', // array( "code" => 32044, "message" => "The margin ratio after submitting this order is lower than the minimum requirement ({0}) for your tier." )
                    '32045' => '\\ccxt\\ExchangeError', // String of commission over 1 million
                    '32046' => '\\ccxt\\ExchangeError', // Each user can hold up to 10 trade plans at the same time
                    '32047' => '\\ccxt\\ExchangeError', // system error
                    '32048' => '\\ccxt\\InvalidOrder', // Order strategy track range error
                    '32049' => '\\ccxt\\ExchangeError', // Each user can hold up to 10 track plans at the same time
                    '32050' => '\\ccxt\\InvalidOrder', // Order strategy rang error
                    '32051' => '\\ccxt\\InvalidOrder', // Order strategy ice depth error
                    '32052' => '\\ccxt\\ExchangeError', // String of commission over 100 thousand
                    '32053' => '\\ccxt\\ExchangeError', // Each user can hold up to 6 ice plans at the same time
                    '32057' => '\\ccxt\\ExchangeError', // The order price is zero. Market-close-all function cannot be executed
                    '32054' => '\\ccxt\\ExchangeError', // Trade not allow
                    '32055' => '\\ccxt\\InvalidOrder', // cancel order error
                    '32056' => '\\ccxt\\ExchangeError', // iceberg per order average should between {0}-{1} contracts
                    '32058' => '\\ccxt\\ExchangeError', // Each user can hold up to 6 initiative plans at the same time
                    '32059' => '\\ccxt\\InvalidOrder', // Total amount should exceed per order amount
                    '32060' => '\\ccxt\\InvalidOrder', // Order strategy type error
                    '32061' => '\\ccxt\\InvalidOrder', // Order strategy initiative limit error
                    '32062' => '\\ccxt\\InvalidOrder', // Order strategy initiative range error
                    '32063' => '\\ccxt\\InvalidOrder', // Order strategy initiative rate error
                    '32064' => '\\ccxt\\ExchangeError', // Time Stringerval of orders should set between 5-120s
                    '32065' => '\\ccxt\\ExchangeError', // Close amount exceeds the limit of Market-close-all (999 for BTC, and 9999 for the rest tokens)
                    '32066' => '\\ccxt\\ExchangeError', // You have open orders. Please cancel all open orders before changing your leverage level.
                    '32067' => '\\ccxt\\ExchangeError', // Account equity < required margin in this setting. Please adjust your leverage level again.
                    '32068' => '\\ccxt\\ExchangeError', // The margin for this position will fall short of the required margin in this setting. Please adjust your leverage level or increase your margin to proceed.
                    '32069' => '\\ccxt\\ExchangeError', // Target leverage level too low. Your account balance is insufficient to cover the margin required. Please adjust the leverage level again.
                    '32070' => '\\ccxt\\ExchangeError', // Please check open position or unfilled order
                    '32071' => '\\ccxt\\ExchangeError', // Your current liquidation mode does not support this action.
                    '32072' => '\\ccxt\\ExchangeError', // The highest available margin for your order’s tier is {0}. Please edit your margin and place a new order.
                    '32073' => '\\ccxt\\ExchangeError', // The action does not apply to the token
                    '32074' => '\\ccxt\\ExchangeError', // The number of contracts of your position, open orders, and the current order has exceeded the maximum order limit of this asset.
                    '32075' => '\\ccxt\\ExchangeError', // Account risk rate breach
                    '32076' => '\\ccxt\\ExchangeError', // Liquidation of the holding position(s) at market price will require cancellation of all pending close orders of the contracts.
                    '32077' => '\\ccxt\\ExchangeError', // Your margin for this asset in futures account is insufficient and the position has been taken over for liquidation. (You will not be able to place orders, close positions, transfer funds, or add margin during this period of time. Your account will be restored after the liquidation is complete.)
                    '32078' => '\\ccxt\\ExchangeError', // Please cancel all open orders before switching the liquidation mode(Please cancel all open orders before switching the liquidation mode)
                    '32079' => '\\ccxt\\ExchangeError', // Your open positions are at high risk.(Please add margin or reduce positions before switching the mode)
                    '32080' => '\\ccxt\\ExchangeError', // Funds cannot be transferred out within 30 minutes after futures settlement
                    '32083' => '\\ccxt\\ExchangeError', // The number of contracts should be a positive multiple of %%. Please place your order again
                    // token and margin trading
                    '33001' => '\\ccxt\\PermissionDenied', // array( "code" => 33001, "message" => "margin account for this pair is not enabled yet" )
                    '33002' => '\\ccxt\\AccountSuspended', // array( "code" => 33002, "message" => "margin account for this pair is suspended" )
                    '33003' => '\\ccxt\\InsufficientFunds', // array( "code" => 33003, "message" => "no loan balance" )
                    '33004' => '\\ccxt\\ExchangeError', // array( "code" => 33004, "message" => "loan amount cannot be smaller than the minimum limit" )
                    '33005' => '\\ccxt\\ExchangeError', // array( "code" => 33005, "message" => "repayment amount must exceed 0" )
                    '33006' => '\\ccxt\\ExchangeError', // array( "code" => 33006, "message" => "loan order not found" )
                    '33007' => '\\ccxt\\ExchangeError', // array( "code" => 33007, "message" => "status not found" )
                    '33008' => '\\ccxt\\InsufficientFunds', // array( "code" => 33008, "message" => "loan amount cannot exceed the maximum limit" )
                    '33009' => '\\ccxt\\ExchangeError', // array( "code" => 33009, "message" => "user ID is blank" )
                    '33010' => '\\ccxt\\ExchangeError', // array( "code" => 33010, "message" => "you cannot cancel an order during session 2 of call auction" )
                    '33011' => '\\ccxt\\ExchangeError', // array( "code" => 33011, "message" => "no new market data" )
                    '33012' => '\\ccxt\\ExchangeError', // array( "code" => 33012, "message" => "order cancellation failed" )
                    '33013' => '\\ccxt\\InvalidOrder', // array( "code" => 33013, "message" => "order placement failed" )
                    '33014' => '\\ccxt\\OrderNotFound', // array( "code" => 33014, "message" => "order does not exist" )
                    '33015' => '\\ccxt\\InvalidOrder', // array( "code" => 33015, "message" => "exceeded maximum limit" )
                    '33016' => '\\ccxt\\ExchangeError', // array( "code" => 33016, "message" => "margin trading is not open for this token" )
                    '33017' => '\\ccxt\\InsufficientFunds', // array( "code" => 33017, "message" => "insufficient balance" )
                    '33018' => '\\ccxt\\ExchangeError', // array( "code" => 33018, "message" => "this parameter must be smaller than 1" )
                    '33020' => '\\ccxt\\ExchangeError', // array( "code" => 33020, "message" => "request not supported" )
                    '33021' => '\\ccxt\\BadRequest', // array( "code" => 33021, "message" => "token and the pair do not match" )
                    '33022' => '\\ccxt\\InvalidOrder', // array( "code" => 33022, "message" => "pair and the order do not match" )
                    '33023' => '\\ccxt\\ExchangeError', // array( "code" => 33023, "message" => "you can only place market orders during call auction" )
                    '33024' => '\\ccxt\\InvalidOrder', // array( "code" => 33024, "message" => "trading amount too small" )
                    '33025' => '\\ccxt\\InvalidOrder', // array( "code" => 33025, "message" => "base token amount is blank" )
                    '33026' => '\\ccxt\\ExchangeError', // array( "code" => 33026, "message" => "transaction completed" )
                    '33027' => '\\ccxt\\InvalidOrder', // array( "code" => 33027, "message" => "cancelled order or order cancelling" )
                    '33028' => '\\ccxt\\InvalidOrder', // array( "code" => 33028, "message" => "the decimal places of the trading price exceeded the limit" )
                    '33029' => '\\ccxt\\InvalidOrder', // array( "code" => 33029, "message" => "the decimal places of the trading size exceeded the limit" )
                    '33034' => '\\ccxt\\ExchangeError', // array( "code" => 33034, "message" => "You can only place limit order after Call Auction has started" )
                    '33035' => '\\ccxt\\ExchangeError', // This type of order cannot be canceled(This type of order cannot be canceled)
                    '33036' => '\\ccxt\\ExchangeError', // Exceeding the limit of entrust order
                    '33037' => '\\ccxt\\ExchangeError', // The buy order price should be lower than 130% of the trigger price
                    '33038' => '\\ccxt\\ExchangeError', // The sell order price should be higher than 70% of the trigger price
                    '33039' => '\\ccxt\\ExchangeError', // The limit of callback rate is 0 < x <= 5%
                    '33040' => '\\ccxt\\ExchangeError', // The trigger price of a buy order should be lower than the latest transaction price
                    '33041' => '\\ccxt\\ExchangeError', // The trigger price of a sell order should be higher than the latest transaction price
                    '33042' => '\\ccxt\\ExchangeError', // The limit of price variance is 0 < x <= 1%
                    '33043' => '\\ccxt\\ExchangeError', // The total amount must be larger than 0
                    '33044' => '\\ccxt\\ExchangeError', // The average amount should be 1/1000 * total amount <= x <= total amount
                    '33045' => '\\ccxt\\ExchangeError', // The price should not be 0, including trigger price, order price, and price limit
                    '33046' => '\\ccxt\\ExchangeError', // Price variance should be 0 < x <= 1%
                    '33047' => '\\ccxt\\ExchangeError', // Sweep ratio should be 0 < x <= 100%
                    '33048' => '\\ccxt\\ExchangeError', // Per order limit => Total amount/1000 < x <= Total amount
                    '33049' => '\\ccxt\\ExchangeError', // Total amount should be X > 0
                    '33050' => '\\ccxt\\ExchangeError', // Time interval should be 5 <= x <= 120s
                    '33051' => '\\ccxt\\ExchangeError', // cancel order number not higher limit => plan and track entrust no more than 10, ice and time entrust no more than 6
                    '33059' => '\\ccxt\\BadRequest', // array( "code" => 33059, "message" => "client_oid or order_id is required" )
                    '33060' => '\\ccxt\\BadRequest', // array( "code" => 33060, "message" => "Only fill in either parameter client_oid or order_id" )
                    '33061' => '\\ccxt\\ExchangeError', // Value of a single market price order cannot exceed 100,000 USD
                    '33062' => '\\ccxt\\ExchangeError', // The leverage ratio is too high. The borrowed position has exceeded the maximum position of this leverage ratio. Please readjust the leverage ratio
                    '33063' => '\\ccxt\\ExchangeError', // Leverage multiple is too low, there is insufficient margin in the account, please readjust the leverage ratio
                    '33064' => '\\ccxt\\ExchangeError', // The setting of the leverage ratio cannot be less than 2, please readjust the leverage ratio
                    '33065' => '\\ccxt\\ExchangeError', // Leverage ratio exceeds maximum leverage ratio, please readjust leverage ratio
                    // account
                    '21009' => '\\ccxt\\ExchangeError', // Funds cannot be transferred out within 30 minutes after swap settlement(Funds cannot be transferred out within 30 minutes after swap settlement)
                    '34001' => '\\ccxt\\PermissionDenied', // array( "code" => 34001, "message" => "withdrawal suspended" )
                    '34002' => '\\ccxt\\InvalidAddress', // array( "code" => 34002, "message" => "please add a withdrawal address" )
                    '34003' => '\\ccxt\\ExchangeError', // array( "code" => 34003, "message" => "sorry, this token cannot be withdrawn to xx at the moment" )
                    '34004' => '\\ccxt\\ExchangeError', // array( "code" => 34004, "message" => "withdrawal fee is smaller than minimum limit" )
                    '34005' => '\\ccxt\\ExchangeError', // array( "code" => 34005, "message" => "withdrawal fee exceeds the maximum limit" )
                    '34006' => '\\ccxt\\ExchangeError', // array( "code" => 34006, "message" => "withdrawal amount is lower than the minimum limit" )
                    '34007' => '\\ccxt\\ExchangeError', // array( "code" => 34007, "message" => "withdrawal amount exceeds the maximum limit" )
                    '34008' => '\\ccxt\\InsufficientFunds', // array( "code" => 34008, "message" => "insufficient balance" )
                    '34009' => '\\ccxt\\ExchangeError', // array( "code" => 34009, "message" => "your withdrawal amount exceeds the daily limit" )
                    '34010' => '\\ccxt\\ExchangeError', // array( "code" => 34010, "message" => "transfer amount must be larger than 0" )
                    '34011' => '\\ccxt\\ExchangeError', // array( "code" => 34011, "message" => "conditions not met" )
                    '34012' => '\\ccxt\\ExchangeError', // array( "code" => 34012, "message" => "the minimum withdrawal amount for NEO is 1, and the amount must be an integer" )
                    '34013' => '\\ccxt\\ExchangeError', // array( "code" => 34013, "message" => "please transfer" )
                    '34014' => '\\ccxt\\ExchangeError', // array( "code" => 34014, "message" => "transfer limited" )
                    '34015' => '\\ccxt\\ExchangeError', // array( "code" => 34015, "message" => "subaccount does not exist" )
                    '34016' => '\\ccxt\\PermissionDenied', // array( "code" => 34016, "message" => "transfer suspended" )
                    '34017' => '\\ccxt\\AccountSuspended', // array( "code" => 34017, "message" => "account suspended" )
                    '34018' => '\\ccxt\\AuthenticationError', // array( "code" => 34018, "message" => "incorrect trades password" )
                    '34019' => '\\ccxt\\PermissionDenied', // array( "code" => 34019, "message" => "please bind your email before withdrawal" )
                    '34020' => '\\ccxt\\PermissionDenied', // array( "code" => 34020, "message" => "please bind your funds password before withdrawal" )
                    '34021' => '\\ccxt\\InvalidAddress', // array( "code" => 34021, "message" => "Not verified address" )
                    '34022' => '\\ccxt\\ExchangeError', // array( "code" => 34022, "message" => "Withdrawals are not available for sub accounts" )
                    '34023' => '\\ccxt\\PermissionDenied', // array( "code" => 34023, "message" => "Please enable futures trading before transferring your funds" )
                    '34026' => '\\ccxt\\ExchangeError', // transfer too frequently(transfer too frequently)
                    '34036' => '\\ccxt\\ExchangeError', // Parameter is incorrect, please refer to API documentation
                    '34037' => '\\ccxt\\ExchangeError', // Get the sub-account balance interface, account type is not supported
                    '34038' => '\\ccxt\\ExchangeError', // Since your C2C transaction is unusual, you are restricted from fund transfer. Please contact our customer support to cancel the restriction
                    '34039' => '\\ccxt\\ExchangeError', // You are now restricted from transferring out your funds due to abnormal trades on C2C Market. Please transfer your fund on our website or app instead to verify your identity
                    // swap
                    '35001' => '\\ccxt\\ExchangeError', // array( "code" => 35001, "message" => "Contract does not exist" )
                    '35002' => '\\ccxt\\ExchangeError', // array( "code" => 35002, "message" => "Contract settling" )
                    '35003' => '\\ccxt\\ExchangeError', // array( "code" => 35003, "message" => "Contract paused" )
                    '35004' => '\\ccxt\\ExchangeError', // array( "code" => 35004, "message" => "Contract pending settlement" )
                    '35005' => '\\ccxt\\AuthenticationError', // array( "code" => 35005, "message" => "User does not exist" )
                    '35008' => '\\ccxt\\InvalidOrder', // array( "code" => 35008, "message" => "Risk ratio too high" )
                    '35010' => '\\ccxt\\InvalidOrder', // array( "code" => 35010, "message" => "Position closing too large" )
                    '35012' => '\\ccxt\\InvalidOrder', // array( "code" => 35012, "message" => "Incorrect order size" )
                    '35014' => '\\ccxt\\InvalidOrder', // array( "code" => 35014, "message" => "Order price is not within limit" )
                    '35015' => '\\ccxt\\InvalidOrder', // array( "code" => 35015, "message" => "Invalid leverage level" )
                    '35017' => '\\ccxt\\ExchangeError', // array( "code" => 35017, "message" => "Open orders exist" )
                    '35019' => '\\ccxt\\InvalidOrder', // array( "code" => 35019, "message" => "Order size too large" )
                    '35020' => '\\ccxt\\InvalidOrder', // array( "code" => 35020, "message" => "Order price too high" )
                    '35021' => '\\ccxt\\InvalidOrder', // array( "code" => 35021, "message" => "Order size exceeded current tier limit" )
                    '35022' => '\\ccxt\\ExchangeError', // array( "code" => 35022, "message" => "Contract status error" )
                    '35024' => '\\ccxt\\ExchangeError', // array( "code" => 35024, "message" => "Contract not initialized" )
                    '35025' => '\\ccxt\\InsufficientFunds', // array( "code" => 35025, "message" => "No account balance" )
                    '35026' => '\\ccxt\\ExchangeError', // array( "code" => 35026, "message" => "Contract settings not initialized" )
                    '35029' => '\\ccxt\\OrderNotFound', // array( "code" => 35029, "message" => "Order does not exist" )
                    '35030' => '\\ccxt\\InvalidOrder', // array( "code" => 35030, "message" => "Order size too large" )
                    '35031' => '\\ccxt\\InvalidOrder', // array( "code" => 35031, "message" => "Cancel order size too large" )
                    '35032' => '\\ccxt\\ExchangeError', // array( "code" => 35032, "message" => "Invalid user status" )
                    '35037' => '\\ccxt\\ExchangeError', // No last traded price in cache
                    '35039' => '\\ccxt\\ExchangeError', // array( "code" => 35039, "message" => "Open order quantity exceeds limit" )
                    '35040' => '\\ccxt\\InvalidOrder', // array("error_message":"Invalid order type","result":"true","error_code":"35040","order_id":"-1")
                    '35044' => '\\ccxt\\ExchangeError', // array( "code" => 35044, "message" => "Invalid order status" )
                    '35046' => '\\ccxt\\InsufficientFunds', // array( "code" => 35046, "message" => "Negative account balance" )
                    '35047' => '\\ccxt\\InsufficientFunds', // array( "code" => 35047, "message" => "Insufficient account balance" )
                    '35048' => '\\ccxt\\ExchangeError', // array( "code" => 35048, "message" => "User contract is frozen and liquidating" )
                    '35049' => '\\ccxt\\InvalidOrder', // array( "code" => 35049, "message" => "Invalid order type" )
                    '35050' => '\\ccxt\\InvalidOrder', // array( "code" => 35050, "message" => "Position settings are blank" )
                    '35052' => '\\ccxt\\InsufficientFunds', // array( "code" => 35052, "message" => "Insufficient cross margin" )
                    '35053' => '\\ccxt\\ExchangeError', // array( "code" => 35053, "message" => "Account risk too high" )
                    '35055' => '\\ccxt\\InsufficientFunds', // array( "code" => 35055, "message" => "Insufficient account balance" )
                    '35057' => '\\ccxt\\ExchangeError', // array( "code" => 35057, "message" => "No last traded price" )
                    '35058' => '\\ccxt\\ExchangeError', // array( "code" => 35058, "message" => "No limit" )
                    '35059' => '\\ccxt\\BadRequest', // array( "code" => 35059, "message" => "client_oid or order_id is required" )
                    '35060' => '\\ccxt\\BadRequest', // array( "code" => 35060, "message" => "Only fill in either parameter client_oid or order_id" )
                    '35061' => '\\ccxt\\BadRequest', // array( "code" => 35061, "message" => "Invalid instrument_id" )
                    '35062' => '\\ccxt\\InvalidOrder', // array( "code" => 35062, "message" => "Invalid match_price" )
                    '35063' => '\\ccxt\\InvalidOrder', // array( "code" => 35063, "message" => "Invalid order_size" )
                    '35064' => '\\ccxt\\InvalidOrder', // array( "code" => 35064, "message" => "Invalid client_oid" )
                    '35066' => '\\ccxt\\InvalidOrder', // Order interval error
                    '35067' => '\\ccxt\\InvalidOrder', // Time-weighted order ratio error
                    '35068' => '\\ccxt\\InvalidOrder', // Time-weighted order range error
                    '35069' => '\\ccxt\\InvalidOrder', // Time-weighted single transaction limit error
                    '35070' => '\\ccxt\\InvalidOrder', // Algo order type error
                    '35071' => '\\ccxt\\InvalidOrder', // Order total must be larger than single order limit
                    '35072' => '\\ccxt\\InvalidOrder', // Maximum 6 unfulfilled time-weighted orders can be held at the same time
                    '35073' => '\\ccxt\\InvalidOrder', // Order price is 0. Market-close-all not available
                    '35074' => '\\ccxt\\InvalidOrder', // Iceberg order single transaction average error
                    '35075' => '\\ccxt\\InvalidOrder', // Failed to cancel order
                    '35076' => '\\ccxt\\InvalidOrder', // LTC 20x leverage. Not allowed to open position
                    '35077' => '\\ccxt\\InvalidOrder', // Maximum 6 unfulfilled iceberg orders can be held at the same time
                    '35078' => '\\ccxt\\InvalidOrder', // Order amount exceeded 100,000
                    '35079' => '\\ccxt\\InvalidOrder', // Iceberg order price variance error
                    '35080' => '\\ccxt\\InvalidOrder', // Callback rate error
                    '35081' => '\\ccxt\\InvalidOrder', // Maximum 10 unfulfilled trail orders can be held at the same time
                    '35082' => '\\ccxt\\InvalidOrder', // Trail order callback rate error
                    '35083' => '\\ccxt\\InvalidOrder', // Each user can only hold a maximum of 10 unfulfilled stop-limit orders at the same time
                    '35084' => '\\ccxt\\InvalidOrder', // Order amount exceeded 1 million
                    '35085' => '\\ccxt\\InvalidOrder', // Order amount is not in the correct range
                    '35086' => '\\ccxt\\InvalidOrder', // Price exceeds 100 thousand
                    '35087' => '\\ccxt\\InvalidOrder', // Price exceeds 100 thousand
                    '35088' => '\\ccxt\\InvalidOrder', // Average amount error
                    '35089' => '\\ccxt\\InvalidOrder', // Price exceeds 100 thousand
                    '35090' => '\\ccxt\\ExchangeError', // No stop-limit orders available for cancelation
                    '35091' => '\\ccxt\\ExchangeError', // No trail orders available for cancellation
                    '35092' => '\\ccxt\\ExchangeError', // No iceberg orders available for cancellation
                    '35093' => '\\ccxt\\ExchangeError', // No trail orders available for cancellation
                    '35094' => '\\ccxt\\ExchangeError', // Stop-limit order last traded price error
                    '35095' => '\\ccxt\\BadRequest', // Instrument_id error
                    '35096' => '\\ccxt\\ExchangeError', // Algo order status error
                    '35097' => '\\ccxt\\ExchangeError', // Order status and order ID cannot exist at the same time
                    '35098' => '\\ccxt\\ExchangeError', // An order status or order ID must exist
                    '35099' => '\\ccxt\\ExchangeError', // Algo order ID error
                    // option
                    '36001' => '\\ccxt\\BadRequest', // Invalid underlying index.
                    '36002' => '\\ccxt\\BadRequest', // Instrument does not exist.
                    '36005' => '\\ccxt\\ExchangeError', // Instrument status is invalid.
                    '36101' => '\\ccxt\\AuthenticationError', // Account does not exist.
                    '36102' => '\\ccxt\\PermissionDenied', // Account status is invalid.
                    '36103' => '\\ccxt\\AccountSuspended', // Account is suspended due to ongoing liquidation.
                    '36104' => '\\ccxt\\PermissionDenied', // Account is not enabled for options trading.
                    '36105' => '\\ccxt\\PermissionDenied', // Please enable the account for option contract.
                    '36106' => '\\ccxt\\AccountSuspended', // Funds cannot be transferred in or out, as account is suspended.
                    '36107' => '\\ccxt\\PermissionDenied', // Funds cannot be transferred out within 30 minutes after option exercising or settlement.
                    '36108' => '\\ccxt\\InsufficientFunds', // Funds cannot be transferred in or out, as equity of the account is less than zero.
                    '36109' => '\\ccxt\\PermissionDenied', // Funds cannot be transferred in or out during option exercising or settlement.
                    '36201' => '\\ccxt\\PermissionDenied', // New order function is blocked.
                    '36202' => '\\ccxt\\PermissionDenied', // Account does not have permission to short option.
                    '36203' => '\\ccxt\\InvalidOrder', // Invalid format for client_oid.
                    '36204' => '\\ccxt\\ExchangeError', // Invalid format for request_id.
                    '36205' => '\\ccxt\\BadRequest', // Instrument id does not match underlying index.
                    '36206' => '\\ccxt\\BadRequest', // Order_id and client_oid can not be used at the same time.
                    '36207' => '\\ccxt\\InvalidOrder', // Either order price or fartouch price must be present.
                    '36208' => '\\ccxt\\InvalidOrder', // Either order price or size must be present.
                    '36209' => '\\ccxt\\InvalidOrder', // Either order_id or client_oid must be present.
                    '36210' => '\\ccxt\\InvalidOrder', // Either order_ids or client_oids must be present.
                    '36211' => '\\ccxt\\InvalidOrder', // Exceeding max batch size for order submission.
                    '36212' => '\\ccxt\\InvalidOrder', // Exceeding max batch size for oder cancellation.
                    '36213' => '\\ccxt\\InvalidOrder', // Exceeding max batch size for order amendment.
                    '36214' => '\\ccxt\\ExchangeError', // Instrument does not have valid bid/ask quote.
                    '36216' => '\\ccxt\\OrderNotFound', // Order does not exist.
                    '36217' => '\\ccxt\\InvalidOrder', // Order submission failed.
                    '36218' => '\\ccxt\\InvalidOrder', // Order cancellation failed.
                    '36219' => '\\ccxt\\InvalidOrder', // Order amendment failed.
                    '36220' => '\\ccxt\\InvalidOrder', // Order is pending cancel.
                    '36221' => '\\ccxt\\InvalidOrder', // Order qty is not valid multiple of lot size.
                    '36222' => '\\ccxt\\InvalidOrder', // Order price is breaching highest buy limit.
                    '36223' => '\\ccxt\\InvalidOrder', // Order price is breaching lowest sell limit.
                    '36224' => '\\ccxt\\InvalidOrder', // Exceeding max order size.
                    '36225' => '\\ccxt\\InvalidOrder', // Exceeding max open order count for instrument.
                    '36226' => '\\ccxt\\InvalidOrder', // Exceeding max open order count for underlying.
                    '36227' => '\\ccxt\\InvalidOrder', // Exceeding max open size across all orders for underlying
                    '36228' => '\\ccxt\\InvalidOrder', // Exceeding max available qty for instrument.
                    '36229' => '\\ccxt\\InvalidOrder', // Exceeding max available qty for underlying.
                    '36230' => '\\ccxt\\InvalidOrder', // Exceeding max position limit for underlying.
                    // --------------------------------------------------------
                    // swap
                    '400' => '\\ccxt\\BadRequest', // Bad Request
                    '401' => '\\ccxt\\AuthenticationError', // Unauthorized access
                    '403' => '\\ccxt\\PermissionDenied', // Access prohibited
                    '404' => '\\ccxt\\BadRequest', // Request address does not exist
                    '405' => '\\ccxt\\BadRequest', // The HTTP Method is not supported
                    '415' => '\\ccxt\\BadRequest', // The current media type is not supported
                    '429' => '\\ccxt\\DDoSProtection', // Too many requests
                    '500' => '\\ccxt\\ExchangeNotAvailable', // System busy
                    '1001' => '\\ccxt\\RateLimitExceeded', // The request is too frequent and has been throttled
                    '1002' => '\\ccxt\\ExchangeError', // {0} verifications within 24 hours
                    '1003' => '\\ccxt\\ExchangeError', // You failed more than {0} times today, the current operation is locked, please try again in 24 hours
                    // '00000' => '\\ccxt\\ExchangeError', // success
                    '40001' => '\\ccxt\\AuthenticationError', // ACCESS_KEY cannot be empty
                    '40002' => '\\ccxt\\AuthenticationError', // SECRET_KEY cannot be empty
                    '40003' => '\\ccxt\\AuthenticationError', // Signature cannot be empty
                    '40004' => '\\ccxt\\InvalidNonce', // Request timestamp expired
                    '40005' => '\\ccxt\\InvalidNonce', // Invalid ACCESS_TIMESTAMP
                    '40006' => '\\ccxt\\AuthenticationError', // Invalid ACCESS_KEY
                    '40007' => '\\ccxt\\BadRequest', // Invalid Content_Type
                    '40008' => '\\ccxt\\InvalidNonce', // Request timestamp expired
                    '40009' => '\\ccxt\\AuthenticationError', // sign signature error
                    '40010' => '\\ccxt\\AuthenticationError', // sign signature error
                    '40011' => '\\ccxt\\AuthenticationError', // ACCESS_PASSPHRASE cannot be empty
                    '40012' => '\\ccxt\\AuthenticationError', // apikey/password is incorrect
                    '40013' => '\\ccxt\\ExchangeError', // User status is abnormal
                    '40014' => '\\ccxt\\PermissionDenied', // Incorrect permissions
                    '40015' => '\\ccxt\\ExchangeError', // System is abnormal, please try again later
                    '40016' => '\\ccxt\\PermissionDenied', // The user must bind the phone or Google
                    '40017' => '\\ccxt\\ExchangeError', // Parameter verification failed
                    '40018' => '\\ccxt\\PermissionDenied', // Invalid IP
                    '40102' => '\\ccxt\\BadRequest', // Contract configuration does not exist, please check the parameters
                    '40103' => '\\ccxt\\BadRequest', // Request method cannot be empty
                    '40104' => '\\ccxt\\ExchangeError', // Lever adjustment failure
                    '40105' => '\\ccxt\\ExchangeError', // Abnormal access to current price limit data
                    '40106' => '\\ccxt\\ExchangeError', // Abnormal get next settlement time
                    '40107' => '\\ccxt\\ExchangeError', // Abnormal access to index price data
                    '40108' => '\\ccxt\\InvalidOrder', // Wrong order quantity
                    '40109' => '\\ccxt\\OrderNotFound', // The data of the order cannot be found, please confirm the order number
                    '40200' => '\\ccxt\\OnMaintenance', // Server upgrade, please try again later
                    '40201' => '\\ccxt\\InvalidOrder', // Order number cannot be empty
                    '40202' => '\\ccxt\\ExchangeError', // User information cannot be empty
                    '40203' => '\\ccxt\\BadRequest', // The amount of adjustment margin cannot be empty or negative
                    '40204' => '\\ccxt\\BadRequest', // Adjustment margin type cannot be empty
                    '40205' => '\\ccxt\\BadRequest', // Adjusted margin type data is wrong
                    '40206' => '\\ccxt\\BadRequest', // The direction of the adjustment margin cannot be empty
                    '40207' => '\\ccxt\\BadRequest', // The adjustment margin data is wrong
                    '40208' => '\\ccxt\\BadRequest', // The accuracy of the adjustment margin amount is incorrect
                    '40209' => '\\ccxt\\BadRequest', // The current page number is wrong, please confirm
                    '40300' => '\\ccxt\\ExchangeError', // User does not exist
                    '40301' => '\\ccxt\\PermissionDenied', // Permission has not been obtained yet. If you need to use it, please contact customer service
                    '40302' => '\\ccxt\\BadRequest', // Parameter abnormality
                    '40303' => '\\ccxt\\BadRequest', // Can only query up to 20,000 data
                    '40304' => '\\ccxt\\BadRequest', // Parameter type is abnormal
                    '40305' => '\\ccxt\\BadRequest', // Client_oid length is not greater than 50, and cannot be Martian characters
                    '40306' => '\\ccxt\\ExchangeError', // Batch processing orders can only process up to 20
                    '40308' => '\\ccxt\\OnMaintenance', // The contract is being temporarily maintained
                    '40309' => '\\ccxt\\BadSymbol', // The contract has been removed
                    '40400' => '\\ccxt\\ExchangeError', // Status check abnormal
                    '40401' => '\\ccxt\\ExchangeError', // The operation cannot be performed
                    '40402' => '\\ccxt\\BadRequest', // The opening direction cannot be empty
                    '40403' => '\\ccxt\\BadRequest', // Wrong opening direction format
                    '40404' => '\\ccxt\\BadRequest', // Whether to enable automatic margin call parameters cannot be empty
                    '40405' => '\\ccxt\\BadRequest', // Whether to enable the automatic margin call parameter type is wrong
                    '40406' => '\\ccxt\\BadRequest', // Whether to enable automatic margin call parameters is of unknown type
                    '40407' => '\\ccxt\\ExchangeError', // The query direction is not the direction entrusted by the plan
                    '40408' => '\\ccxt\\ExchangeError', // Wrong time range
                    '40409' => '\\ccxt\\ExchangeError', // Time format error
                    '40500' => '\\ccxt\\InvalidOrder', // Client_oid check error
                    '40501' => '\\ccxt\\ExchangeError', // Channel name error
                    '40502' => '\\ccxt\\ExchangeError', // If it is a copy user, you must pass the copy to whom
                    '40503' => '\\ccxt\\ExchangeError', // With the single type
                    '40504' => '\\ccxt\\ExchangeError', // Platform code must pass
                    '40505' => '\\ccxt\\ExchangeError', // Not the same as single type
                    '40506' => '\\ccxt\\AuthenticationError', // Platform signature error
                    '40507' => '\\ccxt\\AuthenticationError', // Api signature error
                    '40508' => '\\ccxt\\ExchangeError', // KOL is not authorized
                    '40509' => '\\ccxt\\ExchangeError', // Abnormal copy end
                    '40600' => '\\ccxt\\ExchangeError', // Copy function suspended
                    '40601' => '\\ccxt\\ExchangeError', // Followers cannot be KOL
                    '40602' => '\\ccxt\\ExchangeError', // The number of copies has reached the limit and cannot process the request
                    '40603' => '\\ccxt\\ExchangeError', // Abnormal copy end
                    '40604' => '\\ccxt\\ExchangeNotAvailable', // Server is busy, please try again later
                    '40605' => '\\ccxt\\ExchangeError', // Copy type, the copy number must be passed
                    '40606' => '\\ccxt\\ExchangeError', // The type of document number is wrong
                    '40607' => '\\ccxt\\ExchangeError', // Document number must be passed
                    '40608' => '\\ccxt\\ExchangeError', // No documented products currently supported
                    '40609' => '\\ccxt\\ExchangeError', // The contract product does not support copying
                    '40700' => '\\ccxt\\BadRequest', // Cursor parameters are incorrect
                    '40701' => '\\ccxt\\ExchangeError', // KOL is not authorized
                    '40702' => '\\ccxt\\ExchangeError', // Unauthorized copying user
                    '40703' => '\\ccxt\\ExchangeError', // Bill inquiry start and end time cannot be empty
                    '40704' => '\\ccxt\\ExchangeError', // Can only check the data of the last three months
                    '40705' => '\\ccxt\\BadRequest', // The start and end time cannot exceed 90 days
                    '40706' => '\\ccxt\\InvalidOrder', // Wrong order price
                    '40707' => '\\ccxt\\BadRequest', // Start time is greater than end time
                    '40708' => '\\ccxt\\BadRequest', // Parameter verification is abnormal
                    '40709' => '\\ccxt\\ExchangeError', // There is no position in this position, and no automatic margin call can be set
                    '40710' => '\\ccxt\\ExchangeError', // Abnormal account status
                    '40711' => '\\ccxt\\InsufficientFunds', // Insufficient contract account balance
                    '40712' => '\\ccxt\\InsufficientFunds', // Insufficient margin
                    '40713' => '\\ccxt\\ExchangeError', // Cannot exceed the maximum transferable margin amount
                    '40714' => '\\ccxt\\ExchangeError', // No direct margin call is allowed
                    // spot
                    'invalid sign' => '\\ccxt\\AuthenticationError',
                    'invalid currency' => '\\ccxt\\BadSymbol', // invalid trading pair
                    'invalid symbol' => '\\ccxt\\BadSymbol',
                    'invalid period' => '\\ccxt\\BadRequest', // invalid Kline type
                    'invalid user' => '\\ccxt\\ExchangeError',
                    'invalid amount' => '\\ccxt\\InvalidOrder',
                    'invalid type' => '\\ccxt\\InvalidOrder', // array("status":"error","ts":1595700344504,"err_code":"invalid-parameter","err_msg":"invalid type")
                    'invalid orderId' => '\\ccxt\\InvalidOrder',
                    'invalid record' => '\\ccxt\\ExchangeError',
                    'invalid accountId' => '\\ccxt\\BadRequest',
                    'invalid address' => '\\ccxt\\BadRequest',
                    'accesskey not null' => '\\ccxt\\AuthenticationError', // array("status":"error","ts":1595704360508,"err_code":"invalid-parameter","err_msg":"accesskey not null")
                    'illegal accesskey' => '\\ccxt\\AuthenticationError',
                    'sign not null' => '\\ccxt\\AuthenticationError',
                    'req_time is too much difference from server time' => '\\ccxt\\InvalidNonce',
                    'permissions not right' => '\\ccxt\\PermissionDenied', // array("status":"error","ts":1595704490084,"err_code":"invalid-parameter","err_msg":"permissions not right")
                    'illegal sign invalid' => '\\ccxt\\AuthenticationError', // array("status":"error","ts":1595684716042,"err_code":"invalid-parameter","err_msg":"illegal sign invalid")
                    'user locked' => '\\ccxt\\AccountSuspended',
                    'Request Frequency Is Too High' => '\\ccxt\\RateLimitExceeded',
                    'more than a daily rate of cash' => '\\ccxt\\BadRequest',
                    'more than the maximum daily withdrawal amount' => '\\ccxt\\BadRequest',
                    'need to bind email or mobile' => '\\ccxt\\ExchangeError',
                    'user forbid' => '\\ccxt\\PermissionDenied',
                    'User Prohibited Cash Withdrawal' => '\\ccxt\\PermissionDenied',
                    'Cash Withdrawal Is Less Than The Minimum Value' => '\\ccxt\\BadRequest',
                    'Cash Withdrawal Is More Than The Maximum Value' => '\\ccxt\\BadRequest',
                    'the account with in 24 hours ban coin' => '\\ccxt\\PermissionDenied',
                    'order cancel fail' => '\\ccxt\\BadRequest', // array("status":"error","ts":1595703343035,"err_code":"bad-request","err_msg":"order cancel fail")
                    'base symbol error' => '\\ccxt\\BadSymbol',
                    'base date error' => '\\ccxt\\ExchangeError',
                    'api signature not valid' => '\\ccxt\\AuthenticationError',
                    'gateway internal error' => '\\ccxt\\ExchangeError',
                    'audit failed' => '\\ccxt\\ExchangeError',
                    'order queryorder invalid' => '\\ccxt\\BadRequest',
                    'market no need price' => '\\ccxt\\InvalidOrder',
                    'limit need price' => '\\ccxt\\InvalidOrder',
                    'userid not equal to account_id' => '\\ccxt\\ExchangeError',
                    'your balance is low' => '\\ccxt\\InsufficientFunds', // array("status":"error","ts":1595594160149,"err_code":"invalid-parameter","err_msg":"invalid size, valid range => [1,2000]")
                    'address invalid cointype' => '\\ccxt\\ExchangeError',
                    'system exception' => '\\ccxt\\ExchangeError', // array("status":"error","ts":1595711862763,"err_code":"system exception","err_msg":"system exception")
                    '50003' => '\\ccxt\\ExchangeError', // No record
                    '50004' => '\\ccxt\\BadSymbol', // The transaction pair is currently not supported or has been suspended
                    '50006' => '\\ccxt\\PermissionDenied', // The account is forbidden to withdraw. If you have any questions, please contact customer service.
                    '50007' => '\\ccxt\\PermissionDenied', // The account is forbidden to withdraw within 24 hours. If you have any questions, please contact customer service.
                    '50008' => '\\ccxt\\RequestTimeout', // network timeout
                    '50009' => '\\ccxt\\RateLimitExceeded', // The operation is too frequent, please try again later
                    '50010' => '\\ccxt\\ExchangeError', // The account is abnormally frozen. If you have any questions, please contact customer service.
                    '50014' => '\\ccxt\\InvalidOrder', // The transaction amount under minimum limits
                    '50015' => '\\ccxt\\InvalidOrder', // The transaction amount exceed maximum limits
                    '50016' => '\\ccxt\\InvalidOrder', // The price can't be higher than the current price
                    '50017' => '\\ccxt\\InvalidOrder', // Price under minimum limits
                    '50018' => '\\ccxt\\InvalidOrder', // The price exceed maximum limits
                    '50019' => '\\ccxt\\InvalidOrder', // The amount under minimum limits
                    '50020' => '\\ccxt\\InsufficientFunds', // Insufficient balance
                    '50021' => '\\ccxt\\InvalidOrder', // Price is under minimum limits
                    '50026' => '\\ccxt\\InvalidOrder', // Market price parameter error
                    'invalid order query time' => '\\ccxt\\ExchangeError', // start time is greater than end time; or the time interval between start time and end time is greater than 48 hours
                    'invalid start time' => '\\ccxt\\BadRequest', // start time is a date 30 days ago; or start time is a date in the future
                    'invalid end time' => '\\ccxt\\BadRequest', // end time is a date 30 days ago; or end time is a date in the future
                    '20003' => '\\ccxt\\ExchangeError', // operation failed, array("status":"error","ts":1595730308979,"err_code":"bad-request","err_msg":"20003")
                    '01001' => '\\ccxt\\ExchangeError', // order failed, array("status":"fail","err_code":"01001","err_msg":"系统异常，请稍后重试")
                ),
                'broad' => array(
                    'invalid size, valid range' => '\\ccxt\\ExchangeError',
                ),
            ),
            'precisionMode' => TICK_SIZE,
            'options' => array(
                'createMarketBuyOrderRequiresPrice' => true,
                'fetchMarkets' => array(
                    'spot',
                    'swap',
                ),
                'parseOHLCV' => array(
                    'volume' => array(
                        'spot' => 'amount',
                        'swap' => 5,
                    ),
                ),
                'defaultType' => 'spot', // 'spot', 'swap'
                'accountId' => null, // '1012838157',
                'timeframes' => array(
                    'spot' => array(
                        '1m' => '1min',
                        '5m' => '5min',
                        '15m' => '15min',
                        '30m' => '30min',
                        '1h' => '60min',
                        '2h' => '120min',
                        '4h' => '240min',
                        '6h' => '360min',
                        '12h' => '720min',
                        '1d' => '1day',
                        '1w' => '1week',
                    ),
                    'swap' => array(
                        '1m' => '60',
                        '5m' => '300',
                        '15m' => '900',
                        '30m' => '1800',
                        '1h' => '3600',
                        '2h' => '7200',
                        '4h' => '14400',
                        '6h' => '21600',
                        '12h' => '43200',
                        '1d' => '86400',
                        '1w' => '604800',
                    ),
                ),
            ),
        ));
    }

    public function fetch_time($params = array ()) {
        $response = $this->dataGetCommonTimestamp ($params);
        //
        //     {
        //         "status":"ok",
        //         "data":"1595525139400"
        //     }
        //
        return $this->safe_integer($response, 'data');
    }

    public function fetch_markets($params = array ()) {
        $types = $this->safe_value($this->options, 'fetchMarkets');
        if (strlen(!$types)) {
            $types = [
                $this->options['defaultType'],
            ];
        }
        $result = array();
        for ($i = 0; $i < count($types); $i++) {
            $markets = $this->fetch_markets_by_type($types[$i], $params);
            $result = $this->array_concat($result, $markets);
        }
        return $result;
    }

    public function parse_markets($markets) {
        $result = array();
        for ($i = 0; $i < count($markets); $i++) {
            $result[] = $this->parse_market($markets[$i]);
        }
        return $result;
    }

    public function parse_market($market) {
        //
        // $spot
        //
        //     {
        //         "base_currency":"btc",
        //         "quote_currency":"usdt",
        //         "$symbol":"btc_usdt",
        //         "tick_size":"2",
        //         "size_increment":"4",
        //         "$status":"1",
        //         "base_asset_precision":"8"
        //     }
        //
        //
        // $swap
        //
        //     {
        //         "$symbol":"btcusd",
        //         "underlying_index":"BTC",
        //         "quote_currency":"USD",
        //         "coin":"BTC",
        //         "contract_val":"1",
        //         "listing":null,
        //         "delivery":["07:00:00","15:00:00","23:00:00"],
        //         "size_increment":"0",
        //         "tick_size":"1",
        //         "forwardContractFlag":false,
        //         "priceEndStep":5
        //     }
        //
        $id = $this->safe_string($market, 'symbol');
        $marketType = 'spot';
        $spot = true;
        $swap = false;
        $baseId = $this->safe_string_2($market, 'base_currency', 'coin');
        $quoteId = $this->safe_string($market, 'quote_currency');
        $contractVal = $this->safe_float($market, 'contract_val');
        if ($contractVal !== null) {
            $marketType = 'swap';
            $spot = false;
            $swap = true;
        }
        $base = $this->safe_currency_code($baseId);
        $quote = $this->safe_currency_code($quoteId);
        $symbol = strtoupper($id);
        if ($spot) {
            $symbol = $base . '/' . $quote;
        }
        $tickSize = $this->safe_string($market, 'tick_size');
        $sizeIncrement = $this->safe_string($market, 'size_increment');
        $precision = array(
            'amount' => floatval('1e-' . $sizeIncrement),
            'price' => floatval('1e-' . $tickSize),
        );
        $minAmount = $this->safe_float_2($market, 'min_size', 'base_min_size');
        $status = $this->safe_string($market, 'status');
        $active = null;
        if ($status !== null) {
            $active = ($status === '1');
        }
        $fees = $this->safe_value_2($this->fees, $marketType, 'trading', array());
        return array_merge($fees, array(
            'id' => $id,
            'symbol' => $symbol,
            'base' => $base,
            'quote' => $quote,
            'baseId' => $baseId,
            'quoteId' => $quoteId,
            'info' => $market,
            'type' => $marketType,
            'spot' => $spot,
            'swap' => $swap,
            'active' => $active,
            'precision' => $precision,
            'limits' => array(
                'amount' => array(
                    'min' => $minAmount,
                    'max' => null,
                ),
                'price' => array(
                    'min' => $precision['price'],
                    'max' => null,
                ),
                'cost' => array(
                    'min' => $precision['price'],
                    'max' => null,
                ),
            ),
        ));
    }

    public function fetch_markets_by_type($type, $params = array ()) {
        if ($type === 'spot') {
            $response = $this->dataGetCommonSymbols ($params);
            //
            //     {
            //         "status":"ok",
            //         "ts":1595526622408,
            //         "$data":array(
            //             array(
            //                 "base_currency":"btc",
            //                 "quote_currency":"usdt",
            //                 "symbol":"btc_usdt",
            //                 "tick_size":"2",
            //                 "size_increment":"4",
            //                 "status":"1",
            //                 "base_asset_precision":"8"
            //             ),
            //         )
            //     }
            //
            $data = $this->safe_value($response, 'data', array());
            return $this->parse_markets($data);
        } else if ($type === 'swap') {
            $response = $this->capiGetMarketContracts ($params);
            //
            //     {
            //         "$data":array(
            //             "contractApis":[
            //                 array(
            //                     "instrument_id":"btcusd",
            //                     "underlying_index":"BTC",
            //                     "quote_currency":"USD",
            //                     "coin":"BTC",
            //                     "contract_val":"1",
            //                     "delivery":["07:00:00","15:00:00","23:00:00"],
            //                     "size_increment":"0",
            //                     "tick_size":"1",
            //                     "forwardContractFlag":false,
            //                     "priceEndStep":"5"
            //                 ),
            //             ]
            //         ),
            //         "status":"ok",
            //         "err_code":"00000"
            //     }
            //
            return $this->parse_markets($response);
        } else {
            throw new NotSupported($this->id . ' fetchMarketsByType does not support market $type ' . $type);
        }
    }

    public function fetch_currencies($params = array ()) {
        $response = $this->dataGetCommonCurrencys ($params);
        //
        //     {
        //         "status":"ok",
        //         "ts":1595537740466,
        //         "$data":array(
        //             "btc",
        //             "bft",
        //             "usdt",
        //             "usdt-omni",
        //             "usdt-erc20"
        //         )
        //     }
        //
        $result = array();
        $data = $this->safe_value($response, 'data', array());
        for ($i = 0; $i < count($data); $i++) {
            $id = $data[$i];
            $code = $this->safe_currency_code($id);
            $result[$code] = array(
                'id' => $id,
                'code' => $code,
                'info' => $id,
                'type' => null,
                'name' => null,
                'active' => null,
                'fee' => null,
                'precision' => null,
                'limits' => array(
                    'amount' => array( 'min' => null, 'max' => null ),
                    'price' => array( 'min' => null, 'max' => null ),
                    'cost' => array( 'min' => null, 'max' => null ),
                    'withdraw' => array( 'min' => null, 'max' => null ),
                ),
            );
        }
        return $result;
    }

    public function fetch_order_book($symbol, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'symbol' => $market['id'],
        );
        $method = null;
        if ($market['spot']) {
            $method = 'dataGetMarketDepth';
            $request['type'] = 'step0'; // step0, step1, step2, step3, step4, step5, do not merge depth if step0
        } else if ($market['swap']) {
            $method = 'capiGetMarketDepth';
            $request['limit'] = ($limit === null) ? 100 : $limit; // max 100
        }
        $response = $this->$method (array_merge($request, $params));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ch":"$market->btc_usdt.depth.step0",
        //         "ts":1595607628197,
        //         "$data":{
        //             "id":"1595607628197",
        //             "ts":"1595607628197",
        //             "bids":[
        //                 ["9534.99","15.36160000000000000000"],
        //                 ["9534.85","0.14580000000000000000"],
        //                 ["9534.73","0.02100000000000000000"],
        //             ],
        //             "asks":[
        //                 ["9535.02","7.37160000000000000000"],
        //                 ["9535.03","0.09040000000000000000"],
        //                 ["9535.05","0.02180000000000000000"],
        //             ]
        //         }
        //     }
        //
        // swap
        //
        //     {
        //         "asks":[
        //             ["9579.0","119865",1],
        //             ["9579.5","90069",1],
        //             ["9580.0","256673",1],
        //         ],
        //         "bids":[
        //             ["9578.5","2417",1],
        //             ["9577.5","3024",1],
        //             ["9577.0","21548",1],
        //         ],
        //         "$timestamp":"1595664767349"
        //     }
        //
        $data = $this->safe_value($response, 'data', $response);
        $timestamp = $this->safe_integer_2($data, 'timestamp', 'ts');
        $nonce = $this->safe_integer($data, 'id');
        $orderbook = $this->parse_order_book($data, $timestamp);
        $orderbook['nonce'] = $nonce;
        return $orderbook;
    }

    public function parse_ticker($ticker, $market = null) {
        //
        // spot
        //
        //     fetchTicker
        //
        //     {
        //         "id":"1595538241113",
        //         "$bid":["0.028474000000","1.139400000000"],
        //         "$ask":["0.028482000000","0.353100000000"],
        //         "amount":"2850.6649",
        //         "count":"818",
        //         "$open":"0.02821",
        //         "close":"0.028474",
        //         "low":"0.02821",
        //         "high":"0.029091",
        //         "vol":"79.4548693404"
        //     }
        //
        //     fetchTickers
        //
        //     {
        //         "amount":"30086.8095",
        //         "count":"22450",
        //         "$open":"9525.11",
        //         "close":"9591.81",
        //         "low":"9510.68",
        //         "high":"9659.7",
        //         "vol":"286239092.250461",
        //         "$symbol":"btc_usdt"
        //     }
        //
        // swap
        //
        //     {
        //         "instrument_id":"btcusd",
        //         "$last":"9574.5",
        //         "best_ask":"9575.0",
        //         "best_bid":"9574.0",
        //         "high_24h":"9672",
        //         "low_24h":"9512",
        //         "volume_24h":"567697050",
        //         "$timestamp":"1595538450096"
        //     }
        //
        $timestamp = $this->safe_integer_2($ticker, 'timestamp', 'id');
        $symbol = null;
        $marketId = $this->safe_string_2($ticker, 'instrument_id', 'symbol');
        if (is_array($this->markets_by_id) && array_key_exists($marketId, $this->markets_by_id)) {
            $market = $this->markets_by_id[$marketId];
            $symbol = $market['symbol'];
        } else if ($marketId !== null) {
            $parts = explode('_', $marketId);
            $numParts = is_array($parts) ? count($parts) : 0;
            if ($numParts === 2) {
                list($baseId, $quoteId) = $parts;
                $base = $this->safe_currency_code($baseId);
                $quote = $this->safe_currency_code($quoteId);
                $symbol = $base . '/' . $quote;
            } else {
                $symbol = $marketId;
            }
        }
        if (($symbol === null) && ($market !== null)) {
            $symbol = $market['symbol'];
        }
        $last = $this->safe_float_2($ticker, 'last', 'close');
        $open = $this->safe_float($ticker, 'open');
        $bidVolume = null;
        $askVolume = null;
        $bid = $this->safe_value($ticker, 'bid');
        if ($bid === null) {
            $bid = $this->safe_float($ticker, 'best_bid');
        } else {
            $bidVolume = $this->safe_float($bid, 1);
            $bid = $this->safe_float($bid, 0);
        }
        $ask = $this->safe_value($ticker, 'ask');
        if ($ask === null) {
            $ask = $this->safe_float($ticker, 'best_ask');
        } else {
            $askVolume = $this->safe_float($ask, 1);
            $ask = $this->safe_float($ask, 0);
        }
        $baseVolume = $this->safe_float_2($ticker, 'amount', 'volume_24h');
        $quoteVolume = $this->safe_float($ticker, 'vol');
        $vwap = $this->vwap($baseVolume, $quoteVolume);
        $change = null;
        $percentage = null;
        $average = null;
        if (($last !== null) && ($open !== null)) {
            $change = $last - $open;
            $percentage = $change / $open * 100;
            $average = $this->sum($open, $last) / 2;
        }
        return array(
            'symbol' => $symbol,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'high' => $this->safe_float_2($ticker, 'high', 'high_24h'),
            'low' => $this->safe_float_2($ticker, 'low', 'low_24h'),
            'bid' => $bid,
            'bidVolume' => $bidVolume,
            'ask' => $ask,
            'askVolume' => $askVolume,
            'vwap' => $vwap,
            'open' => $open,
            'close' => $last,
            'last' => $last,
            'previousClose' => null,
            'change' => $change,
            'percentage' => $percentage,
            'average' => $average,
            'baseVolume' => $baseVolume,
            'quoteVolume' => $quoteVolume,
            'info' => $ticker,
        );
    }

    public function fetch_ticker($symbol, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $method = null;
        if ($market['spot']) {
            $method = 'dataGetMarketDetailMerged';
        } else if ($market['swap']) {
            $method = 'capiGetMarketTicker';
        }
        $request = array(
            'symbol' => $market['id'],
        );
        $response = $this->$method (array_merge($request, $params));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ch":"$market->eth_btc.detail.merged",
        //         "ts":1595538241474,
        //         "$data":{
        //             "id":"1595538241113",
        //             "bid":["0.028474000000","1.139400000000"],
        //             "ask":["0.028482000000","0.353100000000"],
        //             "amount":"2850.6649",
        //             "count":"818",
        //             "open":"0.02821",
        //             "close":"0.028474",
        //             "low":"0.02821",
        //             "high":"0.029091",
        //             "vol":"79.4548693404"
        //         }
        //     }
        //
        // swap
        //
        //     {
        //         "$symbol":"btcusd",
        //         "last":"9575.5",
        //         "best_ask":"9576.0",
        //         "best_bid":"9575.0",
        //         "high_24h":"9646",
        //         "low_24h":"9516",
        //         "volume_24h":"516656839",
        //         "timestamp":"1595664217405"
        //     }
        //
        $data = $this->safe_value($response, 'data', $response);
        return $this->parse_ticker($data, $market);
    }

    public function fetch_tickers_by_type($type, $symbols = null, $params = array ()) {
        $this->load_markets();
        $method = null;
        if ($type === 'spot') {
            $method = 'dataGetMarketTickers';
        } else if ($type === 'swap') {
            $method = 'capiGetMarketTickers';
        }
        $response = $this->$method ($params);
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ts":1595542893250,
        //         "$data":array(
        //             {
        //                 "amount":"30086.8095",
        //                 "count":"22450",
        //                 "open":"9525.11",
        //                 "close":"9591.81",
        //                 "low":"9510.68",
        //                 "high":"9659.7",
        //                 "vol":"286239092.250461",
        //                 "$symbol":"btc_usdt"
        //             }
        //         )
        //     }
        //
        // swap
        //
        //     array(
        //         {
        //             "$symbol":"btcusd",
        //             "last":"9572",
        //             "best_ask":"9571.5",
        //             "best_bid":"9570.5",
        //             "high_24h":"9646",
        //             "low_24h":"9516",
        //             "volume_24h":"515401635",
        //             "$timestamp":"1595664479952"
        //         }
        //     )
        //
        $data = $this->safe_value($response, 'data', $response);
        $timestamp = null;
        if (gettype($response) === 'array' && count(array_filter(array_keys($response), 'is_string')) != 0) {
            $timestamp = $this->safe_integer($response, 'ts');
        }
        $result = array();
        for ($i = 0; $i < count($data); $i++) {
            $ticker = $this->parse_ticker(array_merge(array(
                'timestamp' => $timestamp,
            ), $data[$i]));
            $symbol = $ticker['symbol'];
            $result[$symbol] = $ticker;
        }
        return $this->filter_by_array($result, 'symbol', $symbols);
    }

    public function fetch_tickers($symbols = null, $params = array ()) {
        $defaultType = $this->safe_string_2($this->options, 'fetchTickers', 'defaultType');
        $type = $this->safe_string($params, 'type', $defaultType);
        return $this->fetch_tickers_by_type($type, $symbols, $this->omit($params, 'type'));
    }

    public function parse_trade($trade, $market = null) {
        //
        // fetchTrades (public)
        //
        //     spot
        //
        //     {
        //         "$id":"1",
        //         "$price":"9533.81",
        //         "$amount":"0.7326",
        //         "direction":"sell",
        //         "ts":"1595604964000"
        //     }
        //
        //     swap
        //
        //     {
        //         "trade_id":"670581881367954915",
        //         "$price":"9553.00",
        //         "size":"20",
        //         "$side":"sell",
        //         "$timestamp":"1595605100004",
        //         "$symbol":"btcusd"
        //     }
        //
        // spot fetchMyTrades (private)
        //
        //     {
        //         "$id" => 29555,
        //         "order_id" => 59378,
        //         "match_id" => 59335,
        //         "$symbol" => "eth_usdt",
        //         "$type" => "buy-limit",
        //         "source" => "api",
        //         "$price" => "100.1000000000",
        //         "filled_amount" => "0.9845000000",
        //         "filled_fees" => "0.0019690000",
        //         "created_at" => 1494901400487
        //     }
        //
        // fetchOrderTrades (private)
        //
        //     spot
        //
        //     {
        //         "$id":"614164775",
        //         "created_at":"1596298860602",
        //         "filled_amount":"0.0417000000000000",
        //         "filled_fees":"0.0000834000000000",
        //         "match_id":"673491702661292033",
        //         "order_id":"673491720340279296",
        //         "$price":"359.240000000000",
        //         "source":"接口",
        //         "$symbol":"eth_usdt",
        //         "$type":"buy-$market"
        //     }
        //
        //     swap
        //
        //     {
        //         "trade_id":"6667390",
        //         "$symbol":"cmt_btcusdt",
        //         "order_id":"525946425993854915",
        //         "$price":"9839.00",
        //         "order_qty":"3466",
        //         "$fee":"-0.0000528407360000",
        //         "$timestamp":"1561121514442",
        //         "exec_type":"M",
        //         "$side":"3"
        //     }
        //
        $symbol = null;
        $marketId = $this->safe_string($trade, 'symbol');
        $base = null;
        $quote = null;
        if (is_array($this->markets_by_id) && array_key_exists($marketId, $this->markets_by_id)) {
            $market = $this->markets_by_id[$marketId];
            $symbol = $market['symbol'];
            $base = $market['base'];
            $quote = $market['quote'];
        } else if ($marketId !== null) {
            $parts = explode('_', $marketId);
            $numParts = is_array($parts) ? count($parts) : 0;
            if ($numParts === 2) {
                list($baseId, $quoteId) = $parts;
                $base = $this->safe_currency_code($baseId);
                $quote = $this->safe_currency_code($quoteId);
                $symbol = $base . '/' . $quote;
            } else {
                $symbol = strtoupper($marketId);
            }
        }
        if (($symbol === null) && ($market !== null)) {
            $symbol = $market['symbol'];
            $base = $market['base'];
            $quote = $market['quote'];
        }
        $timestamp = $this->safe_integer($trade, 'created_at');
        $timestamp = $this->safe_integer_2($trade, 'timestamp', 'ts', $timestamp);
        $price = $this->safe_float($trade, 'price');
        $amount = $this->safe_float_2($trade, 'filled_amount', 'order_qty');
        $amount = $this->safe_float_2($trade, 'size', 'amount', $amount);
        $takerOrMaker = $this->safe_string_2($trade, 'exec_type', 'liquidity');
        if ($takerOrMaker === 'M') {
            $takerOrMaker = 'maker';
        } else if ($takerOrMaker === 'T') {
            $takerOrMaker = 'taker';
        }
        $orderType = $this->safe_string($trade, 'type');
        $side = null;
        $type = null;
        if ($orderType !== null) {
            $side = $this->safe_string($trade, 'type');
            $type = $this->parse_order_type($side);
            $side = $this->parse_order_side($side);
        } else {
            $side = $this->safe_string_2($trade, 'side', 'direction');
            $type = $this->parse_order_type($side);
            $side = $this->parse_order_side($side);
        }
        $cost = null;
        if ($amount !== null) {
            if ($price !== null) {
                $cost = $amount * $price;
            }
        }
        $feeCost = $this->safe_float($trade, 'fee');
        if ($feeCost === null) {
            $feeCost = $this->safe_float($trade, 'filled_fees');
        } else {
            $feeCost = -$feeCost;
        }
        $fee = null;
        if ($feeCost !== null) {
            $feeCurrency = ($side === 'buy') ? $base : $quote;
            $fee = array(
                // $fee is either a positive number (invitation rebate)
                // or a negative number (transaction $fee deduction)
                // therefore we need to invert the $fee
                // more about it https://github.com/ccxt/ccxt/issues/5909
                'cost' => $feeCost,
                'currency' => $feeCurrency,
            );
        }
        $orderId = $this->safe_string($trade, 'order_id');
        $id = $this->safe_string_2($trade, 'trade_id', 'id');
        return array(
            'info' => $trade,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'symbol' => $symbol,
            'id' => $id,
            'order' => $orderId,
            'type' => $type,
            'takerOrMaker' => $takerOrMaker,
            'side' => $side,
            'price' => $price,
            'amount' => $amount,
            'cost' => $cost,
            'fee' => $fee,
        );
    }

    public function fetch_trades($symbol, $limit = null, $since = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'symbol' => $market['id'],
        );
        $method = null;
        if ($market['spot']) {
            $method = 'dataGetMarketHistoryTrade';
        } else if ($market['swap']) {
            $method = 'capiGetMarketTrades';
        }
        if ($market['spot']) {
            if ($limit !== null) {
                $request['size'] = $limit; // default 1, max 2000
            }
        } else if ($market['swap']) {
            if ($limit === null) {
                $limit = 100; // default 20, max 100
            }
            $request['limit'] = $limit;
        }
        $response = $this->$method (array_merge($request, $params));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ch":"$market->btc_usdt.trade.detail",
        //         "ts":1595604968430,
        //         "$data":{
        //             "ts":"1595604964000",
        //             "$data":array(
        //                 array("id":"1","price":"9533.81","amount":"0.7326","direction":"sell","ts":"1595604964000"),
        //                 array("id":"2","price":"9533.67","amount":"1.1591","direction":"buy","ts":"1595604961000"),
        //                 array("id":"3","price":"9533.67","amount":"1.5022","direction":"sell","ts":"1595604959000"),
        //             )
        //         }
        //     }
        //
        // swap
        //
        //     array(
        //         array("trade_id":"670833198971748613","price":"9578.50","size":"5412","side":"sell","timestamp":"1595665018790","$symbol":"btcusd"),
        //         array("trade_id":"670833194240574915","price":"9579.00","size":"3972","side":"buy","timestamp":"1595665017662","$symbol":"btcusd"),
        //         array("trade_id":"670833194240573915","price":"9579.00","size":"1227","side":"buy","timestamp":"1595665017662","$symbol":"btcusd"),
        //     )
        //
        $trades = null;
        if (gettype($response) === 'array' && count(array_filter(array_keys($response), 'is_string')) == 0) {
            $trades = $response;
        } else {
            $data = $this->safe_value($response, 'data', array());
            $trades = $this->safe_value_2($data, 'data', array());
        }
        return $this->parse_trades($trades, $market, $since, $limit);
    }

    public function parse_ohlcv($ohlcv, $market = null, $timeframe = '1m') {
        //
        // spot
        //
        //     {
        //         "id":"1594694700000",
        //         "amount":"283.6811",
        //         "count":"234",
        //         "open":"9230.00",
        //         "close":"9227.15",
        //         "low":"9206.66",
        //         "high":"9232.33",
        //         "vol":"2618015.032504000000"
        //     }
        //
        // swap
        //
        //     array(
        //         "1594693800000",
        //         "9240",
        //         "9241",
        //         "9222",
        //         "9228.5",
        //         "3913370",
        //         "424.003616350563"
        //     )
        //
        $options = $this->safe_value($this->options, 'parseOHLCV', array());
        $volume = $this->safe_value($options, 'volume', array());
        if (gettype($ohlcv) === 'array' && count(array_filter(array_keys($ohlcv), 'is_string')) == 0) {
            $volumeIndex = $this->safe_string($volume, $market['type'], 'amount');
            return array(
                $this->safe_integer($ohlcv, 0),         // timestamp
                $this->safe_float($ohlcv, 1),           // Open
                $this->safe_float($ohlcv, 2),           // High
                $this->safe_float($ohlcv, 3),           // Low
                $this->safe_float($ohlcv, 4),           // Close
                // $this->safe_float($ohlcv, 5),        // Quote Volume
                // $this->safe_float($ohlcv, 6),        // Base Volume
                $this->safe_float($ohlcv, $volumeIndex), // Volume, bitget will return base $volume in the 7th element for future markets
            );
        } else {
            $volumeIndex = $this->safe_value($volume, $market['type'], 6);
            return array(
                $this->safe_integer($ohlcv, 'id'),
                $this->safe_float($ohlcv, 'open'),      // Open
                $this->safe_float($ohlcv, 'high'),      // High
                $this->safe_float($ohlcv, 'low'),       // Low
                $this->safe_float($ohlcv, 'close'),     // Close
                $this->safe_float($ohlcv, $volumeIndex), // Base Volume
            );
        }
    }

    public function fetch_ohlcv($symbol, $timeframe = '1m', $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'symbol' => $market['id'],
        );
        $method = null;
        $type = $market['type'];
        $options = $this->safe_value($this->options, 'timeframes', array());
        $intervals = $this->safe_value($options, $type, array());
        $interval = $this->safe_value($intervals, $this->timeframes[$timeframe]);
        if ($market['spot']) {
            $method = 'dataGetMarketHistoryKline';
            $request['period'] = $interval;
            if ($limit !== null) {
                $request['size'] = $limit; // default 150, max 1000
            }
        } else if ($market['swap']) {
            $duration = $this->parse_timeframe($timeframe);
            $method = 'capiGetMarketCandles';
            $request['granularity'] = $interval;
            $now = $this->milliseconds();
            if ($since === null) {
                if ($limit === null) {
                    $limit = 1000;
                }
                $request['start'] = $this->iso8601($now - $limit * $duration * 1000);
                $request['end'] = $this->iso8601($now);
            } else {
                $request['start'] = $this->iso8601($since);
                if ($limit === null) {
                    $request['end'] = $this->iso8601($now);
                } else {
                    $request['end'] = $this->iso8601($this->sum($since, $limit * $duration * 1000));
                }
            }
        }
        $response = $this->$method (array_merge($request, $params));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ch":"$market->btc_usdt.kline.15min",
        //         "ts":1595594183874,
        //         "data":array(
        //             array("id":"1594694700000","amount":"283.6811","count":"234","open":"9230.00","close":"9227.15","low":"9206.66","high":"9232.33","vol":"2618015.032504000000"),
        //             array("id":"1594695600000","amount":"457.2904","count":"238","open":"9227.15","close":"9229.46","low":"9223.80","high":"9235.14","vol":"4220734.684570000000"),
        //             array("id":"1594696500000","amount":"501.2353","count":"255","open":"9229.46","close":"9227.78","low":"9222.69","high":"9230.74","vol":"4625779.185006000000"),
        //         )
        //     }
        //
        // swap
        //
        //     [
        //         ["1594764900000","9255.5","9261","9251","9255.5","3958946","427.742307964305"],
        //         ["1594765800000","9255.5","9264","9252","9258","3609496","389.832756058107"],
        //         ["1594766700000","9258","9260","9244.5","9250.5","3738600","403.97870345085"],
        //     ]
        //
        $candles = $response;
        if (gettype($response) === 'array' && count(array_filter(array_keys($response), 'is_string')) != 0) {
            $candles = $this->safe_value($response, 'data', array());
        }
        return $this->parse_ohlcvs($candles, $market, $timeframe, $since, $limit);
    }

    public function parse_spot_balance($response) {
        //
        //     {
        //         "status":"ok",
        //         "ts":1595681450932,
        //         "$data":{
        //             "list":array(
        //                 array("$balance":"0.0000000000000000","currency":"BTC","$type":"trade"),
        //                 array("$balance":"0.0000000000000000","currency":"BTC","$type":"frozen"),
        //                 array("$balance":"0.0000000000000000","currency":"BTC","$type":"lock"),
        //             ),
        //             "id":"7420922606",
        //             "$type":"spot",
        //             "state":"working"
        //         }
        //     }
        //
        $result = array( 'info' => $response );
        $data = $this->safe_value($response, 'data');
        $balances = $this->safe_value($data, 'list');
        for ($i = 0; $i < count($balances); $i++) {
            $balance = $balances[$i];
            $currencyId = $this->safe_string($balance, 'currency');
            $code = $this->safe_currency_code($currencyId);
            if (!(is_array($result) && array_key_exists($code, $result))) {
                $account = $this->account();
                $result[$code] = $account;
            }
            $type = $this->safe_value($balance, 'type');
            if ($type === 'trade') {
                $result[$code]['free'] = $this->safe_float($balance, 'balance');
            } else if (($type === 'frozen') || ($type === 'lock')) {
                $used = $this->safe_float($result[$code], 'used');
                $result[$code]['used'] = $this->sum($used, $this->safe_float($balance, 'balance'));
            }
        }
        return $this->parse_balance($result);
    }

    public function parse_swap_balance($response) {
        //
        // swap
        //
        //     array(
        //         array("equity":"0","fixed_balance":"0","total_avail_balance":"0","margin":"0","realized_pnl":"0","unrealized_pnl":"0","$symbol":"bchusd","margin_frozen":"0","timestamp":"1595673431547","margin_mode":"fixed","forwardContractFlag":false),
        //         array("equity":"0","fixed_balance":"0","total_avail_balance":"0","margin":"0","realized_pnl":"0","unrealized_pnl":"0","$symbol":"ethusd","margin_frozen":"0","timestamp":"1595673431573","margin_mode":"fixed","forwardContractFlag":false),
        //         array("equity":"0","fixed_balance":"0","total_avail_balance":"0","margin":"0","realized_pnl":"0","unrealized_pnl":"0","$symbol":"cmt_btcsusdt","margin_frozen":"0","timestamp":"1595673431577","margin_mode":"fixed","forwardContractFlag":true),
        //     )
        //
        //
        $result = array();
        for ($i = 0; $i < count($response); $i++) {
            $balance = $response[$i];
            $marketId = $this->safe_string($balance, 'symbol');
            $symbol = $marketId;
            if (is_array($this->markets_by_id) && array_key_exists($marketId, $this->markets_by_id)) {
                $symbol = $this->markets_by_id[$marketId]['symbol'];
            }
            $account = $this->account();
            // it may be incorrect to use total, free and used for swap accounts
            $account['total'] = $this->safe_float($balance, 'equity');
            $account['free'] = $this->safe_float($balance, 'total_avail_balance');
            $result[$symbol] = $account;
        }
        return $this->parse_balance($result);
    }

    public function fetch_accounts($params = array ()) {
        $request = array(
            'method' => 'accounts',
        );
        $response = $this->apiGetAccountAccounts (array_merge($request, $params));
        //
        //     {
        //         "status":"ok",
        //         "ts":1595679591824,
        //         "$data":array(
        //             array("id":"7420922606","$type":"spot","state":"working")
        //         )
        //     }
        //
        $data = $this->safe_value($response, 'data', array());
        $result = array();
        for ($i = 0; $i < count($data); $i++) {
            $account = $data[$i];
            $accountId = $this->safe_string($account, 'id');
            $type = $this->safe_string_lower($account, 'type');
            $result[] = array(
                'id' => $accountId,
                'type' => $type,
                'currency' => null,
                'info' => $account,
            );
        }
        return $result;
    }

    public function find_account_by_type($type) {
        $this->load_markets();
        $this->load_accounts();
        $accountsByType = $this->group_by($this->accounts, 'type');
        $accounts = $this->safe_value($accountsByType, $type);
        if ($accounts === null) {
            throw new ExchangeError($this->id . " findAccountByType() could not find an accountId with $type '" . $type . "', specify the 'accountId' parameter instead"); // eslint-disable-line quotes
        }
        $numAccounts = is_array($accounts) ? count($accounts) : 0;
        if ($numAccounts > 1) {
            throw new ExchangeError($this->id . " findAccountByType() found more than one accountId with $type '" . $type . "', specify the 'accountId' parameter instead"); // eslint-disable-line quotes
        }
        return $accounts[0];
    }

    public function get_account_id($params) {
        $this->load_markets();
        $this->load_accounts();
        $defaultAccountId = $this->safe_string($this->options, 'accountId');
        $accountId = $this->safe_string($params, 'accountId', $defaultAccountId);
        if ($accountId !== null) {
            return $accountId;
        }
        $defaultType = $this->safe_string($this->options, 'defaultType', 'margin');
        $type = $this->safe_string($params, 'type', $defaultType);
        $params = $this->omit($params, 'type');
        if ($type === null) {
            throw new ArgumentsRequired($this->id . " getAccountId() requires an 'accountId' parameter");
        }
        $account = $this->find_account_by_type($type);
        return $account['id'];
    }

    public function fetch_balance($params = array ()) {
        $this->load_markets();
        $this->load_accounts();
        $defaultType = $this->safe_string_2($this->options, 'fetchBalance', 'defaultType');
        $type = $this->safe_string($params, 'type', $defaultType);
        if ($type === null) {
            throw new ArgumentsRequired($this->id . " fetchBalance() requires a 'type' parameter, one of 'spot', 'swap'");
        }
        $method = null;
        $query = $this->omit($params, 'type');
        if ($type === 'spot') {
            $accountId = $this->get_account_id($params);
            $method = 'apiGetAccountsAccountIdBalance';
            $query['account_id'] = $accountId;
            $query['method'] = 'balance';
        } else if ($type === 'swap') {
            $method = 'swapGetAccountAccounts';
        }
        $response = $this->$method ($query);
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ts":1595681450932,
        //         "data":{
        //             "list":array(
        //                 array("balance":"0.0000000000000000","currency":"BTC","$type":"trade"),
        //                 array("balance":"0.0000000000000000","currency":"BTC","$type":"frozen"),
        //                 array("balance":"0.0000000000000000","currency":"BTC","$type":"lock"),
        //             ),
        //             "id":"7420922606",
        //             "$type":"spot",
        //             "state":"working"
        //         }
        //     }
        //
        // swap
        //
        //     array(
        //         array("equity":"0","fixed_balance":"0","total_avail_balance":"0","margin":"0","realized_pnl":"0","unrealized_pnl":"0","symbol":"bchusd","margin_frozen":"0","timestamp":"1595673431547","margin_mode":"fixed","forwardContractFlag":false),
        //         array("equity":"0","fixed_balance":"0","total_avail_balance":"0","margin":"0","realized_pnl":"0","unrealized_pnl":"0","symbol":"ethusd","margin_frozen":"0","timestamp":"1595673431573","margin_mode":"fixed","forwardContractFlag":false),
        //         array("equity":"0","fixed_balance":"0","total_avail_balance":"0","margin":"0","realized_pnl":"0","unrealized_pnl":"0","symbol":"cmt_btcsusdt","margin_frozen":"0","timestamp":"1595673431577","margin_mode":"fixed","forwardContractFlag":true),
        //     )
        //
        return $this->parse_balance_by_type($type, $response);
    }

    public function parse_balance_by_type($type, $response) {
        if ($type === 'spot') {
            return $this->parse_spot_balance($response);
        } else if ($type === 'swap') {
            return $this->parse_swap_balance($response);
        }
        throw new NotSupported($this->id . " fetchBalance does not support the '" . $type . "' $type (the $type must be one of 'account', 'spot', 'margin', 'futures', 'swap')");
    }

    public function parse_order_status($status) {
        $statuses = array(
            'submitted' => 'open',
            'partial-filled' => 'open',
            'partial-canceled' => 'canceled',
            'filled' => 'closed',
            'canceled' => 'canceled',
            '-2' => 'failed',
            '-1' => 'canceled',
            '0' => 'open',
            '1' => 'open',
            '2' => 'closed',
            '3' => 'open',
            '4' => 'canceled',
        );
        return $this->safe_string($statuses, $status, $status);
    }

    public function parse_order_side($side) {
        $sides = array(
            'buy-market' => 'buy',
            'sell-market' => 'sell',
            'buy-limit' => 'buy',
            'sell-limit' => 'sell',
            '1' => 'long', // open long
            '2' => 'short', // open short
            '3' => 'long', // close long
            '4' => 'short', // close short
        );
        return $this->safe_string($sides, $side, $side);
    }

    public function parse_order_type($type) {
        $types = array(
            'buy-market' => 'market',
            'sell-market' => 'market',
            'buy-limit' => 'limit',
            'sell-limit' => 'limit',
            '1' => 'open', // open long
            '2' => 'open', // open short
            '3' => 'close', // close long
            '4' => 'close', // close short
        );
        return $this->safe_string($types, $type, $type);
    }

    public function parse_order($order, $market = null) {
        //
        // createOrder
        //
        //     spot
        //
        //     {
        //         "$status":"ok",
        //         "ts":1595792596056,
        //         "data":671368296142774272
        //     }
        //
        //     swap
        //
        //     {
        //         "client_oid":"58775e54-0592-491c-97e8-e2369025f2d1",
        //         "order_id":"671757564085534713"
        //     }
        //
        // cancelOrder
        //
        //     spot
        //
        //     {
        //         "$status" => "ok",
        //         "ts" => 1595818631279,
        //         "data" => 671368296142774272
        //     }
        //
        //     swap
        //
        //     {
        //         "order_id":"671757564085534713",
        //         "client_oid":"58775e54-0592-491c-97e8-e2369025f2d1",
        //         "$symbol":"cmt_ethusdt",
        //         "result":true,
        //         "err_code":null,
        //         "err_msg":null
        //     }
        //
        // fetchOpenOrders, fetchClosedOrders, fetchOrder
        //
        //     spot
        //
        //     {
        //         "account_id":"7420922606",
        //         "$amount":"0.1000000000000000",
        //         "canceled_at":"1595872129618",
        //         "created_at":"1595872089525",
        //         "filled_amount":"0.000000000000",
        //         "filled_cash_amount":"0.000000000000",
        //         "filled_fees":"0.000000000000",
        //         "finished_at":"1595872129618",
        //         "$id":"671701716584665088",
        //         "$price":"150.000000000000",
        //         "source":"接口",
        //         "state":"canceled",
        //         "$symbol":"eth_usdt",
        //         "$type":"buy-limit"
        //     }
        //
        //     swap
        //
        //     {
        //         "$symbol":"cmt_ethusdt",
        //         "size":"1",
        //         "$timestamp":"1595885546770",
        //         "client_oid":"f3aa81d6-9a4c-4eab-bebe-ebc19da21cf2",
        //         "createTime":"1595885521200",
        //         "filled_qty":"0",
        //         "$fee":"0.00000000",
        //         "order_id":"671758053112020913",
        //         "$price":"150.00",
        //         "price_avg":"0.00",
        //         "$status":"0",
        //         "$type":"1",
        //         "order_type":"0",
        //         "totalProfits":null
        //     }
        //
        $id = $this->safe_string($order, 'order_id');
        $id = $this->safe_string_2($order, 'id', 'data', $id);
        $timestamp = $this->safe_integer_2($order, 'created_at', 'createTime');
        $type = $this->safe_string($order, 'type');
        $side = $this->parse_order_side($type);
        $type = $this->parse_order_type($type);
        // if (($side !== 'buy') && ($side !== 'sell')) {
        //     $side = $this->parse_order_side($type);
        // }
        // if (($type !== 'limit') && ($type !== 'market')) {
        //     if (is_array($order) && array_key_exists('pnl', $order)) {
        //         $type = 'futures';
        //     } else {
        //         $type = 'swap';
        //     }
        // }
        $symbol = null;
        $marketId = $this->safe_string($order, 'symbol');
        if ($marketId !== null) {
            if (is_array($this->markets_by_id) && array_key_exists($marketId, $this->markets_by_id)) {
                $market = $this->markets_by_id[$marketId];
            } else {
                $symbol = strtoupper($marketId);
            }
        }
        if (($symbol === null) && ($market !== null)) {
            $symbol = $market['symbol'];
        }
        $amount = $this->safe_float_2($order, 'amount', 'size');
        $filled = $this->safe_float_2($order, 'filled_amount', 'filled_qty');
        $remaining = null;
        if ($amount !== null) {
            if ($filled !== null) {
                $amount = max ($amount, $filled);
                $remaining = max (0, $amount - $filled);
            }
        }
        if ($type === 'market') {
            $remaining = 0;
        }
        $cost = $this->safe_float($order, 'filled_cash_amount');
        $price = $this->safe_float($order, 'price');
        $average = $this->safe_float($order, 'price_avg');
        if (($average === null) && ($filled !== null) && ($cost !== null) && ($filled > 0)) {
            $average = $cost / $filled;
        }
        $status = $this->parse_order_status($this->safe_string_2($order, 'state', 'status'));
        $feeCost = $this->safe_float_2($order, 'filled_fees', 'fee');
        $fee = null;
        if ($feeCost !== null) {
            $feeCurrency = null;
            $fee = array(
                'cost' => $feeCost,
                'currency' => $feeCurrency,
            );
        }
        $clientOrderId = $this->safe_string($order, 'client_oid');
        return array(
            'info' => $order,
            'id' => $id,
            'clientOrderId' => $clientOrderId,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'lastTradeTimestamp' => null,
            'symbol' => $symbol,
            'type' => $type,
            'timeInForce' => null,
            'postOnly' => null,
            'side' => $side,
            'price' => $price,
            'stopPrice' => null,
            'average' => $average,
            'cost' => $cost,
            'amount' => $amount,
            'filled' => $filled,
            'remaining' => $remaining,
            'status' => $status,
            'fee' => $fee,
            'trades' => null,
        );
    }

    public function create_order($symbol, $type, $side, $amount, $price = null, $params = array ()) {
        $this->load_markets();
        $this->load_accounts();
        $market = $this->market($symbol);
        //
        // spot
        //
        //     account_id true string Account ID, obtained using the accounts $method-> Currency transactions use the accountid of the'spot' account; for loan asset transactions, please use the accountid of the'margin' account
        //     $amount true string A limit order indicates the quantity of the order, when a $market $price buy order indicates how much money to buy, and when a $market $price sell order indicates how much currency to sell
        //     $price false string Order $price, $market order does not pass this parameter
        //     source false string Order source api
        //     $symbol true string Trading pair  btc_usdt, eth_btc ...
        //     $type true string Order Type  buy-$market => buy at $market $price, sell-$market => sell at $market $price, buy-limit => buy at limit $price, sell-limit => sell at limit $price
        //
        // swap
        //
        //     $symbol String Yes Contract ID
        //     client_oid String Yes customize order IDs to identify your orders. (Less than 50 characters without special characters,
        //     size String Yes Quantity to buy or sell (value not equal to 0 or negative)
        //     $type String Yes 1 Open long 2Open short 3 Close long 4 Close short
        //     order_type String Yes 0 => Normal order (Unfilled and 0 imply normal limit order) 1 => Post only 2 => Fill or Kill 3 => Immediate Or Cancel
        //     match_price String Yes 0 Limit $price 1 $market $price
        //     $price String No Price of each contract
        //
        $request = array(
            'symbol' => $market['id'],
        );
        $clientOrderId = $this->safe_string_2($params, 'client_oid', 'clientOrderId', $this->uuid());
        $params = $this->omit($params, array( 'client_oid', 'clientOrderId' ));
        $method = null;
        if ($market['spot']) {
            $accountId = $this->get_account_id(array(
                'type' => $market['type'],
            ));
            $method = 'apiPostOrderOrdersPlace';
            $request['account_id'] = $accountId;
            $request['method'] = 'place';
            $request['type'] = $side . '-' . $type;
            if ($type === 'limit') {
                $request['amount'] = $this->amount_to_precision($symbol, $amount);
                $request['price'] = $this->price_to_precision($symbol, $price);
            } else if ($type === 'market') {
                // for $market buy it requires the $amount of quote currency to spend
                if ($side === 'buy') {
                    $cost = $this->safe_float($params, 'amount');
                    $createMarketBuyOrderRequiresPrice = $this->safe_value($this->options, 'createMarketBuyOrderRequiresPrice', true);
                    if ($createMarketBuyOrderRequiresPrice) {
                        if ($price !== null) {
                            if ($cost === null) {
                                $cost = $amount * $price;
                            }
                        } else if ($cost === null) {
                            throw new InvalidOrder($this->id . " createOrder() requires the $price argument with $market buy orders to calculate total order $cost ($amount to spend), where $cost = $amount * $price-> Supply a $price argument to createOrder() call if you want the $cost to be calculated for you from $price and $amount, or, alternatively, add .options['createMarketBuyOrderRequiresPrice'] = false and supply the total $cost value in the 'amount' argument or in the 'amount' extra parameter (the exchange-specific behaviour)");
                        }
                    } else {
                        $cost = ($cost === null) ? $amount : $cost;
                    }
                    $request['amount'] = $this->cost_to_precision($symbol, $cost);
                } else if ($side === 'sell') {
                    $request['amount'] = $this->amount_to_precision($symbol, $amount);
                }
            }
            // ...
        } else if ($market['swap']) {
            $request['order_type'] = '0'; // '0' = Normal order, null and 0 imply a normal limit order, '1' = Post only, '2' = Fill or Kill, '3' = Immediate Or Cancel
            $request['client_oid'] = $clientOrderId;
            $orderType = $this->safe_string($params, 'type');
            if ($orderType === null) {
                throw new ArgumentsRequired($this->id . " createOrder() requires a $type parameter, '1' = open long, '2' = open short, '3' = close long, '4' = close short for " . $market['type'] . ' orders');
            }
            $request['size'] = $this->amount_to_precision($symbol, $amount);
            $request['type'] = $orderType;
            // if match_price is set to '1', the $price parameter will be ignored for $market orders
            if ($type === 'limit') {
                $request['match_price'] = '0';
                $request['price'] = $this->price_to_precision($symbol, $price);
            } else if ($type === 'market') {
                $request['match_price'] = '1';
            }
            $method = 'swapPostOrderPlaceOrder';
        }
        $response = $this->$method (array_merge($request, $params));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ts":1595792596056,
        //         "data":"671368296142774272"
        //     }
        //
        // swap
        //
        //     {
        //         "client_oid":"58775e54-0592-491c-97e8-e2369025f2d1",
        //         "order_id":"671757564085534713"
        //     }
        //
        return $this->parse_order($response, $market);
    }

    public function cancel_order($id, $symbol = null, $params = array ()) {
        $this->load_markets();
        $market = null;
        $type = null;
        if ($symbol === null) {
            $defaultType = $this->safe_string_2($this->options, 'cancelOrder', 'defaultType');
            $type = $this->safe_string($params, 'type', $defaultType);
            if ($type === 'spot') {
                if ($symbol === null) {
                    throw new ArgumentsRequired($this->id . ' cancelOrder() requires a $symbol argument for spot orders');
                }
            }
        } else {
            $market = $this->market($symbol);
            $type = $market['type'];
        }
        $query = $this->omit($params, 'type');
        $method = null;
        $request = array();
        if ($type === 'spot') {
            $method = 'apiPostOrderOrdersOrderIdSubmitcancel';
            $request['order_id'] = $id;
            $request['method'] = 'submitcancel';
        } else if ($type === 'swap') {
            $method = 'swapPostOrderCancelOrder';
            $request['orderId'] = $id;
            $request['symbol'] = $market['id'];
        }
        $response = $this->$method (array_merge($request, $query));
        //
        // spot
        //
        //     array( "status" => "ok", "ts" => 1595818631279, "data" => 671368296142774272 )
        //
        // swap
        //
        //     {
        //         "order_id":"671757564085534713",
        //         "client_oid":"58775e54-0592-491c-97e8-e2369025f2d1",
        //         "$symbol":"cmt_ethusdt",
        //         "result":true,
        //         "err_code":null,
        //         "err_msg":null
        //     }
        //
        return $this->parse_order($response, $market);
    }

    public function cancel_orders($ids, $symbol = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' cancelOrders() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $type = $this->safe_string($params, 'type', $market['type']);
        if ($type === null) {
            throw new ArgumentsRequired($this->id . " cancelOrders() requires a $type parameter (one of 'spot', 'swap').");
        }
        $params = $this->omit($params, 'type');
        $request = array();
        $method = null;
        if ($type === 'spot') {
            $method = 'apiPostOrderOrdersBatchcancel';
            $request['method'] = 'batchcancel';
            $jsonIds = $this->json($ids);
            $parts = explode('"', $jsonIds);
            $request['order_ids'] = implode('', $parts);
        } else if ($type === 'swap') {
            $method = 'swapPostOrderCancelBatchOrders';
            $request['symbol'] = $market['id'];
            $request['ids'] = $ids;
        }
        $response = $this->$method (array_merge($request, $params));
        //
        //     spot
        //
        //     {
        //         "status" => "ok",
        //         "data" => {
        //             "success" => array(
        //                 "673451224205135872",
        //             ),
        //             "failed" => array(
        //                 {
        //                 "err-msg" => "invalid record",
        //                 "order-id" => "673451224205135873",
        //                 "err-code" => "base record invalid"
        //                 }
        //             )
        //         }
        //     }
        //
        //     swap
        //
        //     {
        //         "result":true,
        //         "$symbol":"cmt_btcusdt",
        //         "order_ids":array(
        //             "258414711",
        //             "478585558"
        //         ),
        //         "fail_infos":array(
        //             {
        //                 "order_id":"258414711",
        //                 "err_code":"401",
        //                 "err_msg":""
        //             }
        //         )
        //     }
        //
        return $response;
    }

    public function fetch_order($id, $symbol = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchOrder() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $type = $this->safe_string($params, 'type', $market['type']);
        if ($type === null) {
            throw new ArgumentsRequired($this->id . " fetchOrder() requires a $type parameter (one of 'spot', 'swap').");
        }
        $method = null;
        $request = array();
        if ($type === 'spot') {
            $clientOid = $this->safe_string($params, 'client_oid');
            if ($clientOid !== null) {
                $method = 'apiPostOrderOrdersClientOid';
                $request['client_oid'] = $clientOid;
            } else {
                $method = 'apiPostOrderOrdersOrderId';
                $request['order_id'] = $id;
            }
            $request['method'] = 'getOrder';
        } else if ($type === 'swap') {
            $method = 'swapGetOrderDetail';
            $request['symbol'] = $market['id'];
            $request['orderId'] = $id;
        }
        $query = $this->omit($params, 'type');
        $response = $this->$method (array_merge($request, $query));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ts":1595897886717,
        //         "$data":{
        //             "account_id":"7420922606",
        //             "amount":"0.1000000000000000",
        //             "canceled_at":"1595818631541",
        //             "created_at":"1595792595897",
        //             "filled_amount":"0.000000000000",
        //             "filled_cash_amount":"0.000000000000",
        //             "filled_fees":"0.000000000000",
        //             "finished_at":"1595818631541",
        //             "$id":"671368296142774272",
        //             "price":"150.000000000000",
        //             "source":"接口",
        //             "state":"canceled",
        //             "$symbol":"eth_usdt",
        //             "$type":"buy-limit"
        //         }
        //     }
        //
        //
        // swap
        //
        //     {
        //         "$symbol":"cmt_ethusdt",
        //         "size":"1",
        //         "timestamp":"1595896459890",
        //         "client_oid":"58775e54-0592-491c-97e8-e2369025f2d1",
        //         "createTime":"1595885404607",
        //         "filled_qty":"0",
        //         "fee":"0",
        //         "order_id":"671757564085534713",
        //         "price":"150",
        //         "price_avg":"0",
        //         "status":"-1",
        //         "$type":"1",
        //         "order_type":"0",
        //         "totalProfits":"0"
        //     }
        //
        $data = $this->safe_value($response, 'data', $response);
        return $this->parse_order($data, $market);
    }

    public function fetch_open_orders($symbol = null, $since = null, $limit = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchOpenOrders() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $type = $this->safe_string($params, 'type', $market['type']);
        $request = array(
            'symbol' => $market['id'],
        );
        $method = null;
        if ($type === 'spot') {
            $method = 'apiGetOrderOrdersOpenOrders';
            // $request['from'] = $this->safe_string($params, 'from'); // order id
            // $request['direct'] = 'next'; // or 'prev'
            $request['method'] = 'openOrders';
            if ($limit === null) {
                $request['size'] = $limit; // default 100, max 1000
            }
        } else if ($type === 'swap') {
            $method = 'swapGetOrderOrders';
            $request['status'] = '3'; // 0 Failed, 1 Partially Filled, 2 Fully Filled 3 = Open . Partially Filled, 4 Canceling
            $request['from'] = '1';
            $request['to'] = '1';
            if ($limit === null) {
                $request['limit'] = 100; // default 100, max 100
            }
        }
        $query = $this->omit($params, 'type');
        $response = $this->$method (array_merge($request, $query));
        //
        //  spot
        //
        //
        //     {
        //         "status":"ok",
        //         "ts":1595875165865,
        //         "$data":array(
        //             {
        //                 "account_id":"7420922606",
        //                 "amount":"0.1000000000000000",
        //                 "canceled_at":"1595872129618",
        //                 "created_at":"1595872089525",
        //                 "filled_amount":"0.000000000000",
        //                 "filled_cash_amount":"0.000000000000",
        //                 "filled_fees":"0.000000000000",
        //                 "finished_at":"1595872129618",
        //                 "id":"671701716584665088",
        //                 "price":"150.000000000000",
        //                 "source":"接口",
        //                 "state":"canceled",
        //                 "$symbol":"eth_usdt",
        //                 "$type":"buy-$limit"
        //             }
        //         )
        //     }
        //
        // swap
        //
        //     array(
        //         {
        //             "$symbol":"cmt_ethusdt",
        //             "size":"1",
        //             "timestamp":"1595885546770",
        //             "client_oid":"f3aa81d6-9a4c-4eab-bebe-ebc19da21cf2",
        //             "createTime":"1595885521200",
        //             "filled_qty":"0",
        //             "fee":"0.00000000",
        //             "order_id":"671758053112020913",
        //             "price":"150.00",
        //             "price_avg":"0.00",
        //             "status":"0",
        //             "$type":"1",
        //             "order_type":"0",
        //             "totalProfits":null
        //         }
        //     )
        //
        $data = $response;
        if (gettype($response) === 'array' && count(array_filter(array_keys($response), 'is_string')) != 0) {
            $data = $this->safe_value($response, 'data', array());
        }
        return $this->parse_orders($data, $market, null, $limit);
    }

    public function fetch_closed_orders($symbol = null, $since = null, $limit = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchClosedOrders() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $type = $this->safe_string($params, 'type', $market['type']);
        $request = array(
            'symbol' => $market['id'],
        );
        $method = null;
        if ($type === 'spot') {
            $method = 'apiGetOrderOrdersHistory';
            // Value range [((end_time) – 48h), (end_time)]
            // the $query window is 48 hours at most
            // the window shift range is the last 30 days
            if ($since !== null) {
                $request['start_time'] = $since;
            }
            // $request['end_time'] = $this->safe_integer($params, 'end_time');
            // $request['from'] = $this->safe_string($params, 'from'); // order id
            // $request['direct'] = 'next'; // or 'prev'
            $request['method'] = 'openOrders';
            if ($limit === null) {
                $request['size'] = $limit; // default 100, max 1000
            }
        } else if ($type === 'swap') {
            $method = 'swapGetOrderOrders';
            $request['status'] = '2'; // 0 Failed, 1 Partially Filled, 2 Fully Filled 3 = Open . Partially Filled, 4 Canceling
            $request['from'] = '1';
            $request['to'] = '1';
            if ($limit === null) {
                $request['limit'] = 100; // default 100, max 100
            }
        }
        $query = $this->omit($params, 'type');
        $response = $this->$method (array_merge($request, $query));
        //
        //  spot
        //
        //
        //     {
        //         "status":"ok",
        //         "ts":1595875165865,
        //         "$data":array(
        //             {
        //                 "account_id":"7420922606",
        //                 "amount":"0.1000000000000000",
        //                 "canceled_at":"1595872129618",
        //                 "created_at":"1595872089525",
        //                 "filled_amount":"0.000000000000",
        //                 "filled_cash_amount":"0.000000000000",
        //                 "filled_fees":"0.000000000000",
        //                 "finished_at":"1595872129618",
        //                 "id":"671701716584665088",
        //                 "price":"150.000000000000",
        //                 "source":"接口",
        //                 "state":"canceled",
        //                 "$symbol":"eth_usdt",
        //                 "$type":"buy-$limit"
        //             }
        //         )
        //     }
        //
        // swap
        //
        //     array(
        //         {
        //             "$symbol":"cmt_ethusdt",
        //             "size":"1",
        //             "timestamp":"1595885546770",
        //             "client_oid":"f3aa81d6-9a4c-4eab-bebe-ebc19da21cf2",
        //             "createTime":"1595885521200",
        //             "filled_qty":"0",
        //             "fee":"0.00000000",
        //             "order_id":"671758053112020913",
        //             "price":"150.00",
        //             "price_avg":"0.00",
        //             "status":"0",
        //             "$type":"1",
        //             "order_type":"0",
        //             "totalProfits":null
        //         }
        //     )
        //
        $data = $response;
        if (gettype($response) === 'array' && count(array_filter(array_keys($response), 'is_string')) != 0) {
            $data = $this->safe_value($response, 'data', array());
        }
        return $this->parse_orders($data, $market, null, $limit);
    }

    public function fetch_deposits($code = null, $since = null, $limit = null, $params = array ()) {
        if ($code === null) {
            throw new ArgumentsRequired($this->id . ' fetchDeposits() requires a $currency $code argument');
        }
        $this->load_markets();
        $currency = $this->currency($code);
        $request = array(
            'currency' => $currency['id'],
            'method' => 'deposit_withdraw',
            'type' => 'deposit',
            'size' => 12,
        );
        $response = $this->apiGetOrderDepositWithdraw (array_merge($request, $params));
        //
        //     {
        //         "status" => "ok",
        //         "$data" => array(
        //             array(
        //                 "id" => 1171,
        //                 "type" => "deposit",
        //                 "$currency" => "usdt",
        //                 "tx_hash" => "ed03094b84eafbe4bc16e7ef766ee959885ee5bcb265872baaa9c64e1cf86c2b",
        //                 "amount" => 7.457467,
        //                 "address" => "rae93V8d2mdoUQHwBDBdM4NHCMehRJAsbm",
        //                 "address_tag" => "100040",
        //                 "fee" => 0,
        //                 "state" => "safe",
        //                 "created_at" => 1510912472199,
        //                 "updated_at" => 1511145876575
        //             ),
        //         )
        //     }
        //
        $data = $this->safe_value($response, 'data', array());
        return $this->parse_transactions($data, $currency, $since, $limit, $params);
    }

    public function fetch_withdrawals($code = null, $since = null, $limit = null, $params = array ()) {
        if ($code === null) {
            throw new ArgumentsRequired($this->id . ' fetchWithdrawals() requires a $currency $code argument');
        }
        $this->load_markets();
        $currency = $this->currency($code);
        $request = array(
            'currency' => $currency['id'],
            'method' => 'deposit_withdraw',
            'type' => 'withdraw',
            'size' => 12,
        );
        $response = $this->apiGetOrderDepositWithdraw (array_merge($request, $params));
        //
        //     {
        //         "status" => "ok",
        //         "$data" => array(
        //             array(
        //                 "id" => 1171,
        //                 "type" => "withdraw",
        //                 "$currency" => "usdt",
        //                 "tx_hash" => "ed03094b84eafbe4bc16e7ef766ee959885ee5bcb265872baaa9c64e1cf86c2b",
        //                 "amount" => 7.457467,
        //                 "address" => "rae93V8d2mdoUQHwBDBdM4NHCMehRJAsbm",
        //                 "address_tag" => "100040",
        //                 "fee" => 0,
        //                 "state" => "safe",
        //                 "created_at" => 1510912472199,
        //                 "updated_at" => 1511145876575
        //             ),
        //         )
        //     }
        //
        $data = $this->safe_value($response, 'data', array());
        return $this->parse_transactions($data, $currency, $since, $limit, $params);
    }

    public function parse_transaction_status($status) {
        $statuses = array(
            // withdrawals
            'WaitForOperation' => 'pending', // 等待提现
            'OperationLock' => 'pending', // 初审锁定成功
            'OperationSuccess' => 'ok', // 提现成功
            'Cancel' => 'canceled', // 用户撤销
            'Sure' => 'ok', // 复审锁定成功
            'Fail' => 'failed', // 出币异常
            'WaitForChainSure' => 'ok', // 等待链上确认
            // deposits
            'WAIT_0' => 'pending', // 待确认
            'WAIT_1' => 'pending', // 待确认
            'DATA_CHANGE' => 'pending', // 待确认中
            'SUCCESS' => 'ok', // 充值成功
        );
        return $this->safe_string($statuses, $status, $status);
    }

    public function parse_transaction($transaction, $currency = null) {
        //
        // fetchDeposits, fetchWithdrawals
        //
        //     {
        //         "$id" => 1171,
        //         "$type" => "withdraw",
        //         "$currency" => "usdt",
        //         "tx_hash" => "ed03094b84eafbe4bc16e7ef766ee959885ee5bcb265872baaa9c64e1cf86c2b",
        //         "$amount" => 7.457467,
        //         "$address" => "rae93V8d2mdoUQHwBDBdM4NHCMehRJAsbm",
        //         "address_tag" => "100040",
        //         "$fee" => 0,
        //         "state" => "safe",
        //         "created_at" => 1510912472199,
        //         "updated_at" => 1511145876575
        //     }
        //
        $id = $this->safe_string($transaction, 'id');
        $address = $this->safe_string($transaction, 'address');
        $tag = $this->safe_string($transaction, 'address_tag');
        $tagFrom = null;
        $tagTo = $tag;
        $addressFrom = null;
        $addressTo = $address;
        $type = $this->safe_string($transaction, 'type');
        if ($type === 'withdraw') {
            $type = 'withdrawal';
        } else if ($type === 'deposit') {
            $type = 'deposit';
        }
        $currencyId = $this->safe_string($transaction, 'currency');
        $code = $this->safe_currency_code($currencyId);
        $amount = $this->safe_float($transaction, 'amount');
        $status = $this->parse_transaction_status($this->safe_string($transaction, 'state'));
        $txid = $this->safe_string($transaction, 'tx_hash');
        $timestamp = $this->safe_integer($transaction, 'created_at');
        $updated = $this->safe_integer($transaction, 'updated_at');
        $feeCost = $this->safe_float($transaction, 'fee');
        $fee = null;
        if ($feeCost !== null) {
            $fee = array(
                'currency' => $code,
                'cost' => $feeCost,
            );
        }
        return array(
            'info' => $transaction,
            'id' => $id,
            'currency' => $code,
            'amount' => $amount,
            'addressFrom' => $addressFrom,
            'addressTo' => $addressTo,
            'address' => $address,
            'tagFrom' => $tagFrom,
            'tagTo' => $tagTo,
            'tag' => $tag,
            'status' => $status,
            'type' => $type,
            'updated' => $updated,
            'txid' => $txid,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601($timestamp),
            'fee' => $fee,
        );
    }

    public function fetch_my_trades($symbol = null, $since = null, $limit = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchMyTrades() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $type = $this->safe_string($params, 'type', $market['type']);
        $query = $this->omit($params, 'type');
        if ($type === 'swap') {
            throw new ArgumentsRequired($this->id . ' fetchMyTrades() is not supported for ' . $type . ' type');
        }
        //
        // spot
        //
        //     POST /api/v1/order/matchresults Query current order, order history
        //     $symbol true string trading pair  btc_usdt, eth_btc ...
        //     types false string Query order $type combination  buy-$market, sell-$market, buy-$limit, sell-$limit
        //     start_date false string Query start date, date format yyyy-mm-dd -61 days [-61day, $end-date]
        //     end_date false string Query $end date, date format yyyy-mm-dd Now [start-date, now]
        //     from false string Query start ID order record id
        //     direct false string Query direction ‘next’ is default , the transaction record ID is sorted from large to small prev，next
        //     size false string Query record size 100 <=100
        //
        $request = array(
            'symbol' => $market['id'],
            'method' => 'matchresults',
            // 'types' => 'buy-$market,sell-$market,buy-$limit,sell-limit',
            // 'start_date' => $this->ymd($since),
            // 'end_date' => $this->ymd($this->milliseconds()),
            // 'size' => 100,
            // 'direct' => 'next',
        );
        if ($since !== null) {
            $request['start_date'] = $this->ymd($since);
            $end = $this->sum($since, 2 * 24 * 60 * 60 * 1000);
            $request['end_date'] = $this->ymd($end);
        }
        if ($limit !== null) {
            $request['size'] = $limit; // default 100, max 100
        }
        $response = $this->apiPostOrderMatchresults (array_merge($request, $query));
        //
        //     {
        //         "status" => "ok",
        //         "$data" => array(
        //             {
        //                 "id" => 29555,
        //                 "order_id" => 59378,
        //                 "match_id" => 59335,
        //                 "$symbol" => "eth_usdt",
        //                 "$type" => "buy-$limit",
        //                 "source" => "api",
        //                 "price" => "100.1000000000",
        //                 "filled_amount" => "0.9845000000",
        //                 "filled_fees" => "0.0019690000",
        //                 "created_at" => 1494901400487
        //             }
        //         )
        //     }
        //
        $data = $this->safe_value($response, 'data', array());
        return $this->parse_trades($data, $market, $since, $limit);
    }

    public function fetch_order_trades($id, $symbol = null, $since = null, $limit = null, $params = array ()) {
        if ($symbol === null) {
            throw new ArgumentsRequired($this->id . ' fetchOrderTrades() requires a $symbol argument');
        }
        $this->load_markets();
        $market = $this->market($symbol);
        $type = $this->safe_string($params, 'type', $market['type']);
        $params = $this->omit($params, 'type');
        $method = null;
        $request = array();
        if ($type === 'spot') {
            $request['order_id'] = $id;
            $request['method'] = 'matchresults';
            $method = 'apiPostOrderOrdersOrderIdMatchresults';
        } else if ($type === 'swap') {
            $request['orderId'] = $id;
            $request['symbol'] = $market['id'];
            $method = 'swapGetOrderFills';
        }
        $response = $this->$method (array_merge($request, $params));
        //
        // spot
        //
        //     {
        //         "status":"ok",
        //         "ts":1596298917277,
        //         "$data":array(
        //             {
        //                 "$id":"614164775",
        //                 "created_at":"1596298860602",
        //                 "filled_amount":"0.0417000000000000",
        //                 "filled_fees":"0.0000834000000000",
        //                 "match_id":"673491702661292033",
        //                 "order_id":"673491720340279296",
        //                 "price":"359.240000000000",
        //                 "source":"接口",
        //                 "$symbol":"eth_usdt",
        //                 "$type":"buy-$market"
        //             }
        //         )
        //     }
        //
        // swap
        //
        //
        //     array(
        //         {
        //             "trade_id":"6667390",
        //             "$symbol":"cmt_btcusdt",
        //             "order_id":"525946425993854915",
        //             "price":"9839.00",
        //             "order_qty":"3466",
        //             "fee":"-0.0000528407360000",
        //             "timestamp":"1561121514442",
        //             "exec_type":"M",
        //             "side":"3"
        //         }
        //     )
        //
        $data = $response;
        if (gettype($data) === 'array' && count(array_filter(array_keys($data), 'is_string')) != 0) {
            $data = $this->safe_value($response, 'data', array());
        }
        return $this->parse_trades($data, $market, $since, $limit);
    }

    public function fetch_position($symbol, $params = array ()) {
        $this->load_markets();
        $market = $this->market($symbol);
        $request = array(
            'symbol' => $market['id'],
        );
        $response = $this->swapGetPositionSinglePosition (array_merge($request, $params));
        //
        //     {
        //         "margin_mode":"fixed", // Margin mode => crossed / fixed
        //         "holding":array(
        //             {
        //                 "$symbol":"cmt_btcusdt", // Contract name
        //                 "liquidation_price":"0.00", // Estimated liquidation price
        //                 "position":"0", // Position Margin, the margin for holding current positions
        //                 "avail_position":"0", // Available position
        //                 "avg_cost":"0.00", // Transaction average price
        //                 "leverage":"2", // Leverage
        //                 "realized_pnl":"0.00000000", // Realized Profit and loss
        //                 "keepMarginRate":"0.005", // Maintenance margin rate
        //                 "side":"1", // Position Direction Long or short, Mark obsolete
        //                 "holdSide":"1", // Position Direction Long or short
        //                 "timestamp":"1557571623963", // System timestamp
        //                 "margin":"0.0000000000000000", // Used margin
        //                 "unrealized_pnl":"0.00000000", // Unrealized profit and loss
        //             }
        //         )
        //     }
        return $response;
    }

    public function fetch_positions($symbols = null, $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $response = $this->swapGetPositionAllPosition ($params);
        //
        //     array(
        //         array(
        //             "margin_mode":"fixed",
        //             "holding":array(
        //                 array(
        //                     "liquidation_price":"0.00",
        //                     "position":"0",
        //                     "avail_position":"0",
        //                     "avg_cost":"0.00",
        //                     "symbol":"btcusd",
        //                     "leverage":"20",
        //                     "keepMarginRate":"0.005",
        //                     "realized_pnl":"0.00000000",
        //                     "unrealized_pnl":"0",
        //                     "side":"long",
        //                     "holdSide":"1",
        //                     "timestamp":"1595698564915",
        //                     "margin":"0.0000000000000000"
        //                 ),
        //             )
        //         ),
        //     )
        //
        // todo unify parsePosition/parsePositions
        return $response;
    }

    public function sign($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $request = '/' . $this->implode_params($path, $params);
        if (($api === 'capi') || ($api === 'swap')) {
            $request = '/api/swap/' . $this->version . $request;
        } else {
            $request = '/' . $api . '/v1' . $request;
        }
        $query = $this->omit($params, $this->extract_params($path));
        $url = $this->implode_params($this->urls['api'][$api], array( 'hostname' => $this->hostname )) . $request;
        if (($api === 'data') || ($api === 'capi')) {
            if ($query) {
                $url .= '?' . $this->urlencode($query);
            }
        } else if ($api === 'swap') {
            $this->check_required_credentials();
            $timestamp = (string) $this->milliseconds();
            $auth = $timestamp . $method . $request;
            if ($method === 'POST') {
                $body = $this->json($params);
                $auth .= $body;
            } else {
                if ($params) {
                    $query = $this->urlencode($this->keysort($params));
                    $url .= '?' . $query;
                    $auth .= '?' . $query;
                }
            }
            $signature = $this->hmac($this->encode($auth), $this->encode($this->secret), 'sha256', 'base64');
            $headers = array(
                'ACCESS-KEY' => $this->apiKey,
                'ACCESS-SIGN' => $signature,
                'ACCESS-TIMESTAMP' => $timestamp,
                'ACCESS-PASSPHRASE' => $this->password,
            );
            if ($method === 'POST') {
                $headers['Content-Type'] = 'application/json';
            }
        } else if ($api === 'api') {
            $timestamp = (string) $this->milliseconds();
            $auth = '';
            $query = $this->keysort($query);
            $auth = $this->rawencode($query);
            $hash = $this->hash($this->encode($this->secret), 'sha1');
            $signed = $auth;
            $signature = $this->hmac($this->encode($auth), $this->encode($hash), 'md5');
            if (strlen($auth) > 0) {
                $signed .= '&';
            }
            $signed .= 'sign=' . $signature . '&req_time=' . $timestamp . '&accesskey=' . $this->apiKey;
            if ($method === 'GET') {
                if ($query) {
                    $url .= '?' . $signed;
                }
            } else if ($method === 'POST') {
                $url .= '?sign=' . $signature . '&req_time=' . $timestamp . '&accesskey=' . $this->apiKey;
                $body = $auth;
                $headers = array(
                    'Content-Type' => 'application/x-www-form-urlencoded',
                );
            }
        }
        return array( 'url' => $url, 'method' => $method, 'body' => $body, 'headers' => $headers );
    }

    public function handle_errors($code, $reason, $url, $method, $headers, $body, $response, $requestHeaders, $requestBody) {
        if (!$response) {
            return; // fallback to default error handler
        }
        //
        // spot
        //
        //     array("status":"fail","err_code":"01001","err_msg":"系统异常，请稍后重试")
        //     array("status":"error","ts":1595594160149,"err_code":"invalid-parameter","err_msg":"invalid size, valid range => [1,2000]")
        //     array("status":"error","ts":1595684716042,"err_code":"invalid-parameter","err_msg":"illegal sign invalid")
        //     array("status":"error","ts":1595700216275,"err_code":"bad-request","err_msg":"your balance is low!")
        //     array("status":"error","ts":1595700344504,"err_code":"invalid-parameter","err_msg":"invalid type")
        //     array("status":"error","ts":1595703343035,"err_code":"bad-request","err_msg":"order cancel fail")
        //     array("status":"error","ts":1595704360508,"err_code":"invalid-parameter","err_msg":"accesskey not null")
        //     array("status":"error","ts":1595704490084,"err_code":"invalid-parameter","err_msg":"permissions not right")
        //     array("status":"error","ts":1595711862763,"err_code":"system exception","err_msg":"system exception")
        //     array("status":"error","ts":1595730308979,"err_code":"bad-request","err_msg":"20003")
        //
        // swap
        //
        //     array("$code":"40015","msg":"","requestTime":1595698564931,"data":null)
        //     array("$code":"40017","msg":"Order id must not be blank","requestTime":1595702477835,"data":null)
        //     array("$code":"40017","msg":"Order Type must not be blank","requestTime":1595698516162,"data":null)
        //     array("$code":"40301","msg":"","requestTime":1595667662503,"data":null)
        //     array("$code":"40017","msg":"Contract $code must not be blank","requestTime":1595703151651,"data":null)
        //     array("$code":"40108","msg":"","requestTime":1595885064600,"data":null)
        //     array("order_id":"513468410013679613","client_oid":null,"symbol":"ethusd","result":false,"err_code":"order_no_exist_error","err_msg":"订单不存在！")
        //
        $message = $this->safe_string($response, 'err_msg');
        $errorCode = $this->safe_string_2($response, 'code', 'err_code');
        $feedback = $this->id . ' ' . $body;
        $nonEmptyMessage = (($message !== null) && ($message !== ''));
        if ($nonEmptyMessage) {
            $this->throw_exactly_matched_exception($this->exceptions['exact'], $message, $feedback);
            $this->throw_broadly_matched_exception($this->exceptions['broad'], $message, $feedback);
        }
        $nonZeroErrorCode = ($errorCode !== null) && ($errorCode !== '00000');
        if ($nonZeroErrorCode) {
            $this->throw_exactly_matched_exception($this->exceptions['exact'], $errorCode, $feedback);
        }
        if ($nonZeroErrorCode || $nonEmptyMessage) {
            throw new ExchangeError($feedback); // unknown $message
        }
    }
}
