# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
from ccxt.base.errors import AuthenticationError
from ccxt.base.errors import ArgumentsRequired
from ccxt.base.errors import BadRequest
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import OrderNotFound
from ccxt.base.errors import NetworkError
from ccxt.base.decimal_to_precision import TICK_SIZE


class hollaex(Exchange):

    def describe(self):
        return self.deep_extend(super(hollaex, self).describe(), {
            'id': 'hollaex',
            'name': 'HollaEx',
            'countries': ['KR'],
            'rateLimit': 333,
            'version': 'v1',
            'has': {
                'CORS': False,
                'fetchMarkets': True,
                'fetchCurrencies': True,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchOrderBook': True,
                'fetchOrderBooks': True,
                'fetchTrades': True,
                'fetchOHLCV': True,
                'fetchBalance': True,
                'createOrder': True,
                'createLimitBuyOrder': True,
                'createLimitSellOrder': True,
                'createMarketBuyOrder': True,
                'createMarketSellOrder': True,
                'cancelOrder': True,
                'cancelAllOrders': True,
                'fetchOpenOrders': True,
                'fetchClosedOrders': False,
                'fetchOpenOrder': True,
                'fetchOrder': False,
                'fetchDeposits': True,
                'fetchWithdrawals': True,
                'fetchTransactions': False,
                'fetchOrders': False,
                'fetchMyTrades': True,
                'withdraw': True,
                'fetchDepositAddress': True,
            },
            'timeframes': {
                '1h': '1h',
                '1d': '1d',
            },
            'urls': {
                'logo': 'https://user-images.githubusercontent.com/1294454/75841031-ca375180-5ddd-11ea-8417-b975674c23cb.jpg',
                'api': 'https://api.hollaex.com',
                'www': 'https://hollaex.com',
                'doc': 'https://apidocs.hollaex.com',
                'referral': 'https://pro.hollaex.com/signup?affiliation_code=QSWA6G',
            },
            'precisionMode': TICK_SIZE,
            'requiredCredentials': {
                'apiKey': True,
                'secret': True,
            },
            'api': {
                'public': {
                    'get': [
                        'health',
                        'constant',
                        'ticker',
                        'ticker/all',
                        'orderbooks',
                        'trades',
                        'chart',
                        # TradingView data
                        'udf/config',
                        'udf/history',
                        'udf/symbols',
                    ],
                },
                'private': {
                    'get': [
                        'user',
                        'user/balance',
                        'user/trades',
                        'user/orders',
                        'user/orders/{order_id}',
                        'user/deposits',
                        'user/withdrawals',
                        'user/withdraw/{currency}/fee',
                    ],
                    'post': [
                        'user/request-withdrawal',
                        'order',
                    ],
                    'delete': [
                        'user/orders',
                        'user/orders/{order_id}',
                    ],
                },
            },
            'fees': {
                'trading': {
                    'tierBased': True,
                    'percentage': True,
                },
            },
            'exceptions': {
                'broad': {
                    'Invalid token': AuthenticationError,
                    'Order not found': OrderNotFound,
                    'Insufficient balance': InsufficientFunds,
                },
                'exact': {
                    '400': BadRequest,
                    '403': AuthenticationError,
                    '404': BadRequest,
                    '405': BadRequest,
                    '410': BadRequest,
                    '429': BadRequest,
                    '500': NetworkError,
                    '503': NetworkError,
                },
            },
            'options': {
                # how many seconds before the authenticated request expires
                'api-expires': int(self.timeout / 1000),
            },
        })

    def fetch_markets(self, params={}):
        response = self.publicGetConstant(params)
        #
        #     {
        #         coins: {
        #             xmr: {
        #                 id: 7,
        #                 fullname: "Monero",
        #                 symbol: "xmr",
        #                 active: True,
        #                 allow_deposit: True,
        #                 allow_withdrawal: True,
        #                 withdrawal_fee: 0.02,
        #                 min: 0.001,
        #                 max: 100000,
        #                 increment_unit: 0.001,
        #                 deposit_limits: {'1': 0, '2': 0, '3': 0, '4': 0, '5': 0, '6': 0},
        #                 withdrawal_limits: {'1': 10, '2': 15, '3': 100, '4': 100, '5': 200, '6': 300, '7': 350, '8': 400, '9': 500, '10': -1},
        #                 created_at: "2019-12-09T07:14:02.720Z",
        #                 updated_at: "2020-01-16T12:12:53.162Z"
        #             },
        #             # ...
        #         },
        #         pairs: {
        #             'btc-usdt': {
        #                 id: 2,
        #                 name: "btc-usdt",
        #                 pair_base: "btc",
        #                 pair_2: "usdt",
        #                 taker_fees: {'1': 0.3, '2': 0.25, '3': 0.2, '4': 0.18, '5': 0.1, '6': 0.09, '7': 0.08, '8': 0.06, '9': 0.04, '10': 0},
        #                 maker_fees: {'1': 0.1, '2': 0.08, '3': 0.05, '4': 0.03, '5': 0, '6': 0, '7': 0, '8': 0, '9': 0, '10': 0},
        #                 min_size: 0.0001,
        #                 max_size: 1000,
        #                 min_price: 100,
        #                 max_price: 100000,
        #                 increment_size: 0.0001,
        #                 increment_price: 0.05,
        #                 active: True,
        #                 created_at: "2019-12-09T07:15:54.537Z",
        #                 updated_at: "2019-12-09T07:15:54.537Z"
        #             },
        #         },
        #         config: {tiers: 10},
        #         status: True
        #     }
        #
        pairs = self.safe_value(response, 'pairs', {})
        keys = list(pairs.keys())
        result = []
        for i in range(0, len(keys)):
            key = keys[i]
            market = pairs[key]
            id = self.safe_string(market, 'name')
            baseId = self.safe_string(market, 'pair_base')
            quoteId = self.safe_string(market, 'pair_2')
            base = self.common_currency_code(baseId.upper())
            quote = self.common_currency_code(quoteId.upper())
            symbol = base + '/' + quote
            active = self.safe_value(market, 'active')
            result.append({
                'id': id,
                'symbol': symbol,
                'base': base,
                'quote': quote,
                'baseId': baseId,
                'quoteId': quoteId,
                'active': active,
                'precision': {
                    'price': self.safe_float(market, 'increment_price'),
                    'amount': self.safe_float(market, 'increment_size'),
                },
                'limits': {
                    'amount': {
                        'min': self.safe_float(market, 'min_size'),
                        'max': self.safe_float(market, 'max_size'),
                    },
                    'price': {
                        'min': self.safe_float(market, 'min_price'),
                        'max': self.safe_float(market, 'max_price'),
                    },
                    'cost': {'min': None, 'max': None},
                },
                'info': market,
            })
        return result

    def fetch_currencies(self, params={}):
        response = self.publicGetConstant(params)
        coins = self.safe_value(response, 'coins', {})
        keys = list(coins.keys())
        result = {}
        for i in range(0, len(keys)):
            key = keys[i]
            currency = coins[key]
            id = self.safe_string(currency, 'symbol')
            numericId = self.safe_integer(currency, 'id')
            code = self.safe_currency_code(id)
            name = self.safe_string(currency, 'fullname')
            active = self.safe_value(currency, 'active')
            fee = self.safe_float(currency, 'withdrawal_fee')
            precision = self.safe_float(currency, 'increment_unit')
            withdrawalLimits = self.safe_value(currency, 'withdrawal_limits', [])
            result[code] = {
                'id': id,
                'numericId': numericId,
                'code': code,
                'info': currency,
                'name': name,
                'active': active,
                'fee': fee,
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': self.safe_float(currency, 'min'),
                        'max': self.safe_float(currency, 'max'),
                    },
                    'price': {
                        'min': None,
                        'max': None,
                    },
                    'cost': {
                        'min': None,
                        'max': None,
                    },
                    'withdraw': {
                        'min': None,
                        'max': self.safe_value(withdrawalLimits, 0),
                    },
                },
            }
        return result

    def fetch_order_books(self, symbols=None, limit=None, params={}):
        self.load_markets()
        response = self.publicGetOrderbooks(params)
        result = {}
        marketIds = list(response.keys())
        for i in range(0, len(marketIds)):
            marketId = marketIds[i]
            orderbook = response[marketId]
            symbol = self.safe_symbol(marketId, None, '-')
            timestamp = self.parse8601(self.safe_string(orderbook, 'timestamp'))
            result[symbol] = self.parse_order_book(response[marketId], timestamp)
        return result

    def fetch_order_book(self, symbol, limit=None, params={}):
        self.load_markets()
        marketId = self.market_id(symbol)
        request = {
            'symbol': marketId,
        }
        response = self.publicGetOrderbooks(self.extend(request, params))
        #
        #     {
        #         "btc-usdt": {
        #             "bids": [
        #                 [8836.4, 1.022],
        #                 [8800, 0.0668],
        #                 [8797.75, 0.2398],
        #             ],
        #             "asks": [
        #                 [8839.35, 1.5334],
        #                 [8852.6, 0.0579],
        #                 [8860.45, 0.1815],
        #             ],
        #             "timestamp": "2020-03-03T02:27:25.147Z"
        #         },
        #         "eth-usdt": {},
        #         # ...
        #     }
        #
        orderbook = self.safe_value(response, marketId)
        timestamp = self.parse8601(self.safe_string(orderbook, 'timestamp'))
        return self.parse_order_book(orderbook, timestamp)

    def fetch_ticker(self, symbol, params={}):
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        response = self.publicGetTicker(self.extend(request, params))
        #
        #     {
        #         open: 8615.55,
        #         close: 8841.05,
        #         high: 8921.1,
        #         low: 8607,
        #         last: 8841.05,
        #         volume: 20.2802,
        #         timestamp: '2020-03-03T03:11:18.964Z'
        #     }
        #
        return self.parse_ticker(response, market)

    def fetch_tickers(self, symbols=None, params={}):
        self.load_markets()
        response = self.publicGetTickerAll(self.extend(params))
        #
        #     {
        #         "bch-usdt": {
        #             "time": "2020-03-02T04:29:45.011Z",
        #             "open": 341.65,
        #             "close":337.9,
        #             "high":341.65,
        #             "low":337.3,
        #             "last":337.9,
        #             "volume":0.054,
        #             "symbol":"bch-usdt"
        #         },
        #         # ...
        #     }
        #
        return self.parse_tickers(response, symbols)

    def parse_tickers(self, response, symbols=None):
        result = {}
        keys = list(response.keys())
        for i in range(0, len(keys)):
            key = keys[i]
            ticker = response[key]
            marketId = self.safe_string(ticker, 'symbol', key)
            market = self.safe_market(marketId, None, '-')
            symbol = market['symbol']
            result[symbol] = self.parse_ticker(ticker, market)
        return self.filter_by_array(result, 'symbol', symbols)

    def parse_ticker(self, ticker, market=None):
        #
        # fetchTicker
        #
        #     {
        #         open: 8615.55,
        #         close: 8841.05,
        #         high: 8921.1,
        #         low: 8607,
        #         last: 8841.05,
        #         volume: 20.2802,
        #         timestamp: '2020-03-03T03:11:18.964Z',
        #     }
        #
        # fetchTickers
        #
        #     {
        #         "time": "2020-03-02T04:29:45.011Z",
        #         "open": 341.65,
        #         "close": 337.9,
        #         "high": 341.65,
        #         "low": 337.3,
        #         "last": 337.9,
        #         "volume": 0.054,
        #         "symbol": "bch-usdt"
        #     }
        #
        marketId = self.safe_string(ticker, 'symbol')
        symbol = self.safe_symbol(marketId, market, '-')
        timestamp = self.parse8601(self.safe_string_2(ticker, 'time', 'timestamp'))
        close = self.safe_float(ticker, 'close')
        result = {
            'symbol': symbol,
            'info': ticker,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_float(ticker, 'high'),
            'low': self.safe_float(ticker, 'low'),
            'bid': None,
            'bidVolume': None,
            'ask': None,
            'askVolume': None,
            'vwap': None,
            'open': self.safe_float(ticker, 'open'),
            'close': close,
            'last': self.safe_float(ticker, 'last', close),
            'previousClose': None,
            'change': None,
            'percentage': None,
            'average': None,
            'baseVolume': self.safe_float(ticker, 'volume'),
            'quoteVolume': None,
        }
        return result

    def fetch_trades(self, symbol, since=None, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        response = self.publicGetTrades(self.extend(request, params))
        #
        #     {
        #         "btc-usdt": [
        #             {
        #                 "size": 0.5,
        #                 "price": 8830,
        #                 "side": "buy",
        #                 "timestamp": "2020-03-03T04:44:33.034Z"
        #             },
        #             # ...
        #         ]
        #     }
        #
        trades = self.safe_value(response, market['id'], [])
        return self.parse_trades(trades, market, since, limit)

    def parse_trade(self, trade, market=None):
        #
        # fetchTrades(public)
        #
        #     {
        #         "size": 0.5,
        #         "price": 8830,
        #         "side": "buy",
        #         "timestamp": "2020-03-03T04:44:33.034Z"
        #     }
        #
        # fetchMyTrades(private)
        #
        #     {
        #         "side": "buy",
        #         "symbol": "eth-usdt",
        #         "size": 0.086,
        #         "price": 226.19,
        #         "timestamp": "2020-03-03T08:03:55.459Z",
        #         "fee": 0.1
        #     }
        #
        marketId = self.safe_string(trade, 'symbol')
        market = self.safe_market(marketId, market, '-')
        symbol = market['symbol']
        datetime = self.safe_string(trade, 'timestamp')
        timestamp = self.parse8601(datetime)
        side = self.safe_string(trade, 'side')
        price = self.safe_float(trade, 'price')
        amount = self.safe_float(trade, 'size')
        cost = None
        if price is not None:
            if amount is not None:
                cost = price * amount
        feeCost = self.safe_float(trade, 'fee')
        fee = None
        if feeCost is not None:
            quote = market['quote']
            feeCurrencyCode = market['quote'] if (market is not None) else quote
            fee = {
                'cost': feeCost,
                'currency': feeCurrencyCode,
            }
        return {
            'info': trade,
            'id': None,
            'timestamp': timestamp,
            'datetime': datetime,
            'symbol': symbol,
            'order': None,
            'type': None,
            'side': side,
            'takerOrMaker': None,
            'price': price,
            'amount': amount,
            'cost': cost,
            'fee': fee,
        }

    def fetch_ohlcv(self, symbol, timeframe='1h', since=None, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
            'resolution': self.timeframes[timeframe],
        }
        duration = self.parse_timeframe(timeframe)
        if since is None:
            if limit is None:
                raise ArgumentsRequired(self.id + " fetchOHLCV() requires a 'since' or a 'limit' argument")
            else:
                end = self.seconds()
                start = end - duration * limit
                request['to'] = end
                request['from'] = start
        else:
            if limit is None:
                request['from'] = int(since / 1000)
                request['to'] = self.seconds()
            else:
                start = int(since / 1000)
                request['from'] = start
                request['to'] = self.sum(start, duration * limit)
        response = self.publicGetChart(self.extend(request, params))
        #
        #     [
        #         {
        #             "time":"2020-03-02T20:00:00.000Z",
        #             "close":8872.1,
        #             "high":8872.1,
        #             "low":8858.6,
        #             "open":8858.6,
        #             "symbol":"btc-usdt",
        #             "volume":1.2922
        #         },
        #     ]
        #
        return self.parse_ohlcvs(response, market, timeframe, since, limit)

    def parse_ohlcv(self, response, market=None, timeframe='1h', since=None, limit=None):
        #
        #     {
        #         "time":"2020-03-02T20:00:00.000Z",
        #         "close":8872.1,
        #         "high":8872.1,
        #         "low":8858.6,
        #         "open":8858.6,
        #         "symbol":"btc-usdt",
        #         "volume":1.2922
        #     }
        #
        return [
            self.parse8601(self.safe_string(response, 'time')),
            self.safe_float(response, 'open'),
            self.safe_float(response, 'high'),
            self.safe_float(response, 'low'),
            self.safe_float(response, 'close'),
            self.safe_float(response, 'volume'),
        ]

    def fetch_balance(self, params={}):
        self.load_markets()
        response = self.privateGetUserBalance(params)
        #
        #     {
        #         "updated_at": "2020-03-02T22:27:38.428Z",
        #         "btc_balance": 0,
        #         "btc_pending": 0,
        #         "btc_available": 0,
        #         "eth_balance": 0,
        #         "eth_pending": 0,
        #         "eth_available": 0,
        #         # ...
        #     }
        #
        result = {'info': response}
        currencyIds = list(self.currencies_by_id.keys())
        for i in range(0, len(currencyIds)):
            currencyId = currencyIds[i]
            code = self.safe_currency_code(currencyId)
            account = self.account()
            account['free'] = self.safe_float(response, currencyId + '_available')
            account['total'] = self.safe_float(response, currencyId + '_balance')
            result[code] = account
        return self.parse_balance(result)

    def fetch_open_order(self, id, symbol=None, params={}):
        self.load_markets()
        request = {
            'order_id': id,
        }
        response = self.privateGetUserOrdersOrderId(self.extend(request, params))
        #
        #     {
        #         "created_at": "2018-03-23T04:14:08.663Z",
        #         "title": "string",
        #         "side": "sell",
        #         "type": "limit",
        #         "price": 0,
        #         "size": 0,
        #         "symbol": "xht-usdt",
        #         "id": "string",
        #         "created_by": 1,
        #         "filled": 0
        #     }
        #
        return self.parse_order(response)

    def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        self.load_markets()
        market = None
        request = {}
        if symbol is not None:
            market = self.market(symbol)
            request['symbol'] = market['id']
        response = self.privateGetUserOrders(self.extend(request, params))
        #
        #     [
        #         {
        #             "created_at":"2020-03-03T08:02:18.639Z",
        #             "title":"5419ff3f-9d25-4af7-bcc2-803926518d76",
        #             "side":"buy",
        #             "type":"limit",
        #             "price":226.19,
        #             "size":0.086,
        #             "symbol":"eth-usdt",
        #             "id":"5419ff3f-9d25-4af7-bcc2-803926518d76",
        #             "created_by":620,
        #             "filled":0
        #         }
        #     ]
        #
        return self.parse_orders(response, market)

    def parse_order(self, order, market=None):
        #
        # fetchOpenOrder, fetchOpenOrders
        #
        #     {
        #         "created_at":"2020-03-03T08:02:18.639Z",
        #         "title":"5419ff3f-9d25-4af7-bcc2-803926518d76",
        #         "side":"buy",
        #         "type":"limit",
        #         "price":226.19,
        #         "size":0.086,
        #         "symbol":"eth-usdt",
        #         "id":"5419ff3f-9d25-4af7-bcc2-803926518d76",
        #         "created_by":620,
        #         "filled":0
        #     }
        #
        marketId = self.safe_string(order, 'symbol')
        symbol = self.safe_symbol(marketId, market, '-')
        id = self.safe_string(order, 'id')
        timestamp = self.parse8601(self.safe_string(order, 'created_at'))
        type = self.safe_string(order, 'type')
        side = self.safe_string(order, 'side')
        price = self.safe_float(order, 'price')
        amount = self.safe_float(order, 'size')
        filled = self.safe_float(order, 'filled')
        cost = None
        remaining = None
        if filled is not None:
            if amount is not None:
                remaining = amount - filled
            if price is not None:
                cost = filled * price
        status = 'closed' if (type == 'market') else 'open'
        result = {
            'id': id,
            'clientOrderId': None,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': None,
            'status': status,
            'symbol': symbol,
            'type': type,
            'timeInForce': None,
            'postOnly': None,
            'side': side,
            'price': price,
            'stopPrice': None,
            'amount': amount,
            'filled': filled,
            'remaining': remaining,
            'cost': cost,
            'trades': None,
            'fee': None,
            'info': order,
            'average': None,
        }
        return result

    def create_order(self, symbol, type, side, amount, price=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        order = {
            'symbol': market['id'],
            'side': side,
            'size': amount,
            'type': type,
        }
        if type != 'market':
            order['price'] = price
        response = self.privatePostOrder(self.extend(order, params))
        #
        #     {
        #         "symbol": "xht-usdt",
        #         "side": "sell",
        #         "size": 1,
        #         "type": "limit",
        #         "price": 0.1,
        #         "id": "string",
        #         "created_by": 34,
        #         "filled": 0,
        #         "status": "pending"
        #     }
        #
        return self.parse_order(response, market)

    def cancel_order(self, id, symbol=None, params={}):
        self.load_markets()
        request = {
            'order_id': id,
        }
        response = self.privateDeleteUserOrdersOrderId(self.extend(request, params))
        #
        #     {
        #         "title": "string",
        #         "symbol": "xht-usdt",
        #         "side": "sell",
        #         "size": 1,
        #         "type": "limit",
        #         "price": 0.1,
        #         "id": "string",
        #         "created_by": 34,
        #         "filled": 0
        #     }
        #
        return self.parse_order(response)

    def cancel_all_orders(self, symbol=None, params={}):
        self.load_markets()
        request = {}
        market = None
        if symbol is not None:
            market = self.markets(symbol)
            request['symbol'] = market['id']
        response = self.privateDeleteUserOrders(self.extend(request, params))
        #
        #     [
        #         {
        #             "title": "string",
        #             "symbol": "xht-usdt",
        #             "side": "sell",
        #             "size": 1,
        #             "type": "limit",
        #             "price": 0.1,
        #             "id": "string",
        #             "created_by": 34,
        #             "filled": 0
        #         }
        #     ]
        #
        return self.parse_orders(response, market)

    def fetch_my_trades(self, symbol=None, since=None, limit=None, params={}):
        self.load_markets()
        request = {
            # 'symbol': market['id'],
            # 'limit': 50,  # default 50, max 100
            # 'page': 1,  # page of data to retrieve
            # 'order_by': 'timestamp',  # field to order data
            # 'order': 'asc',  # asc or desc
            # 'start_date': 123,  # starting date of queried data
            # 'end_date': 321,  # ending date of queried data
        }
        market = None
        if symbol is not None:
            market = self.market(symbol)
            request['symbol'] = market['id']
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        if since is not None:
            request['start_date'] = self.iso8601(since)
        response = self.privateGetUserTrades(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "side": "buy",
        #                 "symbol": "eth-usdt",
        #                 "size": 0.086,
        #                 "price": 226.19,
        #                 "timestamp": "2020-03-03T08:03:55.459Z",
        #                 "fee": 0.1
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_trades(data, market, since, limit)

    def fetch_deposit_address(self, code, params={}):
        self.load_markets()
        currency = self.currency(code)
        response = self.privateGetUser(params)
        #
        #     {
        #         "id": 620,
        #         "email": "email@gmail.com",
        #         "full_name": "",
        #         "name_verified": False,
        #         "gender": False,
        #         "nationality": "",
        #         "phone_number": "",
        #         "address": {"city": "", "address": "", "country": "", "postal_code": ""},
        #         "id_data": {"note": "", "type": "", "number": "", "status": 0},
        #         "bank_account":[],
        #         "crypto_wallet":{
        #             "xrp": "rJtoECs6rPkJoAfgtR8SDDshV6hRHe3X7y:391496555"
        #             "usdt":"0x1fb4248e167901dfa0d8cdda2243a2126d7ce48d"
        #             # ...
        #         },
        #         "verification_level": 1,
        #         "otp_enabled": True,
        #         "activated": True,
        #         "note": "",
        #         "username": "user",
        #         "affiliation_code": "QSWA6G",
        #         "settings": {
        #             "chat": {"set_username": False},
        #             "risk": {"order_portfolio_percentage": 20},
        #             "audio": {
        #                 "public_trade": False,
        #                 "order_completed": True,
        #                 "order_partially_completed": True
        #             },
        #             "language": "en",
        #             "interface": {"theme": "white","order_book_levels": 10},
        #             "notification": {
        #                 "popup_order_completed": True,
        #                 "popup_order_confirmation": True,
        #                 "popup_order_partially_filled": True
        #             }
        #         },
        #         "flagged": False,
        #         "is_hap": False,
        #         "pin": False,
        #         "discount": 0,
        #         "created_at": "2020-03-02T22:27:38.331Z",
        #         "updated_at": "2020-03-03T07:54:58.315Z",
        #         "balance": {
        #             "xht_balance": 0,
        #             "xht_pending": 0,
        #             "xht_available": 0,
        #             # ...
        #             "updated_at": "2020-03-03T10:21:05.430Z"
        #         },
        #         "images": [],
        #         "fees": {
        #             "btc-usdt": {"maker_fee": 0.1, "taker_fee": 0.3},
        #             "eth-usdt": {"maker_fee": 0.1, "taker_fee": 0.3},
        #             # ...
        #         }
        #     }
        #
        cryptoWallet = self.safe_value(response, 'crypto_wallet')
        address = self.safe_string(cryptoWallet, currency['id'])
        tag = None
        if address is not None:
            parts = address.split(':')
            address = self.safe_string(parts, 0)
            tag = self.safe_string(parts, 1)
        self.check_address(address)
        return {
            'currency': code,
            'address': address,
            'tag': tag,
            'info': response,
        }

    def fetch_deposits(self, code=None, since=None, limit=None, params={}):
        self.load_markets()
        request = {
            # 'currency': currency['id'],
            # 'limit': 50,  # default 50, max 100
            # 'page': 1,  # page of data to retrieve
            # 'order_by': 'timestamp',  # field to order data
            # 'order': 'asc',  # asc or desc
            # 'start_date': 123,  # starting date of queried data
            # 'end_date': 321,  # ending date of queried data
        }
        currency = None
        if code is not None:
            currency = self.currency(code)
            request['currency'] = currency['id']
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        if since is not None:
            request['start_date'] = self.iso8601(since)
        response = self.privateGetUserDeposits(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "id": 539,
        #                 "amount": 20,
        #                 "fee": 0,
        #                 "address": "0x5c0cc98270d7089408fcbcc8e2131287f5be2306",
        #                 "transaction_id": "0xd4006327a5ec2c41adbdcf566eaaba6597c3d45906abe78ea1a4a022647c2e28",
        #                 "status": True,
        #                 "dismissed": False,
        #                 "rejected": False,
        #                 "description": "",
        #                 "type": "deposit",
        #                 "currency": "usdt",
        #                 "created_at": "2020-03-03T07:56:36.198Z",
        #                 "updated_at": "2020-03-03T08:00:05.674Z",
        #                 "user_id": 620
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_transactions(data, currency, since, limit)

    def fetch_withdrawals(self, code=None, since=None, limit=None, params={}):
        self.load_markets()
        request = {
            # 'currency': currency['id'],
            # 'limit': 50,  # default 50, max 100
            # 'page': 1,  # page of data to retrieve
            # 'order_by': 'timestamp',  # field to order data
            # 'order': 'asc',  # asc or desc
            # 'start_date': 123,  # starting date of queried data
            # 'end_date': 321,  # ending date of queried data
        }
        currency = None
        if code is not None:
            currency = self.currency(code)
            request['currency'] = currency['id']
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        if since is not None:
            request['start_date'] = self.iso8601(since)
        response = self.privateGetUserWithdrawals(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "id": 539,
        #                 "amount": 20,
        #                 "fee": 0,
        #                 "address": "0x5c0cc98270d7089408fcbcc8e2131287f5be2306",
        #                 "transaction_id": "0xd4006327a5ec2c41adbdcf566eaaba6597c3d45906abe78ea1a4a022647c2e28",
        #                 "status": True,
        #                 "dismissed": False,
        #                 "rejected": False,
        #                 "description": "",
        #                 "type": "withdrawal",
        #                 "currency": "usdt",
        #                 "created_at": "2020-03-03T07:56:36.198Z",
        #                 "updated_at": "2020-03-03T08:00:05.674Z",
        #                 "user_id": 620
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_transactions(data, currency, since, limit)

    def parse_transaction(self, transaction, currency=None):
        #
        #     {
        #         "id": 539,
        #         "amount": 20,
        #         "fee": 0,
        #         "address": "0x5c0cc98270d7089408fcbcc8e2131287f5be2306",
        #         "transaction_id": "0xd4006327a5ec2c41adbdcf566eaaba6597c3d45906abe78ea1a4a022647c2e28",
        #         "status": True,
        #         "dismissed": False,
        #         "rejected": False,
        #         "description": "",
        #         "type": "withdrawal",
        #         "currency": "usdt",
        #         "created_at": "2020-03-03T07:56:36.198Z",
        #         "updated_at": "2020-03-03T08:00:05.674Z",
        #         "user_id": 620
        #     }
        #
        id = self.safe_string(transaction, 'id')
        txid = self.safe_string(transaction, 'transaction_id')
        timestamp = self.parse8601(self.safe_string(transaction, 'created_at'))
        updated = self.parse8601(self.safe_string(transaction, 'updated_at'))
        type = self.safe_string(transaction, 'type')
        amount = self.safe_float(transaction, 'amount')
        address = self.safe_string(transaction, 'address')
        addressTo = None
        addressFrom = None
        tag = None
        tagTo = None
        tagFrom = None
        if address is not None:
            parts = address.split(':')
            address = self.safe_string(parts, 0)
            tag = self.safe_string(parts, 1)
            addressTo = address
            tagTo = tag
        currencyId = self.safe_string(transaction, 'currency')
        code = self.safe_currency_code(currencyId)
        status = self.safe_value(transaction, 'status')
        dismissed = self.safe_value(transaction, 'dismissed')
        rejected = self.safe_value(transaction, 'rejected')
        if status:
            status = 'ok'
        elif dismissed:
            status = 'canceled'
        elif rejected:
            status = 'failed'
        else:
            status = 'pending'
        fee = {
            'currency': code,
            'cost': self.safe_float(transaction, 'fee'),
        }
        return {
            'info': transaction,
            'id': id,
            'txid': txid,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'addressFrom': addressFrom,
            'address': address,
            'addressTo': addressTo,
            'tagFrom': tagFrom,
            'tag': tag,
            'tagTo': tagTo,
            'type': type,
            'amount': amount,
            'currency': code,
            'status': status,
            'updated': updated,
            'fee': fee,
        }

    def withdraw(self, code, amount, address, tag=None, params={}):
        self.check_address(address)
        self.load_markets()
        currency = self.currency(code)
        if tag is not None:
            address += ':' + tag
        request = {
            'currency': currency['id'],
            'amount': amount,
            'address': address,
        }
        # one time password
        otp = self.safe_string(params, 'otp_code')
        if (otp is not None) or (self.twofa is not None):
            if otp is None:
                otp = self.oath()
            request['otp_code'] = otp
        response = self.privatePostUserRequestWithdrawal(self.extend(request, params))
        return {
            'info': response,
            'id': None,
        }

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        path = '/' + self.version + '/' + self.implode_params(path, params)
        if method == 'GET':
            if query:
                path += '?' + self.urlencode(query)
        url = self.urls['api'] + path
        if api == 'private':
            self.check_required_credentials()
            defaultExpires = self.safe_integer_2(self.options, 'api-expires', 'expires', int(self.timeout / 1000))
            expires = self.sum(self.seconds(), defaultExpires)
            expiresString = str(expires)
            auth = method + path + expiresString
            headers = {
                'api-key': self.encode(self.apiKey),
                'api-expires': expiresString,
            }
            if method == 'POST':
                headers['Content-type'] = 'application/json'
                if query:
                    body = self.json(query)
                    auth += body
            signature = self.hmac(self.encode(auth), self.encode(self.secret))
            headers['api-signature'] = signature
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def handle_errors(self, code, reason, url, method, headers, body, response, requestHeaders, requestBody):
        if response is None:
            return
        if (code >= 400) and (code <= 503):
            #
            #  {"message": "Invalid token"}
            #
            feedback = self.id + ' ' + body
            message = self.safe_string(response, 'message')
            self.throw_broadly_matched_exception(self.exceptions['broad'], message, feedback)
            status = str(code)
            self.throw_exactly_matched_exception(self.exceptions['exact'], status, feedback)
