<h1 align="center">
	<img width="300" src="https://github.com/mindsdb/mindsdb_native/blob/stable/assets/MindsDBColorPurp@3x.png?raw=true" alt="MindsDB">
	<br>

</h1>
<div align="center">
	<a href="https://github.com/mindsdb/mindsdb/actions"><img src="https://github.com/mindsdb/mindsdb/workflows/MindsDB%20workflow/badge.svg" alt="MindsDB workflow"></a>

  <a href="https://www.python.org/downloads/" target="_blank"><img src="https://img.shields.io/badge/python-3.6%20|%203.7|%203.8-brightgreen.svg" alt="Python supported"></a>
   <a href="https://pypi.org/project/MindsDB/" target="_blank"><img src="https://badge.fury.io/py/MindsDB.svg" alt="PyPi Version"></a>
  <a href="https://pypi.org/project/MindsDB/" target="_blank"><img src="https://img.shields.io/pypi/dm/mindsdb" alt="PyPi Downloads"></a>
  <a href="https://hub.docker.com/u/mindsdb" target="_blank"><img src="https://img.shields.io/docker/pulls/mindsdb/mindsdb" alt="Docker pulls"></a>
  <a href="https://www.mindsdb.com/"><img src="https://img.shields.io/website?url=https%3A%2F%2Fwww.mindsdb.com%2F" alt="MindsDB Website"></a>	
    <a href="https://join.slack.com/t/mindsdbcommunity/shared_invite/zt-o8mrmx3l-5ai~5H66s6wlxFfBMVI6wQ" target="_blank"><img src="https://img.shields.io/badge/slack-@mindsdbcommunity-brightgreen.svg?logo=slack " alt="MindsDB Community"></a>
	
  <h3 align="center">
    <a href="https://www.mindsdb.com/">Website</a>
    <span> | </span>
    <a href="https://docs.mindsdb.com/">Docs</a>
    <span> | </span>
    <a href="https://apidocs.mindsdb.com/">API Docs</a>
    <span> | </span>
    <a href="https://join.slack.com/t/mindsdbcommunity/shared_invite/zt-o8mrmx3l-5ai~5H66s6wlxFfBMVI6wQ">Community Slack</a>
  </h3>
  
</div>

[MindsDB](https://mindsdb.com/) is an open-source predictive layer for existing databases that enables rapid prototyping & deployment of ML Models from your database. Significantly reducing the time and cost of machine learning workflows. [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Machine%20Learning%20in%20one%20line%20of%20code%21&url=https://www.mindsdb.com&via=mindsdb&hashtags=ai,ml,machine_learning,neural_networks)

<h2 align="center">
   Machine Learning in Database using SQL
   <br/>
   <br/>
  <img width="600" src="https://mindsdb-resources.s3.amazonaws.com/MindsDB+Glue.png" alt="MindsDB">	

</h2>


## Features

* **Prototype AutoML**. With MindsDB built-in Automated Machine Learning you can quickly generate the right machine learning model.
* **Model Tune(JSON AI)**. Optimize the model quickly and easily through the auto-generated JSON-type configuration file.
* **Bring your own models**. Build your models in any framework and import into MindsDB
* **AI Tables**. Move your models instantly to production, reduce resources, and overhead costs with AI Tables that deliver the results as database tables.
* **Explainable AI**. Use MindsDB Studio to interpret predictions made by the model. Identify potential data biases, evaluate and visualize model accuracy using the Explainable AI.




## Try it out

* [Getting started](https://docs.mindsdb.com/)
* [Install MindsDB](https://docs.mindsdb.com/Installing/)
	* [Docker](https://docs.mindsdb.com/installation/docker/)
	* [Linux](https://docs.mindsdb.com/installation/Linux/)
	* [Windows](https://docs.mindsdb.com/installation/Windows/)
	* [MacOS](https://docs.mindsdb.com/installation/MacOS/)
	* [From source](https://docs.mindsdb.com/installation/source/)
* [Tutorials](https://docs.mindsdb.com/databases/)
	* [AI Tables in MariaDB](https://docs.mindsdb.com/tutorials/mysql/)
	* [AI Tables in ClickHouse](https://docs.mindsdb.com/tutorials/clickhouse/)
	* [AI Tables in MySQL](https://docs.mindsdb.com/tutorials/mysql/)
	* [AI Tables in PostgreSQL](https://docs.mindsdb.com/tutorials/postgresql/)
	* [AI Tables in Microsoft SQL Server](https://docs.mindsdb.com/tutorials/microsoft-sql-server/)


## Integrations


AI Tables - Get the predictions you need as simple tables in your database.

| Connect your Data |
|-|
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/MongoDB-4EA94B?style=for-the-badge&logo=mongodb&logoColor=white" alt="Connect MongoDB"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/MySQL-00758F?style=for-the-badge&logo=mysql&logoColor=white" alt="Connect MySQL"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/PostgreSQL-316192?style=for-the-badge&logo=postgresql&logoColor=white" alt="Connect PostgreSQL"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/MariaDB-003545?style=for-the-badge&logo=mariadb&logoColor=white" alt="Connect MariaDB"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/Apache Kafka-808080?style=for-the-badge&logo=apache-kafka&logoColor=white" alt="Connect MongoDB"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/Snowflake-35aedd?style=for-the-badge&logo=snowflake&logoColor=blue" alt="Connect Snowflake"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/Clickhouse-e6e600?style=for-the-badge&logo=clickhouse&logoColor=white" alt="Connect Clickhouse"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/Cassandra-1287B1?style=for-the-badge&logo=apache%20cassandra&logoColor=white" alt="Connect Cassandra"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/redis-%23DD0031.svg?&style=for-the-badge&logo=redis&logoColor=white" alt="Connect Redis"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/Microsoft%20SQL%20Sever-CC2927?style=for-the-badge&logo=microsoft%20sql%20server&logoColor=white" alt="Connect SQL Server"></a> |
| <a href="https://docs.mindsdb.com/"><img src="https://img.shields.io/badge/Singlestore-5f07b4?style=for-the-badge&logo=singlestore&logoColor=white" alt="Connect Singlestore"></a> |

[:question: :wave: Missing integration?](https://github.com/mindsdb/mindsdb/issues/new?assignees=&labels=&template=feature-mindsdb-request.md)

## Contributing

* To contribute to MindsDB, please check out [Contribution docs](https://docs.mindsdb.com/contribute/).
* Welcome to our awesome community, please check out [Community docs](https://docs.mindsdb.com/community/).

### Current contributors

<a href="https://github.com/mindsdb/mindsdb/graphs/contributors">
  <img src="https://contributors-img.web.app/image?repo=mindsdb/mindsdb" />
</a>

Made with [contributors-img](https://contributors-img.web.app).

## Report Issues

Please help us by [reporting any issues](https://github.com/mindsdb/mindsdb/issues/new/choose) you may have while using MindsDB.

## License

* [MindsDB License](https://github.com/mindsdb/mindsdb/blob/master/LICENSE)
