# Contribute to MindsDB :bear:

Thank you for your interest in contributing to MindsDB. MindsDB is free, open source software, and all types of contributions are welcome, whether they’re documentation changes, bug reports, bug fixes or new source code changes.

## Report issue :loudspeaker:

We use [GitHub issues](https://github.com/mindsdb/mindsdb/issues) to track bugs and features. Report them by opening a new issue and complete out all of the required inputs: `Your Python version`, `MindsDB version`, `Describe the bug` and `Steps to reproduce`.

![Github Issue](/assets/report-issue.gif)

## Documentation :book:

We are always trying to improve our documentation. All Pull Requests that improve our grammar or docs structure or fix typos are welcomed.

* Check the [MindsDB Docs](https://github.com/mindsdb/mindsdb-docs) repository and help us.

## Easy contribution to issues :wrench:

Most of the issues that are open for contributions will be tagged with `good-first-issue` or `help-wanted`. After you find the issue that you want to contribute to, follow the `fork-and-pull` workflow:

1. Fork the MindsDB repository
2. Clone the repository locally
3. Make changes and commit them
4. Push your local branch to your fork
5. Submit a Pull Request so that we can review your changes
6. Write a commit message
7. Make sure that the CI tests are GREEN
>NOTE: Be sure to merge the latest from "upstream" before making a Pull Request!

Pull Request reviews are done on a regular basis. Please make sure you respond to our feedback/questions and sign our CLA.

## Write for us :pencil:

Do you find MindsDB useful and want to share your story? Make a PR to this repo with your writing in a markdown file, or just post it on Medium, Dev or your own blog post. We would love to hear from you :green_heart:.
