# Contributing to Mindsdb

Being part of the core MindsDB team is accessible to anyone who is motivated and wants to be part of that journey!

Please see below how to contribute to the project, also refer to the contributing documentation.

# Hacktoberfest 2021
We are very excited that MindsDB is participating in this year's Hacktoberfest 2021 event. This month-long event through October gives you the chance to contribute to the Open Source codebase of MindsDB!

MindsDB engineers have prepared several categories of open issues that are ideal for first-time contributors. It's entirely up to you what you choose to work on and if you have your own great idea, feel free to suggest it by reaching out to us via our Slack community or Github Discussions.

**Our Major Incentive and SWAG from MindsDB!** 

Make contributions and enter into the draw for a [Deep Learning Laptop](https://lambdalabs.com/deep-learning/laptops/tensorbook) **powered by the NVIDIA RTX 3080 Max-Q GPU**. Pre-installed with TensorFlow, PyTorch, CUDA, cuDNN and more.

![Deep Learning Laptop](/assets/laptop.jpeg)

Also we’d love to send you a special MindsDB SWAG gift packs

![MindsDB Swag](/assets/swag.png)


#### How to take part:

1. Contribute with at least 5 points making pull requests to any of our open issues labeled Hacktoberfest during the October timeframe.
2. Complete the form with links to all your completed PR’s so we know where to ship the gift pack to!

Entries close at midnight (PST) Sunday, 31 October 2021 with the prize draw winner announced at an online event on Monday, 1st of November.

Please check https://mindsdb.com/hacktoberfest for more details.

## How can you help us?

* Report a bug
* Improve documentation
* Discuss the code implementation
* Submit a bug fix
* Propose new features
* Test Mindsdb

## Code contributions

In general, we follow the "fork-and-pull" Git workflow.
1. Fork the Mindsdb repository
2. Clone the repository
3. Make changes and commit them
4. Push your local branch to your fork
5. Submit a Pull request so that we can review your changes
6. Write a commit message
7. Make sure that the CI tests are GREEN

> NOTE: Be sure to merge the latest from "upstream" before making a pull request! Also, make the PR to the staging branch.

## Feature and Bug reports
We use GitHub issues to track bugs and features. Report them by opening a [new issue](https://github.com/mindsdb/mindsdb/issues/new/choose) and fill out all of the required inputs.

## Code review process

The Pull Request reviews are done on a regular basis. Please, make sure you respond to our feedback/questions.

## Community

If you have additional questions or you want to chat with the MindsDB core team, please join our [Slack community](https://join.slack.com/t/mindsdbcommunity/shared_invite/zt-o8mrmx3l-5ai~5H66s6wlxFfBMVI6wQ) or post at [Github Discussions](https://github.com/mindsdb/mindsdb/discussions).
 
To get updates on MindsDB’s latest announcements, releases, and events, sign up for our [Monthly Community Newsletter](https://mindsdb.com/newsletter/?utm_medium=community&utm_source=github&utm_campaign=mindsdb%20repo).

Join our mission of democratizing machine learning!

## Contributor Code of Conduct
Please note that this project is released with a [Contributor Code of Conduct](https://github.com/mindsdb/mindsdb/blob/stable/CODE_OF_CONDUCT.md). By participating in this project, you agree to abide by its terms.

