# Contributing to Mindsdb

We love to receive contributions from the community and hear your opinions! We want to make contributing to Mindsdb as easily as it can be.

# How can you help us?

* Report a bug
* Improve documentation
* Discuss the code implementation
* Submit a bug fix
* Propose new features
* Test Mindsdb

# Code contributions
In general, we follow the "fork-and-pull" Git workflow.

1. Fork the Mindsdb repository
2. Clone the repository
3. Make changes and commit them
4. Push your local branch to your fork
5. Submit a Pull request so that we can review your changes
6. Write a commit message
7. Make sure that the CI tests are GREEN

>NOTE: Be sure to merge the latest from "upstream" before making a pull request!

# Feature and Bug reports
We use GitHub issues to track bugs and features. Report them by opening a [new issue](https://github.com/mindsdb/mindsdb/issues/new/choose) and fill out all of the required inputs.

# Code review process
The Pull Request reviews are done on a regular basis. 
Please, make sure you respond to our feedback/questions.

# Community
If you have additional questions or you want to chat with MindsDB core team, you can join our community [![Discourse posts](https://img.shields.io/discourse/posts?server=https%3A%2F%2Fcommunity.mindsdb.com%2F)](https://community.mindsdb.com/). To get updates on MindsDB’s latest announcements, releases, and events, [sign up for our newsletter](https://mindsdb.us20.list-manage.com/subscribe/post?u=5174706490c4f461e54869879&amp;id=242786942a).
