/**
 *    Copyright (C) 2021-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */
#pragma once

#include "mongo/db/process_health/health_observer.h"

#include "mongo/db/service_context.h"

namespace mongo {
namespace process_health {

/**
 * Interface to conduct periodic health checks.
 * Every instance of health observer is wired internally to update the state of the FaultManager
 * when a problem is detected.
 */
class HealthObserverBase : public HealthObserver {
public:
    HealthObserverBase(ClockSource* clockSource);
    virtual ~HealthObserverBase() = default;

    // Implements the common logic for periodic checks.
    // Every observer should implement periodicCheckImpl() for specific tests.
    void periodicCheck(FaultFacetsContainerFactory& factory) final;

protected:
    /**
     * The main method every health observer should implement for a particular
     * health check it does.
     *
     * @param optionalExistingFacet if a fault facet of this particular type already exists
     *        (if there is an ongoing incident already)
     */
    // TODO(SERVER-59592): futurize this.
    virtual FaultFacetPtr periodicCheckImpl(FaultFacetPtr optionalExistingFacet) = 0;

    ClockSource* const _clockSource;

    HealthObserverIntensity _intensity = HealthObserverIntensity::kNonCritical;

    HealthObserverIntensity getIntensity();
};

}  // namespace process_health
}  // namespace mongo
