---
title: Oozie SLAでワークフローの監視とアラートを取得
author: Hue Team
type: post
date: 2014-04-03T21:20:41+00:00
url: /oozie-slaでワークフローの監視とアラートを取得/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_author_info:
  - 1
sf_social_sharing:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
slide_template:
  - default
sf_custom_excerpt:
  - HueはOozie SLA が簡単に使用できるようになりました！SLAにより、ある時間内にワークフローが完了していない場合、自動的にアラートをすることができます。....
categories:
  - Oozie
  - Tutorial
  - Video

---
<p id="docs-internal-guid-99e4a41b-294c-1afb-46e2-ab6223f97bad" dir="ltr">
  Hueは<a href="http://oozie.apache.org/docs/4.0.0/DG_SLAMonitoring.html">Oozie SLA</a> が簡単に使用できるようになりました！SLAにより、ある時間内にワークフローが完了していない場合、自動的にアラートをすることができます。OozieのSLAはOozie 4で多くの改善がされているので、この機能には Oozie 4.x が必要になります。
</p>

{{< youtube 3QBGF1tTEgQ >}}

SLAはエディタの高度なタブで設定できます:

<li dir="ltr">
  <p dir="ltr">
    ワークフローのプロパティ
  </p>
</li>

<li dir="ltr">
  <p dir="ltr">
    ワークフローのアクションプロパティ
  </p>
</li>

<li dir="ltr">
  <p dir="ltr">
    コーディネータのプロパティ
  </p>
</li>

<p dir="ltr">
  SLAはダッシュボードで可視化することができます:
</p>

<li dir="ltr">
  <p dir="ltr">
    検索やグラフのための新しいメインのSLAタブ
  </p>
</li>

<li dir="ltr">
  <p dir="ltr">
    単一のワークフローやコーディネータのためのSLAタブ
  </p>
</li>

<p dir="ltr">
  ここではJMSの通知のセットアップは扱いません。<a href="http://oozie.apache.org/docs/4.0.0/DG_JMSNotifications.html">JMS</a> は（このチュートリアルのようにプールする代わりに）通知をリアルタイムでアラートするようにクライアントを有効にします。Hueにより、タイムラインでジョブの成功の可視化とアラートの場合にメール通知のセットアップができます。
</p>

<p dir="ltr">
  いつものように、<a href="http://groups.google.com/a/cloudera.org/group/hue-user">hue-user</a>リスト、または<a href="https://twitter.com/gethue">@gethue</a>までお気軽にコメントして下さい!
</p>

<p dir="ltr">
  <strong>注</strong><br /> Oozie自身にSLAを有効にするには?
</p>

<p dir="ltr">
  最初に、Oozie 4を使用していることを確認して下さい。Oozie 3からアップグレードする必要がある場合、Oozie sharelibを以下のように更新することを忘れないで下さい:
</p>

<pre><code class="bash">sudo -u oozie /usr/lib/oozie/bin/oozie-setup.sh sharelib create -fs hdfs://localhost:8020 -locallib /usr/lib/oozie/oozie-sharelib-yarn.tar.gz
</pre>

<p dir="ltr">
  何らかの理由でOozieのDBをリセットする必要がある場合、以下のように削除してから再作成して下さい:
</p>

<pre><code class="bash">sudo -u oozie /usr/lib/oozie/bin/ooziedb.sh create -sqlfile oozie.sql -run
</pre>

<p dir="ltr">
  <strong>注</strong><br /> 以下の例外を避けるために、oozie-site.xmlにSLAプロパティを持つべきではありません。
</p>

<pre><code class="java">Exception in thread "main" java.lang.NoClassDefFoundError: javax/mail/MessagingException
    at java.lang.Class.forName0(Native Method)
    at java.lang.Class.forName(Class.java:270)
</pre>

<p dir="ltr">
  それからoozie-site.xmlを開いて、これらの<a href="http://oozie.apache.org/docs/4.0.0/AG_Install.html#Notifications_Configuration">プロパティ</a>を追加してOozieを再起動します:
</p>

<pre><code class="xml">&lt;property&gt;
  &lt;name&gt;oozie.services.ext&lt;/name&gt;
  &lt;value&gt;
    org.apache.oozie.service.EventHandlerService,
    org.apache.oozie.sla.service.SLAService
  &lt;/value&gt;
&lt;/property&gt;
&lt;property&gt;
  &lt;name&gt;oozie.service.EventHandlerService.event.listeners&lt;/name&gt;
  &lt;value&gt;
    org.apache.oozie.sla.listener.SLAJobEventListener,
    org.apache.oozie.sla.listener.SLAEmailEventListener
  &lt;/value&gt;
&lt;/property&gt;
</pre>