---
title: Kerberos環境で、HiveアクションでOozieワークフローのクレデンシャル
author: Hue Team
type: post
date: 2014-04-02T20:22:18+00:00
url: /oozieワークフローのクレデンシャル/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_custom_excerpt:
  - Hive (あるいは Pig, HBase) を用いてHadoopセキュリティとジョブのスケジューリングを使用する際、このエラーを受け取ったかもしれません...
sf_author_info:
  - 1
sf_social_sharing:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
slide_template:
  - default
categories:
  - Oozie
  - Security
  - Tutorial
  - Video

---
原文は[こちら][1]

[Hive][2] (あるいは Pig, [HBase][3]) を用いてHadoopセキュリティとジョブのスケジューリングを使用する際、このエラーを受け取ったかもしれません:

<pre><code class="bash">Caused by: MetaException(message:Could not connect to meta store using any of the URIs provided. Most recent failure: org.apache.thrift.transport.TTransportException: GSS initiate failed
</pre>

実際に、Kerberosが有効になっている場合、HiveのメタストアサーバにOozieのHiveアクションを使用するために、ワークフローでHCatalogのクレデンシャルを使用する必要があります。

これはKerberos化されたクラスタとMySql Hiveメタストアで、それがどのように動作するかを示しているデモです。HCatクレデンシャルを必要とするテーブルの一覧と操作を行うHiveスクリプトを作成します。[ここ][4]から全ての使用と設定について探してみて下さい。

{{< youtube 6meeq7xvj54 >}}

Hueは、ワークフローのアクションで必要なクレデンシャルをチェックして自動的にパラメータを満たし、以下を行います:

  * クラスタから利用可能なクレデンシャルの詳細を動的に引き出す
  * ワークフローでクレデンシャルを設定

その後、Hiveアクションの高度なプロパティでHCatのクレデンシャルにチェックすることを忘れないで下さい。必要がある場合は複数のクレデンシャルをチェックできます。

そう、これだけです！ワークフローをサブミットして出力を確認すると、テーブルの一覧と2番目のクエリの計算結果が表示されます！

いつものように、[hue-user][5]リスト、または[@gethue][6]までお気軽にコメントして下さい!

**注**:
  
HiveはJDBCを介して直接メタストアに、あるいは保護をバイパスしてアクセスするべきではありません。

hive-config.xmlでは、この種類の設定の代わりに、:

<pre><code class="xml">javax.jdo.option.ConnectionURL
    jdbc:mysql://hue.com:3306/hive1?useUnicode=true&characterEncoding=UTF-8
javax.jdo.option.ConnectionDriverName
com.mysql.jdbc.Driver
javax.jdo.option.ConnectionUserName
hive1
javax.jdo.option.ConnectionPassword
hive1
</pre>

これを使用します:

<pre><code class="xml">hive.metastore.local
false
hive.metastore.uris
    thrift://hue.com:9083
hive.metastore.sasl.enabled
true
</pre>

**注**:
  
ジョブがMySQLに接続しようとする際、このJarの問題に遭遇するかもしれません:

<pre><code class="bash">Caused by: org.datanucleus.store.rdbms.datasource.DatastoreDriverNotFoundException: The specified datastore driver ("com.mysql.jdbc.Driver") was not found in the CLASSPATH. Please check your CLASSPATH specification, and the name of the driver.
</pre>

これを解決するにはhttp://dev.mysql.com/downloads/connector/j/から単純にMySQLのコネクタをダウンロードして、HiveServer2が示すようにします:

<pre><code class="xml">hive.aux.jars.path
  file:///usr/share/java//mysql-connector-java.jar
</pre>

**注**:
  
Oozie自身でクレデンシャルをアクティベートするには、oozie-site.xmlでこのプロパティを更新します。

<pre><code class="xml"> oozie.credentials.credentialclasses

    hcat=org.apache.oozie.action.hadoop.HCatCredentials,
    hbase=org.apache.oozie.action.hadoop.HbaseCredentials

</pre>

 [1]: https://gethue.com/hadoop-tutorial-oozie-workflow-credentials-with-a-hive-action-with-kerberos/
 [2]: https://gethue.com/hadoop-tutorial-how-to-access-hive-in-pig-with/
 [3]: https://gethue.com/hadoop-tutorial-use-pig-and-hive-with-hbase/
 [4]: https://github.com/romainr/hadoop-tutorials-examples/tree/master/oozie/credentials
 [5]: http://groups.google.com/a/cloudera.org/group/hue-user
 [6]: https://twitter.com/gethue