---
title: 最近のセキュリティ強化
author: Hue Team
type: post
date: 2014-03-26T16:22:05+00:00
url: /最近のセキュリティ強化/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
slide_template:
  - default
categories:
  - Enterprise
  - カテゴリーなし

---
<p id="docs-internal-guid-4e51c4c8-e826-f763-73a0-2427956de77d">
  <a href="https://gethue.com">Hue</a>&nbsp;は、最近(<a href="https://gethue.com/hue-3-5-and-its-redesign-are-out">Hue 3.5</a>から)おびただしい数のセキュリティの改善を行っています。最も重要なものの一つは、他のサービスとの通信を行う際、暗号を有効にするものです:
</p>

  1. <span>セキュアなデータベース接続 (</span>[<span>HUE-1638</span>][1]<span>)</span>

  2. <span>HiveServer2 over SSL (</span>[<span>HUE-1749</span>][2]<span>)</span>

<span></span>

<span>さらに、いくつかの別のセキュリティオプションが追加されています:</span>

  1. <span>セッションのタイムアウトが現在設定可能に (</span>[<span>HUE-1528</span>][3]<span>)</span>

  2. <span>クッキーがセキュアにできる (</span>[<span>HUE-1529</span>][4]<span>)</span>

  3. <span>サポートされている場合はセッションクッキーでHTTPOnlyを使う (</span>[<span>HUE-1639</span>][5]<span>)</span>

  4. <span>hue.iniにHTTPメソッドが定義可能に</span>

  5. <span>SSL使用時Cipher listを制限可能にできる</span>

<span></span>

# <span>セキュアなデータベース接続</span>

<span>コネクションはデータベースにより違ってきます。Hueは内部的に各データベースと通信するために、異なるクライアントを使用します。それらは全てDBAPI バージョン2として知られている一般的なインタフェースを指定します。セキュアな接続性のようなクライアント特有のオプションは、インタフェースを通してもたらされます。例 (MySQL):</span>

<pre>[<span id="80b1c282-abad-4758-8643-37492044e111">desktop</span>]
  [[databases]]<span id="127f0cb5-2734-406e-bd1f-3d9a2412f692">
   &hellip;</span>
   options=<span id="418ed8a6-c713-48be-94e8-c8348c96a2d8">{</span>&ldquo;<span id="2fe6b8d2-c7e2-4e85-9b0a-2a43c4fc1b0e">ssl</span>&rdquo;<span id="71f3d43d-302c-4807-a3d0-129018ec1a0f">:</span>{&ldquo;<span id="733efc8b-fbfe-4fe5-bea4-9f9ae4561426">ca</span>&rdquo;:&rdquo;/tmp/<span id="ed0c166d-707f-4c1a-aac5-1dae0f9d442b">ca</span>-<span id="f3833263-6a57-48b8-8ff6-0fff21c8adfc">cert</span><span id="72a756a3-936f-429d-a924-4ec3222c1472">.</span><span id="6d5f05d6-2040-4213-b980-1ae7f6951e95">pem</span>&rdquo;}}</pre>

# <span>HiveServer2 over SSL</span>

<span>CA certificate, private key, public certificateを提供することにより、HueはSSL上でHiveServer2と通信できます。これは</span><span><a href="https://github.com/cloudera/hue/blob/master/desktop/conf.dist/hue.ini#L494">hue<span id="f18b10bd-ae2a-445e-a0e6-d60f3de04aed">.</span>ini</a>で設定できます。例</span><span>:</span>

<pre>[<span id="59b40510-4427-45d4-9d96-f31290ce737c">beeswax</span>]
  [[<span id="dc3015f7-5749-4aa4-a342-f5d6116b12a2">ssl</span>]]
  enabled=true
  cacerts=/<span id="fae232c2-2a26-4ca7-b394-bf01041e37aa">etc</span>/hue/<span id="50bfbcc8-91ab-41a6-bc0b-69727551086c">cacerts</span><span id="bfba1781-19e7-4708-979d-b513cba40597">.</span><span id="57158a15-7bd3-4555-8327-d12188b95fdf">pem</span>
  key=/<span id="b005d6f8-65ab-4f54-b94f-ff50146c3d35">etc</span>/hue/key<span id="7f2de45f-9ed3-4a5a-9e8c-eddff5fb69cf">.</span><span id="fe72cf52-e569-420f-89a2-73f9a8873c59">pem</span>
  cert=/<span id="3b6311df-5c75-41cd-a884-7d3eb74192c2">etc</span>/hue/key<span id="49cd6c73-fb07-4ef3-94df-06ad86a169dd">.</span>pemkey=/<span id="d51a6b22-71be-4a9c-a6f6-acd815a9985e">etc</span>/hue/<span id="64bbedb1-2397-4195-bbb0-1700ff743828">publiccert</span><span id="7afbbaf8-3ce0-47f2-91ca-932d572b7a86">.</span><span id="1288ab12-8df7-44c9-8101-0170011b2724">pem</span>
</pre>

# <span>セッションタイムアウト</span>

セッションタイムアウトは&nbsp;[hue.ini][6]&nbsp;の、desktop->session->ttlで設定できます。例:

<pre>[<span id="31ca97fe-b163-4200-a1c0-19404cc0c4c7">desktop</span>]
  [[session]]
  ttl=3600
</pre>

# <span>セキュアなクッキー</span>

<span>セキュアなセッションクッキーは、<a href="https://github.com/cloudera/hue/blob/master/desktop/conf.dist/hue.ini#L208">hue.ini</a>のdesktop->session->secureで有効にできます。例</span><span>:</span>

<pre>[<span id="0fd2139a-cab4-403f-8410-c4f62408b318">desktop</span>]
  [[session]]
  secure=true
</pre>

<span>HTTPonlyフラグは<a href="https://github.com/cloudera/hue/blob/master/desktop/conf.dist/hue.ini#L211">hue.ini</a>のdesktop->session->http_onlyで設定できます。例</span><span>:</span>

<pre>[<span id="003c5fbd-75ea-47be-93df-2297df23b5fc">desktop</span>]
  [[session]]
  http_only=true
</pre>

# <span>許可されたHTTPメソッド</span>

<span>どのHTTPリクエストメソッドにサーバーが応答するか、hue.iniのdesktop->http_allowed_methodsで制御できます。例:</span>

<pre>[<span id="83047978-68a9-4bf7-a3ca-a7b819317c57">desktop</span>]
http_allowed_methods=options<span id="7ed2a880-f72d-49ce-925c-f80d412e9065">,</span><span id="09b37d71-382d-497d-ab5d-d307a848d49f">get</span><span id="f5aaa132-1c93-45bc-b2ee-9ab412bb3c83">,</span>head<span id="80657d06-0529-44f4-8e9d-7ce61e7a3dec">,</span>post<span id="a504a3c7-9396-4ca1-b071-322d634bba9f">,</span>put<span id="a1fa3ae9-bd66-4780-bd59-86600617afdf">,</span>delete<span id="e09a20a0-942b-48a4-8f08-c312f821b1eb">,</span>connect
</pre>

# <span>Cipher Listを制限</span>

<span>HTTPSでのCipher listのサポートは、hue.iniのdesktop->ssl_cipher_listで制限できます。値は<a href="http://www.openssl.org/docs/apps/ciphers.html">cipher list format</a>にあります。例</span><span>:</span>

<pre>[<span id="8e79b827-1601-4ba0-9c2d-f9bc7cde70b2">desktop</span>]
ssl_cipher_list=DEFAULT:<span id="491c0fa3-4590-4dee-b390-7b90d02d9bd3">!</span><span id="c136355c-d94e-4110-9e04-d6a7890323f8">aNULL</span>:<span id="0b024ab5-5562-4c81-9b00-1721fd6896d9">!</span><span id="08d54a96-3ddf-4c67-96df-38db8bcc846c">eNULL</span>:<span id="71988331-a8aa-497c-aa74-4c6c11c48ea4">!</span>LOW:<span id="b0bb11aa-ec58-4c96-aabf-a154b5b8761a">!</span>EXPORT:<span id="6af53966-f468-43a1-8045-b377d30ab241">!</span>SSLv2
</pre>

<span></span>

<span>Hueチームはセキュリティの改善に一生懸命取り組んでいます。これらの最近の改善が，貴方のシステムがよりセキュアになり、セキュリティ標準により準拠するようになることを願っています。いつものように、お気軽に</span><span><a href="http://groups.google.com/a/cloudera.org/group/hue-user">hue-user</a>や</span><span></span><span><a class="tumblelog" href="http://tmblr.co/mjrjfJ-GIti18oBq2GmTjjA">gethue</a><a href="http://twitter.com/gethue">​</a>までお問い合わせ下さい。</span><span><br /></span>

 [1]: https://issues.cloudera.org/browse/HUE-1638
 [2]: https://issues.cloudera.org/browse/HUE-1749
 [3]: https://issues.cloudera.org/browse/HUE-1528
 [4]: https://issues.cloudera.org/browse/HUE-1529
 [5]: https://issues.cloudera.org/browse/HUE-1639
 [6]: https://github.com/cloudera/hue/blob/master/desktop/conf.dist/hue.ini#L204