---
title: Hue 4.7 and its improvements are out!
author: Hue Team
type: post
date: 2020-04-10T02:36:35+00:00
url: /blog/hue-4-7-and-its-improvements-are-out/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_related_articles:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
sf_remove_promo_bar:
  - 1
ampforwp-amp-on-off:
  - default
categories:
  - Version 4
#  - Version 4.7
  - Release

---
Hi Data Explorers,

&nbsp;

The Hue Team is glad to thanks all the contributors and release Hue 4.7!

<img class="" src="https://cdn.gethue.com/uploads/2015/08/hue-logo-copy.png" alt="hue-logo" width="85" height="63" />

&nbsp;

The focus of this release was to keep building on top of [4.6](https://gethue.com/hue-4-6-and-its-improvements-are-out/), modularize the tech stack, improve SQL integrations and prepare major features of Hue 5. Some highlights:

* Top blue button has been converted to a menu in the left side
* Birthday time: its was the [10 years of Hue!](https://gethue.com/blog/2020-01-28-ten-years-data-querying-ux-evolution/)
* Build your own or improve the [SQL parsers](https://docs.gethue.com/developer/development/#sql-parsers)
* Japanese blog is back https://jp.gethue.com/
* A big summary of the [Datawarehouse UX](https://gethue.com/blog/2020-02-10-sql-query-experience-of-your-cloud-data-warehouse/) was published


This release comes with 650+ commits and 100+ bug fixes! For all the changes, check out the [release notes](https://docs.gethue.com/releases/release-notes-4.7.0/).

Go grab it and give it a spin!

* Docker
    ```
    docker run -it -p 8888:8888 gethue/4.7.0
    ```
* Kubernetes :
    ```
    helm repo add gethue https://helm.gethue.com
    helm repo update
    helm install hue gethue/hue
    ```
* [demo.gethue.com](demo.gethue.com)
* [Tarball](https://cdn.gethue.com/downloads/hue-4.7.0.tgz) or [source](https://github.com/cloudera/hue/archive/release-4.7.0.zip)

<a href="https://cdn.gethue.com/uploads/2020/04/hue-4.7.png">
  <img src="https://cdn.gethue.com/uploads/2020/04/hue-4.7.png" />
</a>

</br>
</br>
</br>

Here is a selection of the improvements:

## SQL

* [Foreign Keys](https://gethue.com/2019-11-13-sql-column-assist-icons/) are showing-up in the SQL left assist
* The autocomplete grammar was updated with: INTEGER, CTAS, STREAM keyword, EXPLAIN, LOAD, SHOW MATERIALIZED VIEW, ALTER MATERIALIZED VIEW,  DROP MATERIALIZED VIEW
* Materialized views are showing-up with the proper eye icon
* Hive LLAP/Tez sessions management was revamped in order to support more than one query running concurrently
* The Drag & Drop from the SQL left assist flakiness was fixed
* SQL samples now also work with mutable tables (e.g. ORC format tables with INSERT, DELETE, UPDATE..)
* How to build [SQL Autocompletes tutorial](https://docs.gethue.com/developer/development/#sql-parsers) has been updated
* SQL Autocomplete parsers are now available as a [JavaScript component](https://gethue.com/blog/2020-02-27-using-sql-parser-module/) pluggable via a classic `npm install`

![Foreign Keys](https://cdn.gethue.com/uploads/2019/11/sql_columns_assist_keys.png)

## Collaboration

* Queries snippets can be shared via a [Gist](https://gethue.com/blog/2020-03-04-datawarehouse-database-sql-collaboration-and-sharing-with-link-and-gist/#sql-snippet---gist) with their own Slack previews
* Queries can be shared via [public links](https://gethue.com/blog/2020-03-04-datawarehouse-database-sql-collaboration-and-sharing-with-link-and-gist/#public-links)
* The link sharing modal was restyled to be [friendlier](https://cdn.gethue.com/uploads/2020/04/4.7_sharing_popup.png)

![Query Gist](https://cdn.gethue.com/uploads/2020/03/editor_gist_slack.png)

![Query Sharing](https://cdn.gethue.com/uploads/2020/03/editor_sharing_popup.png)

## Infra

* [Azure ABFS filesystem](https://gethue.com/integration-with-microsoft-azure-data-lake-store-gen2/) is now officially supported
* The continuous integration now [checks for deadlinks](https://gethue.com/checking-dead-links-automatically-continuous-integration/) on [docs.gethue.com](https://docs.gethue.com/)
* Python 3: support is making additional progress. How to compile with it and send feedback:
  ```
  export PYTHON_VER=python3.6
  make apps
  ```

![ABFS connector](https://cdn.gethue.com/uploads/2020/04/4.7_filebrowser_abfs.png)

## Admin

* Configuration settings can be searched [via a filter](https://cdn.gethue.com/uploads/2020/04/4.7_admin_config_filter.png)
* The delete flow of a user now disables instead of deleting (to avoid losing the saved documents and queries)
* User admin page now displays [ACTIVE and SUPERUSER](https://cdn.gethue.com/uploads/2020/04/4.7_admin_users_status.png) statuses
* The number of [active users](https://gethue.com/hue-active-users-metric-improvements/) metric per API instance was revamped

![Active user](https://cdn.gethue.com/uploads/2020/04/cm_active_users.png)

## Progress

* [HUE-8768](https://issues.cloudera.org/browse/HUE-8768) The new version of the Editor with multi execution contexts and more robustness got 200+ commits
* [HUE-8758](https://issues.cloudera.org/browse/HUE-8758) SQL connectors configuration instead of using hue.ini is close to a MVP
* [HUE-8824](https://issues.cloudera.org/browse/HUE-8824) The Optimizations and Catalogs API were made public
* [HUE-8738](https://issues.cloudera.org/browse/HUE-8738) The Celery Task Server and SQL task got updated for Python 3


Any feedback or question? Feel free to comment here or on the <a href="https://discourse.gethue.com/">Forum</a> and <a href="https://docs.gethue.com/quickstart/">quick start</a> SQL querying!


Onwards!
