---
title: Hue 4.6 and its improvements are out!
author: Hue Team
type: post
date: 2019-12-05T02:36:35+00:00
url: /hue-4-6-and-its-improvements-are-out/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_related_articles:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
sf_remove_promo_bar:
  - 1
ampforwp-amp-on-off:
  - default
categories:
  - Version 4
# - Version 4.6
  - Release

---
Hi Data Explorers,

&nbsp;

The Hue Team is glad to thanks all the contributors and release Hue 4.6!

<img class="" src="https://cdn.gethue.com/uploads/2015/08/hue-logo-copy.png" alt="hue-logo" width="85" height="63" />

&nbsp;

The focus of this release was to keep building on top of 4.5 and modularize the tech stack, improve SQL integrations and prepare major upcoming features of Hue 5. In particular now:

* Python 3 support can be tested
* There is a new version of [gethue.com](gethue.com) and the content of [docs.gethue.com](https://docs.gethue.com) was revamped
* The new version of the Editor with multi execution contexts and more robustness is 66% done
* Build your own or improve [SQL parsers with highlighter](https://docs.gethue.com/developer/development/#sql-parsers)


This release comes with 650+ commits and 100+ bug fixes! For all the changes, check out the [release notes](https://docs.gethue.com/releases/release-notes-4.6.0/).

Go grab it and give it a spin!

* Docker
    ```
    docker run -it -p 8888:8888 gethue/4.6.0
    ```
* Kubernetes :
    ```
    helm repo add gethue https://helm.gethue.com
    helm repo update
    helm install hue gethue/hue
    ```
* [demo.gethue.com](demo.gethue.com)
* [Tarball](https://cdn.gethue.com/downloads/hue-4.6.0.tgz) or [source](https://github.com/cloudera/hue/archive/release-4.6.0.zip)

<a href="https://cdn.gethue.com/uploads/2019/12/hue4.6.png">
  <img src="https://cdn.gethue.com/uploads/2019/12/hue4.6.png" />
</a>

Here is a selection of the improvements:

## SQL

* Apache Hive Tez improvements
* Apache Hive LLAP improvements
* Apache Atlas [search and catalog information](/realtime-catalog-search-with-hue-and-apache-atlas/) are builtin and pluggable
* Autocompletes
  * Tutorial on how to [improve/create a new SQL parser](https://docs.gethue.com/developer/development/#sql-parsers) with [Highlighter](/how-to-improve-or-add-your-own-sql-syntax-highlighter/)
  * Skeletons of dedicated parsers for Apache Druid, Phoenix, Elastic Serch, Presto, KSQL, Calcite are present
* [Primary Keys, Partition Keys icons showing in the assists](/2019-11-13-sql-column-assist-icons/)
* [SQL Query tracing](/introducing-request-tracing-with-opentracing-and-jaeger-in-kubernetes/)
* Support of [transactional tables](/2019-11-13-sql-column-assist-icons/) in the importer/samples
* [HUE-9055](https://issues.cloudera.org/browse/HUE-9055) INTEGER is introduced as a synonym for INT in 2.2

## Collaboration

* The Sharing icons as well as sharing action are now showing-up in left assistant
* Copy result to Clipboard now properly keeps the table formatting

## Cloud

* 3 blog posts on how to get the basics for:
  * [Tracing calls](/introducing-request-tracing-with-opentracing-and-jaeger-in-kubernetes/)
  * [Retrieving and searching Logs](/collecting-hue-metrics-with-prometheus-in-kubernetes/)
  * [Collecting health and performance Metrics](/collecting-and-querying-hue-logs-with-fluentd-in-kubernetes/)
* Apache Knox and its IdBroker has been integrated
* [Azure ADLS v2 / ABFS v1](/integration-with-microsoft-azure-data-lake-store-gen2/) has been integrated
* Google Storage connector has a skeleton
[HUE-8983](https://issues.cloudera.org/browse/HUE-8983) Handle S3 with ListAllMyBuckets denied

## Infra

* Python 3: support is making progress and now can be beta tested. `py3-ci` [CI branch](https://circleci.com/gh/cloudera/hue/tree/py3-ci), how to compile it and send feedback:
  ```
  export PYTHON_VER=python3.6
  make apps
  ```
* Javascript testing switched to Jest and now supports headless
* [docs.gethue.com](docs.gethue.com) has been revamped
* [HUE-9023](https://issues.cloudera.org/browse/HUE-9023) [core] Logging HTTP requests code and size separately
* Oozie: Coordinator sync action was pushed
* Ko.js has been upgraded to the latest 3.5.1

## Bugs

* The erratic behaviour of the horizontal result scrollbar in the SQL Editor has been fixed
* LDAP sync command parameters fix
* Several Dashboard layout issues and IE 11 support fixes
* [HUE-8727](https://issues.cloudera.org/browse/HUE-8727) Prevent chrome autofill in the assist documents
* [HUE-8983](https://issues.cloudera.org/browse/HUE-8983) Handle s3 with ListAllMyBuckets denied
* Fix multi query statement with 'INVALIDATE METADATA'
* Impala's GRANT & REVOKE syntax have been updated
* Now honoring the previous 'USE database' statement in multi query execution in the SQL editor


Any feedback or question? Feel free to comment here or on the <a href="https://discourse.gethue.com/">Forum</a> and <a href="https://docs.gethue.com/quickstart/">quick start</a> SQL querying!


Onwards!
