## Licensed to Cloudera, Inc. under one
## or more contributor license agreements.  See the NOTICE file
## distributed with this work for additional information
## regarding copyright ownership.  Cloudera, Inc. licenses this file
## to you under the Apache License, Version 2.0 (the
## "License"); you may not use this file except in compliance
## with the License.  You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.


## This is a generated file!

## ==== Impala ====
## 1. Checkout impala from github next to the hue folder
## 2. Run "npm install" inside tools/sql-docs
## 3. Then inside the tools/sql-docs folder run: "node docExtractor.js -c hue -f ../../../impala/docs/ -d impala_langref.ditamap,impala_keydefs.ditamap,impala.ditamap -o ../../desktop/core/src/desktop/static/desktop/docs/impala/ -m ../../desktop/core/src/desktop/templates/sql_doc_index.mako"

## ==== Hive ====
## 1. Extract and save an .epub file from https://cwiki.apache.org/confluence/display/Hive/LanguageManual
## 2. Run "npm install" inside tools/sql-docs
## 3. Then inside the tools/sql-docs folder run: "node hiveExtractor.js --epub /path/to/downloaded/file.epub"


<%def name="sqlDocIndex()">
window.IMPALA_DOC_INDEX = {'topics/impala_langref.xml':'${ static('desktop/docs/impala/topics/impala_langref.json') }','topics/impala_comments.xml':'${ static('desktop/docs/impala/topics/impala_comments.json') }','topics/impala_datatypes.xml':'${ static('desktop/docs/impala/topics/impala_datatypes.json') }','topics/impala_array.xml':'${ static('desktop/docs/impala/topics/impala_array.json') }','topics/impala_bigint.xml':'${ static('desktop/docs/impala/topics/impala_bigint.json') }','topics/impala_boolean.xml':'${ static('desktop/docs/impala/topics/impala_boolean.json') }','topics/impala_char.xml':'${ static('desktop/docs/impala/topics/impala_char.json') }','topics/impala_decimal.xml':'${ static('desktop/docs/impala/topics/impala_decimal.json') }','topics/impala_date.xml':'${ static('desktop/docs/impala/topics/impala_date.json') }','topics/impala_double.xml':'${ static('desktop/docs/impala/topics/impala_double.json') }','topics/impala_float.xml':'${ static('desktop/docs/impala/topics/impala_float.json') }','topics/impala_int.xml':'${ static('desktop/docs/impala/topics/impala_int.json') }','topics/impala_map.xml':'${ static('desktop/docs/impala/topics/impala_map.json') }','topics/impala_real.xml':'${ static('desktop/docs/impala/topics/impala_real.json') }','topics/impala_smallint.xml':'${ static('desktop/docs/impala/topics/impala_smallint.json') }','topics/impala_string.xml':'${ static('desktop/docs/impala/topics/impala_string.json') }','topics/impala_struct.xml':'${ static('desktop/docs/impala/topics/impala_struct.json') }','topics/impala_timestamp.xml':'${ static('desktop/docs/impala/topics/impala_timestamp.json') }','topics/impala_custom_timezones.xml':'${ static('desktop/docs/impala/topics/impala_custom_timezones.json') }','topics/impala_tinyint.xml':'${ static('desktop/docs/impala/topics/impala_tinyint.json') }','topics/impala_varchar.xml':'${ static('desktop/docs/impala/topics/impala_varchar.json') }','topics/impala_complex_types.xml':'${ static('desktop/docs/impala/topics/impala_complex_types.json') }','topics/impala_literals.xml':'${ static('desktop/docs/impala/topics/impala_literals.json') }','topics/impala_operators.xml':'${ static('desktop/docs/impala/topics/impala_operators.json') }','topics/impala_schema_objects.xml':'${ static('desktop/docs/impala/topics/impala_schema_objects.json') }','topics/impala_aliases.xml':'${ static('desktop/docs/impala/topics/impala_aliases.json') }','topics/impala_databases.xml':'${ static('desktop/docs/impala/topics/impala_databases.json') }','topics/impala_data_sources.xml':'${ static('desktop/docs/impala/topics/impala_data_sources.json') }','topics/impala_functions_overview.xml':'${ static('desktop/docs/impala/topics/impala_functions_overview.json') }','topics/impala_identifiers.xml':'${ static('desktop/docs/impala/topics/impala_identifiers.json') }','topics/impala_tables.xml':'${ static('desktop/docs/impala/topics/impala_tables.json') }','topics/impala_views.xml':'${ static('desktop/docs/impala/topics/impala_views.json') }','topics/impala_langref_sql.xml':'${ static('desktop/docs/impala/topics/impala_langref_sql.json') }','topics/impala_ddl.xml':'${ static('desktop/docs/impala/topics/impala_ddl.json') }','topics/impala_dml.xml':'${ static('desktop/docs/impala/topics/impala_dml.json') }','topics/impala_alter_database.xml':'${ static('desktop/docs/impala/topics/impala_alter_database.json') }','topics/impala_alter_table.xml':'${ static('desktop/docs/impala/topics/impala_alter_table.json') }','topics/impala_alter_view.xml':'${ static('desktop/docs/impala/topics/impala_alter_view.json') }','topics/impala_comment.xml':'${ static('desktop/docs/impala/topics/impala_comment.json') }','topics/impala_compute_stats.xml':'${ static('desktop/docs/impala/topics/impala_compute_stats.json') }','topics/impala_create_data_source.xml':'${ static('desktop/docs/impala/topics/impala_create_data_source.json') }','topics/impala_create_database.xml':'${ static('desktop/docs/impala/topics/impala_create_database.json') }','topics/impala_create_function.xml':'${ static('desktop/docs/impala/topics/impala_create_function.json') }','topics/impala_create_role.xml':'${ static('desktop/docs/impala/topics/impala_create_role.json') }','topics/impala_create_table.xml':'${ static('desktop/docs/impala/topics/impala_create_table.json') }','topics/impala_create_view.xml':'${ static('desktop/docs/impala/topics/impala_create_view.json') }','topics/impala_delete.xml':'${ static('desktop/docs/impala/topics/impala_delete.json') }','topics/impala_describe.xml':'${ static('desktop/docs/impala/topics/impala_describe.json') }','topics/impala_drop_data_source.xml':'${ static('desktop/docs/impala/topics/impala_drop_data_source.json') }','topics/impala_drop_database.xml':'${ static('desktop/docs/impala/topics/impala_drop_database.json') }','topics/impala_drop_function.xml':'${ static('desktop/docs/impala/topics/impala_drop_function.json') }','topics/impala_drop_role.xml':'${ static('desktop/docs/impala/topics/impala_drop_role.json') }','topics/impala_drop_stats.xml':'${ static('desktop/docs/impala/topics/impala_drop_stats.json') }','topics/impala_drop_table.xml':'${ static('desktop/docs/impala/topics/impala_drop_table.json') }','topics/impala_drop_view.xml':'${ static('desktop/docs/impala/topics/impala_drop_view.json') }','topics/impala_explain.xml':'${ static('desktop/docs/impala/topics/impala_explain.json') }','topics/impala_grant.xml':'${ static('desktop/docs/impala/topics/impala_grant.json') }','topics/impala_insert.xml':'${ static('desktop/docs/impala/topics/impala_insert.json') }','topics/impala_invalidate_metadata.xml':'${ static('desktop/docs/impala/topics/impala_invalidate_metadata.json') }','topics/impala_load_data.xml':'${ static('desktop/docs/impala/topics/impala_load_data.json') }','topics/impala_refresh.xml':'${ static('desktop/docs/impala/topics/impala_refresh.json') }','topics/impala_refresh_functions.xml':'${ static('desktop/docs/impala/topics/impala_refresh_functions.json') }','topics/impala_revoke.xml':'${ static('desktop/docs/impala/topics/impala_revoke.json') }','topics/impala_select.xml':'${ static('desktop/docs/impala/topics/impala_select.json') }','topics/impala_joins.xml':'${ static('desktop/docs/impala/topics/impala_joins.json') }','topics/impala_order_by.xml':'${ static('desktop/docs/impala/topics/impala_order_by.json') }','topics/impala_group_by.xml':'${ static('desktop/docs/impala/topics/impala_group_by.json') }','topics/impala_having.xml':'${ static('desktop/docs/impala/topics/impala_having.json') }','topics/impala_limit.xml':'${ static('desktop/docs/impala/topics/impala_limit.json') }','topics/impala_offset.xml':'${ static('desktop/docs/impala/topics/impala_offset.json') }','topics/impala_union.xml':'${ static('desktop/docs/impala/topics/impala_union.json') }','topics/impala_subqueries.xml':'${ static('desktop/docs/impala/topics/impala_subqueries.json') }','topics/impala_tablesample.xml':'${ static('desktop/docs/impala/topics/impala_tablesample.json') }','topics/impala_with.xml':'${ static('desktop/docs/impala/topics/impala_with.json') }','topics/impala_distinct.xml':'${ static('desktop/docs/impala/topics/impala_distinct.json') }','topics/impala_set.xml':'${ static('desktop/docs/impala/topics/impala_set.json') }','topics/impala_query_options.xml':'${ static('desktop/docs/impala/topics/impala_query_options.json') }','topics/impala_abort_on_error.xml':'${ static('desktop/docs/impala/topics/impala_abort_on_error.json') }','topics/impala_allow_erasure_coded_files.xml':'${ static('desktop/docs/impala/topics/impala_allow_erasure_coded_files.json') }','topics/impala_allow_unsupported_formats.xml':'${ static('desktop/docs/impala/topics/impala_allow_unsupported_formats.json') }','topics/impala_appx_count_distinct.xml':'${ static('desktop/docs/impala/topics/impala_appx_count_distinct.json') }','topics/impala_batch_size.xml':'${ static('desktop/docs/impala/topics/impala_batch_size.json') }','topics/impala_buffer_pool_limit.xml':'${ static('desktop/docs/impala/topics/impala_buffer_pool_limit.json') }','topics/impala_compression_codec.xml':'${ static('desktop/docs/impala/topics/impala_compression_codec.json') }','topics/impala_compute_stats_min_sample_size.xml':'${ static('desktop/docs/impala/topics/impala_compute_stats_min_sample_size.json') }','topics/impala_debug_action.xml':'${ static('desktop/docs/impala/topics/impala_debug_action.json') }','topics/impala_decimal_v2.xml':'${ static('desktop/docs/impala/topics/impala_decimal_v2.json') }','topics/impala_default_join_distribution_mode.xml':'${ static('desktop/docs/impala/topics/impala_default_join_distribution_mode.json') }','topics/impala_default_spillable_buffer_size.xml':'${ static('desktop/docs/impala/topics/impala_default_spillable_buffer_size.json') }','topics/impala_disable_codegen.xml':'${ static('desktop/docs/impala/topics/impala_disable_codegen.json') }','topics/impala_disable_codegen_rows_threshold.xml':'${ static('desktop/docs/impala/topics/impala_disable_codegen_rows_threshold.json') }','topics/impala_disable_outermost_topn.xml':'${ static('desktop/docs/impala/topics/impala_disable_outermost_topn.json') }','topics/impala_disable_row_runtime_filtering.xml':'${ static('desktop/docs/impala/topics/impala_disable_row_runtime_filtering.json') }','topics/impala_disable_streaming_preaggregations.xml':'${ static('desktop/docs/impala/topics/impala_disable_streaming_preaggregations.json') }','topics/impala_disable_unsafe_spills.xml':'${ static('desktop/docs/impala/topics/impala_disable_unsafe_spills.json') }','topics/impala_enable_expr_rewrites.xml':'${ static('desktop/docs/impala/topics/impala_enable_expr_rewrites.json') }','topics/impala_exec_single_node_rows_threshold.xml':'${ static('desktop/docs/impala/topics/impala_exec_single_node_rows_threshold.json') }','topics/impala_exec_time_limit_s.xml':'${ static('desktop/docs/impala/topics/impala_exec_time_limit_s.json') }','topics/impala_explain_level.xml':'${ static('desktop/docs/impala/topics/impala_explain_level.json') }','topics/impala_hbase_cache_blocks.xml':'${ static('desktop/docs/impala/topics/impala_hbase_cache_blocks.json') }','topics/impala_hbase_caching.xml':'${ static('desktop/docs/impala/topics/impala_hbase_caching.json') }','topics/impala_idle_session_timeout.xml':'${ static('desktop/docs/impala/topics/impala_idle_session_timeout.json') }','topics/impala_kudu_read_mode.xml':'${ static('desktop/docs/impala/topics/impala_kudu_read_mode.json') }','topics/impala_live_progress.xml':'${ static('desktop/docs/impala/topics/impala_live_progress.json') }','topics/impala_live_summary.xml':'${ static('desktop/docs/impala/topics/impala_live_summary.json') }','topics/impala_max_errors.xml':'${ static('desktop/docs/impala/topics/impala_max_errors.json') }','topics/impala_max_mem_estimate_for_admission.xml':'${ static('desktop/docs/impala/topics/impala_max_mem_estimate_for_admission.json') }','topics/impala_max_row_size.xml':'${ static('desktop/docs/impala/topics/impala_max_row_size.json') }','topics/impala_max_num_runtime_filters.xml':'${ static('desktop/docs/impala/topics/impala_max_num_runtime_filters.json') }','topics/impala_max_scan_range_length.xml':'${ static('desktop/docs/impala/topics/impala_max_scan_range_length.json') }','topics/impala_mem_limit.xml':'${ static('desktop/docs/impala/topics/impala_mem_limit.json') }','topics/impala_min_spillable_buffer_size.xml':'${ static('desktop/docs/impala/topics/impala_min_spillable_buffer_size.json') }','topics/impala_mt_dop.xml':'${ static('desktop/docs/impala/topics/impala_mt_dop.json') }','topics/impala_num_nodes.xml':'${ static('desktop/docs/impala/topics/impala_num_nodes.json') }','topics/impala_num_scanner_threads.xml':'${ static('desktop/docs/impala/topics/impala_num_scanner_threads.json') }','topics/impala_optimize_partition_key_scans.xml':'${ static('desktop/docs/impala/topics/impala_optimize_partition_key_scans.json') }','topics/impala_parquet_compression_codec.xml':'${ static('desktop/docs/impala/topics/impala_parquet_compression_codec.json') }','topics/impala_parquet_annotate_strings_utf8.xml':'${ static('desktop/docs/impala/topics/impala_parquet_annotate_strings_utf8.json') }','topics/impala_parquet_array_resolution.xml':'${ static('desktop/docs/impala/topics/impala_parquet_array_resolution.json') }','topics/impala_parquet_dictionary_filtering.xml':'${ static('desktop/docs/impala/topics/impala_parquet_dictionary_filtering.json') }','topics/impala_parquet_fallback_schema_resolution.xml':'${ static('desktop/docs/impala/topics/impala_parquet_fallback_schema_resolution.json') }','topics/impala_parquet_file_size.xml':'${ static('desktop/docs/impala/topics/impala_parquet_file_size.json') }','topics/impala_parquet_read_statistics.xml':'${ static('desktop/docs/impala/topics/impala_parquet_read_statistics.json') }','topics/impala_prefetch_mode.xml':'${ static('desktop/docs/impala/topics/impala_prefetch_mode.json') }','topics/impala_query_timeout_s.xml':'${ static('desktop/docs/impala/topics/impala_query_timeout_s.json') }','topics/impala_request_pool.xml':'${ static('desktop/docs/impala/topics/impala_request_pool.json') }','topics/impala_replica_preference.xml':'${ static('desktop/docs/impala/topics/impala_replica_preference.json') }','topics/impala_runtime_bloom_filter_size.xml':'${ static('desktop/docs/impala/topics/impala_runtime_bloom_filter_size.json') }','topics/impala_runtime_filter_max_size.xml':'${ static('desktop/docs/impala/topics/impala_runtime_filter_max_size.json') }','topics/impala_runtime_filter_min_size.xml':'${ static('desktop/docs/impala/topics/impala_runtime_filter_min_size.json') }','topics/impala_runtime_filter_mode.xml':'${ static('desktop/docs/impala/topics/impala_runtime_filter_mode.json') }','topics/impala_runtime_filter_wait_time_ms.xml':'${ static('desktop/docs/impala/topics/impala_runtime_filter_wait_time_ms.json') }','topics/impala_s3_skip_insert_staging.xml':'${ static('desktop/docs/impala/topics/impala_s3_skip_insert_staging.json') }','topics/impala_scan_bytes_limit.xml':'${ static('desktop/docs/impala/topics/impala_scan_bytes_limit.json') }','topics/impala_schedule_random_replica.xml':'${ static('desktop/docs/impala/topics/impala_schedule_random_replica.json') }','topics/impala_scratch_limit.xml':'${ static('desktop/docs/impala/topics/impala_scratch_limit.json') }','topics/impala_shuffle_distinct_exprs.xml':'${ static('desktop/docs/impala/topics/impala_shuffle_distinct_exprs.json') }','topics/impala_support_start_over.xml':'${ static('desktop/docs/impala/topics/impala_support_start_over.json') }','topics/impala_sync_ddl.xml':'${ static('desktop/docs/impala/topics/impala_sync_ddl.json') }','topics/impala_thread_reservation_aggregate_limit.xml':'${ static('desktop/docs/impala/topics/impala_thread_reservation_aggregate_limit.json') }','topics/impala_thread_reservation_limit.xml':'${ static('desktop/docs/impala/topics/impala_thread_reservation_limit.json') }','topics/impala_timezone.xml':'${ static('desktop/docs/impala/topics/impala_timezone.json') }','topics/impala_topn_bytes_limit.xml':'${ static('desktop/docs/impala/topics/impala_topn_bytes_limit.json') }','topics/impala_show.xml':'${ static('desktop/docs/impala/topics/impala_show.json') }','topics/impala_shutdown.xml':'${ static('desktop/docs/impala/topics/impala_shutdown.json') }','topics/impala_truncate_table.xml':'${ static('desktop/docs/impala/topics/impala_truncate_table.json') }','topics/impala_update.xml':'${ static('desktop/docs/impala/topics/impala_update.json') }','topics/impala_upsert.xml':'${ static('desktop/docs/impala/topics/impala_upsert.json') }','topics/impala_use.xml':'${ static('desktop/docs/impala/topics/impala_use.json') }','topics/impala_hints.xml':'${ static('desktop/docs/impala/topics/impala_hints.json') }','topics/impala_functions.xml':'${ static('desktop/docs/impala/topics/impala_functions.json') }','topics/impala_math_functions.xml':'${ static('desktop/docs/impala/topics/impala_math_functions.json') }','topics/impala_bit_functions.xml':'${ static('desktop/docs/impala/topics/impala_bit_functions.json') }','topics/impala_conversion_functions.xml':'${ static('desktop/docs/impala/topics/impala_conversion_functions.json') }','topics/impala_datetime_functions.xml':'${ static('desktop/docs/impala/topics/impala_datetime_functions.json') }','topics/impala_conditional_functions.xml':'${ static('desktop/docs/impala/topics/impala_conditional_functions.json') }','topics/impala_string_functions.xml':'${ static('desktop/docs/impala/topics/impala_string_functions.json') }','topics/impala_misc_functions.xml':'${ static('desktop/docs/impala/topics/impala_misc_functions.json') }','topics/impala_aggregate_functions.xml':'${ static('desktop/docs/impala/topics/impala_aggregate_functions.json') }','topics/impala_appx_median.xml':'${ static('desktop/docs/impala/topics/impala_appx_median.json') }','topics/impala_avg.xml':'${ static('desktop/docs/impala/topics/impala_avg.json') }','topics/impala_count.xml':'${ static('desktop/docs/impala/topics/impala_count.json') }','topics/impala_group_concat.xml':'${ static('desktop/docs/impala/topics/impala_group_concat.json') }','topics/impala_max.xml':'${ static('desktop/docs/impala/topics/impala_max.json') }','topics/impala_min.xml':'${ static('desktop/docs/impala/topics/impala_min.json') }','topics/impala_ndv.xml':'${ static('desktop/docs/impala/topics/impala_ndv.json') }','topics/impala_stddev.xml':'${ static('desktop/docs/impala/topics/impala_stddev.json') }','topics/impala_sum.xml':'${ static('desktop/docs/impala/topics/impala_sum.json') }','topics/impala_variance.xml':'${ static('desktop/docs/impala/topics/impala_variance.json') }','topics/impala_analytic_functions.xml':'${ static('desktop/docs/impala/topics/impala_analytic_functions.json') }','topics/impala_udf.xml':'${ static('desktop/docs/impala/topics/impala_udf.json') }','topics/impala_langref_unsupported.xml':'${ static('desktop/docs/impala/topics/impala_langref_unsupported.json') }','topics/impala_porting.xml':'${ static('desktop/docs/impala/topics/impala_porting.json') }'};
window.HIVE_DOC_INDEX = {'_27362030':'${ static('desktop/docs/hive/_27362030.json') }','_27362033':'${ static('desktop/docs/hive/_27362033.json') }','_27362034':'${ static('desktop/docs/hive/_27362034.json') }','_27362035':'${ static('desktop/docs/hive/_27362035.json') }','_95654003':'${ static('desktop/docs/hive/_95654003.json') }','_145724128':'${ static('desktop/docs/hive/_145724128.json') }','_30755801':'${ static('desktop/docs/hive/_30755801.json') }','_27362036':'${ static('desktop/docs/hive/_27362036.json') }','_27362043':'${ static('desktop/docs/hive/_27362043.json') }','_38572242':'${ static('desktop/docs/hive/_38572242.json') }','_103092177':'${ static('desktop/docs/hive/_103092177.json') }','_27362039':'${ static('desktop/docs/hive/_27362039.json') }','_27362040':'${ static('desktop/docs/hive/_27362040.json') }','_27362049':'${ static('desktop/docs/hive/_27362049.json') }','_27362044':'${ static('desktop/docs/hive/_27362044.json') }','_27362042':'${ static('desktop/docs/hive/_27362042.json') }','_27362037':'${ static('desktop/docs/hive/_27362037.json') }','_27362048':'${ static('desktop/docs/hive/_27362048.json') }','_27842758':'${ static('desktop/docs/hive/_27842758.json') }','_27837968':'${ static('desktop/docs/hive/_27837968.json') }','_27362032':'${ static('desktop/docs/hive/_27362032.json') }','_45876440':'${ static('desktop/docs/hive/_45876440.json') }','_40509928':'${ static('desktop/docs/hive/_40509928.json') }','_45876173':'${ static('desktop/docs/hive/_45876173.json') }','_27838462':'${ static('desktop/docs/hive/_27838462.json') }','_122917025':'${ static('desktop/docs/hive/_122917025.json') }','_27829682':'${ static('desktop/docs/hive/_27829682.json') }','_30754722':'${ static('desktop/docs/hive/_30754722.json') }','_31818911':'${ static('desktop/docs/hive/_31818911.json') }','_31819589':'${ static('desktop/docs/hive/_31819589.json') }','_31822176':'${ static('desktop/docs/hive/_31822176.json') }','_33293167':'${ static('desktop/docs/hive/_33293167.json') }','_33298193':'${ static('desktop/docs/hive/_33298193.json') }','_34838882':'${ static('desktop/docs/hive/_34838882.json') }','_38570914':'${ static('desktop/docs/hive/_38570914.json') }','_30151323':'${ static('desktop/docs/hive/_30151323.json') }','_47384180':'${ static('desktop/docs/hive/_47384180.json') }','_58851803':'${ static('desktop/docs/hive/_58851803.json') }','_59690156':'${ static('desktop/docs/hive/_59690156.json') }'};
</%def>
<%def name="sqlDocTopLevel()">
window.IMPALA_DOC_TOP_LEVEL = [{title:'Impala SQL Language Reference',ref:'topics/impala_langref.xml',children:[]},{title:'Comments',ref:'topics/impala_comments.xml',children:[]},{title:'Data Types',ref:'topics/impala_datatypes.xml',children:[{title:'ARRAY Complex Type (Impala 2.3 or higher only)',ref:'topics/impala_array.xml',children:[]},{title:'BIGINT Data Type',ref:'topics/impala_bigint.xml',children:[]},{title:'BOOLEAN Data Type',ref:'topics/impala_boolean.xml',children:[]},{title:'CHAR Data Type (Impala 2.0 or higher only)',ref:'topics/impala_char.xml',children:[]},{title:'DECIMAL Data Type (Impala 3.0 or higher only)',ref:'topics/impala_decimal.xml',children:[]},{title:'DATE Data Type (Impala 2.1 or higher only)',ref:'topics/impala_date.xml',children:[]},{title:'DOUBLE Data Type',ref:'topics/impala_double.xml',children:[]},{title:'FLOAT Data Type',ref:'topics/impala_float.xml',children:[]},{title:'INT Data Type',ref:'topics/impala_int.xml',children:[]},{title:'MAP Complex Type (Impala 2.3 or higher only)',ref:'topics/impala_map.xml',children:[]},{title:'REAL Data Type',ref:'topics/impala_real.xml',children:[]},{title:'SMALLINT Data Type',ref:'topics/impala_smallint.xml',children:[]},{title:'STRING Data Type',ref:'topics/impala_string.xml',children:[]},{title:'STRUCT Complex Type (Impala 2.3 or higher only)',ref:'topics/impala_struct.xml',children:[]},{title:'TIMESTAMP Data Type',ref:'topics/impala_timestamp.xml',children:[{title:'Customizing Time Zones',ref:'topics/impala_custom_timezones.xml',children:[]}]},{title:'TINYINT Data Type',ref:'topics/impala_tinyint.xml',children:[]},{title:'VARCHAR Data Type (Impala 2.0 or higher only)',ref:'topics/impala_varchar.xml',children:[]},{title:'Complex Types (Impala 2.3 or higher only)',ref:'topics/impala_complex_types.xml',children:[]}]},{title:'Literals',ref:'topics/impala_literals.xml',children:[]},{title:'SQL Operators',ref:'topics/impala_operators.xml',children:[]},{title:'Impala Schema Objects and Object Names',ref:'topics/impala_schema_objects.xml',children:[{title:'Overview of Impala Aliases',ref:'topics/impala_aliases.xml',children:[]},{title:'Overview of Impala Databases',ref:'topics/impala_databases.xml',children:[]},{title:'Data Sources',ref:'topics/impala_data_sources.xml',children:[]},{title:'Overview of Impala Functions',ref:'topics/impala_functions_overview.xml',children:[]},{title:'Overview of Impala Identifiers',ref:'topics/impala_identifiers.xml',children:[]},{title:'Overview of Impala Tables',ref:'topics/impala_tables.xml',children:[]},{title:'Overview of Impala Views',ref:'topics/impala_views.xml',children:[]}]},{title:'Impala SQL Statements',ref:'topics/impala_langref_sql.xml',children:[{title:'DDL Statements',ref:'topics/impala_ddl.xml',children:[]},{title:'DML Statements',ref:'topics/impala_dml.xml',children:[]},{title:'ALTER DATABASE Statement',ref:'topics/impala_alter_database.xml',children:[]},{title:'ALTER TABLE Statement',ref:'topics/impala_alter_table.xml',children:[]},{title:'ALTER VIEW Statement',ref:'topics/impala_alter_view.xml',children:[]},{title:'COMMENT Statement',ref:'topics/impala_comment.xml',children:[]},{title:'COMPUTE STATS Statement',ref:'topics/impala_compute_stats.xml',children:[]},{title:'CREATE DATA SOURCE Statement',ref:'topics/impala_create_data_source.xml',children:[]},{title:'CREATE DATABASE Statement',ref:'topics/impala_create_database.xml',children:[]},{title:'CREATE FUNCTION Statement',ref:'topics/impala_create_function.xml',children:[]},{title:'CREATE ROLE Statement (Impala 2.0 or higher only)',ref:'topics/impala_create_role.xml',children:[]},{title:'CREATE TABLE Statement',ref:'topics/impala_create_table.xml',children:[]},{title:'CREATE VIEW Statement',ref:'topics/impala_create_view.xml',children:[]},{title:'DELETE Statement (Impala 2.8 or higher only)',ref:'topics/impala_delete.xml',children:[]},{title:'DESCRIBE Statement',ref:'topics/impala_describe.xml',children:[]},{title:'DROP DATA SOURCE Statement',ref:'topics/impala_drop_data_source.xml',children:[]},{title:'DROP DATABASE Statement',ref:'topics/impala_drop_database.xml',children:[]},{title:'DROP FUNCTION Statement',ref:'topics/impala_drop_function.xml',children:[]},{title:'DROP ROLE Statement (Impala 2.0 or higher only)',ref:'topics/impala_drop_role.xml',children:[]},{title:'DROP STATS Statement',ref:'topics/impala_drop_stats.xml',children:[]},{title:'DROP TABLE Statement',ref:'topics/impala_drop_table.xml',children:[]},{title:'DROP VIEW Statement',ref:'topics/impala_drop_view.xml',children:[]},{title:'EXPLAIN Statement',ref:'topics/impala_explain.xml',children:[]},{title:'GRANT Statement (Impala 2.0 or higher only)',ref:'topics/impala_grant.xml',children:[]},{title:'INSERT Statement',ref:'topics/impala_insert.xml',children:[]},{title:'INVALIDATE METADATA Statement',ref:'topics/impala_invalidate_metadata.xml',children:[]},{title:'LOAD DATA Statement',ref:'topics/impala_load_data.xml',children:[]},{title:'REFRESH Statement',ref:'topics/impala_refresh.xml',children:[]},{title:'REFRESH FUNCTIONS Statement',ref:'topics/impala_refresh_functions.xml',children:[]},{title:'REVOKE Statement (Impala 2.0 or higher only)',ref:'topics/impala_revoke.xml',children:[]},{title:'SELECT Statement',ref:'topics/impala_select.xml',children:[{title:'Joins in Impala SELECT Statements',ref:'topics/impala_joins.xml',children:[]},{title:'ORDER BY Clause',ref:'topics/impala_order_by.xml',children:[]},{title:'GROUP BY Clause',ref:'topics/impala_group_by.xml',children:[]},{title:'HAVING Clause',ref:'topics/impala_having.xml',children:[]},{title:'LIMIT Clause',ref:'topics/impala_limit.xml',children:[]},{title:'OFFSET Clause',ref:'topics/impala_offset.xml',children:[]},{title:'UNION Clause',ref:'topics/impala_union.xml',children:[]},{title:'Subqueries in Impala SELECT Statements',ref:'topics/impala_subqueries.xml',children:[]},{title:'TABLESAMPLE Clause',ref:'topics/impala_tablesample.xml',children:[]},{title:'WITH Clause',ref:'topics/impala_with.xml',children:[]},{title:'DISTINCT Operator',ref:'topics/impala_distinct.xml',children:[]}]},{title:'SET Statement',ref:'topics/impala_set.xml',children:[{title:'Query Options for the SET Statement',ref:'topics/impala_query_options.xml',children:[{title:'ABORT_ON_ERROR Query Option',ref:'topics/impala_abort_on_error.xml',children:[]},{title:'ALLOW_ERASURE_CODED_FILES Query Option',ref:'topics/impala_allow_erasure_coded_files.xml',children:[]},{title:'ALLOW_UNSUPPORTED_FORMATS Query Option',ref:'topics/impala_allow_unsupported_formats.xml',children:[]},{title:'APPX_COUNT_DISTINCT Query Option (Impala 2.0 or higher only)',ref:'topics/impala_appx_count_distinct.xml',children:[]},{title:'BATCH_SIZE Query Option',ref:'topics/impala_batch_size.xml',children:[]},{title:'BUFFER_POOL_LIMIT Query Option',ref:'topics/impala_buffer_pool_limit.xml',children:[]},{title:'COMPRESSION_CODEC Query Option (Impala 2.0 or higher only)',ref:'topics/impala_compression_codec.xml',children:[]},{title:'COMPUTE_STATS_MIN_SAMPLE_SIZE Query Option',ref:'topics/impala_compute_stats_min_sample_size.xml',children:[]},{title:'DEBUG_ACTION Query Option',ref:'topics/impala_debug_action.xml',children:[]},{title:'DECIMAL_V2 Query Option',ref:'topics/impala_decimal_v2.xml',children:[]},{title:'DEFAULT_JOIN_DISTRIBUTION_MODE Query Option',ref:'topics/impala_default_join_distribution_mode.xml',children:[]},{title:'DEFAULT_SPILLABLE_BUFFER_SIZE Query Option',ref:'topics/impala_default_spillable_buffer_size.xml',children:[]},{title:'DISABLE_CODEGEN Query Option',ref:'topics/impala_disable_codegen.xml',children:[]},{title:'DISABLE_CODEGEN_ROWS_THRESHOLD Query Option (Impala 2.10 or higher only)',ref:'topics/impala_disable_codegen_rows_threshold.xml',children:[]},{title:'DISABLE_OUTERMOST_TOPN Query Option',ref:'topics/impala_disable_outermost_topn.xml',children:[]},{title:'DISABLE_ROW_RUNTIME_FILTERING Query Option (Impala 2.5 or higher only)',ref:'topics/impala_disable_row_runtime_filtering.xml',children:[]},{title:'DISABLE_STREAMING_PREAGGREGATIONS Query Option (Impala 2.5 or higher only)',ref:'topics/impala_disable_streaming_preaggregations.xml',children:[]},{title:'DISABLE_UNSAFE_SPILLS Query Option (Impala 2.0 or higher only)',ref:'topics/impala_disable_unsafe_spills.xml',children:[]},{title:'ENABLE_EXPR_REWRITES Query Option',ref:'topics/impala_enable_expr_rewrites.xml',children:[]},{title:'EXEC_SINGLE_NODE_ROWS_THRESHOLD Query Option (Impala 2.1 or higher only)',ref:'topics/impala_exec_single_node_rows_threshold.xml',children:[]},{title:'EXEC_TIME_LIMIT_S Query Option (Impala 2.12 or higher only)',ref:'topics/impala_exec_time_limit_s.xml',children:[]},{title:'EXPLAIN_LEVEL Query Option',ref:'topics/impala_explain_level.xml',children:[]},{title:'HBASE_CACHE_BLOCKS Query Option',ref:'topics/impala_hbase_cache_blocks.xml',children:[]},{title:'HBASE_CACHING Query Option',ref:'topics/impala_hbase_caching.xml',children:[]},{title:'IDLE_SESSION_TIMEOUT Query Option (Impala 2.12 or higher only)',ref:'topics/impala_idle_session_timeout.xml',children:[]},{title:'KUDU_READ_MODE Query Option (Impala 3.1 or higher only)',ref:'topics/impala_kudu_read_mode.xml',children:[]},{title:'LIVE_PROGRESS Query Option (Impala 2.3 or higher only)',ref:'topics/impala_live_progress.xml',children:[]},{title:'LIVE_SUMMARY Query Option (Impala 2.3 or higher only)',ref:'topics/impala_live_summary.xml',children:[]},{title:'MAX_ERRORS Query Option',ref:'topics/impala_max_errors.xml',children:[]},{title:'MAX_MEM_ESTIMATE_FOR_ADMISSION Query Option',ref:'topics/impala_max_mem_estimate_for_admission.xml',children:[]},{title:'MAX_ROW_SIZE Query Option',ref:'topics/impala_max_row_size.xml',children:[]},{title:'MAX_NUM_RUNTIME_FILTERS Query Option (Impala 2.5 or higher only)',ref:'topics/impala_max_num_runtime_filters.xml',children:[]},{title:'MAX_SCAN_RANGE_LENGTH Query Option',ref:'topics/impala_max_scan_range_length.xml',children:[]},{title:'MEM_LIMIT Query Option',ref:'topics/impala_mem_limit.xml',children:[]},{title:'MIN_SPILLABLE_BUFFER_SIZE Query Option',ref:'topics/impala_min_spillable_buffer_size.xml',children:[]},{title:'MT_DOP Query Option',ref:'topics/impala_mt_dop.xml',children:[]},{title:'NUM_NODES Query Option',ref:'topics/impala_num_nodes.xml',children:[]},{title:'NUM_SCANNER_THREADS Query Option',ref:'topics/impala_num_scanner_threads.xml',children:[]},{title:'OPTIMIZE_PARTITION_KEY_SCANS Query Option (Impala 2.5 or higher only)',ref:'topics/impala_optimize_partition_key_scans.xml',children:[]},{title:'PARQUET_COMPRESSION_CODEC Query Option',ref:'topics/impala_parquet_compression_codec.xml',children:[]},{title:'PARQUET_ANNOTATE_STRINGS_UTF8 Query Option (Impala 2.6 or higher only)',ref:'topics/impala_parquet_annotate_strings_utf8.xml',children:[]},{title:'PARQUET_ARRAY_RESOLUTION Query Option (Impala 2.9 or higher only)',ref:'topics/impala_parquet_array_resolution.xml',children:[]},{title:'PARQUET_DICTIONARY_FILTERING Query Option (Impala 2.9 or higher only)',ref:'topics/impala_parquet_dictionary_filtering.xml',children:[]},{title:'PARQUET_FALLBACK_SCHEMA_RESOLUTION Query Option (Impala 2.6 or higher only)',ref:'topics/impala_parquet_fallback_schema_resolution.xml',children:[]},{title:'PARQUET_FILE_SIZE Query Option',ref:'topics/impala_parquet_file_size.xml',children:[]},{title:'PARQUET_READ_STATISTICS Query Option (Impala 2.9 or higher only)',ref:'topics/impala_parquet_read_statistics.xml',children:[]},{title:'PREFETCH_MODE Query Option (Impala 2.6 or higher only)',ref:'topics/impala_prefetch_mode.xml',children:[]},{title:'QUERY_TIMEOUT_S Query Option (Impala 2.0 or higher only)',ref:'topics/impala_query_timeout_s.xml',children:[]},{title:'REQUEST_POOL Query Option',ref:'topics/impala_request_pool.xml',children:[]},{title:'REPLICA_PREFERENCE Query Option (Impala 2.7 or higher only)',ref:'topics/impala_replica_preference.xml',children:[]},{title:'RUNTIME_BLOOM_FILTER_SIZE Query Option (Impala 2.5 or higher only)',ref:'topics/impala_runtime_bloom_filter_size.xml',children:[]},{title:'RUNTIME_FILTER_MAX_SIZE Query Option (Impala 2.6 or higher only)',ref:'topics/impala_runtime_filter_max_size.xml',children:[]},{title:'RUNTIME_FILTER_MIN_SIZE Query Option (Impala 2.6 or higher only)',ref:'topics/impala_runtime_filter_min_size.xml',children:[]},{title:'RUNTIME_FILTER_MODE Query Option (Impala 2.5 or higher only)',ref:'topics/impala_runtime_filter_mode.xml',children:[]},{title:'RUNTIME_FILTER_WAIT_TIME_MS Query Option (Impala 2.5 or higher only)',ref:'topics/impala_runtime_filter_wait_time_ms.xml',children:[]},{title:'S3_SKIP_INSERT_STAGING Query Option (Impala 2.6 or higher only)',ref:'topics/impala_s3_skip_insert_staging.xml',children:[]},{title:'SCAN_BYTES_LIMIT Query Option (Impala 3.1 or higher only)',ref:'topics/impala_scan_bytes_limit.xml',children:[]},{title:'SCHEDULE_RANDOM_REPLICA Query Option (Impala 2.5 or higher only)',ref:'topics/impala_schedule_random_replica.xml',children:[]},{title:'SCRATCH_LIMIT Query Option',ref:'topics/impala_scratch_limit.xml',children:[]},{title:'SHUFFLE_DISTINCT_EXPRS Query Option',ref:'topics/impala_shuffle_distinct_exprs.xml',children:[]},{title:'SUPPORT_START_OVER Query Option',ref:'topics/impala_support_start_over.xml',children:[]},{title:'SYNC_DDL Query Option',ref:'topics/impala_sync_ddl.xml',children:[]},{title:'THREAD_RESERVATION_AGGREGATE_LIMIT Query Option (Impala 3.1 or higher only)',ref:'topics/impala_thread_reservation_aggregate_limit.xml',children:[]},{title:'THREAD_RESERVATION_LIMIT Query Option (Impala 3.1 or higher only)',ref:'topics/impala_thread_reservation_limit.xml',children:[]},{title:'TIMEZONE Query Option (Impala 3.1 or higher only)',ref:'topics/impala_timezone.xml',children:[]},{title:'TOPN_BYTES_LIMIT Query Option (Impala 3.1 or higher only)',ref:'topics/impala_topn_bytes_limit.xml',children:[]}]}]},{title:'SHOW Statement',ref:'topics/impala_show.xml',children:[]},{title:'SHUTDOWN Statement',ref:'topics/impala_shutdown.xml',children:[]},{title:'TRUNCATE TABLE Statement (Impala 2.3 or higher only)',ref:'topics/impala_truncate_table.xml',children:[]},{title:'UPDATE Statement (Impala 2.8 or higher only)',ref:'topics/impala_update.xml',children:[]},{title:'UPSERT Statement (Impala 2.8 or higher only)',ref:'topics/impala_upsert.xml',children:[]},{title:'USE Statement',ref:'topics/impala_use.xml',children:[]},{title:'Optimizer Hints',ref:'topics/impala_hints.xml',children:[]}]},{title:'Impala Built-In Functions',ref:'topics/impala_functions.xml',children:[{title:'Impala Mathematical Functions',ref:'topics/impala_math_functions.xml',children:[]},{title:'Impala Bit Functions',ref:'topics/impala_bit_functions.xml',children:[]},{title:'Impala Type Conversion Functions',ref:'topics/impala_conversion_functions.xml',children:[]},{title:'Impala Date and Time Functions',ref:'topics/impala_datetime_functions.xml',children:[]},{title:'Impala Conditional Functions',ref:'topics/impala_conditional_functions.xml',children:[]},{title:'Impala String Functions',ref:'topics/impala_string_functions.xml',children:[]},{title:'Impala Miscellaneous Functions',ref:'topics/impala_misc_functions.xml',children:[]},{title:'Impala Aggregate Functions',ref:'topics/impala_aggregate_functions.xml',children:[{title:'APPX_MEDIAN Function',ref:'topics/impala_appx_median.xml',children:[]},{title:'AVG Function',ref:'topics/impala_avg.xml',children:[]},{title:'COUNT Function',ref:'topics/impala_count.xml',children:[]},{title:'GROUP_CONCAT Function',ref:'topics/impala_group_concat.xml',children:[]},{title:'MAX Function',ref:'topics/impala_max.xml',children:[]},{title:'MIN Function',ref:'topics/impala_min.xml',children:[]},{title:'NDV Function',ref:'topics/impala_ndv.xml',children:[]},{title:'STDDEV, STDDEV_SAMP, STDDEV_POP Functions',ref:'topics/impala_stddev.xml',children:[]},{title:'SUM Function',ref:'topics/impala_sum.xml',children:[]},{title:'VARIANCE, VARIANCE_SAMP, VARIANCE_POP, VAR_SAMP, VAR_POP Functions',ref:'topics/impala_variance.xml',children:[]}]},{title:'Impala Analytic Functions',ref:'topics/impala_analytic_functions.xml',children:[]},{title:'User-Defined Functions (UDFs)',ref:'topics/impala_udf.xml',children:[]}]},{title:'SQL Differences Between Impala and Hive',ref:'topics/impala_langref_unsupported.xml',children:[]},{title:'Porting SQL from Other Database Systems to Impala',ref:'topics/impala_porting.xml',children:[]}];
window.HIVE_DOC_TOP_LEVEL = [{title:'LanguageManual',ref:'_27362030',children:[]},{title:'Cli',ref:'_27362033',children:[]},{title:'DDL',ref:'_27362034',children:[{title:'DDL BucketedTables',ref:'_27362035',children:[]},{title:'Managed vs. External Tables',ref:'_95654003',children:[]},{title:'Scheduled Queries',ref:'_145724128',children:[]},{title:'Exchange Partition',ref:'_30755801',children:[]}]},{title:'DML',ref:'_27362036',children:[]},{title:'Select',ref:'_27362043',children:[{title:'Common Table Expression',ref:'_38572242',children:[]},{title:'Partition Filter Syntax',ref:'_103092177',children:[]}]},{title:'Joins',ref:'_27362039',children:[]},{title:'LateralView',ref:'_27362040',children:[]},{title:'Union',ref:'_27362049',children:[]},{title:'SubQueries',ref:'_27362044',children:[]},{title:'Sampling',ref:'_27362042',children:[]},{title:'Explain',ref:'_27362037',children:[]},{title:'VirtualColumns',ref:'_27362048',children:[]},{title:'Configuration Properties',ref:'_27842758',children:[]},{title:'ImportExport',ref:'_27837968',children:[]},{title:'Authorization',ref:'_27362032',children:[{title:'Storage Based Authorization in the Metastore Server',ref:'_45876440',children:[]},{title:'SQL Standard Based Hive Authorization',ref:'_40509928',children:[]},{title:'Hive deprecated authorization mode / Legacy Mode',ref:'_45876173',children:[]}]},{title:'Types',ref:'_27838462',children:[{title:'CAST...FORMAT with SQL:2016 datetime formats',ref:'_122917025',children:[]}]},{title:'Literals',ref:'_27829682',children:[]},{title:'VariableSubstitution',ref:'_30754722',children:[]},{title:'ORC',ref:'_31818911',children:[]},{title:'WindowingAndAnalytics',ref:'_31819589',children:[]},{title:'Indexing',ref:'_31822176',children:[]},{title:'JoinOptimization',ref:'_33293167',children:[]},{title:'LZO',ref:'_33298193',children:[]},{title:'Commands',ref:'_34838882',children:[]},{title:'Parquet',ref:'_38570914',children:[]},{title:'Enhanced Aggregation, Cube, Grouping and Rollup',ref:'_30151323',children:[]},{title:'FileFormats',ref:'_47384180',children:[{title:'RCFile',ref:'_58851803',children:[]}]},{title:'Hive HPL/SQL',ref:'_59690156',children:[]}];
</%def>
