# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-30 18:38
from __future__ import unicode_literals

import desktop.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_prometheus.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('useradmin', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Connector',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=255)),
                ('description', models.TextField(default='')),
                ('dialect', models.CharField(db_index=True, help_text='Type of connector, e.g. hive, mysql... ', max_length=32)),
                ('settings', models.TextField(default='{}')),
                ('last_modified', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Time last modified')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='useradmin.Organization')),
            ],
        ),
        migrations.CreateModel(
            name='DefaultConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app', models.CharField(db_index=True, help_text='App that this configuration belongs to.', max_length=32)),
                ('properties', models.TextField(default='[]', help_text='JSON-formatted default properties values.')),
                ('is_default', models.BooleanField(db_index=True, default=False)),
                ('groups', models.ManyToManyField(db_index=True, db_table='defaultconfiguration_groups', to='useradmin.OrganizationGroup')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['app', '-is_default', 'user'],
            },
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=255)),
                ('description', models.TextField(default='')),
                ('last_modified', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Last modified')),
                ('version', models.SmallIntegerField(default=1, verbose_name='Schema version')),
                ('extra', models.TextField(default='')),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('owner', models.ForeignKey(help_text='User who can own the job.', on_delete=django.db.models.deletion.CASCADE, related_name='doc_owner', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
            ],
        ),
        migrations.CreateModel(
            name='Document2',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=255)),
                ('description', models.TextField(default='')),
                ('uuid', models.CharField(db_index=True, default=desktop.models.uuid_default, max_length=36)),
                ('type', models.CharField(db_index=True, default='', help_text='Type of document, e.g. Hive query, Oozie workflow, Search Dashboard...', max_length=32)),
                ('data', models.TextField(default='{}')),
                ('extra', models.TextField(default='')),
                ('search', models.TextField(blank=True, help_text='Searchable text for the document.', null=True)),
                ('last_modified', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Time last modified')),
                ('version', models.SmallIntegerField(db_index=True, default=1, verbose_name='Document version')),
                ('is_history', models.BooleanField(db_index=True, default=False)),
                ('is_managed', models.BooleanField(db_index=True, default=False, verbose_name='If managed under the cover by Hue and never by the user')),
                ('is_trashed', models.NullBooleanField(db_index=True, default=False, verbose_name='True if trashed')),
                ('dependencies', models.ManyToManyField(db_index=True, related_name='dependents', to='desktop.Document2')),
                ('owner', models.ForeignKey(help_text='Creator.', on_delete=django.db.models.deletion.CASCADE, related_name='doc2_owner', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
                ('parent_directory', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='desktop.Document2')),
            ],
            options={
                'ordering': ['-last_modified', 'name'],
            },
            # bases=(models.Model, django_prometheus.models.Mixin),
            bases=(models.Model, django_prometheus.models.ExportModelOperationsMixin('Document2')),
        ),
        migrations.CreateModel(
            name='Document2Permission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('perms', models.CharField(choices=[('read', 'read'), ('write', 'write'), ('comment', 'comment'), ('link_read', 'link read'), ('link_write', 'link write')], db_index=True, default='read', max_length=10)),
                ('is_link_on', models.BooleanField(default=False)),
                ('doc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='desktop.Document2')),
                ('groups', models.ManyToManyField(db_index=True, db_table='documentpermission2_groups', to='useradmin.OrganizationGroup')),
                ('users', models.ManyToManyField(db_index=True, db_table='documentpermission2_users', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DocumentPermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('perms', models.CharField(choices=[('read', 'read'), ('write', 'write')], default='read', max_length=10)),
                ('doc', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='desktop.Document')),
                ('groups', models.ManyToManyField(db_index=True, db_table='documentpermission_groups', to='useradmin.OrganizationGroup')),
                ('users', models.ManyToManyField(db_index=True, db_table='documentpermission_users', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DocumentTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tag', models.SlugField()),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('collect_usage', models.BooleanField(db_index=True, default=True)),
                ('tours_and_tutorials', models.BooleanField(db_index=True, default=True)),
            ],
        ),
        migrations.CreateModel(
            name='UserPreferences',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=20)),
                ('value', models.TextField(max_length=4096)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='document',
            name='tags',
            field=models.ManyToManyField(db_index=True, to='desktop.DocumentTag'),
        ),
        migrations.CreateModel(
            name='Directory',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('desktop.document2',),
        ),
        migrations.AlterUniqueTogether(
            name='documenttag',
            unique_together=set([('owner', 'tag')]),
        ),
        migrations.AlterUniqueTogether(
            name='documentpermission',
            unique_together=set([('doc', 'perms')]),
        ),
        migrations.AlterUniqueTogether(
            name='document2permission',
            unique_together=set([('doc', 'perms')]),
        ),
        migrations.AlterUniqueTogether(
            name='document2',
            unique_together=set([('uuid', 'version', 'is_history')]),
        ),
        migrations.AlterUniqueTogether(
            name='document',
            unique_together=set([('content_type', 'object_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='connector',
            unique_together=set([('name', 'organization')]),
        ),
    ]
